/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.io.PrintWriter;

final class Status {
    public static final int PASSED = 0;
    public static final int FAILED = 1;
    public static final int CHECK_FILE = 2;
    public static final int ERROR = 3;
    public static final int NOT_RUN = 4;
    private int type;
    private String reason;
    public static final String EXIT_PREFIX = "STATUS:";
    private static String[] texts = new String[]{"Passed.", "Failed.", "Completed--check results.", "Error.", "Not run."};
    public static final int[] exitCodes = new int[]{95, 97, 96, 98, 99};

    public static Status passed(String reason) {
        return new Status(0, reason);
    }

    public static Status failed(String reason) {
        return new Status(1, reason);
    }

    public static Status checkFile(String reason) {
        return new Status(2, reason);
    }

    public static Status error(String reason) {
        return new Status(3, reason);
    }

    public static Status notApplicable(String reason) {
        return new Status(1, "Not Applicable: " + reason);
    }

    static Status notRun(String reason) {
        return new Status(4, reason);
    }

    public boolean isPassed() {
        return this.type == 0;
    }

    public boolean isFailed() {
        return this.type == 1;
    }

    public boolean isCheckFile() {
        return this.type == 2;
    }

    public boolean isError() {
        return this.type == 3;
    }

    public int getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public Status augment(String aux) {
        if (aux == null || aux.length() == 0) {
            return this;
        }
        return new Status(this.type, this.reason + " [" + aux + "]");
    }

    public Status augment(Status aux) {
        return aux == null ? this : this.augment(aux.reason);
    }

    public static Status parse(String s) {
        for (int i = 0; i < texts.length; ++i) {
            if (!s.startsWith(texts[i])) continue;
            return new Status(i, s.substring(texts[i].length()).trim());
        }
        return null;
    }

    public String toString() {
        if (this.reason == null || this.reason.length() == 0) {
            return texts[this.type];
        }
        return texts[this.type] + " " + this.reason;
    }

    public void exit() {
        PrintWriter strm = new PrintWriter(System.err);
        strm.print(EXIT_PREFIX);
        strm.print(texts[this.type]);
        strm.println(this.reason);
        strm.flush();
        System.exit(exitCodes[this.type]);
    }

    public Status(int type, String reason) {
        this.type = type;
        this.reason = reason;
    }
}

