/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.SuperInterface;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.netbeans.apitest.ClassCollection;
import org.netbeans.apitest.ClassFinder;
import org.netbeans.apitest.DefinitionFormat;
import org.netbeans.apitest.MemberEntry;
import org.netbeans.apitest.SignatureClass;
import org.netbeans.apitest.SignatureConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TableOfClass
implements SignatureConstants {
    private static ClassCollection nestedClasses = new ClassCollection();
    String classDef;
    private ClassCollection members;
    ClassCollection memberClasses;
    private SignatureClass classObject;
    private String name;
    protected DefinitionFormat converter;
    boolean isReflectUsed = false;
    private int constructorCount = -1;

    public TableOfClass(SignatureClass c, boolean isReflectUsed) {
        this(c, null, isReflectUsed);
    }

    public TableOfClass(SignatureClass c, String enclClass, boolean isReflectUsed) {
        this.name = enclClass == null ? c.getName() : enclClass + "$" + TableOfClass.getLocalName(c);
        this.classObject = c;
        this.isReflectUsed = isReflectUsed;
        this.converter = c.filter;
        if (isReflectUsed) {
            this.memberClasses = new ClassCollection();
        }
        this.members = new ClassCollection();
        this.classDef = c.getMemberEntry(false).getEntry();
    }

    public TableOfClass(String definition, DefinitionFormat converter) {
        this.converter = converter;
        this.name = definition.substring(definition.lastIndexOf(32) + 1);
        this.members = new ClassCollection();
        this.classDef = converter.getDefinition(definition);
        this.classObject = null;
        this.isReflectUsed = false;
    }

    public static SignatureClass addNestedClass(String name, ClassFinder loader) throws ClassNotFoundException {
        SignatureClass c = loader.loadClass(name);
        if (name.indexOf(36) < 0) {
            return null;
        }
        nestedClasses.addElement(name.substring(0, name.lastIndexOf(36)), name);
        return c;
    }

    public static Vector getDeclaredNestedClasses(String name) {
        Vector h = nestedClasses.get(name);
        return h == null ? new Vector() : h;
    }

    private static ClassCollection getReflectClasses(SignatureClass c) {
        if (c == null) {
            return new ClassCollection();
        }
        ClassCollection retVal = TableOfClass.getReflectClasses(c.getSuperclass());
        SignatureClass[] interfaces = c.getInterfaces();
        for (int i = 0; interfaces != null && i < interfaces.length; ++i) {
            ClassCollection temp = TableOfClass.getReflectClasses(interfaces[i]);
            Enumeration e = temp.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Vector<Object> h = temp.get(key);
                for (int j = 0; j < h.size(); ++j) {
                    retVal.addUniqueElement(key, h.elementAt(j));
                }
            }
        }
        SignatureClass[] dec = c.getDeclaredClasses();
        for (int i = 0; dec != null && i < dec.length; ++i) {
            String key = TableOfClass.getLocalName(dec[i]);
            if (retVal.get(key) != null) {
                retVal.remove(key);
            }
            retVal.addUniqueElement(key, dec[i]);
        }
        return retVal;
    }

    private static String getLocalName(SignatureClass c) {
        String retVal = c.getName();
        int pos = Math.max(retVal.lastIndexOf("."), retVal.lastIndexOf("$"));
        return retVal.substring(pos + 1);
    }

    TableOfClass(ClassDescription descr, DefinitionFormat converter, Map<String, ClassDescription> all) {
        this.name = descr.getQualifiedName();
        this.classDef = converter.getDefinition(descr.toString());
        this.converter = converter;
        this.members = new ClassCollection();
        this.feed(descr, descr, all, true, new HashSet<MethodDescr>());
    }

    private void feed(ClassDescription main, ClassDescription descr, Map<String, ClassDescription> all, boolean addConstructors, Set<MethodDescr> alreadyPresent) {
        String def;
        String clazzTypes = this.converter.getDefinition(descr.toString());
        for (MethodDescr methodDescr : descr.getDeclaredMethods()) {
            if (!alreadyPresent.add(methodDescr)) continue;
            def = this.converter.getDefinition(methodDescr.toString());
            this.members.addElement(new MemberEntry(def, this.converter));
        }
        for (MemberDescription memberDescription : descr.getDeclaredFields()) {
            def = this.converter.getDefinition(((FieldDescr)memberDescription).toString());
            this.members.addElement(new MemberEntry(def, this.converter));
        }
        if (addConstructors) {
            this.constructorCount = 0;
            for (MemberDescription memberDescription : descr.getDeclaredConstructors()) {
                def = this.converter.getDefinition(((ConstructorDescr)memberDescription).toString());
                this.members.addElement(new MemberEntry(def, this.converter));
                ++this.constructorCount;
            }
        }
        if (descr.getSuperClass() != null) {
            this.feed(main, all.get(descr.getSuperClass().getQualifiedName()), all, false, alreadyPresent);
        }
        for (MemberDescription memberDescription : descr.getInterfaces()) {
            this.feed(main, all.get(((SuperInterface)memberDescription).getQualifiedName()), all, false, alreadyPresent);
        }
    }

    public String getName() {
        return this.name;
    }

    public void createMembers(Enumeration definitions) {
        String currentDef = null;
        while (definitions.hasMoreElements()) {
            currentDef = (String)definitions.nextElement();
            String temp = this.converter.getDefinition(currentDef);
            MemberEntry tempEntry = new MemberEntry(temp, this.converter);
            MemberEntry entry = new MemberEntry(currentDef, this.converter);
            if (!tempEntry.isPublic() && !tempEntry.isProtected() && !temp.startsWith("supr ") && !temp.startsWith("intf ")) continue;
            this.members.addElement(entry);
        }
    }

    public Vector getNestedClassDefinitions(String name) {
        Vector<String> retVal = new Vector<String>();
        Vector h = this.getNestedClass(name);
        if (h == null) {
            return new Vector();
        }
        for (int i = 0; i < h.size(); ++i) {
            SignatureClass c = (SignatureClass)h.elementAt(i);
            retVal.addElement(c.getMemberEntry(true).getEntry());
        }
        return retVal;
    }

    public Vector getNestedClass(String name) {
        if (this.isReflectUsed) {
            return this.memberClasses.get("innr " + name);
        }
        return this.getNestedClass(this.classObject, name);
    }

    public String getClassName() {
        if (this.classObject == null) {
            return null;
        }
        return this.classObject.getName();
    }

    public SignatureClass getClassObject() {
        return this.classObject;
    }

    public Vector get(String key) {
        return this.members.get(key);
    }

    public Enumeration keys() {
        return this.members.keys();
    }

    private Vector getNestedClass(SignatureClass cl, String name) {
        Vector<SignatureClass> h;
        if (cl == null) {
            return new Vector();
        }
        Vector classes = this.getNestedClass(cl.getSuperclass(), name);
        SignatureClass[] intf = cl.getInterfaces();
        for (int i = 0; i < intf.length; ++i) {
            h = this.getNestedClass(intf[i], name);
            for (int j = 0; j < h.size(); ++j) {
                Object ob = h.elementAt(j);
                if (classes.indexOf(ob) >= 0) continue;
                classes.addElement(h.elementAt(j));
            }
        }
        try {
            SignatureClass c = this.classObject.loadClass(cl.getName() + "$" + name);
            h = new Vector<SignatureClass>();
            h.addElement(c);
            return h;
        }
        catch (ClassNotFoundException e) {
            return classes;
        }
        catch (LinkageError er) {
            return classes;
        }
    }

    public void createMembers() throws ClassNotFoundException {
        this.members = new ClassCollection();
        if (this.classObject == null) {
            return;
        }
        ClassCollection innrCl = new ClassCollection();
        SignatureClass spr = this.classObject.getSuperclass();
        this.members.addElement("supr ", "supr " + (spr == null ? null : spr.getName()));
        SignatureClass[] intfs = this.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            this.members.addElement("intf ", "intf " + intfs[i].getName());
        }
        this.getMethods();
        this.getFields();
        MemberEntry[] constr = this.classObject.getDeclaredConstructors();
        assert (this.constructorCount == -1);
        this.constructorCount = 0;
        for (int i = 0; i < constr.length; ++i) {
            if (!constr[i].isPublic() && !constr[i].isProtected()) continue;
            this.members.addElement(constr[i]);
            ++this.constructorCount;
        }
        if (this.isReflectUsed) {
            innrCl = TableOfClass.getReflectClasses(this.classObject);
        } else {
            this.getClasses(this.classObject, innrCl);
        }
        Enumeration e = innrCl.keys();
        while (e.hasMoreElements()) {
            String nameClass = (String)e.nextElement();
            Vector<Object> h = innrCl.get(nameClass);
            for (int i = 0; i < h.size(); ++i) {
                SignatureClass cl = null;
                cl = (SignatureClass)h.elementAt(i);
                if (!Modifier.isPublic(cl.getModifiers()) && !Modifier.isProtected(cl.getModifiers())) continue;
                MemberEntry entry = cl.getMemberEntry(true);
                this.members.addElement(entry);
                if (!this.isReflectUsed) continue;
                this.memberClasses.addElement(entry.getKey(), cl);
            }
        }
    }

    public void writeDefinitions(PrintWriter out) {
        int i;
        out.println(this.classDef);
        Vector<String> temp = new Vector<String>();
        Enumeration e = this.members.keys();
        while (e.hasMoreElements()) {
            Vector<Object> h = this.members.get((String)e.nextElement());
            for (i = 0; i < h.size(); ++i) {
                String t = (String)h.elementAt(i);
                temp.addElement(t);
            }
        }
        while (!temp.isEmpty()) {
            String line = (String)temp.elementAt(0);
            int pos = 0;
            for (i = 0; i < temp.size(); ++i) {
                if (line.compareTo((String)temp.elementAt(i)) <= 0) continue;
                line = (String)temp.elementAt(i);
                pos = i;
            }
            out.println(line);
            temp.removeElementAt(pos);
        }
    }

    public boolean isPublic() {
        return this.classDef.indexOf(" public ") >= 0;
    }

    public boolean isProtected() {
        return this.classDef.indexOf(" protected ") >= 0;
    }

    public boolean isInterface() {
        return this.classDef.indexOf(" interface ") >= 0;
    }

    public boolean isFinal() {
        if (this.isInterface()) {
            return false;
        }
        if (this.constructorCount == -1) {
            this.constructorCount = 0;
            for (String o : this.members.keySet()) {
                if (!o.toString().startsWith("cons ")) continue;
                ++this.constructorCount;
            }
        }
        return this.classDef.indexOf(" final ") >= 0 || this.constructorCount == 0;
    }

    private void getClasses(SignatureClass c, ClassCollection innrHash) throws ClassNotFoundException {
        String name;
        if (c == null) {
            return;
        }
        this.getClasses(c.getSuperclass(), innrHash);
        ClassCollection clFromIntf = new ClassCollection();
        SignatureClass[] intf = c.getInterfaces();
        for (int j = 0; j < intf.length; ++j) {
            this.getClasses(intf[j], clFromIntf);
            Enumeration e = clFromIntf.keys();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                Vector<Object> h = clFromIntf.get(name);
                for (int i = 0; i < h.size(); ++i) {
                    innrHash.addUniqueElement(name, h.elementAt(i));
                }
            }
            clFromIntf.clear();
        }
        Vector<Object> decClass = nestedClasses.get(c.getName());
        if (decClass == null) {
            return;
        }
        for (int i = 0; i < decClass.size(); ++i) {
            name = (String)decClass.elementAt(i);
            name = "innr " + name.substring(name.lastIndexOf(36) + 1);
            innrHash.put(name, this.classObject.loadClass((String)decClass.elementAt(i)));
        }
    }

    private void getMethods() {
        boolean hasNested = false;
        for (SignatureClass t = this.classObject; t != null; t = t.getSuperclass()) {
            if ((this.isReflectUsed || nestedClasses.get(t.getName()) == null) && (!this.isReflectUsed || t.getDeclaredClasses().length <= 0)) continue;
            hasNested = true;
        }
        ClassCollection methods = this.getMethods(this.classObject);
        Enumeration e = methods.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Vector<Object> h = methods.get(name);
            for (int i = 0; i < h.size(); ++i) {
                MemberEntry meth = (MemberEntry)h.elementAt(i);
                if (!meth.isPublic() && !meth.isProtected() || meth.isSynthetic()) continue;
                this.members.addElement(meth);
            }
        }
    }

    private ClassCollection getMethods(SignatureClass c) {
        if (c == null) {
            return new ClassCollection();
        }
        ClassCollection methods = this.getMethods(c.getSuperclass());
        SignatureClass[] intf = c.getInterfaces();
        for (int j = 0; j < intf.length; ++j) {
            ClassCollection methI = this.getMethods(intf[j]);
            Enumeration e = methI.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Vector<Object> h = methI.get(key);
                Vector<Object> meth = methods.get(key);
                if (meth != null && (meth.size() != 1 || !((MemberEntry)meth.elementAt(0)).isAbstract())) continue;
                Enumeration<Object> e1 = h.elements();
                while (e1.hasMoreElements()) {
                    methods.addUniqueElement(key, e1.nextElement());
                }
            }
        }
        MemberEntry[] meth = c.getDeclaredMethods();
        block3: for (int i = 0; i < meth.length; ++i) {
            String name = meth[i].getKey();
            Vector<Object> prevVector = methods.get(name);
            if (prevVector == null) {
                methods.put(name, meth[i]);
                continue;
            }
            for (Object prev : prevVector) {
                MemberEntry pm = (MemberEntry)prev;
                if (pm.getDeclaringClass().equals(meth[i].getDeclaringClass())) continue;
                methods.put(name, meth[i]);
                continue block3;
            }
            methods.addElement(name, meth[i]);
        }
        return methods;
    }

    private void getFields() {
        ClassCollection fields = this.getFields(this.classObject);
        Enumeration e = fields.keys();
        while (e.hasMoreElements()) {
            String nm = (String)e.nextElement();
            Vector<Object> h = fields.get(nm);
            for (int i = 0; i < h.size(); ++i) {
                MemberEntry field = (MemberEntry)h.elementAt(i);
                if (!field.isPublic() && !field.isProtected()) continue;
                this.members.addElement(field);
            }
        }
    }

    private ClassCollection getFields(SignatureClass c) {
        if (c == null) {
            return new ClassCollection();
        }
        ClassCollection retVal = this.getFields(c.getSuperclass());
        SignatureClass[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            ClassCollection fieldI = this.getFields(interfaces[i]);
            Enumeration fields = fieldI.keys();
            while (fields.hasMoreElements()) {
                String name = (String)fields.nextElement();
                Vector<Object> h = fieldI.get(name);
                Enumeration<Object> e = h.elements();
                while (e.hasMoreElements()) {
                    retVal.addUniqueElement(name, e.nextElement());
                }
            }
        }
        MemberEntry[] declaredFields = c.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!declaredFields[i].isPublic() && !declaredFields[i].isProtected()) continue;
            retVal.put(declaredFields[i].getKey(), declaredFields[i]);
        }
        return retVal;
    }

    public SignatureClass[] getInterfaces() {
        Vector interfaces = new Vector();
        this.getInterfaces(this.classObject, interfaces);
        SignatureClass[] retVal = new SignatureClass[interfaces.size()];
        for (int i = 0; i < interfaces.size(); ++i) {
            retVal[i] = (SignatureClass)interfaces.elementAt(i);
        }
        return retVal;
    }

    private void getInterfaces(SignatureClass c, Vector h) {
        if (c == null) {
            return;
        }
        this.getInterfaces(c.getSuperclass(), h);
        SignatureClass[] intf = c.getInterfaces();
        if (c == null) {
            return;
        }
        for (int i = 0; i < intf.length; ++i) {
            if (h.contains(intf[i])) continue;
            h.addElement(intf[i]);
            this.getInterfaces(intf[i], h);
        }
    }
}

