/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package service;

import javax.ws.rs.Path;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.DELETE;
import javax.ws.rs.Produces;
import javax.ws.rs.Consumes;
import javax.ws.rs.QueryParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import com.sun.jersey.api.core.ResourceContext;
import javax.ws.rs.WebApplicationException;
import javax.persistence.NoResultException;
import javax.persistence.EntityManager;
import x.Customer;
import x.DiscountCode;
import converter.CustomerConverter;

/**
 *
 * @author ayubkhan
 */

public class CustomerResource {
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ResourceContext resourceContext;
    protected Integer id;
  
    /** Creates a new instance of CustomerResource */
    public CustomerResource() {
    }

    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * Get method for retrieving an instance of Customer identified by id in XML format.
     *
     * @param id identifier for the entity
     * @return an instance of CustomerConverter
     */
    @GET
    @Produces({"application/xml", "application/json"})
    public CustomerConverter get(@QueryParam("expandLevel")
    @DefaultValue("1")
    int expandLevel) {
        try {
            return new CustomerConverter(getEntity(), uriInfo.getAbsolutePath(), expandLevel);
        } finally {
            PersistenceService.getInstance().close();
        }
    }

    /**
     * Put method for updating an instance of Customer identified by id using XML as the input format.
     *
     * @param id identifier for the entity
     * @param data an CustomerConverter entity that is deserialized from a XML stream
     */
    @PUT
    @Consumes({"application/xml", "application/json"})
    public void put(CustomerConverter data) {
        PersistenceService persistenceSvc = PersistenceService.getInstance();
        try {
            persistenceSvc.beginTx();
            EntityManager em = persistenceSvc.getEntityManager();
            updateEntity(getEntity(), data.resolveEntity(em));
            persistenceSvc.commitTx();
        } finally {
            persistenceSvc.close();
        }
    }

    /**
     * Delete method for deleting an instance of Customer identified by id.
     *
     * @param id identifier for the entity
     */
    @DELETE
    public void delete() {
        PersistenceService persistenceSvc = PersistenceService.getInstance();
        try {
            persistenceSvc.beginTx();
            deleteEntity(getEntity());
            persistenceSvc.commitTx();
        } finally {
            persistenceSvc.close();
        }
    }

    /**
     * Returns an instance of Customer identified by id.
     *
     * @param id identifier for the entity
     * @return an instance of Customer
     */
    protected Customer getEntity() {
        EntityManager em = PersistenceService.getInstance().getEntityManager();
        try {
            return (Customer) em.createQuery("SELECT e FROM Customer e where e.customerId = :customerId").setParameter("customerId", id).getSingleResult();
        } catch (NoResultException ex) {
            throw new WebApplicationException(new Throwable("Resource for " + uriInfo.getAbsolutePath() + " does not exist."), 404);
        }
    }

    /**
     * Updates entity using data from newEntity.
     *
     * @param entity the entity to update
     * @param newEntity the entity containing the new data
     * @return the updated entity
     */
    protected Customer updateEntity(Customer entity, Customer newEntity) {
        EntityManager em = PersistenceService.getInstance().getEntityManager();
        DiscountCode discountCode = entity.getDiscountCode();
        DiscountCode discountCodeNew = newEntity.getDiscountCode();
        DiscountCode discountCode1 = entity.getDiscountCode1();
        DiscountCode discountCode1New = newEntity.getDiscountCode1();
        entity = em.merge(newEntity);
        if (discountCode != null && !discountCode.equals(discountCodeNew)) {
            discountCode.getCustomerCollection().remove(entity);
        }
        if (discountCodeNew != null && !discountCodeNew.equals(discountCode)) {
            discountCodeNew.getCustomerCollection().add(entity);
        }
        if (discountCode1 != null && !discountCode1.equals(discountCode1New)) {
            discountCode1.getCustomerCollection().remove(entity);
        }
        if (discountCode1New != null && !discountCode1New.equals(discountCode1)) {
            discountCode1New.getCustomerCollection().add(entity);
        }
        return entity;
    }

    /**
     * Deletes the entity.
     *
     * @param entity the entity to deletle
     */
    protected void deleteEntity(Customer entity) {
        EntityManager em = PersistenceService.getInstance().getEntityManager();
        DiscountCode discountCode = entity.getDiscountCode();
        if (discountCode != null) {
            discountCode.getCustomerCollection().remove(entity);
        }
        DiscountCode discountCode1 = entity.getDiscountCode1();
        if (discountCode1 != null) {
            discountCode1.getCustomerCollection().remove(entity);
        }
        em.remove(entity);
    }

    /**
     * Returns a dynamic instance of DiscountCodeResource used for entity navigation.
     *
     * @param id identifier for the parent entity
     * @return an instance of DiscountCodeResource
     */
    @Path("discountCode/")
    public DiscountCodeResource getDiscountCodeResource() {
        DiscountCodeResourceSub resource = resourceContext.getResource(DiscountCodeResourceSub.class);
        resource.setParent(getEntity());
        return resource;
    }

    /**
     * Returns a dynamic instance of DiscountCodeResource used for entity navigation.
     *
     * @param id identifier for the parent entity
     * @return an instance of DiscountCodeResource
     */
    @Path("discountCode1/")
    public DiscountCodeResource getDiscountCode1Resource() {
        DiscountCode1ResourceSub resource = resourceContext.getResource(DiscountCode1ResourceSub.class);
        resource.setParent(getEntity());
        return resource;
    }

    public static class DiscountCodeResourceSub extends DiscountCodeResource {

        private Customer parent;

        public void setParent(Customer parent) {
            this.parent = parent;
        }

        @Override
        protected DiscountCode getEntity() {
            DiscountCode entity = parent.getDiscountCode();
            if (entity == null) {
                throw new WebApplicationException(new Throwable("Resource for " + uriInfo.getAbsolutePath() + " does not exist."), 404);
            }
            return entity;
        }
    }

    public static class DiscountCode1ResourceSub extends DiscountCodeResource {

        private Customer parent;

        public void setParent(Customer parent) {
            this.parent = parent;
        }

        @Override
        protected DiscountCode getEntity() {
            DiscountCode entity = parent.getDiscountCode1();
            if (entity == null) {
                throw new WebApplicationException(new Throwable("Resource for " + uriInfo.getAbsolutePath() + " does not exist."), 404);
            }
            return entity;
        }
    }
}
