/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package service;

import javax.ws.rs.Path;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.DELETE;
import javax.ws.rs.Produces;
import javax.ws.rs.Consumes;
import javax.ws.rs.QueryParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import com.sun.jersey.api.core.ResourceContext;
import javax.ws.rs.WebApplicationException;
import javax.persistence.NoResultException;
import javax.persistence.EntityManager;
import java.util.Collection;
import x.Customer;
import converter.DiscountCodeConverter;
import x.DiscountCode;

/**
 *
 * @author ayubkhan
 */

public class DiscountCodeResource {
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ResourceContext resourceContext;
    protected String id;
  
    /** Creates a new instance of DiscountCodeResource */
    public DiscountCodeResource() {
    }

    public void setId(String id) {
        this.id = id;
    }

    /**
     * Get method for retrieving an instance of DiscountCode identified by id in XML format.
     *
     * @param id identifier for the entity
     * @return an instance of DiscountCodeConverter
     */
    @GET
    @Produces({"application/xml", "application/json"})
    public DiscountCodeConverter get(@QueryParam("expandLevel")
    @DefaultValue("1")
    int expandLevel) {
        try {
            return new DiscountCodeConverter(getEntity(), uriInfo.getAbsolutePath(), expandLevel);
        } finally {
            PersistenceService.getInstance().close();
        }
    }

    /**
     * Put method for updating an instance of DiscountCode identified by id using XML as the input format.
     *
     * @param id identifier for the entity
     * @param data an DiscountCodeConverter entity that is deserialized from a XML stream
     */
    @PUT
    @Consumes({"application/xml", "application/json"})
    public void put(DiscountCodeConverter data) {
        PersistenceService persistenceSvc = PersistenceService.getInstance();
        try {
            persistenceSvc.beginTx();
            EntityManager em = persistenceSvc.getEntityManager();
            updateEntity(getEntity(), data.resolveEntity(em));
            persistenceSvc.commitTx();
        } finally {
            persistenceSvc.close();
        }
    }

    /**
     * Delete method for deleting an instance of DiscountCode identified by id.
     *
     * @param id identifier for the entity
     */
    @DELETE
    public void delete() {
        PersistenceService persistenceSvc = PersistenceService.getInstance();
        try {
            persistenceSvc.beginTx();
            deleteEntity(getEntity());
            persistenceSvc.commitTx();
        } finally {
            persistenceSvc.close();
        }
    }

    /**
     * Returns an instance of DiscountCode identified by id.
     *
     * @param id identifier for the entity
     * @return an instance of DiscountCode
     */
    protected DiscountCode getEntity() {
        EntityManager em = PersistenceService.getInstance().getEntityManager();
        try {
            return (DiscountCode) em.createQuery("SELECT e FROM DiscountCode e where e.discountCode = :discountCode").setParameter("discountCode", id.charAt(0)).getSingleResult();
        } catch (NoResultException ex) {
            throw new WebApplicationException(new Throwable("Resource for " + uriInfo.getAbsolutePath() + " does not exist."), 404);
        }
    }

    /**
     * Updates entity using data from newEntity.
     *
     * @param entity the entity to update
     * @param newEntity the entity containing the new data
     * @return the updated entity
     */
    protected DiscountCode updateEntity(DiscountCode entity, DiscountCode newEntity) {
        EntityManager em = PersistenceService.getInstance().getEntityManager();
        Collection<Customer> customerCollection = entity.getCustomerCollection();
        Collection<Customer> customerCollectionNew = newEntity.getCustomerCollection();
        Collection<Customer> customerCollection1 = entity.getCustomerCollection1();
        Collection<Customer> customerCollection1New = newEntity.getCustomerCollection1();
        entity = em.merge(newEntity);
        for (Customer value : customerCollection) {
            if (!customerCollectionNew.contains(value)) {
                throw new WebApplicationException(new Throwable("Cannot remove items from customerCollection"));
            }
        }
        for (Customer value : customerCollectionNew) {
            if (!customerCollection.contains(value)) {
                DiscountCode oldEntity = value.getDiscountCode();
                value.setDiscountCode(entity);
                if (oldEntity != null && !oldEntity.equals(entity)) {
                    oldEntity.getCustomerCollection().remove(value);
                }
            }
        }
        for (Customer value : customerCollection1) {
            if (!customerCollection1New.contains(value)) {
                throw new WebApplicationException(new Throwable("Cannot remove items from customerCollection1"));
            }
        }
        for (Customer value : customerCollection1New) {
            if (!customerCollection1.contains(value)) {
                DiscountCode oldEntity = value.getDiscountCode();
                value.setDiscountCode(entity);
                if (oldEntity != null && !oldEntity.equals(entity)) {
                    oldEntity.getCustomerCollection1().remove(value);
                }
            }
        }
        return entity;
    }

    /**
     * Deletes the entity.
     *
     * @param entity the entity to deletle
     */
    protected void deleteEntity(DiscountCode entity) {
        EntityManager em = PersistenceService.getInstance().getEntityManager();
        if (!entity.getCustomerCollection().isEmpty()) {
            throw new WebApplicationException(new Throwable("Cannot delete entity because customerCollection is not empty."));
        }
        if (!entity.getCustomerCollection1().isEmpty()) {
            throw new WebApplicationException(new Throwable("Cannot delete entity because customerCollection1 is not empty."));
        }
        em.remove(entity);
    }

    /**
     * Returns a dynamic instance of CustomersResource used for entity navigation.
     *
     * @param id identifier for the parent entity
     * @return an instance of CustomersResource
     */
    @Path("customerCollection/")
    public CustomersResource getCustomerCollectionResource() {
        CustomerCollectionResourceSub resource = resourceContext.getResource(CustomerCollectionResourceSub.class);
        resource.setParent(getEntity());
        return resource;
    }

    /**
     * Returns a dynamic instance of CustomersResource used for entity navigation.
     *
     * @param id identifier for the parent entity
     * @return an instance of CustomersResource
     */
    @Path("customerCollection1/")
    public CustomersResource getCustomerCollection1Resource() {
        CustomerCollection1ResourceSub resource = resourceContext.getResource(CustomerCollection1ResourceSub.class);
        resource.setParent(getEntity());
        return resource;
    }

    public static class CustomerCollectionResourceSub extends CustomersResource {

        private DiscountCode parent;

        public void setParent(DiscountCode parent) {
            this.parent = parent;
        }

        @Override
        protected Collection<Customer> getEntities(int start, int max, String query) {
            Collection<Customer> result = new java.util.ArrayList<Customer>();
            int index = 0;
            for (Customer e : parent.getCustomerCollection()) {
                if (index >= start && (index - start) < max) {
                    result.add(e);
                }
                index++;
            }
            return result;
        }
    }

    public static class CustomerCollection1ResourceSub extends CustomersResource {

        private DiscountCode parent;

        public void setParent(DiscountCode parent) {
            this.parent = parent;
        }

        @Override
        protected Collection<Customer> getEntities(int start, int max, String query) {
            Collection<Customer> result = new java.util.ArrayList<Customer>();
            int index = 0;
            for (Customer e : parent.getCustomerCollection1()) {
                if (index >= start && (index - start) < max) {
                    result.add(e);
                }
                index++;
            }
            return result;
        }
    }
}
