/*
 * CurrenciesSelector.java
 *
 * Copyright (c) 2004 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package converter;

import javax.microedition.lcdui.*;

/**
 *
 */
public class CurrenciesSelector extends List implements CommandListener {
    
    private ConverterMIDlet midlet;
    
    /**
     * constructor
     */
    public CurrenciesSelector(ConverterMIDlet midlet) {
        super("Select Currencies", List.MULTIPLE, midlet.currencies, null);
        this.midlet = midlet;
        setSelectedFlags(midlet.selected);
        try {
            // Set up this list to listen to command events
            setCommandListener(this);
            // Add the Save command
            addCommand(new Command("Save", Command.OK, 1));
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    /**
     * Called when action should be handled
     */
    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == Command.OK) {
            getSelectedFlags(midlet.selected);
            midlet.notifySettingsChanged();
        }
    }
    
}
