/*
* Support js for Customer
*/

function Customer(uri_) {
    this.Customer(uri_, false);
}

function Customer(uri_, initialized_) {
    this.uri = uri_;
    this.customerId = '';

    this.initialized = initialized_;
}

Customer.prototype = {

   getUri : function() {
      return this.uri;
   },

   getCustomerId : function() {
      if(!this.initialized)
         this.init();
      return this.customerId;
   },

   setCustomerId : function(customerId_) {
      this.customerId = customerId_;
   },



   init : function() {
      var remote = new CustomerRemote(this.uri);
      var c = remote.getJson_();
      if(c != -1) {
         var myObj = eval('(' +c+')');
         var customer = myObj.customer;
         this.uri = customer['@uri'];
         this.customerId = this.findValue(this.customerId, customer['customerId']);

         this.initialized = true;
      }
   },

   findValue : function(field, value) {
      if(value == undefined)
          return field;
      else
         return value;
   },

   flush : function() {
      var remote = new CustomerRemote(this.uri);
      return remote.putJson_('{'+this.toString()+'}');
   },

   delete_ : function() {
      var remote = new CustomerRemote(this.uri);
      return remote.deleteJson_();
   },

   toString : function() {
      if(!this.initialized)
         this.init();
      var myObj = 
         '"customer":'+
         '{'+
         '"@uri":"'+this.uri+'"'+
                  ', "customerId":"'+this.customerId+'"'+

         '}';
      return myObj;
   },

   getFields : function() {
      var fields = [];
         fields.push('customerId');

      return fields;
   }

}

function CustomerRemote(uri_) {
    this.uri = uri_+'?expandLevel=1';
}

CustomerRemote.prototype = {

/* Default getJson_() method used by init() method. Do not remove. */
   getJson_ : function() {
      return rjsSupport.get(this.uri, 'application/json');
   },
/* Default putJson_() method used by flush() method. Do not remove. */
   putJson_ : function(content) {
      return rjsSupport.put(this.uri, 'application/json', content);
   },
/* Default deleteJson_() method used by delete_() method. Do not remove. */
   deleteJson_ : function() {
      return rjsSupport.delete_(this.uri);
   }
   ,
   getXml : function() {
      return rjsSupport.get(this.uri, 'application/xml');
   },

   getJson : function() {
      return rjsSupport.get(this.uri, 'application/json');
   },

   putXml : function(content) {
      return rjsSupport.put(this.uri, 'application/xml', content);
   },

   putJson : function(content) {
      return rjsSupport.put(this.uri, 'application/json', content);
   },

   delete_ : function() {
      return rjsSupport.delete_(this.uri);
   }
}
