/*
* Support js for DiscountCode
*/

function DiscountCode(uri_) {
    this.DiscountCode(uri_, false);
}

function DiscountCode(uri_, initialized_) {
    this.uri = uri_;
    this.discountCode = '';

    this.initialized = initialized_;
}

DiscountCode.prototype = {

   getUri : function() {
      return this.uri;
   },

   getDiscountCode : function() {
      if(!this.initialized)
         this.init();
      return this.discountCode;
   },

   setDiscountCode : function(discountCode_) {
      this.discountCode = discountCode_;
   },



   init : function() {
      var remote = new DiscountCodeRemote(this.uri);
      var c = remote.getJson_();
      if(c != -1) {
         var myObj = eval('(' +c+')');
         var discountCode = myObj.discountCode;
         this.uri = discountCode['@uri'];
         this.discountCode = this.findValue(this.discountCode, discountCode['discountCode']);

         this.initialized = true;
      }
   },

   findValue : function(field, value) {
      if(value == undefined)
          return field;
      else
         return value;
   },

   flush : function() {
      var remote = new DiscountCodeRemote(this.uri);
      return remote.putJson_('{'+this.toString()+'}');
   },

   delete_ : function() {
      var remote = new DiscountCodeRemote(this.uri);
      return remote.deleteJson_();
   },

   toString : function() {
      if(!this.initialized)
         this.init();
      var myObj = 
         '"discountCode":'+
         '{'+
         '"@uri":"'+this.uri+'"'+
                  ', "discountCode":"'+this.discountCode+'"'+

         '}';
      return myObj;
   },

   getFields : function() {
      var fields = [];
         fields.push('discountCode');

      return fields;
   }

}

function DiscountCodeRemote(uri_) {
    this.uri = uri_+'?expandLevel=1';
}

DiscountCodeRemote.prototype = {

/* Default getJson_() method used by init() method. Do not remove. */
   getJson_ : function() {
      return rjsSupport.get(this.uri, 'application/json');
   },
/* Default putJson_() method used by flush() method. Do not remove. */
   putJson_ : function(content) {
      return rjsSupport.put(this.uri, 'application/json', content);
   },
/* Default deleteJson_() method used by delete_() method. Do not remove. */
   deleteJson_ : function() {
      return rjsSupport.delete_(this.uri);
   }

}
