/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.bpel.debugger.ui.source;

import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.xml.namespace.QName;

/** 
 * 
 * @author Kirill Sorokin
 */
public class SeveralSourceFilesWarning extends JPanel {

    public SeveralSourceFilesWarning (
            final QName processQName, 
            final String[] sourcePaths) {
        
        initComponents();
        
        // add MainClassChooser
        jList1.setModel(new SourceFilesListModel(sourcePaths));
        jList1.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        jList1.setCellRenderer(new SourceFilesRenderer());
        jList1.setSelectedIndex(0);
        tfTargetNamespace.setText(processQName.getNamespaceURI());
        tfProcessName.setText(processQName.getLocalPart());
    }

    /** Returns the selected server instance Id or null if no instance was selected.
     *
     * @return server instance ID or null if no instance is selected
     */
    public String getSelectedInstance () {
        if (jList1.getSelectedIndex () == -1) {
            return null;
        } else {
            return (String)jList1.getSelectedValue ();
        }
    }
    
    @Override
    public boolean isValid() {
        return jList1.getSelectedIndex() > -1;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        tfTargetNamespace = new javax.swing.JTextField();
        tfProcessName = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/bpel/debugger/ui/source/Bundle"); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, bundle.getString("LBL_MORE_THAN_ONE_SOURCE_SELECTED")); // NOI18N

        jLabel2.setLabelFor(jList1);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(SeveralSourceFilesWarning.class, "LBL_PLEASE_SELECT_SOURCE")); // NOI18N

        jScrollPane2.setMinimumSize(new java.awt.Dimension(100, 200));

        jList1.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jScrollPane2.setViewportView(jList1);
        jList1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(SeveralSourceFilesWarning.class).getString("ACS_NoSelectedServerWarning_jLabel2_A11YDesc")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, bundle.getString("LBL_TARGET_NAMESPACE")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, bundle.getString("LBL_PROCESS_NAME")); // NOI18N

        tfTargetNamespace.setBackground(java.awt.SystemColor.control);
        tfTargetNamespace.setEditable(false);
        tfTargetNamespace.setFont(new java.awt.Font("Tahoma", 1, 11));
        tfTargetNamespace.setText("http://www.sun.com/samples/SynchronousSampleApplication_1");
        tfTargetNamespace.setBorder(null);
        tfTargetNamespace.setFocusable(false);

        tfProcessName.setBackground(java.awt.SystemColor.control);
        tfProcessName.setEditable(false);
        tfProcessName.setFont(new java.awt.Font("Tahoma", 1, 11));
        tfProcessName.setText("jTextField1");
        tfProcessName.setBorder(null);
        tfProcessName.setFocusable(false);

        jLabel5.setFont(new java.awt.Font("Tahoma", 2, 11));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel5, bundle.getString("LBL_NOTE")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 605, Short.MAX_VALUE)
                    .add(jLabel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 605, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(jLabel4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(jLabel3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(tfProcessName, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 415, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, tfTargetNamespace, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 415, Short.MAX_VALUE)))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 605, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jLabel5, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 605, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 14, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(tfTargetNamespace, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel4)
                    .add(tfProcessName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 23, Short.MAX_VALUE)
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 189, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel5)
                .add(20, 20, 20))
        );

        jLabel1.getAccessibleContext().setAccessibleName("");
    }// </editor-fold>//GEN-END:initComponents
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JList jList1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTextField tfProcessName;
    private javax.swing.JTextField tfTargetNamespace;
    // End of variables declaration//GEN-END:variables
        
    private static final long serialVersionUID = 1L;
    
    private static final class SourceFilesListModel 
            extends AbstractListModel {
            
        private String mySourcePaths[];
        
        public SourceFilesListModel (String[] sourcePaths) {
            mySourcePaths = sourcePaths;
            
            Arrays.sort(mySourcePaths, new Comparator<String>() {
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
;
        }
        
        public synchronized int getSize() {
            return mySourcePaths.length;
        }
        
        public synchronized Object getElementAt (int index) {
            if ((index >= 0) && (index < mySourcePaths.length)) {
                return mySourcePaths[index];
            }
            else {
                return null;
            }
        }
        
        private static final long serialVersionUID = 1L;
    }

    private static final class SourceFilesRenderer 
            extends JLabel 
            implements ListCellRenderer {
        
        public SourceFilesRenderer () {
            setOpaque (true);
        }

        public Component getListCellRendererComponent(
                final JList list, 
                final Object value, 
                final int index, 
                final boolean isSelected, 
                final boolean hasFocus) {
            
            if (value instanceof String) {
                setText((String) value);
                //setIcon(ProjectUtils.getInformation(prj).getIcon());
            } else {
                setText (value.toString ());
                setIcon (null);
            }
            
            if (isSelected) {
                setBackground(list.getSelectionBackground());
                setForeground(list.getSelectionForeground());
                //setBorder (BorderFactory.createLineBorder(Color.BLACK));
            } else {
                setBackground(list.getBackground());
                setForeground(list.getForeground());
                //setBorder(null);
            }
            
            return this;
        }
        
        private static final long serialVersionUID = 1L;
    }
    
    
}
