/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.bpel.project;

import java.io.File;

import java.net.URI;
import org.netbeans.modules.xml.retriever.XMLCatalogProvider;

/**
 * Basic Java class representing the XML Catalog Provider. This class is 
 * used by both in Populate Catalog Wizard and in Ant task for project building.
 * The reason for creation of this class is to eliminate the netbeans 
 * dependency XMLCatalogProvider has on Project API( FileObject)
 * 
 * @author Sreenivasan Genipudi
 * @author Kirill Sorokin
 */
public class CommandlineBpelProjectXmlCatalogProvider {

    private static CommandlineBpelProjectXmlCatalogProvider mInstance = null;
    
    private String mSourceDir = null;
    private String mRetrieverPath = null;
    private String mRetrieverCatalogPath = null;
    
    private URI mProjectCatalogUri = null;
    private URI mRetrieverCatalogUri = null;
   
    private CommandlineBpelProjectXmlCatalogProvider() {
        // Does nothing
    }
    
    /**
     * Singleton
     * @return The current instance
     */
    public static CommandlineBpelProjectXmlCatalogProvider getInstance() {
        if (mInstance == null) {
            mInstance = new CommandlineBpelProjectXmlCatalogProvider();
        }
        
        return mInstance;
    }
    
    /**
     * Set the source directory
     * 
     * @param sourceDir Source directory
     */
    public void setSourceDirectory(String sourceDir) {
        mSourceDir = sourceDir;
        
        final String projectDir = mSourceDir + File.separator + ".." + File.separator;
        final String retrieverCatalogDir = projectDir + XMLCatalogProvider.TYPE_RETRIEVED;
        
        mRetrieverCatalogPath = (retrieverCatalogDir + File.separator + "catalog.xml").replace('\\','/');;
        mRetrieverPath = (retrieverCatalogDir + File.separator + "src").replace('\\','/');
        
        mProjectCatalogUri = new File((projectDir + File.separator + "catalog.xml").replace('\\','/')).toURI();
        mRetrieverCatalogUri = new File(mRetrieverCatalogPath).toURI();
    }
    
    /**
     * Get the Retriever download location
     * @return Get the Retriever download location
     */
    public String getRetrieverPath() {
        return mRetrieverPath;
    }

    /**
     * Get the catalog.xml generated by retriever.
     * 
     * @return URI of retriever-generated catalog.
     */
    public URI getRetrieverCatalogUri(){
        return mRetrieverCatalogUri;
    }   
    
    /**
     * Get the project catalog.xml.
     * 
     * @return URI of the project catalog.
     */
    public URI getProjectCatalogUri() {
        return mProjectCatalogUri;
    }        
}
