/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.cnd.api.model.util;

import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmClassifierBasedTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionPointerType;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInitializerListContainer;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameterType;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.CsmValidable;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;


/**
 * Utulity functions to prevent using of "instanceof" on CsmObjects for 
 * determining type/kind of Csm element
 *
 * @author Vladimir Kvashin
 * @author Vladimir Voskresensky
 */
public class CsmKindUtilities {

    public static boolean isInstantiation(CsmObject obj) {
        return obj instanceof CsmInstantiation;
    }

    private CsmKindUtilities() {
        
    }

    public static boolean isProject(Object obj) {
        return obj instanceof CsmProject;
    }
    
    public static boolean isCsmObject(Object obj) {
        if (obj instanceof CsmObject) {
            return true;
        } else {
            return false;
        }
    }

    public static boolean isValidable(CsmObject obj) {
        if (obj instanceof CsmValidable) {
            return true;
        } else {
            return false;
        }
    }
    
    public static boolean isQualified(CsmObject obj) {
        if (obj instanceof CsmQualifiedNamedElement) {
            return true;
        } else {
            return false;
        }
    }
    
    public static boolean isDeclaration(CsmObject obj) {
        if (obj instanceof CsmDeclaration) {
            return true;
        } else {
            return false;
        }
    }
    
    public static boolean isBuiltIn(CsmObject obj) {
        if (isDeclaration(obj)) {
            return ((CsmDeclaration)obj).getKind() == CsmDeclaration.Kind.BUILT_IN;
        } else {
            return false;
        }
    }
    
    public static boolean isTemplateInstantiation(CsmObject obj) {
        return obj instanceof CsmInstantiation;
    }
    
    public static boolean isTemplateParameterType(CsmObject obj) {
        return (obj instanceof CsmTemplateParameterType);
    }
    
    public static boolean isTemplate(CsmObject obj) {
        return (obj instanceof CsmTemplate) && ((CsmTemplate)obj).isTemplate();
    }
    
    public static boolean isTemplateParameter(CsmObject obj) {
        return (obj instanceof CsmTemplateParameter);
    }

    public static boolean isClassifierBasedTemplateParameter(CsmObject obj) {
        return (obj instanceof CsmClassifierBasedTemplateParameter);
    }

    
    public static boolean isFunctionPointerType(CsmObject obj) {
        return (obj instanceof CsmFunctionPointerType);
    }

    public static boolean isType(CsmObject obj) {
        if (obj instanceof CsmType) {
            return true;
        } else {
            return false;
        }
    }

    public static boolean isTypedef(CsmObject obj) {
        if (isDeclaration(obj)) {
            return ((CsmDeclaration)obj).getKind() == CsmDeclaration.Kind.TYPEDEF;
        } else {
            return false;
        }
    }
    
    public static boolean isStatement(CsmObject obj) {
        if (obj instanceof CsmStatement) {
            return true;
        } else {
            return false;
        }          
    }

    public static boolean isDeclarationStatement(CsmObject obj) {
        if (obj instanceof CsmDeclarationStatement) {
            return true;
        } else {
            return false;
        }
    }
    
    public static boolean isCompoundStatement(CsmObject obj) {
        if (isStatement(obj)) {
            return ((CsmStatement)obj).getKind() == CsmStatement.Kind.COMPOUND;
        } else {
            return false;
        }          
    }

    public static boolean isGotoStatement(CsmObject obj) {
        return (obj instanceof CsmGotoStatement);
    }

    public static boolean isLabel(CsmObject obj) {
        return (obj instanceof CsmLabel);
    }

    public static boolean isOffsetable(Object obj) {
        if (obj instanceof CsmOffsetable) {
            return true;
        } else {
            return false;
        }        
    }
      
    public static boolean isNamedElement(CsmObject obj) {
        if (obj instanceof CsmNamedElement) {
            return true;
        } else {
            return false;
        }
    }
    
    public static boolean isNamedElement(Object obj) {
        if (obj instanceof CsmNamedElement) {
            return true;
        } else {
            return false;
        }
    }

    public static boolean isEnum(CsmObject obj) {
        if (isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.ENUM; 
        } else {
            return false;
        }
    }
    
    public static boolean isEnumerator(CsmObject obj) {
        if (obj instanceof CsmEnumerator) {
            return true;
        } else {
            return false;
        }
    }
    
    public static boolean isClassifier(CsmObject obj) {
        if (obj instanceof CsmClassifier) {
            return true;
        } else {
            return false;
        }
    }

    public static boolean isCompoundClassifier(CsmObject obj) {
        if (obj instanceof CsmCompoundClassifier) {
            return true;
        } else {
            return false;
        }
    }
    
    public static boolean isClass(CsmObject obj) {
        if (isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return 
                kind == CsmDeclaration.Kind.CLASS 
                || kind == CsmDeclaration.Kind.STRUCT 
                || kind == CsmDeclaration.Kind.UNION;
        } else {
            return false;
        }
    }

    public static boolean isUnion(CsmObject obj) {
        if (isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.UNION;
        } else {
            return false;
        }
    }
    
    public static boolean isClassForwardDeclaration(CsmObject obj) {
        if (isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION;
        } else {
            return false;
        }
    }
    
    public static boolean isScope(CsmObject obj) {
        if (obj instanceof CsmScope) {
            return true;
        } else {
            return false;
        }
    }
    
    public static boolean isScopeElement(CsmObject obj) {
        if (obj instanceof CsmScopeElement) {
            return true;
        } else {
            return false;
        }
    }
    
    /*
     * checks if object is function declaration or function definition
     * it's safe to cast to CsmFunction
     */
    public static boolean isFunction(CsmObject obj) {
        if (isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.FUNCTION ||
                    kind == CsmDeclaration.Kind.FUNCTION_DEFINITION;
        } else {
            return false;
        }
    }   

    public static boolean isParameter(CsmObject obj) {
        return (obj instanceof CsmParameter);
    }

    /*
     * checks if object is function operator
     */
    public static boolean isOperator(CsmObject obj) {
        if (isFunction(obj)) {
            return ((CsmFunction)obj).isOperator();
        }
        return false;
    }   

    /*
     * checks if object is function declaration
     * it's safe to cast to CsmFunction which is not CsmFunctionDefinition
     */
    public static boolean isFunctionDeclaration(CsmObject obj) {
        if (isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.FUNCTION;
        } else {
            return false;
        }
    }   
    
    /*
     * checks if object is function definition
     * it's safe to cast to CsmFunction or CsmFunctionDefinition
     */
    public static boolean isFunctionDefinition(CsmObject obj) {
        if (isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.FUNCTION_DEFINITION;
        } else {
            return false;
        }
    } 
    
    public static boolean isFile(CsmObject obj) {
        if (obj instanceof CsmFile) {
            return true;
        } else {
            return false;
        }
    }  
    
    public static boolean isInheritance(CsmObject obj) {
        if (obj instanceof CsmInheritance) {
            return true;
        } else {
            return false;
        }
    } 

    public static boolean isNamespace(CsmObject obj) {
        if (obj instanceof CsmNamespace) {
            return true;
        } else {
            return false;
        }
    } 
    
    public static boolean isNamespaceDefinition(CsmObject obj) {
        if (isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.NAMESPACE_DEFINITION;
        } else {
            return false;
        }
    }   
    
    public static boolean isClassMember(CsmObject obj) {
        if (obj instanceof CsmMember) {
	    if (isClass(obj) ) {
		return isClass(((CsmClass) obj).getScope());
	    } else {
		return true;
	    }   
        } else {
            return false;
        }
    }    
    
    public static boolean isVariable(CsmObject obj) {
        if (isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.VARIABLE ||
                   kind == CsmDeclaration.Kind.VARIABLE_DEFINITION ;
        } else {
            return false;
        }        
    }

    public static boolean isVariableDeclaration(CsmObject obj) {
        if (isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.VARIABLE ;
        } else {
            return false;
        }        
    }

    public static boolean isVariableDefinition(CsmObject obj) {
        if (isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.VARIABLE_DEFINITION ;
        } else {
            return false;
        }        
    }
    
    /* 
     * Local variable is CsmVariable object declared through
     * CsmDeclaration as part of CsmDeclarationStatement's declarators list
     * or it's CsmParameter
     * for file local variables and global variables return false
     */
    public static boolean isLocalVariable(CsmObject obj) {
        if (isVariable(obj)) {
            // can't be class member
            if (isClassMember(obj)) {
                return false;
            }
            // check scope
            CsmScope scope = ((CsmVariable)obj).getScope();
            return !isFile(scope) && !isNamespace(scope);
        } else {
            return false;
        }
    }  
    
    public static boolean isFileLocalVariable(CsmObject obj) {
        if (isVariable(obj)) {
            return isFile(((CsmVariable)obj).getScope());
        } else {
            return false;
        }
    }      
    
    public static boolean isGlobalVariable(CsmObject obj) {
        if (isVariable(obj)) {
            // global variable has scope - namespace
            return isNamespace(((CsmVariable)obj).getScope());
        } else {
            return false;
        }
    }   
    
    public static boolean isParamVariable(CsmObject obj) {
        if (isVariable(obj)) {
            assert (!(obj instanceof CsmParameter) || !isClassMember(obj)) : "parameter is not class member";
            return obj instanceof CsmParameter;
        } else {
            return false;
        }
    }  
    
    public static boolean isField(CsmObject obj) {
        if (isVariable(obj)) {
            return isClassMember(obj);
        } else {
            return false;
        }
    }  
    
    public static boolean isGlobalFunction(CsmObject obj) {
        if (isFunction(obj)) {
            return !isClassMember(CsmBaseUtilities.getFunctionDeclaration((CsmFunction)obj));
        } else {
            return false;
        }
    }       
    
    /**
     * checks if passed object is method definition or method declaration
     * after this check it is safe to cast only to CsmFunction (not CsmMethod)
     * @see isMethodDeclaration
     */
    public static boolean isMethod(CsmObject obj) {
        if (isFunction(obj)) {
            return isClassMember(CsmBaseUtilities.getFunctionDeclaration((CsmFunction)obj));
        } else {
            return false;
        }
    }
    
    /**
     * checks if passed object is method declaration;
     * after this check it is safe to cast to CsmMethod
     */
    public static boolean isMethodDeclaration(CsmObject obj) {
        if (isFunction(obj)) {
            return isClassMember(obj);
        } else {
            return false;
        }
    }     

    /**
     * checks if passed object is method definition;
     * after this check it is safe to cast to CsmFunctionDefinition (not CsmMethod)
     * @see isMethodDeclaration
     */
    public static boolean isMethodDefinition(CsmObject obj) {
        if (isFunctionDefinition(obj)) {
            return isClassMember(CsmBaseUtilities.getFunctionDeclaration((CsmFunction)obj));
        } else {
            return false;
        }
    }     

    /**
     * checks if passed object is constructor definition or declaration;
     * after this check it is safe to cast to CsmFunction or CsmInitializerListContainer
     */    
    public static boolean isConstructor(CsmObject obj) {
        return obj instanceof CsmInitializerListContainer;
    }   
    
    public static boolean isDestructor(CsmObject obj) {
        if (isMethod(obj)) {
            CsmFunction funDecl = CsmBaseUtilities.getFunctionDeclaration((CsmFunction)obj);
            // check constructor by ~ at the begining of the name
            if (funDecl != null && funDecl.getName().length() > 0) {
                return funDecl.getName().charAt(0) == '~'; //NOI18N
            }
        }
        return false;
    }     
    
    public static boolean isExpression(CsmObject obj) {
        return obj instanceof CsmExpression;
    }
    
    public static boolean isMacro(CsmObject obj) {
        return obj instanceof CsmMacro;
    }
    
    public static boolean isInclude(CsmObject obj) {
        return obj instanceof CsmInclude;
    }

    public static boolean isUsing(CsmObject obj) {
        return (obj instanceof CsmUsingDeclaration) ||
               (obj instanceof CsmUsingDirective);
    }

    public static boolean isNamespaceAlias(CsmObject obj) {
        return obj instanceof CsmNamespaceAlias;        
    }
    
    public static boolean isUsingDirective(CsmObject obj) {
        return obj instanceof CsmUsingDirective;
    }

    public static boolean isUsingDeclaration(CsmObject obj) {
        return obj instanceof CsmUsingDeclaration;
    }

    public static boolean isFriend(CsmObject obj) {
        return obj instanceof CsmFriend;
    }

    public static boolean isFriendClass(CsmObject obj) {
        return obj instanceof CsmFriendClass;
    }

    public static boolean isFriendMethod(CsmObject obj) {
        return obj instanceof CsmFriendFunction;
    }

    public static boolean isExternVariable(CsmDeclaration decl) {
        if (isVariable(decl)) {
            return ((CsmVariable)decl).isExtern();
        }
        return false;
    }
    
    public static boolean isIdentifiable(Object obj) {
        if (obj instanceof CsmIdentifiable) {
            return true;
        } else {
            return false;
        }
    }
}
