/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * DeploymentOptionPanel.java
 *
 * Created on November 30, 2006, 4:27 PM
 */

package org.netbeans.modules.compapp.projects.jbi.jeese.ui;

import java.util.List;
import javax.swing.JLabel;
import org.netbeans.modules.compapp.javaee.codegen.model.EndpointCfg;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/**
 *
 * @author  gpatil
 */
public class DeploymentOptionPanel extends javax.swing.JPanel {

    /**
     * Creates new form DeploymentOptionPanel
     */
    public DeploymentOptionPanel(List<EndpointCfg> cfgs) {
        this.epCfgs = cfgs;
        initComponents();
        custInit();
    }

    public void isDeployThruCA(boolean dep){
        this.jCheckBox1.setSelected(dep);
    }

    public boolean isDeployThruCA(){
        return this.jCheckBox1.isSelected();
    }

    public List<EndpointCfg> getEndpointCfgs(){
        if ((this.epCfgs == null) || (this.epCfgs.size() <= 0)){
            return this.epCfgs;
        }

        return this.cfgPnl.getEndpointCfgs();
    }

    private void custInit(){
        addEndpointCnofigPanel();
        Mnemonics.setLocalizedText(jCheckBox1, NbBundle.getMessage(
                DeploymentOptionPanel.class, "LBL_depThruCA"));//NOI18N
        jCheckBox1.setToolTipText(NbBundle.getMessage(
                DeploymentOptionPanel.class,"TT_depThruCA"));//NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jCheckBox1 = new javax.swing.JCheckBox();
        jlblConfigEffect = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jCheckBox1, org.openide.util.NbBundle.getMessage(DeploymentOptionPanel.class, "LBL_depThruCA")); // NOI18N
        jCheckBox1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBox1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        add(jCheckBox1, gridBagConstraints);
        jCheckBox1.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DeploymentOptionPanel.class, "ASN_Deploy_ChkBx")); // NOI18N
        jCheckBox1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(DeploymentOptionPanel.class, "ASD_Deploy_ChkBx")); // NOI18N

        jlblConfigEffect.setText(org.openide.util.NbBundle.getMessage(DeploymentOptionPanel.class, "LBL_ConfigEffect")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        add(jlblConfigEffect, gridBagConstraints);
        jlblConfigEffect.getAccessibleContext().setAccessibleName("configEffect");

        jLabel1.setText(org.openide.util.NbBundle.getMessage(DeploymentOptionPanel.class, "LBL_Endpoints")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        add(jLabel1, gridBagConstraints);
        jLabel1.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DeploymentOptionPanel.class, "ASN_Endpoints")); // NOI18N
        jLabel1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(DeploymentOptionPanel.class, "ASD_Endpoints")); // NOI18N

        jLabel2.setText(org.openide.util.NbBundle.getMessage(DeploymentOptionPanel.class, "LBL_Deployment")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        add(jLabel2, gridBagConstraints);
        jLabel2.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DeploymentOptionPanel.class, "ASN_Deployment")); // NOI18N
        jLabel2.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(DeploymentOptionPanel.class, "ASD_Deployment")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void jCheckBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBox1ActionPerformed
// TODO add your handling code here:
    }//GEN-LAST:event_jCheckBox1ActionPerformed


    private void  addEndpointCnofigPanel(){
        if ((this.epCfgs != null) && (this.epCfgs.size() > 0)){
            cfgPnl = new EndpointConfigPanel(this.epCfgs);
            java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
            add(cfgPnl, gridBagConstraints);
        } else {
            JLabel msgLbl = new JLabel();
            msgLbl.setText(NbBundle.getMessage(DeploymentOptionPanel.class, "MSG_NoEndpoints"));//NOI18N
            java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 5);
            add(msgLbl, gridBagConstraints);
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jlblConfigEffect;
    // End of variables declaration//GEN-END:variables

    private List<EndpointCfg> epCfgs = null;
    private EndpointConfigPanel cfgPnl = null;
}

