/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * JavaEEModuleNode.java
 *
 * Created on October 12, 2006, 3:20 PM
 */

package org.netbeans.modules.compapp.projects.jbi.jeese.ui;

import java.awt.Image;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.jeese.actions.AppVerifierAction;
import org.netbeans.modules.compapp.projects.jbi.jeese.actions.DeleteJavaEEModuleAction;
import org.netbeans.modules.compapp.projects.jbi.jeese.actions.JavaEEModulePropertiesAction;
import org.netbeans.modules.compapp.projects.jbi.jeese.actions.ServerResourcesAction;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.VisualClassPathItem;
import org.openide.actions.DeleteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.Utilities;

/**
 *
 * @author root
 */
public class JavaEEModuleNode extends AbstractNode {
    private JbiProject jbiProject;
    private VisualClassPathItem vcpi;
    private Lookup lookup;
        
    public JavaEEModuleNode( VisualClassPathItem vcpi,
            JbiProject project) {
        super( Children.LEAF, buildLookup( vcpi, project ) );
        this.vcpi = vcpi;
        this.jbiProject = project;
    }
    
    private static Lookup buildLookup(
            VisualClassPathItem vcpi, JbiProject project) {
        return Lookups.fixed( new Object[] {
            vcpi,
            project,
        }
        );
    }
    
    public String getName() {
        return vcpi.toString();
    }
    
    public String getDisplayName() {
        return vcpi.toString();
    }
    
    public VisualClassPathItem getRefernece() {
        return vcpi;
    }
    
    public Action[] getActions(boolean context) {
        return new Action[] {
            SystemAction.get(DeleteAction.class),            
            null,
            SystemAction.get( JavaEEModulePropertiesAction.class),
            null,
            SystemAction.get(AppVerifierAction.class),
            //SystemAction.get(ServerResourcesAction.class)
        };
    }
    
    public boolean canDestroy() {
        return true;
    }
    
    public void destroy() throws IOException {
        super.destroy();
        
        DeleteJavaEEModuleAction deleteModuleAction =
                SystemAction.get(DeleteJavaEEModuleAction.class);
        deleteModuleAction.performAction(new Node[] {this});
    }

    private Image getProjIcon(){
        Icon ic = null;
        Image ret = null;
        if (this.vcpi != null){
            ic = vcpi.getProjectIcon();
            if (ic instanceof ImageIcon){
                ret = ((ImageIcon)ic).getImage();
            }
        }
        
        return ret;
    }
        
    public Image getIcon(int type) {
        Image ret = getProjIcon();
        if (ret == null){
            ret = ImageUtilities.loadImage(
                "org/netbeans/modules/compapp/projects/jbi/ui/resources/j2seProject.gif"); // NOI18N;
        }
        return ret;
    }
    
    public Image getOpenedIcon(int type) {
        Image ret = getProjIcon();
        if (ret == null){
            ret = ImageUtilities.loadImage(
                "org/netbeans/modules/compapp/projects/jbi/ui/resources/j2seProject.gif"); // NOI18N;            
        }
        return ret;        
    }    
}
