/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.compapp.projects.wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Panel template used by {@link ProgressDialogFactory}.
 *
 * @see org.netbeans.modules.compapp.projects.wizard.ProgressDialogFactory
 *
 * @author Tientien Li
 */
class ProgressPanel extends JPanel {
    
    /** Creates new form ProgressPanel */
    ProgressPanel(final JComponent progressBar) {
        
        initComponents();
        embed(progressBar);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        panelProgressTracking = new javax.swing.JPanel();
        panelVisualProgress = new javax.swing.JPanel();
        labelProgressDetail = new javax.swing.JLabel();
        progressBar = new javax.swing.JProgressBar();

        setLayout(new java.awt.GridBagLayout());

        panelProgressTracking.setLayout(new java.awt.GridBagLayout());

        panelVisualProgress.setLayout(new java.awt.GridBagLayout());

        labelProgressDetail.setMinimumSize(new java.awt.Dimension(300, 14));
        labelProgressDetail.setPreferredSize(new java.awt.Dimension(300, 14));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 4, 4, 4);
        panelVisualProgress.add(labelProgressDetail, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 8, 4);
        panelVisualProgress.add(progressBar, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 10, 4, 10);
        panelProgressTracking.add(panelVisualProgress, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(panelProgressTracking, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void embed(JComponent actualProgressBar) {
        LayoutManager layout = panelVisualProgress.getLayout();
        if (layout instanceof GridBagLayout) {
            GridBagLayout gbl = (GridBagLayout) layout;
            GridBagConstraints cons = gbl.getConstraints(progressBar);
            panelVisualProgress.add(actualProgressBar, cons);
            panelVisualProgress.remove(progressBar);
            validate();
        } else {
            throw new RuntimeException(
                    "Internal error: expected GridBagLayout for panelVisualProgress, "
                    + "found " + layout.getClass().getName());
        }
    }

    JLabel getMessageComponent() {
        return labelProgressDetail;
    }
        
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel labelProgressDetail;
    private javax.swing.JPanel panelProgressTracking;
    private javax.swing.JPanel panelVisualProgress;
    private javax.swing.JProgressBar progressBar;
    // End of variables declaration//GEN-END:variables
    
}
