/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 * 
 * Contributor(s):
 * 
 * Portions Copyrighted 2008 Sun Microsystems, Inc.
 */
package org.netbeans.core.ui.options.filetypes;

import org.netbeans.core.ui.options.filetypes.FileAssociationsModel.MimeItem;
import org.openide.util.NbBundle;

/** Panel with list of available MIME types.
 *
 * @author Jiri Skrivanek
 */
public class OpenAsPanel extends javax.swing.JPanel {

    private String extension;
    private FileAssociationsModel model;
    
    /** Creates new OpenAsPanel */
    public OpenAsPanel() {
        initComponents();
        getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OpenAsPanel.class, "OpenAsPanel.AD")); // NOI18N
    }

    void setModel(FileAssociationsModel model) {
        this.model = model;
    }
    
    /** Returns selected MIME type. */
    String getMimeType() {
        if(lstMimeTypes.getSelectedValue() != null) {
            return ((MimeItem)lstMimeTypes.getSelectedValue()).getMimeType();
        }
        return null;
    }

    void setExtension(String extension) {
        this.extension = extension;
        lblExtension.setText(NbBundle.getMessage(OpenAsPanel.class, "OpenAsPanel.lblExtension.text", extension)); // NOI18N
        updateList();
    }
    
    void updateList() {
        lstMimeTypes.setListData(model.getMimeItems().toArray());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        txtDescription = new javax.swing.JTextPane();
        lblExtension = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        lstMimeTypes = new javax.swing.JList();

        jScrollPane1.setBorder(null);
        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane1.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);
        jScrollPane1.setOpaque(false);

        txtDescription.setBorder(null);
        txtDescription.setEditable(false);
        txtDescription.setText(org.openide.util.NbBundle.getMessage(OpenAsPanel.class, "OpenAsPanel.txtDescription.text")); // NOI18N
        txtDescription.setOpaque(false);
        jScrollPane1.setViewportView(txtDescription);
        txtDescription.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(OpenAsPanel.class, "OpenAsPanel.txtDescription.AN")); // NOI18N
        txtDescription.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(OpenAsPanel.class, "OpenAsPanel.txtDescription.AD")); // NOI18N

        lblExtension.setLabelFor(lstMimeTypes);
        lblExtension.setText("Treat files as:"); // NOI18N

        lstMimeTypes.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jScrollPane2.setViewportView(lstMimeTypes);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 245, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 245, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, lblExtension))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 37, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(lblExtension)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 216, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JLabel lblExtension;
    private javax.swing.JList lstMimeTypes;
    private javax.swing.JTextPane txtDescription;
    // End of variables declaration//GEN-END:variables

}
