/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is the Nokia Deployment.                      
 * The Initial Developer of the Original Software is Nokia Corporation.
 * Portions created by Nokia Corporation Copyright 2005, 2007.         
 * All Rights Reserved.                                                
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.mobility.deployment.nokia;

import com.nokia.phone.deploy.Deployer;
import javax.swing.DefaultListModel;

/**
 * Project-specific customizer panel for Nokia deployment.
 */
public class NokiaProjectCustomizerPanel extends javax.swing.JPanel {

    private DefaultListModel allDevices;
    private Deployer deployer;
    
    /** Creates new form NokiaProjectCustomizerPanel */
    public NokiaProjectCustomizerPanel(Deployer deployer) {
        this.deployer = deployer;
        allDevices = new DefaultListModel();
        for(String dev : deployer.getTerminals()) {
            allDevices.addElement(dev);
        }

        initComponents();

        setVisibilityOfComponents();
    }

    private void setVisibilityOfComponents() {
        boolean visible;
        if(allDevicesButton.isEnabled() && allDevicesButton.isSelected()) {
            visible = false;
        } else {
            visible = true;
        }
        this.availableDevicesList.setEnabled(visible);
        this.selectedDevicesTextArea.setEnabled(visible);
        this.clearSelectedDevicesButton.setEnabled(visible);
        this.refreshButton.setEnabled(visible);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        allDevicesButton = new javax.swing.JRadioButton();
        selectedDevicesButton = new javax.swing.JRadioButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        availableDevicesList = new javax.swing.JList();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        selectedDevicesTextArea = new javax.swing.JTextArea();
        clearSelectedDevicesButton = new javax.swing.JButton();
        refreshButton = new javax.swing.JButton();

        buttonGroup1.add(allDevicesButton);
        org.openide.awt.Mnemonics.setLocalizedText(allDevicesButton, org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "NokiaProjectCustomizerPanel.allDevicesButton.text")); // NOI18N
        allDevicesButton.setActionCommand(org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "NokiaProjectCustomizerPanel.allDevicesButton.actionCommand")); // NOI18N
        allDevicesButton.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        allDevicesButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        allDevicesButton.setName(NokiaDeploymentPlugin.PROP_DEPLOY_TO_ALL_DEVICES);
        allDevicesButton.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                allDevicesButtonStateChanged(evt);
            }
        });
        allDevicesButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                allDevicesButtonActionPerformed(evt);
            }
        });

        buttonGroup1.add(selectedDevicesButton);
        org.openide.awt.Mnemonics.setLocalizedText(selectedDevicesButton, org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "NokiaProjectCustomizerPanel.selectedDevicesButton.text")); // NOI18N
        selectedDevicesButton.setActionCommand(org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "NokiaProjectCustomizerPanel.selectedDevicesButton.actionCommand")); // NOI18N
        selectedDevicesButton.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        selectedDevicesButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        selectedDevicesButton.setName(NokiaDeploymentPlugin.PROP_DEPLOY_TO_ALL_DEVICES);
        selectedDevicesButton.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                selectedDevicesButtonStateChanged(evt);
            }
        });
        selectedDevicesButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                selectedDevicesButtonActionPerformed(evt);
            }
        });

        availableDevicesList.setModel(allDevices);
        availableDevicesList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        availableDevicesList.setToolTipText(org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "NokiaProjectCustomizerPanel.availableDevicesList.toolTipText")); // NOI18N
        availableDevicesList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                availableDevicesListValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(availableDevicesList);
        availableDevicesList.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "ACSN_ListAll")); // NOI18N
        availableDevicesList.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "ACSD_ListAll")); // NOI18N

        jLabel1.setLabelFor(availableDevicesList);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "NokiaProjectCustomizerPanel.jLabel1.text")); // NOI18N

        jLabel2.setLabelFor(selectedDevicesTextArea);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "NokiaProjectCustomizerPanel.jLabel2.text")); // NOI18N

        selectedDevicesTextArea.setColumns(20);
        selectedDevicesTextArea.setEditable(false);
        selectedDevicesTextArea.setRows(5);
        selectedDevicesTextArea.setName(NokiaDeploymentPlugin.PROP_SELECTED_DEVICES);
        jScrollPane2.setViewportView(selectedDevicesTextArea);

        org.openide.awt.Mnemonics.setLocalizedText(clearSelectedDevicesButton, org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "NokiaProjectCustomizerPanel.clearSelectedDevicesButton.text")); // NOI18N
        clearSelectedDevicesButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearSelectedDevicesButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(refreshButton, org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "NokiaProjectCustomizerPanel.refreshButton.text")); // NOI18N
        refreshButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refreshButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                        .add(org.jdesktop.layout.GroupLayout.TRAILING, jScrollPane1, 0, 0, Short.MAX_VALUE)
                        .add(org.jdesktop.layout.GroupLayout.TRAILING, allDevicesButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(org.jdesktop.layout.GroupLayout.TRAILING, selectedDevicesButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .add(jLabel1)
                    .add(refreshButton))
                .add(74, 74, 74)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(clearSelectedDevicesButton)
                    .add(jLabel2)
                    .add(jScrollPane2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 187, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(100, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {jScrollPane1, jScrollPane2}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(allDevicesButton)
                .add(15, 15, 15)
                .add(selectedDevicesButton)
                .add(16, 16, 16)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(jLabel2))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 132, Short.MAX_VALUE)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(clearSelectedDevicesButton)
                    .add(refreshButton))
                .addContainerGap(47, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {jScrollPane1, jScrollPane2}, org.jdesktop.layout.GroupLayout.VERTICAL);

        allDevicesButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "ACSN_DeployAll")); // NOI18N
        allDevicesButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "ACSD_DeployAll")); // NOI18N
        selectedDevicesButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "ACSN_DeploySelected")); // NOI18N
        selectedDevicesButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "ACSD_DeploySelected")); // NOI18N
        jLabel2.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "ACSN_ListSelected")); // NOI18N
        jLabel2.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NokiaProjectCustomizerPanel.class, "ACSD_ListSelected")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

private void selectedDevicesButtonStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_selectedDevicesButtonStateChanged
    setVisibilityOfComponents();
}//GEN-LAST:event_selectedDevicesButtonStateChanged

private void allDevicesButtonStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_allDevicesButtonStateChanged
    setVisibilityOfComponents();
}//GEN-LAST:event_allDevicesButtonStateChanged

private void refreshButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_refreshButtonActionPerformed
    this.refreshAvailableDevices();
}//GEN-LAST:event_refreshButtonActionPerformed

private void allDevicesButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_allDevicesButtonActionPerformed
    this.selectedDevicesTextArea.setText("");
    setVisibilityOfComponents();
}//GEN-LAST:event_allDevicesButtonActionPerformed

private void selectedDevicesButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_selectedDevicesButtonActionPerformed
    setVisibilityOfComponents();
}//GEN-LAST:event_selectedDevicesButtonActionPerformed

private void clearSelectedDevicesButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearSelectedDevicesButtonActionPerformed
    this.selectedDevicesTextArea.setText("");
}//GEN-LAST:event_clearSelectedDevicesButtonActionPerformed

private void availableDevicesListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_availableDevicesListValueChanged
    if(availableDevicesList.getSelectedIndex() != -1) {
        String selectedDevice = (String)availableDevicesList.getSelectedValue();
        if((selectedDevicesTextArea.getText()).indexOf(selectedDevice) == -1) {
            selectedDevicesTextArea.append(selectedDevice + "\n");
        } else {
            // do nothing
        }
    }
}//GEN-LAST:event_availableDevicesListValueChanged
private void refreshAvailableDevices() {
    allDevices.clear();
    for(String dev : deployer.getTerminals()) {
        allDevices.addElement(dev);
    }
}    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton allDevicesButton;
    private javax.swing.JList availableDevicesList;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton clearSelectedDevicesButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JButton refreshButton;
    private javax.swing.JRadioButton selectedDevicesButton;
    private javax.swing.JTextArea selectedDevicesTextArea;
    // End of variables declaration//GEN-END:variables
    
}
