/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.project.support.customizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.openide.util.WeakListeners;

import java.util.Comparator;
import java.util.Arrays;
import javax.swing.*;
import java.awt.*;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import org.openide.util.NbBundle;

/**
 *
 * @author  tz97951
 */
public class LibrariesChooser extends javax.swing.JPanel {
    
    /** Creates new form LibrariesChooser */
    public LibrariesChooser(String libraryType) {
        initComponents();
        initAccessibility();
        jList1.setPrototypeCellValue("0123456789012345678901234");      //NOI18N
        jList1.setModel(new LibrariesListModel(libraryType));
        jList1.setCellRenderer(new LibraryRenderer());
    }
    
    
    
    public Library[] getSelectedLibraries() {
        final Object[] selected = this.jList1.getSelectedValues();
        final Library[] libraries = new Library[selected.length];
        System.arraycopy(selected,0,libraries,0,selected.length);
        return libraries;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        edit = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setLabelFor(jList1);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, NbBundle.getMessage(LibrariesChooser.class, "LAB_LIbCh_InstalledLibraries")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 6, 12);
        add(jLabel1, gridBagConstraints);
        jLabel1.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LibrariesChooser.class, "ACCESSIBLE_NAME_jLabel1")); // NOI18N
        jLabel1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LibrariesChooser.class, "ACCESSIBLE_DESCRIPTION_jLabel1")); // NOI18N

        jScrollPane1.setViewportView(jList1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 12, 12);
        add(jScrollPane1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(edit, NbBundle.getMessage(LibrariesChooser.class, "LBL_LibCh_Edit")); // NOI18N
        edit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editLibraries(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 12, 12);
        add(edit, gridBagConstraints);
        edit.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LibrariesChooser.class, "ACCESSIBLE_NAME_edit")); // NOI18N
        edit.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LibrariesChooser.class, "ACCESSIBLE_DESCRIPTION_edit")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    private void initAccessibility() {
        //getAccessibleContext().setAccessibleName();
        //getAccessibleContext().setAccessibleDescription();
    }
    
    private void editLibraries(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editLibraries
        LibrariesCustomizer.showCustomizer((Library)this.jList1.getSelectedValue());
    }//GEN-LAST:event_editLibraries
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton edit;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JList jList1;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    
    
    
    private final class LibrariesListModel extends AbstractListModel implements PropertyChangeListener {
        
        private Library[] cache;
        private final String libraryType;
        
        public LibrariesListModel(String libraryType) {
            this.libraryType = libraryType;
            LibraryManager manager = LibraryManager.getDefault();
            manager.addPropertyChangeListener(WeakListeners.create(PropertyChangeListener.class,
                                                                   this, manager));
        }
        
        public synchronized int getSize() {
            if (this.cache == null) {
                this.cache = this.getLibraries();
            }
            return this.cache.length;
        }
        
        public synchronized Object getElementAt(final int index) {
            if (this.cache == null) {
                this.cache = this.getLibraries();
            }
            if (index >= 0 && index < this.cache.length) {
                return this.cache[index];
            }
            return null;
        }
        
        public synchronized void propertyChange(@SuppressWarnings("unused")
		final PropertyChangeEvent evt) {
            this.cache = null;
        }
        
        private Library[] getLibraries() {
            Library[] libs = LibraryManager.getDefault().getLibraries();
            final ArrayList<Library> filtered = new ArrayList<Library>();
            for (int i=0; libs!=null && i<libs.length; i++) {
                if (libraryType == null || libraryType.equals(libs[i].getType())) {
                    filtered.add(libs[i]);
                }
            }
            libs = filtered.toArray(new Library[filtered.size()]);
            Arrays.sort(libs, new Comparator<Library>() {
                public int compare(Library o1, Library o2) {
                    final String name1 = o1.getDisplayName();
                    final String name2 = o2.getDisplayName();
                    return name1.compareToIgnoreCase(name2);
                }
            });
            return libs;
        }
    }
    
    
    private static final class LibraryRenderer extends DefaultListCellRenderer {
        
        private LibraryRenderer()
        {
            //Just to avoid creation of accessor class
        }
        
        public Component getListCellRendererComponent(final JList list, final Object value, final int index, final boolean isSelected, final boolean cellHasFocus) {
            String displayName;
            if (value instanceof Library) {
                displayName = ((Library)value).getDisplayName();
            } else if (value instanceof String) {
                displayName = (String) value;
            } else {
                displayName = value.toString();
            }
            return super.getListCellRendererComponent(list, displayName, index, isSelected, cellHasFocus);
        }
    }
    
}
