/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.refactoring.php.ui.tree;

import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.spi.ui.*;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/**
 *
 * @author Jan Becicka
 */
public class TreeElementFactoryImpl implements TreeElementFactoryImplementation {

    public Map<Object, TreeElement> map = new WeakHashMap<Object,TreeElement>();
    public static TreeElementFactoryImpl instance;
    {
        instance = this;
    }
    
    public TreeElement getTreeElement(Object o) {
        TreeElement result = null;
        if (o instanceof SourceGroup) {
            result = map.get(((SourceGroup)o).getRootFolder());
        } else {
            result = map.get(o);
        }
        if (result!= null)
            return result;
        if (o instanceof FileObject) {
            FileObject fo = (FileObject) o;
            if (!isPhpFile(fo)) {return null;}
            if (fo.isFolder()) {
                SourceGroup sg = FolderTreeElement.getSourceGroup(fo);
                if (sg!=null && fo.equals(sg.getRootFolder())) 
                    result = new SourceGroupTreeElement(sg);
                else 
                    result = new FolderTreeElement(fo);
            } else {
                result = new FileTreeElement(fo);
            }
        } else if (o instanceof SourceGroup) {
            result = new SourceGroupTreeElement((SourceGroup)o);
        } else if (o instanceof ElementGrip) {
            result = new ElementGripTreeElement((ElementGrip) o);
        }
        else if (o instanceof Project) {
            result = new ProjectTreeElement((Project) o);
        } else if (o instanceof RefactoringElement) {
            ElementGrip grip = ((RefactoringElement) o).getLookup().lookup(ElementGrip.class);
            if (grip!=null) {
                result = new RefactoringTreeElement((RefactoringElement) o);
            } 
        }
        if (result != null) {
            if (o instanceof SourceGroup) {
                map.put(((SourceGroup)o).getRootFolder(), result);
            } else {
                map.put(o, result);
            }
        }
        return result;
    }

    private static boolean isPhpFile(FileObject fo) {
        String mimeType = FileUtil.getMIMEType(fo, PhpSourcePath.MIME_TYPE);
        return mimeType == null ? false : PhpSourcePath.MIME_TYPE.equals(mimeType);        
    }

    public void cleanUp() {
        map.clear();
        ElementGripFactory.getDefault().cleanUp();
    }
}
