/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.visualweb.complib.ui;

import java.io.File;
import java.util.prefs.Preferences;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import org.netbeans.modules.visualweb.complib.ComplibServiceProvider;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.extension.openide.awt.JFileChooser_RAVE;
import org.openide.util.NbBundle;

final class ComplibOptionsPanel extends javax.swing.JPanel {
    
    private static final String IMPORT_START_DIR = "importStartDir";
    private final ComplibOptionsPanelController controller;
    
    ComplibOptionsPanel(ComplibOptionsPanelController controller) {
        this.controller = controller;
        initComponents();
        // TODO listen to changes in form fields and call controller.changed()
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel1 = new javax.swing.JPanel();
        importStartDirLbl = new javax.swing.JLabel();
        importStartDirField = new javax.swing.JTextField();
        importResetBtn = new javax.swing.JButton();
        importBrowseBtn = new javax.swing.JButton();
        sharedComplibCheckBox = new javax.swing.JCheckBox();

        setBackground(java.awt.Color.white);
        jPanel1.setBackground(java.awt.Color.white);
        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(ComplibOptionsPanel.class, "AdvancedOption_ImportPanelTitle")));
        importStartDirLbl.setLabelFor(importStartDirField);
        org.openide.awt.Mnemonics.setLocalizedText(importStartDirLbl, org.openide.util.NbBundle.getMessage(ComplibOptionsPanel.class, "AdvancedOption_ImportStartDirLbl"));

        org.openide.awt.Mnemonics.setLocalizedText(importResetBtn, org.openide.util.NbBundle.getMessage(ComplibOptionsPanel.class, "AdvancedOption_ImportResetBtn"));
        importResetBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                importResetActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(importBrowseBtn, org.openide.util.NbBundle.getMessage(ComplibOptionsPanel.class, "AdvancedOption_ImportBrowseBtn"));
        importBrowseBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(importStartDirLbl)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(importStartDirField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 246, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(importBrowseBtn))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, importResetBtn))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(importStartDirLbl)
                    .add(importStartDirField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(importBrowseBtn))
                .add(12, 12, 12)
                .add(importResetBtn)
                .addContainerGap())
        );

        sharedComplibCheckBox.setBackground(java.awt.Color.white);
        org.openide.awt.Mnemonics.setLocalizedText(sharedComplibCheckBox, org.openide.util.NbBundle.getMessage(ComplibOptionsPanel.class, "AdvancedOption_SharedComplibCheckBox"));
        sharedComplibCheckBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        sharedComplibCheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(sharedComplibCheckBox))
                    .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(sharedComplibCheckBox)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void browseActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_browseActionPerformed
        JFileChooser fcd = JFileChooser_RAVE.getJFileChooser();
        fcd.setFileFilter(new FileFilter() {
            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(ComplibOptionsPanel.class,
                        "AdvancedOption_ImportFilterDesc"); // NOI18N
            }
        });

        File file = new File(importStartDirField.getText());
        fcd.setCurrentDirectory(file);

        // FIXME This does not allow user to select a directory for some reason
        if (fcd.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            File selectedFile = fcd.getSelectedFile();
            importStartDirField.setText(selectedFile.getAbsolutePath());
        }
    }// GEN-LAST:event_browseActionPerformed

    private void importResetActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_importResetActionPerformed
        String samplesDir = IdeUtil.getRaveSamplesDirectory().getAbsolutePath();
        importStartDirField.setText(samplesDir);
    }// GEN-LAST:event_importResetActionPerformed
    
    private static Preferences prefs = ComplibServiceProvider.getInstance()
            .getPreferences();
    
    static {
        initImportStartDir();
    }
    
    /**
     * Set system property to overwrite the default file chooser start
     * directory.
     */
    private static void initImportStartDir() {
        // Current property name
        String dir = System.getProperty("complib.importStartDir");
        if (dir == null) {
            // Deprecated property name
            dir = System.getProperty("toolbox.importStartDir");
        }

        if (dir != null) {
            prefs.put(IMPORT_START_DIR, dir);
        }
    }
    
    /**
     * Return the directory used initially by the FileChooser
     * to import complib files. Order of precedence is: 1) current System
     * property 2) deprecated System property 3) saved Preference 4) IDE samples
     * directory. Note: #1 and #2 will overwrite #3.
     * 
     * @return
     */
    static File getImportStartDir() {
        // Initially point to the rave samples directory
        String samplesDir = IdeUtil.getRaveSamplesDirectory()
                .getAbsolutePath();
        String importStartPath = prefs.get(IMPORT_START_DIR, samplesDir);
        return new File(importStartPath);
    }

    void load() {
        importStartDirField.setText(getImportStartDir().getAbsolutePath());
        
        // TODO Hook up the shared component library action
        sharedComplibCheckBox.setEnabled(false);
        sharedComplibCheckBox.setSelected(true);
        
        // TODO read settings and initialize GUI
        // Example:
        // someCheckBox.setSelected(Preferences.userNodeForPackage(ComplibPanel.class).getBoolean("someFlag", false));
        // or:
        // someTextField.setText(SomeSystemOption.getDefault().getSomeStringProperty());
    }
    
    void store() {
        prefs.put(IMPORT_START_DIR, importStartDirField.getText());
        // TODO store modified settings
        // Example:
        // Preferences.userNodeForPackage(ComplibPanel.class).putBoolean("someFlag", someCheckBox.isSelected());
        // or:
        // SomeSystemOption.getDefault().setSomeStringProperty(someTextField.getText());
    }
    
    boolean valid() {
        // Check whether form is consistent and complete
        File startDir = new File(importStartDirField.getText());
        if (!startDir.isDirectory()) {
            return false;
        }
        return true;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton importBrowseBtn;
    private javax.swing.JButton importResetBtn;
    private javax.swing.JTextField importStartDirField;
    private javax.swing.JLabel importStartDirLbl;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JCheckBox sharedComplibCheckBox;
    // End of variables declaration//GEN-END:variables
    
}
