/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.visualweb.designer.jsf;

import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataListener;

/**
 *
 * @author  pbuzek
 */
public class JsfDesignerAdvancedOptionsPanel extends javax.swing.JPanel {
    private ResolutionModel resolutionModel = new ResolutionModel();
    
    /** Creates new form JsfDesignerAdvancedOptionsPanel */
    public JsfDesignerAdvancedOptionsPanel() {
        initComponents();
        resolutionModel.setValue(0);
        resolution.setModel(resolutionModel);
    }
    
    int getResolution() {
        return resolutionModel.getValue();
    }
    void setResolution(int res) {
        resolutionModel.setValue(res);
    }
    
    int getDefaultFontSize() {
        return ((Integer)defaultFontSize.getValue()).intValue();
    }
    void setDefaultFontSize(int i) {
        defaultFontSize.setValue(Integer.valueOf(i));
    }
    int getGridHeight() {
        return ((Integer)gridHeight.getValue()).intValue();
    }
    void setGridHeight(int i) {
        gridHeight.setValue(Integer.valueOf(i));
    }
    int getGridWidth() {
        return ((Integer)gridWidth.getValue()).intValue();
    }
    void setGridWidth(int i) {
        gridWidth.setValue(Integer.valueOf(i));
    }
    boolean isShowGrid() {
        return showGrid.isSelected();
    }
    void setShowGrid(boolean b) {
        showGrid.setSelected(b);
    }
    boolean isSnapToGrid() {
        return snapToGrid.isSelected();
    }
    void setSnapToGrid(boolean b) {
        snapToGrid.setSelected(b);
    }
    String getDataProviderSuffix() {
        return dataProviderSuffix.getText();
    }
    void setDataProviderSuffix(String suffix) {
        dataProviderSuffix.setText(suffix);
    }
    String getRowsetSuffix() {
        return rowsetSuffix.getText();
    }
    void setRowsetSuffix(String suffix) {
        rowsetSuffix.setText(suffix);
    }
    boolean isRowsetInSession() {
        return rowsetInSession.isSelected();
    }
    void setRowsetInSession(boolean b) {
        rowsetInSession.setSelected(b);
    }
    boolean isRowsetDuplicate() {
        return checkRowsetDuplicate.isSelected();
    }
    void setRowsetDuplicate(boolean b) {
        checkRowsetDuplicate.setSelected(b);
    }
    boolean isPromptForName() {
        return promptForName.isSelected();
    }
    void setPromptForName(boolean b) {
        promptForName.setSelected(b);
    }
        
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        defaultFontSize = new javax.swing.JSpinner();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        gridHeight = new javax.swing.JSpinner();
        gridWidth = new javax.swing.JSpinner();
        jLabel4 = new javax.swing.JLabel();
        resolution = new javax.swing.JComboBox();
        showGrid = new javax.swing.JCheckBox();
        snapToGrid = new javax.swing.JCheckBox();
        jLabel6 = new javax.swing.JLabel();
        rowsetSuffix = new javax.swing.JTextField();
        rowsetInSession = new javax.swing.JCheckBox();
        checkRowsetDuplicate = new javax.swing.JCheckBox();
        jLabel5 = new javax.swing.JLabel();
        dataProviderSuffix = new javax.swing.JTextField();
        promptForName = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 0, 0);
        add(defaultFontSize, gridBagConstraints);

        jLabel1.setLabelFor(defaultFontSize);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 0, 0, 0);
        add(jLabel1, gridBagConstraints);

        jLabel2.setLabelFor(gridHeight);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.jLabel2.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 0, 0, 0);
        add(jLabel2, gridBagConstraints);

        jLabel3.setLabelFor(gridWidth);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.jLabel3.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 0, 0, 0);
        add(jLabel3, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 0, 0);
        add(gridHeight, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 0, 0);
        add(gridWidth, gridBagConstraints);

        jLabel4.setLabelFor(resolution);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.jLabel4.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel4, gridBagConstraints);

        resolution.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 7, 0, 0);
        add(resolution, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(showGrid, org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.showGrid.text")); // NOI18N
        showGrid.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 0, 0);
        add(showGrid, gridBagConstraints);
        showGrid.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.showGrid.desc")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(snapToGrid, org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.snapToGrid.text")); // NOI18N
        snapToGrid.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 0, 0);
        add(snapToGrid, gridBagConstraints);
        snapToGrid.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.snapToGrid.desc")); // NOI18N

        jLabel6.setLabelFor(rowsetSuffix);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel6, org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.jLabel6.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 0, 0, 0);
        add(jLabel6, gridBagConstraints);

        rowsetSuffix.setText(org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.rowsetSuffix.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 0, 0);
        add(rowsetSuffix, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(rowsetInSession, org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.rowsetInSession.text")); // NOI18N
        rowsetInSession.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 0, 0);
        add(rowsetInSession, gridBagConstraints);
        rowsetInSession.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.rowsetInSession.desc")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(checkRowsetDuplicate, org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.checkRowsetDuplicate.text")); // NOI18N
        checkRowsetDuplicate.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 0, 0);
        add(checkRowsetDuplicate, gridBagConstraints);
        checkRowsetDuplicate.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.checkRowsetDuplicate.desc")); // NOI18N

        jLabel5.setLabelFor(dataProviderSuffix);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel5, org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.jLabel5.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(14, 0, 0, 0);
        add(jLabel5, gridBagConstraints);

        dataProviderSuffix.setText(org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.dataProviderSuffix.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(14, 7, 0, 0);
        add(dataProviderSuffix, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(promptForName, org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.promptForName.text")); // NOI18N
        promptForName.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 0, 0);
        add(promptForName, gridBagConstraints);
        promptForName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JsfDesignerAdvancedOptionsPanel.class, "JsfDesignerAdvancedOptionsPanel.promptForName.desc")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox checkRowsetDuplicate;
    private javax.swing.JTextField dataProviderSuffix;
    private javax.swing.JSpinner defaultFontSize;
    private javax.swing.JSpinner gridHeight;
    private javax.swing.JSpinner gridWidth;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JCheckBox promptForName;
    private javax.swing.JComboBox resolution;
    private javax.swing.JCheckBox rowsetInSession;
    private javax.swing.JTextField rowsetSuffix;
    private javax.swing.JCheckBox showGrid;
    private javax.swing.JCheckBox snapToGrid;
    // End of variables declaration//GEN-END:variables

    private class ResolutionModel implements ComboBoxModel {
        ResolutionEditor editor = new ResolutionEditor();

        public int getValue() {
            return ((Integer)editor.getValue()).intValue();
        }
        
        public void setValue(int value) {
            editor.setValue(Integer.valueOf(value));
        }
        
        public void setSelectedItem(Object anItem) {
            editor.setAsText((String)anItem);
        }

        public Object getSelectedItem() {
            return editor.getAsText();
        }

        public int getSize() {
            return editor.getTags().length;
        }

        public Object getElementAt(int index) {
            return editor.getTags()[index];
        }

        public void addListDataListener(ListDataListener l) {
        }

        public void removeListDataListener(ListDataListener l) {
        }
        
    }
}
