/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * CodeClipItemNode.java
 *
 * Created on July 27, 2006, 10:16 AM
 *
 * This node represents the dataobject in the palette
 *
 * @author Joelle Lam <joelle.lam@sun.com>
 * @date 08/20/2006
 */

package org.netbeans.modules.visualweb.palette.codeclips;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.BeanInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.text.JTextComponent;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class CodeClipItemNode extends FilterNode implements EditCookie {

    private static final Node.PropertySet[] NO_PROPERTIES = new Node.PropertySet[0];

    private String name;
    private String bundleName;
    private String displayNameKey;
    private String tooltipKey;
    private String icon16URL;
    private String icon32URL;
    private String displayName;
    private String description;
    private Image icon16;
    private Image icon32;
    private String body;
    private DataNode dataNode;
    private FileObject fileObj;


    /*
     * Class constructor
     *
     * @param
     */
    CodeClipItemNode(DataNode dataNode, String name, String bundleName, String displayNameKey, String tooltipKey, String icon16URL, String icon32URL, String body, InstanceContent content) {


        super(dataNode, Children.LEAF, new AbstractLookup(content));


//        DataObject dataObj = dataNode.getDataObject();
        fileObj = (dataNode.getDataObject()).getPrimaryFile();

        this.dataNode = dataNode;
        content.add(this);
        this.name = name;
        this.bundleName = bundleName;
        this.displayNameKey = displayNameKey;
        this.tooltipKey = tooltipKey;
        this.icon16URL = icon16URL;
        this.icon32URL = icon32URL;
        this.body = body;
    }

    public String getName() {
        return getDisplayName();
    }

    public void setName(String s) {

        if (!fileObj.canWrite()) {
            System.out.println("Cannot write to file.");
            return;
        }
//        File file = FileUtil.toFile(fileObj);
        try {
            this.destroy();
        } catch (IOException ex) {
            ErrorManager.getDefault().notify(ex);
        }

        displayNameKey = s;

        try {
            CodeClipUtilities.createCodeClipFile(fileObj.getParent(), body, displayNameKey, this.bundleName, tooltipKey);
        } catch (IOException ex) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
        }
    }

    public String getDisplayName() {
        if (displayName == null) {
            displayName = _getDisplayName(bundleName, displayNameKey);
        }
        return displayName;
    }

    public String getShortDescription() {
        if (description == null ) {
            description = _getShortDescription(bundleName, tooltipKey, displayNameKey);
        } 
        return description;
    }

    public Image getIcon(int type) {

        Image icon = null;

        if (type == BeanInfo.ICON_COLOR_16x16 || type == BeanInfo.ICON_MONO_16x16) {
            if (icon16 == null) {
                icon16 = _getIcon(icon16URL);
                if (icon16 == null) {
                    icon16 = ImageUtilities.loadImage("org/netbeans/modules/palette/resources/unknown16.gif"); // NOI18N
                }
            }
            icon = icon16;
        } else if (type == BeanInfo.ICON_COLOR_32x32 || type == BeanInfo.ICON_MONO_32x32) {
            if (icon32 == null) {
                icon32 = _getIcon(icon32URL);
                if (icon32 == null) {
                    icon32 = ImageUtilities.loadImage("org/netbeans/modules/palette/resources/unknown32.gif"); // NOI18N
                }
            }
            icon = icon32;
        }

        return icon;
    }

    public boolean canRename() {
        return true;
    }
    // TODO properties
//    public Node.PropertySet[] getPropertySets() {
//        return NO_PROPERTIES;
//    }

    public Transferable clipboardCopy() throws IOException {

        ExTransferable t = ExTransferable.create(super.clipboardCopy());

        Lookup lookup = getLookup();

        // Can we create our own version of Active Editor Drop here?
        ActiveEditorDrop drop = lookup.lookup(ActiveEditorDrop.class);
        ActiveEditorDropTransferable s = new ActiveEditorDropTransferable(drop);
        t.put(s);

        return new NoExternalDndTransferable(t);
    }

    @Override
    public Transferable drag() throws IOException {
        Transferable t = clipboardCopy();
        return t;
    }

    private static class ActiveEditorDropTransferable extends ExTransferable.Single {

        private ActiveEditorDrop drop;

        ActiveEditorDropTransferable(ActiveEditorDrop drop) {
            super(ActiveEditorDrop.FLAVOR);

            this.drop = drop;
        }

        public Object getData() {
            return drop;
        }
    }

    public String _getDisplayName(String bundleName, String displayNameKey) {
        String displayName = null;
        if (bundleName != null) {
            try {
                displayName = NbBundle.getBundle(bundleName).getString(displayNameKey);
            } catch (MissingResourceException mre) {
//                ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
                displayName = displayNameKey;
            }
        } else {
            displayName = displayNameKey;
        }

        return displayName;
    }

    public String _getShortDescription(String bundleName, String tooltipKey, String displayNameKey) {

        String tooltip = null;
        if (tooltipKey != null && bundleName != null) {
            try {
                tooltip = NbBundle.getBundle(bundleName).getString(tooltipKey);
            } catch (Exception ex) {
                ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
            }
            /* This will make sure the tooltips.  I chose to do this here even
             * thou it means that sometimes it may happen twice due to
             * performance.  I prefer that the palette not be dependent on loading
             * all of the body comments.  By doing this, it is only loaded when
             * the category is opened. I wish there was a better way to do this.
             * I would suggest that we never allow the user to use the body as
             * the tooltip, but I guess that is preference.
             */
//        } else if (body != null) {
//
//
//            tooltip = CodeClipUtilities.fillFromBundle(body, bundleName);
//            if (tooltip.length() > 200) {
//                tooltip = tooltip.substring(0, 200);
//            }
//
//            tooltip = tooltip.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br>");
//
//            /*
//             * This is a temporary workaround.
//             * For some reason if the tooltip bigs with / the first line
//             * is removed altogether form the tooltip.  Not sure where this is
//             * happening.
//             */
//            
//            if (tooltip.startsWith("//")) {
//                tooltip = " <br>" + tooltip;
//            }
//
//            tooltip = "<html>".concat(tooltip).concat("</html>");
        } else if (tooltipKey != null ) {
            tooltip = tooltipKey;
            
        } else if( bundleName != null ){
            // no tooltip derived from the item
            tooltip = _getDisplayName(bundleName, displayNameKey);
        } else {
            tooltip = displayNameKey;
        }

        return tooltip;
    }

    public Image _getIcon(String iconURL) {

        Image icon = null;
        try {
            icon = ImageUtilities.loadImage(iconURL);
        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
        }


        return icon;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    /*
     * Edit this codeclip
     * @param none
     */
    public void edit() {
        String oldDisplayName = this.getDisplayName();
        String oldToolTip = this.getShortDescription();
        CodeClipViewerPanel snippetViewer = new CodeClipViewerPanel( this.getDisplayName(), oldToolTip, this.body);
        snippetViewer.setVisible(true);
        if (!snippetViewer.isCancelled()) {
            String newDisplayName = displayNameKey; /* Store the bundle key */
            String myBundleName = this.bundleName;
            String text = snippetViewer.getContentText();
            String title = snippetViewer.getClipName();
            String newToolTip = tooltipKey;
            String toolTip = snippetViewer.getToolTip();
            
            /* If the name has changed then we will stop worry about keys, etc. */
            if( !oldDisplayName.equals(title)) {
                newDisplayName = title;
                if( this.bundleName != null ) /* if this is the first time it is going to null */ {
                    newToolTip = toolTip;
                }
                myBundleName = null; /* If the title has changed, we no longer need the bundle. */
            } 
            if ( !oldToolTip.equals(toolTip)) {
                newToolTip = toolTip;
                if( this.bundleName != null ){
                    newDisplayName = title;
                }
                myBundleName = null;
            }
            try {
                CodeClipUtilities.createCodeClipFile(fileObj.getParent(), text, newDisplayName, myBundleName, newToolTip);
                this.destroy();
            } catch (IOException ex) {
                ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
            }
        }
//        this.setBody(text);
    }

    /*
     * Drop the codeclip on the given text component target
     * @param target JTextComponent or the targeted editor component
     */
    public void drop(JTextComponent target) {

//        if (target == null) {
//            String msg = NbBundle.getMessage(CodeClipItemNode.class, "MSG_ErrorNoFocusedDocument");
//            DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(msg, NotifyDescriptor.ERROR_MESSAGE));
//            return;
//        }
        ActiveEditorDrop drop = (ActiveEditorDrop) getLookup().lookup(ActiveEditorDrop.class);
        drop.handleTransfer(target);
    }
    
       /**
     * Transferable wrapper that does not allow DataFlavors for external drag and drop
     * (FileListFlavor and URI list flavors)
     */
    private static class NoExternalDndTransferable implements Transferable {
        private Transferable t;
        private DataFlavor uriListFlavor;
        public NoExternalDndTransferable( Transferable t ) {
            this.t = t;
        }
    
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = t.getTransferDataFlavors();
            if( t.isDataFlavorSupported( DataFlavor.javaFileListFlavor ) 
                || t.isDataFlavorSupported( getUriListFlavor() ) ) {
                ArrayList<DataFlavor> tmp = new ArrayList<DataFlavor>( flavors.length );
                for( int i=0; i<flavors.length; i++ ) {
                    if( isDataFlavorSupported( flavors[i] ) )
                        tmp.add( flavors[i] );
                }
                flavors = tmp.toArray( new DataFlavor[tmp.size()] );
            }
            return flavors;
        }

        public boolean isDataFlavorSupported( DataFlavor flavor ) {
            if( DataFlavor.javaFileListFlavor.equals( flavor ) || getUriListFlavor().equals( flavor ) )
                return false;
            return t.isDataFlavorSupported(flavor);
        }

        public Object getTransferData( DataFlavor flavor ) throws UnsupportedFlavorException, IOException {
            if( !isDataFlavorSupported(flavor) )
                throw new UnsupportedFlavorException( flavor );
            return t.getTransferData( flavor );
        }
        
        private DataFlavor getUriListFlavor () {
            if( null == uriListFlavor ) {
                try {
                    uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                } catch (ClassNotFoundException ex) {
                    //cannot happen
                    throw new AssertionError(ex);
                }
            }
            return uriListFlavor;
        }
    }
}
