/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */package org.netbeans.modules.vmd.midp.palette.wizard;

import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.vmd.api.io.javame.MidpProjectPropertiesSupport;

import javax.swing.*;
import java.awt.*;
import java.util.Vector;
import org.openide.util.NbBundle;

/**
 * @author David Kaspar
 */
public final class AddToPaletteVisualPanel1 extends JPanel {

    private static final String MSG_NO_PROJECTS = "MSG_ERR_NoOpenedProjects"; // NOI18N 
    
    private AddToPaletteWizardPanel1 wizardPanel;

    public AddToPaletteVisualPanel1 (AddToPaletteWizardPanel1 wizardPanel) {
        this.wizardPanel = wizardPanel;
        initComponents();
    }

    public String getName() {
        return NbBundle.getMessage(AddToPaletteVisualPanel1.class, "TITLE_SelectProject"); // NOI18N
    }

    public Project getActiveProject () {
        Object item = projectCombo.getSelectedItem();
        if (item instanceof Project){
            return (Project)item;
        }
        return null;
    }

    public int getProjectsCount () {
        if (projectCombo.getItemAt(0).equals(MSG_NO_PROJECTS)){
            return 0;
        }
        return projectCombo.getItemCount();
    }

    public void reload (Project project) {
        Project[] projects = OpenProjects.getDefault ().getOpenProjects ();
        Vector projectsVector = new Vector ();
        for (Project prj : projects) {
            if (MidpProjectPropertiesSupport.isMobileProject(prj)) {
                projectsVector.add(prj);
            }
        }
        if(projectsVector.size() == 0){
            projectsVector.add(getMessage(MSG_NO_PROJECTS));
            projectCombo.setEnabled( false );
            projectCombo.setRenderer(new DefaultListCellRenderer());
            projectCombo.setModel(new DefaultComboBoxModel(projectsVector));
        } else {
            projectCombo.setEnabled( true );
            projectCombo.setRenderer (new ProjectListCellRenderer ());
            projectCombo.setModel(new DefaultComboBoxModel(projectsVector));
            setProjectSelection(projects, project);
        }
    }

    private void setProjectSelection(Project[] openedProjects, Project project){
            if (project == null) {
                Project prj = OpenProjects.getDefault().getMainProject();
                if (MidpProjectPropertiesSupport.isMobileProject(prj)) {
                    project = prj;
                }
            }
            if (project == null && openedProjects.length > 0) {
                project = openedProjects[0];
            }
            projectCombo.setSelectedItem(project);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        projectCombo = new javax.swing.JComboBox();
        javax.swing.JLabel jLabel1 = new javax.swing.JLabel();

        projectCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                projectComboActionPerformed(evt);
            }
        });

        jLabel1.setLabelFor(projectCombo);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, NbBundle.getMessage(AddToPaletteVisualPanel1.class, "DISP_SelectProject")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1)
                    .add(projectCombo, 0, 376, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(projectCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(243, Short.MAX_VALUE))
        );

        projectCombo.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(AddToPaletteVisualPanel1.class, "ACCESSIBLE_NAME_projectCombo")); // NOI18N
        projectCombo.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AddToPaletteVisualPanel1.class, "ACCESSIBLE_DESCRIPTION_projectCombo")); // NOI18N
        jLabel1.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(AddToPaletteVisualPanel1.class, "ACCESSIBLE_NAME_jLabel1_2")); // NOI18N
        jLabel1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AddToPaletteVisualPanel1.class, "ACCESSIBLE_DESCRIPTION_jLabel1_2")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

private void projectComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_projectComboActionPerformed
    wizardPanel.fireChangeEvent();
}//GEN-LAST:event_projectComboActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox projectCombo;
    // End of variables declaration//GEN-END:variables

    public static class ProjectListCellRenderer extends DefaultListCellRenderer {

        public Component getListCellRendererComponent (JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null)
                return super.getListCellRendererComponent (list, value, index, isSelected, cellHasFocus);
            ProjectInformation info = ((Project) value).getLookup ().lookup (ProjectInformation.class);
            super.getListCellRendererComponent (list, info != null ? info.getDisplayName () : null, index, isSelected, cellHasFocus);
            if (info != null)
                setIcon (info.getIcon ());
            return this;
        }

    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(AddToPaletteVisualPanel1.class, key);
    }
    
}

