/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */package org.netbeans.modules.vmd.midp.screen.display;

import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsSupport;
import org.openide.util.Utilities;

import javax.swing.*;

/**
 * @author David Kaspar
 */
public class DisplayableDisplayPanel extends javax.swing.JPanel {

    private DisplayableDisplayPresenter presenter;

    /** Creates new form DisplayableDisplayPanel */
    public DisplayableDisplayPanel(DisplayableDisplayPresenter presenter) {
        this.presenter = presenter;
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        headerPanel = new javax.swing.JPanel();
        lBattery = new javax.swing.JLabel();
        lSignal = new javax.swing.JLabel();
        lTicker = new javax.swing.JLabel();
        lTitle = new javax.swing.JLabel();
        contentPanel = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        headerPanel.setBackground(new java.awt.Color(235, 235, 231));
        headerPanel.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        headerPanel.add(lBattery, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        headerPanel.add(lSignal, gridBagConstraints);

        lTicker.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        headerPanel.add(lTicker, gridBagConstraints);

        lTitle.setFont(new java.awt.Font("Dialog", lTitle.getFont().getStyle() | java.awt.Font.BOLD, lTitle.getFont().getSize()));
        lTitle.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        headerPanel.add(lTitle, gridBagConstraints);

        add(headerPanel, java.awt.BorderLayout.PAGE_START);

        contentPanel.setBackground(java.awt.Color.white);
        contentPanel.setBorder(javax.swing.BorderFactory.createLineBorder(java.awt.Color.white));
        add(contentPanel, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel contentPanel;
    private javax.swing.JPanel headerPanel;
    private javax.swing.JLabel lBattery;
    private javax.swing.JLabel lSignal;
    private javax.swing.JLabel lTicker;
    private javax.swing.JLabel lTitle;
    // End of variables declaration//GEN-END:variables

    @Override
    public JPopupMenu getComponentPopupMenu () {
        return Utilities.actionsToPopup (ActionsSupport.createActionsArray (presenter.getRelatedComponent ()), this);
    }

    public JPanel getContentPanel () {
        return contentPanel;
    }

    public JPanel getHeaderPanel () {
        return headerPanel;
    }

    public JLabel getBattery () {
        return lBattery;
    }

    public JLabel getSignal () {
        return lSignal;
    }

    public JLabel getTicker () {
        return lTicker;
    }

    public JLabel getTitle () {
        return lTitle;
    }

}
