/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.websvc.core.dev.wizard;

import java.awt.Dialog;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.core.ServerType;
import org.netbeans.modules.websvc.core.WSStackUtils;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author  radko
 */
public class WebServiceTypePanel extends javax.swing.JPanel implements HelpCtx.Provider, ItemListener {
    
    private Project project;
    private Node[] sessionBeanNodes;
    
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    
    private boolean jsr109Supported;
    private boolean jsr109oldSupported;
    //private boolean jwsdpSupported;
    private boolean jaxWsInJ2ee14Supported;
    private boolean noMetroInstalledOnGlassFishV3;
    private WebModule wm;
    private EjbJar em;
    
    /** Creates new form WebServiceTypePanel */
    public WebServiceTypePanel(Project project) {
        this.project = project;
        
        initComponents();
        
        WSStackUtils stackUtils = new WSStackUtils(project);
        jsr109Supported = stackUtils.isJsr109Supported();
        jsr109oldSupported = stackUtils.isJsr109OldSupported();
        jaxWsInJ2ee14Supported = (ServerType.JBOSS == stackUtils.getServerType());
        noMetroInstalledOnGlassFishV3 = !jsr109Supported && ServerType.GLASSFISH_V3 == stackUtils.getServerType();
        
        //convert Java class not implemented for 5.5 release, disable components
        jRadioButtonConvert.setEnabled(false);
        jLabelConvert.setEnabled(false);
        jTextFieldConvert.setEnabled(false);
        jButtonConvert.setEnabled(false);
        jRadioButtonConvert.setVisible(false);
        jLabelConvert.setVisible(false);
        jTextFieldConvert.setVisible(false);
        jButtonConvert.setVisible(false);
        
        //disable encapsulate session bean for j2se project
        wm = WebModule.getWebModule(project.getProjectDirectory());
        em = EjbJar.getEjbJar(project.getProjectDirectory());
        if ((em == null && wm == null)
        ||  //disable encapsulate session beans for Tomcat
                ((!jsr109Supported && !jsr109oldSupported ||
                (!jsr109Supported && jsr109oldSupported/* && jwsdpSupported*/ ))) ) {
            disableDelegateToEJB();
        }
        
        addItemListener(this);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jRadioButtonScratch = new javax.swing.JRadioButton();
        jRadioButtonDelegate = new javax.swing.JRadioButton();
        jLabelDelegate = new javax.swing.JLabel();
        jTextFieldDelegate = new javax.swing.JTextField();
        jButtonDelegate = new javax.swing.JButton();
        jRadioButtonConvert = new javax.swing.JRadioButton();
        jLabelConvert = new javax.swing.JLabel();
        jTextFieldConvert = new javax.swing.JTextField();
        jButtonConvert = new javax.swing.JButton();

        buttonGroup1.add(jRadioButtonScratch);
        jRadioButtonScratch.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButtonScratch, org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_EmptyWebService")); // NOI18N
        jRadioButtonScratch.setToolTipText(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "HINT_EmptyWebService")); // NOI18N
        jRadioButtonScratch.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonScratch.setMargin(new java.awt.Insets(0, 0, 0, 0));

        buttonGroup1.add(jRadioButtonDelegate);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButtonDelegate, org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_EncapsulateSessionBean")); // NOI18N
        jRadioButtonDelegate.setToolTipText(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "HINT_EnterpriseBean")); // NOI18N
        jRadioButtonDelegate.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonDelegate.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jLabelDelegate.setLabelFor(jTextFieldDelegate);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelDelegate, org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_EnterpriseBean")); // NOI18N
        jLabelDelegate.setToolTipText(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "HINT_EnterpriseBean")); // NOI18N

        jTextFieldDelegate.setEditable(false);
        jTextFieldDelegate.setEnabled(false);

        org.openide.awt.Mnemonics.setLocalizedText(jButtonDelegate, org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_Browse")); // NOI18N
        jButtonDelegate.setToolTipText(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "HINT_BrowseBean")); // NOI18N
        jButtonDelegate.setEnabled(false);
        jButtonDelegate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDelegateActionPerformed(evt);
            }
        });

        buttonGroup1.add(jRadioButtonConvert);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButtonConvert, org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_ConvertJavaClass")); // NOI18N
        jRadioButtonConvert.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonConvert.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jLabelConvert.setLabelFor(jTextFieldConvert);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelConvert, org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_JavaClass")); // NOI18N

        jTextFieldConvert.setEditable(false);
        jTextFieldConvert.setEnabled(false);

        org.openide.awt.Mnemonics.setLocalizedText(jButtonConvert, org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_Browse")); // NOI18N
        jButtonConvert.setEnabled(false);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jRadioButtonScratch)
                .addContainerGap(330, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .add(jRadioButtonDelegate)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .add(17, 17, 17)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabelConvert)
                    .add(jLabelDelegate))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jTextFieldConvert)
                    .add(jTextFieldDelegate))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jButtonConvert)
                    .add(jButtonDelegate)))
            .add(layout.createSequentialGroup()
                .add(jRadioButtonConvert, 0, 497, Short.MAX_VALUE)
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {jLabelConvert, jLabelDelegate}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jRadioButtonScratch)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jRadioButtonDelegate, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 15, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jButtonDelegate)
                    .add(jLabelDelegate)
                    .add(jTextFieldDelegate, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jRadioButtonConvert)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabelConvert)
                    .add(jButtonConvert)
                    .add(jTextFieldConvert, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(184, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    private void jButtonDelegateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDelegateActionPerformed
        Project[] allProjects = getCallableEjbProjects(project);
        List<Node> ejbProjectNodes = new LinkedList<Node>();
        
        for (int i = 0; i < allProjects.length; i++) {
            LogicalViewProvider lvp = allProjects[i].getLookup().lookup(LogicalViewProvider.class);
            Node projectView = lvp.createLogicalView();
            ejbProjectNodes.add(new FilterNode(projectView, new EJBListViewChildren(allProjects[i])) {
                @Override
                public Action[] getActions(boolean context) {
                    return new Action[0];
                }
            });
        }
        
        Children.Array children = new Children.Array();
        children.add(ejbProjectNodes.<Node>toArray(new Node[ejbProjectNodes.size()]));
        Node root = new AbstractNode(children);
        EjbChooser chooser = new EjbChooser(root);
        final DialogDescriptor dd = new DialogDescriptor(chooser, org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_BrowseBean_Title"));
        
        dd.setValid(false);
        chooser.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(EjbChooser.IS_VALID)) {
                    Object newvalue = evt.getNewValue();
                    if ((newvalue != null) && (newvalue instanceof Boolean)) {
                        dd.setValid(((Boolean) newvalue).booleanValue());
                    }
                }
            }
        });
        
        //Object result = DialogDisplayer.getDefault().notify(dd);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.getAccessibleContext().setAccessibleDescription(dlg.getTitle());
        dlg.setVisible(true);
 
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            jTextFieldDelegate.setText(chooser.getSelectedEJBProjectName() + "#" + chooser.getSelectedNodes()[0].getDisplayName());
            sessionBeanNodes = chooser.getSelectedNodes();
            fireChange();
        }
    }//GEN-LAST:event_jButtonDelegateActionPerformed
    
    void validate(WizardDescriptor wizardDescriptor) {
    }
    
    boolean valid(WizardDescriptor wizardDescriptor) {
        //first check for JDK compliance (for non-JSR 109)
        if(!checkNonJsr109Valid(wizardDescriptor)){
            return false;
        }
        boolean noJsr109InWeb = wm != null && !jsr109Supported && !jsr109oldSupported;
        boolean jaxWsInWeb14 = wm != null && jaxWsInJ2ee14Supported;
        if (!Util.isJavaEE5orHigher(project) && !noJsr109InWeb && !jaxWsInWeb14 && WebServicesSupport.getWebServicesSupport(project.getProjectDirectory()) == null) {
            // check if jaxrpc plugin installed
            wizardDescriptor.putProperty(WizardDescriptor.PROP_ERROR_MESSAGE, NbBundle.getMessage(WebServiceFromWSDLPanel.class, "ERR_NoJaxrpcPluginFound")); // NOI18N
            return false;
        }
        
        if (getServiceType() == WizardProperties.ENCAPSULATE_SESSION_BEAN &&
            jTextFieldDelegate.getText().length() == 0) {
            wizardDescriptor.putProperty(WizardDescriptor.PROP_INFO_MESSAGE, NbBundle.getMessage(WebServiceTypePanel.class, "LBL_SelectOneEJB")); //NOI18N
            return false;        
        }
        if (noMetroInstalledOnGlassFishV3) {
            wizardDescriptor.putProperty(WizardDescriptor.PROP_INFO_MESSAGE, NbBundle.getMessage(WebServiceTypePanel.class, "LBL_NoMetroInstalled")); //NOI18N            
        } else {
            wizardDescriptor.putProperty(WizardDescriptor.PROP_ERROR_MESSAGE, ""); //NOI18N
        }
        
        return true;
    }
    
    /**
     * If the project the web service is being created is not on a JSR 109 platform,
     * its Java source level must be at least 1.5
     */
    private boolean checkNonJsr109Valid(WizardDescriptor wizardDescriptor){
        if( (!jsr109Supported && !jsr109oldSupported) || jaxWsInJ2ee14Supported || 
                (!jsr109Supported && jsr109oldSupported/* && jwsdpSupported */)){
            if (Util.isSourceLevel14orLower(project)) {
                wizardDescriptor.putProperty(WizardDescriptor.PROP_ERROR_MESSAGE,
                        NbBundle.getMessage(WebServiceTypePanel.class, "ERR_NeedProperSourceLevel")); // NOI18N
                return false;
            }
        }
        return true;
    }
    
    
    void store(WizardDescriptor d) {
        d.putProperty(WizardProperties.WEB_SERVICE_TYPE, Integer.valueOf(getServiceType()));
        if (getServiceType() == WizardProperties.ENCAPSULATE_SESSION_BEAN)
            d.putProperty(WizardProperties.DELEGATE_TO_SESSION_BEAN, sessionBeanNodes);
    }
    
    void read(WizardDescriptor wizardDescriptor) {
    }
    
    public HelpCtx getHelpCtx() {
        return new HelpCtx(WebServiceTypePanel.class);
    }
    
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src.equals(jRadioButtonScratch)) {
            jButtonDelegate.setEnabled(false);
            jTextFieldDelegate.setEnabled(false);
//convert Java class not implemented for 5.5 release
//            jButtonConvert.setEnabled(false);
//            jTextFieldConvert.setEnabled(false);
        } else if (src.equals(jRadioButtonDelegate)) {
            jButtonDelegate.setEnabled(true);
            jTextFieldDelegate.setEnabled(true);
//convert Java class not implemented for 5.5 release
//            jButtonConvert.setEnabled(false);
//            jTextFieldConvert.setEnabled(false);
        }
//convert Java class not implemented for 5.5 release
//        else if (src.equals(jRadioButtonConvert)) {
//            jButtonDelegate.setEnabled(false);
//            jTextFieldDelegate.setEnabled(false);
//            jButtonConvert.setEnabled(true);
//            jTextFieldConvert.setEnabled(true);
//        }
        
        fireChange();
    }
    
    public void addItemListener(ItemListener l) {
        jRadioButtonScratch.addItemListener(l);
        jRadioButtonDelegate.addItemListener(l);
//convert Java class not implemented for 5.5 release
//        jRadioButtonConvert.addItemListener(l);
    }
    
    public void removeItemListener(ItemListener l) {
        jRadioButtonScratch.removeItemListener(l);
        jRadioButtonDelegate.removeItemListener(l);
//convert Java class not implemented for 5.5 release
//        jRadioButtonConvert.removeItemListener(l);
    }
    
    public int getServiceType() {
        if (jRadioButtonScratch.isSelected())
            return WizardProperties.FROM_SCRATCH;
        else
//        else if (jRadioButtonDelegate.isSelected())
            return WizardProperties.ENCAPSULATE_SESSION_BEAN;
//convert Java class not implemented for 5.5 release
//        else
//            return NewWebServiceWizardIterator.CONVERT_JAVA_CLASS;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButtonConvert;
    private javax.swing.JButton jButtonDelegate;
    private javax.swing.JLabel jLabelConvert;
    private javax.swing.JLabel jLabelDelegate;
    private javax.swing.JRadioButton jRadioButtonConvert;
    private javax.swing.JRadioButton jRadioButtonDelegate;
    private javax.swing.JRadioButton jRadioButtonScratch;
    private javax.swing.JTextField jTextFieldConvert;
    private javax.swing.JTextField jTextFieldDelegate;
    // End of variables declaration//GEN-END:variables
    
    private void disableDelegateToEJB(){
        jRadioButtonDelegate.setEnabled(false);
        jLabelDelegate.setEnabled(false);
        jTextFieldDelegate.setEnabled(false);
        jButtonDelegate.setEnabled(false);
    }
    
    /** Returns list of all EJB projects that can be called from the caller project.
     *
     * @param enterpriseProject the caller enterprise project
     */
    private Project [] getCallableEjbProjects(Project enterpriseProject) {
        Project[] allProjects = OpenProjects.getDefault().getOpenProjects();
        
        boolean isCallerEJBModule = false;
        J2eeModuleProvider callerJ2eeModuleProvider = (J2eeModuleProvider) enterpriseProject.getLookup().lookup(J2eeModuleProvider.class);
        if (callerJ2eeModuleProvider != null && callerJ2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.EJB)) {
            // TODO: HACK - this should be set by calling AntArtifactQuery.findArtifactsByType(p, EjbProjectConstants.ARTIFACT_TYPE_EJBJAR)
            // but now freeform doesn't implement this correctly
            isCallerEJBModule = true;
        }
        // TODO: HACK - this must be solved by freeform's own implementation of EnterpriseReferenceContainer, see issue 57003
        // call ejb should not make this check, all should be handled in EnterpriseReferenceContainer
        boolean isCallerFreeform = enterpriseProject.getClass().getName().equals("org.netbeans.modules.ant.freeform.FreeformProject");
        
        List<Project> filteredResults = new ArrayList<Project>(allProjects.length);
        for (int i = 0; i < allProjects.length; i++) {
            boolean isEJBModule = false;
            J2eeModuleProvider j2eeModuleProvider = allProjects[i].getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider != null && j2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.EJB)) {
                isEJBModule = true;
            }
            if ((isEJBModule && !isCallerFreeform) ||
                    (isCallerFreeform && enterpriseProject.equals(allProjects[i]))) {
                filteredResults.add(allProjects[i]);
            }
        }
        return filteredResults.<Project>toArray(new Project[filteredResults.size()]);
    }
    
    public void addChangeListener(ChangeListener l) {
        listeners.add(l);
    }
    
    public void removeChangeListener(ChangeListener l) {
        listeners.remove(l);
    }
    
    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        Iterator<ChangeListener> it = listeners.iterator();
        while (it.hasNext()) {
            it.next().stateChanged(e);
        }
    }
    
}
