/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2008 Sun Microsystems, Inc.
 */

/*
 * WsimportOptionsPanel.java
 *
 * Created on Sep 15, 2008, 10:02:05 AM
 */
package org.netbeans.modules.websvc.customization.jaxwssettings.panel;

import java.util.ArrayList;
import java.util.List;
//import java.util.Map;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOption;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOptions;

/**
 *
 * @author rico
 */
public class WsimportOptionsPanel extends javax.swing.JPanel {

    private List<WsimportOption> wsimportOptions;
    private List<WsimportOption> jaxbOptions;
    private List<String> reservedOptions;
    private String[] columnNames;
    private WsimportOptions wsimportOptionParent;

    /** Creates new form WsimportOptionsPanel */
    public WsimportOptionsPanel(List<WsimportOption> wsimportOptions, List<WsimportOption> jaxbOptions, WsimportOptions wsimportOptionParent) {

        this.wsimportOptions = wsimportOptions;
        this.jaxbOptions = jaxbOptions;
        this.wsimportOptionParent = wsimportOptionParent;
        columnNames = new String[]{"Option", "Value"};
        reservedOptions = getReservedOptions();
        initComponents();
        
    }

    private List<String> getReservedOptions() {
        if (reservedOptions == null) {
            reservedOptions = new ArrayList<String>();
            reservedOptions.add("destdir");
            reservedOptions.add("wsdl");
            reservedOptions.add("sourcedestdir");
            reservedOptions.add("catalog");
        }
        return reservedOptions;
    }

    public List<WsimportOption> getWsimportOptions(){
        return wsimportOptionsPanel.getOptions();
    }

    public List<WsimportOption> getJaxbOptions(){
        return jaxbOptionsPanel.getOptions();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        wsimportOptionsPanel = new OptionsPanel(columnNames, wsimportOptions, reservedOptions, wsimportOptionParent);
        jaxbOptionsPanel = new OptionsPanel(columnNames, jaxbOptions, null, wsimportOptionParent);
        wsimportLabel = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();

        wsimportLabel.setText(org.openide.util.NbBundle.getMessage(WsimportOptionsPanel.class, "LBL_WSIMPORT_OPTIONS")); // NOI18N

        jLabel2.setText(org.openide.util.NbBundle.getMessage(WsimportOptionsPanel.class, "Label_JAXB_OPTIONS")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jaxbOptionsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(wsimportOptionsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(wsimportLabel)
                    .add(jLabel2))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(wsimportLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(wsimportOptionsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 169, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(jLabel2)
                .add(5, 5, 5)
                .add(jaxbOptionsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 157, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel2;
    private org.netbeans.modules.websvc.customization.jaxwssettings.panel.OptionsPanel jaxbOptionsPanel;
    private javax.swing.JLabel wsimportLabel;
    private org.netbeans.modules.websvc.customization.jaxwssettings.panel.OptionsPanel wsimportOptionsPanel;
    // End of variables declaration//GEN-END:variables
}
