/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.websvc.wsitconf.ui.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.CallbackHandler;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityCheckerRegistry;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.client.subpanels.DynamicCredsPanel;
import org.netbeans.modules.websvc.wsitconf.ui.client.subpanels.KerberosConfigPanel;
import org.netbeans.modules.websvc.wsitconf.ui.client.subpanels.StaticCredsPanel;
import org.netbeans.modules.websvc.wsitconf.ui.client.subpanels.ValidatorsPanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.BindingPanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.KeystorePanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.TruststorePanel;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.X509Token;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public class CallbackPanel extends SectionInnerPanel {

    private Node node;
    private Binding binding;

    private boolean inSync = false;

    private Project project;

    private SectionView view;
    private JaxWsModel jaxwsmodel;
    private WSDLModel serviceModel;

    private String profile;

    private DefaultFormatterFactory tstampff = null;

    private ConfigVersion cfgVersion = null;
    
    public CallbackPanel(SectionView view, Node node, Binding binding, JaxWsModel jaxWsModel, WSDLModel serviceModel) {
        super(view);
        this.view = view;
        this.node = node;
        this.binding = binding;
        this.jaxwsmodel = jaxWsModel;
        this.serviceModel = serviceModel;

        cfgVersion = PolicyModelHelper.getConfigVersion(binding);

        FileObject fo = node.getLookup().lookup(FileObject.class);
        if (fo != null) {
            project = FileOwnerQuery.getOwner(fo);
        }

        tstampff = new DefaultFormatterFactory();
        NumberFormat timestampFormat = NumberFormat.getIntegerInstance();
        timestampFormat.setGroupingUsed(false);
        timestampFormat.setParseIntegerOnly(true);
        timestampFormat.setMaximumIntegerDigits(8);
        timestampFormat.setMaximumFractionDigits(0);
        NumberFormatter timestampFormatter = new NumberFormatter(timestampFormat);
        timestampFormatter.setCommitsOnValidEdit(true);
        timestampFormatter.setMinimum(0);
        timestampFormatter.setMaximum(99999999);
        tstampff.setDefaultFormatter(timestampFormatter);

        initComponents();
        
        samlHandlerField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        samlHandlerLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        devDefaultsChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        cbTimestampLbl.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        cbTimestampField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        cbTimestampField.setFocusLostBehavior(JFormattedTextField.COMMIT_OR_REVERT);

        inSync = true;
        credTypeCombo.removeAllItems();
        credTypeCombo.addItem(ComboConstants.STATIC);
        credTypeCombo.addItem(ComboConstants.DYNAMIC);
        inSync = false;

        addImmediateModifier(samlHandlerField);
        addImmediateModifier(credTypeCombo);
        addImmediateModifier(devDefaultsChBox);
        addImmediateModifier(cbTimestampField);
        
        sync();
    }

    public void sync() {
        inSync = true;

        Binding serviceBinding = PolicyModelHelper.getBinding(serviceModel, binding.getName());
        profile = ProfilesModelHelper.getWSITSecurityProfile(serviceBinding);

        boolean defaultsSupported = ProfilesModelHelper.isClientDefaultSetupSupported(profile);
        boolean defaults = false;
        if (defaultsSupported) {
            defaults = ProfilesModelHelper.isClientDefaultSetupUsed(profile, binding, serviceBinding, project);
        }
        setChBox(devDefaultsChBox, defaults);
        
        String samlCallback = ProprietarySecurityPolicyModelHelper.getCallbackHandler(binding, CallbackHandler.SAML_CBHANDLER);
        if (samlCallback != null) {
            setCallbackHandler(samlCallback);
        }

        String usernameCBH = ProprietarySecurityPolicyModelHelper.getCallbackHandler(binding, CallbackHandler.USERNAME_CBHANDLER);
        if ((usernameCBH != null) && (usernameCBH.length() > 0)) {
            setCredType(ComboConstants.DYNAMIC, defaults);
            credTypeCombo.setSelectedItem(ComboConstants.DYNAMIC);
        } else {
            setCredType(ComboConstants.STATIC, defaults);
            credTypeCombo.setSelectedItem(ComboConstants.STATIC);
        }

        String tsTimeout = ProprietarySecurityPolicyModelHelper.getHandlerTimestampTimeout(binding);
        if (tsTimeout == null) { // no setup exists yet - set the default
            cbTimestampField.setText(ProprietarySecurityPolicyModelHelper.DEFAULT_HANDLER_TIMESTAMP_TIMEOUT);
        } else {
            cbTimestampField.setText(tsTimeout);
        } 
        
        enableDisable();

        inSync = false;
    }

    private void setChBox(JCheckBox chBox, Boolean enable) {
        if (enable == null) {
            chBox.setSelected(false);
        } else {
            chBox.setSelected(enable);
        }
    }

    private JPanel getPanel(String type, boolean defaults) {
        boolean amSec = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(node, jaxwsmodel);

        if (ComboConstants.DYNAMIC.equals(type)) {
            return new DynamicCredsPanel(binding, project, !amSec && !defaults);
        }
        return new StaticCredsPanel(binding, !amSec && !defaults);
    }

    private void setCredType(String credType, boolean defaults) {
        this.remove(credPanel);
        credPanel = getPanel(credType, defaults);

        boolean active = true;
        if (view != null) {
            NodeSectionPanel panel = view.getActivePanel();
            active = (panel == null) ? false : panel.isActive();
        }

        Color c = active ? SectionVisualTheme.getSectionActiveBackgroundColor() : SectionVisualTheme.getDocumentBackgroundColor();
        credPanel.setBackground(c);
        refreshLayout();
    }

    @Override
    public void setValue(javax.swing.JComponent source, Object value) {
        if (inSync) {
            return;
        }
        if (source.equals(credTypeCombo)) {
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(binding, CallbackHandler.USERNAME_CBHANDLER, null, null, true);
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(binding, CallbackHandler.PASSWORD_CBHANDLER, null, null, true);
            setCredType((String) credTypeCombo.getSelectedItem(), devDefaultsChBox.isSelected());
        }

        if (source.equals(samlHandlerField)) {
            String classname = getCallbackHandler();
            if ((classname != null) && (classname.length() == 0)) {
                classname = null;
            }
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(binding, CallbackHandler.SAML_CBHANDLER, classname, null, true);
            return;
        }

        if (source.equals(cbTimestampField)) {
            String timeout = ((Integer) cbTimestampField.getValue()).toString();
            if ((timeout == null) || (timeout.length() == 0) || (ProprietarySecurityPolicyModelHelper.DEFAULT_HANDLER_TIMESTAMP_TIMEOUT.equals(timeout.toString()))) {
                ProprietarySecurityPolicyModelHelper.setHandlerTimestampTimeout(binding, null, true);
            } else {
                ProprietarySecurityPolicyModelHelper.setHandlerTimestampTimeout(binding, timeout, true);
            }
        }
        
        if (source.equals(devDefaultsChBox)) {
            if (devDefaultsChBox.isSelected()) {
                Util.fillDefaults(project, true,true);
                Binding serviceBinding = PolicyModelHelper.getBinding(serviceModel, binding.getName());
                ProfilesModelHelper.setClientDefaults(profile, binding, serviceBinding, project);
                sync();
                refreshLayout();
                ((PanelEnabler)credPanel).enablePanel(false);
                credPanel.revalidate();
                credPanel.repaint();
            } else {
                ((PanelEnabler)credPanel).enablePanel(true);
            }
        }

        enableDisable();
    }

    @Override
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
        enableDisable();
    }

    @Override
    public void rollbackValue(javax.swing.text.JTextComponent source) {
    }

    @Override
    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public javax.swing.JComponent getErrorComponent(String errorId) {
        return null;
    }

    private void enableDisable() {

        boolean amSec = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(node, jaxwsmodel);
        boolean samlRequired = true;
        boolean authRequired = true;


        if (!amSec) {
            devDefaultsChBox.setEnabled(true);
            boolean defaults = devDefaultsChBox.isSelected();

            boolean trustStoreConfigRequired = true;
            boolean keyStoreConfigRequired = true;
            boolean kerberosConfigRequired = false;
            boolean validatorsConfigRequired = (ConfigVersion.CONFIG_1_3 != cfgVersion);
            
            if (ComboConstants.PROF_USERNAME.equals(profile)) {
                    keyStoreConfigRequired = false;
            }
            if (ComboConstants.PROF_MSGAUTHSSL.equals(profile)) {
                    trustStoreConfigRequired = false;
            }
            if (ComboConstants.PROF_KERBEROS.equals(profile)) {
                trustStoreConfigRequired = false;
                keyStoreConfigRequired = false;
                kerberosConfigRequired = true;
            }
            keyStoreButton.setEnabled(keyStoreConfigRequired && !defaults);
            trustStoreButton.setEnabled(trustStoreConfigRequired && !defaults);
            kerberosCfgButton.setEnabled(kerberosConfigRequired && !defaults);
            validatorCfgButton.setEnabled(validatorsConfigRequired && !defaults);

            if (ComboConstants.PROF_USERNAME.equals(profile) || 
                ComboConstants.PROF_STSISSUED.equals(profile) || 
                ComboConstants.PROF_STSISSUEDENDORSE.equals(profile) || 
                ComboConstants.PROF_STSISSUEDCERT.equals(profile) || 
                ComboConstants.PROF_STSISSUEDSUPPORTING.equals(profile) || 
                ComboConstants.PROF_MSGAUTHSSL.equals(profile)) {
                    samlRequired = false;
            }

            if (ComboConstants.PROF_SAMLSSL.equals(profile) || 
                ComboConstants.PROF_SAMLHOLDER.equals(profile) || 
                ComboConstants.PROF_SAMLSENDER.equals(profile)) {
                    authRequired = false;
            }

            credTypeLabel.setEnabled(authRequired && !defaults);
            credTypeCombo.setEnabled(authRequired && !defaults);

            credPanel.setEnabled(authRequired && !defaults);
            Component[] comps = credPanel.getComponents();
            for (Component c : comps) {
                c.setEnabled(authRequired && !defaults);
            }

            samlBrowseButton.setEnabled(samlRequired && !defaults);
            samlHandlerField.setEnabled(samlRequired && !defaults);
            samlHandlerLabel.setEnabled(samlRequired && !defaults);
            
            cbTimestampField.setEnabled(!defaults);
            cbTimestampLbl.setEnabled(!defaults);
            
        } else {
            credPanel.setEnabled(false);
            Component[] comps = credPanel.getComponents();
            for (Component c : comps) {
                c.setEnabled(false);
            }
            credTypeCombo.setEnabled(false);
            credTypeLabel.setEnabled(false);
            devDefaultsChBox.setEnabled(false);
            validatorCfgButton.setEnabled(false);
            jSeparator1.setEnabled(false);
            keyStoreButton.setEnabled(false);
            samlBrowseButton.setEnabled(false);
            samlHandlerField.setEnabled(false);
            samlHandlerLabel.setEnabled(false);
            trustStoreButton.setEnabled(false);
        }
        refreshLayout();
    }

    public static boolean isStoreConfigRequired(String profile, boolean trust, Binding binding) {
        ArrayList<WSDLComponent> compsToTry = new ArrayList<WSDLComponent>();
        compsToTry.add(binding);
        Collection<BindingOperation> ops = binding.getBindingOperations();
        for (BindingOperation op : ops) {
            BindingInput bi = op.getBindingInput();
            if (bi != null) {
                compsToTry.add(bi);
            }
            BindingOutput bo = op.getBindingOutput();
            if (bo != null) {
                compsToTry.add(bo);
            }
            Collection<BindingFault> bfs = op.getBindingFaults();
            for (BindingFault bf : bfs) {
                if (bf != null) {
                    compsToTry.add(bf);
                }
            }
        }

        for (WSDLComponent wc : compsToTry) {
            List<WSDLComponent> suppTokens = SecurityTokensModelHelper.getSupportingTokens(wc);
            if (suppTokens != null) {
                for (WSDLComponent suppToken : suppTokens) {
                    WSDLComponent token = SecurityTokensModelHelper.getTokenTypeElement(suppToken);
                    if (token instanceof X509Token) {
                        return true;
                    }
                }
            }
        }

        if ((ComboConstants.PROF_TRANSPORT.equals(profile)) || (ComboConstants.PROF_SAMLSSL.equals(profile))) {
            return false;
        }
        if (!trust) {
            if (ComboConstants.PROF_USERNAME.equals(profile)) {
                return false;
            }
            if (ComboConstants.PROF_MSGAUTHSSL.equals(profile)) {
                // TODO - depends on other config
            }
        } else {
            if (ComboConstants.PROF_MSGAUTHSSL.equals(profile)) {
                return false;
            }
        }
        return true;
    }
    
    private void setCallbackHandler(String classname) {
        this.samlHandlerField.setText(classname);
    }

    private String getCallbackHandler() {
        return samlHandlerField.getText();
    }

    private void refreshLayout() {
        org.jdesktop.layout.GroupLayout layout = (GroupLayout) this.getLayout();
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(keyStoreButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(trustStoreButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(kerberosCfgButton)
                        .add(6, 6, 6)
                        .add(validatorCfgButton))
                    .add(devDefaultsChBox))
                .add(62, 62, 62))
            .add(layout.createSequentialGroup()
                .add(24, 24, 24)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(credTypeLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(credTypeCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, credPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(samlHandlerLabel)
                                .add(cbTimestampLbl))
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(layout.createSequentialGroup()
                                    .add(samlHandlerField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 209, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .add(samlBrowseButton))
                                .add(cbTimestampField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 78, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                    .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 533, Short.MAX_VALUE))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {kerberosCfgButton, keyStoreButton, trustStoreButton, validatorCfgButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(devDefaultsChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(keyStoreButton)
                    .add(trustStoreButton)
                    .add(kerberosCfgButton)
                    .add(validatorCfgButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(credTypeLabel)
                    .add(credTypeCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(credPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(samlHandlerLabel)
                    .add(samlBrowseButton)
                    .add(samlHandlerField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cbTimestampLbl)
                    .add(cbTimestampField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {kerberosCfgButton, keyStoreButton, trustStoreButton, validatorCfgButton}, org.jdesktop.layout.GroupLayout.VERTICAL);

        samlHandlerLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStorePanel_SamlLabel_ACSN")); // NOI18N
        samlHandlerLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStorePanel_SamlLabel_ACSD")); // NOI18N
        samlBrowseButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_AuthPanel_SCHBrowseButton_ACSN")); // NOI18N
        samlBrowseButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_AuthPanel_SCHBrowseButton_ACSD")); // NOI18N
        credTypeLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStorePanel_AuthTypeLabel_ACSN")); // NOI18N
        credTypeLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStorePanel_AuthTypeLabel_ACSD")); // NOI18N
        keyStoreButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStore_ACSN")); // NOI18N
        keyStoreButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStore_ACSD")); // NOI18N
        trustStoreButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_Truststore_ACSN")); // NOI18N
        trustStoreButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_Truststore_ACSD")); // NOI18N
        devDefaultsChBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_DevDefaults_ACSN")); // NOI18N
        devDefaultsChBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_DevDefaults_ACSD")); // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        samlHandlerLabel = new javax.swing.JLabel();
        samlHandlerField = new javax.swing.JTextField();
        samlBrowseButton = new javax.swing.JButton();
        credTypeCombo = new javax.swing.JComboBox();
        credTypeLabel = new javax.swing.JLabel();
        credPanel = new javax.swing.JPanel();
        keyStoreButton = new javax.swing.JButton();
        trustStoreButton = new javax.swing.JButton();
        devDefaultsChBox = new javax.swing.JCheckBox();
        jSeparator1 = new javax.swing.JSeparator();
        cbTimestampLbl = new javax.swing.JLabel();
        cbTimestampField = new javax.swing.JFormattedTextField();
        kerberosCfgButton = new javax.swing.JButton();
        validatorCfgButton = new javax.swing.JButton();

        addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                formFocusGained(evt);
            }
        });
        addAncestorListener(new javax.swing.event.AncestorListener() {
            public void ancestorMoved(javax.swing.event.AncestorEvent evt) {
            }
            public void ancestorAdded(javax.swing.event.AncestorEvent evt) {
                formAncestorAdded(evt);
            }
            public void ancestorRemoved(javax.swing.event.AncestorEvent evt) {
            }
        });

        samlHandlerLabel.setLabelFor(samlHandlerField);
        org.openide.awt.Mnemonics.setLocalizedText(samlHandlerLabel, org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStorePanel_SamlLabel")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(samlBrowseButton, org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_AuthPanel_SCHBrowseButton")); // NOI18N
        samlBrowseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samlBrowseButtonActionPerformed(evt);
            }
        });

        credTypeCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Static", "Dynamic" }));

        credTypeLabel.setLabelFor(credTypeCombo);
        org.openide.awt.Mnemonics.setLocalizedText(credTypeLabel, org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStorePanel_AuthTypeLabel")); // NOI18N

        org.jdesktop.layout.GroupLayout credPanelLayout = new org.jdesktop.layout.GroupLayout(credPanel);
        credPanel.setLayout(credPanelLayout);
        credPanelLayout.setHorizontalGroup(
            credPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 424, Short.MAX_VALUE)
        );
        credPanelLayout.setVerticalGroup(
            credPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 64, Short.MAX_VALUE)
        );

        org.openide.awt.Mnemonics.setLocalizedText(keyStoreButton, org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStore")); // NOI18N
        keyStoreButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                keyStoreButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(trustStoreButton, org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_Truststore")); // NOI18N
        trustStoreButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                trustStoreButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(devDefaultsChBox, org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_DevDefaults")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbTimestampLbl, org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_CallbackPanel_Timestamp")); // NOI18N

        cbTimestampField.setFormatterFactory(tstampff);

        org.openide.awt.Mnemonics.setLocalizedText(kerberosCfgButton, org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KerberosCfg")); // NOI18N
        kerberosCfgButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                kerberosCfgButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(validatorCfgButton, org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_ValidatorsCfg")); // NOI18N
        validatorCfgButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                validatorCfgButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(keyStoreButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(trustStoreButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(kerberosCfgButton)
                        .add(6, 6, 6)
                        .add(validatorCfgButton))
                    .add(devDefaultsChBox))
                .add(62, 62, 62))
            .add(layout.createSequentialGroup()
                .add(24, 24, 24)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(credTypeLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(credTypeCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, credPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(samlHandlerLabel)
                                .add(cbTimestampLbl))
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(layout.createSequentialGroup()
                                    .add(samlHandlerField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 209, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .add(samlBrowseButton))
                                .add(cbTimestampField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 78, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                    .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 533, Short.MAX_VALUE))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {kerberosCfgButton, keyStoreButton, trustStoreButton, validatorCfgButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(devDefaultsChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(keyStoreButton)
                    .add(trustStoreButton)
                    .add(kerberosCfgButton)
                    .add(validatorCfgButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(credTypeLabel)
                    .add(credTypeCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(credPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(samlHandlerLabel)
                    .add(samlBrowseButton)
                    .add(samlHandlerField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cbTimestampLbl)
                    .add(cbTimestampField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {kerberosCfgButton, keyStoreButton, trustStoreButton, validatorCfgButton}, org.jdesktop.layout.GroupLayout.VERTICAL);

        samlHandlerLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStorePanel_SamlLabel_ACSN")); // NOI18N
        samlHandlerLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStorePanel_SamlLabel_ACSD")); // NOI18N
        samlBrowseButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_AuthPanel_SCHBrowseButton_ACSN")); // NOI18N
        samlBrowseButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_AuthPanel_SCHBrowseButton_ACSD")); // NOI18N
        credTypeLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStorePanel_AuthTypeLabel_ACSN")); // NOI18N
        credTypeLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStorePanel_AuthTypeLabel_ACSD")); // NOI18N
        keyStoreButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStore_ACSN")); // NOI18N
        keyStoreButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_KeyStore_ACSD")); // NOI18N
        trustStoreButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_Truststore_ACSN")); // NOI18N
        trustStoreButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_Truststore_ACSD")); // NOI18N
        devDefaultsChBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_DevDefaults_ACSN")); // NOI18N
        devDefaultsChBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CallbackPanel.class, "LBL_DevDefaults_ACSD")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

private void trustStoreButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_trustStoreButtonActionPerformed
    boolean jsr109 = isJsr109Supported();
    TruststorePanel storePanel = new TruststorePanel(binding, project, jsr109, profile, true, cfgVersion);
    DialogDescriptor dlgDesc = new DialogDescriptor(storePanel, 
            NbBundle.getMessage(BindingPanel.class, "LBL_Truststore_Panel_Title")); //NOI18N
    Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);

    dlg.setVisible(true); 
    if (dlgDesc.getValue() == DialogDescriptor.OK_OPTION) {
        storePanel.storeState();
    }
}//GEN-LAST:event_trustStoreButtonActionPerformed

private void keyStoreButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_keyStoreButtonActionPerformed
    boolean jsr109 = isJsr109Supported();
    KeystorePanel storePanel = new KeystorePanel(binding, project, jsr109, true, cfgVersion);
    DialogDescriptor dlgDesc = new DialogDescriptor(storePanel, 
            NbBundle.getMessage(BindingPanel.class, "LBL_Keystore_Panel_Title")); //NOI18N
    Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);

    dlg.setVisible(true); 

    if (dlgDesc.getValue() == DialogDescriptor.OK_OPTION) {
        storePanel.storeState();
    }
}//GEN-LAST:event_keyStoreButtonActionPerformed

private void formFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_formFocusGained
    enableDisable();
}//GEN-LAST:event_formFocusGained

private void formAncestorAdded(javax.swing.event.AncestorEvent evt) {//GEN-FIRST:event_formAncestorAdded
    enableDisable();
}//GEN-LAST:event_formAncestorAdded

    private boolean isJsr109Supported(){
        J2eePlatform j2eePlatform = Util.getJ2eePlatform(project);
        if (j2eePlatform != null){
            Collection<WSStack> wsStacks = (Collection<WSStack>)
                    j2eePlatform.getLookup().lookupAll(WSStack.class);
            for (WSStack stack : wsStacks) {
                if (stack.isFeatureSupported(JaxWs.Feature.JSR109)) {
                    return true;
                }
            }
        }
        return false;
    }
    
    private void samlBrowseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samlBrowseButtonActionPerformed
        if (project != null) {
            ClassDialog classDialog = new ClassDialog(project, "javax.security.auth.callback.CallbackHandler"); //NOI18N
            classDialog.show();
            if (classDialog.okButtonPressed()) {
                Set<String> selectedClasses = classDialog.getSelectedClasses();
                for (String selectedClass : selectedClasses) {
                    setCallbackHandler(selectedClass);
                    ProprietarySecurityPolicyModelHelper.setCallbackHandler(binding, CallbackHandler.SAML_CBHANDLER, selectedClass, null, true);
                    break;
                }
            }
        }
    }//GEN-LAST:event_samlBrowseButtonActionPerformed

    private void kerberosCfgButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_kerberosCfgButtonActionPerformed
        KerberosConfigPanel panel = new KerberosConfigPanel(binding, project);
        DialogDescriptor dlgDesc = new DialogDescriptor(panel, 
                NbBundle.getMessage(BindingPanel.class, "LBL_KerberosConfig_Panel_Title")); //NOI18N
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);

        dlg.setVisible(true); 

        if (dlgDesc.getValue() == DialogDescriptor.OK_OPTION) {
            panel.storeState();
        }
}//GEN-LAST:event_kerberosCfgButtonActionPerformed

    private void validatorCfgButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_validatorCfgButtonActionPerformed
        ValidatorsPanel panel = new ValidatorsPanel(binding, project);
        DialogDescriptor dlgDesc = new DialogDescriptor(panel,
                NbBundle.getMessage(BindingPanel.class, "LBL_KerberosConfig_Panel_Title")); //NOI18N
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);

        dlg.setVisible(true);

        if (dlgDesc.getValue() == DialogDescriptor.OK_OPTION) {
            panel.storeState();
        }
}//GEN-LAST:event_validatorCfgButtonActionPerformed
        
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JFormattedTextField cbTimestampField;
    private javax.swing.JLabel cbTimestampLbl;
    private javax.swing.JPanel credPanel;
    private javax.swing.JComboBox credTypeCombo;
    private javax.swing.JLabel credTypeLabel;
    private javax.swing.JCheckBox devDefaultsChBox;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JButton kerberosCfgButton;
    private javax.swing.JButton keyStoreButton;
    private javax.swing.JButton samlBrowseButton;
    private javax.swing.JTextField samlHandlerField;
    private javax.swing.JLabel samlHandlerLabel;
    private javax.swing.JButton trustStoreButton;
    private javax.swing.JButton validatorCfgButton;
    // End of variables declaration//GEN-END:variables
    
}
