/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xml.tools.java.generator;

import org.netbeans.modules.xml.tools.generator.*;
import java.awt.*;
import javax.swing.*;

import org.netbeans.modules.xml.lib.A11YUtil;
import org.openide.util.NbBundle;

/**
 * A panel allowing to customize SAX generator i.e. setting file locations and element mapping.
 * <p>
 * The UI performs name checks and colors appropriate input fields giving a user feedback.
 *
 * @author  Petr Kuzel
 * @version 1.0
 */
public final class SAXGeneratorFilePanel extends SAXGeneratorAbstractPanel implements java.awt.event.ActionListener {

    /** Serial Version UID */
    private static final long serialVersionUID =-8950908568784619306L;  
        
    private static final Util.NameCheck check = Util.JAVA_CHECK;
   
    private java.util.ResourceBundle bundle = org.openide.util.NbBundle.getBundle(SAXGeneratorFilePanel.class);

    /** Creates new form SAXGeneratorCustomizer */
    public SAXGeneratorFilePanel() {
//        try {
//            this.putClientProperty(WizardDescriptor.PROP_HELP_URL, new URL("nbresloc:/org/netbeans/modules/xml/tools/generator/SAXGeneratorFilePanel.html"));  //NOI18N
//        } catch (MalformedURLException ex) {
//        }
    }
    
    private final ValidatingTextField.Validator NAME_VALIDATOR = new ValidatingTextField.Validator() {
        public boolean isValid(String value) {
            boolean ret = check.checkName(value);
            if (ret) {
                setValid(checkNames());
            } else {
                setValid(false);
            }
            
            return ret;
        }
        
        public String getReason() {
            return NbBundle.getMessage(SAXGeneratorFilePanel.class, "MSG_file_err_1");
        }
    };
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        descTextArea = new javax.swing.JTextArea();
        interfaceLabel = new javax.swing.JLabel();
        interfaceTextField = new org.netbeans.modules.xml.tools.generator.ValidatingTextField();
        stubLabel = new javax.swing.JLabel();
        stubTextField = new org.netbeans.modules.xml.tools.generator.ValidatingTextField();
        parsletLabel = new javax.swing.JLabel();
        parsletTextField = new org.netbeans.modules.xml.tools.generator.ValidatingTextField();
        parsletImplLabel = new javax.swing.JLabel();
        parsletImplTextField = new org.netbeans.modules.xml.tools.generator.ValidatingTextField();
        saveCheckBox = new javax.swing.JCheckBox();
        saveLabel = new javax.swing.JLabel();
        saveTextField = new org.netbeans.modules.xml.tools.generator.ValidatingTextField();
        handlerImplLabel = new javax.swing.JLabel();
        handlerImplTextField = new org.netbeans.modules.xml.tools.generator.ValidatingTextField();

        setName(NbBundle.getMessage(SAXGeneratorFilePanel.class, "SAXGeneratorFilePanel.Form.name")); // NOI18N
        setPreferredSize(new java.awt.Dimension(480, 350));
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentHidden(java.awt.event.ComponentEvent evt) {
                formComponentHidden(evt);
            }
        });
        addContainerListener(new java.awt.event.ContainerAdapter() {
            public void componentRemoved(java.awt.event.ContainerEvent evt) {
                formComponentRemoved(evt);
            }
        });

        descTextArea.setEditable(false);
        descTextArea.setFont(javax.swing.UIManager.getFont ("Label.font"));
        descTextArea.setForeground(new java.awt.Color(102, 102, 153));
        descTextArea.setLineWrap(true);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/xml/tools/java/generator/Bundle"); // NOI18N
        descTextArea.setText(bundle.getString("DESC_saxw_files")); // NOI18N
        descTextArea.setWrapStyleWord(true);
        descTextArea.setDisabledTextColor(javax.swing.UIManager.getColor ("Label.foreground"));
        descTextArea.setEnabled(false);
        descTextArea.setOpaque(false);

        interfaceLabel.setLabelFor(interfaceTextField);
        org.openide.awt.Mnemonics.setLocalizedText(interfaceLabel, org.openide.util.NbBundle.getMessage(SAXGeneratorFilePanel.class, "SAXGeneratorCustomizer.interfaceLabel.text")); // NOI18N

        stubLabel.setLabelFor(stubTextField);
        org.openide.awt.Mnemonics.setLocalizedText(stubLabel, org.openide.util.NbBundle.getMessage(SAXGeneratorFilePanel.class, "SAXGeneratorCustomizer.stubLabel.text")); // NOI18N

        parsletLabel.setLabelFor(parsletTextField);
        org.openide.awt.Mnemonics.setLocalizedText(parsletLabel, org.openide.util.NbBundle.getMessage(SAXGeneratorFilePanel.class, "SAXGeneratorCustomizer.parsletLabel.text")); // NOI18N

        parsletTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                parsletTextFieldActionPerformed(evt);
            }
        });

        parsletImplLabel.setLabelFor(parsletImplTextField);
        org.openide.awt.Mnemonics.setLocalizedText(parsletImplLabel, org.openide.util.NbBundle.getMessage(SAXGeneratorFilePanel.class, "SAXGeneratorFilePanel.parsletImplLabel.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(saveCheckBox, org.openide.util.NbBundle.getMessage(SAXGeneratorFilePanel.class, "PROP_save_it")); // NOI18N

        saveLabel.setLabelFor(saveTextField);
        org.openide.awt.Mnemonics.setLocalizedText(saveLabel, org.openide.util.NbBundle.getMessage(SAXGeneratorFilePanel.class, "PROP_bindings_label")); // NOI18N

        saveTextField.setEditable(false);

        org.openide.awt.Mnemonics.setLocalizedText(handlerImplLabel, org.openide.util.NbBundle.getMessage(SAXGeneratorFilePanel.class, "SAXGeneratorCustomizer.implementationLabel.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(saveCheckBox, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 700, Short.MAX_VALUE)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                            .add(saveLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 230, Short.MAX_VALUE)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(saveTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                            .add(parsletImplLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(parsletImplTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                            .add(parsletLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 230, Short.MAX_VALUE)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(parsletTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(handlerImplLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .add(interfaceLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 138, Short.MAX_VALUE)
                                .add(stubLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 230, Short.MAX_VALUE))
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                .add(stubTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .add(handlerImplTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .add(interfaceTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 275, Short.MAX_VALUE))))
                    .add(descTextArea, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 696, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(descTextArea, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(35, 35, 35)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(interfaceLabel)
                    .add(interfaceTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(27, 27, 27)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(handlerImplLabel)
                    .add(handlerImplTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(27, 27, 27)
                        .add(stubLabel))
                    .add(layout.createSequentialGroup()
                        .add(18, 18, 18)
                        .add(stubTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(parsletLabel)
                    .add(parsletTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(parsletImplLabel)
                    .add(parsletImplTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(18, 18, 18)
                .add(saveCheckBox)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(18, 18, 18)
                        .add(saveLabel))
                    .add(layout.createSequentialGroup()
                        .add(1, 1, 1)
                        .add(saveTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
        
    private void formComponentHidden(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentHidden
        updateModel();  //??? does not occur
    }//GEN-LAST:event_formComponentHidden
  
    private void formComponentRemoved(java.awt.event.ContainerEvent evt) {//GEN-FIRST:event_formComponentRemoved
        updateModel();  //??? does not occur
    }//GEN-LAST:event_formComponentRemoved

private void parsletTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_parsletTextFieldActionPerformed
// TODO add your handling code here:
}//GEN-LAST:event_parsletTextFieldActionPerformed
  
    protected void updateModel() {
        model.setHandler(interfaceTextField.getText());
        model.setParslet(parsletTextField.getText());
        model.setStub(stubTextField.getText());
        model.setParsletImpl(parsletImplTextField.getText());
        model.setHandlerImpl(handlerImplTextField.getText());
        model.setBindnings(saveCheckBox.isSelected() ? saveTextField.getText() : null);
    }
  
  
    protected void initView() {
        initComponents();
                    
        interfaceTextField.setText(model.getHandler());
        stubTextField.setText(model.getStub());
        handlerImplTextField.setText(model.getHandlerImpl());        
        parsletTextField.setText(model.getParslet());
        parsletImplTextField.setText(model.getParsletImpl());
        saveTextField.setText(model.getBindings());

        interfaceTextField.setValidator(NAME_VALIDATOR);
        stubTextField.setValidator(NAME_VALIDATOR);
        handlerImplTextField.setValidator(NAME_VALIDATOR);
        parsletTextField.setValidator(NAME_VALIDATOR);
        parsletImplTextField.setValidator(NAME_VALIDATOR);
        
        saveCheckBox.setSelected(model.getBindings() != null);
        
        initAccessibility();
    }
  
    protected void updateView() {
        
        parsletTextField.setVisible(hasParslets());
        parsletLabel.setVisible(hasParslets());
        parsletImplTextField.setVisible(hasParslets());
        parsletImplLabel.setVisible(hasParslets());
        
        doLayout();
        setValid(checkNames());
        
    }
  
    /** Get notified by DialigDescriptor */
    public void actionPerformed(java.awt.event.ActionEvent p1) {
        updateModel();
    }
  
    //
    // Check all entered names
    //
    private boolean checkNames() {

        return  check.checkName(interfaceTextField.getText()) 
                && (not(hasParslets()) || check.checkName(parsletTextField.getText()))
                && check.checkName(stubTextField.getText())
                && (not(hasParslets()) || check.checkName(parsletImplTextField.getText()))
                && check.checkName(handlerImplTextField.getText());
       
       // return false;
    }

    private boolean hasParslets() {
        return (model.getParsletBindings().isEmpty() == false);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea descTextArea;
    private javax.swing.JLabel handlerImplLabel;
    private org.netbeans.modules.xml.tools.generator.ValidatingTextField handlerImplTextField;
    private javax.swing.JLabel interfaceLabel;
    private org.netbeans.modules.xml.tools.generator.ValidatingTextField interfaceTextField;
    private javax.swing.JLabel parsletImplLabel;
    private org.netbeans.modules.xml.tools.generator.ValidatingTextField parsletImplTextField;
    private javax.swing.JLabel parsletLabel;
    private org.netbeans.modules.xml.tools.generator.ValidatingTextField parsletTextField;
    private javax.swing.JCheckBox saveCheckBox;
    private javax.swing.JLabel saveLabel;
    private org.netbeans.modules.xml.tools.generator.ValidatingTextField saveTextField;
    private javax.swing.JLabel stubLabel;
    private org.netbeans.modules.xml.tools.generator.ValidatingTextField stubTextField;
    // End of variables declaration//GEN-END:variables

    /** Initialize accesibility
     */
    public void initAccessibility(){

        interfaceTextField.getAccessibleContext().setAccessibleDescription(
                NbBundle.getMessage(SAXGeneratorFilePanel.class, "ACSD_interfaceTextField"));        
        handlerImplTextField.getAccessibleContext().setAccessibleDescription(
                NbBundle.getMessage(SAXGeneratorFilePanel.class, "ACSD_handlerImplTextField"));
        stubTextField.getAccessibleContext().setAccessibleDescription(
                NbBundle.getMessage(SAXGeneratorFilePanel.class, "ACSD_stubTextField"));
        parsletTextField.getAccessibleContext().setAccessibleDescription(
                NbBundle.getMessage(SAXGeneratorFilePanel.class, "ACSD_parsletTextField"));
        parsletImplTextField.getAccessibleContext().setAccessibleDescription(
                NbBundle.getMessage(SAXGeneratorFilePanel.class, "ACSD_parsletImplTextField"));
        
        saveTextField.getAccessibleContext().setAccessibleDescription(
                NbBundle.getMessage(SAXGeneratorFilePanel.class, "ACSD_saveTextField"));
        saveTextField.addFocusListener(A11YUtil.getA11YJTextFieldSupport());
        
        saveCheckBox.getAccessibleContext().setAccessibleDescription(
                NbBundle.getMessage(SAXGeneratorFilePanel.class, "ACSD_saveCheckBox"));
        saveCheckBox.getAccessibleContext().setAccessibleName(
                NbBundle.getMessage(SAXGeneratorFilePanel.class, "ACSN_saveCheckBox"));   
        
        this.getAccessibleContext().setAccessibleDescription(
                NbBundle.getMessage(SAXGeneratorFilePanel.class, "ACSD_SAXGeneratorFilePanel"));
    }    
}
