/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.xml.wsdl.ui.view.property;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.ListModel;

import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

/**
 *
 * @author  skini
 */
public class ParameterOrderPropertyPanel extends javax.swing.JPanel {
    
    /**
     * Creates new form ParameterOrderPropertyPanel
     */
    public ParameterOrderPropertyPanel(Operation operation, PropertyEnv env) {
        mOperation = operation;
        mSelectedParts = new Vector<String>();
        mParts = getAllMessageParts(mSelectedParts);
        mEnv = env;
        mEnv.setState(PropertyEnv.STATE_INVALID);
        initComponents();
        addBtn.setEnabled(false);
        removeBtn.setEnabled(false);
        moveUpBtn.setEnabled(false);
        moveDownBtn.setEnabled(false);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        currParamLabel = new javax.swing.JLabel();
        availParamLabel = new javax.swing.JLabel();
        availScrollPane = new javax.swing.JScrollPane();
        availParamList = new javax.swing.JList();
        currScrollPane = new javax.swing.JScrollPane();
        currParamList = new javax.swing.JList();
        moveUpBtn = new javax.swing.JButton();
        moveDownBtn = new javax.swing.JButton();
        addBtn = new javax.swing.JButton();
        removeBtn = new javax.swing.JButton();

        setName("Form"); // NOI18N

        currParamLabel.setLabelFor(currParamList);
        org.openide.awt.Mnemonics.setLocalizedText(currParamLabel, NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.currParamLabel.text")); // NOI18N
        currParamLabel.setToolTipText(NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.currParamLabel.toolTipText")); // NOI18N
        currParamLabel.setName("currParamLabel"); // NOI18N

        availParamLabel.setLabelFor(availParamList);
        org.openide.awt.Mnemonics.setLocalizedText(availParamLabel, NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.availParamLabel.text")); // NOI18N
        availParamLabel.setToolTipText(NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.availParamLabel.toolTipText")); // NOI18N
        availParamLabel.setName("availParamLabel"); // NOI18N

        availScrollPane.setName("availScrollPane"); // NOI18N

        availParamList.setModel(new DefaultComboBoxModel(mParts));
        availParamList.setToolTipText(NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.availParamList.toolTipText")); // NOI18N
        availParamList.setName("availParamList"); // NOI18N
        availParamList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                availParamListValueChanged(evt);
            }
        });
        availScrollPane.setViewportView(availParamList);
        availParamList.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.availParamList.AccessibleContext.accessibleName")); // NOI18N
        availParamList.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.availParamList.toolTipText")); // NOI18N

        currScrollPane.setName("currScrollPane"); // NOI18N

        currParamList.setModel(new DefaultComboBoxModel(mSelectedParts));
        currParamList.setToolTipText(NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.currParamList.toolTipText")); // NOI18N
        currParamList.setName("currParamList"); // NOI18N
        currParamList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                currParamListValueChanged(evt);
            }
        });
        currScrollPane.setViewportView(currParamList);
        currParamList.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.currParamList.AccessibleContext.accessibleName")); // NOI18N
        currParamList.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.currParamList.toolTipText")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(moveUpBtn, NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.moveUpBtn.text")); // NOI18N
        moveUpBtn.setToolTipText(NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.moveUpBtn.toolTipText")); // NOI18N
        moveUpBtn.setDefaultCapable(false);
        moveUpBtn.setName("moveUpBtn"); // NOI18N
        moveUpBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveUpBtnActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(moveDownBtn, NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.moveDownBtn.text")); // NOI18N
        moveDownBtn.setToolTipText(NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.moveDownBtn.toolTipText")); // NOI18N
        moveDownBtn.setName("moveDownBtn"); // NOI18N
        moveDownBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveDownBtnActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(addBtn, NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.addBtn.text")); // NOI18N
        addBtn.setToolTipText(NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.addBtn.toolTipText")); // NOI18N
        addBtn.setName("addBtn"); // NOI18N
        addBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addBtnActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(removeBtn, NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.removeBtn.text")); // NOI18N
        removeBtn.setToolTipText(NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.removeBtn.toolTipText")); // NOI18N
        removeBtn.setName("removeBtn"); // NOI18N
        removeBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeBtnActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(currParamLabel)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(availScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 214, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, currScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 214, Short.MAX_VALUE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                    .add(addBtn, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .add(moveDownBtn, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .add(moveUpBtn, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 110, Short.MAX_VALUE))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 6, Short.MAX_VALUE))
                            .add(removeBtn, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 116, Short.MAX_VALUE)))
                    .add(availParamLabel))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(currParamLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(moveUpBtn)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(moveDownBtn)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 61, Short.MAX_VALUE)
                        .add(removeBtn))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, currScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 136, Short.MAX_VALUE))
                .add(6, 6, 6)
                .add(availParamLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(availScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 133, Short.MAX_VALUE)
                    .add(addBtn))
                .addContainerGap())
        );

        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.Form.AccessibleContext.accessibleName")); // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ParameterOrderPropertyPanel.class, "ParameterOrderPropertyPanel.Form.AccessibleContext.accessibleDescription")); // NOI18N
        getAccessibleContext().setAccessibleParent(this);
    }// </editor-fold>//GEN-END:initComponents
    
    private void moveDownBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveDownBtnActionPerformed
        enableOKButton();
        int[] selectedIndices = currParamList.getSelectedIndices();
        for (int i = 0; i < selectedIndices.length; i++) {
            DefaultComboBoxModel model = (DefaultComboBoxModel) currParamList.getModel();
            Object removedObj = model.getElementAt(selectedIndices[i]);
            model.removeElementAt(selectedIndices[i]);
            selectedIndices[i]++;
            model.insertElementAt(removedObj, selectedIndices[i]);
        }
        currParamList.setSelectedIndices(selectedIndices);
}//GEN-LAST:event_moveDownBtnActionPerformed
    
    private void moveUpBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveUpBtnActionPerformed
        enableOKButton();
        int[] selectedIndices = currParamList.getSelectedIndices();
        for (int i = 0; i < selectedIndices.length; i++) {
            DefaultComboBoxModel model = (DefaultComboBoxModel) currParamList.getModel();
            Object removedObj = model.getElementAt(selectedIndices[i]);
            model.removeElementAt(selectedIndices[i]);
            selectedIndices[i]--;
            model.insertElementAt(removedObj, selectedIndices[i]);
        }
        currParamList.setSelectedIndices(selectedIndices);
}//GEN-LAST:event_moveUpBtnActionPerformed
    
    private void removeBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeBtnActionPerformed
        enableOKButton();
        Object[] selectedObjects = currParamList.getSelectedValues();
        int[] selectedIndices = new int[selectedObjects.length];
        int count = 0;
        for (Object selectedObject : selectedObjects) {
            ((DefaultComboBoxModel) currParamList.getModel()).removeElement(selectedObject);
            ((DefaultComboBoxModel) availParamList.getModel()).addElement(selectedObject);
            selectedIndices[count++] = availParamList.getModel().getSize() - 1;
        }
        availParamList.setSelectedIndices(selectedIndices);
        
}//GEN-LAST:event_removeBtnActionPerformed
    
    private void addBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addBtnActionPerformed
        enableOKButton();
        Object[] selectedObjects = availParamList.getSelectedValues();
        int[] selectedIndices = new int[selectedObjects.length];
        int count = 0;
        for (Object selectedObject : selectedObjects) {
            ((DefaultComboBoxModel) availParamList.getModel()).removeElement(selectedObject);
            ((DefaultComboBoxModel) currParamList.getModel()).addElement(selectedObject);
            selectedIndices[count++] = currParamList.getModel().getSize() - 1;
        }
        currParamList.setSelectedIndices(selectedIndices);
}//GEN-LAST:event_addBtnActionPerformed
    
    private void currParamListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_currParamListValueChanged
        JList list = (JList) evt.getSource();
        if (!list.getValueIsAdjusting()) {
            int[] si = list.getSelectedIndices();
            if (si != null && si.length > 0) {
                removeBtn.setEnabled(true);
                moveUpBtn.setEnabled(true);
                moveDownBtn.setEnabled(true);
            } else {
                removeBtn.setEnabled(false);
                moveUpBtn.setEnabled(false);
                moveDownBtn.setEnabled(false);
            }
            
            if (si.length > 0) {
                
                if (si[si.length - 1] < list.getModel().getSize() - 1) {
                    moveDownBtn.setEnabled(true);
                } else {
                    moveDownBtn.setEnabled(false);
                }
                
                if (si[0] > 0) {
                    moveUpBtn.setEnabled(true);
                } else {
                    moveUpBtn.setEnabled(false);
                }
                
            }
        }
}//GEN-LAST:event_currParamListValueChanged
    
    private void availParamListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_availParamListValueChanged
        JList list = (JList) evt.getSource();
        if (!list.getValueIsAdjusting()) {
            Object[] sv = list.getSelectedValues();
            if (sv != null && sv.length > 0) {
                addBtn.setEnabled(true);
            } else {
                addBtn.setEnabled(false);
            }
        }
}//GEN-LAST:event_availParamListValueChanged
    
    
    
    private void enableOKButton() {
        mEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
    }
    
    public String getParameterOrder() {
        ListModel model = currParamList.getModel();
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < model.getSize(); i++) {
            String delegate = (String) model.getElementAt(i);
            strBuf.append(delegate.toString()).append(" ");
        }
        return strBuf.toString().trim();
    }
    
    
    private Vector<String> getAllMessageParts(Vector<String> selectedParameters) {
        Set<String> allPartsSet = new HashSet<String>();
        
        Input input = mOperation.getInput();
        Output output = this.mOperation.getOutput();
        Vector<String> allParts = new Vector<String>();
        if(input != null) {
            NamedComponentReference<Message> messageRef = input.getMessage();
            if(messageRef != null && messageRef.get() != null) {
                allParts.addAll(getAllMessageParts(messageRef.get(), allPartsSet));
            }
        }
        
        if(output != null) {
            NamedComponentReference<Message> messageRef = output.getMessage();
            if(messageRef != null && messageRef.get() != null) {
                allParts.addAll(getAllMessageParts(messageRef.get(), allPartsSet));
            }
        }
        
        
        
        //REmove the ones that are already selected
        selectedParameters.clear();
        
        
        List<String> parameterOrder = mOperation.getParameterOrder();
        if (parameterOrder != null) {
            for (String part : parameterOrder) {
                if (!allPartsSet.contains(part)) {
                    parameterOrder.remove(part);
                }
            }
            allParts.removeAll(parameterOrder);
            selectedParameters.addAll(parameterOrder);
        }
        
        return allParts;
    }
    
    private Vector<String> getAllMessageParts(Message message, Set<String> allParts) {
        Vector<String> parts = new Vector<String>();
        Collection<Part> msgParts = message.getParts();
        if (msgParts != null) {
            for (Part part : msgParts) {
                String pd = part.getName();
                if (!allParts.contains(pd)) {
                    parts.add(pd);
                    allParts.add(pd);
                }
            }
        }
        return parts;
    }
    
   
    private Operation mOperation;
    private Vector<String> mParts;
    private Vector<String> mSelectedParts;
    private PropertyEnv mEnv;
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addBtn;
    private javax.swing.JLabel availParamLabel;
    private javax.swing.JList availParamList;
    private javax.swing.JScrollPane availScrollPane;
    private javax.swing.JLabel currParamLabel;
    private javax.swing.JList currParamList;
    private javax.swing.JScrollPane currScrollPane;
    private javax.swing.JButton moveDownBtn;
    private javax.swing.JButton moveUpBtn;
    private javax.swing.JButton removeBtn;
    // End of variables declaration//GEN-END:variables
    
}
