djd43.registerModulePath("rdj", "../../../../rest/rdj");
djd43.require("rdj.widget.ResourcesTable");
djd43.require("rdj.data.CustomersStore");

// define the namespaces
jmaki.namespace("jmaki.widgets.dojo.rest.customerstable");

var resourcesTable;
var restStore;
var restTopic;
var _proxy = "";

jmaki.widgets.dojo.rest.customerstable.Widget = function(wargs) {

    var _widget = this;
    var columns = [];
    var uuid = wargs.uuid;
    var topic = "/dojo/rest/customerstable";
    var subscribe = ["/dojo/rest/customerstable", "/table"];
    var filter = "jmaki.filters.tableModelFilter";
    var counter = 0;
    var container = document.getElementById(uuid);
    var table;
    var showedModelWarning = false;
    
    function showModelDeprecation() {
        if (!showedModelWarning) {
             jmaki.log("Dojo rest customerstable widget uses the incorrect data format. " +
                       "Please see <a href='http://wiki.java.net/bin/view/Projects/jMakiTableDataModel'>" +
                       "http://wiki.java.net/bin/view/Projects/jMakiTableDataModel</a> for the proper format.");
             showedModelWarning = true;
        }   
    }
    
    function genId() {
        return wargs.uuid + "_nid_" + counter++;
    }
         
    rjsSupport.debug('Rest scripts initialized...');

    if (wargs.args) {
        if (wargs.args.topic) {
            topic = wargs.args.topic;
	    jmaki.log("Dojo rest customerstable: widget uses deprecated topic property. Use publish instead. ");
        }
        if (wargs.args.filter) {
           filter = wargs.args.filter;
        }        
    }
    if (wargs.publish ) {
	topic = wargs.publish;
     }
     
    if (wargs.subscribe){
        if (typeof wargs.subscribe == "string") {
            subscribe = [];
            subscribe.push(wargs.subscribe);
        } else {
            subscribe = wargs.subscribe;
        }
    }
    
    restTopic = topic;
    
    // initialize the widget
    this.init = function() {   
        // backwards compatibility
        if (typeof columns[0] != 'object') { 
            showedModelWarning();
        } else if (_widget.rows.length > 0 && _widget.rows[0] instanceof Array) {
            showedModelWarning();
        }           
        table = djd43.widget.createWidget("rdj:ResourcesTable",{valueField: "id"},container);
         
        // provide generic column names if they were not provided.
        for (var l = 0; l < columns.length; l++) {
            var c = columns[l];
            if (!c.id)c.id = l + "" ;              
            c.field =  c.id;
            if (c.title)  c.label = c.title;
            c.dataType = "String";
        }
        
        for (var x = 0; x < columns.length; x++) {
            table.columns.push(table.createMetaData(columns[x]));
        }
        
        var data = [];

        // add an Id for everything as it is needed for sorting
        for (var i=0; i < _widget.rows.length; i++) {
            var nRow;
 
            if (!(_widget.rows[i] instanceof Array)) {
              nRow = _widget.rows[i];
            } else {
               nRow = {};
               for (var cl = 0; cl < columns.length; cl++) { 
                   nRow[columns[cl].id] = _widget.rows[i][cl];
                }
            }
            if (typeof _widget.rows[i].id == "undefined") {          
                nRow.id = genId();
            } else {
                nRow.id = _widget.rows[i].id;
            }
            data.push(nRow);
        }
        table.store.setData(data);
        djd43.event.connect(table, "onSelect", _widget, "onSelect");
        djd43.event.connect(table, "onCellUpdate", _widget, "onCellUpdate");        
    }

   
      // set columns from the widget arguments if provided.
    if (wargs.args && wargs.args.columns) {
        columns = wargs.args.columns;     
    }
    
    // pull in the arguments
    if (wargs.value) {
        // convert value if a jmakiRSS type
        if (wargs.value.dataType == 'jmakiRSS') {
           wargs.value = jmaki.filter(wargs.value, filter);
        }
        if (wargs.value.rows){
            _widget.rows = wargs.value.rows;
        } else if (wargs.value instanceof  Array) {
            _widget.rows = wargs.value;
        }
        if (wargs.value.columns) {
            columns = wargs.value.columns;
        }
        _widget.init();
        
    } else if (wargs.service) {
        if(wargs.args) {
            var args = wargs.args.split(";");
            if(args.length > 0) {
              var proxyE = args[0].split('=');
              if(proxyE[0] == 'proxy')
              _proxy = proxyE[1];
            }
        }
        table = rdj.initResource(wargs.service, _widget, container);
    } else {
        djd43.io.bind({
            url: wargs.widgetDir + "/widget.json",
            method: "get",
            mimetype: "text/json",
            load: function (type,data,evt) {
                if (data == false) {
                    container.innerHTML = "Data format error loading data widget.json file.";
                } else {
                    var _d;
                    // convert value if a jmakiRSS type
                    if (data.dataType == 'jmakiRSS') {
                        _d = jmaki.filter(data, filter);
                    } else {
                        if (data.value.defaultValue) _d = data.value.defaultValue;
                    }
                    if (_d.rows) {
                        _widget.rows = _d.rows;                   
                    }
                    if (_d.columns) {
                       columns = _d.columns;                        
                    }
                    _widget.init();
                }
            }
        });
    }
    
    this.clearFilters = function(){
        table.clearFilters();
    };
    
    this.clear = function() {
        table.store.setData([]);        
        table.store.clearData();
        counter = 0;
    };
    
    this.addRows = function(b){
        if (b.message)b = b.message;
        for (var i=0; i < b.value.length; i++) {
            _widget.addRow({ value : b.value[i]}, false);
        }
    };
 
    this.removeRow = function(b){
        var index;
        var data;
        if (b) data = b;
        if (b.message) {
            b = b.message;
        }
        if (b.value) {
            data = b.value;    
        }
        if (b.targetId) {
           index = b.targetId;
        } else {
            index = b;
        }  
        if (index && table.store.getDataByKey(index)) {
            table.store.removeDataByKey(index);
            restStore.deleteItem(data);
        }
    };
    
    this.updateRow = function(b, d) {
        var index;
        var data;
        if (d) data = d;
        if (b.message) {
            b = b.message;
        }
        if (b.value) {
            data = b.value;    
        }
        if (b.targetId) {
           index = b.targetId;
        } else {
            index = b;
        }
        if (typeof index != 'undefined' && table.store.getDataByKey(index)) {
            var s = table.store.getDataByKey(index);
            if (s) {
                var r = table.getRow(s);
                for (var i in data) {
                  s[i] = data[i];    
                }
                // update the table cells to match the model
              	for (var j = 0; j < table.columns.length; j++) {
                    // update the visible
		    r.childNodes[j].childNodes[0].innerHTML = data[table.columns[j].field];
                    // update the input element
                    r.childNodes[j].childNodes[1].childNodes[0].value = data[table.columns[j].field];
                } 
            } 
            restStore.save({sync: true, Id: s['Id'], method: "put", data: data});
        }
    };
    
    this.select = function(b){
        var index;
        if (b.message)b = b.message;
        if (b.targetId) {
           index = b.targetId;
        } else {
            index = b;
        }    
        if (index && table.store.getDataByKey(index)) {
            var s = table.store.getDataByKey(index);
            if (s) {
                var r = table.getRow(s);
                r.isSelected = true;         
                table.resetSelections();
                table.toggleSelectionByRow(r); 
                table.renderSelections();
                jmaki.publish(topic + "/onSelect", { widgetId : wargs.uuid, type : 'onSelect', targetId : index });
            }
        }
    };  
    
    this.addRow = function(b){
        var r;
        if (b.message)b = b.message;
        if (b.value) {
            r = b.value;
        } else {
            r = b;
        }
        var targetId;
        if (r.id) targetId = r.id;
        if (r.Id) targetId = r.Id;
        
        if (table.store.getDataByKey(targetId)) {
            jmaki.log(wargs.uuid  + " : Warning. Attempt to add record to dojo.rest.customerstable with duplicate row id: " + targetId + ". Autogenerating new id.");
            r.id = genId();
        }
        
        // add an id for sorting if not defined
        if (typeof r.id == "undefined") {  
            r.id = genId();
        }
        var kwArgs = {        
            attribute: "Id"   
        }
        restStore.newItem({Id: targetId}, kwArgs);
        restStore.save({sync: true, Id: targetId, method: "post"});
        table.store.addData(r, null, false);
     }
    
    this.onSelect = function(e) {
        var _s = [];
        var _data = [];
	var d = table.store.get();
	for (var i = 0; i < d.length; i++) {
            if (d[i].isSelected) {
	        _s.push(d[i].src.Id);
                _data.push(d[i].src);
            }
	}     
        // later we may want to support multiple selections
        jmaki.publish(topic + "/onSelect", { widgetId : wargs.uuid, type : 'onSelect', targetId : _s[0], src : _data[0] });

    }

    this.clearFilters = function(){
        table.clearFilters();
    }
  
    this.onCellUpdate = function(column,row,value){
        jmaki.publish(topic + "/onCellEdit", {widgetId : wargs.uuid, topic : topic, type : 'onCellEdit', column:column, row: row, value: value});
    }
    
    function doSubscribe(topic, handler) {
        var i = jmaki.subscribe(topic, handler);
        _widget.subs.push(i);
    }
    
    this.destroy = function() {
        for (var i=0; _widget.subs && i < _widget.subs.length; i++) {
            jmaki.unsubscribe(_widget.subs[i]);
        }
    }

    this.postLoad = function() {
        // track the subscribers so we can later remove them
        _widget.subs = [];
        for (var _i=0; _i < subscribe.length; _i++) {
            doSubscribe(subscribe[_i]  + "/clear", _widget.clear);
            doSubscribe(subscribe[_i]  + "/addRow", _widget.addRow);
            doSubscribe(subscribe[_i]  + "/addRows", _widget.addRows);
            doSubscribe(subscribe[_i]  + "/updateRow", _widget.updateRow);
            doSubscribe(subscribe[_i]  + "/removeRow", _widget.removeRow);
            doSubscribe(subscribe[_i]  + "/select", _widget.select);
        }
       
        jmaki.subscribe(_widget.topic  + "/clear", _widget.clear);
        jmaki.subscribe(_widget.topic  + "/addRow", _widget.addRow);
        jmaki.subscribe(_widget.topic  + "/addRows", _widget.addRows);
        jmaki.subscribe(_widget.topic  + "/updateRow", _widget.updateRow);
        jmaki.subscribe(_widget.topic  + "/removeRow", _widget.removeRow);
        jmaki.subscribe(_widget.topic  + "/select", _widget.select);
    }
}

djd43.provide("rdj.initResource");
rdj.initResource = function (url, widget, container) {
    var dataInSimpleStoreFormat = [];
    var columnsInResourcesTableFormat = null;
    var addRow = function(item, result) {
        var object = {};
        var attributes = restStore.getAttributes(item);
        object["Identity"] = item;
        for (var i in attributes) {
            var attribute = attributes[i];
            var value = restStore.get(item, attribute);
            object[attribute] = value;
        }
        dataInSimpleStoreFormat.push(object);
        if (!columnsInResourcesTableFormat) {
            columnsInResourcesTableFormat = [];
            for (var i in attributes) {
                var attribute = attributes[i];
                columnsInResourcesTableFormat.push({field: attribute});
            }
        }
    };
    restStore = new rdj.data.CustomersStore({serviceUrl:url});
    if(_proxy.length > 0)
        restStore.setProxy(_proxy);
    var query = null;
    var result = restStore.find({query:query, sync:true, onnext:addRow});
    var table = djd43.widget.createWidget("rdj:ResourcesTable", {valueField:"Id"}, container);
    resourcesTable = table;
    for (var i in columnsInResourcesTableFormat) {
        var column = columnsInResourcesTableFormat[i];
        table.columns.push(table.createMetaData(column));
    }
    table.store.setData(dataInSimpleStoreFormat);
    djd43.event.connect(table, "onSelect", widget, "onSelect");
    djd43.event.connect(table, "onCellUpdate", widget, "onCellUpdate");

    //Add actions Add, Update
    var actions = djd43.byId("actions");
    if(actions == null) {
        var tableElement = null;
        var tables = document.getElementsByTagName('table');
        for(var i=0;i<tables.length;i++) {
            if(tables[i].id.substring(0, 9) == 'dojo_rest') {
                tableElement = tables[i];
            }
        }
        var body = document.getElementsByTagName('body')[0];
        if(tableElement == null) {
            actions = body.appendChild(document.createElement('div'));
        } else {
            var tableParent = tableElement.parentNode;
            actions = tableParent.insertBefore(document.createElement('div'), tableElement);
        }
        actions.id = 'actions';
    }
    var actionTable = actions.appendChild(document.createElement('table'));
    var tr = actionTable.appendChild(document.createElement('tr'));
    var text2 = 'color: #000000';

    if(dataInSimpleStoreFormat.length > 0) {
        var addActionStr = '<div class="action"><a style="text-decoration: none" href="javascript:rdj.addResource()"><span style="'+text2+'">Add</span></a></div>';        
        var addAction = tr.appendChild(document.createElement('td'));
        addAction.innerHTML = addActionStr;

        var updActionStr = '<div class="action"><a style="text-decoration: none" href="javascript:rdj.updateResource()"><span style="'+text2+'">Update</span></a></div>';
        var updAction = tr.appendChild(document.createElement('td'));
        updAction.innerHTML = updActionStr;   

        var delActionStr = '<div class="action"><a style="text-decoration: none" href="javascript:rdj.deleteResource()"><span style="'+text2+'">Delete</span></a></div>';
        var delAction = tr.appendChild(document.createElement('td'));
        delAction.innerHTML = delActionStr;
    } else {
        var alertStr = '';
        if(result == -1) {
            alertStr = '<span style="'+text2+'">Error reading data store, Please check url: <a href="'+restStore._serverQueryUrl+'" target="_blank">'+restStore._serverQueryUrl+'</a>.<br/>Set proxy if RESTful web service is not running on the same domain as this application.</span>';
        } else {
            alertStr = '<span style="'+text2+'">No items to display!</span>';
        }
        var alertAction = tr.appendChild(document.createElement('td'));
        alertAction.innerHTML = alertStr;
    }
    return table;
}
djd43.provide("rdj.updateResource");
rdj.updateResource = function () {
    var a = resourcesTable.getSelectedData();
    if(a == null) {
        alert('Please select an item, by clicking the item in the table, then click Update button.');
        return;
    }
    var b = {};
    b.targetId = a['Id'];
    b.value = a;
    jmaki.publish(restTopic  + "/updateRow", b);
}

djd43.provide("rdj.deleteResource");
rdj.deleteResource = function () {
    var a = resourcesTable.getSelectedData();
    if(a == null) {
        alert('Please select an item, by clicking the item in the table, then click Delete button.');
        return;
    }
    var b = {};
    b.targetId = a['Id'];
    b.value = a;
    jmaki.publish(restTopic  + "/removeRow", b);
}

djd43.provide("rdj.addResource");
rdj.addResource = function () {
    var data = resourcesTable.store.get();
    if(data == null || data.length == 0) {
        alert('There need to be atleast 1 item in the store (as seed item) to add new item.');
        return;
    }
    var a = data[0].src;
    var kwArgs = {        
        attribute: "Id"   
    }
    var newId = '';
    while(newId == '') {
        newId = prompt("Please provide Id for new item: ", "");
    }
    var b = {};
    b.id = newId;
    b.value = a;
    b.value.Id = newId;
    b.value['Identity'] = data.length-1;
    jmaki.publish(restTopic  + "/addRow", b);
    try {
        submitForm();
    } catch(e) {
        alert('Please refresh page to see updated table.');
    }
}
