djd43.registerModulePath("rdj", "../../../../../dojo/rest/rdj"); //relative to djd43.js
//Do not Remove -- Begin
djd43.require("rdj.data.CustomersStore");
djd43.require("rdj.data.DiscountCodesStore");

//__REQUIRE_DOJO_SCRIPTS__
//Do not Remove -- End
djd43.require("rdj.widget.ResourcesTable");
djd43.hostenv.writeIncludes();

var resourcesTable;
var restStore;
var rdjTable;
var proxy = "";

djd43.provide("rdj.includeJS");
rdj.includeJS = function(file) {
    if(window.XMLHttpRequest)
    var req = new XMLHttpRequest();
    else
    var req = new ActiveXObject("Microsoft.XMLHTTP");
    req.open("GET", file,false);
    req.onreadystatechange = function(){
        if (req.readyState == 4)
        {
            window.eval(req.responseText);
        }
    }
    req.send(null);
}

djd43.provide("rdj.includeCSS");
rdj.includeCSS = function(file) {
    var scriptTag = document.createElement("link");
    scriptTag.setAttribute("rel", "stylesheet");
    scriptTag.setAttribute("type", "text/css");
    scriptTag.setAttribute("href", file);
    document.getElementsByTagName("head")[0].appendChild(scriptTag);
}

djd43.provide("rdj.init");
rdj.init = function() {
    rdj.includeJS('../rjs/Support.js');
//Do not Remove -- Begin
    rdj.includeJS('../rjs/webapplication2/WebApplication2.js');
    rdj.includeJS('../rjs/webapplication2/Customers.js');
    rdj.includeJS('../rjs/webapplication2/DiscountCodes.js');
    rdj.includeJS('../rjs/webapplication2/Customer.js');
    rdj.includeJS('../rjs/webapplication2/DiscountCode.js');

//__INCLUDE_JS_SCRIPTS__
//Do not Remove -- End
    rdj.includeCSS('../customerstable/component.css');
    rjsSupport.debug('Rest scripts initialized...');
}

djd43.provide("rdj.setProxy");
rdj.setProxy = function(proxy_) {
    proxy = proxy_;
}

djd43.provide("rdj.displayResourcesTable");
rdj.displayResourcesTable = function(datastore, query, tableElement) {
    rdj.init();
    var dataInSimpleStoreFormat = [];
    var columnsInResourcesTableFormat = null;
    var addRow = function(item, result) {
            var object = {};
            var attributes = datastore.getAttributes(item);
            object["Id"] = item;
            for (var i in attributes) {
                    var attribute = attributes[i];
                    var value = datastore.get(item, attribute);
                    object[attribute] = value;
            }
            dataInSimpleStoreFormat.push(object);
            if (!columnsInResourcesTableFormat) {
                    columnsInResourcesTableFormat = [];
                    for (var i in attributes) {
                            var attribute = attributes[i];
                            columnsInResourcesTableFormat.push({field: attribute});
                    }
            }
    };
    restStore = datastore;
    rdjTable = tableElement;
    if(proxy.length > 0)
        restStore.setProxy(proxy);
    var result = datastore.find({query:query, sync:true, onnext:addRow});	
    resourcesTable = djd43.widget.createWidget("rdj:ResourcesTable", {valueField:"Id"}, tableElement);
    for (var i in columnsInResourcesTableFormat) {
            var column = columnsInResourcesTableFormat[i];
            resourcesTable.columns.push(resourcesTable.createMetaData(column));
    }
    resourcesTable.store.setData(dataInSimpleStoreFormat);

    //Add actions Add, Update
    var body = tableElement.parentNode;
    var actions = djd43.byId("actions");
    if(actions == null) {
        actions = body.insertBefore(document.createElement('div'), tableElement);
        actions.id = 'actions';
    }
    var actionTable = actions.appendChild(document.createElement('table'));
    var tr = actionTable.appendChild(document.createElement('tr'));
    var tab = ' background-image: url(../customerstable/images/rtable.gif); width: 100px; border-right: #2574B7 1px solid; border-top: #2574B7 1px solid; border-left: #2574B7 1px solid; border-bottom: #2574B7 1px solid; color: #000000; text-align: center;';
    var text2 = 'color: #000000';
    
    if(dataInSimpleStoreFormat.length > 0) {
        var addActionStr = '<div style="'+tab+'"><a style="text-decoration: none" href="javascript:rdj.addResource()"><span style="'+text2+'">Add</span></a></div>';        
        var addAction = tr.appendChild(document.createElement('td'));
        addAction.innerHTML = addActionStr;

        var updActionStr = '<div style="'+tab+'"><a style="text-decoration: none" href="javascript:rdj.updateResource()"><span style="'+text2+'">Update</span></a></div>';
        var updAction = tr.appendChild(document.createElement('td'));
        updAction.innerHTML = updActionStr;   

        var delActionStr = '<div style="'+tab+'"><a style="text-decoration: none" href="javascript:rdj.deleteResource()"><span style="'+text2+'">Delete</span></a></div>';
        var delAction = tr.appendChild(document.createElement('td'));
        delAction.innerHTML = delActionStr;
    } else {
        var alertStr = '';
        if(result == -1) {
            alertStr = '<span style="'+text2+'">Error reading data store, Please check url: <a href="'+restStore._serverQueryUrl+'" target="_blank">'+restStore._serverQueryUrl+'</a>.<br/>Set proxy if RESTful web service is not running on the same domain as this application.</span>';
        } else {
            alertStr = '<span style="'+text2+'">No items to display!</span>';
        }
        var alertAction = tr.appendChild(document.createElement('td'));
        alertAction.innerHTML = alertStr;
    }
}

djd43.provide("rdj.updateResource");
rdj.updateResource = function () {
    var a = resourcesTable.getSelectedData();
    restStore.save({sync: true, Id: a['Id'], method: "put", data: a});   
}

djd43.provide("rdj.deleteResource");
rdj.deleteResource = function () {
    var a = resourcesTable.getSelectedData();
    restStore.deleteItem(a);
    rdjTable.innerHTML = '';
    var actions2 = djd43.byId("actions");
    if(actions2 != null)
        actions2.innerHTML = '';
    rdj.displayResourcesTable(restStore, null, rdjTable);
    resourcesTable.selectByValue('1');
}

djd43.provide("rdj.addResource");
rdj.addResource = function () {
    var kwArgs = {        
        attribute: "Id"   
    }
    var id = 1000+restStore.getSize()+1;
    var newId = '';
    while(newId == '') {
        newId = prompt("Please provide Id for new item: ", "");
    }
    restStore.newItem({Id: newId}, kwArgs);
    restStore.save({sync: true, Id: newId, method: "post"});
    rdjTable.innerHTML = '';
    var actions2 = djd43.byId("actions");
    if(actions2 != null)
        actions2.innerHTML = '';
    rdj.displayResourcesTable(restStore, null, rdjTable);
    resourcesTable.selectByValue('1');
} 
