djd43.provide("rdj.data.CustomersStore");
djd43.require("djd43.data.core.RemoteStore");
djd43.require("djd43.lang.declare");
djd43.require("djd43.io.ScriptSrcIO");
djd43.declare("rdj.data.CustomersStore", djd43.data.core.RemoteStore, {initializer:function (kwArgs) {
	if (!kwArgs) {
		kwArgs = {};
	}
	this._serverQueryUrl = kwArgs.serviceUrl || "";
	this._serverSaveUrl = kwArgs.serviceUrl || "";
	this._deleted = {};
	this._changed = {};
	this._added = {};
	this._results = {};
	this._data = {};
	this._numItems = 0;
        this._refCustomer = null;
        this._refData = {};
        this._proxy = "";
},

    _getProxy : function() {
        return this._proxy;
    },
   
    setProxy : function(proxy_) {
        this._proxy = proxy_;
    },

    _setQueryUrl : function(requestKw, qUrl) {
        if(this._getProxy().length > 0) {
            requestKw.url = this._getProxy()+"?url="+qUrl;
            rjsSupport.setHttpProxy(this._getProxy());
        } else {
            requestKw.url = qUrl;
        }

        //add timestamp to make url unique in case of IE7
        var timestamp = new Date().getTime();
        if(requestKw.url.indexOf("?") == -1) {
            requestKw.url += "?timestamp="+timestamp;
        } else {
            requestKw.url += "&timestamp="+timestamp;
        }
    },

    _setupQueryRequest:function (result, requestKw) {
	var start = 1;
	var max = 100;
	if (result) {
		start = result.start || start;
		max = result.max || max;
	}
        this._setQueryUrl(requestKw, this._serverQueryUrl);

        requestKw.url += "&expandLevel=0";

        if(max != -1)
            requestKw.url += "&start=" + start + "&max=" + max;

        var method = "GET";
        if(method == 'GET') {
            requestKw.headers = {"Accept" : "application/json"};
        }
}, _resultToQueryMetadata:function (json) {
        var myObj = eval('('+json+')');
	return myObj.customers.customer;
}, _resultToQueryData:function (json) {
        var myObj = eval('('+json+')');
        var customers = myObj.customers;
        var refs = customers.customer;
	var data = {};
        if(refs != null && refs.length > 0) {
            for (var i = 0; i < refs.length; ++i) {
                var record = refs[i];
                var url2 = record['@uri'];
                var item = {};
                var ci = new Customer(url2);
                ci.init();
                var fields = ci.getFields();//first field is Id, second is uri
                if(typeof ci[fields[0]] == "object") {
                    var id = '';
                    for(var k in ci[fields[0]])
                        id += [ci[fields[0]][k]]+",";
                    if(id.length > 0) {
                        id = id.substring(0, id.length-1);
                        var s1 = id.split(',');
                        var rId = '';
                        for(var l=s1.length-1;l>=0;l--)
                            rId += s1[l]+",";
                        rId = rId.substring(0, rId.length-1);
                    }
                    item['Id'] = [rId];
                } else {
                    item['Id'] = [ci[fields[0]]];
                }
                for(var j=1;j<fields.length;j++) {
                    var f = fields[j];
                    item[f] = [ci[f]];
                }
                data[i] = item;
            }
            this._refCustomer = new Customer(refs[0]['@uri']);
            this._refCustomer.init();
            this._refData = data[0];
        }
	return data;
}, _setupSaveRequest:function (saveKeywordArgs, requestKw) {
        var id = 1000+this.getSize()+1;
        var method = "put";
        var data = null;
        if(saveKeywordArgs) {
            var id = saveKeywordArgs.Id || id;
            method = saveKeywordArgs.method || method;
            data = saveKeywordArgs.data || data;
        }
        if(this._proxy.length > 0) {
            rjsSupport.setHttpProxy(this._getProxy());
        }
        var jsonStr = '';
        if(method == 'put') {
             var ci = new Customer(this._serverSaveUrl+id+'/');
             ci.init();
             var fields = ci.getFields();//first field is Id, second is uri
             for(var j=1;j<fields.length;j++) {
                var f = fields[j];
                ci[f] = data[f];
             }
             
            var status = ci.flush();
            if(status) {
                alert('Update succeeded for customer with Id: \''+id+'\'.');
            } else {
                alert('Update failed for customer with Id: \''+id+'\'.');
            }
            this._setQueryUrl(requestKw, this._serverSaveUrl+id+'/');
            method = 'get';
            requestKw.headers = {"Accept" : "application/json"};
            requestKw.mimetype = "application/json";          
        } else {
            if(this._refCustomer != null) {
                for(var item in this._added) {
                    var ci = this._refCustomer;
                    ci.initialized = true;
                    ci.uri = this._serverSaveUrl+id+'/';
                    var fields = ci.getFields();//first field is Id, second is uri
                    if(typeof ci[fields[0]] == "object") {
                        var ids = id.split(',');
                        var count = 0;
                        for(var k in ci[fields[0]]) {
                            ci[fields[0]][k] = ids[count++];
                        }
                    } else {
                        ci[fields[0]] = id;
                    }
                    for(var j=1;j<fields.length;j++) {
                        var f = fields[j];
                        ci[f] = this._refData[f];
                    }
                    var c = new Customers(this._serverSaveUrl);
                    var status = c.flush(ci);
                    if(status) {
                        alert('Add succeeded for customer with Id: \''+id+'\'.');
                    } else {
                        alert('Add failed for customer with Id: \''+id+'\'.');
                    }
                }  
            }
            this._setQueryUrl(requestKw, this._serverSaveUrl);
            method = 'get';
            requestKw.headers = {"Accept" : "application/json"}; 
            requestKw.mimetype = "application/json";   
        }        
}, find:function (keywordArgs) {
	var result = null;
	if (keywordArgs instanceof djd43.data.core.Result) {
		result = keywordArgs;
		result.store = this;
	} else {
		result = new djd43.data.core.Result(keywordArgs, this);
	}
	var query = result.query;
	var self = this;
	var bindfunc = function (type, data, evt) {
		var scope = result.scope || dj_global;
		if (type == "load") {
			result.resultMetadata = self._resultToQueryMetadata(data);
			var dataDict = self._resultToQueryData(data);
			if (result.onbegin) {
				result.onbegin.call(scope, result);
			}
			var count = 0;
			var resultData = [];
			var newItemCount = 0;
			for (var key in dataDict) {
				if (result._aborted) {
					break;
				}
				if (!self._deleted[key]) {
					var values = dataDict[key];
					var attributeDict = self._remoteToLocalValues(values);
					var existingValue = self._data[key];
					var refCount = 1;
					if (existingValue) {
						refCount = ++existingValue[1];
					} else {
						newItemCount++;
					}
					self._data[key] = [attributeDict, refCount];
					resultData.push(key);
					count++;
					if (result.onnext) {
						result.onnext.call(scope, key, result);
					}
				}
			}
			self._results[self._queryToQueryKey(query)] = resultData;
			self._numItems += newItemCount;
			result.length = count;
			if (result.saveResult) {
				result.items = resultData;
			}
			if (!result._aborted && result.oncompleted) {
				result.oncompleted.call(scope, result);
			}
		} else {
			if (type == "error" || type == "timeout") {
				djd43.debug("find error: " + djd43.json.serialize(data));
                                rjsSupport.debug('CustomersStore.find() returned error: '+
                                    djd43.json.serialize(data)+ '\nPlease check the url: '+self._serverQueryUrl+
                                        ' \nor the server logs for details.');
				if (result.onerror) {
					result.onerror.call(scope, data);
				}
			}
		}
	};
	var bindKw = keywordArgs.bindArgs || {};
	bindKw.sync = result.sync;
	bindKw.handle = bindfunc;
	this._setupQueryRequest(result, bindKw);
        try {
            var request = djd43.io.bind(bindKw);
            result._abortFunc = request.abort;
        } catch(e) {
            return "-1";
        }
	return result;
}, deleteItem:function (item) {
        var id = item['Id'];
	var ci = new Customer(this._serverSaveUrl+id+'/');
        var status = ci.delete_();
        if(status) {
            alert('Delete succeeded for Customer with Id: \''+id+'\'.');
        } else {
            alert('Delete failed for Customer with Id: \''+id+'\'.');
        }
}});
