/*
* Support js for Customers
*/

function Customers(uri_) {
    this.uri = uri_;
}

Customers.prototype = {

   getUri : function() {
      return this.uri;
   },
   
   getRemote : function() {
      return new CustomersRemote(this.uri);
   }
}

function CustomersRemote(uri_) {
    this.uri = uri_+'?expandLevel=1';
}

CustomersRemote.prototype = {

   getXml : function() {
      return rjsSupport.get(this.uri, 'application/xml');
   },

   getJson : function() {
      return rjsSupport.get(this.uri, 'application/json');
   },

   postXml : function(content) {
      return rjsSupport.post(this.uri, 'application/xml', content);
   },

   postJson : function(content) {
      return rjsSupport.post(this.uri, 'application/json', content);
   }
}
