/*
* Support js for DiscountCodes
*/

function DiscountCodes(uri_) {
    this.uri = uri_;
}

DiscountCodes.prototype = {

   getUri : function() {
      return this.uri;
   },
   
   getRemote : function() {
      return new DiscountCodesRemote(this.uri);
   }
}

function DiscountCodesRemote(uri_) {
    this.uri = uri_+'?expandLevel=1';
}

DiscountCodesRemote.prototype = {

   getXml : function() {
      return rjsSupport.get(this.uri, 'application/xml');
   },

   getJson : function() {
      return rjsSupport.get(this.uri, 'application/json');
   },

   postXml : function(content) {
      return rjsSupport.post(this.uri, 'application/xml', content);
   },

   postJson : function(content) {
      return rjsSupport.post(this.uri, 'application/json', content);
   }
}
