/*
* Support js for Manufacturers
*/

function Manufacturers(uri_) {
    this.uri = uri_;
}

Manufacturers.prototype = {

   getUri : function() {
      return this.uri;
   },
   
   getRemote : function() {
      return new ManufacturersRemote(this.uri);
   }
}

function ManufacturersRemote(uri_) {
    this.uri = uri_+'?expandLevel=1';
}

ManufacturersRemote.prototype = {

   getXml : function() {
      return rjsSupport.get(this.uri, 'application/xml');
   },

   getJson : function() {
      return rjsSupport.get(this.uri, 'application/json');
   },

   postXml : function(content) {
      return rjsSupport.post(this.uri, 'application/xml', content);
   },

   postJson : function(content) {
      return rjsSupport.post(this.uri, 'application/json', content);
   }
}
