/*
* Support js for ProductCodes
*/

function ProductCodes(uri_) {
    this.uri = uri_;
}

ProductCodes.prototype = {

   getUri : function() {
      return this.uri;
   },
   
   getRemote : function() {
      return new ProductCodesRemote(this.uri);
   }
}

function ProductCodesRemote(uri_) {
    this.uri = uri_+'?expandLevel=1';
}

ProductCodesRemote.prototype = {

   getXml : function() {
      return rjsSupport.get(this.uri, 'application/xml');
   },

   getJson : function() {
      return rjsSupport.get(this.uri, 'application/json');
   },

   postXml : function(content) {
      return rjsSupport.post(this.uri, 'application/xml', content);
   },

   postJson : function(content) {
      return rjsSupport.post(this.uri, 'application/json', content);
   }
}
