/*
* Support js for Products
*/

function Products(uri_) {
    this.uri = uri_;
}

Products.prototype = {

   getUri : function() {
      return this.uri;
   },
   
   getRemote : function() {
      return new ProductsRemote(this.uri);
   }
}

function ProductsRemote(uri_) {
    this.uri = uri_+'?expandLevel=1';
}

ProductsRemote.prototype = {

   getXml : function() {
      return rjsSupport.get(this.uri, 'application/xml');
   },

   getJson : function() {
      return rjsSupport.get(this.uri, 'application/json');
   },

   postXml : function(content) {
      return rjsSupport.post(this.uri, 'application/xml', content);
   },

   postJson : function(content) {
      return rjsSupport.post(this.uri, 'application/json', content);
   }
}
