/*
* Support js for PurchaseOrders
*/

function PurchaseOrders(uri_) {
    this.uri = uri_;
}

PurchaseOrders.prototype = {

   getUri : function() {
      return this.uri;
   },
   
   getRemote : function() {
      return new PurchaseOrdersRemote(this.uri);
   }
}

function PurchaseOrdersRemote(uri_) {
    this.uri = uri_+'?expandLevel=1';
}

PurchaseOrdersRemote.prototype = {

   getXml : function() {
      return rjsSupport.get(this.uri, 'application/xml');
   },

   getJson : function() {
      return rjsSupport.get(this.uri, 'application/json');
   },

   postXml : function(content) {
      return rjsSupport.post(this.uri, 'application/xml', content);
   },

   postJson : function(content) {
      return rjsSupport.post(this.uri, 'application/json', content);
   }
}
