/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * The original contributor of this 
 *
 */

/*
 * AddressDataSet.java
 *
 * Created on April 19, 2007, 4:05 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.microedition.databinding.pim;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import org.netbeans.microedition.databinding.DataBindingException;
import org.netbeans.microedition.databinding.DataSet;

/**
 *
 * @author Michal Skvor
 */
public class AddressDataSet implements DataSet {
    
    public static final String COUNTRY          = "country";
    public static final String LOCALITY         = "locality";
    public static final String ZIP              = "zip";
    public static final String STREET           = "street";
    public static final String REGION           = "region";
    public static final String EXTRA            = "extra";
    public static final String POBOX            = "pobox";
    
    private Vector supportedFields = new Vector();
    
    private int contactIndex;
    private int attribute;
    
    /** Creates a new instance of AddressDataSet */
     public AddressDataSet( int contactIndex, int attribute ) {
         this.contactIndex = contactIndex;
         this.attribute = attribute;
         
         try {
            ContactList contacts = (ContactList) PIM.getInstance().openPIMList( PIM.CONTACT_LIST, PIM.READ_ONLY );
            contacts.createContact();
            int[] fields = contacts.getSupportedArrayElements( Contact.ADDR );
            for( int i = 0; i < fields.length; i++ ) {
                switch( fields[i] ) {
                    case Contact.ADDR_COUNTRY:
                        supportedFields.addElement( COUNTRY );
                        break;
                    case Contact.ADDR_STREET:
                        supportedFields.addElement( STREET );
                        break;
                }
                System.err.println(" - - " + contacts.getArrayElementLabel( Contact.ADDR, fields[i] ));
            }
         } catch( PIMException e ) {
             e.printStackTrace();
         }
    }

    public Class getType( String dataItemName ) throws DataBindingException {
        return null;
    }

    public Object getValue( String dataItemName ) throws DataBindingException {
        if( !supportedFields.contains( dataItemName )) 
            throw new DataBindingException( "Unsupported item name: " + dataItemName );
        
        if( COUNTRY.equals( dataItemName )) {
            return Query.getContactArrayValue( contactIndex, attribute, Contact.ADDR, Contact.ADDR_COUNTRY );
        } else if( STREET.equals( dataItemName )) {
            return Query.getContactArrayValue( contactIndex, attribute, Contact.ADDR, Contact.ADDR_STREET );
        } else if( LOCALITY.equals( dataItemName )) {
            return Query.getContactArrayValue( contactIndex, attribute, Contact.ADDR, Contact.ADDR_LOCALITY );
        } else if( ZIP.equals( dataItemName )) {
            return Query.getContactArrayValue( contactIndex, attribute, Contact.ADDR, Contact.ADDR_POSTALCODE );
        } else if( REGION.equals( dataItemName )) {
            return Query.getContactArrayValue( contactIndex, attribute, Contact.ADDR, Contact.ADDR_REGION );
        } else if( EXTRA.equals( dataItemName )) {
            return Query.getContactArrayValue( contactIndex, attribute, Contact.ADDR, Contact.ADDR_EXTRA );
        } else if( POBOX.equals( dataItemName )) {
            return Query.getContactArrayValue( contactIndex, attribute, Contact.ADDR, Contact.ADDR_POBOX );
        }
        throw new DataBindingException( "Invalid data item name: " + dataItemName );
    }

    public void setValue( String dataItemName, Object value ) throws DataBindingException {
        if( !supportedFields.contains( dataItemName )) 
            throw new DataBindingException( "Unsupported item name: " + dataItemName );
        if(!( value instanceof String ))
            throw new DataBindingException( "Unsupported value type." );           
        setAsString( dataItemName, (String) value );
    }

    public void setAsString( String dataItemName, String value ) throws DataBindingException {
        if( !supportedFields.contains( dataItemName )) 
            throw new DataBindingException( "Unsupported item name: " + dataItemName );
        
        if( COUNTRY.equals( dataItemName )) {
            Query.setContactArrayValue( contactIndex, attribute, Contact.ADDR, Contact.ADDR_COUNTRY,  value );
            return;
        } else if( STREET.equals( dataItemName )) {
            Query.setContactArrayValue( contactIndex, attribute, Contact.ADDR, Contact.ADDR_STREET, value );
            return;
        } else if( LOCALITY.equals( dataItemName )) {
            Query.setContactArrayValue( contactIndex, attribute, Contact.ADDR, Contact.ADDR_LOCALITY, value );
            return;
        } else if( ZIP.equals( dataItemName )) {
            Query.setContactArrayValue( contactIndex, attribute, Contact.ADDR, Contact.ADDR_POSTALCODE, value );
            return;
        } else if( REGION.equals( dataItemName )) {
            Query.setContactArrayValue( contactIndex, attribute, Contact.ADDR, Contact.ADDR_REGION, value );
            return;
        } else if( EXTRA.equals( dataItemName )) {
            Query.setContactArrayValue( contactIndex, attribute, Contact.ADDR, Contact.ADDR_EXTRA, value );
            return;
        } else if( POBOX.equals( dataItemName )) {
            Query.setContactArrayValue( contactIndex, attribute, Contact.ADDR, Contact.ADDR_POBOX, value );
            return;
        }
        throw new DataBindingException( "Invalid data item name: " + dataItemName );
    }

    public boolean isReadOnly( String dataItemName ) throws DataBindingException {
        return false;
    }
}
