
/***************************************************************************
 * RawData.cc -- The RawData Class represents a network packet payload. It *
 * is essentially a single buffer that may contain either random data or   *
 * caller supplied data. This class can be used, for example, to be linked *
 * to a UDP datagram.                                                      *
 *                                                                         *
 ***********************IMPORTANT NMAP LICENSE TERMS************************
 *                                                                         *
 * The Nmap Security Scanner is (C) 1996-2010 Insecure.Com LLC. Nmap is    *
 * also a registered trademark of Insecure.Com LLC.  This program is free  *
 * software; you may redistribute and/or modify it under the terms of the  *
 * GNU General Public License as published by the Free Software            *
 * Foundation; Version 2 with the clarifications and exceptions described  *
 * below.  This guarantees your right to use, modify, and redistribute     *
 * this software under certain conditions.  If you wish to embed Nmap      *
 * technology into proprietary software, we sell alternative licenses      *
 * (contact sales@insecure.com).  Dozens of software vendors already       *
 * license Nmap technology such as host discovery, port scanning, OS       *
 * detection, and version detection.                                       *
 *                                                                         *
 * Note that the GPL places important restrictions on "derived works", yet *
 * it does not provide a detailed definition of that term.  To avoid       *
 * misunderstandings, we consider an application to constitute a           *
 * "derivative work" for the purpose of this license if it does any of the *
 * following:                                                              *
 * o Integrates source code from Nmap                                      *
 * o Reads or includes Nmap copyrighted data files, such as                *
 *   nmap-os-db or nmap-service-probes.                                    *
 * o Executes Nmap and parses the results (as opposed to typical shell or  *
 *   execution-menu apps, which simply display raw Nmap output and so are  *
 *   not derivative works.)                                                *
 * o Integrates/includes/aggregates Nmap into a proprietary executable     *
 *   installer, such as those produced by InstallShield.                   *
 * o Links to a library or executes a program that does any of the above   *
 *                                                                         *
 * The term "Nmap" should be taken to also include any portions or derived *
 * works of Nmap.  This list is not exclusive, but is meant to clarify our *
 * interpretation of derived works with some common examples.  Our         *
 * interpretation applies only to Nmap--we don't speak for other people's  *
 * GPL works.                                                              *
 *                                                                         *
 * If you have any questions about the GPL licensing restrictions on using *
 * Nmap in non-GPL works, we would be happy to help.  As mentioned above,  *
 * we also offer alternative license to integrate Nmap into proprietary    *
 * applications and appliances.  These contracts have been sold to dozens  *
 * of software vendors, and generally include a perpetual license as well  *
 * as providing for priority support and updates as well as helping to     *
 * fund the continued development of Nmap technology.  Please email        *
 * sales@insecure.com for further information.                             *
 *                                                                         *
 * As a special exception to the GPL terms, Insecure.Com LLC grants        *
 * permission to link the code of this program with any version of the     *
 * OpenSSL library which is distributed under a license identical to that  *
 * listed in the included COPYING.OpenSSL file, and distribute linked      *
 * combinations including the two. You must obey the GNU GPL in all        *
 * respects for all of the code used other than OpenSSL.  If you modify    *
 * this file, you may extend this exception to your version of the file,   *
 * but you are not obligated to do so.                                     *
 *                                                                         *
 * If you received these files with a written license agreement or         *
 * contract stating terms other than the terms above, then that            *
 * alternative license agreement takes precedence over these comments.     *
 *                                                                         *
 * Source is provided to this software because we believe users have a     *
 * right to know exactly what a program is going to do before they run it. *
 * This also allows you to audit the software for security holes (none     *
 * have been found so far).                                                *
 *                                                                         *
 * Source code also allows you to port Nmap to new platforms, fix bugs,    *
 * and add new features.  You are highly encouraged to send your changes   *
 * to nmap-dev@insecure.org for possible incorporation into the main       *
 * distribution.  By sending these changes to Fyodor or one of the         *
 * Insecure.Org development mailing lists, it is assumed that you are      *
 * offering the Nmap Project (Insecure.Com LLC) the unlimited,             *
 * non-exclusive right to reuse, modify, and relicense the code.  Nmap     *
 * will always be available Open Source, but this is important because the *
 * inability to relicense code has caused devastating problems for other   *
 * Free Software projects (such as KDE and NASM).  We also occasionally    *
 * relicense the code to third parties as discussed above.  If you wish to *
 * specify special license conditions of your contributions, just say so   *
 * when you send them.                                                     *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License v2.0 for more details at                         *
 * http://www.gnu.org/licenses/gpl-2.0.html , or in the COPYING file       *
 * included with Nmap.                                                     *
 *                                                                         *
 ***************************************************************************/

#include "RawData.h"
#include "nping.h"
#include "output.h"


RawData::RawData(){

  data=NULL;
  length=0;
  data_is_user_supplied=false;

} /* End of RawData contructor */




RawData::RawData(int len){

  if( len < 0 )
    outFatal(QT_3, "RawData() Invalid length supplied.");
  else if(len==0){
    data=NULL;
    length=0;
  }
  else{
    data=(u8 *)safe_zalloc( len );
    length=len;
    data_is_user_supplied=false;
  }

} /* End of RawData constructor */



/** @warning Supplied pointer can be either a static address or a free()able
 *  memory location. No attempt to free() it will me made by RawData
 *  destructor or any other method,
 */
RawData::RawData(u8 *pnt, int len){

  if( len < 0 )
    outFatal(QT_3, "RawData() Invalid length supplied.");
  else if(len==0 || pnt==NULL){
    data=NULL;
    length=0;
  }
  else{
    data=pnt;
    length=len;
    data_is_user_supplied=true;
  }

} /* End of RawData constructor */



RawData::~RawData(){

  if(data!=NULL && data_is_user_supplied==false){
    free(data);
    data=NULL;
  }

} /* End of RawData destructor */



u8 * RawData::getBufferPointer(){

  return this->data;

} /* End of getBufferPointer() */




int RawData::setBufferPointer(u8 *pnt){

    data=pnt;
    data_is_user_supplied=true;

    return OP_SUCCESS;

} /* End of setBufferPointer() */


int RawData::setBufferPointer(u8 *pnt, int len){

    data=pnt;
    length=len;
    data_is_user_supplied=true;

    return OP_SUCCESS;

} /* End of setBufferPointer() */

int RawData::setBufferLen(int len){

    length=len;

    return OP_SUCCESS;

} /* End of setBufferPointer() */


/* Fills data buffer with random bits */
int RawData::setBufferContents(){

  for(int i=0; i<length; i++)
    data[i]=get_random_u8();

   return OP_SUCCESS;

} /* End of setBufferContents() */



/** Copies "len" bytes of data from position "buff" to the object's buffer.
 *  If "len" is more that object's buffer, only the first "length" bytes
 *  are copied. */
int RawData::setBufferContents(u8 *buff, int len){

  if( buff==NULL || len<=0 ) /* TODO: Add printf()? */
    return OP_FAILURE;

  int limit = (len < length) ? len : length ;

  for(int i=0; i<limit; i++)
    data[i]=buff[i];

   return OP_SUCCESS;

} /* End of setBufferContents() */




/** @warning This method asuumes that supplied buffer contains at least
 *  length bytes (getDataLen() bytes) */
int RawData::setBufferContents(u8 *buff){

    return setBufferContents(buff, length);

} /* End of setBufferContents() */

