# Copyright 2012 the V8 project authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.
{
  'variables': {
    'V8_ROOT': '../../deps/v8',
    'v8_code': 1,
    'v8_random_seed%': 314159265,
    'v8_vector_stores%': 0,
    'v8_embed_script%': "",
    'mksnapshot_exec': '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)mksnapshot<(EXECUTABLE_SUFFIX)',
    'v8_os_page_size%': 0,
    'generate_bytecode_output_root': '<(SHARED_INTERMEDIATE_DIR)/generate-bytecode-output-root',
    'generate_bytecode_builtins_list_output': '<(generate_bytecode_output_root)/builtins-generated/bytecodes-builtins-list.h',
    'torque_files': [
      "<(V8_ROOT)/src/builtins/base.tq",
      "<(V8_ROOT)/src/builtins/growable-fixed-array.tq",
      "<(V8_ROOT)/src/builtins/frames.tq",
      "<(V8_ROOT)/src/builtins/arguments.tq",
      "<(V8_ROOT)/src/builtins/array.tq",
      "<(V8_ROOT)/src/builtins/array-copywithin.tq",
      "<(V8_ROOT)/src/builtins/array-every.tq",
      "<(V8_ROOT)/src/builtins/array-filter.tq",
      "<(V8_ROOT)/src/builtins/array-find.tq",
      "<(V8_ROOT)/src/builtins/array-findindex.tq",
      "<(V8_ROOT)/src/builtins/array-foreach.tq",
      "<(V8_ROOT)/src/builtins/array-join.tq",
      "<(V8_ROOT)/src/builtins/array-lastindexof.tq",
      "<(V8_ROOT)/src/builtins/array-of.tq",
      "<(V8_ROOT)/src/builtins/array-map.tq",
      "<(V8_ROOT)/src/builtins/array-reduce.tq",
      "<(V8_ROOT)/src/builtins/array-reduce-right.tq",
      "<(V8_ROOT)/src/builtins/array-reverse.tq",
      "<(V8_ROOT)/src/builtins/array-shift.tq",
      "<(V8_ROOT)/src/builtins/array-slice.tq",
      "<(V8_ROOT)/src/builtins/array-some.tq",
      "<(V8_ROOT)/src/builtins/array-splice.tq",
      "<(V8_ROOT)/src/builtins/array-unshift.tq",
      "<(V8_ROOT)/src/builtins/collections.tq",
      "<(V8_ROOT)/src/builtins/data-view.tq",
      "<(V8_ROOT)/src/builtins/extras-utils.tq",
      "<(V8_ROOT)/src/builtins/iterator.tq",
      "<(V8_ROOT)/src/builtins/object-fromentries.tq",
      "<(V8_ROOT)/src/builtins/proxy.tq",
      "<(V8_ROOT)/src/builtins/proxy-constructor.tq",
      "<(V8_ROOT)/src/builtins/proxy-revocable.tq",
      "<(V8_ROOT)/src/builtins/proxy-revoke.tq",
      "<(V8_ROOT)/src/builtins/regexp.tq",
      "<(V8_ROOT)/src/builtins/regexp-replace.tq",
      "<(V8_ROOT)/src/builtins/string-endswith.tq",
      "<(V8_ROOT)/src/builtins/string-html.tq",
      "<(V8_ROOT)/src/builtins/string-repeat.tq",
      "<(V8_ROOT)/src/builtins/string-startswith.tq",
      "<(V8_ROOT)/src/builtins/typed-array.tq",
      "<(V8_ROOT)/src/builtins/typed-array-createtypedarray.tq",
      "<(V8_ROOT)/src/builtins/typed-array-every.tq",
      "<(V8_ROOT)/src/builtins/typed-array-filter.tq",
      "<(V8_ROOT)/src/builtins/typed-array-find.tq",
      "<(V8_ROOT)/src/builtins/typed-array-findindex.tq",
      "<(V8_ROOT)/src/builtins/typed-array-foreach.tq",
      "<(V8_ROOT)/src/builtins/typed-array-reduce.tq",
      "<(V8_ROOT)/src/builtins/typed-array-reduceright.tq",
      "<(V8_ROOT)/src/builtins/typed-array-slice.tq",
      "<(V8_ROOT)/src/builtins/typed-array-some.tq",
      "<(V8_ROOT)/src/builtins/typed-array-subarray.tq",
      "<(V8_ROOT)/third_party/v8/builtins/array-sort.tq",
    ],
    'torque_namespaces': [
      "arguments",
      "array",
      "array-copywithin",
      "array-filter",
      "array-find",
      "array-findindex",
      "array-foreach",
      "array-join",
      "array-map",
      "array-of",
      "array-reverse",
      "array-shift",
      "array-slice",
      "array-splice",
      "array-unshift",
      "array-lastindexof",
      "base",
      "collections",
      "data-view",
      "extras-utils",
      "growable-fixed-array",
      "iterator",
      "object",
      "proxy",
      "regexp",
      "regexp-replace",
      "string",
      "string-html",
      "string-repeat",
      "typed-array",
      "typed-array-createtypedarray",
      "typed-array-every",
      "typed-array-filter",
      "typed-array-find",
      "typed-array-findindex",
      "typed-array-foreach",
      "typed-array-reduce",
      "typed-array-reduceright",
      "typed-array-slice",
      "typed-array-some",
      "typed-array-subarray",
    ],
    'torque_output_root': '<(SHARED_INTERMEDIATE_DIR)/torque-output-root',
    # Since there is no foreach in GYP we use `ForEachFormat` to unroll the following:
    # foreach(namespace, torque_namespaces) {
    #   outputs += [
    #     "$target_gen_dir/torque-generated/builtins-$namespace-from-dsl-gen.cc",
    #     "$target_gen_dir/torque-generated/builtins-$namespace-from-dsl-gen.h",
    #   ]
    # }
    'torque_outputs': ['<!@pymod_do_main(ForEachFormat "<(torque_output_root)/torque-generated/builtins-%s-from-dsl-gen.cc" <@(torque_namespaces))'],
    'torque_outputs+': ['<!@pymod_do_main(ForEachFormat "<(torque_output_root)/torque-generated/builtins-%s-from-dsl-gen.h" <@(torque_namespaces))'],
    'v8_compiler_sources': [
      '<(V8_ROOT)/src/compiler/access-builder.cc',
      '<(V8_ROOT)/src/compiler/access-builder.h',
      '<(V8_ROOT)/src/compiler/access-info.cc',
      '<(V8_ROOT)/src/compiler/access-info.h',
      '<(V8_ROOT)/src/compiler/all-nodes.cc',
      '<(V8_ROOT)/src/compiler/all-nodes.h',
      '<(V8_ROOT)/src/compiler/allocation-builder-inl.h',
      '<(V8_ROOT)/src/compiler/allocation-builder.h',
      '<(V8_ROOT)/src/compiler/backend/code-generator-impl.h',
      '<(V8_ROOT)/src/compiler/backend/code-generator.cc',
      '<(V8_ROOT)/src/compiler/backend/code-generator.h',
      '<(V8_ROOT)/src/compiler/backend/frame-elider.cc',
      '<(V8_ROOT)/src/compiler/backend/frame-elider.h',
      '<(V8_ROOT)/src/compiler/backend/gap-resolver.cc',
      '<(V8_ROOT)/src/compiler/backend/gap-resolver.h',
      '<(V8_ROOT)/src/compiler/backend/instruction-codes.h',
      '<(V8_ROOT)/src/compiler/backend/instruction-scheduler.cc',
      '<(V8_ROOT)/src/compiler/backend/instruction-scheduler.h',
      '<(V8_ROOT)/src/compiler/backend/instruction-selector-impl.h',
      '<(V8_ROOT)/src/compiler/backend/instruction-selector.cc',
      '<(V8_ROOT)/src/compiler/backend/instruction-selector.h',
      '<(V8_ROOT)/src/compiler/backend/instruction.cc',
      '<(V8_ROOT)/src/compiler/backend/instruction.h',
      '<(V8_ROOT)/src/compiler/backend/jump-threading.cc',
      '<(V8_ROOT)/src/compiler/backend/jump-threading.h',
      '<(V8_ROOT)/src/compiler/backend/live-range-separator.cc',
      '<(V8_ROOT)/src/compiler/backend/live-range-separator.h',
      '<(V8_ROOT)/src/compiler/backend/move-optimizer.cc',
      '<(V8_ROOT)/src/compiler/backend/move-optimizer.h',
      '<(V8_ROOT)/src/compiler/backend/register-allocator-verifier.cc',
      '<(V8_ROOT)/src/compiler/backend/register-allocator-verifier.h',
      '<(V8_ROOT)/src/compiler/backend/register-allocator.cc',
      '<(V8_ROOT)/src/compiler/backend/register-allocator.h',
      '<(V8_ROOT)/src/compiler/backend/unwinding-info-writer.h',
      '<(V8_ROOT)/src/compiler/basic-block-instrumentor.cc',
      '<(V8_ROOT)/src/compiler/basic-block-instrumentor.h',
      '<(V8_ROOT)/src/compiler/branch-elimination.cc',
      '<(V8_ROOT)/src/compiler/branch-elimination.h',
      '<(V8_ROOT)/src/compiler/bytecode-analysis.cc',
      '<(V8_ROOT)/src/compiler/bytecode-analysis.h',
      '<(V8_ROOT)/src/compiler/bytecode-graph-builder.cc',
      '<(V8_ROOT)/src/compiler/bytecode-graph-builder.h',
      '<(V8_ROOT)/src/compiler/bytecode-liveness-map.cc',
      '<(V8_ROOT)/src/compiler/bytecode-liveness-map.h',
      '<(V8_ROOT)/src/compiler/c-linkage.cc',
      '<(V8_ROOT)/src/compiler/checkpoint-elimination.cc',
      '<(V8_ROOT)/src/compiler/checkpoint-elimination.h',
      '<(V8_ROOT)/src/compiler/code-assembler.cc',
      '<(V8_ROOT)/src/compiler/code-assembler.h',
      '<(V8_ROOT)/src/compiler/common-node-cache.cc',
      '<(V8_ROOT)/src/compiler/common-node-cache.h',
      '<(V8_ROOT)/src/compiler/common-operator-reducer.cc',
      '<(V8_ROOT)/src/compiler/common-operator-reducer.h',
      '<(V8_ROOT)/src/compiler/common-operator.cc',
      '<(V8_ROOT)/src/compiler/common-operator.h',
      '<(V8_ROOT)/src/compiler/compilation-dependencies.cc',
      '<(V8_ROOT)/src/compiler/compilation-dependencies.h',
      '<(V8_ROOT)/src/compiler/compiler-source-position-table.cc',
      '<(V8_ROOT)/src/compiler/compiler-source-position-table.h',
      '<(V8_ROOT)/src/compiler/constant-folding-reducer.cc',
      '<(V8_ROOT)/src/compiler/constant-folding-reducer.h',
      '<(V8_ROOT)/src/compiler/control-equivalence.cc',
      '<(V8_ROOT)/src/compiler/control-equivalence.h',
      '<(V8_ROOT)/src/compiler/control-flow-optimizer.cc',
      '<(V8_ROOT)/src/compiler/control-flow-optimizer.h',
      '<(V8_ROOT)/src/compiler/dead-code-elimination.cc',
      '<(V8_ROOT)/src/compiler/dead-code-elimination.h',
      '<(V8_ROOT)/src/compiler/diamond.h',
      '<(V8_ROOT)/src/compiler/effect-control-linearizer.cc',
      '<(V8_ROOT)/src/compiler/effect-control-linearizer.h',
      '<(V8_ROOT)/src/compiler/escape-analysis-reducer.cc',
      '<(V8_ROOT)/src/compiler/escape-analysis-reducer.h',
      '<(V8_ROOT)/src/compiler/escape-analysis.cc',
      '<(V8_ROOT)/src/compiler/escape-analysis.h',
      '<(V8_ROOT)/src/compiler/frame-states.cc',
      '<(V8_ROOT)/src/compiler/frame-states.h',
      '<(V8_ROOT)/src/compiler/frame.cc',
      '<(V8_ROOT)/src/compiler/frame.h',
      '<(V8_ROOT)/src/compiler/functional-list.h',
      '<(V8_ROOT)/src/compiler/graph-assembler.cc',
      '<(V8_ROOT)/src/compiler/graph-assembler.h',
      '<(V8_ROOT)/src/compiler/graph-reducer.cc',
      '<(V8_ROOT)/src/compiler/graph-reducer.h',
      '<(V8_ROOT)/src/compiler/graph-trimmer.cc',
      '<(V8_ROOT)/src/compiler/graph-trimmer.h',
      '<(V8_ROOT)/src/compiler/graph-visualizer.cc',
      '<(V8_ROOT)/src/compiler/graph-visualizer.h',
      '<(V8_ROOT)/src/compiler/graph.cc',
      '<(V8_ROOT)/src/compiler/graph.h',
      '<(V8_ROOT)/src/compiler/int64-lowering.cc',
      '<(V8_ROOT)/src/compiler/int64-lowering.h',
      '<(V8_ROOT)/src/compiler/js-call-reducer.cc',
      '<(V8_ROOT)/src/compiler/js-call-reducer.h',
      '<(V8_ROOT)/src/compiler/js-context-specialization.cc',
      '<(V8_ROOT)/src/compiler/js-context-specialization.h',
      '<(V8_ROOT)/src/compiler/js-create-lowering.cc',
      '<(V8_ROOT)/src/compiler/js-create-lowering.h',
      '<(V8_ROOT)/src/compiler/js-generic-lowering.cc',
      '<(V8_ROOT)/src/compiler/js-generic-lowering.h',
      '<(V8_ROOT)/src/compiler/js-graph.cc',
      '<(V8_ROOT)/src/compiler/js-graph.h',
      '<(V8_ROOT)/src/compiler/js-heap-broker.cc',
      '<(V8_ROOT)/src/compiler/js-heap-broker.h',
      '<(V8_ROOT)/src/compiler/js-heap-copy-reducer.cc',
      '<(V8_ROOT)/src/compiler/js-heap-copy-reducer.h',
      '<(V8_ROOT)/src/compiler/js-inlining-heuristic.cc',
      '<(V8_ROOT)/src/compiler/js-inlining-heuristic.h',
      '<(V8_ROOT)/src/compiler/js-inlining.cc',
      '<(V8_ROOT)/src/compiler/js-inlining.h',
      '<(V8_ROOT)/src/compiler/js-intrinsic-lowering.cc',
      '<(V8_ROOT)/src/compiler/js-intrinsic-lowering.h',
      '<(V8_ROOT)/src/compiler/js-native-context-specialization.cc',
      '<(V8_ROOT)/src/compiler/js-native-context-specialization.h',
      '<(V8_ROOT)/src/compiler/js-operator.cc',
      '<(V8_ROOT)/src/compiler/js-operator.h',
      '<(V8_ROOT)/src/compiler/js-type-hint-lowering.cc',
      '<(V8_ROOT)/src/compiler/js-type-hint-lowering.h',
      '<(V8_ROOT)/src/compiler/js-typed-lowering.cc',
      '<(V8_ROOT)/src/compiler/js-typed-lowering.h',
      '<(V8_ROOT)/src/compiler/linkage.cc',
      '<(V8_ROOT)/src/compiler/linkage.h',
      '<(V8_ROOT)/src/compiler/load-elimination.cc',
      '<(V8_ROOT)/src/compiler/load-elimination.h',
      '<(V8_ROOT)/src/compiler/loop-analysis.cc',
      '<(V8_ROOT)/src/compiler/loop-analysis.h',
      '<(V8_ROOT)/src/compiler/loop-peeling.cc',
      '<(V8_ROOT)/src/compiler/loop-peeling.h',
      '<(V8_ROOT)/src/compiler/loop-variable-optimizer.cc',
      '<(V8_ROOT)/src/compiler/loop-variable-optimizer.h',
      '<(V8_ROOT)/src/compiler/machine-graph-verifier.cc',
      '<(V8_ROOT)/src/compiler/machine-graph-verifier.h',
      '<(V8_ROOT)/src/compiler/machine-graph.cc',
      '<(V8_ROOT)/src/compiler/machine-graph.h',
      '<(V8_ROOT)/src/compiler/machine-operator-reducer.cc',
      '<(V8_ROOT)/src/compiler/machine-operator-reducer.h',
      '<(V8_ROOT)/src/compiler/machine-operator.cc',
      '<(V8_ROOT)/src/compiler/machine-operator.h',
      '<(V8_ROOT)/src/compiler/memory-optimizer.cc',
      '<(V8_ROOT)/src/compiler/memory-optimizer.h',
      '<(V8_ROOT)/src/compiler/node-aux-data.h',
      '<(V8_ROOT)/src/compiler/node-cache.cc',
      '<(V8_ROOT)/src/compiler/node-cache.h',
      '<(V8_ROOT)/src/compiler/node-marker.cc',
      '<(V8_ROOT)/src/compiler/node-marker.h',
      '<(V8_ROOT)/src/compiler/node-matchers.cc',
      '<(V8_ROOT)/src/compiler/node-matchers.h',
      '<(V8_ROOT)/src/compiler/node-origin-table.cc',
      '<(V8_ROOT)/src/compiler/node-origin-table.h',
      '<(V8_ROOT)/src/compiler/node-properties.cc',
      '<(V8_ROOT)/src/compiler/node-properties.h',
      '<(V8_ROOT)/src/compiler/node.cc',
      '<(V8_ROOT)/src/compiler/node.h',
      '<(V8_ROOT)/src/compiler/opcodes.cc',
      '<(V8_ROOT)/src/compiler/opcodes.h',
      '<(V8_ROOT)/src/compiler/operation-typer.cc',
      '<(V8_ROOT)/src/compiler/operation-typer.h',
      '<(V8_ROOT)/src/compiler/operator-properties.cc',
      '<(V8_ROOT)/src/compiler/operator-properties.h',
      '<(V8_ROOT)/src/compiler/operator.cc',
      '<(V8_ROOT)/src/compiler/operator.h',
      '<(V8_ROOT)/src/compiler/osr.cc',
      '<(V8_ROOT)/src/compiler/osr.h',
      '<(V8_ROOT)/src/compiler/per-isolate-compiler-cache.h',
      '<(V8_ROOT)/src/compiler/persistent-map.h',
      '<(V8_ROOT)/src/compiler/pipeline-statistics.cc',
      '<(V8_ROOT)/src/compiler/pipeline-statistics.h',
      '<(V8_ROOT)/src/compiler/pipeline.cc',
      '<(V8_ROOT)/src/compiler/pipeline.h',
      '<(V8_ROOT)/src/compiler/property-access-builder.cc',
      '<(V8_ROOT)/src/compiler/property-access-builder.h',
      '<(V8_ROOT)/src/compiler/raw-machine-assembler.cc',
      '<(V8_ROOT)/src/compiler/raw-machine-assembler.h',
      '<(V8_ROOT)/src/compiler/redundancy-elimination.cc',
      '<(V8_ROOT)/src/compiler/redundancy-elimination.h',
      '<(V8_ROOT)/src/compiler/refs-map.cc',
      '<(V8_ROOT)/src/compiler/refs-map.h',
      '<(V8_ROOT)/src/compiler/representation-change.cc',
      '<(V8_ROOT)/src/compiler/representation-change.h',
      '<(V8_ROOT)/src/compiler/schedule.cc',
      '<(V8_ROOT)/src/compiler/schedule.h',
      '<(V8_ROOT)/src/compiler/scheduler.cc',
      '<(V8_ROOT)/src/compiler/scheduler.h',
      '<(V8_ROOT)/src/compiler/select-lowering.cc',
      '<(V8_ROOT)/src/compiler/select-lowering.h',
      '<(V8_ROOT)/src/compiler/serializer-for-background-compilation.cc',
      '<(V8_ROOT)/src/compiler/serializer-for-background-compilation.h',
      '<(V8_ROOT)/src/compiler/simd-scalar-lowering.cc',
      '<(V8_ROOT)/src/compiler/simd-scalar-lowering.h',
      '<(V8_ROOT)/src/compiler/simplified-lowering.cc',
      '<(V8_ROOT)/src/compiler/simplified-lowering.h',
      '<(V8_ROOT)/src/compiler/simplified-operator-reducer.cc',
      '<(V8_ROOT)/src/compiler/simplified-operator-reducer.h',
      '<(V8_ROOT)/src/compiler/simplified-operator.cc',
      '<(V8_ROOT)/src/compiler/simplified-operator.h',
      '<(V8_ROOT)/src/compiler/state-values-utils.cc',
      '<(V8_ROOT)/src/compiler/state-values-utils.h',
      '<(V8_ROOT)/src/compiler/store-store-elimination.cc',
      '<(V8_ROOT)/src/compiler/store-store-elimination.h',
      '<(V8_ROOT)/src/compiler/type-cache.cc',
      '<(V8_ROOT)/src/compiler/type-cache.h',
      '<(V8_ROOT)/src/compiler/type-narrowing-reducer.cc',
      '<(V8_ROOT)/src/compiler/type-narrowing-reducer.h',
      '<(V8_ROOT)/src/compiler/typed-optimization.cc',
      '<(V8_ROOT)/src/compiler/typed-optimization.h',
      '<(V8_ROOT)/src/compiler/typer.cc',
      '<(V8_ROOT)/src/compiler/typer.h',
      '<(V8_ROOT)/src/compiler/types.cc',
      '<(V8_ROOT)/src/compiler/types.h',
      '<(V8_ROOT)/src/compiler/value-numbering-reducer.cc',
      '<(V8_ROOT)/src/compiler/value-numbering-reducer.h',
      '<(V8_ROOT)/src/compiler/verifier.cc',
      '<(V8_ROOT)/src/compiler/verifier.h',
      '<(V8_ROOT)/src/compiler/wasm-compiler.cc',
      '<(V8_ROOT)/src/compiler/wasm-compiler.h',
      '<(V8_ROOT)/src/compiler/zone-stats.cc',
      '<(V8_ROOT)/src/compiler/zone-stats.h',
    ]
  },
  'includes': ['toolchain.gypi', 'features.gypi', 'v8_external_snapshot.gypi'],
  'targets': [
    {
      'target_name': 'run_torque',
      'type': 'none',
      'conditions': [
        ['want_separate_host_toolset', {
          'dependencies': ['torque#host'],
          'toolsets': ['host', 'target'],
        }, {
          'dependencies': ['torque'],
        }],
      ],
      'hard_dependency': 1,
      'direct_dependent_settings': {
        'include_dirs': [
          '<(torque_output_root)',
        ],
      },
      'actions': [
        {
          'action_name': 'run_torque_action',
          'inputs': [  # Order matters.
            '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)torque<(EXECUTABLE_SUFFIX)',
            '<@(torque_files)',
          ],
          'outputs': [
            "<(torque_output_root)/torque-generated/builtin-definitions-from-dsl.h",
            "<(torque_output_root)/torque-generated/class-definitions-from-dsl.h",
            "<(torque_output_root)/torque-generated/objects-printer-from-dsl.cc",
            '<@(torque_outputs)',
          ],
          'action': [
            '<@(_inputs)',
            '-o', '<(torque_output_root)/torque-generated'
          ],
        },
      ],
    },  # run_torque
    {
      'target_name': 'v8_maybe_icu',
      'type': 'none',
      'hard_dependency': 1,
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
        ['v8_enable_i18n_support', {
          'dependencies': [
            '<(icu_gyp_path):icui18n',
            '<(icu_gyp_path):icuuc',
          ],
          'export_dependent_settings': [
            '<(icu_gyp_path):icui18n',
            '<(icu_gyp_path):icuuc',
          ],
        }],
      ],
    },  # v8_maybe_icu
    {
      'target_name': 'torque_generated_initializers',
      'type': 'none',
      'hard_dependency': 1,
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
      ],
      'dependencies': [
        'generate_bytecode_builtins_list',
        'run_torque',
        'v8_maybe_icu',
      ],
      'direct_dependent_settings': {
        'sources': [
          '<@(torque_outputs)',
        ],
      }
    },  # torque_generated_initializers
    {
      'target_name': 'torque_generated_definitions',
      'type': 'none',
      'hard_dependency': 1,
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
      ],
      'dependencies': [
        'generate_bytecode_builtins_list',
        'run_torque',
        'v8_maybe_icu',
      ],
      'direct_dependent_settings': {
        'sources': [
          '<(torque_output_root)/torque-generated/objects-printer-from-dsl.cc',
        ],
        'include_dirs': [
          '<(torque_output_root)',
        ],
      },
    },  # torque_generated_definitions
    {
      'target_name': 'generate_bytecode_builtins_list',
      'type': 'none',
      'hard_dependency': 1,
      'conditions': [
        ['want_separate_host_toolset', {
          'dependencies': ['bytecode_builtins_list_generator#host'],
          'toolsets': ['host', 'target'],
        }, {
          'dependencies': ['bytecode_builtins_list_generator'],
        }],
      ],
      'direct_dependent_settings': {
        'sources': [
          '<(generate_bytecode_builtins_list_output)',
        ],
        'include_dirs': [
          '<(generate_bytecode_output_root)',
          '<(torque_output_root)',
        ],
      },
      'actions': [
        {
          'action_name': 'generate_bytecode_builtins_list_action',
          'inputs': [
            '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)bytecode_builtins_list_generator<(EXECUTABLE_SUFFIX)',
          ],
          'outputs': [
            '<(generate_bytecode_builtins_list_output)',
          ],
          'action': [
            'python',
            '<(V8_ROOT)/tools/run.py',
            '<@(_inputs)',
            '<@(_outputs)',
          ],
        },
      ],
    },  # generate_bytecode_builtins_list

    {
      # This rule delegates to either v8_snapshot, v8_nosnapshot, or
      # v8_external_snapshot, depending on the current variables.
      # The intention is to make the 'calling' rules a bit simpler.
      'target_name': 'v8_maybe_snapshot',
      'type': 'none',
      'toolsets': ['target'],
      'hard_dependency': 1,
      'conditions': [
        ['v8_use_snapshot!=1', {
          # The dependency on v8_base should come from a transitive
          # dependency however the Android toolchain requires libv8_base.a
          # to appear before libv8_snapshot.a so it's listed explicitly.
          'dependencies': ['v8_base', 'v8_init', 'v8_nosnapshot'],
        }],
        ['v8_use_snapshot==1 and v8_use_external_startup_data==0', {
          # The dependency on v8_base should come from a transitive
          # dependency however the Android toolchain requires libv8_base.a
          # to appear before libv8_snapshot.a so it's listed explicitly.
          'dependencies': ['v8_base', 'v8_snapshot'],
        }],
        ['v8_use_snapshot==1 and v8_use_external_startup_data==1 and want_separate_host_toolset==0', {
          'dependencies': ['v8_base', 'v8_external_snapshot'],
        }],
        ['v8_use_snapshot==1 and v8_use_external_startup_data==1 and want_separate_host_toolset==1', {
          'dependencies': ['v8_base', 'v8_external_snapshot'],
        }],
      ]
    },  # v8_maybe_snapshot
    {
      'target_name': 'v8_init',
      'type': 'static_library',
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
      ],
      'dependencies': [
        'generate_bytecode_builtins_list',
        'run_torque',
        'v8_initializers',
        'v8_maybe_icu',
      ],
      'sources': [
        ### gcmole(all) ###
        '<(V8_ROOT)/src/setup-isolate-full.cc',

        # '<(generate_bytecode_builtins_list_output)',
      ],
    },  # v8_init
    {
      'target_name': 'v8_initializers',
      'type': 'static_library',
      'dependencies': [
        'torque_generated_initializers',
      ],
      'include_dirs': [
        '<(torque_output_root)',
        '<(generate_bytecode_output_root)',
      ],
      'sources': [
        '<(V8_ROOT)/src/builtins/builtins-arguments-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-arguments-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-array-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-array-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-async-function-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-async-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-async-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-async-generator-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-async-iterator-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-bigint-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-boolean-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-call-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-call-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-collections-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-console-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-constructor-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-constructor-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-constructor.h',
        '<(V8_ROOT)/src/builtins/builtins-conversion-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-data-view-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-date-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-debug-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-function-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-generator-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-global-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-handler-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-ic-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-internal-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-interpreter-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-intl-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-iterator-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-iterator-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-lazy-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-lazy-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-math-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-math-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-microtask-queue-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-number-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-object-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-promise-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-promise-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-proxy-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-proxy-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-reflect-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-regexp-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-regexp-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-sharedarraybuffer-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-string-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-string-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-symbol-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-typed-array-gen.cc',
        '<(V8_ROOT)/src/builtins/builtins-typed-array-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-utils-gen.h',
        '<(V8_ROOT)/src/builtins/builtins-wasm-gen.cc',
        '<(V8_ROOT)/src/builtins/growable-fixed-array-gen.cc',
        '<(V8_ROOT)/src/builtins/growable-fixed-array-gen.h',
        '<(V8_ROOT)/src/builtins/setup-builtins-internal.cc',
        '<(V8_ROOT)/src/code-stub-assembler.cc',
        '<(V8_ROOT)/src/code-stub-assembler.h',
        '<(V8_ROOT)/src/heap/setup-heap-internal.cc',
        '<(V8_ROOT)/src/ic/accessor-assembler.cc',
        '<(V8_ROOT)/src/ic/accessor-assembler.h',
        '<(V8_ROOT)/src/ic/binary-op-assembler.cc',
        '<(V8_ROOT)/src/ic/binary-op-assembler.h',
        '<(V8_ROOT)/src/ic/keyed-store-generic.cc',
        '<(V8_ROOT)/src/ic/keyed-store-generic.h',
        '<(V8_ROOT)/src/interpreter/interpreter-assembler.cc',
        '<(V8_ROOT)/src/interpreter/interpreter-assembler.h',
        '<(V8_ROOT)/src/interpreter/interpreter-generator.cc',
        '<(V8_ROOT)/src/interpreter/interpreter-generator.h',
        '<(V8_ROOT)/src/interpreter/interpreter-intrinsics-generator.cc',
        '<(V8_ROOT)/src/interpreter/interpreter-intrinsics-generator.h',
        '<@(torque_outputs)',
      ],
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
        ['v8_target_arch=="ia32"', {
          'sources': [
            '<(V8_ROOT)/src/builtins/ia32/builtins-ia32.cc',
          ],
        }],
        ['v8_target_arch=="x64"', {
          'sources': [
            '<(V8_ROOT)/src/builtins/x64/builtins-x64.cc',
          ],
        }],
        ['v8_target_arch=="arm"', {
          'sources': [
            '<(V8_ROOT)/src/builtins/arm/builtins-arm.cc',
          ],
        }],
        ['v8_target_arch=="arm64"', {
          'sources': [
            '<(V8_ROOT)/src/builtins/arm64/builtins-arm64.cc',
          ],
        }],
        ['v8_target_arch=="mips" or v8_target_arch=="mipsel"', {
          'sources': [
            '<(V8_ROOT)/src/builtins/mips/builtins-mips.cc',
          ],
        }],
        ['v8_target_arch=="mips64" or v8_target_arch=="mips64el"', {
          'sources': [
            '<(V8_ROOT)/src/builtins/mips64/builtins-mips64.cc',
          ],
        }],
        ['v8_target_arch=="ppc" or v8_target_arch=="ppc64"', {
          'sources': [
            '<(V8_ROOT)/src/builtins/ppc/builtins-ppc.cc',
          ],
        }],
        ['v8_target_arch=="s390x"', {
          'sources': [
            '<(V8_ROOT)/src/builtins/s390/builtins-s390.cc',
          ],
        }],
        ['v8_enable_i18n_support==1', {
          'dependencies': [
            '<(icu_gyp_path):icui18n',
            '<(icu_gyp_path):icuuc',
          ],
        }, {
           'sources!': [
             '<(V8_ROOT)/src/builtins/builtins-intl-gen.cc',
           ],
         }],
        ['OS=="win"', {
          'msvs_precompiled_header': '<(V8_ROOT)/../../tools/msvs/pch/v8_pch.h',
          'msvs_precompiled_source': '<(V8_ROOT)/../../tools/msvs/pch/v8_pch.cc',
          'sources': [
            '<(_msvs_precompiled_header)',
            '<(_msvs_precompiled_source)',
          ],
        }],
      ],
    },  # v8_initializers
    {
      'target_name': 'v8_snapshot',
      'type': 'static_library',
      'toolsets': ['target'],
      'conditions': [
        ['want_separate_host_toolset', {
          'dependencies': [
            'generate_bytecode_builtins_list',
            'run_torque',
            'mksnapshot#host',
            'v8_maybe_icu',
            # [GYP] added explicitly, instead of inheriting from the other deps
            'v8_base_without_compiler',
            'v8_compiler_for_mksnapshot',
            'v8_initializers',
            'v8_libplatform',
          ]
        }, {
          'dependencies': [
            'generate_bytecode_builtins_list',
            'run_torque',
            'mksnapshot',
            'v8_maybe_icu',
            # [GYP] added explicitly, instead of inheriting from the other deps
            'v8_base_without_compiler',
            'v8_compiler_for_mksnapshot',
            'v8_initializers',
            'v8_libplatform',
          ]
        }],
      ],
      'sources': [
        '<(V8_ROOT)/src/setup-isolate-deserialize.cc',
        './extras-libraries.cc',
      ],
      'xcode_settings': {
        # V8 7.4 over macOS10.11 compatibility
        # Refs: https://github.com/nodejs/node/pull/26685
        'GCC_GENERATE_DEBUGGING_SYMBOLS': 'NO',
      },
      'actions': [
        {
          'action_name': 'run_mksnapshot',
          'message': 'generating: >@(_outputs)',
          'variables': {
            'mksnapshot_flags': [
              '--turbo_instruction_scheduling',
              # In cross builds, the snapshot may be generated for both the host and
              # target toolchains.  The same host binary is used to generate both, so
              # mksnapshot needs to know which target OS to use at runtime.  It's weird,
              # but the target OS is really <(OS).
              '--target_os=<(OS)',
            ],
          },
          'inputs': [
            '<(mksnapshot_exec)',
          ],
          'process_outputs_as_sources': 1,
          'conditions': [
            ['v8_enable_embedded_builtins', {
              # In this case we use `embedded_variant "Default"`
              # and `suffix = ''` for the template `embedded${suffix}.S`.
              'outputs': ['<(INTERMEDIATE_DIR)/embedded.S'],
              'variables': {
                'mksnapshot_flags': [
                  '--embedded_variant', 'Default',
                  '--embedded_src', '<(INTERMEDIATE_DIR)/embedded.S',
                ],
              },
            }, {
               'outputs': ['<(V8_ROOT)/src/snapshot/embedded-empty.cc']
             }],
            ['v8_random_seed', {
              'variables': {
                'mksnapshot_flags': ['--random-seed', '<(v8_random_seed)'],
              },
            }],
            ['v8_os_page_size', {
              'variables': {
                'mksnapshot_flags': ['--v8_os_page_size', '<(v8_os_page_size)'],
              },
            }],
            ['v8_use_external_startup_data', {
              'outputs': ['<(INTERMEDIATE_DIR)/snapshot_blob.bin', ],
              'variables': {
                'mksnapshot_flags': ['--startup_blob', '<(INTERMEDIATE_DIR)/snapshot_blob.bin', ],
              },
            }, {
               'outputs': ["<(INTERMEDIATE_DIR)/snapshot.cc"],
               'variables': {
                 'mksnapshot_flags': ['--startup_src', '<(INTERMEDIATE_DIR)/snapshot.cc', ],
               },
             }],
            ['v8_embed_script != ""', {
              'inputs': ['<(v8_embed_script)'],
              'variables': {
                'mksnapshot_flags': ['<(v8_embed_script)'],
              },
            }],
            ['v8_enable_snapshot_code_comments', {
              'variables': {
                'mksnapshot_flags': ['--code-comments'],
              },
            }],
            ['v8_win64_unwinding_info', {
              'variables': {
                'mksnapshot_flags': ['--win64-unwinding-info'],
              },
            }],
            ['v8_enable_snapshot_native_code_counters', {
              'variables': {
                'mksnapshot_flags': ['--native-code-counters'],
              },
            }, {
               # --native-code-counters is the default in debug mode so make sure we can
               # unset it.
               'variables': {
                 'mksnapshot_flags': ['--no-native-code-counters'],
               },
             }],
          ],
          'action': [
            '>@(_inputs)',
            '>@(mksnapshot_flags)',
          ],
        },
      ],
    },  # v8_snapshot
    {
      'target_name': 'v8_nosnapshot',
      'type': 'static_library',
      'dependencies': [
        # 'js2c_extras',  # Disabled for Node.js
        'generate_bytecode_builtins_list',
        'run_torque',
        'v8_maybe_icu',
      ],
      'sources': [
        './extras-libraries.cc',
        '<(V8_ROOT)/src/snapshot/embedded-empty.cc',
        '<(V8_ROOT)/src/snapshot/snapshot-empty.cc',
      ],
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
        ['component=="shared_library"', {
          'defines': [
            'BUILDING_V8_SHARED',
          ],
        }],
      ]
    },  # v8_nosnapshot
    {
      'target_name': 'v8_version',
      'type': 'none',
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
      ],
      'direct_dependent_settings': {
        'sources': [
          '<(V8_ROOT)/include/v8-value-serializer-version.h',
          '<(V8_ROOT)/include/v8-version-string.h',
          '<(V8_ROOT)/include/v8-version.h',
        ],
      },
    },  # v8_version
    {
      'target_name': 'v8_headers',
      'type': 'none',
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
      ],
      'dependencies': [
        'v8_version',
      ],
      'direct_dependent_settings': {
        'sources': [
          '<(V8_ROOT)/include/v8-internal.h',
          '<(V8_ROOT)/include/v8.h',
          '<(V8_ROOT)/include/v8config.h',

          # The following headers cannot be platform-specific. The include validation
          # of `gn gen $dir --check` requires all header files to be available on all
          # platforms.
          '<(V8_ROOT)/include/v8-wasm-trap-handler-posix.h',
          '<(V8_ROOT)/include/v8-wasm-trap-handler-win.h',
        ],
      },
    },  # v8_headers
    {
      'target_name': 'v8_shared_internal_headers',
      'type': 'none',
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
      ],
      'dependencies': [
        'v8_headers',
      ],
      'direct_dependent_settings': {
        'sources': [
          '<(V8_ROOT)/src/globals.h',
        ],
      },
    },  # v8_shared_internal_headers
    {
      'target_name': 'v8_compiler_opt',
      'type': 'static_library',
      'dependencies': [
        'generate_bytecode_builtins_list',
        'run_torque',
        'v8_maybe_icu',
      ],
      'sources': ['<@(v8_compiler_sources)'],
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
        ['OS=="win"', {
          'msvs_precompiled_header': '<(V8_ROOT)/../../tools/msvs/pch/v8_pch.h',
          'msvs_precompiled_source': '<(V8_ROOT)/../../tools/msvs/pch/v8_pch.cc',
          'sources': [
            '<(_msvs_precompiled_header)',
            '<(_msvs_precompiled_source)',
          ],
        }],
      ],
    },  # v8_compiler_opt
    {
      'target_name': 'v8_compiler',
      'type': 'static_library',
      'dependencies': [
        'generate_bytecode_builtins_list',
        'run_torque',
        'v8_maybe_icu',
      ],
      'sources': ['<@(v8_compiler_sources)'],
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
        ['OS=="win"', {
          'msvs_precompiled_header': '<(V8_ROOT)/../../tools/msvs/pch/v8_pch.h',
          'msvs_precompiled_source': '<(V8_ROOT)/../../tools/msvs/pch/v8_pch.cc',
          'sources': [
            '<(_msvs_precompiled_header)',
            '<(_msvs_precompiled_source)',
          ],
        }],
      ],
    },  # v8_compiler
    {
      'target_name': 'v8_compiler_for_mksnapshot',
      'type': 'none',
      'hard_dependency': 1,
      'dependencies': [
        'generate_bytecode_builtins_list',
        'run_torque',
        'v8_maybe_icu',
      ],
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
        ['is_component_build and not v8_optimized_debug and v8_enable_fast_mksnapshot', {
          'dependencies': [
            'v8_compiler_opt',
          ],
          'export_dependent_settings': [
            'v8_compiler_opt',
          ],
        }, {
           'dependencies': [
             'v8_compiler',
           ],
           'export_dependent_settings': [
             'v8_compiler',
           ],
         }],
      ],
    },  # v8_compiler_for_mksnapshot
    {
      'target_name': 'v8_base_without_compiler',
      'type': 'static_library',
      'dependencies': [
        # Code generators that only need to be build for the host.
        'torque_generated_definitions',
        'v8_headers',
        'v8_libbase',
        'v8_libsampler',
        'v8_shared_internal_headers',
        'v8_version',
        # BUILD.gn public_deps
        'generate_bytecode_builtins_list',
        'run_torque',
        'v8_maybe_icu',
      ],
      'includes': ['inspector.gypi'],
      'direct_dependent_settings': {
        'include_dirs': [
          '<(generate_bytecode_output_root)',
          '<(torque_output_root)',
        ],
      },
      'sources': [
        # "//base/trace_event/common/trace_event_common.h",

        ### gcmole(all) ###
        '<(generate_bytecode_builtins_list_output)',
        '<(V8_ROOT)/include/v8-inspector-protocol.h',
        '<(V8_ROOT)/include/v8-inspector.h',
        '<(V8_ROOT)/include/v8-internal.h',
        '<(V8_ROOT)/include/v8-platform.h',
        '<(V8_ROOT)/include/v8-profiler.h',
        '<(V8_ROOT)/include/v8-testing.h',
        '<(V8_ROOT)/include/v8-util.h',
        '<(V8_ROOT)/include/v8-wasm-trap-handler-posix.h',
        '<(V8_ROOT)/include/v8.h',
        '<(V8_ROOT)/include/v8config.h',
        '<(V8_ROOT)/src/accessors.cc',
        '<(V8_ROOT)/src/accessors.h',
        '<(V8_ROOT)/src/address-map.cc',
        '<(V8_ROOT)/src/address-map.h',
        '<(V8_ROOT)/src/allocation-site-scopes-inl.h',
        '<(V8_ROOT)/src/allocation-site-scopes.h',
        '<(V8_ROOT)/src/allocation.cc',
        '<(V8_ROOT)/src/allocation.h',
        '<(V8_ROOT)/src/api-arguments-inl.h',
        '<(V8_ROOT)/src/api-arguments.cc',
        '<(V8_ROOT)/src/api-arguments.h',
        '<(V8_ROOT)/src/api-natives.cc',
        '<(V8_ROOT)/src/api-natives.h',
        '<(V8_ROOT)/src/api.cc',
        '<(V8_ROOT)/src/api.h',
        '<(V8_ROOT)/src/arguments-inl.h',
        '<(V8_ROOT)/src/arguments.cc',
        '<(V8_ROOT)/src/arguments.h',
        '<(V8_ROOT)/src/asan.h',
        '<(V8_ROOT)/src/asmjs/asm-js.cc',
        '<(V8_ROOT)/src/asmjs/asm-js.h',
        '<(V8_ROOT)/src/asmjs/asm-names.h',
        '<(V8_ROOT)/src/asmjs/asm-parser.cc',
        '<(V8_ROOT)/src/asmjs/asm-parser.h',
        '<(V8_ROOT)/src/asmjs/asm-scanner.cc',
        '<(V8_ROOT)/src/asmjs/asm-scanner.h',
        '<(V8_ROOT)/src/asmjs/asm-types.cc',
        '<(V8_ROOT)/src/asmjs/asm-types.h',
        '<(V8_ROOT)/src/assembler-arch.h',
        '<(V8_ROOT)/src/assembler-inl.h',
        '<(V8_ROOT)/src/assembler.cc',
        '<(V8_ROOT)/src/assembler.h',
        '<(V8_ROOT)/src/assert-scope.cc',
        '<(V8_ROOT)/src/assert-scope.h',
        '<(V8_ROOT)/src/ast/ast-function-literal-id-reindexer.cc',
        '<(V8_ROOT)/src/ast/ast-function-literal-id-reindexer.h',
        '<(V8_ROOT)/src/ast/ast-source-ranges.h',
        '<(V8_ROOT)/src/ast/ast-traversal-visitor.h',
        '<(V8_ROOT)/src/ast/ast-value-factory.cc',
        '<(V8_ROOT)/src/ast/ast-value-factory.h',
        '<(V8_ROOT)/src/ast/ast.cc',
        '<(V8_ROOT)/src/ast/ast.h',
        '<(V8_ROOT)/src/ast/modules.cc',
        '<(V8_ROOT)/src/ast/modules.h',
        '<(V8_ROOT)/src/ast/prettyprinter.cc',
        '<(V8_ROOT)/src/ast/prettyprinter.h',
        '<(V8_ROOT)/src/ast/scopes.cc',
        '<(V8_ROOT)/src/ast/scopes.h',
        '<(V8_ROOT)/src/ast/source-range-ast-visitor.cc',
        '<(V8_ROOT)/src/ast/source-range-ast-visitor.h',
        '<(V8_ROOT)/src/ast/variables.cc',
        '<(V8_ROOT)/src/ast/variables.h',
        '<(V8_ROOT)/src/bailout-reason.cc',
        '<(V8_ROOT)/src/bailout-reason.h',
        '<(V8_ROOT)/src/basic-block-profiler.cc',
        '<(V8_ROOT)/src/basic-block-profiler.h',
        '<(V8_ROOT)/src/bignum-dtoa.cc',
        '<(V8_ROOT)/src/bignum-dtoa.h',
        '<(V8_ROOT)/src/bignum.cc',
        '<(V8_ROOT)/src/bignum.h',
        '<(V8_ROOT)/src/bit-vector.cc',
        '<(V8_ROOT)/src/bit-vector.h',
        '<(V8_ROOT)/src/bootstrapper.cc',
        '<(V8_ROOT)/src/bootstrapper.h',
        '<(V8_ROOT)/src/boxed-float.h',
        '<(V8_ROOT)/src/builtins/builtins-api.cc',
        '<(V8_ROOT)/src/builtins/builtins-array.cc',
        '<(V8_ROOT)/src/builtins/builtins-arraybuffer.cc',
        '<(V8_ROOT)/src/builtins/builtins-bigint.cc',
        '<(V8_ROOT)/src/builtins/builtins-boolean.cc',
        '<(V8_ROOT)/src/builtins/builtins-call.cc',
        '<(V8_ROOT)/src/builtins/builtins-callsite.cc',
        '<(V8_ROOT)/src/builtins/builtins-collections.cc',
        '<(V8_ROOT)/src/builtins/builtins-console.cc',
        '<(V8_ROOT)/src/builtins/builtins-constructor.h',
        '<(V8_ROOT)/src/builtins/builtins-dataview.cc',
        '<(V8_ROOT)/src/builtins/builtins-date.cc',
        '<(V8_ROOT)/src/builtins/builtins-definitions.h',
        '<(V8_ROOT)/src/builtins/builtins-descriptors.h',
        '<(V8_ROOT)/src/builtins/builtins-error.cc',
        '<(V8_ROOT)/src/builtins/builtins-extras-utils.cc',
        '<(V8_ROOT)/src/builtins/builtins-function.cc',
        '<(V8_ROOT)/src/builtins/builtins-global.cc',
        '<(V8_ROOT)/src/builtins/builtins-internal.cc',
        '<(V8_ROOT)/src/builtins/builtins-intl.cc',
        '<(V8_ROOT)/src/builtins/builtins-json.cc',
        '<(V8_ROOT)/src/builtins/builtins-math.cc',
        '<(V8_ROOT)/src/builtins/builtins-number.cc',
        '<(V8_ROOT)/src/builtins/builtins-object.cc',
        '<(V8_ROOT)/src/builtins/builtins-promise.cc',
        '<(V8_ROOT)/src/builtins/builtins-promise.h',
        '<(V8_ROOT)/src/builtins/builtins-reflect.cc',
        '<(V8_ROOT)/src/builtins/builtins-regexp.cc',
        '<(V8_ROOT)/src/builtins/builtins-sharedarraybuffer.cc',
        '<(V8_ROOT)/src/builtins/builtins-string.cc',
        '<(V8_ROOT)/src/builtins/builtins-symbol.cc',
        '<(V8_ROOT)/src/builtins/builtins-trace.cc',
        '<(V8_ROOT)/src/builtins/builtins-typed-array.cc',
        '<(V8_ROOT)/src/builtins/builtins-utils-inl.h',
        '<(V8_ROOT)/src/builtins/builtins-utils.h',
        '<(V8_ROOT)/src/builtins/builtins-weak-refs.cc',
        '<(V8_ROOT)/src/builtins/builtins.cc',
        '<(V8_ROOT)/src/builtins/builtins.h',
        '<(V8_ROOT)/src/builtins/constants-table-builder.cc',
        '<(V8_ROOT)/src/builtins/constants-table-builder.h',
        '<(V8_ROOT)/src/cached-powers.cc',
        '<(V8_ROOT)/src/cached-powers.h',
        '<(V8_ROOT)/src/callable.h',
        '<(V8_ROOT)/src/cancelable-task.cc',
        '<(V8_ROOT)/src/cancelable-task.h',
        '<(V8_ROOT)/src/char-predicates-inl.h',
        '<(V8_ROOT)/src/char-predicates.cc',
        '<(V8_ROOT)/src/char-predicates.h',
        '<(V8_ROOT)/src/checks.h',
        '<(V8_ROOT)/src/code-comments.cc',
        '<(V8_ROOT)/src/code-comments.h',
        '<(V8_ROOT)/src/code-desc.cc',
        '<(V8_ROOT)/src/code-desc.h',
        '<(V8_ROOT)/src/code-events.h',
        '<(V8_ROOT)/src/code-factory.cc',
        '<(V8_ROOT)/src/code-factory.h',
        '<(V8_ROOT)/src/code-reference.cc',
        '<(V8_ROOT)/src/code-reference.h',
        '<(V8_ROOT)/src/code-tracer.h',
        '<(V8_ROOT)/src/collector.h',
        '<(V8_ROOT)/src/compilation-cache.cc',
        '<(V8_ROOT)/src/compilation-cache.h',
        '<(V8_ROOT)/src/compilation-statistics.cc',
        '<(V8_ROOT)/src/compilation-statistics.h',
        '<(V8_ROOT)/src/compiler-dispatcher/compiler-dispatcher.cc',
        '<(V8_ROOT)/src/compiler-dispatcher/compiler-dispatcher.h',
        '<(V8_ROOT)/src/compiler-dispatcher/optimizing-compile-dispatcher.cc',
        '<(V8_ROOT)/src/compiler-dispatcher/optimizing-compile-dispatcher.h',
        '<(V8_ROOT)/src/compiler.cc',
        '<(V8_ROOT)/src/compiler.h',
        '<(V8_ROOT)/src/constant-pool.cc',
        '<(V8_ROOT)/src/constant-pool.h',
        '<(V8_ROOT)/src/constants-arch.h',
        '<(V8_ROOT)/src/contexts-inl.h',
        '<(V8_ROOT)/src/contexts.cc',
        '<(V8_ROOT)/src/contexts.h',
        '<(V8_ROOT)/src/conversions-inl.h',
        '<(V8_ROOT)/src/conversions.cc',
        '<(V8_ROOT)/src/conversions.h',
        '<(V8_ROOT)/src/counters-definitions.h',
        '<(V8_ROOT)/src/counters-inl.h',
        '<(V8_ROOT)/src/counters.cc',
        '<(V8_ROOT)/src/counters.h',
        '<(V8_ROOT)/src/cpu-features.h',
        '<(V8_ROOT)/src/date.cc',
        '<(V8_ROOT)/src/date.h',
        '<(V8_ROOT)/src/dateparser-inl.h',
        '<(V8_ROOT)/src/dateparser.cc',
        '<(V8_ROOT)/src/dateparser.h',
        '<(V8_ROOT)/src/debug/debug-coverage.cc',
        '<(V8_ROOT)/src/debug/debug-coverage.h',
        '<(V8_ROOT)/src/debug/debug-evaluate.cc',
        '<(V8_ROOT)/src/debug/debug-evaluate.h',
        '<(V8_ROOT)/src/debug/debug-frames.cc',
        '<(V8_ROOT)/src/debug/debug-frames.h',
        '<(V8_ROOT)/src/debug/debug-interface.h',
        '<(V8_ROOT)/src/debug/debug-property-iterator.cc',
        '<(V8_ROOT)/src/debug/debug-property-iterator.h',
        '<(V8_ROOT)/src/debug/debug-scope-iterator.cc',
        '<(V8_ROOT)/src/debug/debug-scope-iterator.h',
        '<(V8_ROOT)/src/debug/debug-scopes.cc',
        '<(V8_ROOT)/src/debug/debug-scopes.h',
        '<(V8_ROOT)/src/debug/debug-stack-trace-iterator.cc',
        '<(V8_ROOT)/src/debug/debug-stack-trace-iterator.h',
        '<(V8_ROOT)/src/debug/debug-type-profile.cc',
        '<(V8_ROOT)/src/debug/debug-type-profile.h',
        '<(V8_ROOT)/src/debug/debug.cc',
        '<(V8_ROOT)/src/debug/debug.h',
        '<(V8_ROOT)/src/debug/interface-types.h',
        '<(V8_ROOT)/src/debug/liveedit.cc',
        '<(V8_ROOT)/src/debug/liveedit.h',
        '<(V8_ROOT)/src/deoptimize-reason.cc',
        '<(V8_ROOT)/src/deoptimize-reason.h',
        '<(V8_ROOT)/src/deoptimizer.cc',
        '<(V8_ROOT)/src/deoptimizer.h',
        '<(V8_ROOT)/src/detachable-vector.cc',
        '<(V8_ROOT)/src/detachable-vector.h',
        '<(V8_ROOT)/src/disasm.h',
        '<(V8_ROOT)/src/disassembler.cc',
        '<(V8_ROOT)/src/disassembler.h',
        '<(V8_ROOT)/src/diy-fp.cc',
        '<(V8_ROOT)/src/diy-fp.h',
        '<(V8_ROOT)/src/double.h',
        '<(V8_ROOT)/src/dtoa.cc',
        '<(V8_ROOT)/src/dtoa.h',
        '<(V8_ROOT)/src/eh-frame.cc',
        '<(V8_ROOT)/src/eh-frame.h',
        '<(V8_ROOT)/src/elements-inl.h',
        '<(V8_ROOT)/src/elements-kind.cc',
        '<(V8_ROOT)/src/elements-kind.h',
        '<(V8_ROOT)/src/elements.cc',
        '<(V8_ROOT)/src/elements.h',
        '<(V8_ROOT)/src/execution.cc',
        '<(V8_ROOT)/src/execution.h',
        '<(V8_ROOT)/src/extensions/externalize-string-extension.cc',
        '<(V8_ROOT)/src/extensions/externalize-string-extension.h',
        '<(V8_ROOT)/src/extensions/free-buffer-extension.cc',
        '<(V8_ROOT)/src/extensions/free-buffer-extension.h',
        '<(V8_ROOT)/src/extensions/gc-extension.cc',
        '<(V8_ROOT)/src/extensions/gc-extension.h',
        '<(V8_ROOT)/src/extensions/ignition-statistics-extension.cc',
        '<(V8_ROOT)/src/extensions/ignition-statistics-extension.h',
        '<(V8_ROOT)/src/extensions/statistics-extension.cc',
        '<(V8_ROOT)/src/extensions/statistics-extension.h',
        '<(V8_ROOT)/src/extensions/trigger-failure-extension.cc',
        '<(V8_ROOT)/src/extensions/trigger-failure-extension.h',
        '<(V8_ROOT)/src/external-reference-table.cc',
        '<(V8_ROOT)/src/external-reference-table.h',
        '<(V8_ROOT)/src/external-reference.cc',
        '<(V8_ROOT)/src/external-reference.h',
        '<(V8_ROOT)/src/fast-dtoa.cc',
        '<(V8_ROOT)/src/fast-dtoa.h',
        '<(V8_ROOT)/src/feedback-vector-inl.h',
        '<(V8_ROOT)/src/feedback-vector.cc',
        '<(V8_ROOT)/src/feedback-vector.h',
        '<(V8_ROOT)/src/field-index-inl.h',
        '<(V8_ROOT)/src/field-index.h',
        '<(V8_ROOT)/src/field-type.cc',
        '<(V8_ROOT)/src/field-type.h',
        '<(V8_ROOT)/src/fixed-dtoa.cc',
        '<(V8_ROOT)/src/fixed-dtoa.h',
        '<(V8_ROOT)/src/flag-definitions.h',
        '<(V8_ROOT)/src/flags.cc',
        '<(V8_ROOT)/src/flags.h',
        '<(V8_ROOT)/src/flush-instruction-cache.cc',
        '<(V8_ROOT)/src/flush-instruction-cache.h',
        '<(V8_ROOT)/src/frame-constants.h',
        '<(V8_ROOT)/src/frames-inl.h',
        '<(V8_ROOT)/src/frames.cc',
        '<(V8_ROOT)/src/frames.h',
        '<(V8_ROOT)/src/function-kind.h',
        '<(V8_ROOT)/src/futex-emulation.cc',
        '<(V8_ROOT)/src/futex-emulation.h',
        '<(V8_ROOT)/src/gdb-jit.cc',
        '<(V8_ROOT)/src/gdb-jit.h',
        '<(V8_ROOT)/src/global-handles.cc',
        '<(V8_ROOT)/src/global-handles.h',
        '<(V8_ROOT)/src/handler-table.cc',
        '<(V8_ROOT)/src/handler-table.h',
        '<(V8_ROOT)/src/handles-inl.h',
        '<(V8_ROOT)/src/handles.cc',
        '<(V8_ROOT)/src/handles.h',
        '<(V8_ROOT)/src/hash-seed-inl.h',
        '<(V8_ROOT)/src/heap-symbols.h',
        '<(V8_ROOT)/src/heap/array-buffer-collector.cc',
        '<(V8_ROOT)/src/heap/array-buffer-collector.h',
        '<(V8_ROOT)/src/heap/array-buffer-tracker-inl.h',
        '<(V8_ROOT)/src/heap/array-buffer-tracker.cc',
        '<(V8_ROOT)/src/heap/array-buffer-tracker.h',
        '<(V8_ROOT)/src/heap/barrier.h',
        '<(V8_ROOT)/src/heap/code-stats.cc',
        '<(V8_ROOT)/src/heap/code-stats.h',
        '<(V8_ROOT)/src/heap/concurrent-marking.cc',
        '<(V8_ROOT)/src/heap/concurrent-marking.h',
        '<(V8_ROOT)/src/heap/embedder-tracing.cc',
        '<(V8_ROOT)/src/heap/embedder-tracing.h',
        '<(V8_ROOT)/src/heap/factory-inl.h',
        '<(V8_ROOT)/src/heap/factory.cc',
        '<(V8_ROOT)/src/heap/factory.h',
        '<(V8_ROOT)/src/heap/gc-idle-time-handler.cc',
        '<(V8_ROOT)/src/heap/gc-idle-time-handler.h',
        '<(V8_ROOT)/src/heap/gc-tracer.cc',
        '<(V8_ROOT)/src/heap/gc-tracer.h',
        '<(V8_ROOT)/src/heap/heap-controller.cc',
        '<(V8_ROOT)/src/heap/heap-controller.h',
        '<(V8_ROOT)/src/heap/heap-inl.h',
        '<(V8_ROOT)/src/heap/heap-write-barrier-inl.h',
        '<(V8_ROOT)/src/heap/heap-write-barrier.h',
        '<(V8_ROOT)/src/heap/heap.cc',
        '<(V8_ROOT)/src/heap/heap.h',
        '<(V8_ROOT)/src/heap/incremental-marking-inl.h',
        '<(V8_ROOT)/src/heap/incremental-marking-job.cc',
        '<(V8_ROOT)/src/heap/incremental-marking-job.h',
        '<(V8_ROOT)/src/heap/incremental-marking.cc',
        '<(V8_ROOT)/src/heap/incremental-marking.h',
        '<(V8_ROOT)/src/heap/invalidated-slots-inl.h',
        '<(V8_ROOT)/src/heap/invalidated-slots.cc',
        '<(V8_ROOT)/src/heap/invalidated-slots.h',
        '<(V8_ROOT)/src/heap/item-parallel-job.cc',
        '<(V8_ROOT)/src/heap/item-parallel-job.h',
        '<(V8_ROOT)/src/heap/local-allocator-inl.h',
        '<(V8_ROOT)/src/heap/local-allocator.h',
        '<(V8_ROOT)/src/heap/mark-compact-inl.h',
        '<(V8_ROOT)/src/heap/mark-compact.cc',
        '<(V8_ROOT)/src/heap/mark-compact.h',
        '<(V8_ROOT)/src/heap/marking.cc',
        '<(V8_ROOT)/src/heap/marking.h',
        '<(V8_ROOT)/src/heap/memory-reducer.cc',
        '<(V8_ROOT)/src/heap/memory-reducer.h',
        '<(V8_ROOT)/src/heap/object-stats.cc',
        '<(V8_ROOT)/src/heap/object-stats.h',
        '<(V8_ROOT)/src/heap/objects-visiting-inl.h',
        '<(V8_ROOT)/src/heap/objects-visiting.cc',
        '<(V8_ROOT)/src/heap/objects-visiting.h',
        '<(V8_ROOT)/src/heap/read-only-heap.cc',
        '<(V8_ROOT)/src/heap/read-only-heap.h',
        '<(V8_ROOT)/src/heap/remembered-set.h',
        '<(V8_ROOT)/src/heap/scavenge-job.cc',
        '<(V8_ROOT)/src/heap/scavenge-job.h',
        '<(V8_ROOT)/src/heap/scavenger-inl.h',
        '<(V8_ROOT)/src/heap/scavenger.cc',
        '<(V8_ROOT)/src/heap/scavenger.h',
        '<(V8_ROOT)/src/heap/slot-set.cc',
        '<(V8_ROOT)/src/heap/slot-set.h',
        '<(V8_ROOT)/src/heap/spaces-inl.h',
        '<(V8_ROOT)/src/heap/spaces.cc',
        '<(V8_ROOT)/src/heap/spaces.h',
        '<(V8_ROOT)/src/heap/store-buffer-inl.h',
        '<(V8_ROOT)/src/heap/store-buffer.cc',
        '<(V8_ROOT)/src/heap/store-buffer.h',
        '<(V8_ROOT)/src/heap/stress-marking-observer.cc',
        '<(V8_ROOT)/src/heap/stress-marking-observer.h',
        '<(V8_ROOT)/src/heap/stress-scavenge-observer.cc',
        '<(V8_ROOT)/src/heap/stress-scavenge-observer.h',
        '<(V8_ROOT)/src/heap/sweeper.cc',
        '<(V8_ROOT)/src/heap/sweeper.h',
        '<(V8_ROOT)/src/heap/worklist.h',
        '<(V8_ROOT)/src/ic/call-optimization.cc',
        '<(V8_ROOT)/src/ic/call-optimization.h',
        '<(V8_ROOT)/src/ic/handler-configuration-inl.h',
        '<(V8_ROOT)/src/ic/handler-configuration.cc',
        '<(V8_ROOT)/src/ic/handler-configuration.h',
        '<(V8_ROOT)/src/ic/ic-inl.h',
        '<(V8_ROOT)/src/ic/ic-stats.cc',
        '<(V8_ROOT)/src/ic/ic-stats.h',
        '<(V8_ROOT)/src/ic/ic.cc',
        '<(V8_ROOT)/src/ic/ic.h',
        '<(V8_ROOT)/src/ic/stub-cache.cc',
        '<(V8_ROOT)/src/ic/stub-cache.h',
        '<(V8_ROOT)/src/icu_util.cc',
        '<(V8_ROOT)/src/icu_util.h',
        '<(V8_ROOT)/src/identity-map.cc',
        '<(V8_ROOT)/src/identity-map.h',
        '<(V8_ROOT)/src/interface-descriptors.cc',
        '<(V8_ROOT)/src/interface-descriptors.h',
        '<(V8_ROOT)/src/interpreter/block-coverage-builder.h',
        '<(V8_ROOT)/src/interpreter/bytecode-array-accessor.cc',
        '<(V8_ROOT)/src/interpreter/bytecode-array-accessor.h',
        '<(V8_ROOT)/src/interpreter/bytecode-array-builder.cc',
        '<(V8_ROOT)/src/interpreter/bytecode-array-builder.h',
        '<(V8_ROOT)/src/interpreter/bytecode-array-iterator.cc',
        '<(V8_ROOT)/src/interpreter/bytecode-array-iterator.h',
        '<(V8_ROOT)/src/interpreter/bytecode-array-random-iterator.cc',
        '<(V8_ROOT)/src/interpreter/bytecode-array-random-iterator.h',
        '<(V8_ROOT)/src/interpreter/bytecode-array-writer.cc',
        '<(V8_ROOT)/src/interpreter/bytecode-array-writer.h',
        '<(V8_ROOT)/src/interpreter/bytecode-decoder.cc',
        '<(V8_ROOT)/src/interpreter/bytecode-decoder.h',
        '<(V8_ROOT)/src/interpreter/bytecode-flags.cc',
        '<(V8_ROOT)/src/interpreter/bytecode-flags.h',
        '<(V8_ROOT)/src/interpreter/bytecode-generator.cc',
        '<(V8_ROOT)/src/interpreter/bytecode-generator.h',
        '<(V8_ROOT)/src/interpreter/bytecode-jump-table.h',
        '<(V8_ROOT)/src/interpreter/bytecode-label.cc',
        '<(V8_ROOT)/src/interpreter/bytecode-label.h',
        '<(V8_ROOT)/src/interpreter/bytecode-node.cc',
        '<(V8_ROOT)/src/interpreter/bytecode-node.h',
        '<(V8_ROOT)/src/interpreter/bytecode-operands.cc',
        '<(V8_ROOT)/src/interpreter/bytecode-operands.h',
        '<(V8_ROOT)/src/interpreter/bytecode-register-allocator.h',
        '<(V8_ROOT)/src/interpreter/bytecode-register-optimizer.cc',
        '<(V8_ROOT)/src/interpreter/bytecode-register-optimizer.h',
        '<(V8_ROOT)/src/interpreter/bytecode-register.cc',
        '<(V8_ROOT)/src/interpreter/bytecode-register.h',
        '<(V8_ROOT)/src/interpreter/bytecode-source-info.cc',
        '<(V8_ROOT)/src/interpreter/bytecode-source-info.h',
        '<(V8_ROOT)/src/interpreter/bytecode-traits.h',
        '<(V8_ROOT)/src/interpreter/bytecodes.cc',
        '<(V8_ROOT)/src/interpreter/bytecodes.h',
        '<(V8_ROOT)/src/interpreter/constant-array-builder.cc',
        '<(V8_ROOT)/src/interpreter/constant-array-builder.h',
        '<(V8_ROOT)/src/interpreter/control-flow-builders.cc',
        '<(V8_ROOT)/src/interpreter/control-flow-builders.h',
        '<(V8_ROOT)/src/interpreter/handler-table-builder.cc',
        '<(V8_ROOT)/src/interpreter/handler-table-builder.h',
        '<(V8_ROOT)/src/interpreter/interpreter-generator.h',
        '<(V8_ROOT)/src/interpreter/interpreter-intrinsics.cc',
        '<(V8_ROOT)/src/interpreter/interpreter-intrinsics.h',
        '<(V8_ROOT)/src/interpreter/interpreter.cc',
        '<(V8_ROOT)/src/interpreter/interpreter.h',
        '<(V8_ROOT)/src/isolate-allocator.cc',
        '<(V8_ROOT)/src/isolate-allocator.h',
        '<(V8_ROOT)/src/isolate-data.h',
        '<(V8_ROOT)/src/isolate-inl.h',
        '<(V8_ROOT)/src/isolate.cc',
        '<(V8_ROOT)/src/isolate.h',
        '<(V8_ROOT)/src/json-parser.cc',
        '<(V8_ROOT)/src/json-parser.h',
        '<(V8_ROOT)/src/json-stringifier.cc',
        '<(V8_ROOT)/src/json-stringifier.h',
        '<(V8_ROOT)/src/keys.cc',
        '<(V8_ROOT)/src/keys.h',
        '<(V8_ROOT)/src/label.h',
        '<(V8_ROOT)/src/layout-descriptor-inl.h',
        '<(V8_ROOT)/src/layout-descriptor.cc',
        '<(V8_ROOT)/src/layout-descriptor.h',
        '<(V8_ROOT)/src/locked-queue-inl.h',
        '<(V8_ROOT)/src/locked-queue.h',
        '<(V8_ROOT)/src/log-inl.h',
        '<(V8_ROOT)/src/log-utils.cc',
        '<(V8_ROOT)/src/log-utils.h',
        '<(V8_ROOT)/src/log.cc',
        '<(V8_ROOT)/src/log.h',
        '<(V8_ROOT)/src/lookup-cache-inl.h',
        '<(V8_ROOT)/src/lookup-cache.cc',
        '<(V8_ROOT)/src/lookup-cache.h',
        '<(V8_ROOT)/src/lookup-inl.h',
        '<(V8_ROOT)/src/lookup.cc',
        '<(V8_ROOT)/src/lookup.h',
        '<(V8_ROOT)/src/machine-type.cc',
        '<(V8_ROOT)/src/machine-type.h',
        '<(V8_ROOT)/src/macro-assembler-inl.h',
        '<(V8_ROOT)/src/macro-assembler.h',
        '<(V8_ROOT)/src/map-updater.cc',
        '<(V8_ROOT)/src/map-updater.h',
        '<(V8_ROOT)/src/math-random.cc',
        '<(V8_ROOT)/src/math-random.h',
        '<(V8_ROOT)/src/maybe-handles-inl.h',
        '<(V8_ROOT)/src/maybe-handles.h',
        '<(V8_ROOT)/src/memcopy.cc',
        '<(V8_ROOT)/src/memcopy.h',
        '<(V8_ROOT)/src/message-template.h',
        '<(V8_ROOT)/src/messages.cc',
        '<(V8_ROOT)/src/messages.h',
        '<(V8_ROOT)/src/microtask-queue.cc',
        '<(V8_ROOT)/src/microtask-queue.h',
        '<(V8_ROOT)/src/msan.h',
        '<(V8_ROOT)/src/objects-body-descriptors-inl.h',
        '<(V8_ROOT)/src/objects-body-descriptors.h',
        '<(V8_ROOT)/src/objects-debug.cc',
        '<(V8_ROOT)/src/objects-inl.h',
        '<(V8_ROOT)/src/objects-printer.cc',
        '<(V8_ROOT)/src/objects.cc',
        '<(V8_ROOT)/src/objects.h',
        '<(V8_ROOT)/src/objects/allocation-site-inl.h',
        '<(V8_ROOT)/src/objects/allocation-site.h',
        '<(V8_ROOT)/src/objects/api-callbacks-inl.h',
        '<(V8_ROOT)/src/objects/api-callbacks.h',
        '<(V8_ROOT)/src/objects/arguments-inl.h',
        '<(V8_ROOT)/src/objects/arguments.h',
        '<(V8_ROOT)/src/objects/bigint.cc',
        '<(V8_ROOT)/src/objects/bigint.h',
        '<(V8_ROOT)/src/objects/cell-inl.h',
        '<(V8_ROOT)/src/objects/cell.h',
        '<(V8_ROOT)/src/objects/code-inl.h',
        '<(V8_ROOT)/src/objects/code.cc',
        '<(V8_ROOT)/src/objects/code.h',
        '<(V8_ROOT)/src/objects/compilation-cache-inl.h',
        '<(V8_ROOT)/src/objects/compilation-cache.h',
        '<(V8_ROOT)/src/objects/compressed-slots-inl.h',
        '<(V8_ROOT)/src/objects/compressed-slots.h',
        '<(V8_ROOT)/src/objects/data-handler.h',
        '<(V8_ROOT)/src/objects/debug-objects-inl.h',
        '<(V8_ROOT)/src/objects/debug-objects.cc',
        '<(V8_ROOT)/src/objects/debug-objects.h',
        '<(V8_ROOT)/src/objects/descriptor-array-inl.h',
        '<(V8_ROOT)/src/objects/descriptor-array.h',
        '<(V8_ROOT)/src/objects/dictionary-inl.h',
        '<(V8_ROOT)/src/objects/dictionary.h',
        '<(V8_ROOT)/src/objects/embedder-data-array-inl.h',
        '<(V8_ROOT)/src/objects/embedder-data-array.cc',
        '<(V8_ROOT)/src/objects/embedder-data-array.h',
        '<(V8_ROOT)/src/objects/embedder-data-slot-inl.h',
        '<(V8_ROOT)/src/objects/embedder-data-slot.h',
        '<(V8_ROOT)/src/objects/feedback-cell-inl.h',
        '<(V8_ROOT)/src/objects/feedback-cell.h',
        '<(V8_ROOT)/src/objects/fixed-array-inl.h',
        '<(V8_ROOT)/src/objects/fixed-array.h',
        '<(V8_ROOT)/src/objects/frame-array-inl.h',
        '<(V8_ROOT)/src/objects/frame-array.h',
        '<(V8_ROOT)/src/objects/hash-table-inl.h',
        '<(V8_ROOT)/src/objects/hash-table.h',
        '<(V8_ROOT)/src/objects/heap-number-inl.h',
        '<(V8_ROOT)/src/objects/heap-number.h',
        '<(V8_ROOT)/src/objects/heap-object-inl.h',
        '<(V8_ROOT)/src/objects/heap-object.h',
        '<(V8_ROOT)/src/objects/instance-type-inl.h',
        '<(V8_ROOT)/src/objects/instance-type.h',
        '<(V8_ROOT)/src/objects/intl-objects.cc',
        '<(V8_ROOT)/src/objects/intl-objects.h',
        '<(V8_ROOT)/src/objects/js-array-buffer-inl.h',
        '<(V8_ROOT)/src/objects/js-array-buffer.cc',
        '<(V8_ROOT)/src/objects/js-array-buffer.h',
        '<(V8_ROOT)/src/objects/js-array-inl.h',
        '<(V8_ROOT)/src/objects/js-array.h',
        '<(V8_ROOT)/src/objects/js-break-iterator-inl.h',
        '<(V8_ROOT)/src/objects/js-break-iterator.cc',
        '<(V8_ROOT)/src/objects/js-break-iterator.h',
        '<(V8_ROOT)/src/objects/js-collator-inl.h',
        '<(V8_ROOT)/src/objects/js-collator.cc',
        '<(V8_ROOT)/src/objects/js-collator.h',
        '<(V8_ROOT)/src/objects/js-collection-inl.h',
        '<(V8_ROOT)/src/objects/js-collection-iterator.h',
        '<(V8_ROOT)/src/objects/js-collection.h',
        '<(V8_ROOT)/src/objects/js-date-time-format-inl.h',
        '<(V8_ROOT)/src/objects/js-date-time-format.cc',
        '<(V8_ROOT)/src/objects/js-date-time-format.h',
        '<(V8_ROOT)/src/objects/js-generator-inl.h',
        '<(V8_ROOT)/src/objects/js-generator.h',
        '<(V8_ROOT)/src/objects/js-list-format-inl.h',
        '<(V8_ROOT)/src/objects/js-list-format.cc',
        '<(V8_ROOT)/src/objects/js-list-format.h',
        '<(V8_ROOT)/src/objects/js-locale-inl.h',
        '<(V8_ROOT)/src/objects/js-locale.cc',
        '<(V8_ROOT)/src/objects/js-locale.h',
        '<(V8_ROOT)/src/objects/js-number-format-inl.h',
        '<(V8_ROOT)/src/objects/js-number-format.cc',
        '<(V8_ROOT)/src/objects/js-number-format.h',
        '<(V8_ROOT)/src/objects/js-objects-inl.h',
        '<(V8_ROOT)/src/objects/js-objects.cc',
        '<(V8_ROOT)/src/objects/js-objects.h',
        '<(V8_ROOT)/src/objects/js-plural-rules-inl.h',
        '<(V8_ROOT)/src/objects/js-plural-rules.cc',
        '<(V8_ROOT)/src/objects/js-plural-rules.h',
        '<(V8_ROOT)/src/objects/js-promise-inl.h',
        '<(V8_ROOT)/src/objects/js-promise.h',
        '<(V8_ROOT)/src/objects/js-proxy-inl.h',
        '<(V8_ROOT)/src/objects/js-proxy.h',
        '<(V8_ROOT)/src/objects/js-regexp-inl.h',
        '<(V8_ROOT)/src/objects/js-regexp-string-iterator-inl.h',
        '<(V8_ROOT)/src/objects/js-regexp-string-iterator.h',
        '<(V8_ROOT)/src/objects/js-regexp.h',
        '<(V8_ROOT)/src/objects/js-relative-time-format-inl.h',
        '<(V8_ROOT)/src/objects/js-relative-time-format.cc',
        '<(V8_ROOT)/src/objects/js-relative-time-format.h',
        '<(V8_ROOT)/src/objects/js-segment-iterator-inl.h',
        '<(V8_ROOT)/src/objects/js-segment-iterator.cc',
        '<(V8_ROOT)/src/objects/js-segment-iterator.h',
        '<(V8_ROOT)/src/objects/js-segmenter-inl.h',
        '<(V8_ROOT)/src/objects/js-segmenter.cc',
        '<(V8_ROOT)/src/objects/js-segmenter.h',
        '<(V8_ROOT)/src/objects/js-weak-refs-inl.h',
        '<(V8_ROOT)/src/objects/js-weak-refs.h',
        '<(V8_ROOT)/src/objects/literal-objects-inl.h',
        '<(V8_ROOT)/src/objects/literal-objects.cc',
        '<(V8_ROOT)/src/objects/literal-objects.h',
        '<(V8_ROOT)/src/objects/managed.cc',
        '<(V8_ROOT)/src/objects/managed.h',
        '<(V8_ROOT)/src/objects/map-inl.h',
        '<(V8_ROOT)/src/objects/map.h',
        '<(V8_ROOT)/src/objects/map.cc',
        '<(V8_ROOT)/src/objects/maybe-object-inl.h',
        '<(V8_ROOT)/src/objects/maybe-object.h',
        '<(V8_ROOT)/src/objects/microtask-inl.h',
        '<(V8_ROOT)/src/objects/microtask.h',
        '<(V8_ROOT)/src/objects/module-inl.h',
        '<(V8_ROOT)/src/objects/module.cc',
        '<(V8_ROOT)/src/objects/module.h',
        '<(V8_ROOT)/src/objects/name-inl.h',
        '<(V8_ROOT)/src/objects/name.h',
        '<(V8_ROOT)/src/objects/object-macros-undef.h',
        '<(V8_ROOT)/src/objects/object-macros.h',
        '<(V8_ROOT)/src/objects/oddball-inl.h',
        '<(V8_ROOT)/src/objects/oddball.h',
        '<(V8_ROOT)/src/objects/ordered-hash-table-inl.h',
        '<(V8_ROOT)/src/objects/ordered-hash-table.cc',
        '<(V8_ROOT)/src/objects/ordered-hash-table.h',
        '<(V8_ROOT)/src/objects/promise-inl.h',
        '<(V8_ROOT)/src/objects/promise.h',
        '<(V8_ROOT)/src/objects/property-array-inl.h',
        '<(V8_ROOT)/src/objects/property-array.h',
        '<(V8_ROOT)/src/objects/property-cell-inl.h',
        '<(V8_ROOT)/src/objects/property-cell.h',
        '<(V8_ROOT)/src/objects/property-descriptor-object-inl.h',
        '<(V8_ROOT)/src/objects/property-descriptor-object.h',
        '<(V8_ROOT)/src/objects/prototype-info-inl.h',
        '<(V8_ROOT)/src/objects/prototype-info.h',
        '<(V8_ROOT)/src/objects/regexp-match-info.h',
        '<(V8_ROOT)/src/objects/scope-info.cc',
        '<(V8_ROOT)/src/objects/scope-info.h',
        '<(V8_ROOT)/src/objects/script-inl.h',
        '<(V8_ROOT)/src/objects/script.h',
        '<(V8_ROOT)/src/objects/shared-function-info-inl.h',
        '<(V8_ROOT)/src/objects/shared-function-info.h',
        '<(V8_ROOT)/src/objects/slots-atomic-inl.h',
        '<(V8_ROOT)/src/objects/slots-inl.h',
        '<(V8_ROOT)/src/objects/slots.h',
        '<(V8_ROOT)/src/objects/stack-frame-info-inl.h',
        '<(V8_ROOT)/src/objects/stack-frame-info.cc',
        '<(V8_ROOT)/src/objects/stack-frame-info.h',
        '<(V8_ROOT)/src/objects/string-comparator.cc',
        '<(V8_ROOT)/src/objects/string-comparator.h',
        '<(V8_ROOT)/src/objects/string-inl.h',
        '<(V8_ROOT)/src/objects/string-table-inl.h',
        '<(V8_ROOT)/src/objects/string-table.h',
        '<(V8_ROOT)/src/objects/string.cc',
        '<(V8_ROOT)/src/objects/string.h',
        '<(V8_ROOT)/src/objects/struct-inl.h',
        '<(V8_ROOT)/src/objects/struct.h',
        '<(V8_ROOT)/src/objects/template-objects-inl.h',
        '<(V8_ROOT)/src/objects/template-objects.cc',
        '<(V8_ROOT)/src/objects/template-objects.h',
        '<(V8_ROOT)/src/objects/templates-inl.h',
        '<(V8_ROOT)/src/objects/templates.h',
        '<(V8_ROOT)/src/optimized-compilation-info.cc',
        '<(V8_ROOT)/src/optimized-compilation-info.h',
        '<(V8_ROOT)/src/ostreams.cc',
        '<(V8_ROOT)/src/ostreams.h',
        '<(V8_ROOT)/src/parsing/expression-scope-reparenter.cc',
        '<(V8_ROOT)/src/parsing/expression-scope-reparenter.h',
        '<(V8_ROOT)/src/parsing/expression-scope.h',
        '<(V8_ROOT)/src/parsing/func-name-inferrer.cc',
        '<(V8_ROOT)/src/parsing/func-name-inferrer.h',
        '<(V8_ROOT)/src/parsing/parse-info.cc',
        '<(V8_ROOT)/src/parsing/parse-info.h',
        '<(V8_ROOT)/src/parsing/parser-base.h',
        '<(V8_ROOT)/src/parsing/parser.cc',
        '<(V8_ROOT)/src/parsing/parser.h',
        '<(V8_ROOT)/src/parsing/parsing.cc',
        '<(V8_ROOT)/src/parsing/parsing.h',
        '<(V8_ROOT)/src/parsing/preparse-data-impl.h',
        '<(V8_ROOT)/src/parsing/preparse-data.cc',
        '<(V8_ROOT)/src/parsing/preparse-data.h',
        '<(V8_ROOT)/src/parsing/preparser-logger.h',
        '<(V8_ROOT)/src/parsing/preparser.cc',
        '<(V8_ROOT)/src/parsing/preparser.h',
        '<(V8_ROOT)/src/parsing/rewriter.cc',
        '<(V8_ROOT)/src/parsing/rewriter.h',
        '<(V8_ROOT)/src/parsing/scanner-character-streams.cc',
        '<(V8_ROOT)/src/parsing/scanner-character-streams.h',
        '<(V8_ROOT)/src/parsing/scanner.cc',
        '<(V8_ROOT)/src/parsing/scanner.h',
        '<(V8_ROOT)/src/parsing/token.cc',
        '<(V8_ROOT)/src/parsing/token.h',
        '<(V8_ROOT)/src/pending-compilation-error-handler.cc',
        '<(V8_ROOT)/src/pending-compilation-error-handler.h',
        '<(V8_ROOT)/src/perf-jit.cc',
        '<(V8_ROOT)/src/perf-jit.h',
        '<(V8_ROOT)/src/pointer-with-payload.h',
        '<(V8_ROOT)/src/profiler/allocation-tracker.cc',
        '<(V8_ROOT)/src/profiler/allocation-tracker.h',
        '<(V8_ROOT)/src/profiler/circular-queue-inl.h',
        '<(V8_ROOT)/src/profiler/circular-queue.h',
        '<(V8_ROOT)/src/profiler/cpu-profiler-inl.h',
        '<(V8_ROOT)/src/profiler/cpu-profiler.cc',
        '<(V8_ROOT)/src/profiler/cpu-profiler.h',
        '<(V8_ROOT)/src/profiler/heap-profiler.cc',
        '<(V8_ROOT)/src/profiler/heap-profiler.h',
        '<(V8_ROOT)/src/profiler/heap-snapshot-generator-inl.h',
        '<(V8_ROOT)/src/profiler/heap-snapshot-generator.cc',
        '<(V8_ROOT)/src/profiler/heap-snapshot-generator.h',
        '<(V8_ROOT)/src/profiler/profile-generator-inl.h',
        '<(V8_ROOT)/src/profiler/profile-generator.cc',
        '<(V8_ROOT)/src/profiler/profile-generator.h',
        '<(V8_ROOT)/src/profiler/profiler-listener.cc',
        '<(V8_ROOT)/src/profiler/profiler-listener.h',
        '<(V8_ROOT)/src/profiler/sampling-heap-profiler.cc',
        '<(V8_ROOT)/src/profiler/sampling-heap-profiler.h',
        '<(V8_ROOT)/src/profiler/strings-storage.cc',
        '<(V8_ROOT)/src/profiler/strings-storage.h',
        '<(V8_ROOT)/src/profiler/tick-sample.cc',
        '<(V8_ROOT)/src/profiler/tick-sample.h',
        '<(V8_ROOT)/src/profiler/tracing-cpu-profiler.cc',
        '<(V8_ROOT)/src/profiler/tracing-cpu-profiler.h',
        '<(V8_ROOT)/src/property-descriptor.cc',
        '<(V8_ROOT)/src/property-descriptor.h',
        '<(V8_ROOT)/src/property-details.h',
        '<(V8_ROOT)/src/property.cc',
        '<(V8_ROOT)/src/property.h',
        '<(V8_ROOT)/src/prototype.h',
        '<(V8_ROOT)/src/ptr-compr-inl.h',
        '<(V8_ROOT)/src/ptr-compr.h',
        '<(V8_ROOT)/src/regexp/bytecodes-irregexp.h',
        '<(V8_ROOT)/src/regexp/interpreter-irregexp.cc',
        '<(V8_ROOT)/src/regexp/interpreter-irregexp.h',
        '<(V8_ROOT)/src/regexp/jsregexp-inl.h',
        '<(V8_ROOT)/src/regexp/jsregexp.cc',
        '<(V8_ROOT)/src/regexp/jsregexp.h',
        '<(V8_ROOT)/src/regexp/property-sequences.cc',
        '<(V8_ROOT)/src/regexp/property-sequences.h',
        '<(V8_ROOT)/src/regexp/regexp-ast.cc',
        '<(V8_ROOT)/src/regexp/regexp-ast.h',
        '<(V8_ROOT)/src/regexp/regexp-macro-assembler-irregexp-inl.h',
        '<(V8_ROOT)/src/regexp/regexp-macro-assembler-irregexp.cc',
        '<(V8_ROOT)/src/regexp/regexp-macro-assembler-irregexp.h',
        '<(V8_ROOT)/src/regexp/regexp-macro-assembler-tracer.cc',
        '<(V8_ROOT)/src/regexp/regexp-macro-assembler-tracer.h',
        '<(V8_ROOT)/src/regexp/regexp-macro-assembler.cc',
        '<(V8_ROOT)/src/regexp/regexp-macro-assembler.h',
        '<(V8_ROOT)/src/regexp/regexp-parser.cc',
        '<(V8_ROOT)/src/regexp/regexp-parser.h',
        '<(V8_ROOT)/src/regexp/regexp-stack.cc',
        '<(V8_ROOT)/src/regexp/regexp-stack.h',
        '<(V8_ROOT)/src/regexp/regexp-utils.cc',
        '<(V8_ROOT)/src/regexp/regexp-utils.h',
        '<(V8_ROOT)/src/register-arch.h',
        '<(V8_ROOT)/src/register-configuration.cc',
        '<(V8_ROOT)/src/register-configuration.h',
        '<(V8_ROOT)/src/register.h',
        '<(V8_ROOT)/src/reglist.h',
        '<(V8_ROOT)/src/reloc-info.cc',
        '<(V8_ROOT)/src/reloc-info.h',
        '<(V8_ROOT)/src/roots-inl.h',
        '<(V8_ROOT)/src/roots.cc',
        '<(V8_ROOT)/src/roots.h',
        '<(V8_ROOT)/src/runtime-profiler.cc',
        '<(V8_ROOT)/src/runtime-profiler.h',
        '<(V8_ROOT)/src/runtime/runtime-array.cc',
        '<(V8_ROOT)/src/runtime/runtime-atomics.cc',
        '<(V8_ROOT)/src/runtime/runtime-bigint.cc',
        '<(V8_ROOT)/src/runtime/runtime-classes.cc',
        '<(V8_ROOT)/src/runtime/runtime-collections.cc',
        '<(V8_ROOT)/src/runtime/runtime-compiler.cc',
        '<(V8_ROOT)/src/runtime/runtime-date.cc',
        '<(V8_ROOT)/src/runtime/runtime-debug.cc',
        '<(V8_ROOT)/src/runtime/runtime-forin.cc',
        '<(V8_ROOT)/src/runtime/runtime-function.cc',
        '<(V8_ROOT)/src/runtime/runtime-futex.cc',
        '<(V8_ROOT)/src/runtime/runtime-generator.cc',
        '<(V8_ROOT)/src/runtime/runtime-internal.cc',
        '<(V8_ROOT)/src/runtime/runtime-interpreter.cc',
        '<(V8_ROOT)/src/runtime/runtime-intl.cc',
        '<(V8_ROOT)/src/runtime/runtime-literals.cc',
        '<(V8_ROOT)/src/runtime/runtime-module.cc',
        '<(V8_ROOT)/src/runtime/runtime-numbers.cc',
        '<(V8_ROOT)/src/runtime/runtime-object.cc',
        '<(V8_ROOT)/src/runtime/runtime-operators.cc',
        '<(V8_ROOT)/src/runtime/runtime-promise.cc',
        '<(V8_ROOT)/src/runtime/runtime-proxy.cc',
        '<(V8_ROOT)/src/runtime/runtime-regexp.cc',
        '<(V8_ROOT)/src/runtime/runtime-scopes.cc',
        '<(V8_ROOT)/src/runtime/runtime-strings.cc',
        '<(V8_ROOT)/src/runtime/runtime-symbol.cc',
        '<(V8_ROOT)/src/runtime/runtime-test.cc',
        '<(V8_ROOT)/src/runtime/runtime-typedarray.cc',
        '<(V8_ROOT)/src/runtime/runtime-utils.h',
        '<(V8_ROOT)/src/runtime/runtime-wasm.cc',
        '<(V8_ROOT)/src/runtime/runtime-weak-refs.cc',
        '<(V8_ROOT)/src/runtime/runtime.cc',
        '<(V8_ROOT)/src/runtime/runtime.h',
        '<(V8_ROOT)/src/safepoint-table.cc',
        '<(V8_ROOT)/src/safepoint-table.h',
        '<(V8_ROOT)/src/setup-isolate.h',
        '<(V8_ROOT)/src/signature.h',
        '<(V8_ROOT)/src/simulator-base.cc',
        '<(V8_ROOT)/src/simulator-base.h',
        '<(V8_ROOT)/src/simulator.h',
        '<(V8_ROOT)/src/snapshot/code-serializer.cc',
        '<(V8_ROOT)/src/snapshot/code-serializer.h',
        '<(V8_ROOT)/src/snapshot/deserializer-allocator.cc',
        '<(V8_ROOT)/src/snapshot/deserializer-allocator.h',
        '<(V8_ROOT)/src/snapshot/deserializer.cc',
        '<(V8_ROOT)/src/snapshot/deserializer.h',
        '<(V8_ROOT)/src/snapshot/embedded-data.cc',
        '<(V8_ROOT)/src/snapshot/embedded-data.h',
        '<(V8_ROOT)/src/snapshot/natives-common.cc',
        '<(V8_ROOT)/src/snapshot/natives.h',
        '<(V8_ROOT)/src/snapshot/object-deserializer.cc',
        '<(V8_ROOT)/src/snapshot/object-deserializer.h',
        '<(V8_ROOT)/src/snapshot/partial-deserializer.cc',
        '<(V8_ROOT)/src/snapshot/partial-deserializer.h',
        '<(V8_ROOT)/src/snapshot/partial-serializer.cc',
        '<(V8_ROOT)/src/snapshot/partial-serializer.h',
        '<(V8_ROOT)/src/snapshot/read-only-deserializer.cc',
        '<(V8_ROOT)/src/snapshot/read-only-deserializer.h',
        '<(V8_ROOT)/src/snapshot/read-only-serializer.cc',
        '<(V8_ROOT)/src/snapshot/read-only-serializer.h',
        '<(V8_ROOT)/src/snapshot/references.h',
        '<(V8_ROOT)/src/snapshot/roots-serializer.cc',
        '<(V8_ROOT)/src/snapshot/roots-serializer.h',
        '<(V8_ROOT)/src/snapshot/serializer-allocator.cc',
        '<(V8_ROOT)/src/snapshot/serializer-allocator.h',
        '<(V8_ROOT)/src/snapshot/serializer-common.cc',
        '<(V8_ROOT)/src/snapshot/serializer-common.h',
        '<(V8_ROOT)/src/snapshot/serializer.cc',
        '<(V8_ROOT)/src/snapshot/serializer.h',
        '<(V8_ROOT)/src/snapshot/snapshot-common.cc',
        '<(V8_ROOT)/src/snapshot/snapshot-source-sink.cc',
        '<(V8_ROOT)/src/snapshot/snapshot-source-sink.h',
        '<(V8_ROOT)/src/snapshot/snapshot.h',
        '<(V8_ROOT)/src/snapshot/startup-deserializer.cc',
        '<(V8_ROOT)/src/snapshot/startup-deserializer.h',
        '<(V8_ROOT)/src/snapshot/startup-serializer.cc',
        '<(V8_ROOT)/src/snapshot/startup-serializer.h',
        '<(V8_ROOT)/src/source-position-table.cc',
        '<(V8_ROOT)/src/source-position-table.h',
        '<(V8_ROOT)/src/source-position.cc',
        '<(V8_ROOT)/src/source-position.h',
        '<(V8_ROOT)/src/splay-tree-inl.h',
        '<(V8_ROOT)/src/splay-tree.h',
        '<(V8_ROOT)/src/startup-data-util.cc',
        '<(V8_ROOT)/src/startup-data-util.h',
        '<(V8_ROOT)/src/string-builder-inl.h',
        '<(V8_ROOT)/src/string-builder.cc',
        '<(V8_ROOT)/src/string-case.cc',
        '<(V8_ROOT)/src/string-case.h',
        '<(V8_ROOT)/src/string-constants.cc',
        '<(V8_ROOT)/src/string-constants.h',
        '<(V8_ROOT)/src/string-hasher-inl.h',
        '<(V8_ROOT)/src/string-hasher.h',
        '<(V8_ROOT)/src/string-search.h',
        '<(V8_ROOT)/src/string-stream.cc',
        '<(V8_ROOT)/src/string-stream.h',
        '<(V8_ROOT)/src/strtod.cc',
        '<(V8_ROOT)/src/strtod.h',
        '<(V8_ROOT)/src/task-utils.cc',
        '<(V8_ROOT)/src/task-utils.h',
        '<(V8_ROOT)/src/third_party/siphash/halfsiphash.cc',
        '<(V8_ROOT)/src/third_party/siphash/halfsiphash.h',
        '<(V8_ROOT)/src/third_party/utf8-decoder/utf8-decoder.h',
        '<(V8_ROOT)/src/thread-id.cc',
        '<(V8_ROOT)/src/thread-id.h',
        '<(V8_ROOT)/src/thread-local-top.cc',
        '<(V8_ROOT)/src/thread-local-top.h',
        '<(V8_ROOT)/src/tracing/trace-event.cc',
        '<(V8_ROOT)/src/tracing/trace-event.h',
        '<(V8_ROOT)/src/tracing/traced-value.cc',
        '<(V8_ROOT)/src/tracing/traced-value.h',
        '<(V8_ROOT)/src/tracing/tracing-category-observer.cc',
        '<(V8_ROOT)/src/tracing/tracing-category-observer.h',
        '<(V8_ROOT)/src/transitions-inl.h',
        '<(V8_ROOT)/src/transitions.cc',
        '<(V8_ROOT)/src/transitions.h',
        '<(V8_ROOT)/src/trap-handler/handler-inside.cc',
        '<(V8_ROOT)/src/trap-handler/handler-outside.cc',
        '<(V8_ROOT)/src/trap-handler/handler-shared.cc',
        '<(V8_ROOT)/src/trap-handler/trap-handler-internal.h',
        '<(V8_ROOT)/src/trap-handler/trap-handler.h',
        '<(V8_ROOT)/src/turbo-assembler.cc',
        '<(V8_ROOT)/src/turbo-assembler.h',
        '<(V8_ROOT)/src/type-hints.cc',
        '<(V8_ROOT)/src/type-hints.h',
        '<(V8_ROOT)/src/type-traits.h',
        '<(V8_ROOT)/src/unicode-cache.h',
        '<(V8_ROOT)/src/unicode-decoder.cc',
        '<(V8_ROOT)/src/unicode-decoder.h',
        '<(V8_ROOT)/src/unicode-inl.h',
        '<(V8_ROOT)/src/unicode.cc',
        '<(V8_ROOT)/src/unicode.h',
        '<(V8_ROOT)/src/unoptimized-compilation-info.cc',
        '<(V8_ROOT)/src/unoptimized-compilation-info.h',
        '<(V8_ROOT)/src/unwinder.cc',
        '<(V8_ROOT)/src/uri.cc',
        '<(V8_ROOT)/src/uri.h',
        '<(V8_ROOT)/src/utils-inl.h',
        '<(V8_ROOT)/src/utils.cc',
        '<(V8_ROOT)/src/utils.h',
        '<(V8_ROOT)/src/v8.cc',
        '<(V8_ROOT)/src/v8.h',
        '<(V8_ROOT)/src/v8memory.h',
        '<(V8_ROOT)/src/v8threads.cc',
        '<(V8_ROOT)/src/v8threads.h',
        '<(V8_ROOT)/src/value-serializer.cc',
        '<(V8_ROOT)/src/value-serializer.h',
        '<(V8_ROOT)/src/vector-slot-pair.cc',
        '<(V8_ROOT)/src/vector-slot-pair.h',
        '<(V8_ROOT)/src/vector.h',
        '<(V8_ROOT)/src/version.cc',
        '<(V8_ROOT)/src/version.h',
        '<(V8_ROOT)/src/visitors.cc',
        '<(V8_ROOT)/src/visitors.h',
        '<(V8_ROOT)/src/vm-state-inl.h',
        '<(V8_ROOT)/src/vm-state.h',
        '<(V8_ROOT)/src/wasm/baseline/liftoff-assembler-defs.h',
        '<(V8_ROOT)/src/wasm/baseline/liftoff-assembler.cc',
        '<(V8_ROOT)/src/wasm/baseline/liftoff-assembler.h',
        '<(V8_ROOT)/src/wasm/baseline/liftoff-compiler.cc',
        '<(V8_ROOT)/src/wasm/baseline/liftoff-compiler.h',
        '<(V8_ROOT)/src/wasm/baseline/liftoff-register.h',
        '<(V8_ROOT)/src/wasm/compilation-environment.h',
        '<(V8_ROOT)/src/wasm/decoder.h',
        '<(V8_ROOT)/src/wasm/function-body-decoder-impl.h',
        '<(V8_ROOT)/src/wasm/function-body-decoder.cc',
        '<(V8_ROOT)/src/wasm/function-body-decoder.h',
        '<(V8_ROOT)/src/wasm/function-compiler.cc',
        '<(V8_ROOT)/src/wasm/function-compiler.h',
        '<(V8_ROOT)/src/wasm/graph-builder-interface.cc',
        '<(V8_ROOT)/src/wasm/graph-builder-interface.h',
        '<(V8_ROOT)/src/wasm/js-to-wasm-wrapper-cache.h',
        '<(V8_ROOT)/src/wasm/jump-table-assembler.cc',
        '<(V8_ROOT)/src/wasm/jump-table-assembler.h',
        '<(V8_ROOT)/src/wasm/leb-helper.h',
        '<(V8_ROOT)/src/wasm/local-decl-encoder.cc',
        '<(V8_ROOT)/src/wasm/local-decl-encoder.h',
        '<(V8_ROOT)/src/wasm/memory-tracing.cc',
        '<(V8_ROOT)/src/wasm/memory-tracing.h',
        '<(V8_ROOT)/src/wasm/module-compiler.cc',
        '<(V8_ROOT)/src/wasm/module-compiler.h',
        '<(V8_ROOT)/src/wasm/module-decoder.cc',
        '<(V8_ROOT)/src/wasm/module-decoder.h',
        '<(V8_ROOT)/src/wasm/module-instantiate.cc',
        '<(V8_ROOT)/src/wasm/module-instantiate.h',
        '<(V8_ROOT)/src/wasm/object-access.h',
        '<(V8_ROOT)/src/wasm/signature-map.cc',
        '<(V8_ROOT)/src/wasm/signature-map.h',
        '<(V8_ROOT)/src/wasm/streaming-decoder.cc',
        '<(V8_ROOT)/src/wasm/streaming-decoder.h',
        '<(V8_ROOT)/src/wasm/value-type.h',
        '<(V8_ROOT)/src/wasm/wasm-code-manager.cc',
        '<(V8_ROOT)/src/wasm/wasm-code-manager.h',
        '<(V8_ROOT)/src/wasm/wasm-constants.h',
        '<(V8_ROOT)/src/wasm/wasm-debug.cc',
        '<(V8_ROOT)/src/wasm/wasm-engine.cc',
        '<(V8_ROOT)/src/wasm/wasm-engine.h',
        '<(V8_ROOT)/src/wasm/wasm-external-refs.cc',
        '<(V8_ROOT)/src/wasm/wasm-external-refs.h',
        '<(V8_ROOT)/src/wasm/wasm-feature-flags.h',
        '<(V8_ROOT)/src/wasm/wasm-features.cc',
        '<(V8_ROOT)/src/wasm/wasm-features.h',
        '<(V8_ROOT)/src/wasm/wasm-import-wrapper-cache.cc',
        '<(V8_ROOT)/src/wasm/wasm-import-wrapper-cache.h',
        '<(V8_ROOT)/src/wasm/wasm-interpreter.cc',
        '<(V8_ROOT)/src/wasm/wasm-interpreter.h',
        '<(V8_ROOT)/src/wasm/wasm-js.cc',
        '<(V8_ROOT)/src/wasm/wasm-js.h',
        '<(V8_ROOT)/src/wasm/wasm-limits.h',
        '<(V8_ROOT)/src/wasm/wasm-linkage.h',
        '<(V8_ROOT)/src/wasm/wasm-memory.cc',
        '<(V8_ROOT)/src/wasm/wasm-memory.h',
        '<(V8_ROOT)/src/wasm/wasm-module-builder.cc',
        '<(V8_ROOT)/src/wasm/wasm-module-builder.h',
        '<(V8_ROOT)/src/wasm/wasm-module.cc',
        '<(V8_ROOT)/src/wasm/wasm-module.h',
        '<(V8_ROOT)/src/wasm/wasm-objects-inl.h',
        '<(V8_ROOT)/src/wasm/wasm-objects.cc',
        '<(V8_ROOT)/src/wasm/wasm-objects.h',
        '<(V8_ROOT)/src/wasm/wasm-opcodes.cc',
        '<(V8_ROOT)/src/wasm/wasm-opcodes.h',
        '<(V8_ROOT)/src/wasm/wasm-result.cc',
        '<(V8_ROOT)/src/wasm/wasm-result.h',
        '<(V8_ROOT)/src/wasm/wasm-serialization.cc',
        '<(V8_ROOT)/src/wasm/wasm-serialization.h',
        '<(V8_ROOT)/src/wasm/wasm-text.cc',
        '<(V8_ROOT)/src/wasm/wasm-text.h',
        '<(V8_ROOT)/src/wasm/wasm-tier.h',
        '<(V8_ROOT)/src/wasm/wasm-value.h',
        '<(V8_ROOT)/src/zone/accounting-allocator.cc',
        '<(V8_ROOT)/src/zone/accounting-allocator.h',
        '<(V8_ROOT)/src/zone/zone-allocator.h',
        '<(V8_ROOT)/src/zone/zone-chunk-list.h',
        '<(V8_ROOT)/src/zone/zone-containers.h',
        '<(V8_ROOT)/src/zone/zone-handle-set.h',
        '<(V8_ROOT)/src/zone/zone-list-inl.h',
        '<(V8_ROOT)/src/zone/zone-segment.cc',
        '<(V8_ROOT)/src/zone/zone-segment.h',
        '<(V8_ROOT)/src/zone/zone-splay-tree.h',
        '<(V8_ROOT)/src/zone/zone.cc',
        '<(V8_ROOT)/src/zone/zone.h',
        '<@(inspector_all_sources)',
      ],
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
        ['v8_target_arch=="ia32"', {
          'sources': [  ### gcmole(arch:ia32) ###
            '<(V8_ROOT)/src/compiler/backend/ia32/code-generator-ia32.cc',
            '<(V8_ROOT)/src/compiler/backend/ia32/instruction-codes-ia32.h',
            '<(V8_ROOT)/src/compiler/backend/ia32/instruction-scheduler-ia32.cc',
            '<(V8_ROOT)/src/compiler/backend/ia32/instruction-selector-ia32.cc',
            '<(V8_ROOT)/src/debug/ia32/debug-ia32.cc',
            '<(V8_ROOT)/src/ia32/assembler-ia32-inl.h',
            '<(V8_ROOT)/src/ia32/assembler-ia32.cc',
            '<(V8_ROOT)/src/ia32/assembler-ia32.h',
            '<(V8_ROOT)/src/ia32/constants-ia32.h',
            '<(V8_ROOT)/src/ia32/cpu-ia32.cc',
            '<(V8_ROOT)/src/ia32/deoptimizer-ia32.cc',
            '<(V8_ROOT)/src/ia32/disasm-ia32.cc',
            '<(V8_ROOT)/src/ia32/frame-constants-ia32.cc',
            '<(V8_ROOT)/src/ia32/frame-constants-ia32.h',
            '<(V8_ROOT)/src/ia32/interface-descriptors-ia32.cc',
            '<(V8_ROOT)/src/ia32/macro-assembler-ia32.cc',
            '<(V8_ROOT)/src/ia32/macro-assembler-ia32.h',
            '<(V8_ROOT)/src/ia32/register-ia32.h',
            '<(V8_ROOT)/src/ia32/sse-instr.h',
            '<(V8_ROOT)/src/regexp/ia32/regexp-macro-assembler-ia32.cc',
            '<(V8_ROOT)/src/regexp/ia32/regexp-macro-assembler-ia32.h',
            '<(V8_ROOT)/src/wasm/baseline/ia32/liftoff-assembler-ia32.h',
          ],
        }],
        ['v8_target_arch=="x64"', {
          'sources': [  ### gcmole(arch:x64) ###
            '<(V8_ROOT)/src/compiler/backend/x64/code-generator-x64.cc',
            '<(V8_ROOT)/src/compiler/backend/x64/instruction-codes-x64.h',
            '<(V8_ROOT)/src/compiler/backend/x64/instruction-scheduler-x64.cc',
            '<(V8_ROOT)/src/compiler/backend/x64/instruction-selector-x64.cc',
            '<(V8_ROOT)/src/compiler/backend/x64/unwinding-info-writer-x64.cc',
            '<(V8_ROOT)/src/compiler/backend/x64/unwinding-info-writer-x64.h',
            '<(V8_ROOT)/src/debug/x64/debug-x64.cc',
            '<(V8_ROOT)/src/regexp/x64/regexp-macro-assembler-x64.cc',
            '<(V8_ROOT)/src/regexp/x64/regexp-macro-assembler-x64.h',
            '<(V8_ROOT)/src/third_party/valgrind/valgrind.h',
            '<(V8_ROOT)/src/wasm/baseline/x64/liftoff-assembler-x64.h',
            '<(V8_ROOT)/src/x64/assembler-x64-inl.h',
            '<(V8_ROOT)/src/x64/assembler-x64.cc',
            '<(V8_ROOT)/src/x64/assembler-x64.h',
            '<(V8_ROOT)/src/x64/constants-x64.h',
            '<(V8_ROOT)/src/x64/cpu-x64.cc',
            '<(V8_ROOT)/src/x64/deoptimizer-x64.cc',
            '<(V8_ROOT)/src/x64/disasm-x64.cc',
            '<(V8_ROOT)/src/x64/eh-frame-x64.cc',
            '<(V8_ROOT)/src/x64/frame-constants-x64.cc',
            '<(V8_ROOT)/src/x64/frame-constants-x64.h',
            '<(V8_ROOT)/src/x64/interface-descriptors-x64.cc',
            '<(V8_ROOT)/src/x64/macro-assembler-x64.cc',
            '<(V8_ROOT)/src/x64/macro-assembler-x64.h',
            '<(V8_ROOT)/src/x64/register-x64.h',
            '<(V8_ROOT)/src/x64/sse-instr.h',
          ],
          'conditions': [
            # iOS Xcode simulator builds run on an x64 target. iOS and macOS are both
            # based on Darwin and thus POSIX-compliant to a similar degree.
            ['OS=="linux" or OS=="mac" or OS=="ios"', {
              'sources': [
                '<(V8_ROOT)/src/trap-handler/handler-inside-posix.cc',
                '<(V8_ROOT)/src/trap-handler/handler-inside-posix.h',
                '<(V8_ROOT)/src/trap-handler/handler-outside-posix.cc',
              ],
            }],
            ['OS=="win"', {
              'sources': [
                '<(V8_ROOT)/src/trap-handler/handler-inside-win.cc',
                '<(V8_ROOT)/src/trap-handler/handler-inside-win.h',
                '<(V8_ROOT)/src/trap-handler/handler-outside-win.cc',
                '<(V8_ROOT)/src/unwinding-info-win64.cc',
                '<(V8_ROOT)/src/unwinding-info-win64.h',
              ],
            }],
          ],
        }],
        ['v8_target_arch=="arm"', {
          'sources': [  ### gcmole(arch:arm) ###
            '<(V8_ROOT)/src/arm/assembler-arm-inl.h',
            '<(V8_ROOT)/src/arm/assembler-arm.cc',
            '<(V8_ROOT)/src/arm/assembler-arm.h',
            '<(V8_ROOT)/src/arm/constants-arm.h',
            '<(V8_ROOT)/src/arm/constants-arm.cc',
            '<(V8_ROOT)/src/arm/cpu-arm.cc',
            '<(V8_ROOT)/src/arm/deoptimizer-arm.cc',
            '<(V8_ROOT)/src/arm/disasm-arm.cc',
            '<(V8_ROOT)/src/arm/eh-frame-arm.cc',
            '<(V8_ROOT)/src/arm/frame-constants-arm.cc',
            '<(V8_ROOT)/src/arm/frame-constants-arm.h',
            '<(V8_ROOT)/src/arm/interface-descriptors-arm.cc',
            '<(V8_ROOT)/src/arm/macro-assembler-arm.cc',
            '<(V8_ROOT)/src/arm/macro-assembler-arm.h',
            '<(V8_ROOT)/src/arm/register-arm.h',
            '<(V8_ROOT)/src/arm/simulator-arm.cc',
            '<(V8_ROOT)/src/arm/simulator-arm.h',
            '<(V8_ROOT)/src/compiler/backend/arm/code-generator-arm.cc',
            '<(V8_ROOT)/src/compiler/backend/arm/instruction-codes-arm.h',
            '<(V8_ROOT)/src/compiler/backend/arm/instruction-scheduler-arm.cc',
            '<(V8_ROOT)/src/compiler/backend/arm/instruction-selector-arm.cc',
            '<(V8_ROOT)/src/compiler/backend/arm/unwinding-info-writer-arm.cc',
            '<(V8_ROOT)/src/compiler/backend/arm/unwinding-info-writer-arm.h',
            '<(V8_ROOT)/src/debug/arm/debug-arm.cc',
            '<(V8_ROOT)/src/regexp/arm/regexp-macro-assembler-arm.cc',
            '<(V8_ROOT)/src/regexp/arm/regexp-macro-assembler-arm.h',
            '<(V8_ROOT)/src/wasm/baseline/arm/liftoff-assembler-arm.h',
          ],
        }],
        ['v8_target_arch=="arm64"', {
          'sources': [  ### gcmole(arch:arm64) ###
            '<(V8_ROOT)/src/arm64/assembler-arm64-inl.h',
            '<(V8_ROOT)/src/arm64/assembler-arm64.cc',
            '<(V8_ROOT)/src/arm64/assembler-arm64.h',
            '<(V8_ROOT)/src/arm64/constants-arm64.h',
            '<(V8_ROOT)/src/arm64/cpu-arm64.cc',
            '<(V8_ROOT)/src/arm64/decoder-arm64-inl.h',
            '<(V8_ROOT)/src/arm64/decoder-arm64.cc',
            '<(V8_ROOT)/src/arm64/decoder-arm64.h',
            '<(V8_ROOT)/src/arm64/deoptimizer-arm64.cc',
            '<(V8_ROOT)/src/arm64/disasm-arm64.cc',
            '<(V8_ROOT)/src/arm64/disasm-arm64.h',
            '<(V8_ROOT)/src/arm64/eh-frame-arm64.cc',
            '<(V8_ROOT)/src/arm64/frame-constants-arm64.cc',
            '<(V8_ROOT)/src/arm64/frame-constants-arm64.h',
            '<(V8_ROOT)/src/arm64/instructions-arm64-constants.cc',
            '<(V8_ROOT)/src/arm64/instructions-arm64.cc',
            '<(V8_ROOT)/src/arm64/instructions-arm64.h',
            '<(V8_ROOT)/src/arm64/instrument-arm64.cc',
            '<(V8_ROOT)/src/arm64/instrument-arm64.h',
            '<(V8_ROOT)/src/arm64/interface-descriptors-arm64.cc',
            '<(V8_ROOT)/src/arm64/macro-assembler-arm64-inl.h',
            '<(V8_ROOT)/src/arm64/macro-assembler-arm64.cc',
            '<(V8_ROOT)/src/arm64/macro-assembler-arm64.h',
            '<(V8_ROOT)/src/arm64/register-arm64.cc',
            '<(V8_ROOT)/src/arm64/register-arm64.h',
            '<(V8_ROOT)/src/arm64/simulator-arm64.cc',
            '<(V8_ROOT)/src/arm64/simulator-arm64.h',
            '<(V8_ROOT)/src/arm64/simulator-logic-arm64.cc',
            '<(V8_ROOT)/src/arm64/utils-arm64.cc',
            '<(V8_ROOT)/src/arm64/utils-arm64.h',
            '<(V8_ROOT)/src/compiler/backend/arm64/code-generator-arm64.cc',
            '<(V8_ROOT)/src/compiler/backend/arm64/instruction-codes-arm64.h',
            '<(V8_ROOT)/src/compiler/backend/arm64/instruction-scheduler-arm64.cc',
            '<(V8_ROOT)/src/compiler/backend/arm64/instruction-selector-arm64.cc',
            '<(V8_ROOT)/src/compiler/backend/arm64/unwinding-info-writer-arm64.cc',
            '<(V8_ROOT)/src/compiler/backend/arm64/unwinding-info-writer-arm64.h',
            '<(V8_ROOT)/src/debug/arm64/debug-arm64.cc',
            '<(V8_ROOT)/src/regexp/arm64/regexp-macro-assembler-arm64.cc',
            '<(V8_ROOT)/src/regexp/arm64/regexp-macro-assembler-arm64.h',
            '<(V8_ROOT)/src/wasm/baseline/arm64/liftoff-assembler-arm64.h',
          ],
        }],
        ['v8_target_arch=="mips" or v8_target_arch=="mipsel"', {
          'sources': [  ### gcmole(arch:mipsel) ###
            '<(V8_ROOT)/src/compiler/backend/mips/code-generator-mips.cc',
            '<(V8_ROOT)/src/compiler/backend/mips/instruction-codes-mips.h',
            '<(V8_ROOT)/src/compiler/backend/mips/instruction-scheduler-mips.cc',
            '<(V8_ROOT)/src/compiler/backend/mips/instruction-selector-mips.cc',
            '<(V8_ROOT)/src/debug/mips/debug-mips.cc',
            '<(V8_ROOT)/src/mips/assembler-mips-inl.h',
            '<(V8_ROOT)/src/mips/assembler-mips.cc',
            '<(V8_ROOT)/src/mips/assembler-mips.h',
            '<(V8_ROOT)/src/mips/constants-mips.cc',
            '<(V8_ROOT)/src/mips/constants-mips.h',
            '<(V8_ROOT)/src/mips/cpu-mips.cc',
            '<(V8_ROOT)/src/mips/deoptimizer-mips.cc',
            '<(V8_ROOT)/src/mips/disasm-mips.cc',
            '<(V8_ROOT)/src/mips/frame-constants-mips.cc',
            '<(V8_ROOT)/src/mips/frame-constants-mips.h',
            '<(V8_ROOT)/src/mips/interface-descriptors-mips.cc',
            '<(V8_ROOT)/src/mips/macro-assembler-mips.cc',
            '<(V8_ROOT)/src/mips/macro-assembler-mips.h',
            '<(V8_ROOT)/src/mips/register-mips.h',
            '<(V8_ROOT)/src/mips/simulator-mips.cc',
            '<(V8_ROOT)/src/mips/simulator-mips.h',
            '<(V8_ROOT)/src/regexp/mips/regexp-macro-assembler-mips.cc',
            '<(V8_ROOT)/src/regexp/mips/regexp-macro-assembler-mips.h',
            '<(V8_ROOT)/src/wasm/baseline/mips/liftoff-assembler-mips.h',
          ],
        }],
        ['v8_target_arch=="mips64" or v8_target_arch=="mips64el"', {
          'sources': [  ### gcmole(arch:mips64el) ###
            '<(V8_ROOT)/src/compiler/backend/mips64/code-generator-mips64.cc',
            '<(V8_ROOT)/src/compiler/backend/mips64/instruction-codes-mips64.h',
            '<(V8_ROOT)/src/compiler/backend/mips64/instruction-scheduler-mips64.cc',
            '<(V8_ROOT)/src/compiler/backend/mips64/instruction-selector-mips64.cc',
            '<(V8_ROOT)/src/debug/mips64/debug-mips64.cc',
            '<(V8_ROOT)/src/mips64/assembler-mips64-inl.h',
            '<(V8_ROOT)/src/mips64/assembler-mips64.cc',
            '<(V8_ROOT)/src/mips64/assembler-mips64.h',
            '<(V8_ROOT)/src/mips64/constants-mips64.cc',
            '<(V8_ROOT)/src/mips64/constants-mips64.h',
            '<(V8_ROOT)/src/mips64/cpu-mips64.cc',
            '<(V8_ROOT)/src/mips64/deoptimizer-mips64.cc',
            '<(V8_ROOT)/src/mips64/disasm-mips64.cc',
            '<(V8_ROOT)/src/mips64/frame-constants-mips64.cc',
            '<(V8_ROOT)/src/mips64/frame-constants-mips64.h',
            '<(V8_ROOT)/src/mips64/interface-descriptors-mips64.cc',
            '<(V8_ROOT)/src/mips64/macro-assembler-mips64.cc',
            '<(V8_ROOT)/src/mips64/macro-assembler-mips64.h',
            '<(V8_ROOT)/src/mips64/register-mips64.h',
            '<(V8_ROOT)/src/mips64/simulator-mips64.cc',
            '<(V8_ROOT)/src/mips64/simulator-mips64.h',
            '<(V8_ROOT)/src/regexp/mips64/regexp-macro-assembler-mips64.cc',
            '<(V8_ROOT)/src/regexp/mips64/regexp-macro-assembler-mips64.h',
            '<(V8_ROOT)/src/wasm/baseline/mips64/liftoff-assembler-mips64.h',
          ],
        }],
        ['v8_target_arch=="ppc" or v8_target_arch=="ppc64"', {
          'sources': [  ### gcmole(arch:ppc) ###
            '<(V8_ROOT)/src/compiler/backend/ppc/code-generator-ppc.cc',
            '<(V8_ROOT)/src/compiler/backend/ppc/instruction-codes-ppc.h',
            '<(V8_ROOT)/src/compiler/backend/ppc/instruction-scheduler-ppc.cc',
            '<(V8_ROOT)/src/compiler/backend/ppc/instruction-selector-ppc.cc',
            '<(V8_ROOT)/src/debug/ppc/debug-ppc.cc',
            '<(V8_ROOT)/src/ppc/assembler-ppc-inl.h',
            '<(V8_ROOT)/src/ppc/assembler-ppc.cc',
            '<(V8_ROOT)/src/ppc/assembler-ppc.h',
            '<(V8_ROOT)/src/ppc/constants-ppc.h',
            '<(V8_ROOT)/src/ppc/constants-ppc.cc',
            '<(V8_ROOT)/src/ppc/cpu-ppc.cc',
            '<(V8_ROOT)/src/ppc/deoptimizer-ppc.cc',
            '<(V8_ROOT)/src/ppc/disasm-ppc.cc',
            '<(V8_ROOT)/src/ppc/frame-constants-ppc.cc',
            '<(V8_ROOT)/src/ppc/frame-constants-ppc.h',
            '<(V8_ROOT)/src/ppc/interface-descriptors-ppc.cc',
            '<(V8_ROOT)/src/ppc/macro-assembler-ppc.cc',
            '<(V8_ROOT)/src/ppc/macro-assembler-ppc.h',
            '<(V8_ROOT)/src/ppc/register-ppc.h',
            '<(V8_ROOT)/src/ppc/simulator-ppc.cc',
            '<(V8_ROOT)/src/ppc/simulator-ppc.h',
            '<(V8_ROOT)/src/regexp/ppc/regexp-macro-assembler-ppc.cc',
            '<(V8_ROOT)/src/regexp/ppc/regexp-macro-assembler-ppc.h',
            '<(V8_ROOT)/src/wasm/baseline/ppc/liftoff-assembler-ppc.h',
          ],
        }],
        ['v8_target_arch=="s390x"', {
          'sources': [  ### gcmole(arch:s390) ###
            '<(V8_ROOT)/src/compiler/backend/s390/code-generator-s390.cc',
            '<(V8_ROOT)/src/compiler/backend/s390/instruction-codes-s390.h',
            '<(V8_ROOT)/src/compiler/backend/s390/instruction-scheduler-s390.cc',
            '<(V8_ROOT)/src/compiler/backend/s390/instruction-selector-s390.cc',
            '<(V8_ROOT)/src/debug/s390/debug-s390.cc',
            '<(V8_ROOT)/src/regexp/s390/regexp-macro-assembler-s390.cc',
            '<(V8_ROOT)/src/regexp/s390/regexp-macro-assembler-s390.h',
            '<(V8_ROOT)/src/s390/assembler-s390-inl.h',
            '<(V8_ROOT)/src/s390/assembler-s390.cc',
            '<(V8_ROOT)/src/s390/assembler-s390.h',
            '<(V8_ROOT)/src/s390/constants-s390.cc',
            '<(V8_ROOT)/src/s390/constants-s390.h',
            '<(V8_ROOT)/src/s390/cpu-s390.cc',
            '<(V8_ROOT)/src/s390/deoptimizer-s390.cc',
            '<(V8_ROOT)/src/s390/disasm-s390.cc',
            '<(V8_ROOT)/src/s390/frame-constants-s390.cc',
            '<(V8_ROOT)/src/s390/frame-constants-s390.h',
            '<(V8_ROOT)/src/s390/interface-descriptors-s390.cc',
            '<(V8_ROOT)/src/s390/macro-assembler-s390.cc',
            '<(V8_ROOT)/src/s390/macro-assembler-s390.h',
            '<(V8_ROOT)/src/s390/register-s390.h',
            '<(V8_ROOT)/src/s390/simulator-s390.cc',
            '<(V8_ROOT)/src/s390/simulator-s390.h',
            '<(V8_ROOT)/src/wasm/baseline/s390/liftoff-assembler-s390.h',
          ],
        }],
        ['OS=="win"', {
          'msvs_precompiled_header': '<(V8_ROOT)/../../tools/msvs/pch/v8_pch.h',
          'msvs_precompiled_source': '<(V8_ROOT)/../../tools/msvs/pch/v8_pch.cc',
          'sources': [
            '<(_msvs_precompiled_header)',
            '<(_msvs_precompiled_source)',
          ],
          # This will prevent V8's .cc files conflicting with the inspector's
          # .cpp files in the same shard.
          'msvs_settings': {
            'VCCLCompilerTool': {
              'ObjectFile': '$(IntDir)%(Extension)\\',
            },
          },
        }],
        ['component=="shared_library"', {
          'defines': [
            'BUILDING_V8_SHARED',
          ],
        }],
        ['v8_enable_i18n_support', {
          'conditions': [
            ['icu_use_data_file_flag', {
              'defines': ['ICU_UTIL_DATA_IMPL=ICU_UTIL_DATA_FILE'],
            }, {
               'conditions': [
                 ['OS=="win"', {
                   'defines': ['ICU_UTIL_DATA_IMPL=ICU_UTIL_DATA_SHARED'],
                 }, {
                    'defines': ['ICU_UTIL_DATA_IMPL=ICU_UTIL_DATA_STATIC'],
                  }],
               ],
             }],
            ['OS=="win"', {
              'dependencies': [
                '<(icu_gyp_path):icudata#target',
              ],
            }],
          ],
        }, {  # v8_enable_i18n_support==0
           'sources!': [
             '<(V8_ROOT)/src/builtins/builtins-intl.cc',
             '<(V8_ROOT)/src/char-predicates.cc',
             '<(V8_ROOT)/src/objects/intl-objects.cc',
             '<(V8_ROOT)/src/objects/intl-objects.h',
             '<(V8_ROOT)/src/objects/js-break-iterator-inl.h',
             '<(V8_ROOT)/src/objects/js-break-iterator.cc',
             '<(V8_ROOT)/src/objects/js-break-iterator.h',
             '<(V8_ROOT)/src/objects/js-collator-inl.h',
             '<(V8_ROOT)/src/objects/js-collator.cc',
             '<(V8_ROOT)/src/objects/js-collator.h',
             '<(V8_ROOT)/src/objects/js-date-time-format-inl.h',
             '<(V8_ROOT)/src/objects/js-date-time-format.cc',
             '<(V8_ROOT)/src/objects/js-date-time-format.h',
             '<(V8_ROOT)/src/objects/js-list-format-inl.h',
             '<(V8_ROOT)/src/objects/js-list-format.cc',
             '<(V8_ROOT)/src/objects/js-list-format.h',
             '<(V8_ROOT)/src/objects/js-locale-inl.h',
             '<(V8_ROOT)/src/objects/js-locale.cc',
             '<(V8_ROOT)/src/objects/js-locale.h',
             '<(V8_ROOT)/src/objects/js-number-format-inl.h',
             '<(V8_ROOT)/src/objects/js-number-format.cc',
             '<(V8_ROOT)/src/objects/js-number-format.h',
             '<(V8_ROOT)/src/objects/js-plural-rules-inl.h',
             '<(V8_ROOT)/src/objects/js-plural-rules.cc',
             '<(V8_ROOT)/src/objects/js-plural-rules.h',
             '<(V8_ROOT)/src/objects/js-relative-time-format-inl.h',
             '<(V8_ROOT)/src/objects/js-relative-time-format.cc',
             '<(V8_ROOT)/src/objects/js-relative-time-format.h',
             '<(V8_ROOT)/src/objects/js-segment-iterator-inl.h',
             '<(V8_ROOT)/src/objects/js-segment-iterator.cc',
             '<(V8_ROOT)/src/objects/js-segment-iterator.h',
             '<(V8_ROOT)/src/objects/js-segmenter-inl.h',
             '<(V8_ROOT)/src/objects/js-segmenter.cc',
             '<(V8_ROOT)/src/objects/js-segmenter.h',
             '<(V8_ROOT)/src/runtime/runtime-intl.cc',
           ],
         }],
        ['v8_postmortem_support', {
          'dependencies': ['postmortem-metadata#target'],
        }],
        # Platforms that don't have Compare-And-Swap (CAS) support need to link atomic library
        # to implement atomic memory access
        ['v8_current_cpu in ["mips", "mipsel", "mips64", "mips64el", "ppc", "ppc64", "s390x"]', {
          'link_settings': {
            'libraries': ['-latomic', ],
          },
        }],
      ],
    },  # v8_base_without_compiler
    {
      'target_name': 'v8_base',
      'type': 'none',
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
      ],
      'dependencies': [
        'v8_base_without_compiler',
        'v8_compiler',
      ],
    },  # v8_base
    {
      'target_name': 'torque_base',
      'type': 'static_library',
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
      ],
      'sources': [
        '<(V8_ROOT)/src/torque/ast.h',
        '<(V8_ROOT)/src/torque/cfg.cc',
        '<(V8_ROOT)/src/torque/cfg.h',
        '<(V8_ROOT)/src/torque/contextual.h',
        '<(V8_ROOT)/src/torque/csa-generator.cc',
        '<(V8_ROOT)/src/torque/csa-generator.h',
        '<(V8_ROOT)/src/torque/declarable.cc',
        '<(V8_ROOT)/src/torque/declarable.h',
        '<(V8_ROOT)/src/torque/declaration-visitor.cc',
        '<(V8_ROOT)/src/torque/declaration-visitor.h',
        '<(V8_ROOT)/src/torque/declarations.cc',
        '<(V8_ROOT)/src/torque/declarations.h',
        '<(V8_ROOT)/src/torque/earley-parser.cc',
        '<(V8_ROOT)/src/torque/earley-parser.h',
        '<(V8_ROOT)/src/torque/file-visitor.cc',
        '<(V8_ROOT)/src/torque/file-visitor.h',
        '<(V8_ROOT)/src/torque/global-context.h',
        '<(V8_ROOT)/src/torque/implementation-visitor.cc',
        '<(V8_ROOT)/src/torque/implementation-visitor.h',
        '<(V8_ROOT)/src/torque/instructions.cc',
        '<(V8_ROOT)/src/torque/instructions.h',
        '<(V8_ROOT)/src/torque/server-data.cc',
        '<(V8_ROOT)/src/torque/server-data.h',
        '<(V8_ROOT)/src/torque/source-positions.cc',
        '<(V8_ROOT)/src/torque/source-positions.h',
        '<(V8_ROOT)/src/torque/torque-compiler.cc',
        '<(V8_ROOT)/src/torque/torque-compiler.h',
        '<(V8_ROOT)/src/torque/torque-parser.cc',
        '<(V8_ROOT)/src/torque/torque-parser.h',
        '<(V8_ROOT)/src/torque/type-oracle.cc',
        '<(V8_ROOT)/src/torque/type-oracle.h',
        '<(V8_ROOT)/src/torque/types.cc',
        '<(V8_ROOT)/src/torque/types.h',
        '<(V8_ROOT)/src/torque/utils.cc',
        '<(V8_ROOT)/src/torque/utils.h',
      ],
      'dependencies': [
        'v8_shared_internal_headers',
        'v8_libbase',
      ],
      'defines!': [
        '_HAS_EXCEPTIONS=0',
        'BUILDING_V8_SHARED=1',
      ],
      'cflags_cc!': ['-fno-exceptions'],
      'cflags_cc': ['-fexceptions'],
      'xcode_settings': {
        'GCC_ENABLE_CPP_EXCEPTIONS': 'YES',  # -fexceptions
      },
      'msvs_settings': {
        'VCCLCompilerTool': {
          'RuntimeTypeInfo': 'true',
          'ExceptionHandling': 1,
        },
      },
    },  # torque_base
    {
      'target_name': 'torque_ls_base',
      'type': 'static_library',
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
      ],
      'sources': [
        '<(V8_ROOT)/src/torque/ls/globals.h',
        '<(V8_ROOT)/src/torque/ls/json-parser.cc',
        '<(V8_ROOT)/src/torque/ls/json-parser.h',
        '<(V8_ROOT)/src/torque/ls/json.cc',
        '<(V8_ROOT)/src/torque/ls/json.h',
        '<(V8_ROOT)/src/torque/ls/message-handler.cc',
        '<(V8_ROOT)/src/torque/ls/message-handler.h',
        '<(V8_ROOT)/src/torque/ls/message-macros.h',
        '<(V8_ROOT)/src/torque/ls/message-pipe.h',
        '<(V8_ROOT)/src/torque/ls/message.h',
      ],
      'dependencies': [
        'torque_base',
      ],
      'defines!': [
        '_HAS_EXCEPTIONS=0',
        'BUILDING_V8_SHARED=1',
      ],
      'cflags_cc!': ['-fno-exceptions'],
      'cflags_cc': ['-fexceptions'],
      'xcode_settings': {
        'GCC_ENABLE_CPP_EXCEPTIONS': 'YES',  # -fexceptions
      },
      'msvs_settings': {
        'VCCLCompilerTool': {
          'RuntimeTypeInfo': 'true',
          'ExceptionHandling': 1,
        },
      },
    },  # torque_ls_base
    {
      'target_name': 'v8_libbase',
      'type': 'static_library',
      'sources': [
        '<(V8_ROOT)/src/base/adapters.h',
        '<(V8_ROOT)/src/base/address-region.h',
        '<(V8_ROOT)/src/base/atomic-utils.h',
        '<(V8_ROOT)/src/base/atomicops.h',
        '<(V8_ROOT)/src/base/atomicops_internals_atomicword_compat.h',
        '<(V8_ROOT)/src/base/atomicops_internals_portable.h',
        '<(V8_ROOT)/src/base/atomicops_internals_std.h',
        '<(V8_ROOT)/src/base/base-export.h',
        '<(V8_ROOT)/src/base/bits.cc',
        '<(V8_ROOT)/src/base/bits.h',
        '<(V8_ROOT)/src/base/bounded-page-allocator.cc',
        '<(V8_ROOT)/src/base/bounded-page-allocator.h',
        '<(V8_ROOT)/src/base/build_config.h',
        '<(V8_ROOT)/src/base/compiler-specific.h',
        '<(V8_ROOT)/src/base/cpu.cc',
        '<(V8_ROOT)/src/base/cpu.h',
        '<(V8_ROOT)/src/base/debug/stack_trace.cc',
        '<(V8_ROOT)/src/base/debug/stack_trace.h',
        '<(V8_ROOT)/src/base/division-by-constant.cc',
        '<(V8_ROOT)/src/base/division-by-constant.h',
        '<(V8_ROOT)/src/base/enum-set.h',
        '<(V8_ROOT)/src/base/export-template.h',
        '<(V8_ROOT)/src/base/file-utils.cc',
        '<(V8_ROOT)/src/base/file-utils.h',
        '<(V8_ROOT)/src/base/flags.h',
        '<(V8_ROOT)/src/base/format-macros.h',
        '<(V8_ROOT)/src/base/free_deleter.h',
        '<(V8_ROOT)/src/base/functional.cc',
        '<(V8_ROOT)/src/base/functional.h',
        '<(V8_ROOT)/src/base/hashmap-entry.h',
        '<(V8_ROOT)/src/base/hashmap.h',
        '<(V8_ROOT)/src/base/ieee754.cc',
        '<(V8_ROOT)/src/base/ieee754.h',
        '<(V8_ROOT)/src/base/iterator.h',
        '<(V8_ROOT)/src/base/lazy-instance.h',
        '<(V8_ROOT)/src/base/list.h',
        '<(V8_ROOT)/src/base/logging.cc',
        '<(V8_ROOT)/src/base/logging.h',
        '<(V8_ROOT)/src/base/lsan-page-allocator.cc',
        '<(V8_ROOT)/src/base/lsan-page-allocator.h',
        '<(V8_ROOT)/src/base/macros.h',
        '<(V8_ROOT)/src/base/once.cc',
        '<(V8_ROOT)/src/base/once.h',
        '<(V8_ROOT)/src/base/optional.h',
        '<(V8_ROOT)/src/base/overflowing-math.h',
        '<(V8_ROOT)/src/base/page-allocator.cc',
        '<(V8_ROOT)/src/base/page-allocator.h',
        '<(V8_ROOT)/src/base/platform/condition-variable.cc',
        '<(V8_ROOT)/src/base/platform/condition-variable.h',
        '<(V8_ROOT)/src/base/platform/elapsed-timer.h',
        '<(V8_ROOT)/src/base/platform/mutex.cc',
        '<(V8_ROOT)/src/base/platform/mutex.h',
        '<(V8_ROOT)/src/base/platform/platform.h',
        '<(V8_ROOT)/src/base/platform/semaphore.cc',
        '<(V8_ROOT)/src/base/platform/semaphore.h',
        '<(V8_ROOT)/src/base/platform/time.cc',
        '<(V8_ROOT)/src/base/platform/time.h',
        '<(V8_ROOT)/src/base/region-allocator.cc',
        '<(V8_ROOT)/src/base/region-allocator.h',
        '<(V8_ROOT)/src/base/ring-buffer.h',
        '<(V8_ROOT)/src/base/safe_conversions.h',
        '<(V8_ROOT)/src/base/safe_conversions_impl.h',
        '<(V8_ROOT)/src/base/small-vector.h',
        '<(V8_ROOT)/src/base/sys-info.cc',
        '<(V8_ROOT)/src/base/sys-info.h',
        '<(V8_ROOT)/src/base/template-utils.h',
        '<(V8_ROOT)/src/base/timezone-cache.h',
        '<(V8_ROOT)/src/base/tsan.h',
        '<(V8_ROOT)/src/base/utils/random-number-generator.cc',
        '<(V8_ROOT)/src/base/utils/random-number-generator.h',
      ],

      'dependencies': [
        'v8_headers',
      ],

      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
        ['is_component_build', {
          'defines': ["BUILDING_V8_BASE_SHARED"],
        }],
        ['is_posix or is_fuchsia', {
          'sources': [
            '<(V8_ROOT)/src/base/platform/platform-posix.cc',
            '<(V8_ROOT)/src/base/platform/platform-posix.h',
          ],
          'conditions': [
            ['OS != "aix" and OS != "solaris"', {
              'sources': [
                '<(V8_ROOT)/src/base/platform/platform-posix-time.cc',
                '<(V8_ROOT)/src/base/platform/platform-posix-time.h',
              ],
            }],
          ],
        }],
        ['OS=="linux"', {
          'sources': [
            '<(V8_ROOT)/src/base/debug/stack_trace_posix.cc',
            '<(V8_ROOT)/src/base/platform/platform-linux.cc',
          ],
          'link_settings': {
            'libraries': [
              '-ldl',
              '-lrt'
            ],
          },
        }],
        ['OS=="aix"', {
          'variables': {
            # Used to differentiate `AIX` and `OS400`(IBM i).
            'aix_variant_name': '<!(uname -s)',
          },
          'sources': [
            '<(V8_ROOT)/src/base/debug/stack_trace_posix.cc',
            '<(V8_ROOT)/src/base/platform/platform-aix.cc',
          ],
          'conditions': [
            [ '"<(aix_variant_name)"=="AIX"', { # It is `AIX`
              'link_settings': {
                'libraries': [
                  '-ldl',
                  '-lrt'
                ],
              },
            }],
          ],
        }],
        ['is_android', {
          'sources': [
            '<(V8_ROOT)/src/base/debug/stack_trace_android.cc',
            '<(V8_ROOT)/src/base/platform/platform-posix.cc',
            '<(V8_ROOT)/src/base/platform/platform-posix.h',
            '<(V8_ROOT)/src/base/platform/platform-posix-time.cc',
            '<(V8_ROOT)/src/base/platform/platform-posix-time.h',
          ],
          'conditions': [
            ['_toolset=="host"', {
              'link_settings': {
                'libraries': [
                  '-ldl',
                  '-lrt'
                ]
              },
              'conditions': [
                ['_toolset=="host"', {
                  'conditions': [
                    ['host_os == "mac"', {
                      'sources': [
                        '<(V8_ROOT)/src/base/debug/stack_trace_posix.cc'
                        '<(V8_ROOT)/src/base/platform/platform-macos.cc'
                      ]
                    }, {
                       'sources': [
                         '<(V8_ROOT)/src/base/debug/stack_trace_posix.cc'
                         '<(V8_ROOT)/src/base/platform/platform-linux.cc'
                       ]
                     }],
                  ],
                }, {
                   'sources': [
                     '<(V8_ROOT)/src/base/debug/stack_trace_android.cc'
                     '<(V8_ROOT)/src/base/platform/platform-linux.cc'
                   ]
                 }],
              ],
            }],
          ],
        }],
        ['is_fuchsia', {
          'sources': [
            '<(V8_ROOT)/src/base/debug/stack_trace_fuchsia.cc',
            '<(V8_ROOT)/src/base/platform/platform-fuchsia.cc',
          ]
        }],
        ['OS == "mac" or OS == "ios"', {
          'sources': [
            '<(V8_ROOT)/src/base/debug/stack_trace_posix.cc',
            '<(V8_ROOT)/src/base/platform/platform-macos.cc',
          ]
        }],
        ['is_win', {
          'sources': [
            '<(V8_ROOT)/src/base/debug/stack_trace_win.cc',
            '<(V8_ROOT)/src/base/platform/platform-win32.cc',
            '<(V8_ROOT)/src/base/win32-headers.h',
          ],

          'defines': ['_CRT_RAND_S'],  # for rand_s()
          'direct_dependent_settings': {
            'msvs_settings': {
              'VCLinkerTool': {
                'AdditionalDependencies': [
                  'dbghelp.lib',
                  'winmm.lib',
                  'ws2_32.lib'
                ]
              }
            },
          },
        }],
        ['target_arch == "mips" or OS == "mips64"', {
          # here just for 'BUILD.gn' sync
          # 'data': [
          #   '<(V8_ROOT)/tools/mips_toolchain/sysroot/usr/lib/',
          #   '<(V8_ROOT)/tools/mips_toolchain/sysroot/usr/lib/',
          # ],
        }],
        # end of conditions from 'BUILD.gn'

        # Node.js validated
        ['OS=="solaris"', {
          'link_settings': {
            'libraries': [
              '-lnsl',
              '-lrt',
            ]
          },
          'sources': [
            '<(V8_ROOT)/src/base/debug/stack_trace_posix.cc',
            '<(V8_ROOT)/src/base/platform/platform-solaris.cc',
          ],
        }],

        # YMMV with the following conditions
        ['OS=="qnx"', {
          'link_settings': {
            'target_conditions': [
              ['_toolset=="host" and host_os=="linux"', {
                'libraries': [
                  '-lrt'
                ],
              }],
              ['_toolset=="target"', {
                'libraries': [
                  '-lbacktrace'
                ],
              }],
            ],
          },
          'sources': [
            '<(V8_ROOT)/src/base/debug/stack_trace_posix.cc',
            '<(V8_ROOT)/src/base/platform/platform-posix.h',
            '<(V8_ROOT)/src/base/platform/platform-posix.cc',
            '<(V8_ROOT)/src/base/platform/platform-posix-time.h',
            '<(V8_ROOT)/src/base/platform/platform-posix-time.cc',
            '<(V8_ROOT)/src/base/qnx-math.h'
          ],
          'target_conditions': [
            ['_toolset=="host" and host_os=="linux"', {
              'sources': [
                '<(V8_ROOT)/src/base/platform/platform-linux.cc'
              ],
            }],
            ['_toolset=="host" and host_os=="mac"', {
              'sources': [
                '<(V8_ROOT)/src/base/platform/platform-macos.cc'
              ],
            }],
            ['_toolset=="target"', {
              'sources': [
                '<(V8_ROOT)/src/base/platform/platform-qnx.cc'
              ],
            }],
          ],
        },
         ],
        ['OS=="freebsd"', {
          'link_settings': {
            'libraries': [
              '-L/usr/local/lib -lexecinfo',
            ]
          },
          'sources': [
            '<(V8_ROOT)/src/base/debug/stack_trace_posix.cc',
            '<(V8_ROOT)/src/base/platform/platform-freebsd.cc',
            '<(V8_ROOT)/src/base/platform/platform-posix.h',
            '<(V8_ROOT)/src/base/platform/platform-posix.cc',
            '<(V8_ROOT)/src/base/platform/platform-posix-time.h',
            '<(V8_ROOT)/src/base/platform/platform-posix-time.cc',
          ],
        }
         ],
        ['OS=="openbsd"', {
          'link_settings': {
            'libraries': [
              '-L/usr/local/lib -lexecinfo',
            ]
          },
          'sources': [
            '<(V8_ROOT)/src/base/debug/stack_trace_posix.cc',
            '<(V8_ROOT)/src/base/platform/platform-openbsd.cc',
            '<(V8_ROOT)/src/base/platform/platform-posix.h',
            '<(V8_ROOT)/src/base/platform/platform-posix.cc',
            '<(V8_ROOT)/src/base/platform/platform-posix-time.h',
            '<(V8_ROOT)/src/base/platform/platform-posix-time.cc',
          ],
        }
         ],
        ['OS=="netbsd"', {
          'link_settings': {
            'libraries': [
              '-L/usr/pkg/lib -Wl,-R/usr/pkg/lib -lexecinfo',
            ]
          },
          'sources': [
            '<(V8_ROOT)/src/base/debug/stack_trace_posix.cc',
            '<(V8_ROOT)/src/base/platform/platform-openbsd.cc',
            '<(V8_ROOT)/src/base/platform/platform-posix.h',
            '<(V8_ROOT)/src/base/platform/platform-posix.cc',
            '<(V8_ROOT)/src/base/platform/platform-posix-time.h',
            '<(V8_ROOT)/src/base/platform/platform-posix-time.cc',
          ],
        }
         ],
      ],
    },  # v8_libbase
    {
      'target_name': 'v8_libplatform',
      'type': 'static_library',
      'dependencies': [
        'v8_libbase',
      ],
      'sources': [
        '<(V8_ROOT)/base/trace_event/common/trace_event_common.h',
        '<(V8_ROOT)/include/libplatform/libplatform-export.h',
        '<(V8_ROOT)/include/libplatform/libplatform.h',
        '<(V8_ROOT)/include/libplatform/v8-tracing.h',
        '<(V8_ROOT)/src/libplatform/default-foreground-task-runner.cc',
        '<(V8_ROOT)/src/libplatform/default-foreground-task-runner.h',
        '<(V8_ROOT)/src/libplatform/default-platform.cc',
        '<(V8_ROOT)/src/libplatform/default-platform.h',
        '<(V8_ROOT)/src/libplatform/default-worker-threads-task-runner.cc',
        '<(V8_ROOT)/src/libplatform/default-worker-threads-task-runner.h',
        '<(V8_ROOT)/src/libplatform/delayed-task-queue.cc',
        '<(V8_ROOT)/src/libplatform/delayed-task-queue.h',
        '<(V8_ROOT)/src/libplatform/task-queue.cc',
        '<(V8_ROOT)/src/libplatform/task-queue.h',
        '<(V8_ROOT)/src/libplatform/tracing/trace-buffer.cc',
        '<(V8_ROOT)/src/libplatform/tracing/trace-buffer.h',
        '<(V8_ROOT)/src/libplatform/tracing/trace-config.cc',
        '<(V8_ROOT)/src/libplatform/tracing/trace-object.cc',
        '<(V8_ROOT)/src/libplatform/tracing/trace-writer.cc',
        '<(V8_ROOT)/src/libplatform/tracing/trace-writer.h',
        '<(V8_ROOT)/src/libplatform/tracing/tracing-controller.cc',
        '<(V8_ROOT)/src/libplatform/worker-thread.cc',
        '<(V8_ROOT)/src/libplatform/worker-thread.h',
      ],
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
        ['component=="shared_library"', {
          'direct_dependent_settings': {
            'defines': ['USING_V8_PLATFORM_SHARED'],
          },
          'defines': ['BUILDING_V8_PLATFORM_SHARED'],
        }],
        ['v8_use_perfetto', {
          'dependencies': ['<(V8_ROOT)/third_party/perfetto:libperfetto'],
        }],
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '<(V8_ROOT)/include',
        ],
      },
    },  # v8_libplatform
    {
      'target_name': 'v8_libsampler',
      'type': 'static_library',
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
      ],
      'dependencies': [
        'v8_libbase',
      ],
      'sources': [
        '<(V8_ROOT)/src/libsampler/sampler.cc',
        '<(V8_ROOT)/src/libsampler/sampler.h'
      ],
    },  # v8_libsampler

    # {
    #   'target_name': 'fuzzer_support',
    #   'type': 'static_library',
    #   'conditions': [
    #     ['want_separate_host_toolset', {
    #       'toolsets': ['host', 'target'],
    #     }],
    #   ],
    #   'dependencies': [
    #     'v8',
    #     'v8_libbase',
    #     'v8_libplatform',
    #     'v8_maybe_icu',
    #   ],
    #   'sources': [
    #     "<(V8_ROOT)/test/fuzzer/fuzzer-support.cc",
    #     "<(V8_ROOT)/test/fuzzer/fuzzer-support.h",
    #   ],
    # },  # fuzzer_support

    # {
    #   'target_name': 'wee8',
    #   'type': 'static_library',
    #   'dependencies': [
    #     'v8_base',
    #     'v8_libbase',
    #     'v8_libplatform',
    #     'v8_libsampler',
    #     'v8_maybe_snapshot',
    #     # 'build/win:default_exe_manifest',
    #   ],
    #   'sources': [
    #     "<(V8_ROOT)/src/wasm/c-api.cc",
    #     "<(V8_ROOT)/third_party/wasm-c-api/wasm.h",
    #     "<(V8_ROOT)/third_party/wasm-c-api/wasm.hh",
    #   ],
    # }, # wee8

    # ###############################################################################
    # # Executablesicu_path
    # #

    {
      'target_name': 'bytecode_builtins_list_generator',
      'type': 'executable',
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host'],
        }],
      ],
      'defines!': [
        'BUILDING_V8_SHARED=1',
      ],
      'dependencies': [
        "v8_libbase",
        # "build/win:default_exe_manifest",
      ],
      'sources': [
        "<(V8_ROOT)/src/builtins/generate-bytecodes-builtins-list.cc",
        "<(V8_ROOT)/src/interpreter/bytecode-operands.cc",
        "<(V8_ROOT)/src/interpreter/bytecode-operands.h",
        "<(V8_ROOT)/src/interpreter/bytecodes.cc",
        "<(V8_ROOT)/src/interpreter/bytecodes.h",
      ],
    },  # bytecode_builtins_list_generator
    {
      'target_name': 'mksnapshot',
      'type': 'executable',
      'dependencies': [
        'v8_base_without_compiler',
        'v8_compiler_for_mksnapshot',
        'v8_init',
        'v8_libbase',
        'v8_libplatform',
        'v8_nosnapshot',
        # "build/win:default_exe_manifest",
        'v8_maybe_icu',
      ],
      'sources': [
        '<(V8_ROOT)/src/snapshot/embedded-file-writer.cc',
        '<(V8_ROOT)/src/snapshot/embedded-file-writer.h',
        '<(V8_ROOT)/src/snapshot/mksnapshot.cc',
      ],
      'conditions': [
        ['OS == "fuchsia"', {
          'defines': ['V8_TARGET_OS_FUCHSIA'],
        }],
        ['OS=="win"', {
          'defines': ['V8_TARGET_OS_WIN'],
        }],
        ['want_separate_host_toolset', {
          'toolsets': ['host'],
        }],
      ],
    },  # mksnapshot
    {
      'target_name': 'torque',
      'type': 'executable',
      'dependencies': [
        'torque_base',
        # "build/win:default_exe_manifest",
      ],
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host'],
        }],
      ],
      'defines!': [
        '_HAS_EXCEPTIONS=0',
        'BUILDING_V8_SHARED=1',
      ],
      'cflags_cc!': ['-fno-exceptions'],
      'cflags_cc': ['-fexceptions'],
      'xcode_settings': {
        'GCC_ENABLE_CPP_EXCEPTIONS': 'YES',  # -fexceptions
      },
      'msvs_settings': {
        'VCCLCompilerTool': {
          'RuntimeTypeInfo': 'true',
          'ExceptionHandling': 1,
        },
        'VCLinkerTool': {
          'AdditionalDependencies': [
            'dbghelp.lib',
            'winmm.lib',
            'ws2_32.lib'
          ]
        }
      },
      'sources': [
        "<(V8_ROOT)/src/torque/torque.cc",
      ],
    },  # torque
    {
      'target_name': 'torque-language-server',
      'type': 'executable',
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host'],
        }],
      ],
      'dependencies': [
        'torque_base',
        'torque_ls_base',
        # "build/win:default_exe_manifest",
      ],
      'defines!': [
        '_HAS_EXCEPTIONS=0',
        'BUILDING_V8_SHARED=1',
      ],
      'msvs_settings': {
        'VCCLCompilerTool': {
          'RuntimeTypeInfo': 'true',
          'ExceptionHandling': 1,
        },
      },
      'sources': [
        "<(V8_ROOT)/src/torque/ls/torque-language-server.cc",
      ],
    },  # torque-language-server

    ###############################################################################
    # Public targets
    #

    {
      'target_name': 'v8',
      'hard_dependency': 1,
      'toolsets': ['target'],
      'dependencies': [
        'v8_maybe_snapshot'
      ],
      'conditions': [
        ['component=="shared_library"', {
          'type': '<(component)',
          'sources': [
            # Note: on non-Windows we still build this file so that gyp
            # has some sources to link into the component.
            '<(V8_ROOT)/src/v8dll-main.cc',
          ],
          'defines': [
            'BUILDING_V8_SHARED',
          ],
          'direct_dependent_settings': {
            'defines': [
              'USING_V8_SHARED',
            ],
          },
          'conditions': [
            ['OS=="mac"', {
              'xcode_settings': {
                'OTHER_LDFLAGS': ['-dynamiclib', '-all_load']
              },
            }],
            ['soname_version!=""', {
              'product_extension': 'so.<(soname_version)',
            }],
          ],
        },
         {
           'type': 'static_library',
         }],
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '<(V8_ROOT)/include',
        ],
      },
      'actions': [
        {
          'action_name': 'v8_dump_build_config',
          'inputs': [
            '<(V8_ROOT)/tools/testrunner/utils/dump_build_config_gyp.py',
          ],
          'outputs': [
            '<(PRODUCT_DIR)/v8_build_config.json',
          ],
          'variables': {
            'v8_dump_build_config_args': [
              '<(PRODUCT_DIR)/v8_build_config.json',
              'dcheck_always_on=<(dcheck_always_on)',
              'is_android=<(is_android)',
              'is_asan=<(asan)',
              'is_cfi=<(cfi_vptr)',
              'is_clang=<(clang)',
              'is_component_build=<(component)',
              'is_debug=<(CONFIGURATION_NAME)',
              # Not available in gyp.
              'is_gcov_coverage=0',
              'is_msan=<(msan)',
              'is_tsan=<(tsan)',
              # Not available in gyp.
              'is_ubsan_vptr=0',
              'target_cpu=<(target_arch)',
              'v8_enable_i18n_support=<(v8_enable_i18n_support)',
              'v8_enable_verify_predictable=<(v8_enable_verify_predictable)',
              'v8_target_cpu=<(v8_target_arch)',
              'v8_use_snapshot=<(v8_use_snapshot)',
              'v8_use_siphash=<(v8_use_siphash)',
              'v8_enable_embedded_builtins=<(v8_enable_embedded_builtins)',
              'v8_enable_verify_csa=<(v8_enable_verify_csa)',
              'v8_enable_lite_mode=<(v8_enable_lite_mode)',
              'v8_enable_pointer_compression=<(v8_enable_pointer_compression)',
            ]
          },
          'conditions': [
            ['v8_target_arch=="mips" or v8_target_arch=="mipsel" \
              or v8_target_arch=="mips64" or v8_target_arch=="mips64el"', {
              'v8_dump_build_config_args': [
                'mips_arch_variant=<(mips_arch_variant)',
                'mips_use_msa=<(mips_use_msa)',
              ],
            }],
          ],
          'action': [
            'python', '<(V8_ROOT)/tools/testrunner/utils/dump_build_config_gyp.py',
            '<@(v8_dump_build_config_args)',
          ],
        },
      ],
    },  # v8
    # missing a bunch of fuzzer targets

    ###############################################################################
    # Protobuf targets, used only when building outside of chromium.
    #

    {
      'target_name': 'postmortem-metadata',
      'type': 'none',
      'conditions': [
        ['want_separate_host_toolset', {
          'toolsets': ['host', 'target'],
        }],
      ],
      'variables': {
        'heapobject_files': [
          '<(V8_ROOT)/src/objects.h',
          '<(V8_ROOT)/src/objects-inl.h',
          '<(V8_ROOT)/src/objects/allocation-site-inl.h',
          '<(V8_ROOT)/src/objects/allocation-site.h',
          '<(V8_ROOT)/src/objects/cell-inl.h',
          '<(V8_ROOT)/src/objects/cell.h',
          '<(V8_ROOT)/src/objects/code-inl.h',
          '<(V8_ROOT)/src/objects/code.h',
          '<(V8_ROOT)/src/objects/data-handler.h',
          '<(V8_ROOT)/src/objects/data-handler-inl.h',
          '<(V8_ROOT)/src/objects/feedback-cell.h',
          '<(V8_ROOT)/src/objects/feedback-cell-inl.h',
          '<(V8_ROOT)/src/objects/fixed-array-inl.h',
          '<(V8_ROOT)/src/objects/fixed-array.h',
          '<(V8_ROOT)/src/objects/heap-number-inl.h',
          '<(V8_ROOT)/src/objects/heap-number.h',
          '<(V8_ROOT)/src/objects/heap-object-inl.h',
          '<(V8_ROOT)/src/objects/heap-object.h',
          '<(V8_ROOT)/src/objects/instance-type.h',
          '<(V8_ROOT)/src/objects/js-array-inl.h',
          '<(V8_ROOT)/src/objects/js-array.h',
          '<(V8_ROOT)/src/objects/js-array-buffer-inl.h',
          '<(V8_ROOT)/src/objects/js-array-buffer.h',
          '<(V8_ROOT)/src/objects/js-objects-inl.h',
          '<(V8_ROOT)/src/objects/js-objects.h',
          '<(V8_ROOT)/src/objects/js-promise-inl.h',
          '<(V8_ROOT)/src/objects/js-promise.h',
          '<(V8_ROOT)/src/objects/js-regexp-inl.h',
          '<(V8_ROOT)/src/objects/js-regexp.h',
          '<(V8_ROOT)/src/objects/js-regexp-string-iterator-inl.h',
          '<(V8_ROOT)/src/objects/js-regexp-string-iterator.h',
          '<(V8_ROOT)/src/objects/map.h',
          '<(V8_ROOT)/src/objects/map.cc',
          '<(V8_ROOT)/src/objects/map-inl.h',
          '<(V8_ROOT)/src/objects/js-objects.cc',
          '<(V8_ROOT)/src/objects/name.h',
          '<(V8_ROOT)/src/objects/name-inl.h',
          '<(V8_ROOT)/src/objects/oddball-inl.h',
          '<(V8_ROOT)/src/objects/oddball.h',
          '<(V8_ROOT)/src/objects/scope-info.h',
          '<(V8_ROOT)/src/objects/script.h',
          '<(V8_ROOT)/src/objects/script-inl.h',
          '<(V8_ROOT)/src/objects/shared-function-info.h',
          '<(V8_ROOT)/src/objects/shared-function-info-inl.h',
          '<(V8_ROOT)/src/objects/string.cc',
          '<(V8_ROOT)/src/objects/string.h',
          '<(V8_ROOT)/src/objects/string-comparator.cc',
          '<(V8_ROOT)/src/objects/string-comparator.h',
          '<(V8_ROOT)/src/objects/string-inl.h',
          '<(V8_ROOT)/src/objects/struct.h',
          '<(V8_ROOT)/src/objects/struct-inl.h',
        ],
      },
      'actions': [
        {
          'action_name': 'gen-postmortem-metadata',
          'inputs': [
            '<(V8_ROOT)/tools/gen-postmortem-metadata.py',
            '<@(heapobject_files)',
          ],
          'outputs': [
            '<(SHARED_INTERMEDIATE_DIR)/debug-support.cc',
          ],
          'action': [
            'python',
            '<(V8_ROOT)/tools/gen-postmortem-metadata.py',
            '<@(_outputs)',
            '<@(heapobject_files)'
          ],
        },
      ],
      'direct_dependent_settings': {
        'sources': ['<(SHARED_INTERMEDIATE_DIR)/debug-support.cc', ],
      },
    },  # postmortem-metadata
  ],
}
