# Node.js 7 ChangeLog

<!--lint disable prohibited-strings-->
<!--lint disable maximum-line-length-->

<table>
<tr>
<th title="Previously called 'Stable'">Current</th>
</tr>
<tr>
<td>
<a href="#7.10.1">7.10.1</a><br/>
<a href="#7.10.0">7.10.0</a><br/>
<a href="#7.9.0">7.9.0</a><br/>
<a href="#7.8.0">7.8.0</a><br/>
<a href="#7.7.4">7.7.4</a><br/>
<a href="#7.7.3">7.7.3</a><br/>
<a href="#7.7.2">7.7.2</a><br/>
<a href="#7.7.1">7.7.1</a><br/>
<a href="#7.7.0">7.7.0</a><br/>
<a href="#7.6.0">7.6.0</a><br/>
<a href="#7.5.0">7.5.0</a><br/>
<a href="#7.4.0">7.4.0</a><br/>
<a href="#7.3.0">7.3.0</a><br/>
<a href="#7.2.1">7.2.1</a><br/>
<a href="#7.2.0">7.2.0</a><br/>
<a href="#7.1.0">7.1.0</a><br/>
<a href="#7.0.0">7.0.0</a><br/>
</td>
</tr>
</table>

* Other Versions
  * [13.x](CHANGELOG_V13.md)
  * [12.x](CHANGELOG_V12.md)
  * [11.x](CHANGELOG_V11.md)
  * [10.x](CHANGELOG_V10.md)
  * [9.x](CHANGELOG_V9.md)
  * [8.x](CHANGELOG_V8.md)
  * [6.x](CHANGELOG_V6.md)
  * [5.x](CHANGELOG_V5.md)
  * [4.x](CHANGELOG_V4.md)
  * [0.12.x](CHANGELOG_V012.md)
  * [0.10.x](CHANGELOG_V010.md)
  * [io.js](CHANGELOG_IOJS.md)
  * [Archive](CHANGELOG_ARCHIVE.md)

<a id="7.10.1"></a>
## 2017-07-11, Version 7.10.1 (Current), @evanlucas

This is a security release. All Node.js users should consult the
security release summary at
https://nodejs.org/en/blog/vulnerability/july-2017-security-releases/
for details on patched vulnerabilities.

### Notable changes

* **build**:
  * Disable V8 snapshots - The hashseed embedded in the snapshot is
    currently the same for all runs of the binary. This opens node up to
    collision attacks which could result in a Denial of Service. We have
    temporarily disabled snapshots until a more robust solution is found
    (Ali Ijaz Sheikh)
* **deps**:
  * CVE-2017-1000381 - The c-ares function ares_parse_naptr_reply(),
    which is used for parsing NAPTR responses, could be triggered to
    read memory outside of the given input buffer if the passed in DNS
    response packet was crafted in a particular way. This patch checks that
    there is enough data for the required elements of an NAPTR record (2
    int16, 3 bytes for string lengths) before processing a record. (David
    Drysdale)

### Commits

* [[`ff587deb54`](https://github.com/nodejs/node/commit/ff587deb54)] - **build**: disable V8 snapshots (Ali Ijaz Sheikh) [nodejs/node-private#84](https://github.com/nodejs/node-private/pull/84)
* [[`8a82960e76`](https://github.com/nodejs/node/commit/8a82960e76)] - **deps**: cherry-pick 9478908a49 from cares upstream (David Drysdale) [nodejs/node-private#88](https://github.com/nodejs/node-private/pull/88)
* [[`b5bf5e8086`](https://github.com/nodejs/node/commit/b5bf5e8086)] - **test**: verify hash seed uniqueness (Ali Ijaz Sheikh) [nodejs/node-private#84](https://github.com/nodejs/node-private/pull/84)

<a id="7.10.0"></a>
## 2017-05-02, Version 7.10.0 (Current), @evanlucas

### Notable Changes

* **crypto**: add randomFill and randomFillSync (Evan Lucas) [#10209](https://github.com/nodejs/node/pull/10209)
* **meta**: Added new collaborators
  * add lucamaraschi to collaborators (Luca Maraschi) [#12538](https://github.com/nodejs/node/pull/12538)
  * add DavidCai1993 to collaborators (David Cai) [#12435](https://github.com/nodejs/node/pull/12435)
  * add jkrems to collaborators (Jan Krems) [#12427](https://github.com/nodejs/node/pull/12427)
  * add AnnaMag to collaborators (AnnaMag) [#12414](https://github.com/nodejs/node/pull/12414)
* **process**: fix crash when Promise rejection is a Symbol (Cameron Little) [#11640](https://github.com/nodejs/node/pull/11640)
* **url**: make WHATWG URL more spec compliant (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* **v8**:
  * fix stack overflow in recursive method (Ben Noordhuis) [#12460](https://github.com/nodejs/node/pull/12460)
  * fix build errors with g++ 7 (Ben Noordhuis) [#12392](https://github.com/nodejs/node/pull/12392)

### Commits

* [[`224fd3af97`](https://github.com/nodejs/node/commit/224fd3af97)] - **benchmark**: terminate child process on Windows (Rich Trott) [#12658](https://github.com/nodejs/node/pull/12658)
* [[`373e9f08af`](https://github.com/nodejs/node/commit/373e9f08af)] - **benchmark**: add benchmark for v8.getHeap*Statistics (James M Snell) [#12681](https://github.com/nodejs/node/pull/12681)
* [[`7d87edc1ba`](https://github.com/nodejs/node/commit/7d87edc1ba)] - **benchmark**: add benchmark for string concatenations (Vse Mozhet Byt) [#12455](https://github.com/nodejs/node/pull/12455)
* [[`08ba9d437c`](https://github.com/nodejs/node/commit/08ba9d437c)] - **benchmark**: fix CLI arguments check in common.js (Vse Mozhet Byt) [#12429](https://github.com/nodejs/node/pull/12429)
* [[`440f4d4eef`](https://github.com/nodejs/node/commit/440f4d4eef)] - ***Revert*** "**benchmark**: fix CLI arguments check in common.js" (James M Snell) [#12474](https://github.com/nodejs/node/pull/12474)
* [[`b7aeed7a7e`](https://github.com/nodejs/node/commit/b7aeed7a7e)] - **benchmark**: improve cli error message (Brian White) [#12421](https://github.com/nodejs/node/pull/12421)
* [[`917534d541`](https://github.com/nodejs/node/commit/917534d541)] - **benchmark**: fix CLI arguments check in common.js (Vse Mozhet Byt) [#12429](https://github.com/nodejs/node/pull/12429)
* [[`f316b50e8d`](https://github.com/nodejs/node/commit/f316b50e8d)] - **benchmark**: replace more \[\].join() with ''.repeat() (Vse Mozhet Byt) [#12317](https://github.com/nodejs/node/pull/12317)
* [[`d58fa7873f`](https://github.com/nodejs/node/commit/d58fa7873f)] - **benchmark,windows**: TCP.readStart() meaningful only after completion (Refael Ackermann) [#12258](https://github.com/nodejs/node/pull/12258)
* [[`e4b2f61fb5`](https://github.com/nodejs/node/commit/e4b2f61fb5)] - **buffer**: use slightly faster NaN check (Brian White) [#12286](https://github.com/nodejs/node/pull/12286)
* [[`ebeb6c0a26`](https://github.com/nodejs/node/commit/ebeb6c0a26)] - **buffer**: optimize write() (Brian White) [#12361](https://github.com/nodejs/node/pull/12361)
* [[`0c0241ff73`](https://github.com/nodejs/node/commit/0c0241ff73)] - **buffer,util**: refactor for performance (Rich Trott) [#12153](https://github.com/nodejs/node/pull/12153)
* [[`caf6506f9f`](https://github.com/nodejs/node/commit/caf6506f9f)] - **build**: add target for checking for perm deopts (Brian White) [#12456](https://github.com/nodejs/node/pull/12456)
* [[`212475b451`](https://github.com/nodejs/node/commit/212475b451)] - **build**: use do_not_edit variable where possible (Ruslan Bekenev) [#12610](https://github.com/nodejs/node/pull/12610)
* [[`78ac637fe2`](https://github.com/nodejs/node/commit/78ac637fe2)] - **build**: fix case in lib names (Refael Ackermann) [#12522](https://github.com/nodejs/node/pull/12522)
* [[`e6be4b951a`](https://github.com/nodejs/node/commit/e6be4b951a)] - **build**: make linter targets silent (Sakthipriyan Vairamani (thefourtheye)) [#12423](https://github.com/nodejs/node/pull/12423)
* [[`4d9e6718f8`](https://github.com/nodejs/node/commit/4d9e6718f8)] - **build**: run cpplint even if jslint failed (Ruslan Bekenev) [#12276](https://github.com/nodejs/node/pull/12276)
* [[`9662ca1a03`](https://github.com/nodejs/node/commit/9662ca1a03)] - **build**: enable cctest to use generated objects (Daniel Bevenius) [#11956](https://github.com/nodejs/node/pull/11956)
* [[`42e940c5e9`](https://github.com/nodejs/node/commit/42e940c5e9)] - **build,win**: limit maxcpucount to 2 for MSBuild (João Reis) [#12184](https://github.com/nodejs/node/pull/12184)
* [[`933b6b57d6`](https://github.com/nodejs/node/commit/933b6b57d6)] - **cluster**: fix permanent deoptimizations (Brian White) [#12456](https://github.com/nodejs/node/pull/12456)
* [[`db585c9b4d`](https://github.com/nodejs/node/commit/db585c9b4d)] - **crypto**: update root certificates (Ben Noordhuis) [#12402](https://github.com/nodejs/node/pull/12402)
* [[`8ac8e50a58`](https://github.com/nodejs/node/commit/8ac8e50a58)] - **crypto**: make LazyTransform compabile with Streams1 (Matteo Collina) [#12380](https://github.com/nodejs/node/pull/12380)
* [[`75f4329e01`](https://github.com/nodejs/node/commit/75f4329e01)] - **(SEMVER-MINOR)** **crypto**: add randomFill and randomFillSync (Evan Lucas) [#10209](https://github.com/nodejs/node/pull/10209)
* [[`d154aafe18`](https://github.com/nodejs/node/commit/d154aafe18)] - **deps**: remove **/node_modules/form-data/README.md (Jeremiah Senkpiel) [#12643](https://github.com/nodejs/node/pull/12643)
* [[`e8595c505b`](https://github.com/nodejs/node/commit/e8595c505b)] - **deps**: cherry-pick 79aee39 from upstream v8 (Ben Noordhuis) [#12412](https://github.com/nodejs/node/pull/12412)
* [[`810f9215e5`](https://github.com/nodejs/node/commit/810f9215e5)] - **deps,win**: increase msvs_shard in gyp for V8 (João Reis) [#12184](https://github.com/nodejs/node/pull/12184)
* [[`c2c62874d4`](https://github.com/nodejs/node/commit/c2c62874d4)] - **doc**: fix formatting of TOC (Refael Ackermann) [#12731](https://github.com/nodejs/node/pull/12731)
* [[`f60a2e9527`](https://github.com/nodejs/node/commit/f60a2e9527)] - **doc**: fixup the collaborators list (Alexey Orlenko) [#12750](https://github.com/nodejs/node/pull/12750)
* [[`360efe48bc`](https://github.com/nodejs/node/commit/360efe48bc)] - **doc**: fix examples in repl.md (Vse Mozhet Byt) [#12684](https://github.com/nodejs/node/pull/12684)
* [[`395380a136`](https://github.com/nodejs/node/commit/395380a136)] - **doc**: add Added-in metadata for WHATWG URL (Timothy Gu) [#12683](https://github.com/nodejs/node/pull/12683)
* [[`fc96d1a573`](https://github.com/nodejs/node/commit/fc96d1a573)] - **doc**: document url.domainTo* methods separately (Timothy Gu) [#12683](https://github.com/nodejs/node/pull/12683)
* [[`45facc8822`](https://github.com/nodejs/node/commit/45facc8822)] - **doc**: fix an unclear wording in readline.md (Vse Mozhet Byt) [#12605](https://github.com/nodejs/node/pull/12605)
* [[`1316c77b79`](https://github.com/nodejs/node/commit/1316c77b79)] - **doc**: improve randomfill and fix broken link (Sakthipriyan Vairamani (thefourtheye)) [#12541](https://github.com/nodejs/node/pull/12541)
* [[`313b205834`](https://github.com/nodejs/node/commit/313b205834)] - **doc**: prepare js code for eslint-plugin-markdown (Vse Mozhet Byt) [#12563](https://github.com/nodejs/node/pull/12563)
* [[`b52f77df43`](https://github.com/nodejs/node/commit/b52f77df43)] - **doc**: fix typo in doc/api/process.md (morrme) [#12612](https://github.com/nodejs/node/pull/12612)
* [[`47b39928d5`](https://github.com/nodejs/node/commit/47b39928d5)] - **doc**: make commit guidelines easier to reference (Benjamin Fleischer) [#11732](https://github.com/nodejs/node/pull/11732)
* [[`4276c213f2`](https://github.com/nodejs/node/commit/4276c213f2)] - **doc**: add suggestion to use --3way (Michael Dawson) [#12510](https://github.com/nodejs/node/pull/12510)
* [[`3703fc6bbe`](https://github.com/nodejs/node/commit/3703fc6bbe)] - **doc**: update link to Code of Conduct (Alex Autem) [#12552](https://github.com/nodejs/node/pull/12552)
* [[`434873d24b`](https://github.com/nodejs/node/commit/434873d24b)] - **doc**: fix typo in fs.watch() description (Ivo von Putzer Reibegg) [#12550](https://github.com/nodejs/node/pull/12550)
* [[`eb78722922`](https://github.com/nodejs/node/commit/eb78722922)] - **doc**: add lucamaraschi to collaborators (Luca Maraschi) [#12538](https://github.com/nodejs/node/pull/12538)
* [[`9250f02d12`](https://github.com/nodejs/node/commit/9250f02d12)] - **doc**: clarify the callback arguments of dns.resolve (Roman Reiss) [#9532](https://github.com/nodejs/node/pull/9532)
* [[`38278db9c7`](https://github.com/nodejs/node/commit/38278db9c7)] - **doc**: unify spaces in a querystring.md code example (Vse Mozhet Byt) [#12465](https://github.com/nodejs/node/pull/12465)
* [[`3fc25dce82`](https://github.com/nodejs/node/commit/3fc25dce82)] - **doc**: run tests before landing changes (Rich Trott) [#12416](https://github.com/nodejs/node/pull/12416)
* [[`af0067cc5e`](https://github.com/nodejs/node/commit/af0067cc5e)] - **doc**: avoid colloquialism (Rich Trott) [#12417](https://github.com/nodejs/node/pull/12417)
* [[`d0ba631efa`](https://github.com/nodejs/node/commit/d0ba631efa)] - **doc**: fix encoding string in buffer example (MapleUncle) [#12482](https://github.com/nodejs/node/pull/12482)
* [[`3d8878c592`](https://github.com/nodejs/node/commit/3d8878c592)] - **doc**: correct git fix whitespace command (Mateusz Konieczny) [#12445](https://github.com/nodejs/node/pull/12445)
* [[`077187e9a8`](https://github.com/nodejs/node/commit/077187e9a8)] - **doc**: s/origin/upstream/ collaborator guide (Anna Henningsen) [#12436](https://github.com/nodejs/node/pull/12436)
* [[`5a2d358f2e`](https://github.com/nodejs/node/commit/5a2d358f2e)] - **doc**: remove inspector experimental warning (cjihrig) [#12408](https://github.com/nodejs/node/pull/12408)
* [[`320e72b32d`](https://github.com/nodejs/node/commit/320e72b32d)] - **doc**: add missing ) in CONTRIBUTING.md (Mateusz Konieczny) [#12444](https://github.com/nodejs/node/pull/12444)
* [[`4570d9853c`](https://github.com/nodejs/node/commit/4570d9853c)] - **doc**: add guide for backporting prs (Evan Lucas) [#11099](https://github.com/nodejs/node/pull/11099)
* [[`d7d1e923ad`](https://github.com/nodejs/node/commit/d7d1e923ad)] - **doc**: update link for landing PRs (Rich Trott) [#12415](https://github.com/nodejs/node/pull/12415)
* [[`4ce58bd56a`](https://github.com/nodejs/node/commit/4ce58bd56a)] - **doc**: add DavidCai1993 to collaborators (David Cai) [#12435](https://github.com/nodejs/node/pull/12435)
* [[`984232cc2a`](https://github.com/nodejs/node/commit/984232cc2a)] - **doc**: fix typo in streams.md (John Paul Bamberg) [#12428](https://github.com/nodejs/node/pull/12428)
* [[`060b63e91f`](https://github.com/nodejs/node/commit/060b63e91f)] - **doc**: add jkrems to collaborators (Jan Krems) [#12427](https://github.com/nodejs/node/pull/12427)
* [[`6a45be2fa6`](https://github.com/nodejs/node/commit/6a45be2fa6)] - **doc**: path functions ignore trailing slashes (Tobias Nießen) [#12181](https://github.com/nodejs/node/pull/12181)
* [[`92e239d001`](https://github.com/nodejs/node/commit/92e239d001)] - **doc**: add info about serializable types (Shubheksha Jalan) [#12313](https://github.com/nodejs/node/pull/12313)
* [[`5c57feaa27`](https://github.com/nodejs/node/commit/5c57feaa27)] - **doc**: fix formatting in onboarding-extras (Rich Trott) [#12350](https://github.com/nodejs/node/pull/12350)
* [[`e2d66ab809`](https://github.com/nodejs/node/commit/e2d66ab809)] - **doc**: response.write ignores body in some cases (Ruslan Bekenev) [#12314](https://github.com/nodejs/node/pull/12314)
* [[`d1e1832398`](https://github.com/nodejs/node/commit/d1e1832398)] - **doc**: add AnnaMag to collaborators (AnnaMag) [#12414](https://github.com/nodejs/node/pull/12414)
* [[`f3db9a6437`](https://github.com/nodejs/node/commit/f3db9a6437)] - **doc**: limit lines to 80 cols in internal README (Evan Lucas) [#12358](https://github.com/nodejs/node/pull/12358)
* [[`ed130168ed`](https://github.com/nodejs/node/commit/ed130168ed)] - **doc**: add single arg scenario for util.format (Tarun Batra) [#12374](https://github.com/nodejs/node/pull/12374)
* [[`aa511053be`](https://github.com/nodejs/node/commit/aa511053be)] - **doc**: add missing changelog entry for fs.readdir() (Shubheksha Jalan) [#12312](https://github.com/nodejs/node/pull/12312)
* [[`43a39c6786`](https://github.com/nodejs/node/commit/43a39c6786)] - **doc**: modernize and fix code examples in path.md (Vse Mozhet Byt) [#12296](https://github.com/nodejs/node/pull/12296)
* [[`71b39aefc1`](https://github.com/nodejs/node/commit/71b39aefc1)] - **doc**: update os.uptime() and process.uptime() info (Vse Mozhet Byt) [#12294](https://github.com/nodejs/node/pull/12294)
* [[`089a96f337`](https://github.com/nodejs/node/commit/089a96f337)] - **doc**: add link on logo to README (Roman Reiss) [#12307](https://github.com/nodejs/node/pull/12307)
* [[`75f0855f4c`](https://github.com/nodejs/node/commit/75f0855f4c)] - **doc**: c++ unit test guide lines (Daniel Bevenius) [#11956](https://github.com/nodejs/node/pull/11956)
* [[`b1d3f59c59`](https://github.com/nodejs/node/commit/b1d3f59c59)] - **doc**: fix stylistic issues in api/net.md (Alexey Orlenko) [#11786](https://github.com/nodejs/node/pull/11786)
* [[`e48e00b03a`](https://github.com/nodejs/node/commit/e48e00b03a)] - **doc**: document URLSearchParams constructor (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`84484b7063`](https://github.com/nodejs/node/commit/84484b7063)] - **fs**: fix permanent deoptimizations (Brian White) [#12456](https://github.com/nodejs/node/pull/12456)
* [[`675244af8e`](https://github.com/nodejs/node/commit/675244af8e)] - **gyp**: inherit parent for `*.host` (Johan Bergström) [#6173](https://github.com/nodejs/node/pull/6173)
* [[`cbdf9a90d1`](https://github.com/nodejs/node/commit/cbdf9a90d1)] - **lib**: fix typo in comments in module.js (WORMSS) [#12528](https://github.com/nodejs/node/pull/12528)
* [[`51eafe8f3c`](https://github.com/nodejs/node/commit/51eafe8f3c)] - **meta**: update authors list (Aashil Patel) [#11533](https://github.com/nodejs/node/pull/11533)
* [[`2e3813f730`](https://github.com/nodejs/node/commit/2e3813f730)] - **meta**: move the Code of Conduct to TSC repository (James M Snell) [#12147](https://github.com/nodejs/node/pull/12147)
* [[`4a082889bd`](https://github.com/nodejs/node/commit/4a082889bd)] - **net**: fix permanent deoptimizations (Brian White) [#12456](https://github.com/nodejs/node/pull/12456)
* [[`9db4f19283`](https://github.com/nodejs/node/commit/9db4f19283)] - **net**: require 'dns' only once (Ben Noordhuis) [#12342](https://github.com/nodejs/node/pull/12342)
* [[`94385c6d70`](https://github.com/nodejs/node/commit/94385c6d70)] - **net**: don't normalize twice in Socket#connect() (Ben Noordhuis) [#12342](https://github.com/nodejs/node/pull/12342)
* [[`0e40e6d3e9`](https://github.com/nodejs/node/commit/0e40e6d3e9)] - **net**: don't concatenate strings in debug logging (Ben Noordhuis) [#12342](https://github.com/nodejs/node/pull/12342)
* [[`d0b1be13f9`](https://github.com/nodejs/node/commit/d0b1be13f9)] - **net**: remove unnecessary process.nextTick() (Ben Noordhuis) [#12342](https://github.com/nodejs/node/pull/12342)
* [[`dcc9e1a7d4`](https://github.com/nodejs/node/commit/dcc9e1a7d4)] - **net**: don't create unnecessary closure (Ben Noordhuis) [#12342](https://github.com/nodejs/node/pull/12342)
* [[`e09202b78b`](https://github.com/nodejs/node/commit/e09202b78b)] - **net**: don't create unnecessary closure (Ben Noordhuis) [#12342](https://github.com/nodejs/node/pull/12342)
* [[`8ac387be3e`](https://github.com/nodejs/node/commit/8ac387be3e)] - **net**: refactor onSlaveClose in Server.close (Claudio Rodriguez) [#12334](https://github.com/nodejs/node/pull/12334)
* [[`6998e8026b`](https://github.com/nodejs/node/commit/6998e8026b)] - **os,vm**: fix segfaults and CHECK failure (Tobias Nießen) [#12371](https://github.com/nodejs/node/pull/12371)
* [[`b573f77b28`](https://github.com/nodejs/node/commit/b573f77b28)] - **process**: fix permanent deoptimizations (Brian White) [#12456](https://github.com/nodejs/node/pull/12456)
* [[`cd54208463`](https://github.com/nodejs/node/commit/cd54208463)] - **process**: cast promise rejection reason to string (Cameron Little) [#11640](https://github.com/nodejs/node/pull/11640)
* [[`0cc37c71a1`](https://github.com/nodejs/node/commit/0cc37c71a1)] - **querystring**: move isHexTable to internal (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`1ac331b29f`](https://github.com/nodejs/node/commit/1ac331b29f)] - **readline**: fix permanent deoptimizations (Brian White) [#12456](https://github.com/nodejs/node/pull/12456)
* [[`b09bf51cdf`](https://github.com/nodejs/node/commit/b09bf51cdf)] - **repl**: support hidden history file on Windows (Bartosz Sosnowski) [#12207](https://github.com/nodejs/node/pull/12207)
* [[`da01ff7507`](https://github.com/nodejs/node/commit/da01ff7507)] - **src**: remove invalid comment (cjihrig) [#12645](https://github.com/nodejs/node/pull/12645)
* [[`744ed9477b`](https://github.com/nodejs/node/commit/744ed9477b)] - **src**: expose V8's IsNativeError() in util bindings (cjihrig) [#12546](https://github.com/nodejs/node/pull/12546)
* [[`cfd91446a1`](https://github.com/nodejs/node/commit/cfd91446a1)] - **src**: remove extraneous dot (Myles Borins) [#12626](https://github.com/nodejs/node/pull/12626)
* [[`520f876711`](https://github.com/nodejs/node/commit/520f876711)] - **src**: add fcntl.h include to node.cc (Bartosz Sosnowski) [#12540](https://github.com/nodejs/node/pull/12540)
* [[`08951a1307`](https://github.com/nodejs/node/commit/08951a1307)] - **src**: replace IsConstructCalls with lambda (Daniel Bevenius) [#12533](https://github.com/nodejs/node/pull/12533)
* [[`184941ef0b`](https://github.com/nodejs/node/commit/184941ef0b)] - **src**: remove TODO about uv errno removal (Daniel Bevenius) [#12536](https://github.com/nodejs/node/pull/12536)
* [[`94ddab091b`](https://github.com/nodejs/node/commit/94ddab091b)] - **src**: guard default_inspector_port (Daniel Bevenius) [#12303](https://github.com/nodejs/node/pull/12303)
* [[`513fc62267`](https://github.com/nodejs/node/commit/513fc62267)] - **src**: clean up WHATWG WG parser (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`078316c630`](https://github.com/nodejs/node/commit/078316c630)] - **src**: WHATWG URL C++ parser cleanup (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`72a3cacc95`](https://github.com/nodejs/node/commit/72a3cacc95)] - **src**: remove explicit UTF-8 validity check in url (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`f5a702e763`](https://github.com/nodejs/node/commit/f5a702e763)] - **stream**: Fixes missing 'unpipe' event (Christopher Luke) [#11876](https://github.com/nodejs/node/pull/11876)
* [[`7d0adc6d26`](https://github.com/nodejs/node/commit/7d0adc6d26)] - **stream**: fix permanent deoptimizations (Brian White) [#12456](https://github.com/nodejs/node/pull/12456)
* [[`592db37e2f`](https://github.com/nodejs/node/commit/592db37e2f)] - **test**: move test to sequential for reliability (Rich Trott) [#12704](https://github.com/nodejs/node/pull/12704)
* [[`7af2e7940c`](https://github.com/nodejs/node/commit/7af2e7940c)] - **test**: fix permanent deoptimizations (Brian White) [#12456](https://github.com/nodejs/node/pull/12456)
* [[`9da719ab32`](https://github.com/nodejs/node/commit/9da719ab32)] - **test**: fix test filenames (Brian White) [#12456](https://github.com/nodejs/node/pull/12456)
* [[`d78adccc08`](https://github.com/nodejs/node/commit/d78adccc08)] - **test**: support multiple warnings in checkWarning (Cameron Little) [#11640](https://github.com/nodejs/node/pull/11640)
* [[`819c131f58`](https://github.com/nodejs/node/commit/819c131f58)] - **test**: improve test-tcp-wrap-listen (alohaglenn) [#12599](https://github.com/nodejs/node/pull/12599)
* [[`79dff99428`](https://github.com/nodejs/node/commit/79dff99428)] - **test**: remove eslint comments from test-util.js (cjihrig) [#12669](https://github.com/nodejs/node/pull/12669)
* [[`dd1dced4c1`](https://github.com/nodejs/node/commit/dd1dced4c1)] - **test**: remove eslint comments (cjihrig) [#12669](https://github.com/nodejs/node/pull/12669)
* [[`3e9e6afd8a`](https://github.com/nodejs/node/commit/3e9e6afd8a)] - **test**: use common.mustCall in test-https-strict (weewey) [#12668](https://github.com/nodejs/node/pull/12668)
* [[`75e053be39`](https://github.com/nodejs/node/commit/75e053be39)] - **test**: cleanup test-util-inherits.js (RobotMermaid) [#12602](https://github.com/nodejs/node/pull/12602)
* [[`745dea994e`](https://github.com/nodejs/node/commit/745dea994e)] - **test**: use common.js to check platform (Ruslan Bekenev) [#12629](https://github.com/nodejs/node/pull/12629)
* [[`8e6d4402a0`](https://github.com/nodejs/node/commit/8e6d4402a0)] - **test**: improve test-process-kill-pid (alohaglenn) [#12588](https://github.com/nodejs/node/pull/12588)
* [[`660e58c7eb`](https://github.com/nodejs/node/commit/660e58c7eb)] - **test**: improved type checking with regex (coreybeaumont) [#12591](https://github.com/nodejs/node/pull/12591)
* [[`e36a256c6b`](https://github.com/nodejs/node/commit/e36a256c6b)] - **test**: cleanup test-fs-watch.js (RobotMermaid) [#12595](https://github.com/nodejs/node/pull/12595)
* [[`d15b1c4446`](https://github.com/nodejs/node/commit/d15b1c4446)] - **test**: add mustCall in test-timers-clearImmediate (Zahidul Islam) [#12598](https://github.com/nodejs/node/pull/12598)
* [[`989d344ba9`](https://github.com/nodejs/node/commit/989d344ba9)] - **test**: use block scoped variable names (Neehar Venugopal) [#12544](https://github.com/nodejs/node/pull/12544)
* [[`b82e0769fe`](https://github.com/nodejs/node/commit/b82e0769fe)] - **test**: dynamic port in cluster eaddrinuse (Sebastian Plesciuc) [#12547](https://github.com/nodejs/node/pull/12547)
* [[`8ae5afe2d2`](https://github.com/nodejs/node/commit/8ae5afe2d2)] - **test**: dynamic port in cluster ipc throw (Sebastian Plesciuc) [#12571](https://github.com/nodejs/node/pull/12571)
* [[`80ceb04644`](https://github.com/nodejs/node/commit/80ceb04644)] - **test**: replace assertion error check with regex (thelady) [#12603](https://github.com/nodejs/node/pull/12603)
* [[`2021ea1c12`](https://github.com/nodejs/node/commit/2021ea1c12)] - **test**: refactored context type err message to regex (Muhsin Abdul-Musawwir) [#12596](https://github.com/nodejs/node/pull/12596)
* [[`1a4bf431fc`](https://github.com/nodejs/node/commit/1a4bf431fc)] - **test**: improve test-process-chdir (vperezma) [#12589](https://github.com/nodejs/node/pull/12589)
* [[`14e93f6369`](https://github.com/nodejs/node/commit/14e93f6369)] - **test**: dynamic port in parallel cluster tests (Sebastian Plesciuc) [#12584](https://github.com/nodejs/node/pull/12584)
* [[`d10eb83325`](https://github.com/nodejs/node/commit/d10eb83325)] - **test**: remove flaky designation for test on AIX (Rich Trott) [#12564](https://github.com/nodejs/node/pull/12564)
* [[`f0b5afe721`](https://github.com/nodejs/node/commit/f0b5afe721)] - **test**: dynamic port in cluster worker dgram (Sebastian Plesciuc) [#12487](https://github.com/nodejs/node/pull/12487)
* [[`661ff6dae3`](https://github.com/nodejs/node/commit/661ff6dae3)] - **test**: move test-debugger-repeat-last to sequential (kumarrishav) [#12470](https://github.com/nodejs/node/pull/12470)
* [[`0fb69de277`](https://github.com/nodejs/node/commit/0fb69de277)] - **test**: use duplex streams in duplex stream test (cjihrig) [#12514](https://github.com/nodejs/node/pull/12514)
* [[`f84a5e19b7`](https://github.com/nodejs/node/commit/f84a5e19b7)] - **test**: use JSON.stringify to trigger stack overflow (Yang Guo) [#12481](https://github.com/nodejs/node/pull/12481)
* [[`96b2faa79b`](https://github.com/nodejs/node/commit/96b2faa79b)] - **test**: fix parallel/test-setproctitle.js on alpine (David Cai) [#12413](https://github.com/nodejs/node/pull/12413)
* [[`e3ccc3109c`](https://github.com/nodejs/node/commit/e3ccc3109c)] - **test**: set benchmark-child-process flaky on windows (Rich Trott) [#12561](https://github.com/nodejs/node/pull/12561)
* [[`37261319d6`](https://github.com/nodejs/node/commit/37261319d6)] - **test**: minimize time for child_process benchmark (Rich Trott) [#12518](https://github.com/nodejs/node/pull/12518)
* [[`eac0d70429`](https://github.com/nodejs/node/commit/eac0d70429)] - **test**: console.log removed from test-net-localport (Faiz Halde) [#12483](https://github.com/nodejs/node/pull/12483)
* [[`a213320745`](https://github.com/nodejs/node/commit/a213320745)] - **test**: dynamic port in cluster worker disconnect (Sebastian Plesciuc) [#12457](https://github.com/nodejs/node/pull/12457)
* [[`ddc35282c0`](https://github.com/nodejs/node/commit/ddc35282c0)] - **test**: remove uses of common.PORT in test-tls-client tests (Ahmed Taj elsir) [#12461](https://github.com/nodejs/node/pull/12461)
* [[`f48d06c042`](https://github.com/nodejs/node/commit/f48d06c042)] - **test**: dynamic port in cluster worker send (Sebastian Plesciuc) [#12472](https://github.com/nodejs/node/pull/12472)
* [[`a75fbe024a`](https://github.com/nodejs/node/commit/a75fbe024a)] - **test**: increase coverage for buffer.js (Rich Trott) [#12476](https://github.com/nodejs/node/pull/12476)
* [[`e919941a21`](https://github.com/nodejs/node/commit/e919941a21)] - **test**: add test for child_process benchmark (Joyee Cheung) [#12326](https://github.com/nodejs/node/pull/12326)
* [[`8e3d54aca5`](https://github.com/nodejs/node/commit/8e3d54aca5)] - **test**: complete coverage of lib/child_process.js (cjihrig) [#12367](https://github.com/nodejs/node/pull/12367)
* [[`922c457365`](https://github.com/nodejs/node/commit/922c457365)] - **test**: buffer should always be stringified (Luca Maraschi) [#12355](https://github.com/nodejs/node/pull/12355)
* [[`611c23cca6`](https://github.com/nodejs/node/commit/611c23cca6)] - **test**: use dynamic port in test-cluster-bind-twice (Rich Trott) [#12418](https://github.com/nodejs/node/pull/12418)
* [[`a7e13e012d`](https://github.com/nodejs/node/commit/a7e13e012d)] - **test**: remove common.PORT from test-cluster*.js (Tarun Batra) [#12441](https://github.com/nodejs/node/pull/12441)
* [[`a34cccceaa`](https://github.com/nodejs/node/commit/a34cccceaa)] - **test**: use dynamic port in 3 test-cluster-worker tests (Sebastian Plesciuc) [#12443](https://github.com/nodejs/node/pull/12443)
* [[`320b80b792`](https://github.com/nodejs/node/commit/320b80b792)] - **test**: add --use-bundled-ca to tls-cnnic-whitelist (Daniel Bevenius) [#12394](https://github.com/nodejs/node/pull/12394)
* [[`3c59d87164`](https://github.com/nodejs/node/commit/3c59d87164)] - **test**: add crypto check to crypto-lazy-transform (Daniel Bevenius) [#12424](https://github.com/nodejs/node/pull/12424)
* [[`0f290f2414`](https://github.com/nodejs/node/commit/0f290f2414)] - **test**: enable setuid/setgid test (Rich Trott) [#12403](https://github.com/nodejs/node/pull/12403)
* [[`4a19062294`](https://github.com/nodejs/node/commit/4a19062294)] - **test**: replace \[\].join() with ''.repeat() (Jackson Tian) [#12305](https://github.com/nodejs/node/pull/12305)
* [[`5ed9ed3317`](https://github.com/nodejs/node/commit/5ed9ed3317)] - **test**: remove common.PORT from test-cluster-basic (Rich Trott) [#12377](https://github.com/nodejs/node/pull/12377)
* [[`0661fdf781`](https://github.com/nodejs/node/commit/0661fdf781)] - **test**: add test-benchmark-crypto (Rich Trott) [#12347](https://github.com/nodejs/node/pull/12347)
* [[`092c7239ee`](https://github.com/nodejs/node/commit/092c7239ee)] - **test**: add hasCrypto check to test-debug-usage (Daniel Bevenius) [#12357](https://github.com/nodejs/node/pull/12357)
* [[`aff0cfc2d7`](https://github.com/nodejs/node/commit/aff0cfc2d7)] - **test**: improve punycode coverage to check surrogate pair (Nao YONASHIRO) [#12354](https://github.com/nodejs/node/pull/12354)
* [[`1ab998f25c`](https://github.com/nodejs/node/commit/1ab998f25c)] - **test**: fix allocUnsafe uninitialized buffer check (Karl Cheng) [#12290](https://github.com/nodejs/node/pull/12290)
* [[`fe45a379e4`](https://github.com/nodejs/node/commit/fe45a379e4)] - **test**: add arrow functions to test-util-inspect (Alexey Orlenko) [#11781](https://github.com/nodejs/node/pull/11781)
* [[`9bdf62f7a7`](https://github.com/nodejs/node/commit/9bdf62f7a7)] - **test**: refactor test-util-inspect.js (Alexey Orlenko) [#11779](https://github.com/nodejs/node/pull/11779)
* [[`1adb08ee92`](https://github.com/nodejs/node/commit/1adb08ee92)] - **test**: synchronize WPT url test data (Daijiro Wachi) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`90bba9fd3e`](https://github.com/nodejs/node/commit/90bba9fd3e)] - **test,doc**: document `crashOnUnhandledRejection()` (Anna Henningsen) [#12699](https://github.com/nodejs/node/pull/12699)
* [[`46a7c297d3`](https://github.com/nodejs/node/commit/46a7c297d3)] - **tools**: use no-useless-concat ESLint rule (Vse Mozhet Byt) [#12613](https://github.com/nodejs/node/pull/12613)
* [[`258eeaa519`](https://github.com/nodejs/node/commit/258eeaa519)] - **tools**: enable no-useless-return eslint rule (cjihrig) [#12577](https://github.com/nodejs/node/pull/12577)
* [[`200e899cc4`](https://github.com/nodejs/node/commit/200e899cc4)] - **tools**: add `root: true` in main .eslintrc.yaml (Vse Mozhet Byt) [#12570](https://github.com/nodejs/node/pull/12570)
* [[`13441eb1e1`](https://github.com/nodejs/node/commit/13441eb1e1)] - **tools**: add table parsing capability to the doctool (Roman Reiss) [#9532](https://github.com/nodejs/node/pull/9532)
* [[`3c8e366c2a`](https://github.com/nodejs/node/commit/3c8e366c2a)] - **tools**: update certdata.txt (Ben Noordhuis) [#12402](https://github.com/nodejs/node/pull/12402)
* [[`6003958872`](https://github.com/nodejs/node/commit/6003958872)] - **tools**: add compile_commands.json gyp generator (Ben Noordhuis) [#12450](https://github.com/nodejs/node/pull/12450)
* [[`83a28eeff8`](https://github.com/nodejs/node/commit/83a28eeff8)] - **tools**: update gyp to eb296f6 (Refael Ackermann) [#12450](https://github.com/nodejs/node/pull/12450)
* [[`5ccafa2a33`](https://github.com/nodejs/node/commit/5ccafa2a33)] - **tools**: replace custom ESLint timers rule (Rich Trott) [#12162](https://github.com/nodejs/node/pull/12162)
* [[`60daaaeff2`](https://github.com/nodejs/node/commit/60daaaeff2)] - **url**: always show password for URL instances (Brian White) [#12420](https://github.com/nodejs/node/pull/12420)
* [[`ac52923308`](https://github.com/nodejs/node/commit/ac52923308)] - **url**: update WHATWG URL API to latest spec (Timothy Gu) [#12523](https://github.com/nodejs/node/pull/12523)
* [[`539ffaef83`](https://github.com/nodejs/node/commit/539ffaef83)] - **url**: improve descriptiveness of identifier (Rich Trott) [#12579](https://github.com/nodejs/node/pull/12579)
* [[`dfc801737f`](https://github.com/nodejs/node/commit/dfc801737f)] - **url**: improve WHATWG URL inspection (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`b2a9e60ce1`](https://github.com/nodejs/node/commit/b2a9e60ce1)] - **url**: clean up WHATWG URL origin generation (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`29531d2654`](https://github.com/nodejs/node/commit/29531d2654)] - **url**: disallow invalid IPv4 in IPv6 parser (Daijiro Wachi) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`ffb2ef4ff3`](https://github.com/nodejs/node/commit/ffb2ef4ff3)] - **url**: remove javascript URL special case (Daijiro Wachi) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`5a27f6335d`](https://github.com/nodejs/node/commit/5a27f6335d)] - **url**: trim leading slashes of file URL paths (Daijiro Wachi) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`b50a84a259`](https://github.com/nodejs/node/commit/b50a84a259)] - **url**: avoid instanceof for WHATWG URL (Brian White) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`b9b93f2165`](https://github.com/nodejs/node/commit/b9b93f2165)] - **url**: error when domainTo*() is called w/o argument (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`b8d1a45beb`](https://github.com/nodejs/node/commit/b8d1a45beb)] - **url**: change path parsing for non-special URLs (Daijiro Wachi) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`c7de98a7bf`](https://github.com/nodejs/node/commit/c7de98a7bf)] - **url**: add ToObject method to native URL class (James M Snell) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`4b6097d3bd`](https://github.com/nodejs/node/commit/4b6097d3bd)] - **url**: use a class for WHATWG url\[context\] (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`01b8839495`](https://github.com/nodejs/node/commit/01b8839495)] - **url**: spec-compliant URLSearchParams parser (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`b8ff2c9f37`](https://github.com/nodejs/node/commit/b8ff2c9f37)] - **url**: spec-compliant URLSearchParams serializer (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`d6fe91648a`](https://github.com/nodejs/node/commit/d6fe91648a)] - **url**: prioritize toString when stringifying (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`7c9ca0f3ce`](https://github.com/nodejs/node/commit/7c9ca0f3ce)] - **url**: enforce valid UTF-8 in WHATWG parser (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`b4052e656c`](https://github.com/nodejs/node/commit/b4052e656c)] - **url**: extend URLSearchParams constructor (Timothy Gu) [#12507](https://github.com/nodejs/node/pull/12507)
* [[`e77f1e2177`](https://github.com/nodejs/node/commit/e77f1e2177)] - **v8**: fix stack overflow in recursive method (Ben Noordhuis) [#12460](https://github.com/nodejs/node/pull/12460)
* [[`25b851bdd4`](https://github.com/nodejs/node/commit/25b851bdd4)] - **v8**: fix build errors with g++ 7 (Ben Noordhuis) [#12392](https://github.com/nodejs/node/pull/12392)

<a id="7.9.0"></a>
## 2017-04-11, Version 7.9.0 (Current), @italoacasas

### Notable Changes

* **util**: console is now closer to what is supported in all major browsers (Roman Reiss) [#10308](https://github.com/nodejs/node/pull/10308)

### Commits

* [[`9f73df5910`](https://github.com/nodejs/node/commit/9f73df5910)] - **deps**: cherry-pick 22858cb from V8 upstream (Ali Ijaz Sheikh) [#11998](https://github.com/nodejs/node/pull/11998)
* [[`b997e62692`](https://github.com/nodejs/node/commit/b997e62692)] - **test**: add internal/socket_list tests (DavidCai) [#12109](https://github.com/nodejs/node/pull/12109)
* [[`c11c23b22b`](https://github.com/nodejs/node/commit/c11c23b22b)] - **doc**: make the heading consistent (Sakthipriyan Vairamani (thefourtheye)) [#11569](https://github.com/nodejs/node/pull/11569)
* [[`67d21149a2`](https://github.com/nodejs/node/commit/67d21149a2)] - **crypto**: handle exceptions in hmac/hash.digest (Tobias Nießen) [#12164](https://github.com/nodejs/node/pull/12164)
* [[`3b765f5366`](https://github.com/nodejs/node/commit/3b765f5366)] - **doc**: fix confusing example in process.md (Vse Mozhet Byt) [#12282](https://github.com/nodejs/node/pull/12282)
* [[`37568c093a`](https://github.com/nodejs/node/commit/37568c093a)] - **src**: use std::list for at_exit_functions (Daniel Bevenius) [#12255](https://github.com/nodejs/node/pull/12255)
* [[`2f9e2fcf3e`](https://github.com/nodejs/node/commit/2f9e2fcf3e)] - **doc**: update information on test/known_issues (Jan Krems) [#12262](https://github.com/nodejs/node/pull/12262)
* [[`0f4319a14a`](https://github.com/nodejs/node/commit/0f4319a14a)] - **src**: use std::string for trace enabled_categories (Sam Roberts) [#12242](https://github.com/nodejs/node/pull/12242)
* [[`6826637f11`](https://github.com/nodejs/node/commit/6826637f11)] - **doc**: fix missing argument for dns.resolvePtr() (Uppinder Chugh) [#12256](https://github.com/nodejs/node/pull/12256)
* [[`4a6bb378d4`](https://github.com/nodejs/node/commit/4a6bb378d4)] - **doc**: fix confusing reference in net.md (Vse Mozhet Byt) [#12247](https://github.com/nodejs/node/pull/12247)
* [[`3e8991cc56`](https://github.com/nodejs/node/commit/3e8991cc56)] - **doc**: modernize and fix code examples in modules.md (Vse Mozhet Byt) [#12224](https://github.com/nodejs/node/pull/12224)
* [[`376f5ef1ee`](https://github.com/nodejs/node/commit/376f5ef1ee)] - **doc**: document the performance team (Gibson Fahnestock) [#12213](https://github.com/nodejs/node/pull/12213)
* [[`c0b7c075da`](https://github.com/nodejs/node/commit/c0b7c075da)] - **doc**: add refack to collaborators (Refael Ackermann) [#12277](https://github.com/nodejs/node/pull/12277)
* [[`83f855d505`](https://github.com/nodejs/node/commit/83f855d505)] - **doc**: add aqrln to collaborators (Alexey Orlenko) [#12273](https://github.com/nodejs/node/pull/12273)
* [[`2fb2289177`](https://github.com/nodejs/node/commit/2fb2289177)] - **doc**: add sub domain to host in url (Steven) [#12233](https://github.com/nodejs/node/pull/12233)
* [[`ac200a6122`](https://github.com/nodejs/node/commit/ac200a6122)] - **test**: add a second argument to assert.throws() (dave-k) [#12139](https://github.com/nodejs/node/pull/12139)
* [[`3cdd04b1c0`](https://github.com/nodejs/node/commit/3cdd04b1c0)] - **test**: skip irrelevant test on Windows (Rich Trott) [#12261](https://github.com/nodejs/node/pull/12261)
* [[`d4d6986551`](https://github.com/nodejs/node/commit/d4d6986551)] - **build**: fix path voodoo in icu-generic.gyp (Refael Ackermann) [#11217](https://github.com/nodejs/node/pull/11217)
* [[`a735c16d52`](https://github.com/nodejs/node/commit/a735c16d52)] - **deps**: backport ec1ffe3 from upstream V8 (Daniel Bevenius) [#12061](https://github.com/nodejs/node/pull/12061)
* [[`d641164d09`](https://github.com/nodejs/node/commit/d641164d09)] - **doc**: update pull request template URL layout (Rich Trott) [#12216](https://github.com/nodejs/node/pull/12216)
* [[`6feea08587`](https://github.com/nodejs/node/commit/6feea08587)] - **buffer**: preallocate array with buffer length (alejandro) [#11733](https://github.com/nodejs/node/pull/11733)
* [[`a703bdecc4`](https://github.com/nodejs/node/commit/a703bdecc4)] - **build**: add checks for openssl configure options (Daniel Bevenius) [#12175](https://github.com/nodejs/node/pull/12175)
* [[`b495b6acdf`](https://github.com/nodejs/node/commit/b495b6acdf)] - **build**: make configure print statements consistent (Daniel Bevenius) [#12176](https://github.com/nodejs/node/pull/12176)
* [[`f60b4553f3`](https://github.com/nodejs/node/commit/f60b4553f3)] - **doc**: modernize and fix code examples in https.md (Vse Mozhet Byt) [#12171](https://github.com/nodejs/node/pull/12171)
* [[`74d0266694`](https://github.com/nodejs/node/commit/74d0266694)] - **doc**: fix string interpolation in Stream 'finish' (Vinay Hiremath) [#12221](https://github.com/nodejs/node/pull/12221)
* [[`4b54520a4a`](https://github.com/nodejs/node/commit/4b54520a4a)] - **test**: refactor mkdtemp test and added async (Luca Maraschi) [#12080](https://github.com/nodejs/node/pull/12080)
* [[`8caf6fd58a`](https://github.com/nodejs/node/commit/8caf6fd58a)] - **test**: add Unicode characters regression test (Alexey Orlenko) [#11423](https://github.com/nodejs/node/pull/11423)
* [[`961c89cc61`](https://github.com/nodejs/node/commit/961c89cc61)] - **doc**: add table of contents to README.md (Jason Marsh) [#11635](https://github.com/nodejs/node/pull/11635)
* [[`a11ed6a0b3`](https://github.com/nodejs/node/commit/a11ed6a0b3)] - **test**: more robust check for location of `node.exe` (Refael Ackermann) [#12120](https://github.com/nodejs/node/pull/12120)
* [[`6083e7aa7b`](https://github.com/nodejs/node/commit/6083e7aa7b)] - **benchmark**: avoid TurboFan deopt in arrays bench (Michaël Zasso) [#11894](https://github.com/nodejs/node/pull/11894)
* [[`cf1117bc13`](https://github.com/nodejs/node/commit/cf1117bc13)] - **doc**: fix the timing of setImmediate's execution (Daiki Arai) [#12034](https://github.com/nodejs/node/pull/12034)
* [[`806c4f3c0c`](https://github.com/nodejs/node/commit/806c4f3c0c)] - **doc**: fix fs.read arg type (Daiki Arai) [#12034](https://github.com/nodejs/node/pull/12034)
* [[`c814c7e9ea`](https://github.com/nodejs/node/commit/c814c7e9ea)] - **events**: do not keep arrays with a single listener (Luigi Pinca) [#12043](https://github.com/nodejs/node/pull/12043)
* [[`36617fd5b8`](https://github.com/nodejs/node/commit/36617fd5b8)] - **doc**: add notes to http.get options (Raphael Okon) [#12124](https://github.com/nodejs/node/pull/12124)
* [[`9e6b0a4604`](https://github.com/nodejs/node/commit/9e6b0a4604)] - **test**: performance, remove Popen(shell=True) on Win (Refael Ackermann) [#12138](https://github.com/nodejs/node/pull/12138)
* [[`805ebef8b1`](https://github.com/nodejs/node/commit/805ebef8b1)] - **buffer**: optimize decoding wrapped base64 data (Alexey Orlenko) [#12146](https://github.com/nodejs/node/pull/12146)
* [[`fb34d9c210`](https://github.com/nodejs/node/commit/fb34d9c210)] - **test**: increase querystring coverage (DavidCai) [#12163](https://github.com/nodejs/node/pull/12163)
* [[`d6e9cf7c22`](https://github.com/nodejs/node/commit/d6e9cf7c22)] - **doc**: fix and update examples in http.md (Vse Mozhet Byt) [#12169](https://github.com/nodejs/node/pull/12169)
* [[`f057cc3d84`](https://github.com/nodejs/node/commit/f057cc3d84)] - **benchmark**: replace \[\].join() with ''.repeat() (Vse Mozhet Byt) [#12170](https://github.com/nodejs/node/pull/12170)
* [[`b15dc95848`](https://github.com/nodejs/node/commit/b15dc95848)] - **test**: fix flaky test-child-process-exec-timeout (Santiago Gimeno) [#12159](https://github.com/nodejs/node/pull/12159)
* [[`72a27b3eb5`](https://github.com/nodejs/node/commit/72a27b3eb5)] - **build**: use $(RM) in Makefile for consistency (Gibson Fahnestock) [#12157](https://github.com/nodejs/node/pull/12157)
* [[`3af9101d20`](https://github.com/nodejs/node/commit/3af9101d20)] - **doc, inspector**: note that the host is optional (Gibson Fahnestock) [#12149](https://github.com/nodejs/node/pull/12149)
* [[`b52b3f6710`](https://github.com/nodejs/node/commit/b52b3f6710)] - **test**: reduce buffer size in buffer-creation test (Sakthipriyan Vairamani (thefourtheye)) [#11177](https://github.com/nodejs/node/pull/11177)
* [[`b5283f9d4b`](https://github.com/nodejs/node/commit/b5283f9d4b)] - **doc**: add logo to README (Roman Reiss) [#12148](https://github.com/nodejs/node/pull/12148)
* [[`305f822a36`](https://github.com/nodejs/node/commit/305f822a36)] - **net**: rename internal functions for readability (Joyee Cheung) [#11796](https://github.com/nodejs/node/pull/11796)
* [[`2f88de1ce3`](https://github.com/nodejs/node/commit/2f88de1ce3)] - **vm**: use SetterCallback to set func declarations (AnnaMag) [#12051](https://github.com/nodejs/node/pull/12051)
* [[`ffbcfdfe32`](https://github.com/nodejs/node/commit/ffbcfdfe32)] - **src**: fix base64 decoding (Nikolai Vavilov) [#11995](https://github.com/nodejs/node/pull/11995)
* [[`8823861d9d`](https://github.com/nodejs/node/commit/8823861d9d)] - **tools**: update dotfile whitelist in .gitignore (Michaël Zasso) [#12116](https://github.com/nodejs/node/pull/12116)
* [[`87ca9a6ffe`](https://github.com/nodejs/node/commit/87ca9a6ffe)] - **test**: fix flaky child-process-exec-kill-throws (Rich Trott) [#12111](https://github.com/nodejs/node/pull/12111)
* [[`fdf76d5aa0`](https://github.com/nodejs/node/commit/fdf76d5aa0)] - **tools**: add missing #include "unicode/putil.h" (Steven R. Loomis) [#12078](https://github.com/nodejs/node/pull/12078)
* [[`6130d547a0`](https://github.com/nodejs/node/commit/6130d547a0)] - **deps**: backport 8dde6ac from upstream V8 (Daniel Bevenius) [#12060](https://github.com/nodejs/node/pull/12060)
* [[`1ee38eb874`](https://github.com/nodejs/node/commit/1ee38eb874)] - **(SEMVER-MINOR)** **util**: add %i and %f formatting specifiers (Roman Reiss) [#10308](https://github.com/nodejs/node/pull/10308)
* [[`5ac719d0d2`](https://github.com/nodejs/node/commit/5ac719d0d2)] - **doc**: add deprecations page to docs toc (Michaël Zasso) [#12268](https://github.com/nodejs/node/pull/12268)

<a id="7.8.0"></a>
## 2017-03-28, Version 7.8.0 (Current), @MylesBorins

### Notable Changes

* **buffer**:
  * do not segfault on out-of-range index (Timothy Gu) [#11927](https://github.com/nodejs/node/pull/11927)
* **crypto**:
  * Fix memory leak if certificate is revoked (Tom Atkinson) [#12089](https://github.com/nodejs/node/pull/12089)
* **deps**:
  * upgrade npm to 4.2.0 (Kat Marchán) [#11389](https://github.com/nodejs/node/pull/11389)
  * fix async await desugaring in V8 (Michaël Zasso) [#12004](https://github.com/nodejs/node/pull/12004)
* **readline**:
  * add option to stop duplicates in history (Danny Nemer) [#2982](https://github.com/nodejs/node/pull/2982)

### Commits

* [[`51c8d8088a`](https://github.com/nodejs/node/commit/51c8d8088a)] - Partial revert "tls: keep track of stream that is closed" (Trevor Norris) [#11947](https://github.com/nodejs/node/pull/11947)
* [[`751c1153a4`](https://github.com/nodejs/node/commit/751c1153a4)] - **benchmark**: check end() argument to be \> 0 (Vse Mozhet Byt) [#12030](https://github.com/nodejs/node/pull/12030)
* [[`210250465a`](https://github.com/nodejs/node/commit/210250465a)] - **benchmark**: update obsolete information pointer (Rich Trott) [#12026](https://github.com/nodejs/node/pull/12026)
* [[`7aeeee3276`](https://github.com/nodejs/node/commit/7aeeee3276)] - **benchmark**: repair the fs/readfile benchmark (Sorin Baltateanu) [#7818](https://github.com/nodejs/node/pull/7818)
* [[`90acb773be`](https://github.com/nodejs/node/commit/90acb773be)] - **benchmark**: allow multiple values for same config (Nikolai Vavilov) [#11819](https://github.com/nodejs/node/pull/11819)
* [[`2f4ad6fea2`](https://github.com/nodejs/node/commit/2f4ad6fea2)] - **benchmark**: harmonize progress bar + stderr output (Vse Mozhet Byt) [#11925](https://github.com/nodejs/node/pull/11925)
* [[`d62ddbe145`](https://github.com/nodejs/node/commit/d62ddbe145)] - **benchmark**: fix fs\bench-realpathSync.js (Vse Mozhet Byt) [#11904](https://github.com/nodejs/node/pull/11904)
* [[`85eb1bc0a9`](https://github.com/nodejs/node/commit/85eb1bc0a9)] - **benchmark**: remove v8ForceOptimization calls (Lucas Lago) [#11908](https://github.com/nodejs/node/pull/11908)
* [[`17d16e8f3d`](https://github.com/nodejs/node/commit/17d16e8f3d)] - **buffer**: remove unneeded eslint-disable comment (Rich Trott) [#11906](https://github.com/nodejs/node/pull/11906)
* [[`fb41ee3983`](https://github.com/nodejs/node/commit/fb41ee3983)] - **build**: add lint option to vcbuild.bat help (Morgan Brenner) [#11992](https://github.com/nodejs/node/pull/11992)
* [[`3e4ecca0be`](https://github.com/nodejs/node/commit/3e4ecca0be)] - **build**: don't create directory for NDK toolchain (TheBeastOfCaerbannog) [#11916](https://github.com/nodejs/node/pull/11916)
* [[`a64aa442c1`](https://github.com/nodejs/node/commit/a64aa442c1)] - **crypto**: fix memory leak if certificate is revoked (Tom Atkinson) [#12089](https://github.com/nodejs/node/pull/12089)
* [[`2767e2d3cc`](https://github.com/nodejs/node/commit/2767e2d3cc)] - **(SEMVER-MINOR)** **deps**: upgrade npm to 4.2.0 (Kat Marchán) [#11389](https://github.com/nodejs/node/pull/11389)
* [[`d22346de40`](https://github.com/nodejs/node/commit/d22346de40)] - **deps**: fix async await desugaring in V8 (Michaël Zasso) [#12004](https://github.com/nodejs/node/pull/12004)
* [[`fade55b025`](https://github.com/nodejs/node/commit/fade55b025)] - **doc**: clarify out-of-bounds behavior of buf\[index\] (Nikolai Vavilov) [#11286](https://github.com/nodejs/node/pull/11286)
* [[`63a19c7012`](https://github.com/nodejs/node/commit/63a19c7012)] - **doc**: update and modernize examples in fs.ms (Vse Mozhet Byt) [#12035](https://github.com/nodejs/node/pull/12035)
* [[`4b5f177e3d`](https://github.com/nodejs/node/commit/4b5f177e3d)] - **doc**: fix https.timeout docs (Ahmad Nassri) [#12039](https://github.com/nodejs/node/pull/12039)
* [[`af051f6528`](https://github.com/nodejs/node/commit/af051f6528)] - **doc**: fix http properties documented as methods (Ahmad Nassri) [#12039](https://github.com/nodejs/node/pull/12039)
* [[`18a586a278`](https://github.com/nodejs/node/commit/18a586a278)] - **doc**: edit the benchmark guide (Rich Trott) [#12041](https://github.com/nodejs/node/pull/12041)
* [[`5e3d429613`](https://github.com/nodejs/node/commit/5e3d429613)] - **doc**: stdout/err/in are all Duplex streams (Sebastian Van Sande) [#11194](https://github.com/nodejs/node/pull/11194)
* [[`7f6b03fd0f`](https://github.com/nodejs/node/commit/7f6b03fd0f)] - **doc**: fix process.stdout fd number (Fumiya KARASAWA) [#12055](https://github.com/nodejs/node/pull/12055)
* [[`1f7fe55c97`](https://github.com/nodejs/node/commit/1f7fe55c97)] - **doc**: add richardlau to collaborators (Richard Lau) [#12020](https://github.com/nodejs/node/pull/12020)
* [[`924f34606d`](https://github.com/nodejs/node/commit/924f34606d)] - **doc**: update collaborator email address (Rich Trott) [#11996](https://github.com/nodejs/node/pull/11996)
* [[`41bec5cff4`](https://github.com/nodejs/node/commit/41bec5cff4)] - **doc**: correct info in child_process.md (Vse Mozhet Byt) [#11949](https://github.com/nodejs/node/pull/11949)
* [[`96ad336d9e`](https://github.com/nodejs/node/commit/96ad336d9e)] - **doc**: remove superfluous sample assert code (Rich Trott) [#11933](https://github.com/nodejs/node/pull/11933)
* [[`486bd1bd9b`](https://github.com/nodejs/node/commit/486bd1bd9b)] - **doc**: require uses fs root for '/' prefix (Bradley Farias) [#11897](https://github.com/nodejs/node/pull/11897)
* [[`04fa28e6dc`](https://github.com/nodejs/node/commit/04fa28e6dc)] - **doc**: fix gitter badge in README (Roman Reiss) [#11944](https://github.com/nodejs/node/pull/11944)
* [[`68b23be51f`](https://github.com/nodejs/node/commit/68b23be51f)] - **doc**: add missing word in stream.md (Jyotman Singh) [#11914](https://github.com/nodejs/node/pull/11914)
* [[`0f2642ee36`](https://github.com/nodejs/node/commit/0f2642ee36)] - **errors**: remove needless lazyAssert (DavidCai) [#11891](https://github.com/nodejs/node/pull/11891)
* [[`5bdd54925a`](https://github.com/nodejs/node/commit/5bdd54925a)] - **lib**: add comment to script eval _tickCallback (Gibson Fahnestock) [#12050](https://github.com/nodejs/node/pull/12050)
* [[`7347860966`](https://github.com/nodejs/node/commit/7347860966)] - **lib**: clarify the usage of 'else' (Jackson Tian) [#11148](https://github.com/nodejs/node/pull/11148)
* [[`837ff4ba59`](https://github.com/nodejs/node/commit/837ff4ba59)] - **lib**: remove an unnecessary coverage check (Jeremiah Senkpiel) [#12023](https://github.com/nodejs/node/pull/12023)
* [[`6c803db7b9`](https://github.com/nodejs/node/commit/6c803db7b9)] - **lib**: fix event race condition with -e (Ben Noordhuis) [#11958](https://github.com/nodejs/node/pull/11958)
* [[`ac92d0249b`](https://github.com/nodejs/node/commit/ac92d0249b)] - **net**: refactor net module to module.exports (Claudio Rodriguez) [#11698](https://github.com/nodejs/node/pull/11698)
* [[`2462fd8009`](https://github.com/nodejs/node/commit/2462fd8009)] - **process**: maintain constructor descriptor (Bryan English) [#9306](https://github.com/nodejs/node/pull/9306)
* [[`91a2700721`](https://github.com/nodejs/node/commit/91a2700721)] - **readline**: rename `deDupeHistory` option (Danny Nemer) [#11950](https://github.com/nodejs/node/pull/11950)
* [[`8ab26cf508`](https://github.com/nodejs/node/commit/8ab26cf508)] - **(SEMVER-MINOR)** **readline**: add option to stop duplicates in history (Danny Nemer) [#2982](https://github.com/nodejs/node/pull/2982)
* [[`6a6c431eec`](https://github.com/nodejs/node/commit/6a6c431eec)] - **src**: use persistent strings from node::Environment (Ben Noordhuis) [#11945](https://github.com/nodejs/node/pull/11945)
* [[`d0c2d67083`](https://github.com/nodejs/node/commit/d0c2d67083)] - **src**: add native URL class (James M Snell) [#11801](https://github.com/nodejs/node/pull/11801)
* [[`019a20adb5`](https://github.com/nodejs/node/commit/019a20adb5)] - **src**: make PercentDecode return void (Timothy Gu) [#11922](https://github.com/nodejs/node/pull/11922)
* [[`d6da1705cd`](https://github.com/nodejs/node/commit/d6da1705cd)] - **src**: ensure that fd 0-2 are valid on windows (Bartosz Sosnowski) [#11863](https://github.com/nodejs/node/pull/11863)
* [[`59f71f5661`](https://github.com/nodejs/node/commit/59f71f5661)] - **src, buffer**: do not segfault on out-of-range index (Timothy Gu) [#11927](https://github.com/nodejs/node/pull/11927)
* [[`4051184106`](https://github.com/nodejs/node/commit/4051184106)] - **stream_base,tls_wrap**: notify on destruct (Trevor Norris) [#11947](https://github.com/nodejs/node/pull/11947)
* [[`d8b71be183`](https://github.com/nodejs/node/commit/d8b71be183)] - **test**: fix misleading comment (Franziska Hinkelmann) [#12048](https://github.com/nodejs/node/pull/12048)
* [[`8b2b93f148`](https://github.com/nodejs/node/commit/8b2b93f148)] - **test**: mark child-process-exec-kill-throws flaky (Gibson Fahnestock) [#12054](https://github.com/nodejs/node/pull/12054)
* [[`948b99deab`](https://github.com/nodejs/node/commit/948b99deab)] - **test**: fix broken tests in test-buffer-includes (Alexey Orlenko) [#12040](https://github.com/nodejs/node/pull/12040)
* [[`d112aad78b`](https://github.com/nodejs/node/commit/d112aad78b)] - **test**: replace throw with common.fail (Dejon "DJ" Gill) [#9700](https://github.com/nodejs/node/pull/9700)
* [[`41284fbc5b`](https://github.com/nodejs/node/commit/41284fbc5b)] - **test**: cover thrown errors from exec() kill (cjihrig) [#11038](https://github.com/nodejs/node/pull/11038)
* [[`414df6c93b`](https://github.com/nodejs/node/commit/414df6c93b)] - **test**: test validity of prefix in mkdtempSync (Luca Maraschi) [#12009](https://github.com/nodejs/node/pull/12009)
* [[`1c0435b1f3`](https://github.com/nodejs/node/commit/1c0435b1f3)] - **test**: add regex for expected error message (John F. Mercer) [#12011](https://github.com/nodejs/node/pull/12011)
* [[`a73dea9499`](https://github.com/nodejs/node/commit/a73dea9499)] - **test**: add second argument to assert.throws() (Rj Bernaldo) [#12016](https://github.com/nodejs/node/pull/12016)
* [[`ade64e61cd`](https://github.com/nodejs/node/commit/ade64e61cd)] - **test**: refactor test-cluster-disconnect (Rich Trott) [#11981](https://github.com/nodejs/node/pull/11981)
* [[`3d21bfe6b9`](https://github.com/nodejs/node/commit/3d21bfe6b9)] - **test**: invalid chars in http client path (Luca Maraschi) [#11964](https://github.com/nodejs/node/pull/11964)
* [[`e70ed3cb31`](https://github.com/nodejs/node/commit/e70ed3cb31)] - **test**: improve test-vm-cached-data.js (Nick Peleh) [#11974](https://github.com/nodejs/node/pull/11974)
* [[`b48f13af95`](https://github.com/nodejs/node/commit/b48f13af95)] - **test**: add minimal test for net benchmarks (Rich Trott) [#11979](https://github.com/nodejs/node/pull/11979)
* [[`764a00e6e5`](https://github.com/nodejs/node/commit/764a00e6e5)] - **test**: add test for url (Yuta Hiroto) [#11999](https://github.com/nodejs/node/pull/11999)
* [[`bb2de4a5a1`](https://github.com/nodejs/node/commit/bb2de4a5a1)] - **test**: do not use `more` command on Windows (Vse Mozhet Byt) [#11953](https://github.com/nodejs/node/pull/11953)
* [[`55a112689a`](https://github.com/nodejs/node/commit/55a112689a)] - **test**: add test for child_process.execFile() (Rich Trott) [#11929](https://github.com/nodejs/node/pull/11929)
* [[`9ba551f7e3`](https://github.com/nodejs/node/commit/9ba551f7e3)] - **test**: fix flaky test-tls-socket-close (Rich Trott) [#11921](https://github.com/nodejs/node/pull/11921)
* [[`114f9d619d`](https://github.com/nodejs/node/commit/114f9d619d)] - **test**: add hasCrypto check to tls-socket-close (Daniel Bevenius) [#11911](https://github.com/nodejs/node/pull/11911)
* [[`169f187f16`](https://github.com/nodejs/node/commit/169f187f16)] - **test**: synchronize WPT url setters tests data (Daijiro Wachi) [#11887](https://github.com/nodejs/node/pull/11887)
* [[`4b1b6b85a9`](https://github.com/nodejs/node/commit/4b1b6b85a9)] - **timers**: fix not to close reused timer handle (Shigeki Ohtsu) [#11646](https://github.com/nodejs/node/pull/11646)
* [[`fd93622f8a`](https://github.com/nodejs/node/commit/fd93622f8a)] - **tls**: fix SecurePair external memory reporting (Ben Noordhuis) [#11896](https://github.com/nodejs/node/pull/11896)
* [[`126dcb76af`](https://github.com/nodejs/node/commit/126dcb76af)] - **url**: name anonymous functions in url (Pedro lima) [#9225](https://github.com/nodejs/node/pull/9225)
* [[`f6755182e5`](https://github.com/nodejs/node/commit/f6755182e5)] - **url**: show input in parse error message (Joyee Cheung) [#11934](https://github.com/nodejs/node/pull/11934)
* [[`c51d925c84`](https://github.com/nodejs/node/commit/c51d925c84)] - **url**: restrict setting protocol to "file" (Daijiro Wachi) [#11887](https://github.com/nodejs/node/pull/11887)

<a id="7.7.4"></a>
## 2017-03-21, Version 7.7.4 (Current), @cjihrig

### Notable changes

Thank you to @italoacasas for preparing the majority of this release.

* **deps**: Add node-inspect 1.10.6 (Jan Krems) [#11869](https://github.com/nodejs/node/pull/11869)
* **inspector**: proper WS URLs when bound to 0.0.0.0 (Eugene Ostroukhov) [#11850](https://github.com/nodejs/node/pull/11850)
* **tls**: fix segfault on destroy after partial read. (Ben Noordhuis) [#11898](https://github.com/nodejs/node/pull/11898)

### Commits

* [[`f48763c5b9`](https://github.com/nodejs/node/commit/f48763c5b9)] - **benchmark**: remove benchmarks forced optimizations (Bartosz Sosnowski)
* [[`dcac2d8f04`](https://github.com/nodejs/node/commit/dcac2d8f04)] - **benchmark**: benchmark comparing forEach with for (James M Snell) [#11582](https://github.com/nodejs/node/pull/11582)
* [[`80949f3d88`](https://github.com/nodejs/node/commit/80949f3d88)] - **build**: add cpp linting to windows build (liusi) [#11856](https://github.com/nodejs/node/pull/11856)
* [[`5244ee346b`](https://github.com/nodejs/node/commit/5244ee346b)] - **build**: mac OBJ_DIR should point to obj.target (Daniel Bevenius) [#11857](https://github.com/nodejs/node/pull/11857)
* [[`5b1d61ce09`](https://github.com/nodejs/node/commit/5b1d61ce09)] - **child_process**: fix deoptimizing use of arguments (Vse Mozhet Byt) [#11748](https://github.com/nodejs/node/pull/11748)
* [[`ca319862fd`](https://github.com/nodejs/node/commit/ca319862fd)] - **deps**: cherry-pick ca0f9573 from V8 upstream (Ali Ijaz Sheikh)
* [[`a7e4b029da`](https://github.com/nodejs/node/commit/a7e4b029da)] - **deps**: Add node-inspect 1.10.6 (Jan Krems) [#11869](https://github.com/nodejs/node/pull/11869)
* [[`0c00b655d8`](https://github.com/nodejs/node/commit/0c00b655d8)] - **doc**: Fix #7065: cli help documentation for --inspect (Noj Vek) [#11660](https://github.com/nodejs/node/pull/11660)
* [[`60ad7af65e`](https://github.com/nodejs/node/commit/60ad7af65e)] - **doc**: deprecate debug protocol (Jan Krems) [#10320](https://github.com/nodejs/node/pull/10320)
* [[`a5f7393541`](https://github.com/nodejs/node/commit/a5f7393541)] - **doc**: add vsemozhetbyt to collaborators (Vse Mozhet Byt) [#11932](https://github.com/nodejs/node/pull/11932)
* [[`0c091262bd`](https://github.com/nodejs/node/commit/0c091262bd)] - **doc**: add note that vm module is not a security mechanism (Ruslan Bekenev) [#11557](https://github.com/nodejs/node/pull/11557)
* [[`6d6a65e2ad`](https://github.com/nodejs/node/commit/6d6a65e2ad)] - **doc**: linkable commit message guidelines (Sam Roberts) [#11792](https://github.com/nodejs/node/pull/11792)
* [[`7c7228ed4b`](https://github.com/nodejs/node/commit/7c7228ed4b)] - **doc**: gcc version is at least 4.8.5 in BUILDING.md (detailyang) [#11840](https://github.com/nodejs/node/pull/11840)
* [[`9861ec93d4`](https://github.com/nodejs/node/commit/9861ec93d4)] - **doc**: increase Buffer.concat() documentation (cjihrig) [#11845](https://github.com/nodejs/node/pull/11845)
* [[`54879ab7d1`](https://github.com/nodejs/node/commit/54879ab7d1)] - **doc**: fix mistakes in stream doc (object mode) (Christian d'Heureuse) [#11807](https://github.com/nodejs/node/pull/11807)
* [[`78ca15dd78`](https://github.com/nodejs/node/commit/78ca15dd78)] - **doc**: argument types for dns methods (Amelia Clarke) [#11764](https://github.com/nodejs/node/pull/11764)
* [[`e84e33c87c`](https://github.com/nodejs/node/commit/e84e33c87c)] - **doc**: fix a typo in api/process.md (Gaara) [#11780](https://github.com/nodejs/node/pull/11780)
* [[`75fcf53173`](https://github.com/nodejs/node/commit/75fcf53173)] - **doc**: missing argument types for events methods (Amelia Clarke) [#11802](https://github.com/nodejs/node/pull/11802)
* [[`ae52b63df2`](https://github.com/nodejs/node/commit/ae52b63df2)] - **doc**: correct comment error in stream.md (Alexander) [#11804](https://github.com/nodejs/node/pull/11804)
* [[`e6f113d3d5`](https://github.com/nodejs/node/commit/e6f113d3d5)] - **doc**: console.log() -> console.error() in events.md (Vse Mozhet Byt) [#11810](https://github.com/nodejs/node/pull/11810)
* [[`cde5d71db1`](https://github.com/nodejs/node/commit/cde5d71db1)] - **doc**: var -> let / const in events.md (Vse Mozhet Byt) [#11810](https://github.com/nodejs/node/pull/11810)
* [[`d0fb578d64`](https://github.com/nodejs/node/commit/d0fb578d64)] - **fs**: avoid using forEach (James M Snell) [#11582](https://github.com/nodejs/node/pull/11582)
* [[`14e3ad0c5e`](https://github.com/nodejs/node/commit/14e3ad0c5e)] - **inspector**: proper WS URLs when bound to 0.0.0.0 (Eugene Ostroukhov) [#11850](https://github.com/nodejs/node/pull/11850)
* [[`fbbcd1aa89`](https://github.com/nodejs/node/commit/fbbcd1aa89)] - **lib**: Fix swallowed events in inspect integration (Jan Krems) [#11869](https://github.com/nodejs/node/pull/11869)
* [[`9cc712ca18`](https://github.com/nodejs/node/commit/9cc712ca18)] - **lib**: remove unused msg parameter in debug_agent (mr-spd) [#11833](https://github.com/nodejs/node/pull/11833)
* [[`77c69f7ace`](https://github.com/nodejs/node/commit/77c69f7ace)] - **lib, test**: add duplicate symbol checking in E() (DavidCai) [#11829](https://github.com/nodejs/node/pull/11829)
* [[`7e230727fc`](https://github.com/nodejs/node/commit/7e230727fc)] - **module**: avoid using forEach (James M Snell) [#11582](https://github.com/nodejs/node/pull/11582)
* [[`c0a2e02f51`](https://github.com/nodejs/node/commit/c0a2e02f51)] - **net**: avoid using forEach (James M Snell) [#11582](https://github.com/nodejs/node/pull/11582)
* [[`a0b1aa1161`](https://github.com/nodejs/node/commit/a0b1aa1161)] - **readline**: avoid using forEach (James M Snell) [#11582](https://github.com/nodejs/node/pull/11582)
* [[`e19ca8ba11`](https://github.com/nodejs/node/commit/e19ca8ba11)] - **readline**: remove unneeded eslint-disable comment (Rich Trott) [#11836](https://github.com/nodejs/node/pull/11836)
* [[`62e726109a`](https://github.com/nodejs/node/commit/62e726109a)] - **repl**: avoid using forEach (James M Snell) [#11582](https://github.com/nodejs/node/pull/11582)
* [[`90be5a1f19`](https://github.com/nodejs/node/commit/90be5a1f19)] - **stream**: avoid using forEach (James M Snell) [#11582](https://github.com/nodejs/node/pull/11582)
* [[`2cab00aec0`](https://github.com/nodejs/node/commit/2cab00aec0)] - **test**: fix assertion in vm test (AnnaMag) [#11862](https://github.com/nodejs/node/pull/11862)
* [[`8bda7b8d39`](https://github.com/nodejs/node/commit/8bda7b8d39)] - **test**: add coverage for child_process bounds check (Rich Trott) [#11800](https://github.com/nodejs/node/pull/11800)
* [[`3ae58acd29`](https://github.com/nodejs/node/commit/3ae58acd29)] - **test**: failing behaviour on sandboxed Proxy (AnnaMag) [#11671](https://github.com/nodejs/node/pull/11671)
* [[`560d8eed9a`](https://github.com/nodejs/node/commit/560d8eed9a)] - **test**: delay child exit in AIX for pseudo-tty tests (Gireesh Punathil) [#11715](https://github.com/nodejs/node/pull/11715)
* [[`f9c831f4b1`](https://github.com/nodejs/node/commit/f9c831f4b1)] - **test**: fix flaky test-domain-abort-on-uncaught (Rich Trott) [#11817](https://github.com/nodejs/node/pull/11817)
* [[`2649dab274`](https://github.com/nodejs/node/commit/2649dab274)] - **test**: added test for indexed properties (AnnaMag) [#11769](https://github.com/nodejs/node/pull/11769)
* [[`2df662c95a`](https://github.com/nodejs/node/commit/2df662c95a)] - **test**: test resolveObject with an empty path (Daijiro Wachi) [#11811](https://github.com/nodejs/node/pull/11811)
* [[`d2c9111614`](https://github.com/nodejs/node/commit/d2c9111614)] - **test**: fix repl-function-redefinition-edge-case (Alexey Orlenko) [#11772](https://github.com/nodejs/node/pull/11772)
* [[`c9cf922248`](https://github.com/nodejs/node/commit/c9cf922248)] - **test**: add regex to assert.throws (Matej Krajčovič) [#11815](https://github.com/nodejs/node/pull/11815)
* [[`5f6025ba68`](https://github.com/nodejs/node/commit/5f6025ba68)] - **test**: fail when child dies in fork-net (Joyee Cheung) [#11684](https://github.com/nodejs/node/pull/11684)
* [[`c626734409`](https://github.com/nodejs/node/commit/c626734409)] - **tls**: fix segfault on destroy after partial read (Ben Noordhuis) [#11898](https://github.com/nodejs/node/pull/11898)
* [[`646ee559df`](https://github.com/nodejs/node/commit/646ee559df)] - **tls**: avoid using forEach (James M Snell) [#11582](https://github.com/nodejs/node/pull/11582)
* [[`540830116b`](https://github.com/nodejs/node/commit/540830116b)] - **tls**: keep track of stream that is closed (jBarz) [#11776](https://github.com/nodejs/node/pull/11776)
* [[`9a59913039`](https://github.com/nodejs/node/commit/9a59913039)] - **util**: avoid using forEach (James M Snell) [#11582](https://github.com/nodejs/node/pull/11582)

<a id="7.7.3"></a>
## 2017-03-14, Version 7.7.3 (Current), @italoacasas

### Notable changes

* **module**: The [module loading global fallback](https://nodejs.org/dist/latest-v6.x/docs/api/modules.html#modules_loading_from_the_global_folders) to the Node executable's directory now works correctly on Windows. (Richard Lau) [#9283](https://github.com/nodejs/node/pull/9283)
* **net**: `Socket.prototype.connect` now once again functions without a callback. (Juwan Yoo) [#11762](https://github.com/nodejs/node/pull/11762)
* **url**: `URL.prototype.origin` now properly specified an opaque return of `'null'` for `file://` URLs. (Brian White) [#11691](https://github.com/nodejs/node/pull/11691)

### Commits

* [[`542a3735a7`](https://github.com/nodejs/node/commit/542a3735a7)] - **build**: add node_use_openssl check to install.py (Daniel Bevenius) [#11766](https://github.com/nodejs/node/pull/11766)
* [[`2fcefeeda0`](https://github.com/nodejs/node/commit/2fcefeeda0)] - **dgram**: refactor dgram to module.exports (Claudio Rodriguez) [#11696](https://github.com/nodejs/node/pull/11696)
* [[`dd3e6adaa7`](https://github.com/nodejs/node/commit/dd3e6adaa7)] - **doc**: add missing changelog heading for 7.7.2 (Evan Lucas) [#11823](https://github.com/nodejs/node/pull/11823)
* [[`b543fd441c`](https://github.com/nodejs/node/commit/b543fd441c)] - **doc**: update to current V8 versions (Franziska Hinkelmann) [#11787](https://github.com/nodejs/node/pull/11787)
* [[`6cc7b30c62`](https://github.com/nodejs/node/commit/6cc7b30c62)] - **doc**: improve child_process `maxBuffer` text (Rich Trott) [#11791](https://github.com/nodejs/node/pull/11791)
* [[`188cbc6eea`](https://github.com/nodejs/node/commit/188cbc6eea)] - **doc**: package main can be directory with an index (Bradley Farias) [#11581](https://github.com/nodejs/node/pull/11581)
* [[`a20aa0ee48`](https://github.com/nodejs/node/commit/a20aa0ee48)] - **doc**: http cleanup and missing argument types (Amelia Clarke) [#11681](https://github.com/nodejs/node/pull/11681)
* [[`8a1b2b4417`](https://github.com/nodejs/node/commit/8a1b2b4417)] - **doc**: reduce font size on smaller screens (Gibson Fahnestock) [#11695](https://github.com/nodejs/node/pull/11695)
* [[`5bea8b42d9`](https://github.com/nodejs/node/commit/5bea8b42d9)] - **doc**: fix occurences of "the the" (Jeroen Mandersloot) [#11711](https://github.com/nodejs/node/pull/11711)
* [[`517c3af21a`](https://github.com/nodejs/node/commit/517c3af21a)] - **doc**: fix process links to console.log/error (Sam Roberts) [#11718](https://github.com/nodejs/node/pull/11718)
* [[`108449b6ff`](https://github.com/nodejs/node/commit/108449b6ff)] - **doc**: add Franziska Hinkelmann to the CTC (Rod Vagg) [#11488](https://github.com/nodejs/node/pull/11488)
* [[`9c3cf13cbc`](https://github.com/nodejs/node/commit/9c3cf13cbc)] - **doc**: argument types for https methods (Amelia Clarke) [#11681](https://github.com/nodejs/node/pull/11681)
* [[`103458772a`](https://github.com/nodejs/node/commit/103458772a)] - **module**: fix loading from global folders on Windows (Richard Lau) [#9283](https://github.com/nodejs/node/pull/9283)
* [[`1dff218cd1`](https://github.com/nodejs/node/commit/1dff218cd1)] - **net**: allow missing callback for Socket.connect (Juwan Yoo) [#11762](https://github.com/nodejs/node/pull/11762)
* [[`52f0092f54`](https://github.com/nodejs/node/commit/52f0092f54)] - **s390**: enable march=z196 (Junliang Yan) [#11730](https://github.com/nodejs/node/pull/11730)
* [[`032becdc28`](https://github.com/nodejs/node/commit/032becdc28)] - **src**: add missing #include \<unicode/ustring.h\> (Steven R. Loomis) [#11754](https://github.com/nodejs/node/issues/11754)
* [[`1da2afcc26`](https://github.com/nodejs/node/commit/1da2afcc26)] - **src**: drop the NODE_ISOLATE_SLOT macro (Anna Henningsen) [#11692](https://github.com/nodejs/node/pull/11692)
* [[`734ddbe77b`](https://github.com/nodejs/node/commit/734ddbe77b)] - **test**: fix flaky test-http-set-timeout-server (Santiago Gimeno) [#11790](https://github.com/nodejs/node/pull/11790)
* [[`aaf8536dbc`](https://github.com/nodejs/node/commit/aaf8536dbc)] - **test**: add test for loading from global folders (Richard Lau) [#9283](https://github.com/nodejs/node/pull/9283)
* [[`c01c7a490a`](https://github.com/nodejs/node/commit/c01c7a490a)] - **test**: add script to create 0-dns-cert.pem (Shigeki Ohtsu) [#11579](https://github.com/nodejs/node/pull/11579)
* [[`4477e15217`](https://github.com/nodejs/node/commit/4477e15217)] - **test**: add regex in test_cyclic_link_protection (Clarence Dimitri CHARLES) [#11622](https://github.com/nodejs/node/pull/11622)
* [[`3d55cf06b1`](https://github.com/nodejs/node/commit/3d55cf06b1)] - **test**: add more WHATWG URL origin tests (Brian White) [#11691](https://github.com/nodejs/node/pull/11691)
* [[`a98d963082`](https://github.com/nodejs/node/commit/a98d963082)] - **test**: increase coverage of console (DavidCai) [#11653](https://github.com/nodejs/node/pull/11653)
* [[`1af0fa4b84`](https://github.com/nodejs/node/commit/1af0fa4b84)] - **test**: test buffer behavior when zeroFill undefined (Rich Trott) [#11706](https://github.com/nodejs/node/pull/11706)
* [[`1e52ba3b3d`](https://github.com/nodejs/node/commit/1e52ba3b3d)] - **test**: limit lint rule disabling in message test (Rich Trott) [#11724](https://github.com/nodejs/node/pull/11724)
* [[`5e7baa5a72`](https://github.com/nodejs/node/commit/5e7baa5a72)] - **tools**: add links to the stability index reference (Michael Cox) [#11664](https://github.com/nodejs/node/pull/11664)
* [[`c5874d1bd4`](https://github.com/nodejs/node/commit/c5874d1bd4)] - **url**: remove invalid file protocol check (Brian White) [#11691](https://github.com/nodejs/node/pull/11691)

<a id="7.7.2"></a>
## 2017-03-08, Version 7.7.2 (Current), @evanlucas

### Notable changes

* **doc**: add `Daijiro Wachi` to collaborators (Daijiro Wachi) [#11676](https://github.com/nodejs/node/pull/11676)
* **tty**: add ref() so process.stdin.ref() etc. work (Ben Schmidt) [#7360](https://github.com/nodejs/node/pull/7360)
* **util**: fix inspecting symbol key in string (Ali BARIN) [#11672](https://github.com/nodejs/node/pull/11672)

### Commits

* [[`f56ca30bf0`](https://github.com/nodejs/node/commit/f56ca30bf0)] - **benchmark,build,doc,lib,src,test**: correct typos (Benjamin Fleischer) [#11189](https://github.com/nodejs/node/pull/11189)
* [[`02dbae6b3f`](https://github.com/nodejs/node/commit/02dbae6b3f)] - **buffer**: refactor Buffer.prototype.inspect() (Rich Trott) [#11600](https://github.com/nodejs/node/pull/11600)
* [[`e5b530cb62`](https://github.com/nodejs/node/commit/e5b530cb62)] - **build**: fix llvm version detection in freebsd-10 (Shigeki Ohtsu) [#11668](https://github.com/nodejs/node/pull/11668)
* [[`ed6d7412a7`](https://github.com/nodejs/node/commit/ed6d7412a7)] - **deps**: fix CLEAR_HASH macro to be usable as a single statement (Sam Roberts) [#11616](https://github.com/nodejs/node/pull/11616)
* [[`039a1a97d8`](https://github.com/nodejs/node/commit/039a1a97d8)] - **dns**: minor refactor of dns module (James M Snell) [#11597](https://github.com/nodejs/node/pull/11597)
* [[`3b27b8da9d`](https://github.com/nodejs/node/commit/3b27b8da9d)] - **doc**: fixed readable.isPaused() version annotation (Laurent Fortin) [#11677](https://github.com/nodejs/node/pull/11677)
* [[`84028888db`](https://github.com/nodejs/node/commit/84028888db)] - **doc**: fix broken URL to event loop guide (Poker) [#11670](https://github.com/nodejs/node/pull/11670)
* [[`d5c436311c`](https://github.com/nodejs/node/commit/d5c436311c)] - **doc**: remove Locked from stability index (Rich Trott) [#11661](https://github.com/nodejs/node/pull/11661)
* [[`986d391066`](https://github.com/nodejs/node/commit/986d391066)] - **doc**: unlock module (Rich Trott) [#11661](https://github.com/nodejs/node/pull/11661)
* [[`d06dbf03cc`](https://github.com/nodejs/node/commit/d06dbf03cc)] - **doc**: fix misleading ASCII comments (Rahat Ahmed) [#11657](https://github.com/nodejs/node/pull/11657)
* [[`98d33282d9`](https://github.com/nodejs/node/commit/98d33282d9)] - **doc**: add `Daijiro Wachi` to collaborators (Daijiro Wachi) [#11676](https://github.com/nodejs/node/pull/11676)
* [[`3e79dffd2c`](https://github.com/nodejs/node/commit/3e79dffd2c)] - **doc**: fix WHATWG URL url.protocol example (Richard Lau) [#11647](https://github.com/nodejs/node/pull/11647)
* [[`e468cd3ee7`](https://github.com/nodejs/node/commit/e468cd3ee7)] - **doc**: argument types for console methods (Amelia Clarke) [#11554](https://github.com/nodejs/node/pull/11554)
* [[`83c7b245e2`](https://github.com/nodejs/node/commit/83c7b245e2)] - **doc**: fix typo in stream doc (Bradley Curran) [#11560](https://github.com/nodejs/node/pull/11560)
* [[`a0c117ba95`](https://github.com/nodejs/node/commit/a0c117ba95)] - **doc**: fixup errors.md (Vse Mozhet Byt) [#11566](https://github.com/nodejs/node/pull/11566)
* [[`b116830d64`](https://github.com/nodejs/node/commit/b116830d64)] - **doc**: add link to references in net.Socket (Joyee Cheung) [#11625](https://github.com/nodejs/node/pull/11625)
* [[`b968491dc2`](https://github.com/nodejs/node/commit/b968491dc2)] - **doc**: document WHATWG IDNA methods' error handling (Timothy Gu) [#11549](https://github.com/nodejs/node/pull/11549)
* [[`d329abf1c6`](https://github.com/nodejs/node/commit/d329abf1c6)] - **doc**: use common malformed instead of misformatted (James Sumners) [#11518](https://github.com/nodejs/node/pull/11518)
* [[`11aea2662f`](https://github.com/nodejs/node/commit/11aea2662f)] - **doc**: fix typo in STYLE_GUIDE.md (Nikolai Vavilov) [#11615](https://github.com/nodejs/node/pull/11615)
* [[`f972bd81c6`](https://github.com/nodejs/node/commit/f972bd81c6)] - **inspector**: libuv notification on incoming message (Eugene Ostroukhov) [#11617](https://github.com/nodejs/node/pull/11617)
* [[`a7eba9c71c`](https://github.com/nodejs/node/commit/a7eba9c71c)] - **meta**: move WORKING_GROUPS.md to CTC repo (James M Snell) [#11555](https://github.com/nodejs/node/pull/11555)
* [[`5963566367`](https://github.com/nodejs/node/commit/5963566367)] - **meta**: remove out of date ROADMAP.md file (James M Snell) [#11556](https://github.com/nodejs/node/pull/11556)
* [[`b56e851c48`](https://github.com/nodejs/node/commit/b56e851c48)] - **net**: refactor overloaded argument handling (Joyee Cheung) [#11667](https://github.com/nodejs/node/pull/11667)
* [[`13cb8a69e4`](https://github.com/nodejs/node/commit/13cb8a69e4)] - **net**: remove misleading comment (Ben Noordhuis) [#11573](https://github.com/nodejs/node/pull/11573)
* [[`e2133f3e57`](https://github.com/nodejs/node/commit/e2133f3e57)] - **os**: improve cpus() performance (Brian White) [#11564](https://github.com/nodejs/node/pull/11564)
* [[`821d713a38`](https://github.com/nodejs/node/commit/821d713a38)] - **src**: remove outdated FIXME in node_crypto.cc (Daniel Bevenius) [#11669](https://github.com/nodejs/node/pull/11669)
* [[`1b6ba9effb`](https://github.com/nodejs/node/commit/1b6ba9effb)] - **src**: do not ignore IDNA conversion error (Timothy Gu) [#11549](https://github.com/nodejs/node/pull/11549)
* [[`fdb4a6c796`](https://github.com/nodejs/node/commit/fdb4a6c796)] - **test**: skip the test with proper TAP message (Sakthipriyan Vairamani (thefourtheye)) [#11584](https://github.com/nodejs/node/pull/11584)
* [[`5df9110178`](https://github.com/nodejs/node/commit/5df9110178)] - **test**: check the origin of the blob URLs (Daijiro Wachi) [#11426](https://github.com/nodejs/node/pull/11426)
* [[`b4dcb26681`](https://github.com/nodejs/node/commit/b4dcb26681)] - **test**: changed test1 of test-vm-timeout.js (maurice_hayward) [#11590](https://github.com/nodejs/node/pull/11590)
* [[`f69685be65`](https://github.com/nodejs/node/commit/f69685be65)] - **test**: remove obsolete eslint-disable comment (Rich Trott) [#11643](https://github.com/nodejs/node/pull/11643)
* [[`a4d14363a9`](https://github.com/nodejs/node/commit/a4d14363a9)] - **test**: fix args in parallel/test-fs-null-bytes.js (Vse Mozhet Byt) [#11601](https://github.com/nodejs/node/pull/11601)
* [[`8377374754`](https://github.com/nodejs/node/commit/8377374754)] - **test**: fix tests when npn feature is disabled. (Shigeki Ohtsu) [#11655](https://github.com/nodejs/node/pull/11655)
* [[`1445e282c3`](https://github.com/nodejs/node/commit/1445e282c3)] - **test**: add test-buffer-prototype-inspect (Rich Trott) [#11600](https://github.com/nodejs/node/pull/11600)
* [[`00dd20c173`](https://github.com/nodejs/node/commit/00dd20c173)] - **test**: fix flaky test-https-agent-create-connection (Santiago Gimeno) [#11649](https://github.com/nodejs/node/pull/11649)
* [[`91a222de99`](https://github.com/nodejs/node/commit/91a222de99)] - **test**: enable max-len for test-repl (Rich Trott) [#11559](https://github.com/nodejs/node/pull/11559)
* [[`924b785d50`](https://github.com/nodejs/node/commit/924b785d50)] - **test**: fix test-internal-util-assertCrypto regex (Daniel Bevenius) [#11620](https://github.com/nodejs/node/pull/11620)
* [[`cdee945307`](https://github.com/nodejs/node/commit/cdee945307)] - **test**: improve https coverage to check create connection (chiaki-yokoo) [#11435](https://github.com/nodejs/node/pull/11435)
* [[`4f9253686d`](https://github.com/nodejs/node/commit/4f9253686d)] - **test**: apply strict mode in test-repl (Rich Trott) [#11575](https://github.com/nodejs/node/pull/11575)
* [[`2601c06486`](https://github.com/nodejs/node/commit/2601c06486)] - **test**: skip tests with common.skip (Sakthipriyan Vairamani (thefourtheye)) [#11585](https://github.com/nodejs/node/pull/11585)
* [[`6a5d96164a`](https://github.com/nodejs/node/commit/6a5d96164a)] - **test**: more comprehensive IDNA test cases (Timothy Gu) [#11549](https://github.com/nodejs/node/pull/11549)
* [[`163d2d1624`](https://github.com/nodejs/node/commit/163d2d1624)] - **timers**: unlock the timers API (Rich Trott) [#11580](https://github.com/nodejs/node/pull/11580)
* [[`d6ac192fa3`](https://github.com/nodejs/node/commit/d6ac192fa3)] - **tls**: fix macro to check NPN feature (Shigeki Ohtsu) [#11655](https://github.com/nodejs/node/pull/11655)
* [[`ac3deb1481`](https://github.com/nodejs/node/commit/ac3deb1481)] - **tools**: remove NODE_PATH from environment for tests (Rich Trott) [#11612](https://github.com/nodejs/node/pull/11612)
* [[`3c54f8199c`](https://github.com/nodejs/node/commit/3c54f8199c)] - **tty**: add ref() so process.stdin.ref() etc. work (Ben Schmidt) [#7360](https://github.com/nodejs/node/pull/7360)
* [[`24e6fcce8b`](https://github.com/nodejs/node/commit/24e6fcce8b)] - **url**: use `hasIntl` instead of `try-catch` (Daijiro Wachi) [#11571](https://github.com/nodejs/node/pull/11571)
* [[`7b84363636`](https://github.com/nodejs/node/commit/7b84363636)] - **util**: fix inspecting symbol key in string (Ali BARIN) [#11672](https://github.com/nodejs/node/pull/11672)

<a id="7.7.1"></a>
## 2017-03-01, Version 7.7.1 (Current), @italoacasas

### Notables changes

Node.js 7.7.0 contains a bug that will prevent all native modules from building, this patch should fix the issue. Apologies to everyone who was affected by 7.7.0.

### Commits

* [[`c8e34b61f6`](https://github.com/nodejs/node/commit/c8e34b61f6)] - **build**: add missing src/tracing header files (Daniel Bevenius) [#10851](https://github.com/nodejs/node/pull/10851)
* [[`96f55f9e59`](https://github.com/nodejs/node/commit/96f55f9e59)] - **src**: move trace_event.h include to internal header (Ben Noordhuis) [#10959](https://github.com/nodejs/node/pull/10959)
* [[`30c80cbe6f`](https://github.com/nodejs/node/commit/30c80cbe6f)] - **src**: fix TracingController cleanup (Jason Ginchereau) [#10623](https://github.com/nodejs/node/pull/10623)
* [[`b89b2a7d36`](https://github.com/nodejs/node/commit/b89b2a7d36)] - **src**: always initialize tracing controller in agent (Matt Loring) [#10507](https://github.com/nodejs/node/pull/10507)
* [[`54e55e05ca`](https://github.com/nodejs/node/commit/54e55e05ca)] - **test**: make test-intl-no-icu-data more robust (Michaël Zasso) [#10992](https://github.com/nodejs/node/pull/10992)
* [[`7b253eb3ed`](https://github.com/nodejs/node/commit/7b253eb3ed)] - **test**: increase strictness for test-trace-event (Rich Trott) [#11065](https://github.com/nodejs/node/pull/11065)
* [[`3dc4a5f1f4`](https://github.com/nodejs/node/commit/3dc4a5f1f4)] - **tracing**: fix -Wunused-private-field warning (Santiago Gimeno) [#10416](https://github.com/nodejs/node/pull/10416)
* [[`8a918bf411`](https://github.com/nodejs/node/commit/8a918bf411)] - **tracing**: fix -Wreorder warning (Santiago Gimeno) [#10416](https://github.com/nodejs/node/pull/10416)

<a id="7.7.0"></a>
## 2017-02-28, Version 7.7.0 (Current), @italoacasas

This release contains a deprecation warning for `node --debug`. You can find more information in the
[Diagnostics Working Group Update](https://nodejs.org/en/blog/wg/diag-wg-update-2017-02/)

### Notables changes

* **child_process**: spawnSync() exit code now is null when the child is killed via signal (cjihrig) [#11288](https://github.com/nodejs/node/pull/11288)
* **http**: new functions to access the headers for an outgoing HTTP message (Brian White) [#11562](https://github.com/nodejs/node/pull/11562)
* **lib**: deprecate node --debug at runtime (Josh Gavant) [#11275](https://github.com/nodejs/node/pull/11275)
* **tls**: new tls.TLSSocket() supports sec ctx options (Sam Roberts) [#11005](https://github.com/nodejs/node/pull/11005)
* **url**: adding URL.prototype.toJSON support (Michaël Zasso) [#11236](https://github.com/nodejs/node/pull/11236)
* **doc**: items in the API documentation may now have changelogs (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* **crypto**: adding support for OPENSSL_CONF again (Sam Roberts) [#11006](https://github.com/nodejs/node/pull/11006)
* **src**: adding support for trace-event tracing (misterpoe) [#11106](https://github.com/nodejs/node/pull/11106)

### Commits

* [[`18599fc3d7`](https://github.com/nodejs/node/commit/18599fc3d7)] - doc/url: various improvements to WHATWG API (Timothy Gu)
* [[`e7d37a3f09`](https://github.com/nodejs/node/commit/e7d37a3f09)] - tools/doc: add more intrinsic and custom types (Timothy Gu)
* [[`6bcc841786`](https://github.com/nodejs/node/commit/6bcc841786)] - **assert**: apply minor refactoring (Rich Trott) [#11511](https://github.com/nodejs/node/pull/11511)
* [[`6a2f330dbd`](https://github.com/nodejs/node/commit/6a2f330dbd)] - **assert**: remove unneeded condition (Rich Trott) [#11314](https://github.com/nodejs/node/pull/11314)
* [[`0762482339`](https://github.com/nodejs/node/commit/0762482339)] - **assert**: unlock the assert API (Rich Trott) [#11304](https://github.com/nodejs/node/pull/11304)
* [[`842ac583f6`](https://github.com/nodejs/node/commit/842ac583f6)] - **benchmark**: add url.domainTo*() (Timothy Gu) [#11464](https://github.com/nodejs/node/pull/11464)
* [[`3951bd9ac1`](https://github.com/nodejs/node/commit/3951bd9ac1)] - **benchmark**: strip BOM in dgram/bind-params (Anna Henningsen) [#11479](https://github.com/nodejs/node/pull/11479)
* [[`e1573b9fb7`](https://github.com/nodejs/node/commit/e1573b9fb7)] - **benchmark**: add dgram bind(+/- params) benchmark (Vse Mozhet Byt) [#11313](https://github.com/nodejs/node/pull/11313)
* [[`48f6660d78`](https://github.com/nodejs/node/commit/48f6660d78)] - **benchmark**: fix timer display in progress output (Brian White) [#11235](https://github.com/nodejs/node/pull/11235)
* [[`5a81031fd8`](https://github.com/nodejs/node/commit/5a81031fd8)] - **benchmark**: clean up legacy url benchmarks (Joyee Cheung)
* [[`7e37628c51`](https://github.com/nodejs/node/commit/7e37628c51)] - **benchmark**: add url/url-searchparams-sort.js (Timothy Gu)
* [[`4ffad094ba`](https://github.com/nodejs/node/commit/4ffad094ba)] - **buffer**: refactor slowToString (James M Snell) [#11358](https://github.com/nodejs/node/pull/11358)
* [[`d08a8e68e8`](https://github.com/nodejs/node/commit/d08a8e68e8)] - **buffer**: avoid use of arguments (James M Snell) [#11358](https://github.com/nodejs/node/pull/11358)
* [[`4408437796`](https://github.com/nodejs/node/commit/4408437796)] - **build**: add rule to clean addon tests build (Joyee Cheung) [#11519](https://github.com/nodejs/node/pull/11519)
* [[`8d323bb91a`](https://github.com/nodejs/node/commit/8d323bb91a)] - **build**: fail on CI if leftover processes (Rich Trott) [#11269](https://github.com/nodejs/node/pull/11269)
* [[`d4a8631bd1`](https://github.com/nodejs/node/commit/d4a8631bd1)] - **build**: fix newlines in addon build output (Brian White) [#11466](https://github.com/nodejs/node/pull/11466)
* [[`bc9c381027`](https://github.com/nodejs/node/commit/bc9c381027)] - **build**: add code coverage to make (Wayne Andrews) [#10856](https://github.com/nodejs/node/pull/10856)
* [[`9c45758cdf`](https://github.com/nodejs/node/commit/9c45758cdf)] - **build**: fix building with ninja on linux (Kenan Yildirim) [#11348](https://github.com/nodejs/node/pull/11348)
* [[`86a647899f`](https://github.com/nodejs/node/commit/86a647899f)] - **build**: don't rebuild test/gc add-on unnecessarily (Ben Noordhuis) [#11311](https://github.com/nodejs/node/pull/11311)
* [[`c942e2037c`](https://github.com/nodejs/node/commit/c942e2037c)] - **child_process**: refactor internal/child_process.js (Arseniy Maximov) [#11366](https://github.com/nodejs/node/pull/11366)
* [[`0240eb99a2`](https://github.com/nodejs/node/commit/0240eb99a2)] - **child_process**: remove empty if condition (cjihrig) [#11427](https://github.com/nodejs/node/pull/11427)
* [[`60fc567952`](https://github.com/nodejs/node/commit/60fc567952)] - **child_process**: move anonymous class to top level (Jackson Tian) [#11147](https://github.com/nodejs/node/pull/11147)
* [[`58e2517fc0`](https://github.com/nodejs/node/commit/58e2517fc0)] - **child_process**: exit spawnSync with null on signal (cjihrig) [#11288](https://github.com/nodejs/node/pull/11288)
* [[`4b4bc13758`](https://github.com/nodejs/node/commit/4b4bc13758)] - **cluster**: properly handle --inspect-{brk,port} (Ali Ijaz Sheikh) [#11386](https://github.com/nodejs/node/pull/11386)
* [[`570c5e1da8`](https://github.com/nodejs/node/commit/570c5e1da8)] - **(SEMVER-MINOR)** **crypto**: support OPENSSL_CONF again (Sam Roberts) [#11006](https://github.com/nodejs/node/pull/11006)
* [[`d4000e73ed`](https://github.com/nodejs/node/commit/d4000e73ed)] - **deps**: cherry-pick 7c982e7 from V8 upstream (Jaideep Bajwa) [#11263](https://github.com/nodejs/node/pull/11263)
* [[`bd4ccc892c`](https://github.com/nodejs/node/commit/bd4ccc892c)] - **src**: add tracing controller (misterpoe) [#11106](https://github.com/nodejs/node/pull/11106)
* [[`aef67cfe39`](https://github.com/nodejs/node/commit/aef67cfe39)] - **dgram**: fix possibly deoptimizing use of arguments (Vse Mozhet Byt) [#11242](https://github.com/nodejs/node/pull/11242)
* [[`662b0c31ce`](https://github.com/nodejs/node/commit/662b0c31ce)] - **dns**: avoid use of arguments (James M Snell) [#11359](https://github.com/nodejs/node/pull/11359)
* [[`fedf26b235`](https://github.com/nodejs/node/commit/fedf26b235)] - **doc**: update V8 debugger doc to mention --inspect-brk (James Ide) [#11495](https://github.com/nodejs/node/pull/11495)
* [[`1c7f221ef5`](https://github.com/nodejs/node/commit/1c7f221ef5)] - **doc**: adding deprecations.md (Italo A. Casas) [#11621](https://github.com/nodejs/node/pull/11621)
* [[`90bdf16507`](https://github.com/nodejs/node/commit/90bdf16507)] - **doc**: link to readable and writeable stream section (Sebastian Van Sande) [#11517](https://github.com/nodejs/node/pull/11517)
* [[`3b66ccf0ff`](https://github.com/nodejs/node/commit/3b66ccf0ff)] - **doc**: document clientRequest.aborted (Zach Bjornson) [#11544](https://github.com/nodejs/node/pull/11544)
* [[`128f812157`](https://github.com/nodejs/node/commit/128f812157)] - **doc**: argument types for assert methods (Amelia Clarke) [#11548](https://github.com/nodejs/node/pull/11548)
* [[`b1b6b8b730`](https://github.com/nodejs/node/commit/b1b6b8b730)] - **doc**: add changelogs for buffer (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`597945136e`](https://github.com/nodejs/node/commit/597945136e)] - **doc**: add changelogs for v8 (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`b01fd8ce3a`](https://github.com/nodejs/node/commit/b01fd8ce3a)] - **doc**: fix sorting in API references (Vse Mozhet Byt) [#11529](https://github.com/nodejs/node/pull/11529)
* [[`56cd1932c1`](https://github.com/nodejs/node/commit/56cd1932c1)] - **doc**: note message event listeners ref IPC channels (Diego Rodríguez Baquero) [#11494](https://github.com/nodejs/node/pull/11494)
* [[`47034e12ad`](https://github.com/nodejs/node/commit/47034e12ad)] - **doc**: change broken fg(1) links to fg(1p) (Karan Thakkar) [#11504](https://github.com/nodejs/node/pull/11504)
* [[`47dc5662f3`](https://github.com/nodejs/node/commit/47dc5662f3)] - **doc**: add changelogs for zlib (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`4d122700ab`](https://github.com/nodejs/node/commit/4d122700ab)] - **doc**: add changelogs for vm (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`b868468942`](https://github.com/nodejs/node/commit/b868468942)] - **doc**: add changelogs for util (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`93e7639c12`](https://github.com/nodejs/node/commit/93e7639c12)] - **doc**: add changelogs for url (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`f7d59e5568`](https://github.com/nodejs/node/commit/f7d59e5568)] - **doc**: add changelogs for tls (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`fc53547ed4`](https://github.com/nodejs/node/commit/fc53547ed4)] - **doc**: add changelogs for stream (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`c373e07a09`](https://github.com/nodejs/node/commit/c373e07a09)] - **doc**: add changelogs for repl (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`962d27dbde`](https://github.com/nodejs/node/commit/962d27dbde)] - **doc**: add changelogs for readline (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`7c609dc30a`](https://github.com/nodejs/node/commit/7c609dc30a)] - **doc**: add changelogs for querystring (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`6285ff2275`](https://github.com/nodejs/node/commit/6285ff2275)] - **doc**: add changelogs for punycode (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`df30bc869a`](https://github.com/nodejs/node/commit/df30bc869a)] - **doc**: add changelogs for process (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`c1477b9bd3`](https://github.com/nodejs/node/commit/c1477b9bd3)] - **doc**: add changelogs for path (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`ac10a3b306`](https://github.com/nodejs/node/commit/ac10a3b306)] - **doc**: add changelogs for os (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`3183397c8a`](https://github.com/nodejs/node/commit/3183397c8a)] - **doc**: add changelogs for net (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`6cc8f19e99`](https://github.com/nodejs/node/commit/6cc8f19e99)] - **doc**: add changelogs for http (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`f0cee80de7`](https://github.com/nodejs/node/commit/f0cee80de7)] - **doc**: add changelogs for fs (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`354161d804`](https://github.com/nodejs/node/commit/354161d804)] - **doc**: add changelogs for events (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`4f936014ff`](https://github.com/nodejs/node/commit/4f936014ff)] - **doc**: add changelogs for dns (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`5bc9349d40`](https://github.com/nodejs/node/commit/5bc9349d40)] - **doc**: add changelogs for dgram (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`e23598d09f`](https://github.com/nodejs/node/commit/e23598d09f)] - **doc**: add changelogs for crypto (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`296e22adce`](https://github.com/nodejs/node/commit/296e22adce)] - **doc**: add changelogs for console (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`de83e215cb`](https://github.com/nodejs/node/commit/de83e215cb)] - **doc**: add changelogs for cluster (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`5d4e638e34`](https://github.com/nodejs/node/commit/5d4e638e34)] - **doc**: add changelogs for cli (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`ad1ad4d06d`](https://github.com/nodejs/node/commit/ad1ad4d06d)] - **doc**: add changelogs for child_process (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`42413b611b`](https://github.com/nodejs/node/commit/42413b611b)] - **doc**: add changelogs for assert (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`d3013678fb`](https://github.com/nodejs/node/commit/d3013678fb)] - **doc**: change STYLE-GUIDE to STYLE_GUIDE (Dean Coakley) [#11460](https://github.com/nodejs/node/pull/11460)
* [[`c5ff76dadf`](https://github.com/nodejs/node/commit/c5ff76dadf)] - **doc**: restrict the ES.Next features usage in tests (DavidCai) [#11452](https://github.com/nodejs/node/pull/11452)
* [[`98eb18ba3f`](https://github.com/nodejs/node/commit/98eb18ba3f)] - **doc**: add comment for net.Server's error event (QianJin2013) [#11136](https://github.com/nodejs/node/pull/11136)
* [[`20d86db9bb`](https://github.com/nodejs/node/commit/20d86db9bb)] - **doc**: add version meta for SSL_CERT_DIR/FILE (Sam Roberts) [#11007](https://github.com/nodejs/node/pull/11007)
* [[`66f9506c63`](https://github.com/nodejs/node/commit/66f9506c63)] - **doc**: improve test/README.md (Joyee Cheung) [#11237](https://github.com/nodejs/node/pull/11237)
* [[`5d12fd9a4b`](https://github.com/nodejs/node/commit/5d12fd9a4b)] - **doc**: add benchmark/README.md and fix guide (Joyee Cheung) [#11237](https://github.com/nodejs/node/pull/11237)
* [[`22a6eddc5c`](https://github.com/nodejs/node/commit/22a6eddc5c)] - **doc**: move benchmark/README.md to doc/guides (Joyee Cheung) [#11237](https://github.com/nodejs/node/pull/11237)
* [[`12cf359423`](https://github.com/nodejs/node/commit/12cf359423)] - **doc**: add comment for net.Server.listen IPv6 '::' (QianJin2013) [#11134](https://github.com/nodejs/node/pull/11134)
* [[`83fe819131`](https://github.com/nodejs/node/commit/83fe819131)] - **doc**: add STYLE_GUIDE (moved from nodejs/docs) (Gibson Fahnestock) [#11321](https://github.com/nodejs/node/pull/11321)
* [[`ef1731d972`](https://github.com/nodejs/node/commit/ef1731d972)] - **doc**: add missing function to test common doc (Rich Trott) [#11382](https://github.com/nodejs/node/pull/11382)
* [[`c3c874f514`](https://github.com/nodejs/node/commit/c3c874f514)] - **doc**: dns examples implied string args were arrays (Sam Roberts) [#11350](https://github.com/nodejs/node/pull/11350)
* [[`5f1a568ccc`](https://github.com/nodejs/node/commit/5f1a568ccc)] - **doc**: describe when stdout/err is sync (Sam Roberts) [#10884](https://github.com/nodejs/node/pull/10884)
* [[`5a2db15736`](https://github.com/nodejs/node/commit/5a2db15736)] - **doc**: add documentation for url.format(URL\[, options\]); (James M Snell)
* [[`4d7c9427c1`](https://github.com/nodejs/node/commit/4d7c9427c1)] - **doc**: synchronize + update _toc.md and all.md (Vse Mozhet Byt) [#11206](https://github.com/nodejs/node/pull/11206)
* [[`6a45265e81`](https://github.com/nodejs/node/commit/6a45265e81)] - **doc**: update code examples in domain.md (Vse Mozhet Byt) [#11110](https://github.com/nodejs/node/pull/11110)
* [[`89b66dc636`](https://github.com/nodejs/node/commit/89b66dc636)] - **doc,test**: args to `buffer.copy` can be Uint8Arrays (Anna Henningsen) [#11486](https://github.com/nodejs/node/pull/11486)
* [[`4f6a3d38c3`](https://github.com/nodejs/node/commit/4f6a3d38c3)] - **domain,events**: support non-object 'error' argument (Ben Noordhuis) [#11438](https://github.com/nodejs/node/pull/11438)
* [[`214a39294a`](https://github.com/nodejs/node/commit/214a39294a)] - **(SEMVER-MINOR)** **errors**: add internal/errors.js (James M Snell) [#11220](https://github.com/nodejs/node/pull/11220)
* [[`758126301e`](https://github.com/nodejs/node/commit/758126301e)] - **fs**: improve performance for sync stat() functions (Brian White) [#11522](https://github.com/nodejs/node/pull/11522)
* [[`3e8d43d165`](https://github.com/nodejs/node/commit/3e8d43d165)] - **http**: add new functions to OutgoingMessage (Brian White) [#11562](https://github.com/nodejs/node/pull/11562)
* [[`614742b67f`](https://github.com/nodejs/node/commit/614742b67f)] - **(SEMVER-MINOR)** **lib**: deprecate node --debug at runtime (Josh Gavant) [#11275](https://github.com/nodejs/node/pull/11275)
* [[`a710167c79`](https://github.com/nodejs/node/commit/a710167c79)] - **lib**: rename kMaxCallbacksUntilQueueIsShortened (JungMinu) [#11473](https://github.com/nodejs/node/pull/11473)
* [[`61e1af2155`](https://github.com/nodejs/node/commit/61e1af2155)] - **lib**: remove unnecessary assignments with _extend (Sakthipriyan Vairamani (thefourtheye)) [#11364](https://github.com/nodejs/node/pull/11364)
* [[`d1549bf8d9`](https://github.com/nodejs/node/commit/d1549bf8d9)] - **lib**: add constant kMaxCallbacksUntilQueueIsShortened (Daniel Bevenius) [#11199](https://github.com/nodejs/node/pull/11199)
* [[`3afe90dc9b`](https://github.com/nodejs/node/commit/3afe90dc9b)] - **net**: prefer === to == (Arseniy Maximov) [#11513](https://github.com/nodejs/node/pull/11513)
* [[`db06c7311b`](https://github.com/nodejs/node/commit/db06c7311b)] - **os**: improve loadavg() performance (Brian White) [#11516](https://github.com/nodejs/node/pull/11516)
* [[`fe7a722468`](https://github.com/nodejs/node/commit/fe7a722468)] - **process**: fix typo in comments (levsthings) [#11503](https://github.com/nodejs/node/pull/11503)
* [[`54e1f0c219`](https://github.com/nodejs/node/commit/54e1f0c219)] - **process**: improve memoryUsage() performance (Brian White) [#11497](https://github.com/nodejs/node/pull/11497)
* [[`fb85f5049e`](https://github.com/nodejs/node/commit/fb85f5049e)] - **src**: clean up MaybeStackBuffer (Timothy Gu) [#11464](https://github.com/nodejs/node/pull/11464)
* [[`beda32675f`](https://github.com/nodejs/node/commit/beda32675f)] - **src**: don't assume v8::Local is using-declared (Timothy Gu) [#11464](https://github.com/nodejs/node/pull/11464)
* [[`64a92565e0`](https://github.com/nodejs/node/commit/64a92565e0)] - **src**: update http-parser link (Daniel Bevenius) [#11477](https://github.com/nodejs/node/pull/11477)
* [[`539e83a820`](https://github.com/nodejs/node/commit/539e83a820)] - **src**: remove usage of deprecated debug API (Yang Guo) [#11437](https://github.com/nodejs/node/pull/11437)
* [[`8be6702539`](https://github.com/nodejs/node/commit/8be6702539)] - **(SEMVER-MINOR)** **src**: add SafeGetenv() to internal API (Sam Roberts) [#11006](https://github.com/nodejs/node/pull/11006)
* [[`7d47f27049`](https://github.com/nodejs/node/commit/7d47f27049)] - **src**: remove unused variable in node_crypto (cjihrig) [#11361](https://github.com/nodejs/node/pull/11361)
* [[`8a5c0fb0ff`](https://github.com/nodejs/node/commit/8a5c0fb0ff)] - **src**: remove unused typedef (Ben Noordhuis) [#11322](https://github.com/nodejs/node/pull/11322)
* [[`39b00349b8`](https://github.com/nodejs/node/commit/39b00349b8)] - **src, i18n**: cleanup usage of MaybeStackBuffer (Timothy Gu) [#11464](https://github.com/nodejs/node/pull/11464)
* [[`d0483ee47b`](https://github.com/nodejs/node/commit/d0483ee47b)] - **test**: change common.expectsError() signature (Rich Trott) [#11512](https://github.com/nodejs/node/pull/11512)
* [[`f193c6f996`](https://github.com/nodejs/node/commit/f193c6f996)] - **test**: favor assertions over console logging (Rich Trott) [#11547](https://github.com/nodejs/node/pull/11547)
* [[`4b05ec3b95`](https://github.com/nodejs/node/commit/4b05ec3b95)] - **test**: run test-setproctitle where supported (Howard Hellyer) [#11416](https://github.com/nodejs/node/pull/11416)
* [[`ff854834b6`](https://github.com/nodejs/node/commit/ff854834b6)] - **test**: fix flaky test-vm-timeout-rethrow (Kunal Pathak) [#11530](https://github.com/nodejs/node/pull/11530)
* [[`d7fd694cee`](https://github.com/nodejs/node/commit/d7fd694cee)] - **test**: remove redundant additional url tests (Joyee Cheung) [#11439](https://github.com/nodejs/node/pull/11439)
* [[`e92ddd46bb`](https://github.com/nodejs/node/commit/e92ddd46bb)] - **test**: synchronize WPT url test data (Joyee Cheung) [#11439](https://github.com/nodejs/node/pull/11439)
* [[`4109e0edc4`](https://github.com/nodejs/node/commit/4109e0edc4)] - **test**: remove WHATWG URL test data file extension (Joyee Cheung) [#11439](https://github.com/nodejs/node/pull/11439)
* [[`ecb3a7e933`](https://github.com/nodejs/node/commit/ecb3a7e933)] - **(SEMVER-MINOR)** **test**: make tls-socket-default-options tests run (Sam Roberts) [#11005](https://github.com/nodejs/node/pull/11005)
* [[`f5b4849208`](https://github.com/nodejs/node/commit/f5b4849208)] - **test**: test bottom-up merge sort in URLSearchParams (Daijiro Wachi) [#11399](https://github.com/nodejs/node/pull/11399)
* [[`ff927b2cf8`](https://github.com/nodejs/node/commit/ff927b2cf8)] - **test**: add cases for unescape & unescapeBuffer (Daijiro Wachi) [#11326](https://github.com/nodejs/node/pull/11326)
* [[`ea29d4852a`](https://github.com/nodejs/node/commit/ea29d4852a)] - **test**: use expectsError in test-debug-agent.js (Arseniy Maximov) [#11410](https://github.com/nodejs/node/pull/11410)
* [[`8e455a9093`](https://github.com/nodejs/node/commit/8e455a9093)] - **test**: add test for URLSearchParams inspection (Daijiro Wachi) [#11428](https://github.com/nodejs/node/pull/11428)
* [[`ae9b891a39`](https://github.com/nodejs/node/commit/ae9b891a39)] - **test**: use expectsError in require-invalid-package (Rich Trott) [#11409](https://github.com/nodejs/node/pull/11409)
* [[`91fac08c3b`](https://github.com/nodejs/node/commit/91fac08c3b)] - **test**: use common.expectsError() (Rich Trott) [#11408](https://github.com/nodejs/node/pull/11408)
* [[`46084e3270`](https://github.com/nodejs/node/commit/46084e3270)] - **test**: refactor common.expectsError() (Rich Trott) [#11381](https://github.com/nodejs/node/pull/11381)
* [[`8fdb6c24f9`](https://github.com/nodejs/node/commit/8fdb6c24f9)] - **test**: throw check in test-zlib-write-after-close (Jason Wilson) [#11482](https://github.com/nodejs/node/pull/11482)
* [[`b395ed9407`](https://github.com/nodejs/node/commit/b395ed9407)] - **test**: increase coverage of vm (DavidCai) [#11377](https://github.com/nodejs/node/pull/11377)
* [[`000b2a14c1`](https://github.com/nodejs/node/commit/000b2a14c1)] - **test**: add support for --gtest_filter (Daniel Bevenius) [#11474](https://github.com/nodejs/node/pull/11474)
* [[`34220b75e2`](https://github.com/nodejs/node/commit/34220b75e2)] - **test**: add regex check to test-module-loading (Tarang Hirani) [#11413](https://github.com/nodejs/node/pull/11413)
* [[`4509d84095`](https://github.com/nodejs/node/commit/4509d84095)] - **test**: improve coverage in test-crypto.dh (Eric Christie) [#11253](https://github.com/nodejs/node/pull/11253)
* [[`da10e2649d`](https://github.com/nodejs/node/commit/da10e2649d)] - **test**: add error checking in callback (Rich Trott) [#11446](https://github.com/nodejs/node/pull/11446)
* [[`7b8087630f`](https://github.com/nodejs/node/commit/7b8087630f)] - **test**: refactor test-http-response-splitting (Arseniy Maximov) [#11429](https://github.com/nodejs/node/pull/11429)
* [[`c37e2b7690`](https://github.com/nodejs/node/commit/c37e2b7690)] - **test**: add test cases for path (Yuta Hiroto) [#11453](https://github.com/nodejs/node/pull/11453)
* [[`a523482cca`](https://github.com/nodejs/node/commit/a523482cca)] - **test**: enhance test-common.js (Rich Trott) [#11433](https://github.com/nodejs/node/pull/11433)
* [[`1d86a9f5eb`](https://github.com/nodejs/node/commit/1d86a9f5eb)] - **test**: fix over-dependence on native promise impl (Ali Ijaz Sheikh) [#11437](https://github.com/nodejs/node/pull/11437)
* [[`b457f38e68`](https://github.com/nodejs/node/commit/b457f38e68)] - **test**: add coverage for utf8CheckIncomplete() (xiaoyu) [#11419](https://github.com/nodejs/node/pull/11419)
* [[`ca1bae6f3e`](https://github.com/nodejs/node/commit/ca1bae6f3e)] - **test**: remove unused args and comparison fix (Alexander) [#11396](https://github.com/nodejs/node/pull/11396)
* [[`8ee236f85a`](https://github.com/nodejs/node/commit/8ee236f85a)] - **test**: improve crypto coverage (樋口　彰) [#11279](https://github.com/nodejs/node/pull/11279)
* [[`add762550c`](https://github.com/nodejs/node/commit/add762550c)] - **test**: consolidate buffer.read() in a file (larissayvette) [#11297](https://github.com/nodejs/node/pull/11297)
* [[`e416967244`](https://github.com/nodejs/node/commit/e416967244)] - **test**: cases to querystring related to empty string (Daijiro Wachi) [#11329](https://github.com/nodejs/node/pull/11329)
* [[`5723087cdd`](https://github.com/nodejs/node/commit/5723087cdd)] - **test**: refactor test-dgram-membership (Rich Trott) [#11388](https://github.com/nodejs/node/pull/11388)
* [[`aea0d501d7`](https://github.com/nodejs/node/commit/aea0d501d7)] - **test**: improve message in net-connect-local-error (Rich Trott) [#11393](https://github.com/nodejs/node/pull/11393)
* [[`82882f4e90`](https://github.com/nodejs/node/commit/82882f4e90)] - **test**: cover dgram socket close during bind case (cjihrig) [#11383](https://github.com/nodejs/node/pull/11383)
* [[`f495389d67`](https://github.com/nodejs/node/commit/f495389d67)] - **test**: refactor test-tls-cert-chains-in-ca (Rich Trott) [#11367](https://github.com/nodejs/node/pull/11367)
* [[`348f2ef59f`](https://github.com/nodejs/node/commit/348f2ef59f)] - **test**: improve crypto coverage (Akito Ito) [#11280](https://github.com/nodejs/node/pull/11280)
* [[`e7978f04a4`](https://github.com/nodejs/node/commit/e7978f04a4)] - **test**: cover dgram socket close during cluster bind (cjihrig) [#11292](https://github.com/nodejs/node/pull/11292)
* [[`66081d1ddb`](https://github.com/nodejs/node/commit/66081d1ddb)] - **test**: increase coverage of buffer (DavidCai) [#11312](https://github.com/nodejs/node/pull/11312)
* [[`7aaa960f4c`](https://github.com/nodejs/node/commit/7aaa960f4c)] - **test, url**: synchronize WPT url tests (Joyee Cheung)
* [[`506a1cb03f`](https://github.com/nodejs/node/commit/506a1cb03f)] - **timer,domain**: maintain order of timer callbacks (John Barboza) [#10522](https://github.com/nodejs/node/pull/10522)
* [[`4e327708a9`](https://github.com/nodejs/node/commit/4e327708a9)] - **(SEMVER-MINOR)** **tls**: new tls.TLSSocket() supports sec ctx options (Sam Roberts) [#11005](https://github.com/nodejs/node/pull/11005)
* [[`f37ab7968e`](https://github.com/nodejs/node/commit/f37ab7968e)] - **tls**: do not crash on STARTTLS when OCSP requested (Fedor Indutny) [#10706](https://github.com/nodejs/node/pull/10706)
* [[`5f94ff6231`](https://github.com/nodejs/node/commit/5f94ff6231)] - **tls**: avoid potentially deoptimizing use of arguments (James M Snell) [#11357](https://github.com/nodejs/node/pull/11357)
* [[`0934a27c75`](https://github.com/nodejs/node/commit/0934a27c75)] - **tools**: enable unicode-bom ESLint rule (Anna Henningsen) [#11479](https://github.com/nodejs/node/pull/11479)
* [[`eea2eb9111`](https://github.com/nodejs/node/commit/eea2eb9111)] - **tools**: enable one-var-declaration-per-line ESLint rule (Michaël Zasso) [#11462](https://github.com/nodejs/node/pull/11462)
* [[`5b5dca9076`](https://github.com/nodejs/node/commit/5b5dca9076)] - **tools**: suggest python2 command in configure (Roman Reiss) [#11375](https://github.com/nodejs/node/pull/11375)
* [[`d9d541d564`](https://github.com/nodejs/node/commit/d9d541d564)] - **tools,doc**: enable changelogs for items (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`4ee9220565`](https://github.com/nodejs/node/commit/4ee9220565)] - **tty**: avoid oob warning in TTYWrap::GetWindowSize() (Dmitry Tsvettsikh) [#11454](https://github.com/nodejs/node/pull/11454)
* [[`5f10827248`](https://github.com/nodejs/node/commit/5f10827248)] - **url**: fix handling of ? in URLSearchParams creation (Timothy Gu) [#11372](https://github.com/nodejs/node/pull/11372)
* [[`72da362d6e`](https://github.com/nodejs/node/commit/72da362d6e)] - **url**: fix file state clarification in binding (Daijiro Wachi) [#11123](https://github.com/nodejs/node/pull/11123)
* [[`4366ab539f`](https://github.com/nodejs/node/commit/4366ab539f)] - **url**: implement URL.prototype.toJSON (Michaël Zasso) [#11236](https://github.com/nodejs/node/pull/11236)
* [[`8dbd562590`](https://github.com/nodejs/node/commit/8dbd562590)] - **url**: fix surrogate handling in encodeAuth() (Timothy Gu)
* [[`c25c16cc1b`](https://github.com/nodejs/node/commit/c25c16cc1b)] - **url**: add urlSearchParams.sort() (Timothy Gu)
* [[`d8cb65aa6e`](https://github.com/nodejs/node/commit/d8cb65aa6e)] - **url, test**: synchronize WPT url tests for file URL (Daijiro Wachi) [#11123](https://github.com/nodejs/node/pull/11123)
* [[`237db9c497`](https://github.com/nodejs/node/commit/237db9c497)] - **util**: cleanup internalUtil.deprecate (James M Snell) [#11450](https://github.com/nodejs/node/pull/11450)
* [[`95bee8f202`](https://github.com/nodejs/node/commit/95bee8f202)] - **util**: eliminate unnecessary exports (James M Snell) [#11451](https://github.com/nodejs/node/pull/11451)
* [[`3bdac54e67`](https://github.com/nodejs/node/commit/3bdac54e67)] - **util**: use ES2015+ Object.is to check negative zero (Shinnosuke Watanabe) [#11332](https://github.com/nodejs/node/pull/11332)
* [[`3d133ebd3d`](https://github.com/nodejs/node/commit/3d133ebd3d)] - **util, debugger**: remove internalUtil.error (James M Snell) [#11448](https://github.com/nodejs/node/pull/11448)
* [[`f55c628b2a`](https://github.com/nodejs/node/commit/f55c628b2a)] - **vm**: refactor vm module (James M Snell) [#11392](https://github.com/nodejs/node/pull/11392)

<a id="7.6.0"></a>
## 2017-02-21, Version 7.6.0 (Current), @italoacasas

Thank you to @addaleax for helping in the release proposal.

This release contains **v8 5.5**, you can read more about this version in the official [blog post](https://v8project.blogspot.com/2016/10/v8-release-55.html)

### Notable changes

* **deps**:
  * update V8 to 5.5 (Michaël Zasso) [#11029](https://github.com/nodejs/node/pull/11029)
  * upgrade libuv to 1.11.0 (cjihrig) [#11094](https://github.com/nodejs/node/pull/11094)
  * add node-inspect 1.10.4 (Jan Krems) [#10187](https://github.com/nodejs/node/pull/10187)
  * upgrade zlib to 1.2.11 (Sam Roberts) [#10980](https://github.com/nodejs/node/pull/10980)
* **lib**: build `node inspect` into `node` (Anna Henningsen) [#10187](https://github.com/nodejs/node/pull/10187)
* **crypto**: Remove expired certs from CNNIC whitelist (Shigeki Ohtsu) [#9469](https://github.com/nodejs/node/pull/9469)
* **inspector**: add --inspect-brk (Josh Gavant) [#11149](https://github.com/nodejs/node/pull/11149)
* **fs**: allow WHATWG URL objects as paths (James M Snell) [#10739](https://github.com/nodejs/node/pull/10739)
* **src**: support UTF-8 in compiled-in JS source files (Ben Noordhuis) [#11129](https://github.com/nodejs/node/pull/11129)
* **url**: extend url.format to support WHATWG URL (James M Snell) [#10857](https://github.com/nodejs/node/pull/10857)

### Commits

* [[`5059b6fcee`](https://github.com/nodejs/node/commit/5059b6fcee)] - **benchmark**: fix typos (Nikolai Vavilov) [#11287](https://github.com/nodejs/node/pull/11287)
* [[`b4f3a300de`](https://github.com/nodejs/node/commit/b4f3a300de)] - **benchmark**: URLSearchParams v.s. querystring (Joyee Cheung) [#11170](https://github.com/nodejs/node/pull/11170)
* [[`6d2797bd80`](https://github.com/nodejs/node/commit/6d2797bd80)] - **benchmark**: fix first call to URL in useWHATWG (Joyee Cheung) [#11170](https://github.com/nodejs/node/pull/11170)
* [[`8f34181b95`](https://github.com/nodejs/node/commit/8f34181b95)] - **benchmark**: add assert.deep\[Strict\]Equal benchmarks (Joyee Cheung) [#11092](https://github.com/nodejs/node/pull/11092)
* [[`94555c949a`](https://github.com/nodejs/node/commit/94555c949a)] - **benchmark**: simplify URLSearchParams import (Timothy Gu) [#11111](https://github.com/nodejs/node/pull/11111)
* [[`599c947276`](https://github.com/nodejs/node/commit/599c947276)] - **benchmarks**: add spread operator benchmark (James M Snell) [#11227](https://github.com/nodejs/node/pull/11227)
* [[`8fdfa08ed0`](https://github.com/nodejs/node/commit/8fdfa08ed0)] - **(SEMVER-MINOR)** **build**: add node-inspect integration test (Jan Krems) [#10187](https://github.com/nodejs/node/pull/10187)
* [[`67d4dc061c`](https://github.com/nodejs/node/commit/67d4dc061c)] - **build**: clear stalled jobs on POSIX CI hosts (Rich Trott) [#11246](https://github.com/nodejs/node/pull/11246)
* [[`ae39dcbffb`](https://github.com/nodejs/node/commit/ae39dcbffb)] - **build**: disable C4267 conversion compiler warning (Ben Noordhuis) [#11205](https://github.com/nodejs/node/pull/11205)
* [[`92ed2b5001`](https://github.com/nodejs/node/commit/92ed2b5001)] - **(SEMVER-MINOR)** **build**: support for mips64el (nanxiongchao) [#10991](https://github.com/nodejs/node/pull/10991)
* [[`1dc438fd8b`](https://github.com/nodejs/node/commit/1dc438fd8b)] - **crypto**: remove unused access of tlsext_hostname (David Benjamin) [#10882](https://github.com/nodejs/node/pull/10882)
* [[`7af03ba3f6`](https://github.com/nodejs/node/commit/7af03ba3f6)] - **crypto**: Remove expired certs from CNNIC whitelist (Shigeki Ohtsu) [#9469](https://github.com/nodejs/node/pull/9469)
* [[`5e98e34648`](https://github.com/nodejs/node/commit/5e98e34648)] - **crypto**: add cert check issued by StartCom/WoSign (Shigeki Ohtsu) [#9469](https://github.com/nodejs/node/pull/9469)
* [[`af0154535c`](https://github.com/nodejs/node/commit/af0154535c)] - **deps**: upgrade zlib to 1.2.11 (Sam Roberts) [#10980](https://github.com/nodejs/node/pull/10980)
* [[`85f54908bf`](https://github.com/nodejs/node/commit/85f54908bf)] - **(SEMVER-MINOR)** **deps**: add node-inspect 1.10.2 (Jan Krems) [#10187](https://github.com/nodejs/node/pull/10187)
* [[`445794e0c9`](https://github.com/nodejs/node/commit/445794e0c9)] - **deps**: upgrade libuv to 1.11.0 (cjihrig) [#11094](https://github.com/nodejs/node/pull/11094)
* [[`20127e0c0a`](https://github.com/nodejs/node/commit/20127e0c0a)] - **deps**: back-port b049d1a from V8 upstream (Ben Noordhuis) [#11204](https://github.com/nodejs/node/pull/11204)
* [[`5446fa7e8c`](https://github.com/nodejs/node/commit/5446fa7e8c)] - **(SEMVER-MINOR)** **deps**: work around SmartOS 14 incompatibility (Michaël Zasso) [#11029](https://github.com/nodejs/node/pull/11029)
* [[`028bb632b2`](https://github.com/nodejs/node/commit/028bb632b2)] - **(SEMVER-MINOR)** **deps**: revert breaking UTF-8 decoder changes in V8 (Michaël Zasso) [#11029](https://github.com/nodejs/node/pull/11029)
* [[`22e2288f3a`](https://github.com/nodejs/node/commit/22e2288f3a)] - **(SEMVER-MINOR)** **deps**: ensure V8 5.4 ABI compatibility (Michaël Zasso) [#11029](https://github.com/nodejs/node/pull/11029)
* [[`53e00e1617`](https://github.com/nodejs/node/commit/53e00e1617)] - **(SEMVER-MINOR)** **deps**: limit regress/regress-crbug-514081 v8 test (Michael Dawson) [#11029](https://github.com/nodejs/node/pull/11029)
* [[`7fea966a1d`](https://github.com/nodejs/node/commit/7fea966a1d)] - **(SEMVER-MINOR)** **deps**: cherry-pick workaround for clang-3.4 ICE (Michaël Zasso) [#11029](https://github.com/nodejs/node/pull/11029)
* [[`61870b429a`](https://github.com/nodejs/node/commit/61870b429a)] - **(SEMVER-MINOR)** **deps**: update V8 to 5.5.372.40 (Michaël Zasso) [#11029](https://github.com/nodejs/node/pull/11029)
* [[`d9ed965ae1`](https://github.com/nodejs/node/commit/d9ed965ae1)] - **dgram**: remove this aliases (cjihrig) [#11243](https://github.com/nodejs/node/pull/11243)
* [[`2f1ce2952d`](https://github.com/nodejs/node/commit/2f1ce2952d)] - **doc**: update link to V8 Embedder's guide (Franziska Hinkelmann) [#11336](https://github.com/nodejs/node/pull/11336)
* [[`3db54c93f8`](https://github.com/nodejs/node/commit/3db54c93f8)] - **doc**: update email and add personal pronoun (JungMinu) [#11318](https://github.com/nodejs/node/pull/11318)
* [[`1b08f766b1`](https://github.com/nodejs/node/commit/1b08f766b1)] - **doc**: drop "and io.js" from release section (Ben Noordhuis) [#11054](https://github.com/nodejs/node/pull/11054)
* [[`a5e8176fee`](https://github.com/nodejs/node/commit/a5e8176fee)] - **doc**: improve consistency in documentation titles (Vse Mozhet Byt) [#11230](https://github.com/nodejs/node/pull/11230)
* [[`5d2ba44fca`](https://github.com/nodejs/node/commit/5d2ba44fca)] - **doc**: edit maxBuffer/Unicode paragraph for clarity (Rich Trott) [#11228](https://github.com/nodejs/node/pull/11228)
* [[`d5b1a4b265`](https://github.com/nodejs/node/commit/d5b1a4b265)] - **doc**: clarify the behavior of Buffer.byteLength (Nikolai Vavilov) [#11238](https://github.com/nodejs/node/pull/11238)
* [[`0d4b0edb56`](https://github.com/nodejs/node/commit/0d4b0edb56)] - **doc**: add links between cork() and uncork() (Matteo Collina) [#11222](https://github.com/nodejs/node/pull/11222)
* [[`266c41c2b1`](https://github.com/nodejs/node/commit/266c41c2b1)] - **doc**: add and fix System Error properties (Daiki Arai) [#10986](https://github.com/nodejs/node/pull/10986)
* [[`71f8a23da4`](https://github.com/nodejs/node/commit/71f8a23da4)] - **doc**: fix typo in dgram doc (Rich Trott) [#11186](https://github.com/nodejs/node/pull/11186)
* [[`73b32a31e0`](https://github.com/nodejs/node/commit/73b32a31e0)] - **doc**: remove extraneous paragraph from assert doc (Rich Trott) [#11174](https://github.com/nodejs/node/pull/11174)
* [[`abae26421e`](https://github.com/nodejs/node/commit/abae26421e)] - **doc**: improve testing guide (Joyee Cheung) [#11150](https://github.com/nodejs/node/pull/11150)
* [[`803f6b3091`](https://github.com/nodejs/node/commit/803f6b3091)] - **doc**: fix linting command for vcbuild (Rich Trott) [#11151](https://github.com/nodejs/node/pull/11151)
* [[`177e9797cd`](https://github.com/nodejs/node/commit/177e9797cd)] - **doc**: add common.WPT to test README (Rich Trott) [#11127](https://github.com/nodejs/node/pull/11127)
* [[`1fbbcc3c07`](https://github.com/nodejs/node/commit/1fbbcc3c07)] - **doc**: add not-an-aardvark as ESLint contact (Rich Trott) [#11169](https://github.com/nodejs/node/pull/11169)
* [[`5649174dda`](https://github.com/nodejs/node/commit/5649174dda)] - **doc**: typographical fixes in COLLABORATOR_GUIDE.md (Anna Henningsen) [#11163](https://github.com/nodejs/node/pull/11163)
* [[`ae33a15d01`](https://github.com/nodejs/node/commit/ae33a15d01)] - **doc**: fix "initial delay" link in http.md (Timo Tijhof) [#11108](https://github.com/nodejs/node/pull/11108)
* [[`5d58756b41`](https://github.com/nodejs/node/commit/5d58756b41)] - **doc**: remove assertions about assert (Rich Trott) [#11113](https://github.com/nodejs/node/pull/11113)
* [[`3ebe306bb0`](https://github.com/nodejs/node/commit/3ebe306bb0)] - **doc**: edit stability text for clarity and style (Rich Trott) [#11112](https://github.com/nodejs/node/pull/11112)
* [[`535492d321`](https://github.com/nodejs/node/commit/535492d321)] - **doc**: clarify msg when doc/api/cli.md not updated (Stewart X Addison) [#10872](https://github.com/nodejs/node/pull/10872)
* [[`3ae25a0bca`](https://github.com/nodejs/node/commit/3ae25a0bca)] - **doc**: add personal pronouns option (Rich Trott) [#11089](https://github.com/nodejs/node/pull/11089)
* [[`265a59b60f`](https://github.com/nodejs/node/commit/265a59b60f)] - **doc**: replace newlines in deprecation with space (Sakthipriyan Vairamani (thefourtheye)) [#11074](https://github.com/nodejs/node/pull/11074)
* [[`598d35c087`](https://github.com/nodejs/node/commit/598d35c087)] - **doc**: fix confusing example in dns.md (Vse Mozhet Byt) [#11022](https://github.com/nodejs/node/pull/11022)
* [[`989d2cdbac`](https://github.com/nodejs/node/commit/989d2cdbac)] - **doc**: edit CONTRIBUTING.md for clarity (Rich Trott) [#11045](https://github.com/nodejs/node/pull/11045)
* [[`6cf06cf518`](https://github.com/nodejs/node/commit/6cf06cf518)] - **(SEMVER-MINOR)** **fs**: allow WHATWG URL and file: URLs as paths (James M Snell) [#10739](https://github.com/nodejs/node/pull/10739)
* [[`9339891b07`](https://github.com/nodejs/node/commit/9339891b07)] - **fs**: re-enable watch facility in AIX (Gireesh Punathil) [#10085](https://github.com/nodejs/node/pull/10085)
* [[`2952512b86`](https://github.com/nodejs/node/commit/2952512b86)] - **lib**: replace \u2019 with regular ascii quote (Ben Noordhuis) [#11129](https://github.com/nodejs/node/pull/11129)
* [[`3596d156c1`](https://github.com/nodejs/node/commit/3596d156c1)] - **(SEMVER-MINOR)** **lib**: build `node inspect` into `node` (Anna Henningsen) [#10187](https://github.com/nodejs/node/pull/10187)
* [[`3074c6de7e`](https://github.com/nodejs/node/commit/3074c6de7e)] - **meta**: adding Italo A. Casas PGP Fingerprint (Italo A. Casas) [#11202](https://github.com/nodejs/node/pull/11202)
* [[`e530b5ae43`](https://github.com/nodejs/node/commit/e530b5ae43)] - **meta**: remove Chris Dickinson from CTC (Chris Dickinson) [#11267](https://github.com/nodejs/node/pull/11267)
* [[`17314eb9ca`](https://github.com/nodejs/node/commit/17314eb9ca)] - **meta**: add explicit deprecation and semver-major policy (James M Snell) [#7964](https://github.com/nodejs/node/pull/7964)
* [[`6a45c81edd`](https://github.com/nodejs/node/commit/6a45c81edd)] - **readline**: update 6 comparions to strict (Umair Ishaq) [#11078](https://github.com/nodejs/node/pull/11078)
* [[`fe2f058f17`](https://github.com/nodejs/node/commit/fe2f058f17)] - **(SEMVER-MINOR)** **repl**: remove workaround for function redefinition (Michaël Zasso) [#11029](https://github.com/nodejs/node/pull/11029)
* [[`3380cd5fdb`](https://github.com/nodejs/node/commit/3380cd5fdb)] - **src**: support UTF-8 in compiled-in JS source files (Ben Noordhuis) [#11129](https://github.com/nodejs/node/pull/11129)
* [[`308df11658`](https://github.com/nodejs/node/commit/308df11658)] - **src**: fix delete operator on vm context (Franziska Hinkelmann) [#11266](https://github.com/nodejs/node/pull/11266)
* [[`af06f62e35`](https://github.com/nodejs/node/commit/af06f62e35)] - **src**: fix -Wunused-result compiler warning (Ben Noordhuis) [#11197](https://github.com/nodejs/node/pull/11197)
* [[`44b17a21ad`](https://github.com/nodejs/node/commit/44b17a21ad)] - **src**: refactor CopyProperties to remove JS (AnnaMag) [#11102](https://github.com/nodejs/node/pull/11102)
* [[`ce3dcca619`](https://github.com/nodejs/node/commit/ce3dcca619)] - **src**: update v8_platform.StartInspector signature (Myk Melez) [#11157](https://github.com/nodejs/node/pull/11157)
* [[`d8a5e1c37f`](https://github.com/nodejs/node/commit/d8a5e1c37f)] - **src**: don't overwrite non-writable vm globals (Franziska Hinkelmann) [#11109](https://github.com/nodejs/node/pull/11109)
* [[`9264131fb3`](https://github.com/nodejs/node/commit/9264131fb3)] - **src**: unconsume stream fix in internal http impl (Roee Kasher) [#11015](https://github.com/nodejs/node/pull/11015)
* [[`c5210b203d`](https://github.com/nodejs/node/commit/c5210b203d)] - **src**: remove usage of V8 deprecated API in node_url.cc (Timothy Gu) [#11066](https://github.com/nodejs/node/pull/11066)
* [[`0b64f7fc0e`](https://github.com/nodejs/node/commit/0b64f7fc0e)] - **src, inspector**: add --inspect-brk (Josh Gavant) [#11149](https://github.com/nodejs/node/pull/11149)
* [[`0d52aced0c`](https://github.com/nodejs/node/commit/0d52aced0c)] - **stream**: move legacy to lib/internal dir (yorkie) [#8197](https://github.com/nodejs/node/pull/8197)
* [[`0610cc707b`](https://github.com/nodejs/node/commit/0610cc707b)] - **test**: skip IPv6 test on non-IPv6 systems (Rich Trott) [#11432](https://github.com/nodejs/node/pull/11432)
* [[`93d3a3a6b5`](https://github.com/nodejs/node/commit/93d3a3a6b5)] - **test**: add coverage for dgram _createSocketHandle() (cjihrig) [#11291](https://github.com/nodejs/node/pull/11291)
* [[`b140dec930`](https://github.com/nodejs/node/commit/b140dec930)] - **test**: refactor test-repl-sigint-nested-eval (Rich Trott) [#11303](https://github.com/nodejs/node/pull/11303)
* [[`1085a4675a`](https://github.com/nodejs/node/commit/1085a4675a)] - **test**: skip when openssl CLI doesn't exist (Sota Yamashita) [#11095](https://github.com/nodejs/node/pull/11095)
* [[`6f866ae002`](https://github.com/nodejs/node/commit/6f866ae002)] - **test**: improve punycode test coverage (Sebastian Van Sande) [#11144](https://github.com/nodejs/node/pull/11144)
* [[`68eb97442d`](https://github.com/nodejs/node/commit/68eb97442d)] - **test**: cover cluster error during dgram socket bind (cjihrig) [#11295](https://github.com/nodejs/node/pull/11295)
* [[`5350f04e42`](https://github.com/nodejs/node/commit/5350f04e42)] - **test**: refactor test-repl-sigint (Rich Trott) [#11309](https://github.com/nodejs/node/pull/11309)
* [[`1f3eee4f5d`](https://github.com/nodejs/node/commit/1f3eee4f5d)] - **test**: increase setMulticastLoopback() coverage (cjihrig) [#11277](https://github.com/nodejs/node/pull/11277)
* [[`6ee11f82b3`](https://github.com/nodejs/node/commit/6ee11f82b3)] - **test**: refactor test-dgram-address.js (cjihrig) [#11271](https://github.com/nodejs/node/pull/11271)
* [[`d2ee7e20b2`](https://github.com/nodejs/node/commit/d2ee7e20b2)] - **test**: refactor test-readline-keys (Rich Trott) [#11281](https://github.com/nodejs/node/pull/11281)
* [[`f096235d04`](https://github.com/nodejs/node/commit/f096235d04)] - **test**: improve test-assert.js (jobala) [#11193](https://github.com/nodejs/node/pull/11193)
* [[`b4056994c4`](https://github.com/nodejs/node/commit/b4056994c4)] - **test**: improve test-http-agent-destroyed-socket.js (Shubheksha Jalan) [#11201](https://github.com/nodejs/node/pull/11201)
* [[`803be085be`](https://github.com/nodejs/node/commit/803be085be)] - **test**: querystring.escape with multibyte characters (Daijiro Wachi) [#11251](https://github.com/nodejs/node/pull/11251)
* [[`809aea3081`](https://github.com/nodejs/node/commit/809aea3081)] - **test**: refactor test-dgram-setBroadcast.js (cjihrig) [#11252](https://github.com/nodejs/node/pull/11252)
* [[`69f5a754e2`](https://github.com/nodejs/node/commit/69f5a754e2)] - **test**: add vm module edge cases (Franziska Hinkelmann) [#11265](https://github.com/nodejs/node/pull/11265)
* [[`2f15efb05b`](https://github.com/nodejs/node/commit/2f15efb05b)] - **test**: adapt test-debugger-pid to localized Windows (Vse Mozhet Byt) [#11270](https://github.com/nodejs/node/pull/11270)
* [[`5e5d72eb5a`](https://github.com/nodejs/node/commit/5e5d72eb5a)] - **test**: remove nan + weak (Ben Noordhuis) [#11239](https://github.com/nodejs/node/pull/11239)
* [[`969b85cdf5`](https://github.com/nodejs/node/commit/969b85cdf5)] - **test**: remove dependency on node-weak (Ben Noordhuis) [#11239](https://github.com/nodejs/node/pull/11239)
* [[`0cded6aac1`](https://github.com/nodejs/node/commit/0cded6aac1)] - **test**: don't call process.exit() in gc tests (Ben Noordhuis) [#11239](https://github.com/nodejs/node/pull/11239)
* [[`7ff32bf705`](https://github.com/nodejs/node/commit/7ff32bf705)] - **test**: add coverage for dgram send() errors (cjihrig) [#11248](https://github.com/nodejs/node/pull/11248)
* [[`e1beb9fbfc`](https://github.com/nodejs/node/commit/e1beb9fbfc)] - **test**: add coverage for string array dgram send() (cjihrig) [#11247](https://github.com/nodejs/node/pull/11247)
* [[`2333cd3155`](https://github.com/nodejs/node/commit/2333cd3155)] - **test**: increase dgram ref()/unref() coverage (cjihrig) [#11240](https://github.com/nodejs/node/pull/11240)
* [[`480d4cc9df`](https://github.com/nodejs/node/commit/480d4cc9df)] - **test**: add coverage to dgram receive error case (cjihrig) [#11241](https://github.com/nodejs/node/pull/11241)
* [[`ccd1163b46`](https://github.com/nodejs/node/commit/ccd1163b46)] - **test**: refactor test-fs-buffer (Rich Trott) [#11232](https://github.com/nodejs/node/pull/11232)
* [[`25226ced6a`](https://github.com/nodejs/node/commit/25226ced6a)] - **test**: improve checks in test-path-parse-format (cjihrig) [#11223](https://github.com/nodejs/node/pull/11223)
* [[`540dca1d18`](https://github.com/nodejs/node/commit/540dca1d18)] - **test**: fix incorrect indentation (cjihrig) [#11219](https://github.com/nodejs/node/pull/11219)
* [[`f0eba7811d`](https://github.com/nodejs/node/commit/f0eba7811d)] - **test**: add common.mustNotCall() (cjihrig) [#11152](https://github.com/nodejs/node/pull/11152)
* [[`f6dfc3193a`](https://github.com/nodejs/node/commit/f6dfc3193a)] - **test**: remove obsolete comment from dgram test (ALJCepeda) [#8689](https://github.com/nodejs/node/pull/8689)
* [[`9d5ffa6e49`](https://github.com/nodejs/node/commit/9d5ffa6e49)] - **test**: add test cases to test-readline-keys.js (abouthiroppy) [#10772](https://github.com/nodejs/node/pull/10772)
* [[`7ec6a69a7d`](https://github.com/nodejs/node/commit/7ec6a69a7d)] - **test**: add missing initialization in test-assert (Rich Trott) [#11191](https://github.com/nodejs/node/pull/11191)
* [[`b766dab81c`](https://github.com/nodejs/node/commit/b766dab81c)] - **test**: increase specificity in dgram test (Rich Trott) [#11187](https://github.com/nodejs/node/pull/11187)
* [[`9c729211e4`](https://github.com/nodejs/node/commit/9c729211e4)] - **test**: improve crypto.setEngine coverage to check for errors (Sebastian Van Sande) [#11143](https://github.com/nodejs/node/pull/11143)
* [[`3ca483f4cc`](https://github.com/nodejs/node/commit/3ca483f4cc)] - **test**: throw Error objects instead of literals (Rich Trott) [#11168](https://github.com/nodejs/node/pull/11168)
* [[`8612a004a3`](https://github.com/nodejs/node/commit/8612a004a3)] - **(SEMVER-MINOR)** **test**: move test-vm-function-redefinition to parallel (Franziska Hinkelmann) [#11029](https://github.com/nodejs/node/pull/11029)
* [[`fbd495583e`](https://github.com/nodejs/node/commit/fbd495583e)] - **test**: simplify output handling in repl tests (Rich Trott) [#11124](https://github.com/nodejs/node/pull/11124)
* [[`7f9b436c4b`](https://github.com/nodejs/node/commit/7f9b436c4b)] - **test**: make module testing stricter (Rich Trott) [#11116](https://github.com/nodejs/node/pull/11116)
* [[`cf098688e4`](https://github.com/nodejs/node/commit/cf098688e4)] - **test**: fix test.py command line options processing (Julien Gilli) [#11153](https://github.com/nodejs/node/pull/11153)
* [[`e9f6bc60e9`](https://github.com/nodejs/node/commit/e9f6bc60e9)] - **test**: improve coverage on removeListeners functions (matsuda-koushi) [#11140](https://github.com/nodejs/node/pull/11140)
* [[`815e668209`](https://github.com/nodejs/node/commit/815e668209)] - **test**: add --abort-on-timeout option to test.py (Julien Gilli) [#11086](https://github.com/nodejs/node/pull/11086)
* [[`cf3700b0e8`](https://github.com/nodejs/node/commit/cf3700b0e8)] - **test**: fix timing sensitivity in debugger test (Ali Ijaz Sheikh) [#11008](https://github.com/nodejs/node/pull/11008)
* [[`3d35dcff9a`](https://github.com/nodejs/node/commit/3d35dcff9a)] - **test**: make test-fs-access stricter (Rich Trott) [#11087](https://github.com/nodejs/node/pull/11087)
* [[`e2d9c23e72`](https://github.com/nodejs/node/commit/e2d9c23e72)] - **test**: use repeat() instead of new Array().join() (Jackson Tian) [#11071](https://github.com/nodejs/node/pull/11071)
* [[`ea5bef5efe`](https://github.com/nodejs/node/commit/ea5bef5efe)] - **test**: add path.join's test (Yuta Hiroto) [#11063](https://github.com/nodejs/node/pull/11063)
* [[`8d2a9138fc`](https://github.com/nodejs/node/commit/8d2a9138fc)] - **test**: improve error messages in test-npm-install (Gonen Dukas) [#11027](https://github.com/nodejs/node/pull/11027)
* [[`8ac6a709b9`](https://github.com/nodejs/node/commit/8ac6a709b9)] - **test**: add fs-assert-encoding's test (abouthiroppy) [#10913](https://github.com/nodejs/node/pull/10913)
* [[`e4b139d300`](https://github.com/nodejs/node/commit/e4b139d300)] - **timer**: remove duplicated word in comment (asafdav2) [#11323](https://github.com/nodejs/node/pull/11323)
* [[`a2948fbe74`](https://github.com/nodejs/node/commit/a2948fbe74)] - **tools**: enable ES2017 syntax support in ESLint (Michaël Zasso) [#11211](https://github.com/nodejs/node/pull/11211)
* [[`7e465b9c21`](https://github.com/nodejs/node/commit/7e465b9c21)] - **tools**: add compile_commands.json gyp generator (Ben Noordhuis) [#7986](https://github.com/nodejs/node/pull/7986)
* [[`2dc8aac1a9`](https://github.com/nodejs/node/commit/2dc8aac1a9)] - **tools**: enable no-throw-literal ESLint rule (Rich Trott) [#11168](https://github.com/nodejs/node/pull/11168)
* [[`8547871ea2`](https://github.com/nodejs/node/commit/8547871ea2)] - **url**: fix setting `url.search` to the empty string (Timothy Gu) [#11105](https://github.com/nodejs/node/pull/11105)
* [[`322fc20333`](https://github.com/nodejs/node/commit/322fc20333)] - **(SEMVER-MINOR)** **url**: extend url.format to support WHATWG URL (James M Snell) [#10857](https://github.com/nodejs/node/pull/10857)
* [[`cfadbc2661`](https://github.com/nodejs/node/commit/cfadbc2661)] - **util**: improve inspect for AsyncFunction (Michaël Zasso) [#11211](https://github.com/nodejs/node/pull/11211)

<a id="7.5.0"></a>
## 2017-01-31, Version 7.5.0 (Current), @evanlucas

Thank you to @italoacasas for preparing the majority of this release.

This release contains security fixes to upgrade OpenSSL to version 1.0.2k.

Although the OpenSSL team have determined a maximum severity rating of "moderate", the Node.js
crypto team (Ben Noordhuis, Shigeki Ohtsu and Fedor Indutny) have determined the impact to Node
users is "low". Details on this determination can be found
[on the Nodejs.org website](https://nodejs.org/en/blog/vulnerability/openssl-january-2017/).

### Notable changes

* **crypto**:
  * ability to select cert store at runtime (Adam Majer) [#8334](https://github.com/nodejs/node/pull/8334)
  * Use system CAs instead of using bundled ones (Adam Majer) [#8334](https://github.com/nodejs/node/pull/8334)
* **deps**:
  * upgrade npm to 4.1.2 (Kat Marchán) [#11020](https://github.com/nodejs/node/pull/11020)
  * upgrade openssl sources to 1.0.2k (Shigeki Ohtsu) [#11021](https://github.com/nodejs/node/pull/11021)
* **doc**: add basic documentation for WHATWG URL API (James M Snell) [#10620](https://github.com/nodejs/node/pull/10620)
* **process**: add NODE_NO_WARNINGS environment variable (cjihrig) [#10842](https://github.com/nodejs/node/pull/10842)
* **url**: allow use of URL with http.request and https.request (James M Snell) [#10638](https://github.com/nodejs/node/pull/10638)

### Commits

* [[`61f6f1260d`](https://github.com/nodejs/node/commit/61f6f1260d)] - **(SEMVER-MINOR)** src/doc: improve man page and --help (Roman Reiss) [#10157](https://github.com/nodejs/node/pull/10157)
* [[`b2d0c44fb1`](https://github.com/nodejs/node/commit/b2d0c44fb1)] - **assert**: update comments (Kai Cataldo) [#10579](https://github.com/nodejs/node/pull/10579)
* [[`c217b438f2`](https://github.com/nodejs/node/commit/c217b438f2)] - **assert, tools**: enforce strict (not)equal in eslint (Gibson Fahnestock) [#10698](https://github.com/nodejs/node/pull/10698)
* [[`94c4323d56`](https://github.com/nodejs/node/commit/94c4323d56)] - **async_wrap**: close the destroy_ids_idle_handle_ (René Schünemann) [#10385](https://github.com/nodejs/node/pull/10385)
* [[`f61c71b533`](https://github.com/nodejs/node/commit/f61c71b533)] - **benchmark**: add progress indicator to compare.js (Joyee Cheung) [#10823](https://github.com/nodejs/node/pull/10823)
* [[`ccdc922ada`](https://github.com/nodejs/node/commit/ccdc922ada)] - **benchmark**: move setImmediate benchmarks to timers (Joshua Colvin) [#11010](https://github.com/nodejs/node/pull/11010)
* [[`062c8513ad`](https://github.com/nodejs/node/commit/062c8513ad)] - **benchmark**: add more thorough timers benchmarks (Jeremiah Senkpiel) [#10925](https://github.com/nodejs/node/pull/10925)
* [[`1e0294ccc9`](https://github.com/nodejs/node/commit/1e0294ccc9)] - **benchmark**: add benchmark for object properties (Michaël Zasso) [#10949](https://github.com/nodejs/node/pull/10949)
* [[`47c0953b12`](https://github.com/nodejs/node/commit/47c0953b12)] - **benchmark**: add benchmark for vm.runIn*() (Rich Trott) [#10816](https://github.com/nodejs/node/pull/10816)
* [[`2f339e7200`](https://github.com/nodejs/node/commit/2f339e7200)] - **benchmark**: cleanup child_process IPC benchmark (Yuya Tanaka) [#10557](https://github.com/nodejs/node/pull/10557)
* [[`eac1871c45`](https://github.com/nodejs/node/commit/eac1871c45)] - **benchmark**: improve WHATWG URL benchmarks (Joyee Cheung) [#10678](https://github.com/nodejs/node/pull/10678)
* [[`ecf72d8b54`](https://github.com/nodejs/node/commit/ecf72d8b54)] - **benchmark**: use "confidence" in output of compare.R (Joyee Cheung) [#10737](https://github.com/nodejs/node/pull/10737)
* [[`35334273b9`](https://github.com/nodejs/node/commit/35334273b9)] - **benchmark**: don't lint autogenerated modules (Brian White) [#10756](https://github.com/nodejs/node/pull/10756)
* [[`4f96272f12`](https://github.com/nodejs/node/commit/4f96272f12)] - **benchmark**: fix typo "categoty" -> "category" (Victor Felder) [#10568](https://github.com/nodejs/node/pull/10568)
* [[`2f4577c07d`](https://github.com/nodejs/node/commit/2f4577c07d)] - **benchmark**: keep decimals in results (Brian White) [#10559](https://github.com/nodejs/node/pull/10559)
* [[`372e3eeb4b`](https://github.com/nodejs/node/commit/372e3eeb4b)] - **benchmark**: improve readability of net benchmarks (Brian White) [#10446](https://github.com/nodejs/node/pull/10446)
* [[`d19136da84`](https://github.com/nodejs/node/commit/d19136da84)] - **benchmark**: move punycode benchmark out of net (Brian White) [#10446](https://github.com/nodejs/node/pull/10446)
* [[`be24cc0187`](https://github.com/nodejs/node/commit/be24cc0187)] - **benchmark**: add ClientRequest creation benchmark (Brian White) [#10654](https://github.com/nodejs/node/pull/10654)
* [[`1438d00119`](https://github.com/nodejs/node/commit/1438d00119)] - **benchmark,lib,test**: adjust for linting (Rich Trott) [#10561](https://github.com/nodejs/node/pull/10561)
* [[`d13aba8499`](https://github.com/nodejs/node/commit/d13aba8499)] - **buffer**: improve compare() performance (Brian White) [#10927](https://github.com/nodejs/node/pull/10927)
* [[`6549bc2a35`](https://github.com/nodejs/node/commit/6549bc2a35)] - **buffer**: fix comments in bidirectionalIndexOf (dcposch@dcpos.ch) [#10162](https://github.com/nodejs/node/pull/10162)
* [[`a114f63627`](https://github.com/nodejs/node/commit/a114f63627)] - **buffer**: improve toJSON() performance (Brian White) [#10895](https://github.com/nodejs/node/pull/10895)
* [[`9c2f686f7e`](https://github.com/nodejs/node/commit/9c2f686f7e)] - **build**: don't build deps/zlib if --shared-zlib set (Gibson Fahnestock) [#10657](https://github.com/nodejs/node/pull/10657)
* [[`659428fe1d`](https://github.com/nodejs/node/commit/659428fe1d)] - **build**: sort sources alphabetically (Daniel Bevenius) [#10892](https://github.com/nodejs/node/pull/10892)
* [[`74f9cc9f0a`](https://github.com/nodejs/node/commit/74f9cc9f0a)] - **build**: move source files from headers section (Daniel Bevenius) [#10850](https://github.com/nodejs/node/pull/10850)
* [[`a408ba6454`](https://github.com/nodejs/node/commit/a408ba6454)] - **build**: don't squash signal handlers with --shared (Stewart X Addison) [#10539](https://github.com/nodejs/node/pull/10539)
* [[`ddcd1a202f`](https://github.com/nodejs/node/commit/ddcd1a202f)] - **child_process**: optimize IPC for large data (Yuya Tanaka) [#10557](https://github.com/nodejs/node/pull/10557)
* [[`d751afae0f`](https://github.com/nodejs/node/commit/d751afae0f)] - **cluster**: refactor module into multiple files (cjihrig) [#10746](https://github.com/nodejs/node/pull/10746)
* [[`6687b95263`](https://github.com/nodejs/node/commit/6687b95263)] - **crypto**: return the retval of HMAC_Update (Travis Meisenheimer) [#10891](https://github.com/nodejs/node/pull/10891)
* [[`a1897c1445`](https://github.com/nodejs/node/commit/a1897c1445)] - **(SEMVER-MINOR)** **crypto**: ability to select cert store at runtime (Adam Majer) [#8334](https://github.com/nodejs/node/pull/8334)
* [[`aeea13b6f6`](https://github.com/nodejs/node/commit/aeea13b6f6)] - **(SEMVER-MINOR)** **crypto**: Use system CAs instead of using bundled ones (Adam Majer) [#8334](https://github.com/nodejs/node/pull/8334)
* [[`ac2b059500`](https://github.com/nodejs/node/commit/ac2b059500)] - **(SEMVER-MINOR)** **crypto**: do not use pointers to std::vector (Adam Majer) [#8334](https://github.com/nodejs/node/pull/8334)
* [[`5fd0f9ae63`](https://github.com/nodejs/node/commit/5fd0f9ae63)] - **crypto**: freelist_max_len is gone in OpenSSL 1.1.0 (Adam Langley) [#10859](https://github.com/nodejs/node/pull/10859)
* [[`4e7a31b3a0`](https://github.com/nodejs/node/commit/4e7a31b3a0)] - **crypto,tls**: fix mutability of return values (Rich Trott) [#10795](https://github.com/nodejs/node/pull/10795)
* [[`84a9c158ef`](https://github.com/nodejs/node/commit/84a9c158ef)] - **deps**: fix npm files from upgrade to 4.1.2 (João Reis) [#11085](https://github.com/nodejs/node/pull/11085)
* [[`9e60af893c`](https://github.com/nodejs/node/commit/9e60af893c)] - **deps**: upgrade npm to 4.1.2 (Kat Marchán) [#11020](https://github.com/nodejs/node/pull/11020)
* [[`da59a57d60`](https://github.com/nodejs/node/commit/da59a57d60)] - **deps**: limit regress/regress-crbug-514081 v8 test (Michael Dawson) [#6678](https://github.com/nodejs/node/pull/6678)
* [[`edd20720ac`](https://github.com/nodejs/node/commit/edd20720ac)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#11021](https://github.com/nodejs/node/pull/11021)
* [[`ce20ad76ec`](https://github.com/nodejs/node/commit/ce20ad76ec)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`06f87c3e0a`](https://github.com/nodejs/node/commit/06f87c3e0a)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`093cacf61b`](https://github.com/nodejs/node/commit/093cacf61b)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`a3b3b35c53`](https://github.com/nodejs/node/commit/a3b3b35c53)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#11021](https://github.com/nodejs/node/pull/11021)
* [[`6a0f1fabb1`](https://github.com/nodejs/node/commit/6a0f1fabb1)] - **deps**: upgrade openssl sources to 1.0.2k (Shigeki Ohtsu) [#11021](https://github.com/nodejs/node/pull/11021)
* [[`1fae98b833`](https://github.com/nodejs/node/commit/1fae98b833)] - **deps**: upgrade npm to 4.1.1 (Rebecca Turner) [#10781](https://github.com/nodejs/node/pull/10781)
* [[`6e0888ad9e`](https://github.com/nodejs/node/commit/6e0888ad9e)] - **deps**: add test for v8 bug in toUpper('ç') (Steven R. Loomis) [#9828](https://github.com/nodejs/node/pull/9828)
* [[`1c4bf9e8ff`](https://github.com/nodejs/node/commit/1c4bf9e8ff)] - **deps**: cherry-pick 2f5da9a from V8 upstream (Steven R. Loomis) [#9828](https://github.com/nodejs/node/pull/9828)
* [[`ffd938a694`](https://github.com/nodejs/node/commit/ffd938a694)] - **deps**: upgrade libuv to 1.10.2 (cjihrig) [#10717](https://github.com/nodejs/node/pull/10717)
* [[`aa6b9f979e`](https://github.com/nodejs/node/commit/aa6b9f979e)] - **deps**: cherry-pick baba152 from V8 upstream (Michaël Zasso) [#10688](https://github.com/nodejs/node/pull/10688)
* [[`5887396150`](https://github.com/nodejs/node/commit/5887396150)] - **deps**: cherry-pick a814b8a from upstream V8 (ishell@chromium.org) [#10733](https://github.com/nodejs/node/pull/10733)
* [[`cfc4c62249`](https://github.com/nodejs/node/commit/cfc4c62249)] - **doc**: correct and complete dgram's Socket.bind docs (Alex Jordan) [#11025](https://github.com/nodejs/node/pull/11025)
* [[`55e98c66c0`](https://github.com/nodejs/node/commit/55e98c66c0)] - **doc**: add abouthiroppy to collaborators (Yuta Hiroto) [#11080](https://github.com/nodejs/node/pull/11080)
* [[`722ae8700f`](https://github.com/nodejs/node/commit/722ae8700f)] - **doc**: add who to CC list for dgram (cjihrig) [#11035](https://github.com/nodejs/node/pull/11035)
* [[`a8533acee6`](https://github.com/nodejs/node/commit/a8533acee6)] - **doc**: change logical to bitwise OR in dns lookup (Sakthipriyan Vairamani (thefourtheye)) [#11037](https://github.com/nodejs/node/pull/11037)
* [[`ac36d78d56`](https://github.com/nodejs/node/commit/ac36d78d56)] - **doc**: fix typo in http.md (Peter Mescalchin) [#10975](https://github.com/nodejs/node/pull/10975)
* [[`0bf3b24771`](https://github.com/nodejs/node/commit/0bf3b24771)] - **doc**: remove Chris Dickinson from active releasers (Ben Noordhuis) [#11011](https://github.com/nodejs/node/pull/11011)
* [[`9ca404ed25`](https://github.com/nodejs/node/commit/9ca404ed25)] - **doc**: for style, remove "isn't" contraction (Sam Roberts) [#10981](https://github.com/nodejs/node/pull/10981)
* [[`4be9e98448`](https://github.com/nodejs/node/commit/4be9e98448)] - **doc**: make os api doc more consistent (Evan Lucas) [#10994](https://github.com/nodejs/node/pull/10994)
* [[`7dff6aa67f`](https://github.com/nodejs/node/commit/7dff6aa67f)] - **doc**: update http.md for consistency and clarity (Lance Ball) [#10715](https://github.com/nodejs/node/pull/10715)
* [[`dd608591a8`](https://github.com/nodejs/node/commit/dd608591a8)] - **doc**: clarify Buffer.indexOf/lastIndexOf edge cases (dcposch@dcpos.ch) [#10162](https://github.com/nodejs/node/pull/10162)
* [[`5250b3358e`](https://github.com/nodejs/node/commit/5250b3358e)] - **doc**: document argument variant in the repl.md (Vse Mozhet Byt) [#10221](https://github.com/nodejs/node/pull/10221)
* [[`c4b9f0a75e`](https://github.com/nodejs/node/commit/c4b9f0a75e)] - **doc**: DEFAULT_ECDH_CURVE was added in 0.11.13 (Sam Roberts) [#10983](https://github.com/nodejs/node/pull/10983)
* [[`84e2ff3738`](https://github.com/nodejs/node/commit/84e2ff3738)] - **(SEMVER-MINOR)** **doc**: add basic documentation for WHATWG URL API (James M Snell) [#10620](https://github.com/nodejs/node/pull/10620)
* [[`9d91bf9788`](https://github.com/nodejs/node/commit/9d91bf9788)] - **doc**: HTTP response getHeader doc fix (Faiz Halde) [#10817](https://github.com/nodejs/node/pull/10817)
* [[`06acf88117`](https://github.com/nodejs/node/commit/06acf88117)] - **doc**: remove duplicate properties bullet in readme (Javis Sullivan) [#10741](https://github.com/nodejs/node/pull/10741)
* [[`09ac2a2cb7`](https://github.com/nodejs/node/commit/09ac2a2cb7)] - **doc**: specify sorted requires in tests (Sam Roberts) [#10716](https://github.com/nodejs/node/pull/10716)
* [[`f380a5fb5a`](https://github.com/nodejs/node/commit/f380a5fb5a)] - **doc**: mention cc-ing nodejs/python team for reviews (Anna Henningsen) [#10637](https://github.com/nodejs/node/pull/10637)
* [[`58bb263438`](https://github.com/nodejs/node/commit/58bb263438)] - **doc**: update TheAlphaNerd to MylesBorins (Myles Borins) [#10586](https://github.com/nodejs/node/pull/10586)
* [[`1253650cf4`](https://github.com/nodejs/node/commit/1253650cf4)] - **doc**: update examples in api/crypto.md (Vse Mozhet Byt) [#10909](https://github.com/nodejs/node/pull/10909)
* [[`3177d6557a`](https://github.com/nodejs/node/commit/3177d6557a)] - **doc**: move topics/guides to website (Evan Lucas) [#10896](https://github.com/nodejs/node/pull/10896)
* [[`d2896d92a7`](https://github.com/nodejs/node/commit/d2896d92a7)] - **doc**: update AUTHORS list to fix name (Noah Rose Ledesma) [#10945](https://github.com/nodejs/node/pull/10945)
* [[`4ffcefdc09`](https://github.com/nodejs/node/commit/4ffcefdc09)] - **doc**: add TimothyGu to collaborators (Timothy Gu) [#10954](https://github.com/nodejs/node/pull/10954)
* [[`3fcf0aed4a`](https://github.com/nodejs/node/commit/3fcf0aed4a)] - **doc**: mention moderation repo in onboarding doc (Anna Henningsen) [#10869](https://github.com/nodejs/node/pull/10869)
* [[`79d8db0fef`](https://github.com/nodejs/node/commit/79d8db0fef)] - **doc**: add edsadr to collaborators (Adrian Estrada) [#10883](https://github.com/nodejs/node/pull/10883)
* [[`520b1f7853`](https://github.com/nodejs/node/commit/520b1f7853)] - **doc**: clarifying variables in fs.write() (Jessica Quynh Tran) [#9792](https://github.com/nodejs/node/pull/9792)
* [[`daf1bf588b`](https://github.com/nodejs/node/commit/daf1bf588b)] - **doc**: add links for zlib convenience methods (Anna Henningsen) [#10829](https://github.com/nodejs/node/pull/10829)
* [[`aeaf887700`](https://github.com/nodejs/node/commit/aeaf887700)] - **doc**: fix markdown escaping in CHANGELOG_V7.md (Anna Henningsen) [#10827](https://github.com/nodejs/node/pull/10827)
* [[`c8b0fc6d8b`](https://github.com/nodejs/node/commit/c8b0fc6d8b)] - **doc**: remove duplicate PR link from changelog (Anna Henningsen) [#10827](https://github.com/nodejs/node/pull/10827)
* [[`049258b062`](https://github.com/nodejs/node/commit/049258b062)] - **doc**: fixup `added` tags in cli.md (Anna Henningsen) [#10826](https://github.com/nodejs/node/pull/10826)
* [[`61798d1fa4`](https://github.com/nodejs/node/commit/61798d1fa4)] - **doc**: add missing `added:` tag for `zlib.constants` (Anna Henningsen) [#10826](https://github.com/nodejs/node/pull/10826)
* [[`73939ec701`](https://github.com/nodejs/node/commit/73939ec701)] - **doc**: clarify memory sharing behavior of buffer ctor (Zach Bjornson) [#10778](https://github.com/nodejs/node/pull/10778)
* [[`f8b081b519`](https://github.com/nodejs/node/commit/f8b081b519)] - **doc**: fix broken internal link in process.md (Anna Henningsen) [#10828](https://github.com/nodejs/node/pull/10828)
* [[`a53f881f57`](https://github.com/nodejs/node/commit/a53f881f57)] - **doc**: update writable.write return value (Nathan Phillip Brink) [#10582](https://github.com/nodejs/node/pull/10582)
* [[`6e1a3d1e57`](https://github.com/nodejs/node/commit/6e1a3d1e57)] - **doc**: use correct tls certificate property name (Sam Roberts) [#10389](https://github.com/nodejs/node/pull/10389)
* [[`23edfe00b3`](https://github.com/nodejs/node/commit/23edfe00b3)] - **doc**: edit writing-tests.md (Rich Trott) [#10585](https://github.com/nodejs/node/pull/10585)
* [[`9b73a8524f`](https://github.com/nodejs/node/commit/9b73a8524f)] - **doc**: fix misleading language in vm docs (Alexey Orlenko) [#10708](https://github.com/nodejs/node/pull/10708)
* [[`56ea7eb9a7`](https://github.com/nodejs/node/commit/56ea7eb9a7)] - **doc**: mention cc-ing nodejs/url team for reviews (Anna Henningsen) [#10652](https://github.com/nodejs/node/pull/10652)
* [[`66b34eac2f`](https://github.com/nodejs/node/commit/66b34eac2f)] - **doc**: sort require statements in tests (Sam Roberts) [#10616](https://github.com/nodejs/node/pull/10616)
* [[`238466bcf0`](https://github.com/nodejs/node/commit/238466bcf0)] - **doc**: handle backpressure when write() return false (Matteo Collina) [#10631](https://github.com/nodejs/node/pull/10631)
* [[`ec226a2a3b`](https://github.com/nodejs/node/commit/ec226a2a3b)] - **doc**: add test naming information to guide (Rich Trott) [#10584](https://github.com/nodejs/node/pull/10584)
* [[`b73e98bf48`](https://github.com/nodejs/node/commit/b73e98bf48)] - **doc**: fix missing negation in stream.md (Johannes Rieken) [#10712](https://github.com/nodejs/node/pull/10712)
* [[`bf95b074cd`](https://github.com/nodejs/node/commit/bf95b074cd)] - **doc**: "s/git apply/git am -3" in V8 guide (Myles Borins) [#10665](https://github.com/nodejs/node/pull/10665)
* [[`9c89b2f704`](https://github.com/nodejs/node/commit/9c89b2f704)] - **doc**: update LTS info for current releases (Evan Lucas) [#10720](https://github.com/nodejs/node/pull/10720)
* [[`3f1775707e`](https://github.com/nodejs/node/commit/3f1775707e)] - **doc**: correct vcbuild options for windows testing (Jonathan Boarman) [#10686](https://github.com/nodejs/node/pull/10686)
* [[`8314d9ee73`](https://github.com/nodejs/node/commit/8314d9ee73)] - **doc**: killSignal option accepts integer values (Sakthipriyan Vairamani (thefourtheye)) [#10424](https://github.com/nodejs/node/pull/10424)
* [[`736a7f3dd3`](https://github.com/nodejs/node/commit/736a7f3dd3)] - **doc**: update BUILDING.md (Lukasz Gasior) [#10669](https://github.com/nodejs/node/pull/10669)
* [[`f81bd48818`](https://github.com/nodejs/node/commit/f81bd48818)] - **doc**: document use of Refs: for references (Gibson Fahnestock) [#10670](https://github.com/nodejs/node/pull/10670)
* [[`b70dde0050`](https://github.com/nodejs/node/commit/b70dde0050)] - **doc**: new TLSSocket has no secure context options (Sam Roberts) [#10545](https://github.com/nodejs/node/pull/10545)
* [[`d3628d9e47`](https://github.com/nodejs/node/commit/d3628d9e47)] - **doc**: modernize child_process example code (Vse Mozhet Byt) [#10102](https://github.com/nodejs/node/pull/10102)
* [[`3270d4c89b`](https://github.com/nodejs/node/commit/3270d4c89b)] - **doc**: clarify information about ABI version (Rich Trott) [#10419](https://github.com/nodejs/node/pull/10419)
* [[`1fca69c263`](https://github.com/nodejs/node/commit/1fca69c263)] - **doc,test**: tls .ca option supports multi-PEM files (Sam Roberts) [#10389](https://github.com/nodejs/node/pull/10389)
* [[`78a495e1a4`](https://github.com/nodejs/node/commit/78a495e1a4)] - **eslint**: remove dangling eslint symlink (Sam Roberts) [#10771](https://github.com/nodejs/node/pull/10771)
* [[`5cca69320f`](https://github.com/nodejs/node/commit/5cca69320f)] - **events**: avoid emit() eager deopt (Victor Felder) [#10568](https://github.com/nodejs/node/pull/10568)
* [[`ded17579e5`](https://github.com/nodejs/node/commit/ded17579e5)] - **events**: improve removeListener() performance (Brian White) [#10572](https://github.com/nodejs/node/pull/10572)
* [[`d047f8e8f8`](https://github.com/nodejs/node/commit/d047f8e8f8)] - **fs**: remove unused parameter for encodeRealpathResult (Jackson Tian) [#10862](https://github.com/nodejs/node/pull/10862)
* [[`4c0f29723c`](https://github.com/nodejs/node/commit/4c0f29723c)] - **http**: use direct parameters instead (Jackson Tian) [#10833](https://github.com/nodejs/node/pull/10833)
* [[`c32984361a`](https://github.com/nodejs/node/commit/c32984361a)] - **http**: make request.abort() destroy the socket (Luigi Pinca) [#10818](https://github.com/nodejs/node/pull/10818)
* [[`8ba2cf9c51`](https://github.com/nodejs/node/commit/8ba2cf9c51)] - **http**: define all used properties in constructors (vitkarpov) [#9116](https://github.com/nodejs/node/pull/9116)
* [[`75aa6050ab`](https://github.com/nodejs/node/commit/75aa6050ab)] - **http**: eliminate capture of ClientRequest in Agent (Evan Torrie) [#10134](https://github.com/nodejs/node/pull/10134)
* [[`5059b76cbc`](https://github.com/nodejs/node/commit/5059b76cbc)] - **http**: misc ClientRequest cleanup (Brian White) [#10654](https://github.com/nodejs/node/pull/10654)
* [[`44c0e4f1ad`](https://github.com/nodejs/node/commit/44c0e4f1ad)] - **http**: avoid duplicate isArray() (Brian White) [#10654](https://github.com/nodejs/node/pull/10654)
* [[`e7859c217f`](https://github.com/nodejs/node/commit/e7859c217f)] - **http**: optimize default method case (Brian White) [#10654](https://github.com/nodejs/node/pull/10654)
* [[`c9bff043c7`](https://github.com/nodejs/node/commit/c9bff043c7)] - **http**: optimize short path validation (Brian White) [#10654](https://github.com/nodejs/node/pull/10654)
* [[`c012dd79dc`](https://github.com/nodejs/node/commit/c012dd79dc)] - **https**: Use secureProtocol in Agent#getName (Andreas Lind) [#9452](https://github.com/nodejs/node/pull/9452)
* [[`9a111e701e`](https://github.com/nodejs/node/commit/9a111e701e)] - **inspector**: no crash when WS server can't start (Eugene Ostroukhov) [#10878](https://github.com/nodejs/node/pull/10878)
* [[`2d08bbadd6`](https://github.com/nodejs/node/commit/2d08bbadd6)] - **inspector**: stop relying on magic strings (Eugene Ostroukhov) [#10159](https://github.com/nodejs/node/pull/10159)
* [[`e30e307a70`](https://github.com/nodejs/node/commit/e30e307a70)] - **inspector**: move options parsing (Eugene Ostroukhov) [#9691](https://github.com/nodejs/node/pull/9691)
* [[`60f27f91e4`](https://github.com/nodejs/node/commit/60f27f91e4)] - **inspector**: remove unused uv_async_t (Eugene Ostroukhov) [#10392](https://github.com/nodejs/node/pull/10392)
* [[`a3abba0b1a`](https://github.com/nodejs/node/commit/a3abba0b1a)] - **lib**: remove unnecessary parameter for assertCrypto() (Jackson Tian) [#10834](https://github.com/nodejs/node/pull/10834)
* [[`4de7b03a7d`](https://github.com/nodejs/node/commit/4de7b03a7d)] - **lib**: refactor bootstrap_node.js regular expression (Rich Trott) [#10749](https://github.com/nodejs/node/pull/10749)
* [[`a6c93af244`](https://github.com/nodejs/node/commit/a6c93af244)] - **lib**: refactor crypto cipher/hash/curve getters (Rich Trott) [#10682](https://github.com/nodejs/node/pull/10682)
* [[`6e8d627217`](https://github.com/nodejs/node/commit/6e8d627217)] - **lib,src**: support values > 4GB in heap statistics (Ben Noordhuis) [#10186](https://github.com/nodejs/node/pull/10186)
* [[`de8eee6b16`](https://github.com/nodejs/node/commit/de8eee6b16)] - **meta**: decharter the http working group (James M Snell) [#10604](https://github.com/nodejs/node/pull/10604)
* [[`4caa0126aa`](https://github.com/nodejs/node/commit/4caa0126aa)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`d24491c6a7`](https://github.com/nodejs/node/commit/d24491c6a7)] - **(SEMVER-MINOR)** **process**: add NODE_NO_WARNINGS environment variable (cjihrig) [#10842](https://github.com/nodejs/node/pull/10842)
* [[`97ff43232b`](https://github.com/nodejs/node/commit/97ff43232b)] - **querystring**: improve unescapeBuffer performance (Brian White) [#10837](https://github.com/nodejs/node/pull/10837)
* [[`f4796d5f6e`](https://github.com/nodejs/node/commit/f4796d5f6e)] - **querystring**: improve stringify() performance (Brian White) [#10852](https://github.com/nodejs/node/pull/10852)
* [[`53421b174c`](https://github.com/nodejs/node/commit/53421b174c)] - **querystring**: improve parse() performance (Brian White) [#10874](https://github.com/nodejs/node/pull/10874)
* [[`d64e2371f6`](https://github.com/nodejs/node/commit/d64e2371f6)] - **readline**: refactor construct Interface (Jackson Tian) [#4740](https://github.com/nodejs/node/pull/4740)
* [[`e7b656db6e`](https://github.com/nodejs/node/commit/e7b656db6e)] - ***Revert*** "**repl**: disable Ctrl+C support on win32 for now" (Anna Henningsen) [#8645](https://github.com/nodejs/node/pull/8645)
* [[`a24264eb18`](https://github.com/nodejs/node/commit/a24264eb18)] - **src**: fix v8 local handling in node_url.cc (Anna Henningsen) [#11064](https://github.com/nodejs/node/pull/11064)
* [[`8a6367cb20`](https://github.com/nodejs/node/commit/8a6367cb20)] - ***Revert*** "**src**: don't overwrite non-writable vm globals" (Anna Henningsen) [#10920](https://github.com/nodejs/node/pull/10920)
* [[`978acd138f`](https://github.com/nodejs/node/commit/978acd138f)] - **(SEMVER-MINOR)** **src**: support "--" after "-e" as end-of-options (John Barboza) [#10651](https://github.com/nodejs/node/pull/10651)
* [[`cd94642356`](https://github.com/nodejs/node/commit/cd94642356)] - **src**: add NODE_NO_WARNINGS to --help output (cjihrig) [#10918](https://github.com/nodejs/node/pull/10918)
* [[`63f43021b0`](https://github.com/nodejs/node/commit/63f43021b0)] - **src**: remove unused PROTOCOL_JSON array (Ben Noordhuis) [#10407](https://github.com/nodejs/node/pull/10407)
* [[`5a976decf7`](https://github.com/nodejs/node/commit/5a976decf7)] - **src**: remove unnecessary req_wrap_obj (Daniel Bevenius) [#10942](https://github.com/nodejs/node/pull/10942)
* [[`0c0334f7a4`](https://github.com/nodejs/node/commit/0c0334f7a4)] - **src**: add a missing space in node_os.cc (Alexey Orlenko) [#10931](https://github.com/nodejs/node/pull/10931)
* [[`b89d848b36`](https://github.com/nodejs/node/commit/b89d848b36)] - **src**: enable writev for pipe handles on Unix (Alexey Orlenko) [#10677](https://github.com/nodejs/node/pull/10677)
* [[`f0de955220`](https://github.com/nodejs/node/commit/f0de955220)] - **src**: reduce test_inspector_socket_server output (Daniel Bevenius) [#10537](https://github.com/nodejs/node/pull/10537)
* [[`59196af646`](https://github.com/nodejs/node/commit/59196af646)] - **stream**: avoid additional validation for Buffers (Brian White) [#10580](https://github.com/nodejs/node/pull/10580)
* [[`fe80bd9600`](https://github.com/nodejs/node/commit/fe80bd9600)] - **test**: add 2nd argument to throws in test-assert (Marlena Compton) [#11061](https://github.com/nodejs/node/pull/11061)
* [[`8ef4add4c3`](https://github.com/nodejs/node/commit/8ef4add4c3)] - **test**: require handler to be run in sigwinch test (Rich Trott) [#11068](https://github.com/nodejs/node/pull/11068)
* [[`e367b74c4f`](https://github.com/nodejs/node/commit/e367b74c4f)] - **test**: add an exception test to http-write-head (Yuta Hiroto) [#11034](https://github.com/nodejs/node/pull/11034)
* [[`65691d68d5`](https://github.com/nodejs/node/commit/65691d68d5)] - **test**: increase coverage of internal/util (DavidCai) [#10964](https://github.com/nodejs/node/pull/10964)
* [[`0753bc17b6`](https://github.com/nodejs/node/commit/0753bc17b6)] - **test**: increase timeout in break-on-uncaught (Sakthipriyan Vairamani (thefourtheye)) [#10822](https://github.com/nodejs/node/pull/10822)
* [[`eff3a48e63`](https://github.com/nodejs/node/commit/eff3a48e63)] - **test**: add known_issues test for #10223 (AnnaMag) [#11024](https://github.com/nodejs/node/pull/11024)
* [[`72a97b66dc`](https://github.com/nodejs/node/commit/72a97b66dc)] - **test**: guarantee test runs in test-readline-keys (Rich Trott) [#11023](https://github.com/nodejs/node/pull/11023)
* [[`e3a316f3e6`](https://github.com/nodejs/node/commit/e3a316f3e6)] - **test**: check error message in test-http-outgoing-proto (Alex Ling) [#10943](https://github.com/nodejs/node/pull/10943)
* [[`fcd08b8a1e`](https://github.com/nodejs/node/commit/fcd08b8a1e)] - **test**: add tests for searchParams (abouthiroppy) [#10952](https://github.com/nodejs/node/pull/10952)
* [[`f3efaeed35`](https://github.com/nodejs/node/commit/f3efaeed35)] - **test**: increase coverage for stream's duplex (abouthiroppy) [#10963](https://github.com/nodejs/node/pull/10963)
* [[`b5e8413c3f`](https://github.com/nodejs/node/commit/b5e8413c3f)] - **test**: allow for slow hosts in spawnSync() test (Rich Trott) [#10998](https://github.com/nodejs/node/pull/10998)
* [[`cfd1b19c34`](https://github.com/nodejs/node/commit/cfd1b19c34)] - **test**: expand test coverage of fs.js (Vinícius do Carmo) [#10947](https://github.com/nodejs/node/pull/10947)
* [[`4aedde8d82`](https://github.com/nodejs/node/commit/4aedde8d82)] - **test**: expand test coverage of events.js (Vinícius do Carmo) [#10947](https://github.com/nodejs/node/pull/10947)
* [[`c1e166a168`](https://github.com/nodejs/node/commit/c1e166a168)] - **test**: check noAssert option in buf.write*() (larissayvette) [#10790](https://github.com/nodejs/node/pull/10790)
* [[`580a453fcf`](https://github.com/nodejs/node/commit/580a453fcf)] - **test**: expand test coverage of fs.js (Vinícius do Carmo) [#10972](https://github.com/nodejs/node/pull/10972)
* [[`fa8baa2aa1`](https://github.com/nodejs/node/commit/fa8baa2aa1)] - **test**: enhance test-timers (Rich Trott) [#10960](https://github.com/nodejs/node/pull/10960)
* [[`74ff804dbd`](https://github.com/nodejs/node/commit/74ff804dbd)] - **test**: add regression tests for vm bugs (Anna Henningsen) [#10920](https://github.com/nodejs/node/pull/10920)
* [[`1a39bfb7e2`](https://github.com/nodejs/node/commit/1a39bfb7e2)] - **test**: increase coverage for exec() functions (cjihrig) [#10919](https://github.com/nodejs/node/pull/10919)
* [[`4b38744e9b`](https://github.com/nodejs/node/commit/4b38744e9b)] - **test**: add process.assert's test (abouthiroppy) [#10911](https://github.com/nodejs/node/pull/10911)
* [[`e7c953a5f9`](https://github.com/nodejs/node/commit/e7c953a5f9)] - **test**: update Buffer.lastIndexOf (dcposch@dcpos.ch) [#10162](https://github.com/nodejs/node/pull/10162)
* [[`eb7ee50717`](https://github.com/nodejs/node/commit/eb7ee50717)] - **test**: improve code in test-crypto-verify (Adrian Estrada) [#10845](https://github.com/nodejs/node/pull/10845)
* [[`efa9845946`](https://github.com/nodejs/node/commit/efa9845946)] - **test**: refactor test-cli-eval.js (cjihrig) [#10898](https://github.com/nodejs/node/pull/10898)
* [[`b7bf43aa2b`](https://github.com/nodejs/node/commit/b7bf43aa2b)] - **test**: use common.fail() instead of assert(false) (cjihrig) [#10899](https://github.com/nodejs/node/pull/10899)
* [[`90a99177a3`](https://github.com/nodejs/node/commit/90a99177a3)] - **test**: add dgram.Socket.prototype.bind's test (abouthiroppy) [#10894](https://github.com/nodejs/node/pull/10894)
* [[`dc826caed2`](https://github.com/nodejs/node/commit/dc826caed2)] - **test**: update V8 flag in test (Franziska Hinkelmann) [#10917](https://github.com/nodejs/node/pull/10917)
* [[`537d954ed2`](https://github.com/nodejs/node/commit/537d954ed2)] - **test**: increase coverage of string-decoder (abouthiroppy) [#10863](https://github.com/nodejs/node/pull/10863)
* [[`3cd9833eff`](https://github.com/nodejs/node/commit/3cd9833eff)] - **test**: add tests for rs+, sr+ to test-fs-open-flags.js (abouthiroppy) [#10780](https://github.com/nodejs/node/pull/10780)
* [[`c8a069e544`](https://github.com/nodejs/node/commit/c8a069e544)] - **test**: improving coverage of dns-lookup (abouthiroppy) [#10844](https://github.com/nodejs/node/pull/10844)
* [[`939517abfd`](https://github.com/nodejs/node/commit/939517abfd)] - **test**: refactor test-fs-read-zero-length.js (abouthiroppy) [#10729](https://github.com/nodejs/node/pull/10729)
* [[`ffdf605f14`](https://github.com/nodejs/node/commit/ffdf605f14)] - **test**: improving coverage for dgram (abouthiroppy) [#10783](https://github.com/nodejs/node/pull/10783)
* [[`1666600f16`](https://github.com/nodejs/node/commit/1666600f16)] - **test**: improve code in test-console-instance (Adrian Estrada) [#10813](https://github.com/nodejs/node/pull/10813)
* [[`b496374363`](https://github.com/nodejs/node/commit/b496374363)] - **test**: improve code in test-domain-multi (Adrian Estrada) [#10798](https://github.com/nodejs/node/pull/10798)
* [[`46bbabe6c2`](https://github.com/nodejs/node/commit/46bbabe6c2)] - **test**: improve test-stream2-large-read-stall (stefan judis) [#10725](https://github.com/nodejs/node/pull/10725)
* [[`7f043779eb`](https://github.com/nodejs/node/commit/7f043779eb)] - **test**: improve code in test-http-host-headers (Adrian Estrada) [#10830](https://github.com/nodejs/node/pull/10830)
* [[`66c57a24c2`](https://github.com/nodejs/node/commit/66c57a24c2)] - **test**: add test case to test-http-response-statuscode.js (abouthiroppy) [#10808](https://github.com/nodejs/node/pull/10808)
* [[`4a7bb5b4d1`](https://github.com/nodejs/node/commit/4a7bb5b4d1)] - **test**: improve the code in test-crypto-dh (Adrian Estrada) [#10734](https://github.com/nodejs/node/pull/10734)
* [[`825842c185`](https://github.com/nodejs/node/commit/825842c185)] - **test**: getgroups() may contain duplicate GIDs (Sam Roberts) [#10389](https://github.com/nodejs/node/pull/10389)
* [[`c6618df2cc`](https://github.com/nodejs/node/commit/c6618df2cc)] - **test**: improve test stream transform constructor (Adrian Estrada) [#10699](https://github.com/nodejs/node/pull/10699)
* [[`51f4c8bf5c`](https://github.com/nodejs/node/commit/51f4c8bf5c)] - **test**: s/assert.equal/assert.strictEqual/ (Gibson Fahnestock) [#10698](https://github.com/nodejs/node/pull/10698)
* [[`a6bd287724`](https://github.com/nodejs/node/commit/a6bd287724)] - **test**: use eslint to fix var->const/let (Gibson Fahnestock) [#10685](https://github.com/nodejs/node/pull/10685)
* [[`e6b6ce429c`](https://github.com/nodejs/node/commit/e6b6ce429c)] - **test**: refactor test-http-mutable-headers.js (cjihrig) [#10664](https://github.com/nodejs/node/pull/10664)
* [[`8262d49a44`](https://github.com/nodejs/node/commit/8262d49a44)] - **test**: refactor cluster-preload.js (abouthiroppy) [#10701](https://github.com/nodejs/node/pull/10701)
* [[`fc0551072b`](https://github.com/nodejs/node/commit/fc0551072b)] - **test**: improve test-crypto-rsa-dsa (Adrian Estrada) [#10681](https://github.com/nodejs/node/pull/10681)
* [[`727c5e3c96`](https://github.com/nodejs/node/commit/727c5e3c96)] - **test**: improve test-fs-write-file-sync (Adrian Estrada) [#10624](https://github.com/nodejs/node/pull/10624)
* [[`50130220dc`](https://github.com/nodejs/node/commit/50130220dc)] - **test**: s/assert.notEqual()/assert.notStrictEqual()/ (cjihrig) [#10541](https://github.com/nodejs/node/pull/10541)
* [[`44174a52a6`](https://github.com/nodejs/node/commit/44174a52a6)] - **test**: refactor the code in test-util-debug.js (sivaprasanna) [#10531](https://github.com/nodejs/node/pull/10531)
* [[`b1c742e107`](https://github.com/nodejs/node/commit/b1c742e107)] - **test**: improve test-fs-access (Adrian Estrada) [#10542](https://github.com/nodejs/node/pull/10542)
* [[`db7b27abb9`](https://github.com/nodejs/node/commit/db7b27abb9)] - **test**: refactor beforeExit tests (Rich Trott) [#10581](https://github.com/nodejs/node/pull/10581)
* [[`33851d1e2c`](https://github.com/nodejs/node/commit/33851d1e2c)] - **test**: fix process.title expectation (Sakthipriyan Vairamani (thefourtheye)) [#10597](https://github.com/nodejs/node/pull/10597)
* [[`af2bea70e0`](https://github.com/nodejs/node/commit/af2bea70e0)] - **test**: refactor test-beforeexit-event-exit.js (cjihrig) [#10577](https://github.com/nodejs/node/pull/10577)
* [[`0a2fb0d3e1`](https://github.com/nodejs/node/commit/0a2fb0d3e1)] - **test**: refactor several parallel/test-timer tests (Beth Griggs) [#10524](https://github.com/nodejs/node/pull/10524)
* [[`dba8d20ccc`](https://github.com/nodejs/node/commit/dba8d20ccc)] - **test**: improve the code in test-fs-read-stream (Adrian Estrada) [#10556](https://github.com/nodejs/node/pull/10556)
* [[`eba9add48e`](https://github.com/nodejs/node/commit/eba9add48e)] - **test**: refactor test-timer-close (BethGriggs) [#10517](https://github.com/nodejs/node/pull/10517)
* [[`dd9aefde69`](https://github.com/nodejs/node/commit/dd9aefde69)] - **test**: use const for all require() calls (cjihrig) [#10550](https://github.com/nodejs/node/pull/10550)
* [[`807e99b81d`](https://github.com/nodejs/node/commit/807e99b81d)] - **test**: validate errors in test-buffer-indexof (Adrian Estrada) [#10752](https://github.com/nodejs/node/pull/10752)
* [[`32da59ab18`](https://github.com/nodejs/node/commit/32da59ab18)] - **test**: fix broken assertion (cjihrig) [#10840](https://github.com/nodejs/node/pull/10840)
* [[`29a4d354bc`](https://github.com/nodejs/node/commit/29a4d354bc)] - **test**: refactor test-cli-eval.js (Sumit Goel) [#10759](https://github.com/nodejs/node/pull/10759)
* [[`a06419b045`](https://github.com/nodejs/node/commit/a06419b045)] - **test**: refactor test-stream2-readable-wrap.js (David Goussev) [#10551](https://github.com/nodejs/node/pull/10551)
* [[`55377db9b0`](https://github.com/nodejs/node/commit/55377db9b0)] - **test**: refactor test-stream-transform-object (Rich Trott) [#10588](https://github.com/nodejs/node/pull/10588)
* [[`fb35ca3598`](https://github.com/nodejs/node/commit/fb35ca3598)] - **test**: test hmac binding robustness (Sam Roberts) [#10923](https://github.com/nodejs/node/pull/10923)
* [[`94a266e1ef`](https://github.com/nodejs/node/commit/94a266e1ef)] - **test**: refactor the code in test-fs-watch.js (sivaprasanna) [#10357](https://github.com/nodejs/node/pull/10357)
* [[`3575f5159e`](https://github.com/nodejs/node/commit/3575f5159e)] - **test**: reduce unmanaged parallelism in domain test (Joyee Cheung) [#10329](https://github.com/nodejs/node/pull/10329)
* [[`7822d86ee6`](https://github.com/nodejs/node/commit/7822d86ee6)] - **test**: increase usage of assert.ifError() (cjihrig) [#10543](https://github.com/nodejs/node/pull/10543)
* [[`e161dcf1fc`](https://github.com/nodejs/node/commit/e161dcf1fc)] - **test**: add dgram.Socket.prototype.sendto's test (abouthiroppy) [#10901](https://github.com/nodejs/node/pull/10901)
* [[`be3e82dbbb`](https://github.com/nodejs/node/commit/be3e82dbbb)] - **test**: check error message in test-fs-make-callback (legalcodes) [#10914](https://github.com/nodejs/node/pull/10914)
* [[`67d97bce5a`](https://github.com/nodejs/node/commit/67d97bce5a)] - **test**: improve test-assert (richnologies) [#10916](https://github.com/nodejs/node/pull/10916)
* [[`69a04a9c7b`](https://github.com/nodejs/node/commit/69a04a9c7b)] - **test**: increase coverage for punycode's decode (abouthiroppy) [#10940](https://github.com/nodejs/node/pull/10940)
* [[`8778fca82b`](https://github.com/nodejs/node/commit/8778fca82b)] - **test**: check fd 0,1,2 are used, not access mode (John Barboza) [#10339](https://github.com/nodejs/node/pull/10339)
* [[`e80f35c973`](https://github.com/nodejs/node/commit/e80f35c973)] - **test**: verify shell option internals (cjihrig) [#10924](https://github.com/nodejs/node/pull/10924)
* [[`9d5170f850`](https://github.com/nodejs/node/commit/9d5170f850)] - **test**: fix flaky test-regress-GH-897 (Rich Trott) [#10903](https://github.com/nodejs/node/pull/10903)
* [[`c60d87b1ad`](https://github.com/nodejs/node/commit/c60d87b1ad)] - **test**: don't connect to :: (use localhost instead) (Gibson Fahnestock) [#10854](https://github.com/nodejs/node/pull/10854)
* [[`aa4b028523`](https://github.com/nodejs/node/commit/aa4b028523)] - **test**: improve test-fs-open-flags (Vinícius do Carmo)
* [[`35d665958e`](https://github.com/nodejs/node/commit/35d665958e)] - **test**: increase coverage of _http_outgoing (abouthiroppy) [#10820](https://github.com/nodejs/node/pull/10820)
* [[`c4f16949b8`](https://github.com/nodejs/node/commit/c4f16949b8)] - **test**: add message verification on assert.throws (Travis Meisenheimer) [#10890](https://github.com/nodejs/node/pull/10890)
* [[`5ce2ac800b`](https://github.com/nodejs/node/commit/5ce2ac800b)] - **test**: refactor test-repl-tab-complete (Rich Trott) [#10879](https://github.com/nodejs/node/pull/10879)
* [[`999f685a69`](https://github.com/nodejs/node/commit/999f685a69)] - **test**: simplify array initialization (Rich Trott) [#10860](https://github.com/nodejs/node/pull/10860)
* [[`c77078f29f`](https://github.com/nodejs/node/commit/c77078f29f)] - **test**: have inspector test pick an open port (Eugene Ostroukhov) [#10861](https://github.com/nodejs/node/pull/10861)
* [[`aa8771f842`](https://github.com/nodejs/node/commit/aa8771f842)] - **test**: use common.hasIntl in tests related to ICU (Daijiro Wachi) [#10841](https://github.com/nodejs/node/pull/10841)
* [[`5b38776243`](https://github.com/nodejs/node/commit/5b38776243)] - **test**: add http-common's test (abouthiroppy) [#10832](https://github.com/nodejs/node/pull/10832)
* [[`96babb2090`](https://github.com/nodejs/node/commit/96babb2090)] - **test**: tests for _readableStream.awaitDrain (Mark) [#8914](https://github.com/nodejs/node/pull/8914)
* [[`7165f1d409`](https://github.com/nodejs/node/commit/7165f1d409)] - **test**: improve the code in test-process-cpuUsage (Adrian Estrada) [#10714](https://github.com/nodejs/node/pull/10714)
* [[`b5c0b43efa`](https://github.com/nodejs/node/commit/b5c0b43efa)] - **test**: increase test-crypto.js strictness (Rich Trott) [#10784](https://github.com/nodejs/node/pull/10784)
* [[`d818cfaaad`](https://github.com/nodejs/node/commit/d818cfaaad)] - **test**: improve test-fs-write-stream-throw-type (Adrian Estrada) [#10779](https://github.com/nodejs/node/pull/10779)
* [[`77cbc26a96`](https://github.com/nodejs/node/commit/77cbc26a96)] - **test**: delete duplicate test of noAssert in readUInt* (larissayvette) [#10791](https://github.com/nodejs/node/pull/10791)
* [[`36db5a663a`](https://github.com/nodejs/node/commit/36db5a663a)] - **test**: add http_incoming's matchKnownFields test (abouthiroppy) [#10811](https://github.com/nodejs/node/pull/10811)
* [[`31d3a22989`](https://github.com/nodejs/node/commit/31d3a22989)] - **test**: skip test-icu-transcode if Intl is not present (Daijiro Wachi) [#10707](https://github.com/nodejs/node/pull/10707)
* [[`8b02b4ebb4`](https://github.com/nodejs/node/commit/8b02b4ebb4)] - **test**: check error msg test-writeint.js (Irene Li) [#10755](https://github.com/nodejs/node/pull/10755)
* [[`5aad0ccefe`](https://github.com/nodejs/node/commit/5aad0ccefe)] - **test**: no unused args test-fs-watch-file.js (istinson) [#10758](https://github.com/nodejs/node/pull/10758)
* [[`fca0da711d`](https://github.com/nodejs/node/commit/fca0da711d)] - **test**: improve tests in pummel/test-exec (Chase Starr) [#10757](https://github.com/nodejs/node/pull/10757)
* [[`7d917dcb27`](https://github.com/nodejs/node/commit/7d917dcb27)] - **test**: fix temp-dir option in tools/test.py (Gibson Fahnestock) [#10723](https://github.com/nodejs/node/pull/10723)
* [[`6b54024324`](https://github.com/nodejs/node/commit/6b54024324)] - **test**: use realpath for NODE_TEST_DIR in common.js (Gibson Fahnestock) [#10723](https://github.com/nodejs/node/pull/10723)
* [[`c6aeb4491b`](https://github.com/nodejs/node/commit/c6aeb4491b)] - **test**: fix linting for test-tls-add-ca-cert.js (Sam Roberts) [#10771](https://github.com/nodejs/node/pull/10771)
* [[`542f65c66b`](https://github.com/nodejs/node/commit/542f65c66b)] - **test**: tls cert chain completion scenarios (Sam Roberts) [#10389](https://github.com/nodejs/node/pull/10389)
* [[`97a8bd20c6`](https://github.com/nodejs/node/commit/97a8bd20c6)] - **test**: check tls server verification with addCACert (Sam Roberts) [#10389](https://github.com/nodejs/node/pull/10389)
* [[`ebcf834c14`](https://github.com/nodejs/node/commit/ebcf834c14)] - **test**: move common tls connect setup into fixtures (Sam Roberts) [#10389](https://github.com/nodejs/node/pull/10389)
* [[`30926ac6d6`](https://github.com/nodejs/node/commit/30926ac6d6)] - **test**: move resource intensive test to sequential (Rich Trott) [#10744](https://github.com/nodejs/node/pull/10744)
* [[`06a1e9eb7b`](https://github.com/nodejs/node/commit/06a1e9eb7b)] - **test**: add test for noAssert option in buf.read*() (larissayvette) [#10713](https://github.com/nodejs/node/pull/10713)
* [[`160d0381d2`](https://github.com/nodejs/node/commit/160d0381d2)] - **test**: refactor test-crypto-padding-aes256 (adelmann) [#10622](https://github.com/nodejs/node/pull/10622)
* [[`cb111c96cc`](https://github.com/nodejs/node/commit/cb111c96cc)] - **test**: refactor the code of test-keep-alive.js (sivaprasanna) [#10684](https://github.com/nodejs/node/pull/10684)
* [[`dbb7727320`](https://github.com/nodejs/node/commit/dbb7727320)] - **test**: validate 'expected' argument to mustCall() (Nathan Friedly) [#10692](https://github.com/nodejs/node/pull/10692)
* [[`e408f0a1f5`](https://github.com/nodejs/node/commit/e408f0a1f5)] - **test**: fix misplaced ) in http response statuscode test (Nathan Friedly) [#10692](https://github.com/nodejs/node/pull/10692)
* [[`4c8676bc26`](https://github.com/nodejs/node/commit/4c8676bc26)] - **test**: refactor test-doctool-html.js (abouthiroppy) [#10696](https://github.com/nodejs/node/pull/10696)
* [[`da572131db`](https://github.com/nodejs/node/commit/da572131db)] - **test**: improve the code in test-process-hrtime (Adrian Estrada) [#10667](https://github.com/nodejs/node/pull/10667)
* [[`17d9a739c1`](https://github.com/nodejs/node/commit/17d9a739c1)] - **test**: refactor test-watch-file.js (sivaprasanna) [#10679](https://github.com/nodejs/node/pull/10679)
* [[`cf5579d746`](https://github.com/nodejs/node/commit/cf5579d746)] - **test**: improve zlib-from-gzip-with-trailing-garbage (Michael Lefkowitz) [#10674](https://github.com/nodejs/node/pull/10674)
* [[`2d856097b3`](https://github.com/nodejs/node/commit/2d856097b3)] - **test**: refactor the code in test-child-process-spawn-loop.js (sivaprasanna) [#10605](https://github.com/nodejs/node/pull/10605)
* [[`1329eb47f0`](https://github.com/nodejs/node/commit/1329eb47f0)] - **test**: allow testing uid and gid separately (cjihrig) [#10647](https://github.com/nodejs/node/pull/10647)
* [[`4aa32c196a`](https://github.com/nodejs/node/commit/4aa32c196a)] - **test**: improve code in test-https-strict (Adrian Estrada) [#10648](https://github.com/nodejs/node/pull/10648)
* [[`e78de99bcb`](https://github.com/nodejs/node/commit/e78de99bcb)] - **test**: improve test-http-chunked-304 (Adrian Estrada) [#10462](https://github.com/nodejs/node/pull/10462)
* [[`ff23d8112a`](https://github.com/nodejs/node/commit/ff23d8112a)] - **test**: improve test-fs-readfile-zero-byte-liar (Adrian Estrada) [#10570](https://github.com/nodejs/node/pull/10570)
* [[`38bdfb0b8e`](https://github.com/nodejs/node/commit/38bdfb0b8e)] - **test**: refactor test-fs-utimes (Junshu Okamoto) [#9290](https://github.com/nodejs/node/pull/9290)
* [[`09f35a49e3`](https://github.com/nodejs/node/commit/09f35a49e3)] - **test**: provide duration/interval to timers (Rich Trott) [#9472](https://github.com/nodejs/node/pull/9472)
* [[`06a82436c2`](https://github.com/nodejs/node/commit/06a82436c2)] - **test**: improve test-event-emitter-modify-in-emit (Adrian Estrada) [#10600](https://github.com/nodejs/node/pull/10600)
* [[`736b95a617`](https://github.com/nodejs/node/commit/736b95a617)] - **test**: check error and cleanups in test-fs-read-buffer (Anna Henningsen) [#10611](https://github.com/nodejs/node/pull/10611)
* [[`a77940c2d5`](https://github.com/nodejs/node/commit/a77940c2d5)] - **test**: mark test-tty-wrap as flaky for AIX (Michael Dawson) [#10618](https://github.com/nodejs/node/pull/10618)
* [[`cf875d17f3`](https://github.com/nodejs/node/commit/cf875d17f3)] - **test**: improve test-fs-null-bytes (Adrian Estrada) [#10521](https://github.com/nodejs/node/pull/10521)
* [[`656ba86a27`](https://github.com/nodejs/node/commit/656ba86a27)] - **test**: fix Coverity warning in inspector test (Eugene Ostroukhov) [#10510](https://github.com/nodejs/node/pull/10510)
* [[`9916ee8c36`](https://github.com/nodejs/node/commit/9916ee8c36)] - **test**: refactor test-https-truncate (Rich Trott) [#10225](https://github.com/nodejs/node/pull/10225)
* [[`4ff1d3107f`](https://github.com/nodejs/node/commit/4ff1d3107f)] - **test**: add http.ClientRequest defaults test (Brian White) [#10654](https://github.com/nodejs/node/pull/10654)
* [[`1555ced404`](https://github.com/nodejs/node/commit/1555ced404)] - **test, win**: fix up symlink tests (Hitesh Kanwathirtha) [#10477](https://github.com/nodejs/node/pull/10477)
* [[`4323c8018e`](https://github.com/nodejs/node/commit/4323c8018e)] - **test,cluster**: add test-cluster-worker-deprecated (Rich Trott) [#10675](https://github.com/nodejs/node/pull/10675)
* [[`33af09fe6a`](https://github.com/nodejs/node/commit/33af09fe6a)] - **test,net**: add tests for server.connections (Rich Trott) [#10762](https://github.com/nodejs/node/pull/10762)
* [[`fc2db50021`](https://github.com/nodejs/node/commit/fc2db50021)] - **test,repl**: add coverage for repl .clear+useGlobal (Rich Trott) [#10777](https://github.com/nodejs/node/pull/10777)
* [[`84bf04b0c1`](https://github.com/nodejs/node/commit/84bf04b0c1)] - **test,util**: remove lint workarounds (Rich Trott) [#10785](https://github.com/nodejs/node/pull/10785)
* [[`c6af766ad9`](https://github.com/nodejs/node/commit/c6af766ad9)] - **test-console**: streamline arrow fn and refine regex (John Maguire) [#11039](https://github.com/nodejs/node/pull/11039)
* [[`8fae9d4cfb`](https://github.com/nodejs/node/commit/8fae9d4cfb)] - **tools**: rename eslintrc to an undeprecated format (Sakthipriyan Vairamani) [#7699](https://github.com/nodejs/node/pull/7699)
* [[`dd5a4e1d75`](https://github.com/nodejs/node/commit/dd5a4e1d75)] - **tools**: update ESLint to current version (Rich Trott) [#10561](https://github.com/nodejs/node/pull/10561)
* [[`c92b8ecd81`](https://github.com/nodejs/node/commit/c92b8ecd81)] - **(SEMVER-MINOR)** **tools**: add mdn link for Iterator (James M Snell) [#10620](https://github.com/nodejs/node/pull/10620)
* [[`dec5900c42`](https://github.com/nodejs/node/commit/dec5900c42)] - **tools**: add lint rule to enforce timer arguments (Rich Trott) [#9472](https://github.com/nodejs/node/pull/9472)
* [[`891874406a`](https://github.com/nodejs/node/commit/891874406a)] - **tools**: remove no-useless-regex-char-class-escape (Rich Trott) [#10561](https://github.com/nodejs/node/pull/10561)
* [[`1634a7017e`](https://github.com/nodejs/node/commit/1634a7017e)] - **tools**: remove custom align-function-arguments rule (Rich Trott) [#10561](https://github.com/nodejs/node/pull/10561)
* [[`31f8f6f768`](https://github.com/nodejs/node/commit/31f8f6f768)] - **tools, test**: require const/let in test (Gibson Fahnestock) [#10685](https://github.com/nodejs/node/pull/10685)
* [[`d39543e73d`](https://github.com/nodejs/node/commit/d39543e73d)] - **tools,doc**: add Google Analytics tracking. (Phillip Johnsen) [#6601](https://github.com/nodejs/node/pull/6601)
* [[`3adda4b2ad`](https://github.com/nodejs/node/commit/3adda4b2ad)] - **tools,test**: enforce assert.ifError with lint rule (Teddy Katz) [#10671](https://github.com/nodejs/node/pull/10671)
* [[`438a98ca95`](https://github.com/nodejs/node/commit/438a98ca95)] - **url**: make URLSearchParams/Iterator match spec (Timothy Gu) [#11057](https://github.com/nodejs/node/pull/11057)
* [[`2bfd58adb1`](https://github.com/nodejs/node/commit/2bfd58adb1)] - **url**: define @@toStringTag as a data property (Timothy Gu) [#10906](https://github.com/nodejs/node/pull/10906)
* [[`f1851cb8e4`](https://github.com/nodejs/node/commit/f1851cb8e4)] - **url**: do not public expose inspect methods on URL (Timothy Gu) [#10906](https://github.com/nodejs/node/pull/10906)
* [[`b48b80f630`](https://github.com/nodejs/node/commit/b48b80f630)] - **url**: stop exporting originFor() (Timothy Gu) [#10955](https://github.com/nodejs/node/pull/10955)
* [[`c0c1a4c029`](https://github.com/nodejs/node/commit/c0c1a4c029)] - **url**: refactor lib/internal/url.js (Rich Trott) [#10912](https://github.com/nodejs/node/pull/10912)
* [[`2f9fdc454f`](https://github.com/nodejs/node/commit/2f9fdc454f)] - **(SEMVER-MINOR)** **url**: allow use of URL with http.request and https.request (James M Snell) [#10638](https://github.com/nodejs/node/pull/10638)
* [[`95faa55ab9`](https://github.com/nodejs/node/commit/95faa55ab9)] - **url**: check forEach callback is a function (Timothy Gu) [#10905](https://github.com/nodejs/node/pull/10905)
* [[`3642f35d09`](https://github.com/nodejs/node/commit/3642f35d09)] - **url**: add return value to ToUnicode/ToAscii stubs (Birunthan Mohanathas) [#10893](https://github.com/nodejs/node/pull/10893)
* [[`021338dc6d`](https://github.com/nodejs/node/commit/021338dc6d)] - **url**: export URLSearchParams (Timothy Gu)
* [[`5d33c96679`](https://github.com/nodejs/node/commit/5d33c96679)] - **url**: improving URLSearchParams (Timothy Gu) [#10399](https://github.com/nodejs/node/pull/10399)
* [[`824978e337`](https://github.com/nodejs/node/commit/824978e337)] - **url**: do not decode arbitrary %2e sequences in paths (James M Snell) [#10602](https://github.com/nodejs/node/pull/10602)
* [[`e46bdcf2bb`](https://github.com/nodejs/node/commit/e46bdcf2bb)] - **url**: change null password handling (James M Snell) [#10601](https://github.com/nodejs/node/pull/10601)
* [[`2b01138451`](https://github.com/nodejs/node/commit/2b01138451)] - **url**: TupleOrigin#toString use unicode by default (Joyee Cheung) [#10552](https://github.com/nodejs/node/pull/10552)
* [[`9f6d1f6fc2`](https://github.com/nodejs/node/commit/9f6d1f6fc2)] - **util**: improve readability of normalizeEncoding (Joyee Cheung) [#10439](https://github.com/nodejs/node/pull/10439)
* [[`d628f3a227`](https://github.com/nodejs/node/commit/d628f3a227)] - **util**: avoid out-of-bounds arguments index access (Teddy Katz) [#10569](https://github.com/nodejs/node/pull/10569)
* [[`2641cd496d`](https://github.com/nodejs/node/commit/2641cd496d)] - **vm**: improve performance of vm.runIn*() (Rich Trott) [#10816](https://github.com/nodejs/node/pull/10816)

<a id="7.4.0"></a>
## 2017-01-04, Version 7.4.0 (Current), @evanlucas

### Notable changes

* **buffer**:
  * Improve performance of Buffer allocation by ~11%. (Brian White) [#10443](https://github.com/nodejs/node/pull/10443)
  * Improve performance of Buffer.from() by ~50%. (Brian White) [#10443](https://github.com/nodejs/node/pull/10443)
* **events**: Improve performance of `EventEmitter.once()` by ~27%. (Brian White) [#10445](https://github.com/nodejs/node/pull/10445)
* **fs**: Allow passing Uint8Array to fs methods where Buffers are supported. (Anna Henningsen) [#10382](https://github.com/nodejs/node/pull/10382)
* **http**: Improve performance of http server by ~7%. (Brian White) [#6533](https://github.com/nodejs/node/pull/6533)
* **npm**: Upgrade to v4.0.5 (Kat Marchán) [#10330](https://github.com/nodejs/node/pull/10330)

### Commits

* [[`d1843ec3a7`](https://github.com/nodejs/node/commit/d1843ec3a7)] - **async_wrap**: clear destroy_ids vector (Trevor Norris) [#10400](https://github.com/nodejs/node/pull/10400)
* [[`6a4e6e9a42`](https://github.com/nodejs/node/commit/6a4e6e9a42)] - **benchmark**: allow benchmarks to specify flags (Joyee Cheung) [#10448](https://github.com/nodejs/node/pull/10448)
* [[`0b2bc5e27b`](https://github.com/nodejs/node/commit/0b2bc5e27b)] - **benchmark**: add benchmark for WHATWG URL properties (Joyee Cheung) [#10408](https://github.com/nodejs/node/pull/10408)
* [[`10b3297e8f`](https://github.com/nodejs/node/commit/10b3297e8f)] - **benchmark**: use commas in non-csv rate output (Brian White) [#10360](https://github.com/nodejs/node/pull/10360)
* [[`6d15e7b528`](https://github.com/nodejs/node/commit/6d15e7b528)] - **benchmark**: refactor buffer benchmarks (Troy Connor) [#10175](https://github.com/nodejs/node/pull/10175)
* [[`797495a84a`](https://github.com/nodejs/node/commit/797495a84a)] - **buffer**: improve allocation performance (Brian White) [#10443](https://github.com/nodejs/node/pull/10443)
* [[`ad5ae922ce`](https://github.com/nodejs/node/commit/ad5ae922ce)] - **build**: add /opt/freeware/... to AIX library path (Stewart X Addison) [#10128](https://github.com/nodejs/node/pull/10128)
* [[`cff57be2b6`](https://github.com/nodejs/node/commit/cff57be2b6)] - **build**: add (not) cross-compiled configure flags (Jesús Leganés-Combarro 'piranna) [#10287](https://github.com/nodejs/node/pull/10287)
* [[`80e798e324`](https://github.com/nodejs/node/commit/80e798e324)] - **crypto**: use CHECK_NE instead of ABORT or abort (Sam Roberts) [#10413](https://github.com/nodejs/node/pull/10413)
* [[`92eacdb5c6`](https://github.com/nodejs/node/commit/92eacdb5c6)] - **(SEMVER-MINOR)** **deps**: upgrade npm to 4.0.5 (Kat Marchán) [#10330](https://github.com/nodejs/node/pull/10330)
* [[`785975d922`](https://github.com/nodejs/node/commit/785975d922)] - **deps**: ICU 58.2 bump download URL (Steven R. Loomis) [#10206](https://github.com/nodejs/node/pull/10206)
* [[`bce0013dd8`](https://github.com/nodejs/node/commit/bce0013dd8)] - **deps**: ICU 58.2 bump (Steven R. Loomis) [#10206](https://github.com/nodejs/node/pull/10206)
* [[`dcc20f12a6`](https://github.com/nodejs/node/commit/dcc20f12a6)] - **doc**: clarify the statement in vm.createContext() (AnnaMag) [#10519](https://github.com/nodejs/node/pull/10519)
* [[`8e78953c88`](https://github.com/nodejs/node/commit/8e78953c88)] - **doc**: add joyeecheung to collaborators (Joyee Cheung) [#10603](https://github.com/nodejs/node/pull/10603)
* [[`d08463a9e3`](https://github.com/nodejs/node/commit/d08463a9e3)] - **doc**: unify dirname and filename description (Sam Roberts) [#10527](https://github.com/nodejs/node/pull/10527)
* [[`7ad0f7bc32`](https://github.com/nodejs/node/commit/7ad0f7bc32)] - **doc**: redirect 'Start a Working Group' to TSC repo (William Kapke) [#9655](https://github.com/nodejs/node/pull/9655)
* [[`deb0917f76`](https://github.com/nodejs/node/commit/deb0917f76)] - **doc**: warn about unvalidated input in child_process (Matthew Garrett) [#10466](https://github.com/nodejs/node/pull/10466)
* [[`96c3c65a86`](https://github.com/nodejs/node/commit/96c3c65a86)] - **doc**: require two-factor authentication (Rich Trott) [#10529](https://github.com/nodejs/node/pull/10529)
* [[`a7c12fef6c`](https://github.com/nodejs/node/commit/a7c12fef6c)] - **doc**: add Working Group dissolution text (William Kapke) [#9656](https://github.com/nodejs/node/pull/9656)
* [[`e86bf27fe8`](https://github.com/nodejs/node/commit/e86bf27fe8)] - **doc**: improve rinfo object documentation (Matt Crummey) [#10050](https://github.com/nodejs/node/pull/10050)
* [[`5b7b457643`](https://github.com/nodejs/node/commit/5b7b457643)] - **doc**: add tls.DEFAULT_ECDH_CURVE (Sam Roberts) [#10264](https://github.com/nodejs/node/pull/10264)
* [[`cf3f75f6f0`](https://github.com/nodejs/node/commit/cf3f75f6f0)] - **doc**: fixup errors in stream.md (Fumiya KARASAWA) [#10411](https://github.com/nodejs/node/pull/10411)
* [[`89fb82214f`](https://github.com/nodejs/node/commit/89fb82214f)] - **doc**: use "Node.js" in V8 guide (Rich Trott) [#10438](https://github.com/nodejs/node/pull/10438)
* [[`aabaef0aa7`](https://github.com/nodejs/node/commit/aabaef0aa7)] - **doc**: more efficient example in the console.md (Vse Mozhet Byt) [#10451](https://github.com/nodejs/node/pull/10451)
* [[`3d181ce4fd`](https://github.com/nodejs/node/commit/3d181ce4fd)] - **doc**: var -> const / let in the console.md (Vse Mozhet Byt) [#10451](https://github.com/nodejs/node/pull/10451)
* [[`9ce28ec3c5`](https://github.com/nodejs/node/commit/9ce28ec3c5)] - **doc**: add the valid link for curl(1) in repl.md (Vse Mozhet Byt) [#10244](https://github.com/nodejs/node/pull/10244)
* [[`cffbfba4df`](https://github.com/nodejs/node/commit/cffbfba4df)] - **doc**: replace anonymous functions in repl.md (Vse Mozhet Byt) [#10244](https://github.com/nodejs/node/pull/10244)
* [[`f281b190d5`](https://github.com/nodejs/node/commit/f281b190d5)] - **doc**: fix a function name in repl.md (Vse Mozhet Byt) [#10244](https://github.com/nodejs/node/pull/10244)
* [[`b8e2711ddd`](https://github.com/nodejs/node/commit/b8e2711ddd)] - **doc**: fix an output example in repl.md (Vse Mozhet Byt) [#10244](https://github.com/nodejs/node/pull/10244)
* [[`ae61232493`](https://github.com/nodejs/node/commit/ae61232493)] - **doc**: white space unification in repl.md (Vse Mozhet Byt) [#10244](https://github.com/nodejs/node/pull/10244)
* [[`37cb971c65`](https://github.com/nodejs/node/commit/37cb971c65)] - **doc**: var => let / const in repl.md (Vse Mozhet Byt) [#10244](https://github.com/nodejs/node/pull/10244)
* [[`6f8c6133e3`](https://github.com/nodejs/node/commit/6f8c6133e3)] - **doc**: update CONTRIBUTING.MD with link to V8 guide (sarahmeyer) [#10070](https://github.com/nodejs/node/pull/10070)
* [[`8a9d68ad7c`](https://github.com/nodejs/node/commit/8a9d68ad7c)] - **doc**: improve common.mustCall() explanation (Rich Trott) [#10390](https://github.com/nodejs/node/pull/10390)
* [[`4365bb45b8`](https://github.com/nodejs/node/commit/4365bb45b8)] - **doc**: consistent 'Returns:' part two (Myles Borins) [#10391](https://github.com/nodejs/node/pull/10391)
* [[`21fca4bdda`](https://github.com/nodejs/node/commit/21fca4bdda)] - **doc**: require() tries first core not native modules (Vicente Jimenez Aguilar) [#10324](https://github.com/nodejs/node/pull/10324)
* [[`6284d83092`](https://github.com/nodejs/node/commit/6284d83092)] - **doc**: clarify macosx-firewall suggestion BUILDING (Chase Starr) [#10311](https://github.com/nodejs/node/pull/10311)
* [[`0c4cf24f70`](https://github.com/nodejs/node/commit/0c4cf24f70)] - **doc**: update process.versions.modules documentation (Kevin Zurawel) [#9901](https://github.com/nodejs/node/pull/9901)
* [[`b67879f6f4`](https://github.com/nodejs/node/commit/b67879f6f4)] - **doc**: clarify the review and landing process (Joyee Cheung) [#10202](https://github.com/nodejs/node/pull/10202)
* [[`9044423bb6`](https://github.com/nodejs/node/commit/9044423bb6)] - **doc**: modernize code examples in the cluster.md (Vse Mozhet Byt) [#10270](https://github.com/nodejs/node/pull/10270)
* [[`2eec9afdb1`](https://github.com/nodejs/node/commit/2eec9afdb1)] - **doc**: add Michaël Zasso to the CTC (Michaël Zasso)
* [[`85d2a2abcf`](https://github.com/nodejs/node/commit/85d2a2abcf)] - **doc**: update writable.write return value (Tanuja-Sawant) [#9468](https://github.com/nodejs/node/pull/9468)
* [[`37563fafca`](https://github.com/nodejs/node/commit/37563fafca)] - **doc**: fix broken link in COLLABORATOR_GUIDE.md (Emanuel Buholzer) [#10337](https://github.com/nodejs/node/pull/10337)
* [[`f9a5c13ff3`](https://github.com/nodejs/node/commit/f9a5c13ff3)] - **dtrace**: resolve conversion warnings from SLURP_INT (Christopher J. Brody) [#10143](https://github.com/nodejs/node/pull/10143)
* [[`bc379fda75`](https://github.com/nodejs/node/commit/bc379fda75)] - **events**: optimize arrayClone by copying forward (Benedikt Meurer) [#10571](https://github.com/nodejs/node/pull/10571)
* [[`7ece950ffe`](https://github.com/nodejs/node/commit/7ece950ffe)] - **events**: improve once() performance (Brian White) [#10445](https://github.com/nodejs/node/pull/10445)
* [[`6629f8f83f`](https://github.com/nodejs/node/commit/6629f8f83f)] - **fs**: cache non-symlinks in realpathSync. (Jeremy Yallop) [#10253](https://github.com/nodejs/node/pull/10253)
* [[`abde7644a5`](https://github.com/nodejs/node/commit/abde7644a5)] - **(SEMVER-MINOR)** **fs**: support Uint8Array input to methods (Anna Henningsen) [#10382](https://github.com/nodejs/node/pull/10382)
* [[`32b6bcdd83`](https://github.com/nodejs/node/commit/32b6bcdd83)] - **http**: optimize headers iteration (Brian White) [#6533](https://github.com/nodejs/node/pull/6533)
* [[`a760d707ad`](https://github.com/nodejs/node/commit/a760d707ad)] - **http**: simplify boolean checks (Brian White) [#6533](https://github.com/nodejs/node/pull/6533)
* [[`c8ad127abc`](https://github.com/nodejs/node/commit/c8ad127abc)] - **http**: extract validation functions (Brian White) [#6533](https://github.com/nodejs/node/pull/6533)
* [[`8a2a763f13`](https://github.com/nodejs/node/commit/8a2a763f13)] - **http**: improve validation performance (Brian White) [#6533](https://github.com/nodejs/node/pull/6533)
* [[`df8b8b257d`](https://github.com/nodejs/node/commit/df8b8b257d)] - **http**: refactor server connection handling (Brian White) [#6533](https://github.com/nodejs/node/pull/6533)
* [[`1f0fd7b35d`](https://github.com/nodejs/node/commit/1f0fd7b35d)] - **http**: misc cleanup and minor optimizations (Brian White) [#6533](https://github.com/nodejs/node/pull/6533)
* [[`b094b49659`](https://github.com/nodejs/node/commit/b094b49659)] - **http**: reuse existing headers array for raw values (Brian White) [#6533](https://github.com/nodejs/node/pull/6533)
* [[`4bed9475d1`](https://github.com/nodejs/node/commit/4bed9475d1)] - **inspector**: fix Coverity defects (Eugene Ostroukhov) [#10240](https://github.com/nodejs/node/pull/10240)
* [[`023956187e`](https://github.com/nodejs/node/commit/023956187e)] - **inspector**: split HTTP/WS server from the inspector (Eugene Ostroukhov) [#9630](https://github.com/nodejs/node/pull/9630)
* [[`aed5e27451`](https://github.com/nodejs/node/commit/aed5e27451)] - **lib**: avoid recompilation of anonymous functions (Brian White) [#6533](https://github.com/nodejs/node/pull/6533)
* [[`064607be58`](https://github.com/nodejs/node/commit/064607be58)] - **meta**: modify pull request template for prepending (Rich Trott) [#10484](https://github.com/nodejs/node/pull/10484)
* [[`75efdeb635`](https://github.com/nodejs/node/commit/75efdeb635)] - **os**: fix os.release() for aix and add test (jBarz) [#10245](https://github.com/nodejs/node/pull/10245)
* [[`6796bf4829`](https://github.com/nodejs/node/commit/6796bf4829)] - **repl**: allow autocompletion for scoped packages (Evan Lucas) [#10296](https://github.com/nodejs/node/pull/10296)
* [[`11ed8007df`](https://github.com/nodejs/node/commit/11ed8007df)] - **src**: describe what NODE_MODULE_VERSION is for (Sam Roberts) [#10414](https://github.com/nodejs/node/pull/10414)
* [[`5e5b1f8b89`](https://github.com/nodejs/node/commit/5e5b1f8b89)] - **src**: return early if nextTickQueue is empty (Trevor Norris) [#10274](https://github.com/nodejs/node/pull/10274)
* [[`5852336207`](https://github.com/nodejs/node/commit/5852336207)] - **test**: add tests for clearBuffer state machine (Safia Abdalla) [#9922](https://github.com/nodejs/node/pull/9922)
* [[`6ec798bdd6`](https://github.com/nodejs/node/commit/6ec798bdd6)] - **test**: update test-cluster-shared-handle-bind-error (cjihrig) [#10547](https://github.com/nodejs/node/pull/10547)
* [[`32401b5069`](https://github.com/nodejs/node/commit/32401b5069)] - **test**: avoid assigning this to variables (cjihrig) [#10548](https://github.com/nodejs/node/pull/10548)
* [[`e1fbd72ae7`](https://github.com/nodejs/node/commit/e1fbd72ae7)] - **test**: s/ASSERT/assert/ (cjihrig) [#10544](https://github.com/nodejs/node/pull/10544)
* [[`05b0092230`](https://github.com/nodejs/node/commit/05b0092230)] - **test**: refactor test-debugger-remote (Sakthipriyan Vairamani (thefourtheye)) [#10455](https://github.com/nodejs/node/pull/10455)
* [[`82575f9341`](https://github.com/nodejs/node/commit/82575f9341)] - **test**: refactor test-stream-unshift-read-race (Rich Trott) [#10532](https://github.com/nodejs/node/pull/10532)
* [[`4d984ecadb`](https://github.com/nodejs/node/commit/4d984ecadb)] - **test**: refactor test-stream-pipe-error-handling (Rich Trott) [#10530](https://github.com/nodejs/node/pull/10530)
* [[`2619236212`](https://github.com/nodejs/node/commit/2619236212)] - **test**: refactor test-tls-alert-handling (Rich Trott) [#10482](https://github.com/nodejs/node/pull/10482)
* [[`8ac9d07805`](https://github.com/nodejs/node/commit/8ac9d07805)] - **test**: fix flaky test-http-client-timeout-with-data (Rich Trott) [#10431](https://github.com/nodejs/node/pull/10431)
* [[`ef5a43a0e3`](https://github.com/nodejs/node/commit/ef5a43a0e3)] - **test**: improve test-http-allow-req-after-204-res (Adrian Estrada) [#10503](https://github.com/nodejs/node/pull/10503)
* [[`4a16f9b054`](https://github.com/nodejs/node/commit/4a16f9b054)] - **test**: improve test-fs-empty-readStream.js (Adrian Estrada) [#10479](https://github.com/nodejs/node/pull/10479)
* [[`5fc93ee841`](https://github.com/nodejs/node/commit/5fc93ee841)] - **test**: refactor the code in test-http-connect (Adrian Estrada) [#10397](https://github.com/nodejs/node/pull/10397)
* [[`78e8aa81c9`](https://github.com/nodejs/node/commit/78e8aa81c9)] - **test**: refactor test-stream-pipe-after-end (Rich Trott) [#10483](https://github.com/nodejs/node/pull/10483)
* [[`0a0c190db5`](https://github.com/nodejs/node/commit/0a0c190db5)] - **test**: use strictEqual in test-http-server (Fabrice Tatieze) [#10478](https://github.com/nodejs/node/pull/10478)
* [[`04d82a5122`](https://github.com/nodejs/node/commit/04d82a5122)] - **test**: refactor test-stdin-from-file (Rob Adelmann) [#10331](https://github.com/nodejs/node/pull/10331)
* [[`00f791af74`](https://github.com/nodejs/node/commit/00f791af74)] - **test**: refactor test-stream2-unpipe-drain (Chris Story) [#10033](https://github.com/nodejs/node/pull/10033)
* [[`eb1adbb48e`](https://github.com/nodejs/node/commit/eb1adbb48e)] - **test**: refactor the code in test-dns-ipv4 (Adrian Estrada) [#10200](https://github.com/nodejs/node/pull/10200)
* [[`dff48af67f`](https://github.com/nodejs/node/commit/dff48af67f)] - **test**: add regex to text-crypto-random (Nate) [#10020](https://github.com/nodejs/node/pull/10020)
* [[`5164b56224`](https://github.com/nodejs/node/commit/5164b56224)] - **test**: add test for SIGWINCH handling by stdio.js (Sarah Meyer) [#10063](https://github.com/nodejs/node/pull/10063)
* [[`1aa3ab1ec6`](https://github.com/nodejs/node/commit/1aa3ab1ec6)] - **test**: refactor the code in test-fs-chmod (Adrian Estrada) [#10440](https://github.com/nodejs/node/pull/10440)
* [[`4f1d9452de`](https://github.com/nodejs/node/commit/4f1d9452de)] - **test**: swap var for let/const throughout (Paul Graham) [#10177](https://github.com/nodejs/node/pull/10177)
* [[`f6ed233546`](https://github.com/nodejs/node/commit/f6ed233546)] - **test**: improve the code in test-pipe.js (Adrian Estrada) [#10452](https://github.com/nodejs/node/pull/10452)
* [[`011bd4675a`](https://github.com/nodejs/node/commit/011bd4675a)] - **test**: improve code in test-fs-readfile-error (Adrian Estrada) [#10367](https://github.com/nodejs/node/pull/10367)
* [[`98fcb221d5`](https://github.com/nodejs/node/commit/98fcb221d5)] - **test**: improve code in test-vm-preserves-property (Adrian Estrada) [#10428](https://github.com/nodejs/node/pull/10428)
* [[`cdf028c5a6`](https://github.com/nodejs/node/commit/cdf028c5a6)] - **test**: improve code in test-vm-symbols (Adrian Estrada) [#10429](https://github.com/nodejs/node/pull/10429)
* [[`94a894acf2`](https://github.com/nodejs/node/commit/94a894acf2)] - **test**: fix and improve debugger-client test (Sakthipriyan Vairamani (thefourtheye)) [#10371](https://github.com/nodejs/node/pull/10371)
* [[`d4c888df88`](https://github.com/nodejs/node/commit/d4c888df88)] - **test**: basic functionality of readUIntLE() (larissayvette) [#10359](https://github.com/nodejs/node/pull/10359)
* [[`a5b8d097c5`](https://github.com/nodejs/node/commit/a5b8d097c5)] - **test**: clean up repl-reset-event file (Kailean Courtney) [#9931](https://github.com/nodejs/node/pull/9931)
* [[`599a2a956b`](https://github.com/nodejs/node/commit/599a2a956b)] - **test**: refactor test-child-process-ipc (malen) [#9990](https://github.com/nodejs/node/pull/9990)
* [[`d33e560929`](https://github.com/nodejs/node/commit/d33e560929)] - **test**: fix and improve debug-break-on-uncaught (Sakthipriyan Vairamani (thefourtheye)) [#10370](https://github.com/nodejs/node/pull/10370)
* [[`9349f086d9`](https://github.com/nodejs/node/commit/9349f086d9)] - **test**: refactor test-internal-modules (Christy Leung) [#10016](https://github.com/nodejs/node/pull/10016)
* [[`2ad9faa19e`](https://github.com/nodejs/node/commit/2ad9faa19e)] - **test**: add second argument to assert.throws() (Ken Russo) [#9987](https://github.com/nodejs/node/pull/9987)
* [[`4bfd9c0a35`](https://github.com/nodejs/node/commit/4bfd9c0a35)] - **test**: refactor test-pipe-file-to-http (Josh Mays) [#10054](https://github.com/nodejs/node/pull/10054)
* [[`1b9f548e7d`](https://github.com/nodejs/node/commit/1b9f548e7d)] - **test**: refactor test-tls-interleave (Brian Chirgwin) [#10017](https://github.com/nodejs/node/pull/10017)
* [[`db3ac5d6e7`](https://github.com/nodejs/node/commit/db3ac5d6e7)] - **test**: refactor test-tls-client-getephemeralkeyinfo (Harish Tejwani) [#9954](https://github.com/nodejs/node/pull/9954)
* [[`bbe618d3e2`](https://github.com/nodejs/node/commit/bbe618d3e2)] - **test**: refactor test-cluster-send-handle-twice.js (Amar Zavery) [#10049](https://github.com/nodejs/node/pull/10049)
* [[`5d64f3d76f`](https://github.com/nodejs/node/commit/5d64f3d76f)] - **test**: update test-tls-check-server-identity.js (Kevin Cox) [#9986](https://github.com/nodejs/node/pull/9986)
* [[`e6702d6d9b`](https://github.com/nodejs/node/commit/e6702d6d9b)] - **test**: fix flaky test-https-timeout (Rich Trott) [#10404](https://github.com/nodejs/node/pull/10404)
* [[`44f4d6001f`](https://github.com/nodejs/node/commit/44f4d6001f)] - **test**: improve test-cluster-net-listen.js (Rico Cai) [#9953](https://github.com/nodejs/node/pull/9953)
* [[`d3bef30b5f`](https://github.com/nodejs/node/commit/d3bef30b5f)] - **test**: refactor test-child-process-stdin (Segu Riluvan) [#10420](https://github.com/nodejs/node/pull/10420)
* [[`e9b2325d68`](https://github.com/nodejs/node/commit/e9b2325d68)] - **test**: test error messages in test-dns-regress-7070 (Wallace Zhang) [#10058](https://github.com/nodejs/node/pull/10058)
* [[`826decf8e5`](https://github.com/nodejs/node/commit/826decf8e5)] - **test**: basic functionality of readUIntBE() (larissayvette) [#10417](https://github.com/nodejs/node/pull/10417)
* [[`91a2dc216d`](https://github.com/nodejs/node/commit/91a2dc216d)] - **test**: improve test-cluster-worker-constructor.js (Adrian Estrada) [#10396](https://github.com/nodejs/node/pull/10396)
* [[`a82be5d44c`](https://github.com/nodejs/node/commit/a82be5d44c)] - **test**: refactor test-init.js (Sakthipriyan Vairamani (thefourtheye)) [#10384](https://github.com/nodejs/node/pull/10384)
* [[`ed76bfa7ba`](https://github.com/nodejs/node/commit/ed76bfa7ba)] - **test**: refactor code in test-cluster-http-pipe (Adrian Estrada) [#10297](https://github.com/nodejs/node/pull/10297)
* [[`9a0711d37f`](https://github.com/nodejs/node/commit/9a0711d37f)] - **test**: improve code in test-http-bind-twice.js (Adrian Estrada) [#10318](https://github.com/nodejs/node/pull/10318)
* [[`9d0220c4de`](https://github.com/nodejs/node/commit/9d0220c4de)] - **test**: fix linter error in whatwg-url-parsing (Sakthipriyan Vairamani (thefourtheye)) [#10421](https://github.com/nodejs/node/pull/10421)
* [[`bee7d7e32c`](https://github.com/nodejs/node/commit/bee7d7e32c)] - **test**: change var declarations, add mustCall check (Daniel Sims) [#9962](https://github.com/nodejs/node/pull/9962)
* [[`a2ec794d3b`](https://github.com/nodejs/node/commit/a2ec794d3b)] - **test**: added validation regex argument to test (Avery, Frank) [#9918](https://github.com/nodejs/node/pull/9918)
* [[`14826d0569`](https://github.com/nodejs/node/commit/14826d0569)] - **test**: refactoring test-cluster-worker-constructor (Christopher Rokita) [#9956](https://github.com/nodejs/node/pull/9956)
* [[`274eef4da0`](https://github.com/nodejs/node/commit/274eef4da0)] - **test**: refactoring test-pipe-head (Travis Bretton) [#10036](https://github.com/nodejs/node/pull/10036)
* [[`7c406e819b`](https://github.com/nodejs/node/commit/7c406e819b)] - **test**: refactor test-stdin-script-child (Emanuel Buholzer) [#10321](https://github.com/nodejs/node/pull/10321)
* [[`501165f0c1`](https://github.com/nodejs/node/commit/501165f0c1)] - **test**: fix timers-same-timeout-wrong-list-deleted (Rich Trott) [#10362](https://github.com/nodejs/node/pull/10362)
* [[`ba63363512`](https://github.com/nodejs/node/commit/ba63363512)] - **test**: refactor test-stream2-writable (Rich Trott) [#10353](https://github.com/nodejs/node/pull/10353)
* [[`a5a738cca7`](https://github.com/nodejs/node/commit/a5a738cca7)] - **test**: refactor test-tls-0-dns-altname (Richard Karmazin) [#9948](https://github.com/nodejs/node/pull/9948)
* [[`12a3b189da`](https://github.com/nodejs/node/commit/12a3b189da)] - **test**: refactor test-cluster-net-listen (Segu Riluvan) [#10047](https://github.com/nodejs/node/pull/10047)
* [[`18a75a085d`](https://github.com/nodejs/node/commit/18a75a085d)] - **test**: test: refactor test-sync-fileread (Jason Wohlgemuth) [#9941](https://github.com/nodejs/node/pull/9941)
* [[`815b5bdcf4`](https://github.com/nodejs/node/commit/815b5bdcf4)] - **test**: change assert.strict to assert.strictEqual() (Ashita Nagesh) [#9988](https://github.com/nodejs/node/pull/9988)
* [[`f1cc0a4d26`](https://github.com/nodejs/node/commit/f1cc0a4d26)] - **test**: add regex check in test-buffer-bad-overload (Sam Shull) [#10038](https://github.com/nodejs/node/pull/10038)
* [[`0684211d12`](https://github.com/nodejs/node/commit/0684211d12)] - **test**: refactor the code in test-http-keep-alive (Adrian Estrada) [#10350](https://github.com/nodejs/node/pull/10350)
* [[`a815a23631`](https://github.com/nodejs/node/commit/a815a23631)] - **test**: improve domain-top-level-error-handler-throw (CodeVana) [#9950](https://github.com/nodejs/node/pull/9950)
* [[`3448e8e522`](https://github.com/nodejs/node/commit/3448e8e522)] - **test**: use strictEqual in test-cwd-enoent-repl.js (Neeraj Sharma) [#9952](https://github.com/nodejs/node/pull/9952)
* [[`fc2fd920ab`](https://github.com/nodejs/node/commit/fc2fd920ab)] - **test**: refactor test-net-reconnect-error (Duy Le) [#9903](https://github.com/nodejs/node/pull/9903)
* [[`a7c9c5685e`](https://github.com/nodejs/node/commit/a7c9c5685e)] - **test**: add test-require-invalid-package (Duy Le) [#9903](https://github.com/nodejs/node/pull/9903)
* [[`d1b4c5dc61`](https://github.com/nodejs/node/commit/d1b4c5dc61)] - **test**: refactor test-child-process-kill (Duy Le) [#9903](https://github.com/nodejs/node/pull/9903)
* [[`2f92945a70`](https://github.com/nodejs/node/commit/2f92945a70)] - **test**: use consistent block spacing (Rich Trott) [#10377](https://github.com/nodejs/node/pull/10377)
* [[`9a9e530291`](https://github.com/nodejs/node/commit/9a9e530291)] - **test**: add known_issues test for #5350 (AnnaMag) [#10319](https://github.com/nodejs/node/pull/10319)
* [[`76b0e5bfbe`](https://github.com/nodejs/node/commit/76b0e5bfbe)] - **test**: refactor test-timers-this (Rich Trott) [#10315](https://github.com/nodejs/node/pull/10315)
* [[`797d9a8e79`](https://github.com/nodejs/node/commit/797d9a8e79)] - **tools**: refactor json.js (Rich Trott) [#10442](https://github.com/nodejs/node/pull/10442)
* [[`05332942e2`](https://github.com/nodejs/node/commit/05332942e2)] - **tools**: enforce linebreak after ternary operators (Michaël Zasso) [#10213](https://github.com/nodejs/node/pull/10213)
* [[`3a7b63b81b`](https://github.com/nodejs/node/commit/3a7b63b81b)] - **tools**: enable block-spacing rule in .eslintrc (Rich Trott) [#10377](https://github.com/nodejs/node/pull/10377)
* [[`3195fb45ae`](https://github.com/nodejs/node/commit/3195fb45ae)] - **url**: set toStringTag for the URL class (James M Snell) [#10562](https://github.com/nodejs/node/pull/10562)
* [[`659d522d7c`](https://github.com/nodejs/node/commit/659d522d7c)] - **url**: fix accidental filemode change (James M Snell) [#10549](https://github.com/nodejs/node/pull/10549)
* [[`6977224059`](https://github.com/nodejs/node/commit/6977224059)] - **url**: fix URL query update if searchParams changes (Michaël Zasso) [#10486](https://github.com/nodejs/node/pull/10486)
* [[`78e867492a`](https://github.com/nodejs/node/commit/78e867492a)] - **url**: improve spec compliance of WHATWG URL (Michaël Zasso) [#10317](https://github.com/nodejs/node/pull/10317)
* [[`2b98ea0dec`](https://github.com/nodejs/node/commit/2b98ea0dec)] - **url**: move originFor, domainToAscii and domainToUnicode (James M Snell) [#10512](https://github.com/nodejs/node/pull/10512)
* [[`e210efad9e`](https://github.com/nodejs/node/commit/e210efad9e)] - **url**: performance improvement in URL implementation (James M Snell) [#10469](https://github.com/nodejs/node/pull/10469)
* [[`7fbd12f876`](https://github.com/nodejs/node/commit/7fbd12f876)] - **url**: make WHATWG URL properties spec compliant (Joyee Cheung) [#10408](https://github.com/nodejs/node/pull/10408)
* [[`495213e545`](https://github.com/nodejs/node/commit/495213e545)] - **url**: mark ignored return value in node::url::Parse(...) (Christopher J. Brody) [#10141](https://github.com/nodejs/node/pull/10141)
* [[`ba46374cb9`](https://github.com/nodejs/node/commit/ba46374cb9)] - **watchdog**: add flag to mark handler as disabled (Bartosz Sosnowski) [#10248](https://github.com/nodejs/node/pull/10248)

<a id="7.3.0"></a>
## 2016-12-20, Version 7.3.0 (Current), @cjihrig

Thank you to @italoacasas for preparing the majority of this release.

### Notable changes

* **buffer**:
  * buffer.fill() now works properly for the UCS2 encoding on Big-Endian machines. (Anna Henningsen) [#9837](https://github.com/nodejs/node/pull/9837)
* **cluster**:
  * disconnect() now returns a reference to the disconnected worker. (Sean Villars) [#10019](https://github.com/nodejs/node/pull/10019)
* **crypto**:
  * The built-in list of Well-Known CAs (Certificate Authorities) can now be extended via a NODE_EXTRA_CA_CERTS environment variable. (Sam Roberts) [#9139](https://github.com/nodejs/node/pull/9139)
* **http**:
  * Remove stale timeout listeners in order to prevent a memory leak when using keep alive. (Karl Böhlmark) [#9440](https://github.com/nodejs/node/pull/9440)
* **tls**:
  * Allow obvious key/passphrase combinations. (Sam Roberts) [#10294](https://github.com/nodejs/node/pull/10294)
* **url**:
  * Including base argument in URL.originFor() to meet specification compliance. (joyeecheung) [#10021](https://github.com/nodejs/node/pull/10021)
  * Improve URLSearchParams to meet specification compliance. (Timothy Gu) [#9484](https://github.com/nodejs/node/pull/9484)

### Commits

* [[`c2cc11b3c6`](https://github.com/nodejs/node/commit/c2cc11b3c6)] - Working on v7.2.2 (Jeremiah Senkpiel) [#10127](https://github.com/nodejs/node/pull/10127)
* [[`b99a372e91`](https://github.com/nodejs/node/commit/b99a372e91)] - **buffer**: fix single-character string filling (Anna Henningsen) [#9837](https://github.com/nodejs/node/pull/9837)
* [[`d8b6723096`](https://github.com/nodejs/node/commit/d8b6723096)] - **buffer**: handle UCS2 `.fill()` properly on BE (Anna Henningsen) [#9837](https://github.com/nodejs/node/pull/9837)
* [[`e61331ee9b`](https://github.com/nodejs/node/commit/e61331ee9b)] - **build**: fix node_g target (Daniel Bevenius) [#10153](https://github.com/nodejs/node/pull/10153)
* [[`9d04152e15`](https://github.com/nodejs/node/commit/9d04152e15)] - **build**: Don't regenerate node symlink (sxa555) [#9827](https://github.com/nodejs/node/pull/9827)
* [[`5d14602181`](https://github.com/nodejs/node/commit/5d14602181)] - **(SEMVER-MINOR)** **cluster**: return worker reference from disconnect() (Sean Villars) [#10019](https://github.com/nodejs/node/pull/10019)
* [[`6963e8aa9d`](https://github.com/nodejs/node/commit/6963e8aa9d)] - **(SEMVER-MINOR)** **crypto**: allow adding extra certs to well-known CAs (Sam Roberts) [#9139](https://github.com/nodejs/node/pull/9139)
* [[`a308a2fae4`](https://github.com/nodejs/node/commit/a308a2fae4)] - **deps**: cherry-pick 081fce3 from V8 upstream (Matt Loring) [#10342](https://github.com/nodejs/node/pull/10342)
* [[`7c3d280bf0`](https://github.com/nodejs/node/commit/7c3d280bf0)] - **doc**: rework tls for accuracy and clarity (Sam Roberts) [#9800](https://github.com/nodejs/node/pull/9800)
* [[`6b98906a08`](https://github.com/nodejs/node/commit/6b98906a08)] - **doc**: document R CRAN mirror process (Lucas Holmquist) [#10211](https://github.com/nodejs/node/pull/10211)
* [[`7e8c5e3490`](https://github.com/nodejs/node/commit/7e8c5e3490)] - **doc**: expand common module material in test guide (Rich Trott) [#10251](https://github.com/nodejs/node/pull/10251)
* [[`ee736b276c`](https://github.com/nodejs/node/commit/ee736b276c)] - **doc**: fix broken link in COLLABORATOR_GUIDE.md (Michael Dawson) [#10267](https://github.com/nodejs/node/pull/10267)
* [[`40b0ca1329`](https://github.com/nodejs/node/commit/40b0ca1329)] - **doc**: fix typo in code example of 'path' module (pallxk) [#10136](https://github.com/nodejs/node/pull/10136)
* [[`b44e7891d0`](https://github.com/nodejs/node/commit/b44e7891d0)] - **doc**: standardizing on make -j4 (Jonathan Darling) [#9961](https://github.com/nodejs/node/pull/9961)
* [[`ff8fdb14fb`](https://github.com/nodejs/node/commit/ff8fdb14fb)] - **doc**: add note to parallelize make (Jonathan Darling) [#9961](https://github.com/nodejs/node/pull/9961)
* [[`5a64187bed`](https://github.com/nodejs/node/commit/5a64187bed)] - **doc**: buffer allocation throws for negative size (joyeecheung) [#10151](https://github.com/nodejs/node/pull/10151)
* [[`20fdf3aec6`](https://github.com/nodejs/node/commit/20fdf3aec6)] - **doc**: add some info on `tty#setRawMode()` (Jeremiah Senkpiel) [#10147](https://github.com/nodejs/node/pull/10147)
* [[`ae53a6e12b`](https://github.com/nodejs/node/commit/ae53a6e12b)] - **doc**: update `path.format` description and examples (anoff) [#10046](https://github.com/nodejs/node/pull/10046)
* [[`30340388f1`](https://github.com/nodejs/node/commit/30340388f1)] - **doc**: add a variable declaration in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`d64e52c68d`](https://github.com/nodejs/node/commit/d64e52c68d)] - **doc**: adding missing - in README (Italo A. Casas) [#10170](https://github.com/nodejs/node/pull/10170)
* [[`39bf5bfaf1`](https://github.com/nodejs/node/commit/39bf5bfaf1)] - **doc**: removing extra space in README (Italo A. Casas) [#10168](https://github.com/nodejs/node/pull/10168)
* [[`bc64a63440`](https://github.com/nodejs/node/commit/bc64a63440)] - **doc**: fix a wrong note in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`d4c73d4823`](https://github.com/nodejs/node/commit/d4c73d4823)] - **doc**: remove an extraneous word in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`d373b2f2fb`](https://github.com/nodejs/node/commit/d373b2f2fb)] - **doc**: fix examples in buffer.md to avoid confusion (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`7a39a44dbc`](https://github.com/nodejs/node/commit/7a39a44dbc)] - **doc**: remove a wrong remark in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`39b083eb51`](https://github.com/nodejs/node/commit/39b083eb51)] - **doc**: repeat a remark as needed in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`622690f242`](https://github.com/nodejs/node/commit/622690f242)] - **doc**: fix copy-paste artifacts in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`3b848a279b`](https://github.com/nodejs/node/commit/3b848a279b)] - **doc**: fix wrong function arguments in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`9e47b943a7`](https://github.com/nodejs/node/commit/9e47b943a7)] - **doc**: fix a syntax error in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`1864222d50`](https://github.com/nodejs/node/commit/1864222d50)] - **doc**: var => const/let in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`7b924f1713`](https://github.com/nodejs/node/commit/7b924f1713)] - **doc**: fix typo in ecdhCurve, a tls property name (Sam Roberts) [#10345](https://github.com/nodejs/node/pull/10345)
* [[`2673be676a`](https://github.com/nodejs/node/commit/2673be676a)] - **fs**: remove unused argument from copyObject() (Ethan Arrowood) [#10041](https://github.com/nodejs/node/pull/10041)
* [[`1081f0f33d`](https://github.com/nodejs/node/commit/1081f0f33d)] - **fs**: remove needless assignment of null (Francis Gulotta) [#10260](https://github.com/nodejs/node/pull/10260)
* [[`dded482bb8`](https://github.com/nodejs/node/commit/dded482bb8)] - **http**: remove stale timeout listeners (Karl Böhlmark) [#9440](https://github.com/nodejs/node/pull/9440)
* [[`b41db3396b`](https://github.com/nodejs/node/commit/b41db3396b)] - **inspector**: check if connected before waiting (Eugene Ostroukhov) [#10094](https://github.com/nodejs/node/pull/10094)
* [[`b6a8bc6ac3`](https://github.com/nodejs/node/commit/b6a8bc6ac3)] - **lib,test**: use consistent operator linebreak style (Michaël Zasso) [#10178](https://github.com/nodejs/node/pull/10178)
* [[`ef2fa56314`](https://github.com/nodejs/node/commit/ef2fa56314)] - **src**: fix string format mistake for 32 bit node (Alex Newman) [#10082](https://github.com/nodejs/node/pull/10082)
* [[`d4e160c946`](https://github.com/nodejs/node/commit/d4e160c946)] - **(SEMVER-MINOR)** **src**: add wrapper for process.emitWarning() (Sam Roberts) [#9139](https://github.com/nodejs/node/pull/9139)
* [[`ec2f13fe66`](https://github.com/nodejs/node/commit/ec2f13fe66)] - **src**: don't overwrite non-writable vm globals (Ben Noordhuis) [#10227](https://github.com/nodejs/node/pull/10227)
* [[`28ffd593e2`](https://github.com/nodejs/node/commit/28ffd593e2)] - **stream, test**: test _readableState.emittedReadable (Joyee Cheung) [#10249](https://github.com/nodejs/node/pull/10249)
* [[`729fecf390`](https://github.com/nodejs/node/commit/729fecf390)] - **stream_base**: homogenize req_wrap_obj use (Fedor Indutny) [#10184](https://github.com/nodejs/node/pull/10184)
* [[`8b9131c1f8`](https://github.com/nodejs/node/commit/8b9131c1f8)] - **test**: tls key/cert ordering not necessary (Sam Roberts) [#9800](https://github.com/nodejs/node/pull/9800)
* [[`8a34e60b41`](https://github.com/nodejs/node/commit/8a34e60b41)] - **test**: var to const in tls-no-cert-required (Sam Roberts) [#9800](https://github.com/nodejs/node/pull/9800)
* [[`ea16a2ab52`](https://github.com/nodejs/node/commit/ea16a2ab52)] - **test**: stream readable needReadable state (Joyee Cheung) [#10241](https://github.com/nodejs/node/pull/10241)
* [[`e4b29a57f9`](https://github.com/nodejs/node/commit/e4b29a57f9)] - **test**: refactor test-fs-read-stream-inherit (Rich Trott) [#10246](https://github.com/nodejs/node/pull/10246)
* [[`fb297cba8f`](https://github.com/nodejs/node/commit/fb297cba8f)] - **test**: refactor test-dgram-send-callback-multi-buffer (mfrance) [#9999](https://github.com/nodejs/node/pull/9999)
* [[`16fbd4f6bf`](https://github.com/nodejs/node/commit/16fbd4f6bf)] - **test**: refactor test-tls-ecdh-disable (Aaron Williams) [#9989](https://github.com/nodejs/node/pull/9989)
* [[`46c55a6454`](https://github.com/nodejs/node/commit/46c55a6454)] - **test**: cleanup test-stdout-close-catch.js (Travis Bretton) [#10006](https://github.com/nodejs/node/pull/10006)
* [[`8c8b1230da`](https://github.com/nodejs/node/commit/8c8b1230da)] - **test**: use const/let and common.mustCall (Outsider) [#9959](https://github.com/nodejs/node/pull/9959)
* [[`74563f07e9`](https://github.com/nodejs/node/commit/74563f07e9)] - **test**: refactor domain test (Adao Junior) [#10269](https://github.com/nodejs/node/pull/10269)
* [[`d9cfd5484f`](https://github.com/nodejs/node/commit/d9cfd5484f)] - **test**: clean up domain-no-error-handler test (weyj4) [#10291](https://github.com/nodejs/node/pull/10291)
* [[`553a32674a`](https://github.com/nodejs/node/commit/553a32674a)] - **test**: fix http-client-timeout-option-listeners (Rich Trott) [#10224](https://github.com/nodejs/node/pull/10224)
* [[`308cead66e`](https://github.com/nodejs/node/commit/308cead66e)] - **test**: update test-domain-uncaught-exception.js (Andy Chen) [#10193](https://github.com/nodejs/node/pull/10193)
* [[`60542cb98b`](https://github.com/nodejs/node/commit/60542cb98b)] - **test**: refactor test-domain.js (Siddhartha Sahai) [#10207](https://github.com/nodejs/node/pull/10207)
* [[`c0800d9449`](https://github.com/nodejs/node/commit/c0800d9449)] - **test**: refactor test-stream-big-push (Rich Trott) [#10226](https://github.com/nodejs/node/pull/10226)
* [[`b9361cae6e`](https://github.com/nodejs/node/commit/b9361cae6e)] - **test**: refactor test-http-dns-fail (Adrian Estrada) [#10243](https://github.com/nodejs/node/pull/10243)
* [[`a97f26476d`](https://github.com/nodejs/node/commit/a97f26476d)] - **test**: refactor test-crypto-random (Rich Trott) [#10232](https://github.com/nodejs/node/pull/10232)
* [[`2f9c8d977f`](https://github.com/nodejs/node/commit/2f9c8d977f)] - **test**: refactor test-http-pause-resume-one-end (Rich Trott) [#10210](https://github.com/nodejs/node/pull/10210)
* [[`90659bc95c`](https://github.com/nodejs/node/commit/90659bc95c)] - **test**: fix flaky test-dgram-exclusive-implicit-bind (Rich Trott) [#10212](https://github.com/nodejs/node/pull/10212)
* [[`a4f3080595`](https://github.com/nodejs/node/commit/a4f3080595)] - **test**: improvements in test fixtures symlinked (Adrian Estrada) [#10182](https://github.com/nodejs/node/pull/10182)
* [[`d5e30a69e2`](https://github.com/nodejs/node/commit/d5e30a69e2)] - **test**: refactor test-fs-fsync (Rob Adelmann) [#10176](https://github.com/nodejs/node/pull/10176)
* [[`be87441463`](https://github.com/nodejs/node/commit/be87441463)] - **test**: refactor test-http-after-connect.js (larissayvette) [#10229](https://github.com/nodejs/node/pull/10229)
* [[`2b78212445`](https://github.com/nodejs/node/commit/2b78212445)] - **test**: use strictEqual in test-debug-break (Adrian Estrada) [#10181](https://github.com/nodejs/node/pull/10181)
* [[`8b698d89ac`](https://github.com/nodejs/node/commit/8b698d89ac)] - **test**: refactor assert.equal, update syntax to ES6 (Prieto, Marcos) [#10190](https://github.com/nodejs/node/pull/10190)
* [[`3749dc6ce7`](https://github.com/nodejs/node/commit/3749dc6ce7)] - **test**: refactor http pipelined socket test (Rich Trott) [#10189](https://github.com/nodejs/node/pull/10189)
* [[`e1d813f3f8`](https://github.com/nodejs/node/commit/e1d813f3f8)] - **test**: refactor test-handle-wrap-close-abort (Rich Trott) [#10188](https://github.com/nodejs/node/pull/10188)
* [[`7f01484a7a`](https://github.com/nodejs/node/commit/7f01484a7a)] - **test**: add ES6 and strictEqual to test-fs-truncate (Adrian Estrada) [#10167](https://github.com/nodejs/node/pull/10167)
* [[`88839cf204`](https://github.com/nodejs/node/commit/88839cf204)] - **test**: replace var with const in test-require-dot (Amar Zavery) [#9916](https://github.com/nodejs/node/pull/9916)
* [[`09ec5db10b`](https://github.com/nodejs/node/commit/09ec5db10b)] - **test**: fail for missing output files (Anna Henningsen) [#10150](https://github.com/nodejs/node/pull/10150)
* [[`3f269cc760`](https://github.com/nodejs/node/commit/3f269cc760)] - **test**: use ES6 in test-debugger-client.js (Adrian Estrada) [#10183](https://github.com/nodejs/node/pull/10183)
* [[`1f11deb58f`](https://github.com/nodejs/node/commit/1f11deb58f)] - **test**: improve buffer transcode (Johnny Reading) [#10043](https://github.com/nodejs/node/pull/10043)
* [[`3e8df733e8`](https://github.com/nodejs/node/commit/3e8df733e8)] - **test**: improving crypto fips (James Tenenbaum) [#10002](https://github.com/nodejs/node/pull/10002)
* [[`6780c0e572`](https://github.com/nodejs/node/commit/6780c0e572)] - **test**: stream readableState readingMore state (Gregory) [#9868](https://github.com/nodejs/node/pull/9868)
* [[`c792e2ac49`](https://github.com/nodejs/node/commit/c792e2ac49)] - **test**: stream readableListening internal state (Italo A. Casas) [#9864](https://github.com/nodejs/node/pull/9864)
* [[`28c6df2604`](https://github.com/nodejs/node/commit/28c6df2604)] - **test**: add stdin-setrawmode.out file (Jonathan Darling) [#10149](https://github.com/nodejs/node/pull/10149)
* [[`f5347abac8`](https://github.com/nodejs/node/commit/f5347abac8)] - **test**: set stdin too for pseudo-tty tests (Anna Henningsen) [#10149](https://github.com/nodejs/node/pull/10149)
* [[`3a460d5469`](https://github.com/nodejs/node/commit/3a460d5469)] - **test**: check for error on invalid signal (Matt Phillips) [#10026](https://github.com/nodejs/node/pull/10026)
* [[`1ebb5b9adb`](https://github.com/nodejs/node/commit/1ebb5b9adb)] - **test**: refactor test-http-unix-socket (davidmarkclements) [#10072](https://github.com/nodejs/node/pull/10072)
* [[`8b7c97bc59`](https://github.com/nodejs/node/commit/8b7c97bc59)] - **test**: increase test coverage of BufferList (joyeecheung) [#10171](https://github.com/nodejs/node/pull/10171)
* [[`53e8e962d4`](https://github.com/nodejs/node/commit/53e8e962d4)] - **test**: fix flaky test-net-socket-timeout (Rich Trott) [#10172](https://github.com/nodejs/node/pull/10172)
* [[`ca38f70dea`](https://github.com/nodejs/node/commit/ca38f70dea)] - **test**: refactor test-net-keepalive.js (Kyle Corsi) [#9995](https://github.com/nodejs/node/pull/9995)
* [[`a9d4bd7a34`](https://github.com/nodejs/node/commit/a9d4bd7a34)] - **test**: refactor test-crypto-hmac (eudaimos) [#9958](https://github.com/nodejs/node/pull/9958)
* [[`778e5f7d0c`](https://github.com/nodejs/node/commit/778e5f7d0c)] - **test**: fix error in test-cluster-worker-death.js (Bruce Lai) [#9981](https://github.com/nodejs/node/pull/9981)
* [[`b67cad1174`](https://github.com/nodejs/node/commit/b67cad1174)] - **test**: use `assert.strictEqual` (anoff) [#9975](https://github.com/nodejs/node/pull/9975)
* [[`72fb05d062`](https://github.com/nodejs/node/commit/72fb05d062)] - **test**: change assert.equal to assert.strictEqual (Aileen) [#9946](https://github.com/nodejs/node/pull/9946)
* [[`dac757e502`](https://github.com/nodejs/node/commit/dac757e502)] - **test**: changed assert.equal to assert.strictEqual (vazina robertson) [#10015](https://github.com/nodejs/node/pull/10015)
* [[`d7988e0355`](https://github.com/nodejs/node/commit/d7988e0355)] - **test**: renamed assert.Equal to assert.strictEqual (Jared Young)
* [[`9d037cfa44`](https://github.com/nodejs/node/commit/9d037cfa44)] - **test**: improves test-tls-client-verify (Paul Graham) [#10051](https://github.com/nodejs/node/pull/10051)
* [[`2565e48445`](https://github.com/nodejs/node/commit/2565e48445)] - **test**: refactor test-https-agent-session-reuse (Diego Paez) [#10105](https://github.com/nodejs/node/pull/10105)
* [[`11140802f4`](https://github.com/nodejs/node/commit/11140802f4)] - **test**: refactor test-beforeexit-event (Rob Adelmann) [#10121](https://github.com/nodejs/node/pull/10121)
* [[`e695862531`](https://github.com/nodejs/node/commit/e695862531)] - **test**: improve test-fs-read-stream.js (Jenna Vuong) [#9629](https://github.com/nodejs/node/pull/9629)
* [[`be90638487`](https://github.com/nodejs/node/commit/be90638487)] - **test**: refactor test-domain-from-timer (Daniel Sims) [#9889](https://github.com/nodejs/node/pull/9889)
* [[`2c5d5629de`](https://github.com/nodejs/node/commit/2c5d5629de)] - **test**: refactor test-domain-exit-dispose-again (Ethan Arrowood) [#10003](https://github.com/nodejs/node/pull/10003)
* [[`6d4f270f2f`](https://github.com/nodejs/node/commit/6d4f270f2f)] - **test**: use const and strictEqual in test-os-homedir-no-envvar (CodeVana) [#9899](https://github.com/nodejs/node/pull/9899)
* [[`62f5a0bf59`](https://github.com/nodejs/node/commit/62f5a0bf59)] - **test**: check result of uv_loop_init and uv_write (Ben Noordhuis) [#10126](https://github.com/nodejs/node/pull/10126)
* [[`19432f05ff`](https://github.com/nodejs/node/commit/19432f05ff)] - **test**: refactor test-dgram-bind-default-address (Michael-Bryant Choa) [#9947](https://github.com/nodejs/node/pull/9947)
* [[`01509bc67e`](https://github.com/nodejs/node/commit/01509bc67e)] - **test**: move long-running test to sequential (Rich Trott) [#10161](https://github.com/nodejs/node/pull/10161)
* [[`d8dc890352`](https://github.com/nodejs/node/commit/d8dc890352)] - **test**: assert.throws() should include a RegExp (Chris Bystrek) [#9976](https://github.com/nodejs/node/pull/9976)
* [[`6f2f02d5ad`](https://github.com/nodejs/node/commit/6f2f02d5ad)] - **test**: invalid package.json causes error when require()ing in directory (Sam Shull) [#10044](https://github.com/nodejs/node/pull/10044)
* [[`6489a91027`](https://github.com/nodejs/node/commit/6489a91027)] - **test**: refactor test-listen-fd-ebadf (Richard Karmazin) [#10034](https://github.com/nodejs/node/pull/10034)
* [[`eb1664bed9`](https://github.com/nodejs/node/commit/eb1664bed9)] - **test**: refactor test-event-emitter-method-names (Rodrigo Palma) [#10027](https://github.com/nodejs/node/pull/10027)
* [[`c66cf2c1cf`](https://github.com/nodejs/node/commit/c66cf2c1cf)] - **test**: refactor tls-ticket-cluster (Yojan Shrestha) [#10023](https://github.com/nodejs/node/pull/10023)
* [[`de9972678e`](https://github.com/nodejs/node/commit/de9972678e)] - **test**: refactor test-domain-exit-dispose (Chris Henney) [#9938](https://github.com/nodejs/node/pull/9938)
* [[`5ca90777e6`](https://github.com/nodejs/node/commit/5ca90777e6)] - **test**: refactor test-stdin-from-file.js (amrios) [#10012](https://github.com/nodejs/node/pull/10012)
* [[`4d66578997`](https://github.com/nodejs/node/commit/4d66578997)] - **test**: use ES6 to update let & const (Jason Humphrey) [#9917](https://github.com/nodejs/node/pull/9917)
* [[`bb9174745b`](https://github.com/nodejs/node/commit/bb9174745b)] - **test**: fix test for buffer regression #649 (joyeecheung) [#9924](https://github.com/nodejs/node/pull/9924)
* [[`613798335c`](https://github.com/nodejs/node/commit/613798335c)] - **test**: stream readable resumeScheduled state (Italo A. Casas) [#10299](https://github.com/nodejs/node/pull/10299)
* [[`15c71f6c66`](https://github.com/nodejs/node/commit/15c71f6c66)] - **test**: improve code in test-fs-open.js (Adrian Estrada) [#10312](https://github.com/nodejs/node/pull/10312)
* [[`793d8719eb`](https://github.com/nodejs/node/commit/793d8719eb)] - **test**: fix flaky test-debug-port (Santiago Gimeno) [#10316](https://github.com/nodejs/node/pull/10316)
* [[`5e781a3883`](https://github.com/nodejs/node/commit/5e781a3883)] - **test**: refactor the code in test-dns-ipv6 (Adrian Estrada) [#10219](https://github.com/nodejs/node/pull/10219)
* [[`8b367c5ddd`](https://github.com/nodejs/node/commit/8b367c5ddd)] - **test**: improve test-child-process-fork-and-spawn (Adrian Estrada) [#10273](https://github.com/nodejs/node/pull/10273)
* [[`348e69c89d`](https://github.com/nodejs/node/commit/348e69c89d)] - **test**: fix flaky test-http-client-timeout-event (Rich Trott) [#10293](https://github.com/nodejs/node/pull/10293)
* [[`0d3ac89ff7`](https://github.com/nodejs/node/commit/0d3ac89ff7)] - **test**: add known_issues test for #6287 (AnnaMag) [#10272](https://github.com/nodejs/node/pull/10272)
* [[`f7f662cad5`](https://github.com/nodejs/node/commit/f7f662cad5)] - **test**: improve test-child-process-exec-buffer (Adrian Estrada) [#10275](https://github.com/nodejs/node/pull/10275)
* [[`f66461382c`](https://github.com/nodejs/node/commit/f66461382c)] - **timers**: fix handling of cleared immediates (hveldstra) [#9759](https://github.com/nodejs/node/pull/9759)
* [[`8e4b9fa487`](https://github.com/nodejs/node/commit/8e4b9fa487)] - **tls**: fix/annotate connect arg comments (Sam Roberts) [#9800](https://github.com/nodejs/node/pull/9800)
* [[`980acb4b95`](https://github.com/nodejs/node/commit/980acb4b95)] - **tls**: document and test option-less createServer (Sam Roberts) [#9800](https://github.com/nodejs/node/pull/9800)
* [[`41e1e6eb35`](https://github.com/nodejs/node/commit/41e1e6eb35)] - **tls**: do not refer to secureOptions as flags (Sam Roberts) [#9800](https://github.com/nodejs/node/pull/9800)
* [[`0b44384561`](https://github.com/nodejs/node/commit/0b44384561)] - **(SEMVER-MINOR)** **tls**: allow obvious key/passphrase combinations (Sam Roberts) [#10294](https://github.com/nodejs/node/pull/10294)
* [[`a92f2ad19c`](https://github.com/nodejs/node/commit/a92f2ad19c)] - **tools**: enforce consistent operator linebreak style (Michaël Zasso) [#10178](https://github.com/nodejs/node/pull/10178)
* [[`cc5bd9a0cf`](https://github.com/nodejs/node/commit/cc5bd9a0cf)] - **tools**: add macosx-firwall script to avoid popups (Daniel Bevenius) [#10114](https://github.com/nodejs/node/pull/10114)
* [[`7cb98138a9`](https://github.com/nodejs/node/commit/7cb98138a9)] - **tools**: forbid template literals in assert.throws (Michaël Zasso) [#10301](https://github.com/nodejs/node/pull/10301)
* [[`24482d08ce`](https://github.com/nodejs/node/commit/24482d08ce)] - **(SEMVER-MINOR)** **url**: add inspect function to TupleOrigin (Safia Abdalla) [#10039](https://github.com/nodejs/node/pull/10039)
* [[`f08d8a6c6f`](https://github.com/nodejs/node/commit/f08d8a6c6f)] - **url**: improve URLSearchParams spec compliance (Timothy Gu) [#9484](https://github.com/nodejs/node/pull/9484)
* [[`19d7197177`](https://github.com/nodejs/node/commit/19d7197177)] - **url**: add a got host pattern in url.js (Axel Monroy) [#9653](https://github.com/nodejs/node/pull/9653)
* [[`2da71f24de`](https://github.com/nodejs/node/commit/2da71f24de)] - **url, test**: fix typo in inspect output, add test (Jay Brownlee) [#10231](https://github.com/nodejs/node/pull/10231)
* [[`80cccce218`](https://github.com/nodejs/node/commit/80cccce218)] - **url, test**: including base argument in originFor (joyeecheung) [#10021](https://github.com/nodejs/node/pull/10021)
* [[`7a0fe9f471`](https://github.com/nodejs/node/commit/7a0fe9f471)] - **win,msi**: add required UIRef for localized strings (Bill Ticehurst) [#8884](https://github.com/nodejs/node/pull/8884)

<a id="7.2.1"></a>
## 2016-12-06, Version 7.2.1 (Current), @Fishrock123

### Notable changes

* **buffer**:
  * Reverted the runtime deprecation of calling `Buffer()` without `new`. (Anna Henningsen) [#9529](https://github.com/nodejs/node/pull/9529)
  * Fixed `buffer.transcode()` for single-byte character
    encodings to `UCS2`. (Anna Henningsen) [#9838](https://github.com/nodejs/node/pull/9838)
* **promise**: `--trace-warnings` now produces useful stacktraces for Promise warnings. (Anna Henningsen) [#9525](https://github.com/nodejs/node/pull/9525)
* **repl**: Fixed a bug preventing correct parsing of generator functions. (Teddy Katz) [#9852](https://github.com/nodejs/node/pull/9852)
* **V8**: Fixed a significant `instanceof` performance regression. (Franziska Hinkelmann) [#9730](https://github.com/nodejs/node/pull/9730)

### Commits

* [[`f55a63c86f`](https://github.com/nodejs/node/commit/f55a63c86f)] - internal/util: move the case 'latin1' (Jackson Tian) [#9646](https://github.com/nodejs/node/pull/9646)
* [[`5379b9da11`](https://github.com/nodejs/node/commit/5379b9da11)] - **async\_wrap**: call destroy() callback in `uv_idle_t` (Trevor Norris) [#9753](https://github.com/nodejs/node/pull/9753)
* [[`5157a5cee9`](https://github.com/nodejs/node/commit/5157a5cee9)] - **async\_wrap**: make Initialize a static class member (Trevor Norris) [#9753](https://github.com/nodejs/node/pull/9753)
* [[`3e5be7fc8b`](https://github.com/nodejs/node/commit/3e5be7fc8b)] - **async\_wrap**: mode constructor/destructor to .cc (Trevor Norris) [#9753](https://github.com/nodejs/node/pull/9753)
* [[`88464ac6ac`](https://github.com/nodejs/node/commit/88464ac6ac)] - **benchmark**: reformat code for clarity (Rich Trott) [#9790](https://github.com/nodejs/node/pull/9790)
* [[`573f9db6c9`](https://github.com/nodejs/node/commit/573f9db6c9)] - **buffer**: fix transcode for single-byte enc to ucs2 (Anna Henningsen) [#9838](https://github.com/nodejs/node/pull/9838)
* [[`0c745e3a3a`](https://github.com/nodejs/node/commit/0c745e3a3a)] - **buffer**: convert offset & length to int properly (Sakthipriyan Vairamani (thefourtheye)) [#9815](https://github.com/nodejs/node/pull/9815)
* [[`e0e62d1113`](https://github.com/nodejs/node/commit/e0e62d1113)] - ***Revert*** "**buffer**: runtime deprecation of calling Buffer without new" (Anna Henningsen) [#9529](https://github.com/nodejs/node/pull/9529)
* [[`371090d817`](https://github.com/nodejs/node/commit/371090d817)] - **build**: Make configure file parseable on python3 (kalrover) [#9657](https://github.com/nodejs/node/pull/9657)
* [[`16af467146`](https://github.com/nodejs/node/commit/16af467146)] - **build**: add shared library support to AIX build (Stewart Addison) [#9675](https://github.com/nodejs/node/pull/9675)
* [[`fa38032148`](https://github.com/nodejs/node/commit/fa38032148)] - **child\_process**: name anonymous functions (brad-decker) [#9880](https://github.com/nodejs/node/pull/9880)
* [[`5c9aa18484`](https://github.com/nodejs/node/commit/5c9aa18484)] - **constants**: errors -> errno (Bryan English) [#9349](https://github.com/nodejs/node/pull/9349)
* [[`dfa35d66f5`](https://github.com/nodejs/node/commit/dfa35d66f5)] - **debugger**: call `this.resume()` after `this.run()` (Lance Ball) [#10099](https://github.com/nodejs/node/pull/10099)
* [[`ac8d212428`](https://github.com/nodejs/node/commit/ac8d212428)] - **debugger**: refactor `_debugger.js` (Rich Trott) [#9860](https://github.com/nodejs/node/pull/9860)
* [[`4bcda633c0`](https://github.com/nodejs/node/commit/4bcda633c0)] - **deps**: upgrade npm to 3.10.10 (Rebecca Turner) [#9847](https://github.com/nodejs/node/pull/9847)
* [[`03b1c314cd`](https://github.com/nodejs/node/commit/03b1c314cd)] - **deps**: cherry-pick 08377af from v8 upstream (Franziska Hinkelmann) [#9730](https://github.com/nodejs/node/pull/9730)
* [[`e9c2ffd20c`](https://github.com/nodejs/node/commit/e9c2ffd20c)] - **deps**: backport GYP fix to fix AIX shared suffix (Stewart Addison)
* [[`3bc40ce725`](https://github.com/nodejs/node/commit/3bc40ce725)] - **doc**: remove repeated info onboarding.md (BethGriggs) [#9635](https://github.com/nodejs/node/pull/9635)
* [[`446bcbea4e`](https://github.com/nodejs/node/commit/446bcbea4e)] - **doc**: correct it's vs. its usage (Rich Trott) [#10098](https://github.com/nodejs/node/pull/10098)
* [[`b9bd9a2fcb`](https://github.com/nodejs/node/commit/b9bd9a2fcb)] - **doc**: remove Sam Roberts from release team (Sam Roberts) [#9862](https://github.com/nodejs/node/pull/9862)
* [[`51b77aa44a`](https://github.com/nodejs/node/commit/51b77aa44a)] - **doc**: add people to cc for async_wrap (Anna Henningsen) [#9471](https://github.com/nodejs/node/pull/9471)
* [[`346204d77e`](https://github.com/nodejs/node/commit/346204d77e)] - **doc**: add link to `net.Server` in tls.md (Devon Rifkin) [#10109](https://github.com/nodejs/node/pull/10109)
* [[`c4fbdfa785`](https://github.com/nodejs/node/commit/c4fbdfa785)] - **doc**: fix typo for `decipher.final`. (iamchenxin) [#10086](https://github.com/nodejs/node/pull/10086)
* [[`d226418b87`](https://github.com/nodejs/node/commit/d226418b87)] - **doc**: suggest Buffer.alloc instead of Buffer#fill (Teddy Katz) [#10000](https://github.com/nodejs/node/pull/10000)
* [[`78e188d929`](https://github.com/nodejs/node/commit/78e188d929)] - **doc**: clarify fs.createReadStream options (Wes Tyler) [#10078](https://github.com/nodejs/node/pull/10078)
* [[`cdec174d4d`](https://github.com/nodejs/node/commit/cdec174d4d)] - **doc**: var => const in js code examples of addons.md (Vse Mozhet Byt) [#10092](https://github.com/nodejs/node/pull/10092)
* [[`13eea40d6f`](https://github.com/nodejs/node/commit/13eea40d6f)] - **doc**: rename writing_tests.md to writing-tests.md (Safia Abdalla) [#9867](https://github.com/nodejs/node/pull/9867)
* [[`c948d9051b`](https://github.com/nodejs/node/commit/c948d9051b)] - **doc**: it’s -> its in api/child_process.md (Devon Rifkin) [#10090](https://github.com/nodejs/node/pull/10090)
* [[`f6c1f24068`](https://github.com/nodejs/node/commit/f6c1f24068)] - **doc**: update Collaborators list in README (Rich Trott) [#9846](https://github.com/nodejs/node/pull/9846)
* [[`a0e25b2544`](https://github.com/nodejs/node/commit/a0e25b2544)] - **doc**: remove minor contradiction in debugger doc (Rich Trott) [#9832](https://github.com/nodejs/node/pull/9832)
* [[`8c70f79249`](https://github.com/nodejs/node/commit/8c70f79249)] - **doc**: clarify introductory module material (Rich Trott) [#9816](https://github.com/nodejs/node/pull/9816)
* [[`2e22fa043d`](https://github.com/nodejs/node/commit/2e22fa043d)] - **doc**: improve description of module `exports` (Sam Roberts) [#9622](https://github.com/nodejs/node/pull/9622)
* [[`6ab920a3fc`](https://github.com/nodejs/node/commit/6ab920a3fc)] - **doc**: add guide for maintaining V8 (Ali Ijaz Sheikh) [#9777](https://github.com/nodejs/node/pull/9777)
* [[`4fa84c9589`](https://github.com/nodejs/node/commit/4fa84c9589)] - **doc**: fix crypto Verify cut-n-paste from Sign (子丶言) [#9796](https://github.com/nodejs/node/pull/9796)
* [[`6297b9afc5`](https://github.com/nodejs/node/commit/6297b9afc5)] - **doc**: minor fixes event-loop-timers-and-nexttick.md (Dan Koster) [#9126](https://github.com/nodejs/node/pull/9126)
* [[`a8d84d5b50`](https://github.com/nodejs/node/commit/a8d84d5b50)] - **doc**: changed order of invocations in https.request() example. (atrioom) [#9614](https://github.com/nodejs/node/pull/9614)
* [[`c7cd400fcb`](https://github.com/nodejs/node/commit/c7cd400fcb)] - **doc**: fix crypto "decipher.setAAD()" typo (子丶言) [#9782](https://github.com/nodejs/node/pull/9782)
* [[`77e145a00e`](https://github.com/nodejs/node/commit/77e145a00e)] - **doc**: clarify slashes-appending in url module (Rich Trott) [#9731](https://github.com/nodejs/node/pull/9731)
* [[`65af114267`](https://github.com/nodejs/node/commit/65af114267)] - **doc**: "util" is not needed to extend ES6 classes (Adam Brunner) [#9737](https://github.com/nodejs/node/pull/9737)
* [[`44ae0283af`](https://github.com/nodejs/node/commit/44ae0283af)] - **doc**: fix `<code>` inside stability boxes (Roman Reiss) [#9723](https://github.com/nodejs/node/pull/9723)
* [[`9554a974d1`](https://github.com/nodejs/node/commit/9554a974d1)] - **https**: name anonymous functions in https (Pedro Lima) [#9217](https://github.com/nodejs/node/pull/9217)
* [[`80a3934cd7`](https://github.com/nodejs/node/commit/80a3934cd7)] - **inspector**: /json/version returns object, not array (Ben Noordhuis) [#9762](https://github.com/nodejs/node/pull/9762)
* [[`65cda7f265`](https://github.com/nodejs/node/commit/65cda7f265)] - **lib**: use === in `_http_server` and `_tls_wrap` (Walter Beller-Morales) [#9849](https://github.com/nodejs/node/pull/9849)
* [[`a673d44d68`](https://github.com/nodejs/node/commit/a673d44d68)] - **lib,tools**: remove unneeded escaping of / (Prince J Wesley) [#9591](https://github.com/nodejs/node/pull/9591)
* [[`3253954e62`](https://github.com/nodejs/node/commit/3253954e62)] - **meta**: whitelist dotfiles in .gitignore (Claudio Rodriguez) [#8016](https://github.com/nodejs/node/pull/8016)
* [[`cef3a04f62`](https://github.com/nodejs/node/commit/cef3a04f62)] - **promise**: better stack traces for --trace-warnings (Anna Henningsen) [#9525](https://github.com/nodejs/node/pull/9525)
* [[`a0f6cc718a`](https://github.com/nodejs/node/commit/a0f6cc718a)] - **repl**: avoid parsing division operator as regex (Teddy Katz) [#10103](https://github.com/nodejs/node/pull/10103)
* [[`6087e361e5`](https://github.com/nodejs/node/commit/6087e361e5)] - **repl**: preprocess only for defaultEval (Prince J Wesley) [#9752](https://github.com/nodejs/node/pull/9752)
* [[`9099664959`](https://github.com/nodejs/node/commit/9099664959)] - **repl**: fix generator function preprocessing (Teddy Katz) [#9852](https://github.com/nodejs/node/pull/9852)
* [[`9726c8271e`](https://github.com/nodejs/node/commit/9726c8271e)] - **test**: update parallel/test-crypto-hash.js (Deepti Agrawal) [#10009](https://github.com/nodejs/node/pull/10009)
* [[`7144f811a6`](https://github.com/nodejs/node/commit/7144f811a6)] - **test**: add test for url module domainToAscii and domainToUnicode (Daryl Thayil) [#10031](https://github.com/nodejs/node/pull/10031)
* [[`2f6d0c7e61`](https://github.com/nodejs/node/commit/2f6d0c7e61)] - **test**: refactor test-require-extensions-main (Daryl Thayil) [#9912](https://github.com/nodejs/node/pull/9912)
* [[`e718f2051c`](https://github.com/nodejs/node/commit/e718f2051c)] - **test**: refactor test-tls-ocsp-callback (k3kathy) [#9970](https://github.com/nodejs/node/pull/9970)
* [[`f5e622ea53`](https://github.com/nodejs/node/commit/f5e622ea53)] - **test**: use assert.strictEqual and fix setTimeout (Matt Phillips) [#9957](https://github.com/nodejs/node/pull/9957)
* [[`0a4fc64c3f`](https://github.com/nodejs/node/commit/0a4fc64c3f)] - **test**: clean up tls junk test (Danny Guo) [#9940](https://github.com/nodejs/node/pull/9940)
* [[`a3a664a321`](https://github.com/nodejs/node/commit/a3a664a321)] - **test**: update test-stdout-to-file (scalkpdev) [#9939](https://github.com/nodejs/node/pull/9939)
* [[`f531c96846`](https://github.com/nodejs/node/commit/f531c96846)] - **test**: changed assert.Equal to asset.strictEqual (Paul Chin) [#9973](https://github.com/nodejs/node/pull/9973)
* [[`843b8c1658`](https://github.com/nodejs/node/commit/843b8c1658)] - **test**: refactor test-domain-multi (Wes Tyler) [#9963](https://github.com/nodejs/node/pull/9963)
* [[`8936d835c1`](https://github.com/nodejs/node/commit/8936d835c1)] - **test**: refactor test-fs-write.js (hirabhullar) [#9982](https://github.com/nodejs/node/pull/9982)
* [[`2f731e5b5d`](https://github.com/nodejs/node/commit/2f731e5b5d)] - **test**: refactor test-child-fork-exec-path.js (hirabhullar) [#9982](https://github.com/nodejs/node/pull/9982)
* [[`d697ac404f`](https://github.com/nodejs/node/commit/d697ac404f)] - **test**: use assert.strictEqual in test-cli-eval (Nigel Kibodeaux) [#9919](https://github.com/nodejs/node/pull/9919)
* [[`0a07bccc5c`](https://github.com/nodejs/node/commit/0a07bccc5c)] - **test**: refactor test-tls-connect-simple (Russell Sherman) [#9934](https://github.com/nodejs/node/pull/9934)
* [[`371a785f6d`](https://github.com/nodejs/node/commit/371a785f6d)] - **test**: refactor test-signal-unregister (mark hughes) [#9920](https://github.com/nodejs/node/pull/9920)
* [[`79b36e927c`](https://github.com/nodejs/node/commit/79b36e927c)] - **test**: update test-net-connect-handle-econnrefused (Punit Buch) [#9932](https://github.com/nodejs/node/pull/9932)
* [[`ba7d1cf4bc`](https://github.com/nodejs/node/commit/ba7d1cf4bc)] - **test**: refactor test-require-resolve (blugavere) [#10120](https://github.com/nodejs/node/pull/10120)
* [[`1877ba3384`](https://github.com/nodejs/node/commit/1877ba3384)] - **test**: refactor test-fs-symlink-dir-junction (Walter Beller-Morales) [#9928](https://github.com/nodejs/node/pull/9928)
* [[`84813fdaf8`](https://github.com/nodejs/node/commit/84813fdaf8)] - **test**: refactor test-fs-read-stream-resume (Matt Webb) [#9927](https://github.com/nodejs/node/pull/9927)
* [[`f68bfc5bde`](https://github.com/nodejs/node/commit/f68bfc5bde)] - **test**: replace equal with strictEqual (Tracy Hinds) [#10011](https://github.com/nodejs/node/pull/10011)
* [[`c0eb08adbe`](https://github.com/nodejs/node/commit/c0eb08adbe)] - **test**: use strictEqual instead of equal (Uttam Pawar) [#9921](https://github.com/nodejs/node/pull/9921)
* [[`2e36b2ef49`](https://github.com/nodejs/node/commit/2e36b2ef49)] - **test**: using const and strictEqual (Fabrice Tatieze) [#9926](https://github.com/nodejs/node/pull/9926)
* [[`8e27254594`](https://github.com/nodejs/node/commit/8e27254594)] - **test**: convert assert.equal to assert.strictEqual (Jonathan Darling) [#9925](https://github.com/nodejs/node/pull/9925)
* [[`328cd93036`](https://github.com/nodejs/node/commit/328cd93036)] - **test**: changed assert.equal to assert.strictEqual (Scott Smereka) [#9936](https://github.com/nodejs/node/pull/9936)
* [[`cbdc64e026`](https://github.com/nodejs/node/commit/cbdc64e026)] - **test**: test-file-write-stream3.js refactor (Richard Karmazin) [#10035](https://github.com/nodejs/node/pull/10035)
* [[`7c90244677`](https://github.com/nodejs/node/commit/7c90244677)] - **test**: implemented es6 conventions (Erez Weiss) [#9669](https://github.com/nodejs/node/pull/9669)
* [[`bb677d41ce`](https://github.com/nodejs/node/commit/bb677d41ce)] - **test**: strictEqual() and RegExp in test-buffer-fill.js (J Scott Chapman) [#9895](https://github.com/nodejs/node/pull/9895)
* [[`34b8c86895`](https://github.com/nodejs/node/commit/34b8c86895)] - **test**: Modernize test-tls-peer-certificate.js (Ilya Potuzhnov) [#10014](https://github.com/nodejs/node/pull/10014)
* [[`5ad7e04280`](https://github.com/nodejs/node/commit/5ad7e04280)] - **test**: strictCompare and explcit inputs mprovement to test-buffer-slice (Michael Alexander) [#10048](https://github.com/nodejs/node/pull/10048)
* [[`256de35c98`](https://github.com/nodejs/node/commit/256de35c98)] - **test**: add test for process.stdin.setRawMode() (Jonathan Darling) [#10037](https://github.com/nodejs/node/pull/10037)
* [[`990a19fc7e`](https://github.com/nodejs/node/commit/990a19fc7e)] - **test**: refactor test for net listen on fd0 (Julian Duque) [#10025](https://github.com/nodejs/node/pull/10025)
* [[`7fd8833fa9`](https://github.com/nodejs/node/commit/7fd8833fa9)] - **test**: update assert.equal() to assert.strictEqual() (Peter Diaz) [#10024](https://github.com/nodejs/node/pull/10024)
* [[`fdc55ef02c`](https://github.com/nodejs/node/commit/fdc55ef02c)] - **test**: use const or let and assert.strictEqual (Christopher Rokita) [#10001](https://github.com/nodejs/node/pull/10001)
* [[`ae1ef5336d`](https://github.com/nodejs/node/commit/ae1ef5336d)] - **test**: fix buffer alloc tests (levsoroka) [#9998](https://github.com/nodejs/node/pull/9998)
* [[`e8fc7fcef7`](https://github.com/nodejs/node/commit/e8fc7fcef7)] - **test**: Added more validations to setEncoding (Paul Lucas) [#9997](https://github.com/nodejs/node/pull/9997)
* [[`79e6068d5c`](https://github.com/nodejs/node/commit/79e6068d5c)] - **test**: use strictEqual() domain-http (cdnadmin) [#9996](https://github.com/nodejs/node/pull/9996)
* [[`7428d80879`](https://github.com/nodejs/node/commit/7428d80879)] - **test**: refactor test-cluster-worker-events (fmizzell) [#9994](https://github.com/nodejs/node/pull/9994)
* [[`6df3b7babc`](https://github.com/nodejs/node/commit/6df3b7babc)] - **test**: update repl tests (makenova) [#9991](https://github.com/nodejs/node/pull/9991)
* [[`47b5f9e710`](https://github.com/nodejs/node/commit/47b5f9e710)] - **test**: modernize test-fs-truncate-fd (Nigel Kibodeaux) [#9978](https://github.com/nodejs/node/pull/9978)
* [[`8b6c45f4b4`](https://github.com/nodejs/node/commit/8b6c45f4b4)] - **test**: update tls test to use const/let and common.mustCall (rgoodwin) [#9968](https://github.com/nodejs/node/pull/9968)
* [[`c05909b3e8`](https://github.com/nodejs/node/commit/c05909b3e8)] - **test**: adding strictEqual to test-buffer-indexof.js (Eric Gonzalez) [#9955](https://github.com/nodejs/node/pull/9955)
* [[`d0852459d5`](https://github.com/nodejs/node/commit/d0852459d5)] - **test**: strictEqual in test-beforeexit-event.js (CodeTheInternet) [#10004](https://github.com/nodejs/node/pull/10004)
* [[`2beba9e025`](https://github.com/nodejs/node/commit/2beba9e025)] - **test**: refactor test-child-process-double-pipe (Dan Villa) [#9930](https://github.com/nodejs/node/pull/9930)
* [[`64b2494e90`](https://github.com/nodejs/node/commit/64b2494e90)] - **test**: updated tls-getcipher test (Ethan Arrowood) [#9923](https://github.com/nodejs/node/pull/9923)
* [[`e502262687`](https://github.com/nodejs/node/commit/e502262687)] - **test**: replace equal with strictEqual in test-freelist.js (Adrian Estrada) [#9910](https://github.com/nodejs/node/pull/9910)
* [[`5a2b68896c`](https://github.com/nodejs/node/commit/5a2b68896c)] - **test**: updated test-stream-pipe-unpipe-stream (Raja Panidepu) [#10100](https://github.com/nodejs/node/pull/10100)
* [[`f900753eeb`](https://github.com/nodejs/node/commit/f900753eeb)] - **test**: refactor test-crypto-ecb (michael6) [#10029](https://github.com/nodejs/node/pull/10029)
* [[`6502427761`](https://github.com/nodejs/node/commit/6502427761)] - **test**: refactor test-require-exceptions (Oscar Martinez) [#9882](https://github.com/nodejs/node/pull/9882)
* [[`a801ffb1ee`](https://github.com/nodejs/node/commit/a801ffb1ee)] - **test**: refactor test-console (Matt Crummey) [#9873](https://github.com/nodejs/node/pull/9873)
* [[`bca587bdb3`](https://github.com/nodejs/node/commit/bca587bdb3)] - **test**: refactor test-crypto-certificate (Josh Mays) [#9911](https://github.com/nodejs/node/pull/9911)
* [[`278772a5df`](https://github.com/nodejs/node/commit/278772a5df)] - **test**: refactor dgram-send-multi-buffer-copy (Konstantin Likhter) [#9909](https://github.com/nodejs/node/pull/9909)
* [[`6d5ded508e`](https://github.com/nodejs/node/commit/6d5ded508e)] - **test**: refactor test-domain (Johnny Reading) [#9890](https://github.com/nodejs/node/pull/9890)
* [[`318a2dbea4`](https://github.com/nodejs/node/commit/318a2dbea4)] - **test**: refactor test-cli-syntax (Exlipse7) [#10057](https://github.com/nodejs/node/pull/10057)
* [[`da8e3d946a`](https://github.com/nodejs/node/commit/da8e3d946a)] - **test**: refactor test-child-process-constructor (k3kathy) [#10060](https://github.com/nodejs/node/pull/10060)
* [[`9fddf29f53`](https://github.com/nodejs/node/commit/9fddf29f53)] - **test**: refactor test-repl-mode.js (Cesar Hernandez) [#10061](https://github.com/nodejs/node/pull/10061)
* [[`65c44830c2`](https://github.com/nodejs/node/commit/65c44830c2)] - **test**: var to const, assert.equal to assert.strictEqual in net (Sean Villars) [#9907](https://github.com/nodejs/node/pull/9907)
* [[`ef7cbde0a2`](https://github.com/nodejs/node/commit/ef7cbde0a2)] - **test**: changed vars to const in test-net-better-error-messages-listen-path.js (anoff) [#9905](https://github.com/nodejs/node/pull/9905)
* [[`f62567b7f8`](https://github.com/nodejs/node/commit/f62567b7f8)] - **test**: use const instead of var in test-require-json.js (Sarah Meyer) [#9904](https://github.com/nodejs/node/pull/9904)
* [[`5f3f54d4bb`](https://github.com/nodejs/node/commit/5f3f54d4bb)] - **test**: refactor test-http-dns-error (Outsider) [#10062](https://github.com/nodejs/node/pull/10062)
* [[`ae2bf0a761`](https://github.com/nodejs/node/commit/ae2bf0a761)] - **test**: Changed assert.equal to assert.strictEqual (Daniel Pittman) [#9902](https://github.com/nodejs/node/pull/9902)
* [[`1eb581779d`](https://github.com/nodejs/node/commit/1eb581779d)] - **test**: refactor test-vm-syntax-error-stderr.js (Jay Brownlee) [#9900](https://github.com/nodejs/node/pull/9900)
* [[`c456ca3601`](https://github.com/nodejs/node/commit/c456ca3601)] - **test**: refactor test-tls-destroy-whilst-write (Chris Bystrek) [#10064](https://github.com/nodejs/node/pull/10064)
* [[`fd17ca7710`](https://github.com/nodejs/node/commit/fd17ca7710)] - **test**: refactor test-net-dns-custom-lookup (Kent.Fan) [#10071](https://github.com/nodejs/node/pull/10071)
* [[`cf3c635dba`](https://github.com/nodejs/node/commit/cf3c635dba)] - **test**: refactor test-https-truncate (davidmarkclements) [#10074](https://github.com/nodejs/node/pull/10074)
* [[`14c0388945`](https://github.com/nodejs/node/commit/14c0388945)] - **test**: refactor test-tls-server-verify (Hutson Betts) [#10076](https://github.com/nodejs/node/pull/10076)
* [[`36b8dd3b07`](https://github.com/nodejs/node/commit/36b8dd3b07)] - **test**: refactor test-crypto-padding.js (Konstantin Likhter) [#9971](https://github.com/nodejs/node/pull/9971)
* [[`38ec8e44fa`](https://github.com/nodejs/node/commit/38ec8e44fa)] - **test**: improve test for crypto padding (Julian Duque) [#9906](https://github.com/nodejs/node/pull/9906)
* [[`a771f2181c`](https://github.com/nodejs/node/commit/a771f2181c)] - **test**: use strictEqual in test-cli-eval-event.js (Richard Karmazin) [#9964](https://github.com/nodejs/node/pull/9964)
* [[`e1394eeb16`](https://github.com/nodejs/node/commit/e1394eeb16)] - **test**: refactor test-tls-friendly-error-message.js (Adrian Estrada) [#9967](https://github.com/nodejs/node/pull/9967)
* [[`69077a13bf`](https://github.com/nodejs/node/commit/69077a13bf)] - **test**: refactor test-fs-append-file.js (adelmann) [#10110](https://github.com/nodejs/node/pull/10110)
* [[`baa1accdb1`](https://github.com/nodejs/node/commit/baa1accdb1)] - **test**: assert.equal -> assert.strictEqual (davidmarkclements) [#10065](https://github.com/nodejs/node/pull/10065)
* [[`a34e19532c`](https://github.com/nodejs/node/commit/a34e19532c)] - **test**: refactor test-dgram-exclusive-implicit-bind (Cesar Hernandez) [#10066](https://github.com/nodejs/node/pull/10066)
* [[`d87926ae34`](https://github.com/nodejs/node/commit/d87926ae34)] - **test**: assert.equal -> assert.strictEqual (davidmarkclements) [#10067](https://github.com/nodejs/node/pull/10067)
* [[`c4902e44ad`](https://github.com/nodejs/node/commit/c4902e44ad)] - **test**: polish test-net-better-error-messages-listen (Hitesh Kanwathirtha) [#10087](https://github.com/nodejs/node/pull/10087)
* [[`9b9fe8c5ac`](https://github.com/nodejs/node/commit/9b9fe8c5ac)] - **test**: change var to const in test-tls-key-mismatch.js (bjdelro) [#9897](https://github.com/nodejs/node/pull/9897)
* [[`7697aee7da`](https://github.com/nodejs/node/commit/7697aee7da)] - **test**: use strictEqual in cwd-enoent (JDHarmon) [#10077](https://github.com/nodejs/node/pull/10077)
* [[`cdc2909882`](https://github.com/nodejs/node/commit/cdc2909882)] - **test**: refactor test-fs-read-stream-inherit.js (Jonathan Darling) [#9894](https://github.com/nodejs/node/pull/9894)
* [[`55b58baed1`](https://github.com/nodejs/node/commit/55b58baed1)] - **test**: use assert.strictEqual in test-crypto-ecb (Daniel Pittman) [#9980](https://github.com/nodejs/node/pull/9980)
* [[`e070588a8a`](https://github.com/nodejs/node/commit/e070588a8a)] - **test**: refactor test-child-process-stdio-inherit (Wes Tyler) [#9893](https://github.com/nodejs/node/pull/9893)
* [[`22b15f2ab6`](https://github.com/nodejs/node/commit/22b15f2ab6)] - **test**: change var to const for require and strict equality checks (Harish Tejwani) [#9892](https://github.com/nodejs/node/pull/9892)
* [[`2a8d29339d`](https://github.com/nodejs/node/commit/2a8d29339d)] - **test**: Update to const and use regex for assertions (Daniel Flores) [#9891](https://github.com/nodejs/node/pull/9891)
* [[`295eb5a3b6`](https://github.com/nodejs/node/commit/295eb5a3b6)] - **test**: swap var->const/let and equal->strictEqual (Peter Masucci) [#9888](https://github.com/nodejs/node/pull/9888)
* [[`57f060c495`](https://github.com/nodejs/node/commit/57f060c495)] - **test**: replace equal with strictEqual in crypto (Julian Duque) [#9886](https://github.com/nodejs/node/pull/9886)
* [[`3d35930b2c`](https://github.com/nodejs/node/commit/3d35930b2c)] - **test**: replace equal with strictEqual (Julian Duque) [#9879](https://github.com/nodejs/node/pull/9879)
* [[`13cc6a005b`](https://github.com/nodejs/node/commit/13cc6a005b)] - **test**: var to const/let in test-tls-set-ciphers (rajatk) [#9877](https://github.com/nodejs/node/pull/9877)
* [[`f3eb8b1bea`](https://github.com/nodejs/node/commit/f3eb8b1bea)] - **test**: refactor test-tls-timeout-server-2 (Devon Rifkin) [#9876](https://github.com/nodejs/node/pull/9876)
* [[`dc76a20474`](https://github.com/nodejs/node/commit/dc76a20474)] - **test**: Updating vars to const and tsl server test (Matt Webb) [#9874](https://github.com/nodejs/node/pull/9874)
* [[`63fafb8aca`](https://github.com/nodejs/node/commit/63fafb8aca)] - **test**: refactor test-crypto-hash-stream-pipe (Matt Wilson) [#10055](https://github.com/nodejs/node/pull/10055)
* [[`fb4b650159`](https://github.com/nodejs/node/commit/fb4b650159)] - **test**: crypto-hash-stream-pipe use strict equal (Mitchell Stoutin) [#9935](https://github.com/nodejs/node/pull/9935)
* [[`8f550df252`](https://github.com/nodejs/node/commit/8f550df252)] - **test**: refactor child-process-spawn-error (Johnny Reading) [#9951](https://github.com/nodejs/node/pull/9951)
* [[`b73f6b760f`](https://github.com/nodejs/node/commit/b73f6b760f)] - **test**: refactor test-child-process-spawn-error (stokingerl) [#9937](https://github.com/nodejs/node/pull/9937)
* [[`371ca03568`](https://github.com/nodejs/node/commit/371ca03568)] - **test**: refactor test-vm-static-this.js (David Bradford) [#9887](https://github.com/nodejs/node/pull/9887)
* [[`3e37673d5c`](https://github.com/nodejs/node/commit/3e37673d5c)] - **test**: refactor test-crypto-cipheriv-decipheriv (Aileen) [#10018](https://github.com/nodejs/node/pull/10018)
* [[`f76bb2adf8`](https://github.com/nodejs/node/commit/f76bb2adf8)] - **test**: refactor test for crypto cipher/decipher iv (Julian Duque) [#9943](https://github.com/nodejs/node/pull/9943)
* [[`4cc813d8b9`](https://github.com/nodejs/node/commit/4cc813d8b9)] - **test**: refactor test-cluster-setup-master-argv (Oscar Martinez) [#9960](https://github.com/nodejs/node/pull/9960)
* [[`eb0c1cd412`](https://github.com/nodejs/node/commit/eb0c1cd412)] - **test**: refactor test-cluster-setup-master-argv (Christine Hong) [#9993](https://github.com/nodejs/node/pull/9993)
* [[`d2e89272d2`](https://github.com/nodejs/node/commit/d2e89272d2)] - **test**: refactor test-fs-append-file-sync (Chris Bystrek) [#10056](https://github.com/nodejs/node/pull/10056)
* [[`070370fd0a`](https://github.com/nodejs/node/commit/070370fd0a)] - **test**: refactor test-fs-append-file-sync (Ian White) [#9977](https://github.com/nodejs/node/pull/9977)
* [[`87038bb628`](https://github.com/nodejs/node/commit/87038bb628)] - **test**: refactor test-fs-write-file (adelmann) [#10030](https://github.com/nodejs/node/pull/10030)
* [[`1f6f411234`](https://github.com/nodejs/node/commit/1f6f411234)] - **test**: refactor test/parallel/test-fs-write-file.js (Kyle Carter) [#9992](https://github.com/nodejs/node/pull/9992)
* [[`4cb52ee827`](https://github.com/nodejs/node/commit/4cb52ee827)] - **test**: update to const iin cluster test (Greg Valdez) [#10007](https://github.com/nodejs/node/pull/10007)
* [[`f9d79ef597`](https://github.com/nodejs/node/commit/f9d79ef597)] - **test**: use assert.strictEqual() cluster test (Bidur Adhikari) [#10042](https://github.com/nodejs/node/pull/10042)
* [[`b4ec7d6c50`](https://github.com/nodejs/node/commit/b4ec7d6c50)] - **test**: use const in test-crypto-pbkdf2 (Greg Valdez) [#9974](https://github.com/nodejs/node/pull/9974)
* [[`2e889cf056`](https://github.com/nodejs/node/commit/2e889cf056)] - **test**: improve test for crypto pbkdf2 (joyeecheung) [#9883](https://github.com/nodejs/node/pull/9883)
* [[`c0a28622ce`](https://github.com/nodejs/node/commit/c0a28622ce)] - **test**: var -> let/const, .equal -> .strictEqual (shiya) [#9913](https://github.com/nodejs/node/pull/9913)
* [[`d1da89906d`](https://github.com/nodejs/node/commit/d1da89906d)] - **test**: increase coverage for timers (lrlna) [#10068](https://github.com/nodejs/node/pull/10068)
* [[`44d9bc8b90`](https://github.com/nodejs/node/commit/44d9bc8b90)] - **test**: change equal to strictEqual (Kevin Zurawel) [#9872](https://github.com/nodejs/node/pull/9872)
* [[`0cab6eb6ca`](https://github.com/nodejs/node/commit/0cab6eb6ca)] - **test**: test for http.request() invalid method error (Ashton Kinslow) [#10080](https://github.com/nodejs/node/pull/10080)
* [[`f9386f2846`](https://github.com/nodejs/node/commit/f9386f2846)] - **test**: update net-local-address-port (scalkpdev) [#9885](https://github.com/nodejs/node/pull/9885)
* [[`66554c75d5`](https://github.com/nodejs/node/commit/66554c75d5)] - **test**: refactor test-tls-ecdh (Adriana Rios) [#9878](https://github.com/nodejs/node/pull/9878)
* [[`a857c9a74c`](https://github.com/nodejs/node/commit/a857c9a74c)] - **test**: refactor test-vm-debug-context (makenova) [#9875](https://github.com/nodejs/node/pull/9875)
* [[`a6377a96dd`](https://github.com/nodejs/node/commit/a6377a96dd)] - **test**: increase coverage for lib/events.js (Safia Abdalla) [#9865](https://github.com/nodejs/node/pull/9865)
* [[`eb369f6d48`](https://github.com/nodejs/node/commit/eb369f6d48)] - **test**: use strictEqual in test-zlib-truncated (ben_cripps) [#9858](https://github.com/nodejs/node/pull/9858)
* [[`3af4ef4642`](https://github.com/nodejs/node/commit/3af4ef4642)] - **test**: use strictEqual in test-debugger-client.js (ben_cripps) [#9857](https://github.com/nodejs/node/pull/9857)
* [[`5c15a68091`](https://github.com/nodejs/node/commit/5c15a68091)] - **test**: refactor test-debug-args (Rich Trott) [#9833](https://github.com/nodejs/node/pull/9833)
* [[`0e36becd39`](https://github.com/nodejs/node/commit/0e36becd39)] - **test**: refactor test-fs-non-number-arguments-throw (Michaël Zasso) [#9844](https://github.com/nodejs/node/pull/9844)
* [[`c286312ef5`](https://github.com/nodejs/node/commit/c286312ef5)] - **test**: replace assert.equal with assert.strictEqual (brad-decker) [#9842](https://github.com/nodejs/node/pull/9842)
* [[`0ccb2c3992`](https://github.com/nodejs/node/commit/0ccb2c3992)] - **test**: refactor test-crypto-timing-safe-equal (Michaël Zasso) [#9843](https://github.com/nodejs/node/pull/9843)
* [[`0bdd5ca0f7`](https://github.com/nodejs/node/commit/0bdd5ca0f7)] - **test**: run cpplint on files in test/cctest (Ben Noordhuis) [#9787](https://github.com/nodejs/node/pull/9787)
* [[`956239124d`](https://github.com/nodejs/node/commit/956239124d)] - **test**: add toASCII and toUnicode punycode tests (Claudio Rodriguez) [#9741](https://github.com/nodejs/node/pull/9741)
* [[`70633f965d`](https://github.com/nodejs/node/commit/70633f965d)] - **test**: refactor test-util-inspect (Rich Trott) [#9804](https://github.com/nodejs/node/pull/9804)
* [[`4c2ad8c89f`](https://github.com/nodejs/node/commit/4c2ad8c89f)] - **test**: refactor test-preload (Rich Trott) [#9803](https://github.com/nodejs/node/pull/9803)
* [[`59aec82f88`](https://github.com/nodejs/node/commit/59aec82f88)] - **test**: refine test-http-status-reason-invalid-chars (Rich Trott) [#9802](https://github.com/nodejs/node/pull/9802)
* [[`c35bf44f60`](https://github.com/nodejs/node/commit/c35bf44f60)] - **test**: refactor test-crypto-binary-default (Michaël Zasso) [#9810](https://github.com/nodejs/node/pull/9810)
* [[`4d1e11243b`](https://github.com/nodejs/node/commit/4d1e11243b)] - **test**: refactor and fix test-crypto (Michaël Zasso) [#9807](https://github.com/nodejs/node/pull/9807)
* [[`74c3283cfa`](https://github.com/nodejs/node/commit/74c3283cfa)] - **test**: fix test-buffer-slow (Michaël Zasso) [#9809](https://github.com/nodejs/node/pull/9809)
* [[`e2db5c8e7a`](https://github.com/nodejs/node/commit/e2db5c8e7a)] - **test**: refactor test-net-pingpong (Michaël Zasso) [#9812](https://github.com/nodejs/node/pull/9812)
* [[`cd10e1ae4a`](https://github.com/nodejs/node/commit/cd10e1ae4a)] - **test**: refactor and fix test-dns (Michaël Zasso) [#9811](https://github.com/nodejs/node/pull/9811)
* [[`dcba25082f`](https://github.com/nodejs/node/commit/dcba25082f)] - **test**: refactor and fix test-buffer-bytelength (Michaël Zasso) [#9808](https://github.com/nodejs/node/pull/9808)
* [[`d06f010482`](https://github.com/nodejs/node/commit/d06f010482)] - **test**: cleanup test-dgram-error-message-address (Michael Macherey) [#8938](https://github.com/nodejs/node/pull/8938)
* [[`3b193defb2`](https://github.com/nodejs/node/commit/3b193defb2)] - **test**: fix flaky test-cluster-dgram-2 (Rich Trott) [#9791](https://github.com/nodejs/node/pull/9791)
* [[`3f1b068644`](https://github.com/nodejs/node/commit/3f1b068644)] - **test**: refactor common.js (Rich Trott) [#9732](https://github.com/nodejs/node/pull/9732)
* [[`d31a41149d`](https://github.com/nodejs/node/commit/d31a41149d)] - **test**: fix test-tls-connect-address-family (mkamakura) [#9573](https://github.com/nodejs/node/pull/9573)
* [[`d51c856f11`](https://github.com/nodejs/node/commit/d51c856f11)] - **test**: fix test-http-status-reason-invalid-chars (Yosuke Saito) [#9572](https://github.com/nodejs/node/pull/9572)
* [[`b763a31af0`](https://github.com/nodejs/node/commit/b763a31af0)] - **test**: refactor test-child-process-exec-error (Rich Trott) [#9780](https://github.com/nodejs/node/pull/9780)
* [[`2b7ecb5012`](https://github.com/nodejs/node/commit/2b7ecb5012)] - **test**: exclude no_interleaved_stdio test for AIX (Michael Dawson) [#9772](https://github.com/nodejs/node/pull/9772)
* [[`4971c3bb79`](https://github.com/nodejs/node/commit/4971c3bb79)] - **test**: fix flaky test-dgram-empty-packet & friends (Rich Trott) [#9724](https://github.com/nodejs/node/pull/9724)
* [[`2fb825750d`](https://github.com/nodejs/node/commit/2fb825750d)] - **test**: fix flaky test-inspector (Rich Trott) [#9727](https://github.com/nodejs/node/pull/9727)
* [[`fc13cc6a12`](https://github.com/nodejs/node/commit/fc13cc6a12)] - **test**: refactor test-tls-hello-parser-failure (Rich Trott) [#9715](https://github.com/nodejs/node/pull/9715)
* [[`ea1c4e1212`](https://github.com/nodejs/node/commit/ea1c4e1212)] - **test,url**: improve escaping in url.parse (joyeecheung) [#10083](https://github.com/nodejs/node/pull/10083)
* [[`64854f625b`](https://github.com/nodejs/node/commit/64854f625b)] - **tools**: add ESLint rule for assert.throws arguments (Michaël Zasso) [#10089](https://github.com/nodejs/node/pull/10089)
* [[`2ee3543e04`](https://github.com/nodejs/node/commit/2ee3543e04)] - **tools**: remove unneeded escaping in generate.js (Rich Trott) [#9781](https://github.com/nodejs/node/pull/9781)
* [[`53d175267c`](https://github.com/nodejs/node/commit/53d175267c)] - **tools**: Add no useless regex char class rule (Prince J Wesley) [#9591](https://github.com/nodejs/node/pull/9591)
* [[`561b1494bc`](https://github.com/nodejs/node/commit/561b1494bc)] - **tools**: allow test.py to use full paths of tests (Francis Gulotta) [#9694](https://github.com/nodejs/node/pull/9694)
* [[`5ae549c3aa`](https://github.com/nodejs/node/commit/5ae549c3aa)] - **url**: fix -Warray-bounds warning (Santiago Gimeno) [#9751](https://github.com/nodejs/node/pull/9751)

<a id="7.2.0"></a>
## 2016-11-22, Version 7.2.0 (Current), @Fishrock123

_This is a security release impacting Windows 10 users._

### Notable changes

* **crypto**: The `Decipher` methods `setAuthTag()` and `setAAD` now return `this`. (Kirill Fomichev) [#9398](https://github.com/nodejs/node/pull/9398)
* **dns**: Implemented `{ttl: true}` for `resolve4()` and `resolve6()`. (Ben Noordhuis) [#9296](https://github.com/nodejs/node/pull/9296)
* **libuv**: Upgrade to v1.10.1 (cjihrig) [#9647](https://github.com/nodejs/node/pull/9647)
  * Fixed a potential buffer overflow when writing data to console on Windows 10. (CVE-2016-9551)
* **process**: Added a new `external` property to the data returned by `memoryUsage()`. (Fedor Indutny) [#9587](https://github.com/nodejs/node/pull/9587)
* **tls**: Fixed a memory leak when writes were queued on TLS connection that was destroyed during handshake. (Fedor Indutny) [#9626](https://github.com/nodejs/node/pull/9626)
* **V8 (dep)**: Upgrade to v5.4.500.43 (Michaël Zasso) [#9697](https://github.com/nodejs/node/pull/9697)
* **v8**: The data returned by `getHeapStatistics()` now includes three new fields: `malloced_memory`, `peak_malloced_memory`, and `does_zap_garbage`. (Gareth Ellis) [#8610](https://github.com/nodejs/node/pull/8610)

### Commits

* [[`819a38df96`](https://github.com/nodejs/node/commit/819a38df96)] - **benchmark**: split timers benchmark and refactor (Rich Trott) [#9497](https://github.com/nodejs/node/pull/9497)
* [[`0083bf2233`](https://github.com/nodejs/node/commit/0083bf2233)] - **build**: default to ppc64 on AIX (Gibson Fahnestock) [#9645](https://github.com/nodejs/node/pull/9645)
* [[`3efb43c8ba`](https://github.com/nodejs/node/commit/3efb43c8ba)] - **build**: Add option to compile for coverage reports (Wayne Andrews) [#9463](https://github.com/nodejs/node/pull/9463)
* [[`af74db3961`](https://github.com/nodejs/node/commit/af74db3961)] - **crypto**: use SSL_get_servername. (Adam Langley) [#9347](https://github.com/nodejs/node/pull/9347)
* [[`bcdbf22f0d`](https://github.com/nodejs/node/commit/bcdbf22f0d)] - **crypto**: fix handling of root_cert_store. (Adam Langley) [#9409](https://github.com/nodejs/node/pull/9409)
* [[`3f45cc19b0`](https://github.com/nodejs/node/commit/3f45cc19b0)] - **crypto**: Use reference count to manage cert_store (Adam Majer) [#9409](https://github.com/nodejs/node/pull/9409)
* [[`08a7e7b009`](https://github.com/nodejs/node/commit/08a7e7b009)] - **(SEMVER-MINOR)** **crypto**: return `this` in setAuthTag/setAAD (Kirill Fomichev) [#9398](https://github.com/nodejs/node/pull/9398)
* [[`786631c7b4`](https://github.com/nodejs/node/commit/786631c7b4)] - **deps**: upgrade libuv to 1.10.1 (cjihrig) [#9647](https://github.com/nodejs/node/pull/9647)
* [[`1520afd336`](https://github.com/nodejs/node/commit/1520afd336)] - **deps**: update V8 to 5.4.500.43 (Michaël Zasso) [#9697](https://github.com/nodejs/node/pull/9697)
* [[`33bcd6fec8`](https://github.com/nodejs/node/commit/33bcd6fec8)] - **deps**: update V8 to 5.4.500.41 (Michaël Zasso) [#9412](https://github.com/nodejs/node/pull/9412)
* [[`0a3e5cc57a`](https://github.com/nodejs/node/commit/0a3e5cc57a)] - **(SEMVER-MINOR)** **dns**: implement {ttl: true} for dns.resolve6() (Ben Noordhuis) [#9296](https://github.com/nodejs/node/pull/9296)
* [[`1bd79368cd`](https://github.com/nodejs/node/commit/1bd79368cd)] - **(SEMVER-MINOR)** **dns**: implement {ttl: true} for dns.resolve4() (Ben Noordhuis) [#9296](https://github.com/nodejs/node/pull/9296)
* [[`fa98eec410`](https://github.com/nodejs/node/commit/fa98eec410)] - **doc**: fix typo in assert code example (Vse Mozhet Byt) [#9704](https://github.com/nodejs/node/pull/9704)
* [[`409851427a`](https://github.com/nodejs/node/commit/409851427a)] - **doc**: fix typo in doc/tls.md (Syuhei Kobayashi) [#9566](https://github.com/nodejs/node/pull/9566)
* [[`ebc9c4ba97`](https://github.com/nodejs/node/commit/ebc9c4ba97)] - **doc**: add missing link in changelog (Evan Lucas) [#9540](https://github.com/nodejs/node/pull/9540)
* [[`bbd5853236`](https://github.com/nodejs/node/commit/bbd5853236)] - **doc**: v6 is now LTS rather than Current (Jeremiah Senkpiel) [#9182](https://github.com/nodejs/node/pull/9182)
* [[`8030994554`](https://github.com/nodejs/node/commit/8030994554)] - **doc**: fix some table problems in changelog.md (Jeremiah Senkpiel) [#9183](https://github.com/nodejs/node/pull/9183)
* [[`b070df8932`](https://github.com/nodejs/node/commit/b070df8932)] - **doc**: fix typo in BUILDING.md (monkick) [#9569](https://github.com/nodejs/node/pull/9569)
* [[`39f04829d6`](https://github.com/nodejs/node/commit/39f04829d6)] - **doc**: remove backtick escaping for manpage refs (Anna Henningsen) [#9632](https://github.com/nodejs/node/pull/9632)
* [[`159799aa1d`](https://github.com/nodejs/node/commit/159799aa1d)] - **doc**: improve description of urlObject.query (Rahat Ahmed) [#9625](https://github.com/nodejs/node/pull/9625)
* [[`d62376c8d6`](https://github.com/nodejs/node/commit/d62376c8d6)] - **doc**: small improvements in readline code examples (Vse Mozhet Byt) [#9628](https://github.com/nodejs/node/pull/9628)
* [[`69ffe0cf8c`](https://github.com/nodejs/node/commit/69ffe0cf8c)] - **doc**: child_process .stdio accepts a String type (Kenneth Skovhus) [#9637](https://github.com/nodejs/node/pull/9637)
* [[`c99fb1e0d2`](https://github.com/nodejs/node/commit/c99fb1e0d2)] - **doc**: remove invalid padding from privateEncrypt (JungMinu) [#9611](https://github.com/nodejs/node/pull/9611)
* [[`b258a70a40`](https://github.com/nodejs/node/commit/b258a70a40)] - **doc**: add return types and props types to OS module (imatvieiev) [#9648](https://github.com/nodejs/node/pull/9648)
* [[`425a8646e2`](https://github.com/nodejs/node/commit/425a8646e2)] - **doc**: add italoacasas to collaborators (Italo A. Casas) [#9677](https://github.com/nodejs/node/pull/9677)
* [[`8bf42b4ec4`](https://github.com/nodejs/node/commit/8bf42b4ec4)] - **doc**: strip trailing whitespace (Sam Roberts) [#9620](https://github.com/nodejs/node/pull/9620)
* [[`16819d29b0`](https://github.com/nodejs/node/commit/16819d29b0)] - **doc**: fix "either as either" typo (Sam Roberts) [#9665](https://github.com/nodejs/node/pull/9665)
* [[`c18ca1593e`](https://github.com/nodejs/node/commit/c18ca1593e)] - **doc**: fix tls "the the" typo (Sam Roberts) [#9665](https://github.com/nodejs/node/pull/9665)
* [[`f43e47aab2`](https://github.com/nodejs/node/commit/f43e47aab2)] - **doc**: describe when a tls server emits 'close' (Sam Roberts) [#9665](https://github.com/nodejs/node/pull/9665)
* [[`a086566be6`](https://github.com/nodejs/node/commit/a086566be6)] - **doc**: fix an SNI mistyped as SNS (Sam Roberts) [#9665](https://github.com/nodejs/node/pull/9665)
* [[`4ddc23828d`](https://github.com/nodejs/node/commit/4ddc23828d)] - **doc**: move TSC and CTC meeting minutes out of core repo (James M Snell) [#9503](https://github.com/nodejs/node/pull/9503)
* [[`474d4aa2e3`](https://github.com/nodejs/node/commit/474d4aa2e3)] - **doc**: fix typo in doc/repl.md line: 6 (Mitsuo Utano) [#9582](https://github.com/nodejs/node/pull/9582)
* [[`7af680e6fe`](https://github.com/nodejs/node/commit/7af680e6fe)] - **doc**: make comment indentation consistent (Daniel Bevenius) [#9518](https://github.com/nodejs/node/pull/9518)
* [[`d964eacd6a`](https://github.com/nodejs/node/commit/d964eacd6a)] - **doc**: remove redundant warning information (Brian White) [#9590](https://github.com/nodejs/node/pull/9590)
* [[`25a6f88d98`](https://github.com/nodejs/node/commit/25a6f88d98)] - **doc**: improve process.emitWarning() example (Brian White) [#9590](https://github.com/nodejs/node/pull/9590)
* [[`d5fa1d5307`](https://github.com/nodejs/node/commit/d5fa1d5307)] - **doc**: clarify eventType in fs.watch (Nikolai Vavilov) [#9318](https://github.com/nodejs/node/pull/9318)
* [[`3014dfd254`](https://github.com/nodejs/node/commit/3014dfd254)] - **doc**: wrap long lines in http.request (Timothy Gu) [#9584](https://github.com/nodejs/node/pull/9584)
* [[`89216a45b7`](https://github.com/nodejs/node/commit/89216a45b7)] - **doc**: fix type of http.request's `agent` option (Timothy Gu) [#9584](https://github.com/nodejs/node/pull/9584)
* [[`bff4e88f0b`](https://github.com/nodejs/node/commit/bff4e88f0b)] - **doc**: fix a typo in the assert.md (Vse Mozhet Byt) [#9598](https://github.com/nodejs/node/pull/9598)
* [[`d83cb48b3a`](https://github.com/nodejs/node/commit/d83cb48b3a)] - **doc**: fix typo e.g., => e.g. (Daijiro Yamada) [#9563](https://github.com/nodejs/node/pull/9563)
* [[`d532a57a4b`](https://github.com/nodejs/node/commit/d532a57a4b)] - **doc**: consistent 'Returns:' (Roman Reiss) [#9554](https://github.com/nodejs/node/pull/9554)
* [[`92bd19e0bd`](https://github.com/nodejs/node/commit/92bd19e0bd)] - **doc**: simplify process.memoryUsage() example code (Thomas Watson Steen) [#9560](https://github.com/nodejs/node/pull/9560)
* [[`4ae4e00ae9`](https://github.com/nodejs/node/commit/4ae4e00ae9)] - **doc**: fix typo about cluster doc, (eg. -> e.g.) (YutamaKotaro) [#9568](https://github.com/nodejs/node/pull/9568)
* [[`64dec14502`](https://github.com/nodejs/node/commit/64dec14502)] - **doc**: fix e.g., to e.g. in doc/http.md (ikasumi_wt) [#9564](https://github.com/nodejs/node/pull/9564)
* [[`7c9e8cbd76`](https://github.com/nodejs/node/commit/7c9e8cbd76)] - **doc**: fix the index order in pseudocode of modules (kohta ito) [#9562](https://github.com/nodejs/node/pull/9562)
* [[`d09a9f4d27`](https://github.com/nodejs/node/commit/d09a9f4d27)] - **doc**: remove Roadmap Working Group (William Kapke) [#9545](https://github.com/nodejs/node/pull/9545)
* [[`77aded3ba1`](https://github.com/nodejs/node/commit/77aded3ba1)] - **doc**: add process api data types to documentation (imatvieiev) [#9505](https://github.com/nodejs/node/pull/9505)
* [[`7488b0041f`](https://github.com/nodejs/node/commit/7488b0041f)] - **doc**: added types to path docs (imatvieiev) [#9514](https://github.com/nodejs/node/pull/9514)
* [[`549b6f23db`](https://github.com/nodejs/node/commit/549b6f23db)] - **doc**: fix fs constants link (Timothy) [#9508](https://github.com/nodejs/node/pull/9508)
* [[`31a34d7992`](https://github.com/nodejs/node/commit/31a34d7992)] - **doc**: fix minor style issue in code examples (Daniel Bevenius) [#9482](https://github.com/nodejs/node/pull/9482)
* [[`a412b9fa9a`](https://github.com/nodejs/node/commit/a412b9fa9a)] - **doc**: grammar and structure revisions of wg doc (Ryan Lewis) [#9495](https://github.com/nodejs/node/pull/9495)
* [[`92f163e465`](https://github.com/nodejs/node/commit/92f163e465)] - **doc**: clarify the exit code part of writing_tests (Jeremiah Senkpiel) [#9502](https://github.com/nodejs/node/pull/9502)
* [[`62478eb3d9`](https://github.com/nodejs/node/commit/62478eb3d9)] - **doc**: fix link to Event Loop page (timathon) [#9527](https://github.com/nodejs/node/pull/9527)
* [[`c07f648662`](https://github.com/nodejs/node/commit/c07f648662)] - **doc**: Fix inaccuracy in https.request docs (Andreas Lind) [#9453](https://github.com/nodejs/node/pull/9453)
* [[`6f513e0b46`](https://github.com/nodejs/node/commit/6f513e0b46)] - **doc**: add npm link to README (Oscar Morrison) [#7894](https://github.com/nodejs/node/pull/7894)
* [[`f0d40e8be3`](https://github.com/nodejs/node/commit/f0d40e8be3)] - **doc**: fix link to cli.md in vm.md (Daniel Bevenius) [#9481](https://github.com/nodejs/node/pull/9481)
* [[`8a9c45a4a9`](https://github.com/nodejs/node/commit/8a9c45a4a9)] - **fs**: Fix default params for fs.write(Sync) (Andreas Lind) [#7856](https://github.com/nodejs/node/pull/7856)
* [[`9a0bcfc452`](https://github.com/nodejs/node/commit/9a0bcfc452)] - **fs**: export `realpathCacheKey` from `internal/fs` (Anna Henningsen) [#8862](https://github.com/nodejs/node/pull/8862)
* [[`6b01bfa9d6`](https://github.com/nodejs/node/commit/6b01bfa9d6)] - **gitignore**: ignore all tap files (Johan Bergström) [#9262](https://github.com/nodejs/node/pull/9262)
* [[`23584e4ec5`](https://github.com/nodejs/node/commit/23584e4ec5)] - **gtest**: output tap comments as yamlish (Johan Bergström) [#9262](https://github.com/nodejs/node/pull/9262)
* [[`f5442ece33`](https://github.com/nodejs/node/commit/f5442ece33)] - **lib,test**: remove unneeded escaping of / (Rich Trott) [#9485](https://github.com/nodejs/node/pull/9485)
* [[`34c8b0b411`](https://github.com/nodejs/node/commit/34c8b0b411)] - **module**: check -e flag in debug break setup (Kelvin Jin) [#8876](https://github.com/nodejs/node/pull/8876)
* [[`163397a206`](https://github.com/nodejs/node/commit/163397a206)] - **(SEMVER-MINOR)** **process**: add `process.memoryUsage.external` (Fedor Indutny) [#9587](https://github.com/nodejs/node/pull/9587)
* [[`15af912ab5`](https://github.com/nodejs/node/commit/15af912ab5)] - **src**: fix memory leak introduced in 34febfbf4 (Ben Noordhuis) [#9604](https://github.com/nodejs/node/pull/9604)
* [[`30475beef6`](https://github.com/nodejs/node/commit/30475beef6)] - **src**: use ABORT() macro instead of abort() (Evan Lucas) [#9613](https://github.com/nodejs/node/pull/9613)
* [[`c4f33b48f7`](https://github.com/nodejs/node/commit/c4f33b48f7)] - **(SEMVER-MINOR)** **src**: extend `HeapStatistics` with new fields (Gareth Ellis) [#8610](https://github.com/nodejs/node/pull/8610)
* [[`4517276c74`](https://github.com/nodejs/node/commit/4517276c74)] - **src**: fix method name, output format (Josh Gavant) [#9627](https://github.com/nodejs/node/pull/9627)
* [[`7420ce8b7e`](https://github.com/nodejs/node/commit/7420ce8b7e)] - **src**: squelch unused function warnings in util.h (solebox) [#9115](https://github.com/nodejs/node/pull/9115)
* [[`a83a286631`](https://github.com/nodejs/node/commit/a83a286631)] - **test**: add test for broken child process stdio (cjihrig) [#9528](https://github.com/nodejs/node/pull/9528)
* [[`7c1a2f56fc`](https://github.com/nodejs/node/commit/7c1a2f56fc)] - **test**: add new.target add-on regression test (Ben Noordhuis) [#9689](https://github.com/nodejs/node/pull/9689)
* [[`a220170861`](https://github.com/nodejs/node/commit/a220170861)] - **test**: refactor test-async-wrap-* (Rich Trott) [#9663](https://github.com/nodejs/node/pull/9663)
* [[`6c63ab7c9a`](https://github.com/nodejs/node/commit/6c63ab7c9a)] - **test**: simplify test-http-client-unescaped-path (Rod Vagg) [#9649](https://github.com/nodejs/node/pull/9649)
* [[`731a1fa602`](https://github.com/nodejs/node/commit/731a1fa602)] - **test**: Use strictEqual in test-tls-writewrap-leak (Aaron Petcoff) [#9666](https://github.com/nodejs/node/pull/9666)
* [[`a29be5282e`](https://github.com/nodejs/node/commit/a29be5282e)] - **test**: fix memory leaks in malloc cctests (Ben Noordhuis) [#9667](https://github.com/nodejs/node/pull/9667)
* [[`776d291a07`](https://github.com/nodejs/node/commit/776d291a07)] - **test**: run tests even if os.cpus() fails (Bethany Griggs) [#9616](https://github.com/nodejs/node/pull/9616)
* [[`51e24e770a`](https://github.com/nodejs/node/commit/51e24e770a)] - **test**: use setImmediate() in test of stream2 (masashi.g) [#9583](https://github.com/nodejs/node/pull/9583)
* [[`875d1b93fc`](https://github.com/nodejs/node/commit/875d1b93fc)] - **test**: add test case of PassThrough (Yoshiya Hinosawa) [#9581](https://github.com/nodejs/node/pull/9581)
* [[`3b4ec5f6c5`](https://github.com/nodejs/node/commit/3b4ec5f6c5)] - **test**: check that `process.execPath` is a realpath (Anna Henningsen) [#9229](https://github.com/nodejs/node/pull/9229)
* [[`ccc6e75bea`](https://github.com/nodejs/node/commit/ccc6e75bea)] - **test**: ensure nextTick is not scheduled in exit (Jeremiah Senkpiel) [#9555](https://github.com/nodejs/node/pull/9555)
* [[`00a5490ecd`](https://github.com/nodejs/node/commit/00a5490ecd)] - **test**: increase coverage of process.emitWarning (Jeremiah Senkpiel) [#9556](https://github.com/nodejs/node/pull/9556)
* [[`f3db5e4720`](https://github.com/nodejs/node/commit/f3db5e4720)] - **test**: refactor test-zlib.js (Rich Trott) [#9544](https://github.com/nodejs/node/pull/9544)
* [[`58fc7a137c`](https://github.com/nodejs/node/commit/58fc7a137c)] - **test**: change from setTimeout to setImmediate (MURAKAMI Masahiko) [#9578](https://github.com/nodejs/node/pull/9578)
* [[`e7eb9ccdcf`](https://github.com/nodejs/node/commit/e7eb9ccdcf)] - **test**: improve test-stream2-objects.js (Yoshiya Hinosawa) [#9565](https://github.com/nodejs/node/pull/9565)
* [[`dae3d3e53c`](https://github.com/nodejs/node/commit/dae3d3e53c)] - **test**: refactor test-next-tick-error-spin (Rich Trott) [#9537](https://github.com/nodejs/node/pull/9537)
* [[`8c859d58ab`](https://github.com/nodejs/node/commit/8c859d58ab)] - **test**: refactor test-tls-inception (Rich Trott) [#9536](https://github.com/nodejs/node/pull/9536)
* [[`96471556b5`](https://github.com/nodejs/node/commit/96471556b5)] - **test**: move tick-processor tests to own directory (Rich Trott) [#9506](https://github.com/nodejs/node/pull/9506)
* [[`342d8e05cb`](https://github.com/nodejs/node/commit/342d8e05cb)] - **test**: refactor inspector-helper.js (Rich Trott) [#9499](https://github.com/nodejs/node/pull/9499)
* [[`dab3e451ac`](https://github.com/nodejs/node/commit/dab3e451ac)] - **test**: refactor make-callback-recurse test (Rich Trott) [#9498](https://github.com/nodejs/node/pull/9498)
* [[`2a9625656d`](https://github.com/nodejs/node/commit/2a9625656d)] - **test**: move timer-dependent test to sequential (Rich Trott) [#9487](https://github.com/nodejs/node/pull/9487)
* [[`ee7606940a`](https://github.com/nodejs/node/commit/ee7606940a)] - **test**: fix helper-debugger-repl.js (Rich Trott) [#9486](https://github.com/nodejs/node/pull/9486)
* [[`9491352b86`](https://github.com/nodejs/node/commit/9491352b86)] - **test**: remove watchdog in test-debug-signal-cluster (Rich Trott) [#9476](https://github.com/nodejs/node/pull/9476)
* [[`6a94ffb1cf`](https://github.com/nodejs/node/commit/6a94ffb1cf)] - **test**: output tap13 instead of almost-tap (Johan Bergström) [#9262](https://github.com/nodejs/node/pull/9262)
* [[`02c2bf7d34`](https://github.com/nodejs/node/commit/02c2bf7d34)] - **timers**: use consistent checks for canceled timers (Jeremiah Senkpiel) [#9685](https://github.com/nodejs/node/pull/9685)
* [[`ee65b4872d`](https://github.com/nodejs/node/commit/ee65b4872d)] - **tls**: fix leak of WriteWrap+TLSWrap combination (Fedor Indutny) [#9586](https://github.com/nodejs/node/pull/9586)
* [[`19ca6cddcf`](https://github.com/nodejs/node/commit/19ca6cddcf)] - **tools**: disallow trailing whitespace for markdown (Sam Roberts) [#9676](https://github.com/nodejs/node/pull/9676)
* [[`29bf871977`](https://github.com/nodejs/node/commit/29bf871977)] - **tools**: use better regexp for manpage references (Anna Henningsen) [#9632](https://github.com/nodejs/node/pull/9632)
* [[`cc6901d482`](https://github.com/nodejs/node/commit/cc6901d482)] - **tools**: improve docopen target in Makefile (Sakthipriyan Vairamani (thefourtheye)) [#9436](https://github.com/nodejs/node/pull/9436)
* [[`deabb5cfaa`](https://github.com/nodejs/node/commit/deabb5cfaa)] - **tools**: make run-valgrind.py useful (Ben Noordhuis) [#9520](https://github.com/nodejs/node/pull/9520)
* [[`887c76a664`](https://github.com/nodejs/node/commit/887c76a664)] - **tools**: fix run-valgrind.py script (Ben Noordhuis) [#9520](https://github.com/nodejs/node/pull/9520)
* [[`65b60801ce`](https://github.com/nodejs/node/commit/65b60801ce)] - **tools**: copy run-valgrind.py to tools/ (Ben Noordhuis) [#9520](https://github.com/nodejs/node/pull/9520)
* [[`45df0ee717`](https://github.com/nodejs/node/commit/45df0ee717)] - **v8**: update make-v8.sh to use git (Jaideep Bajwa) [#9393](https://github.com/nodejs/node/pull/9393)
* [[`adcc5b15f7`](https://github.com/nodejs/node/commit/adcc5b15f7)] - **zlib**: fix linting recently-introduced lint error (Rich Trott) [#9524](https://github.com/nodejs/node/pull/9524)
* [[`841a2c41d4`](https://github.com/nodejs/node/commit/841a2c41d4)] - **zlib**: name every function Ref: #8913 (solebox) [#9389](https://github.com/nodejs/node/pull/9389)

<a id="7.1.0"></a>
## 2016-11-08, Version 7.1.0 (Current), @evanlucas

### Notable changes

* **buffer**: add buffer.transcode to transcode a buffer's content from one encoding to another primarily using ICU (James M Snell) [#9038](https://github.com/nodejs/node/pull/9038)
* **child_process**: add public API for IPC channel (cjihrig) [#9322](https://github.com/nodejs/node/pull/9322)
* **icu**:
  * Upgraded to ICU 58 - small icu (Steven R. Loomis) [#9234](https://github.com/nodejs/node/pull/9234)
  * Add `cldr`, `tz`, and `unicode` to `process.versions` (Steven R. Loomis) [#9266](https://github.com/nodejs/node/pull/9266)
* **lib**: make `String(global) === '[object global]'` (Anna Henningsen) [#9279](https://github.com/nodejs/node/pull/9279)
* **libuv**: Upgraded to 1.10.0 (cjihrig) [#9267](https://github.com/nodejs/node/pull/9267)
* **readline**: use icu based string width calculation (James M Snell) [#9040](https://github.com/nodejs/node/pull/9040)
* **src**:
  * add NODE_PRESERVE_SYMLINKS environment variable that has the same effect as the `--preserve-symlinks` flag (Marc Udoff) [#8749](https://github.com/nodejs/node/pull/8749)
  * Fix `String#toLocaleUpperCase()` and `String#toLocaleLowerCase()` (Steven R. Loomis)

### Commits

* [[`dafdb7b069`](https://github.com/nodejs/node/commit/dafdb7b069)] - **benchmark**: add trailing newline for consistency (Roman Reiss) [#9410](https://github.com/nodejs/node/pull/9410)
* [[`fab8eb660f`](https://github.com/nodejs/node/commit/fab8eb660f)] - **benchmark**: add microbenchmarks for ES Map (Rod Vagg) [#7581](https://github.com/nodejs/node/pull/7581)
* [[`44792f83bf`](https://github.com/nodejs/node/commit/44792f83bf)] - **benchmark,lib,test,tools**: remove unneeded . escape (Rich Trott) [#9449](https://github.com/nodejs/node/pull/9449)
* [[`c70c96a3e2`](https://github.com/nodejs/node/commit/c70c96a3e2)] - **buffer**: coerce offset using Math.trunc() (cjihrig) [#9341](https://github.com/nodejs/node/pull/9341)
* [[`212da12f45`](https://github.com/nodejs/node/commit/212da12f45)] - **buffer**: use correct name for custom inspect symbol (Charmander) [#9289](https://github.com/nodejs/node/pull/9289)
* [[`0939edd4ed`](https://github.com/nodejs/node/commit/0939edd4ed)] - **(SEMVER-MINOR)** **buffer**: add buffer.transcode (James M Snell) [#9038](https://github.com/nodejs/node/pull/9038)
* [[`ceec520aef`](https://github.com/nodejs/node/commit/ceec520aef)] - **build**: add MAKEFLAGS="-j1" to node-gyp (Daniel Bevenius) [#9450](https://github.com/nodejs/node/pull/9450)
* [[`1109d0b244`](https://github.com/nodejs/node/commit/1109d0b244)] - **build**: reduce noise from doc target (Daniel Bevenius) [#9457](https://github.com/nodejs/node/pull/9457)
* [[`90aac7ca28`](https://github.com/nodejs/node/commit/90aac7ca28)] - **build**: start comments at beginning of line (Sakthipriyan Vairamani (thefourtheye)) [#9375](https://github.com/nodejs/node/pull/9375)
* [[`b51db7120e`](https://github.com/nodejs/node/commit/b51db7120e)] - **build**: make node-gyp output silent (Sakthipriyan Vairamani (thefourtheye)) [#8990](https://github.com/nodejs/node/pull/8990)
* [[`d8eaa14c2d`](https://github.com/nodejs/node/commit/d8eaa14c2d)] - **build**: prioritise --shared-X-Y over pkg-config (Rod Vagg) [#9368](https://github.com/nodejs/node/pull/9368)
* [[`f7d8481ee2`](https://github.com/nodejs/node/commit/f7d8481ee2)] - **build**: use wxneeded on openbsd (Aaron Bieber) [#9232](https://github.com/nodejs/node/pull/9232)
* [[`7b0e93738b`](https://github.com/nodejs/node/commit/7b0e93738b)] - **(SEMVER-MINOR)** **child_process**: add public API for IPC channel (cjihrig) [#9322](https://github.com/nodejs/node/pull/9322)
* [[`4e3731c7e7`](https://github.com/nodejs/node/commit/4e3731c7e7)] - **child_process**: remove unreachable code (cjihrig) [#9307](https://github.com/nodejs/node/pull/9307)
* [[`d573acf96f`](https://github.com/nodejs/node/commit/d573acf96f)] - **child_process**: remove unreachable execSync() code (cjihrig) [#9209](https://github.com/nodejs/node/pull/9209)
* [[`f1f00df9bf`](https://github.com/nodejs/node/commit/f1f00df9bf)] - **deps**: upgrade npm to 3.10.9 (Kat Marchán) [#9286](https://github.com/nodejs/node/pull/9286)
* [[`3d1766f492`](https://github.com/nodejs/node/commit/3d1766f492)] - **(SEMVER-MINOR)** **deps**: Intl: ICU 58 bump - small icu (BIG COMMIT) (Steven R. Loomis) [#9234](https://github.com/nodejs/node/pull/9234)
* [[`827000ee62`](https://github.com/nodejs/node/commit/827000ee62)] - **(SEMVER-MINOR)** **deps**: Intl: ICU 58 bump: configure/LICENSE/docs (Steven R. Loomis) [#9234](https://github.com/nodejs/node/pull/9234)
* [[`0f871e1087`](https://github.com/nodejs/node/commit/0f871e1087)] - **deps**: back port OpenBSD fix in c-ares/c-ares (Aaron Bieber) [#9232](https://github.com/nodejs/node/pull/9232)
* [[`106d71914c`](https://github.com/nodejs/node/commit/106d71914c)] - **deps**: upgrade libuv to 1.10.0 (cjihrig) [#9267](https://github.com/nodejs/node/pull/9267)
* [[`4c4132e5d3`](https://github.com/nodejs/node/commit/4c4132e5d3)] - **doc**: update minute-taking procedure for CTC (Rich Trott) [#9425](https://github.com/nodejs/node/pull/9425)
* [[`ed8df17135`](https://github.com/nodejs/node/commit/ed8df17135)] - **doc**: note that tests should include a description (Gibson Fahnestock) [#9415](https://github.com/nodejs/node/pull/9415)
* [[`bc2d1c9d91`](https://github.com/nodejs/node/commit/bc2d1c9d91)] - **doc**: do not link in the headings (Sakthipriyan Vairamani (thefourtheye)) [#9416](https://github.com/nodejs/node/pull/9416)
* [[`4bb9d21d01`](https://github.com/nodejs/node/commit/4bb9d21d01)] - **doc**: update GOVERNANCE.md to use "meeting chair" (Rich Trott) [#9432](https://github.com/nodejs/node/pull/9432)
* [[`c2fab3c600`](https://github.com/nodejs/node/commit/c2fab3c600)] - **doc**: add Sakthipriyan to the CTC (Rod Vagg) [#9427](https://github.com/nodejs/node/pull/9427)
* [[`a8295d86d9`](https://github.com/nodejs/node/commit/a8295d86d9)] - **doc**: update Diagnostics WG info (Josh Gavant) [#9329](https://github.com/nodejs/node/pull/9329)
* [[`3af9453019`](https://github.com/nodejs/node/commit/3af9453019)] - **doc**: move stray sentences in zlib doc (Rich Trott) [#9365](https://github.com/nodejs/node/pull/9365)
* [[`d4b509584f`](https://github.com/nodejs/node/commit/d4b509584f)] - **doc**: use 'an' over 'a', remove redundant sentence (Zeke Sikelianos) [#9345](https://github.com/nodejs/node/pull/9345)
* [[`ff69e38070`](https://github.com/nodejs/node/commit/ff69e38070)] - **doc**: add more internal links to fs.Stats object (Zeke Sikelianos) [#9345](https://github.com/nodejs/node/pull/9345)
* [[`c554f090df`](https://github.com/nodejs/node/commit/c554f090df)] - **doc**: fix outdate ninja link (Yangyang Liu) [#9278](https://github.com/nodejs/node/pull/9278)
* [[`3d4a829d85`](https://github.com/nodejs/node/commit/3d4a829d85)] - **doc**: fix broken links to Buffer.from(string) (Jesse McCarthy) [#9294](https://github.com/nodejs/node/pull/9294)
* [[`225a9dfb00`](https://github.com/nodejs/node/commit/225a9dfb00)] - **doc**: fs: fix link to mkdtemp (coderaiser) [#9379](https://github.com/nodejs/node/pull/9379)
* [[`dbeadd363c`](https://github.com/nodejs/node/commit/dbeadd363c)] - **doc**: update OpenSSL links (kobelb) [#9338](https://github.com/nodejs/node/pull/9338)
* [[`eeabab3827`](https://github.com/nodejs/node/commit/eeabab3827)] - **doc**: add 2016-10-26 CTC meeting minutes (Rich Trott) [#9348](https://github.com/nodejs/node/pull/9348)
* [[`31690a690c`](https://github.com/nodejs/node/commit/31690a690c)] - **doc**: add 2016-10-05 CTC meeting minutes (Josh Gavant) [#9326](https://github.com/nodejs/node/pull/9326)
* [[`7f1a40dbcf`](https://github.com/nodejs/node/commit/7f1a40dbcf)] - **doc**: add 2016-09-28 CTC meeting minutes (Josh Gavant) [#9325](https://github.com/nodejs/node/pull/9325)
* [[`edd89265ba`](https://github.com/nodejs/node/commit/edd89265ba)] - **doc**: update CONTRIBUTING.md to address editing PRs (Gibson Fahnestock) [#9259](https://github.com/nodejs/node/pull/9259)
* [[`c7458909a7`](https://github.com/nodejs/node/commit/c7458909a7)] - **doc**: reference signal(7) for the list of signals (Emanuele DelBono) [#9323](https://github.com/nodejs/node/pull/9323)
* [[`a3f6854724`](https://github.com/nodejs/node/commit/a3f6854724)] - **doc**: more realistic custom inspect example (Ryan Scheel (Havvy)) [#8875](https://github.com/nodejs/node/pull/8875)
* [[`a0074e2232`](https://github.com/nodejs/node/commit/a0074e2232)] - **doc**: clarify buffer toString docs. (Olan Byrne) [#8984](https://github.com/nodejs/node/pull/8984)
* [[`3f90481e20`](https://github.com/nodejs/node/commit/3f90481e20)] - **doc**: clarify relation between a file and a module (marzelin) [#9026](https://github.com/nodejs/node/pull/9026)
* [[`82119049ef`](https://github.com/nodejs/node/commit/82119049ef)] - **doc**: fix typo in http.md (anu0012) [#9144](https://github.com/nodejs/node/pull/9144)
* [[`d2e7882723`](https://github.com/nodejs/node/commit/d2e7882723)] - **doc**: add 2016-10-19 CTC meeting minutes (Josh Gavant) [#9193](https://github.com/nodejs/node/pull/9193)
* [[`ce00a9d2b6`](https://github.com/nodejs/node/commit/ce00a9d2b6)] - **doc**: add performance warning to require.extensions (Ben Noordhuis) [#9196](https://github.com/nodejs/node/pull/9196)
* [[`d1c32aa335`](https://github.com/nodejs/node/commit/d1c32aa335)] - **doc**: mention case-insensitive env on windows (Oliver Salzburg) [#9166](https://github.com/nodejs/node/pull/9166)
* [[`c6e429a6bc`](https://github.com/nodejs/node/commit/c6e429a6bc)] - **doc**: add CTC meeting minutes for 2016-10-12 (Michael Dawson) [#9070](https://github.com/nodejs/node/pull/9070)
* [[`355041960d`](https://github.com/nodejs/node/commit/355041960d)] - **events**: remove unnecessary checks (cjihrig) [#9330](https://github.com/nodejs/node/pull/9330)
* [[`0ce0abf6cb`](https://github.com/nodejs/node/commit/0ce0abf6cb)] - **events,test**: fix TypeError in EventEmitter warning (jseagull) [#9021](https://github.com/nodejs/node/pull/9021)
* [[`6f35e4421a`](https://github.com/nodejs/node/commit/6f35e4421a)] - **http**: add debug message for invalid header value (Evan Lucas) [#9195](https://github.com/nodejs/node/pull/9195)
* [[`173b088e1a`](https://github.com/nodejs/node/commit/173b088e1a)] - **inspector**: do not prompt to use localhost (Eugene Ostroukhov) [#9451](https://github.com/nodejs/node/pull/9451)
* [[`939d1023c2`](https://github.com/nodejs/node/commit/939d1023c2)] - **inspector**: switch to new inspector APIs (Eugene Ostroukhov) [#9028](https://github.com/nodejs/node/pull/9028)
* [[`2e7b078e7b`](https://github.com/nodejs/node/commit/2e7b078e7b)] - **inspector**: fix request path nullptr dereference (Ben Noordhuis) [#9184](https://github.com/nodejs/node/pull/9184)
* [[`9940666c1b`](https://github.com/nodejs/node/commit/9940666c1b)] - **(SEMVER-MINOR)** **intl**: Add more versions from ICU (Steven R. Loomis) [#9266](https://github.com/nodejs/node/pull/9266)
* [[`5bfefa6063`](https://github.com/nodejs/node/commit/5bfefa6063)] - **lib**: change == to === in linkedlist (jedireza) [#9362](https://github.com/nodejs/node/pull/9362)
* [[`d24bd20d2b`](https://github.com/nodejs/node/commit/d24bd20d2b)] - **lib**: make `String(global) === '[object global]'` (Anna Henningsen) [#9279](https://github.com/nodejs/node/pull/9279)
* [[`9372aee4a3`](https://github.com/nodejs/node/commit/9372aee4a3)] - **lib**: fix beforeExit not working with -e (Ben Noordhuis) [#8821](https://github.com/nodejs/node/pull/8821)
* [[`c231130e06`](https://github.com/nodejs/node/commit/c231130e06)] - **module**: skip directories known not to exist (Ben Noordhuis) [#9196](https://github.com/nodejs/node/pull/9196)
* [[`d09eb9c6b2`](https://github.com/nodejs/node/commit/d09eb9c6b2)] - **net**: name anonymous functions (Pedro Victor) [#9357](https://github.com/nodejs/node/pull/9357)
* [[`a5c62cb4f2`](https://github.com/nodejs/node/commit/a5c62cb4f2)] - **(SEMVER-MINOR)** **readline**: use icu based string width calculation (James M Snell) [#9040](https://github.com/nodejs/node/pull/9040)
* [[`60461d2d90`](https://github.com/nodejs/node/commit/60461d2d90)] - **repl**: refactor lib/repl.js (Rich Trott) [#9374](https://github.com/nodejs/node/pull/9374)
* [[`071836aa42`](https://github.com/nodejs/node/commit/071836aa42)] - **repl**: name anonymous functions (Pedro Victor) [#9356](https://github.com/nodejs/node/pull/9356)
* [[`0b9d80a037`](https://github.com/nodejs/node/commit/0b9d80a037)] - **repl**: don’t write to input stream in editor mode (Anna Henningsen) [#9207](https://github.com/nodejs/node/pull/9207)
* [[`1c59cefc44`](https://github.com/nodejs/node/commit/1c59cefc44)] - **repl**: make `key` of `repl.write()` optional always (Anna Henningsen) [#9207](https://github.com/nodejs/node/pull/9207)
* [[`b1ef638de3`](https://github.com/nodejs/node/commit/b1ef638de3)] - **(SEMVER-MINOR)** **src**: default --icu_case_mapping on as a v8 option (Steven R. Loomis) [#9454](https://github.com/nodejs/node/pull/9454)
* [[`0c236d1d36`](https://github.com/nodejs/node/commit/0c236d1d36)] - **src**: replace SetNamedPropertyHandler() (AnnaMag) [#9062](https://github.com/nodejs/node/pull/9062)
* [[`5ab172ee8f`](https://github.com/nodejs/node/commit/5ab172ee8f)] - **src**: fix use of uninitialized variable (James M Snell) [#9281](https://github.com/nodejs/node/pull/9281)
* [[`57c0a9b5dc`](https://github.com/nodejs/node/commit/57c0a9b5dc)] - **src**: remove unused function (Brian White) [#9243](https://github.com/nodejs/node/pull/9243)
* [[`08e12c7809`](https://github.com/nodejs/node/commit/08e12c7809)] - **src**: remove superfluous env_string string (Ben Noordhuis) [#9213](https://github.com/nodejs/node/pull/9213)
* [[`c342bda49e`](https://github.com/nodejs/node/commit/c342bda49e)] - **src**: make cross-context MakeCallback() calls work (Ben Noordhuis) [#9221](https://github.com/nodejs/node/pull/9221)
* [[`60a5b515b8`](https://github.com/nodejs/node/commit/60a5b515b8)] - **(SEMVER-MINOR)** **src**: add NODE_PRESERVE_SYMLINKS environment variable (Marc Udoff) [#8749](https://github.com/nodejs/node/pull/8749)
* [[`f2a3b24611`](https://github.com/nodejs/node/commit/f2a3b24611)] - **src**: clean up program/isolate/env init logic (Ben Noordhuis) [#9224](https://github.com/nodejs/node/pull/9224)
* [[`9e753ba782`](https://github.com/nodejs/node/commit/9e753ba782)] - **src**: simplify code, remove NodeInstanceData (Ben Noordhuis) [#9224](https://github.com/nodejs/node/pull/9224)
* [[`8b53f3c41c`](https://github.com/nodejs/node/commit/8b53f3c41c)] - **src**: speed up module loading, don't resize buffer (Ben Noordhuis) [#9132](https://github.com/nodejs/node/pull/9132)
* [[`362c307f38`](https://github.com/nodejs/node/commit/362c307f38)] - **src**: speed up module loading, skip EOF read (Ben Noordhuis) [#9132](https://github.com/nodejs/node/pull/9132)
* [[`85a9295813`](https://github.com/nodejs/node/commit/85a9295813)] - **src,tools**: speed up startup by 2.5% (Ben Noordhuis) [#5458](https://github.com/nodejs/node/pull/5458)
* [[`6e1eb59fee`](https://github.com/nodejs/node/commit/6e1eb59fee)] - **test**: improve test-debugger-util-regression (Santiago Gimeno) [#9490](https://github.com/nodejs/node/pull/9490)
* [[`6eb6816e22`](https://github.com/nodejs/node/commit/6eb6816e22)] - **test**: fix flaky test-net-GH-5504 (Santiago Gimeno) [#9461](https://github.com/nodejs/node/pull/9461)
* [[`f640bafc58`](https://github.com/nodejs/node/commit/f640bafc58)] - **test**: fix flaky test-force-repl-with-eval (Santiago Gimeno) [#9460](https://github.com/nodejs/node/pull/9460)
* [[`675a4b20b6`](https://github.com/nodejs/node/commit/675a4b20b6)] - **test**: update http-header-obstext (Gibson Fahnestock) [#9415](https://github.com/nodejs/node/pull/9415)
* [[`9d9ea8127e`](https://github.com/nodejs/node/commit/9d9ea8127e)] - **test**: move timer-dependent test to sequential (Rich Trott) [#9431](https://github.com/nodejs/node/pull/9431)
* [[`1c3487b5c3`](https://github.com/nodejs/node/commit/1c3487b5c3)] - **test**: remove timers from streams test (Anna Henningsen)
* [[`e696bc33eb`](https://github.com/nodejs/node/commit/e696bc33eb)] - **test**: increase test coverage for lib/zlib.js (Rich Trott) [#9366](https://github.com/nodejs/node/pull/9366)
* [[`ed3f80a988`](https://github.com/nodejs/node/commit/ed3f80a988)] - **test**: add test for HTTP client "aborted" event (Kyle E. Mitchell) [#7376](https://github.com/nodejs/node/pull/7376)
* [[`d12ed29f6a`](https://github.com/nodejs/node/commit/d12ed29f6a)] - **test**: remove timer in test-dgram-send-empty-array (Rich Trott) [#9361](https://github.com/nodejs/node/pull/9361)
* [[`e451022dd9`](https://github.com/nodejs/node/commit/e451022dd9)] - **test**: refactor test-http-client-readable (Rich Trott) [#9344](https://github.com/nodejs/node/pull/9344)
* [[`01b626a45a`](https://github.com/nodejs/node/commit/01b626a45a)] - **test**: clean up dgram-broadcast-multi-process test (Isobel Redelmeier) [#9308](https://github.com/nodejs/node/pull/9308)
* [[`411b1339bc`](https://github.com/nodejs/node/commit/411b1339bc)] - **test**: fix freebsd10-64 CI failures (Rich Trott) [#9317](https://github.com/nodejs/node/pull/9317)
* [[`1037463604`](https://github.com/nodejs/node/commit/1037463604)] - **test**: add child_process customFds test (cjihrig) [#9307](https://github.com/nodejs/node/pull/9307)
* [[`bd9cb40977`](https://github.com/nodejs/node/commit/bd9cb40977)] - **test**: run all of test-timers-blocking-callback (Rich Trott) [#9305](https://github.com/nodejs/node/pull/9305)
* [[`8b7ce8bd11`](https://github.com/nodejs/node/commit/8b7ce8bd11)] - **test**: fix flaky test-fs-watch-recursive on OS X (Rich Trott) [#9303](https://github.com/nodejs/node/pull/9303)
* [[`6c9e4fddf0`](https://github.com/nodejs/node/commit/6c9e4fddf0)] - **test**: refactor test-async-wrap-check-providers (Gerges Beshay) [#9297](https://github.com/nodejs/node/pull/9297)
* [[`0ab008e50d`](https://github.com/nodejs/node/commit/0ab008e50d)] - **test**: fix lint error regarding unused commons const (Daniel Bevenius) [#9334](https://github.com/nodejs/node/pull/9334)
* [[`c9b67c6a91`](https://github.com/nodejs/node/commit/c9b67c6a91)] - **test**: writable stream needDrain state (Italo A. Casas) [#8799](https://github.com/nodejs/node/pull/8799)
* [[`248a3200b2`](https://github.com/nodejs/node/commit/248a3200b2)] - **test**: writable stream ending state (Italo A. Casas) [#8707](https://github.com/nodejs/node/pull/8707)
* [[`d6f688ae0d`](https://github.com/nodejs/node/commit/d6f688ae0d)] - **test**: writable stream finished state (Italo A. Casas) [#8791](https://github.com/nodejs/node/pull/8791)
* [[`d49d990c42`](https://github.com/nodejs/node/commit/d49d990c42)] - **test**: prevent workers outliving parent (Sam Roberts) [#9257](https://github.com/nodejs/node/pull/9257)
* [[`2ad81ed0e6`](https://github.com/nodejs/node/commit/2ad81ed0e6)] - **test**: refactor /parallel/test-cluster-uncaught-exception.js to ES6 (Deverick) [#9239](https://github.com/nodejs/node/pull/9239)
* [[`f39eb05946`](https://github.com/nodejs/node/commit/f39eb05946)] - **test**: use strict assertions in module loader test (Ben Noordhuis) [#9263](https://github.com/nodejs/node/pull/9263)
* [[`fc9e6a37fa`](https://github.com/nodejs/node/commit/fc9e6a37fa)] - **test**: remove err timer from test-http-set-timeout (BethGriggs) [#9264](https://github.com/nodejs/node/pull/9264)
* [[`53520f06f3`](https://github.com/nodejs/node/commit/53520f06f3)] - **test**: clean up `test-child-process-exec-cwd.js` (Jeena Lee) [#9231](https://github.com/nodejs/node/pull/9231)
* [[`deef2f6079`](https://github.com/nodejs/node/commit/deef2f6079)] - **test**: add child_process.exec() timeout coverage (cjihrig) [#9208](https://github.com/nodejs/node/pull/9208)
* [[`5e138fe768`](https://github.com/nodejs/node/commit/5e138fe768)] - **test**: skip whatwg url parse and setter tests when icu is missing (James M Snell) [#9246](https://github.com/nodejs/node/pull/9246)
* [[`a39b98ef73`](https://github.com/nodejs/node/commit/a39b98ef73)] - **test**: add common.hasIntl (James M Snell) [#9246](https://github.com/nodejs/node/pull/9246)
* [[`efb62aa146`](https://github.com/nodejs/node/commit/efb62aa146)] - **test**: fix flaky test by removing timer (Evan Lucas) [#9199](https://github.com/nodejs/node/pull/9199)
* [[`44427cc1f7`](https://github.com/nodejs/node/commit/44427cc1f7)] - **test**: case sensitivity of env variables (Oliver Salzburg) [#9166](https://github.com/nodejs/node/pull/9166)
* [[`63ef0990f3`](https://github.com/nodejs/node/commit/63ef0990f3)] - **test**: add coverage for execFileSync() errors (cjihrig) [#9211](https://github.com/nodejs/node/pull/9211)
* [[`06b414078e`](https://github.com/nodejs/node/commit/06b414078e)] - **test**: remove test-v8-inspector-json-protocol test (Ben Noordhuis) [#9184](https://github.com/nodejs/node/pull/9184)
* [[`21ba3e3b89`](https://github.com/nodejs/node/commit/21ba3e3b89)] - **test**: add more module loader test coverage (Ben Noordhuis) [#9196](https://github.com/nodejs/node/pull/9196)
* [[`204461925b`](https://github.com/nodejs/node/commit/204461925b)] - **test**: make flaky pummel test more reliable (Ben Noordhuis) [#9241](https://github.com/nodejs/node/pull/9241)
* [[`4be1ba582a`](https://github.com/nodejs/node/commit/4be1ba582a)] - **test**: move flaky test to test/pummel (Ben Noordhuis) [#9241](https://github.com/nodejs/node/pull/9241)
* [[`032533954b`](https://github.com/nodejs/node/commit/032533954b)] - **tools**: use long format for gpg fingerprint (Myles Borins) [#9258](https://github.com/nodejs/node/pull/9258)
* [[`aac4af2b26`](https://github.com/nodejs/node/commit/aac4af2b26)] - **tools**: enable final newline in .editorconfig (Roman Reiss) [#9410](https://github.com/nodejs/node/pull/9410)
* [[`513da404cb`](https://github.com/nodejs/node/commit/513da404cb)] - **tools**: enforce function name matching in linter (Rich Trott) [#9408](https://github.com/nodejs/node/pull/9408)
* [[`c23ece7056`](https://github.com/nodejs/node/commit/c23ece7056)] - **tools**: remove dangling eslint symlink (Sam Roberts) [#9299](https://github.com/nodejs/node/pull/9299)
* [[`bdad1e28fd`](https://github.com/nodejs/node/commit/bdad1e28fd)] - **tools**: make --repeat work with -j in test.py (Rich Trott) [#9249](https://github.com/nodejs/node/pull/9249)
* [[`4f0596fb03`](https://github.com/nodejs/node/commit/4f0596fb03)] - **util**: use template strings (Alejandro Oviedo Garcia) [#9120](https://github.com/nodejs/node/pull/9120)
* [[`b083086ff2`](https://github.com/nodejs/node/commit/b083086ff2)] - **vm**: name anonymous functions (solebox) [#9388](https://github.com/nodejs/node/pull/9388)

<a id="7.0.0"></a>
## 2016-10-25, Version 7.0.0 (Current), @jasnell

### Notable changes

* Buffer
  * Passing invalid input to Buffer.byteLength will now throw an error [#8946](https://github.com/nodejs/node/pull/8946).
  * Calling Buffer without new is now deprecated and will emit a process warning [#8169](https://github.com/nodejs/node/pull/8169).
  * Passing a negative number to allocUnsafe will now throw an error [#7079](https://github.com/nodejs/node/pull/7079).
* Child Process
  * The fork and execFile methods now have stronger argument validation [#7399](https://github.com/nodejs/node/pull/7399).
* Cluster
  * The worker.suicide method is deprecated and will emit a process warning [#3747](https://github.com/nodejs/node/pull/3747).
* Deps
  * V8 has been updated to 5.4.500.36 [#8317](https://github.com/nodejs/node/pull/8317), [#8852](https://github.com/nodejs/node/pull/8852),
  [#9253](https://github.com/nodejs/node/pull/9253).
  * NODE_MODULE_VERSION has been updated to 51 [#8808](https://github.com/nodejs/node/pull/8808).
* File System
  * A process warning is emitted if a callback is not passed to async file system methods [#7897](https://github.com/nodejs/node/pull/7897).
* Intl
  * Intl.v8BreakIterator constructor has been deprecated and will emit a process warning [#8908](https://github.com/nodejs/node/pull/8908).
* Promises
  * Unhandled Promise rejections have been deprecated and will emit a process warning [#8217](https://github.com/nodejs/node/pull/8217).
* Punycode
  * The `punycode` module has been deprecated [#7941](https://github.com/nodejs/node/pull/7941).
* URL
  * An Experimental WHATWG URL Parser has been introduced [#7448](https://github.com/nodejs/node/pull/7448).

### Commits

* [[`1043f5d08e`](https://github.com/nodejs/node/commit/1043f5d08e)] - **assert**: name anonymous functions (Miguel Angel Asencio Hurtado) [#9051](https://github.com/nodejs/node/pull/9051)
* [[`06f37471aa`](https://github.com/nodejs/node/commit/06f37471aa)] - **benchmark**: use node v4 syntax in common.js (Andreas Madsen) [#9064](https://github.com/nodejs/node/pull/9064)
* [[`8b152fcf47`](https://github.com/nodejs/node/commit/8b152fcf47)] - **benchmark**: change the execution order (Andreas Madsen) [#9064](https://github.com/nodejs/node/pull/9064)
* [[`a5046bf8ef`](https://github.com/nodejs/node/commit/a5046bf8ef)] - **benchmark**: fixes csv parsing given no parameters (Andreas Madsen) [#9064](https://github.com/nodejs/node/pull/9064)
* [[`af01865d66`](https://github.com/nodejs/node/commit/af01865d66)] - **benchmark**: add info about required Unix tools (Bartosz Sosnowski) [#8788](https://github.com/nodejs/node/pull/8788)
* [[`dfb5f301cf`](https://github.com/nodejs/node/commit/dfb5f301cf)] - **benchmark**: make v8-bench.js output consistent (Bartosz Sosnowski) [#8564](https://github.com/nodejs/node/pull/8564)
* [[`84481f9157`](https://github.com/nodejs/node/commit/84481f9157)] - **benchmark**: add --expose_internals switch (Bartosz Sosnowski) [#8547](https://github.com/nodejs/node/pull/8547)
* [[`d3834a1fa3`](https://github.com/nodejs/node/commit/d3834a1fa3)] - **benchmark**: ignore significance when using --runs 1 (Andreas Madsen) [#8299](https://github.com/nodejs/node/pull/8299)
* [[`b1bbc68fb1`](https://github.com/nodejs/node/commit/b1bbc68fb1)] - **benchmark**: support for multiple http benchmarkers (Bartosz Sosnowski) [#8140](https://github.com/nodejs/node/pull/8140)
* [[`474e629ddb`](https://github.com/nodejs/node/commit/474e629ddb)] - **benchmark**: add --format csv option (Adrian Nitu) [#7961](https://github.com/nodejs/node/pull/7961)
* [[`4b527a4129`](https://github.com/nodejs/node/commit/4b527a4129)] - **benchmark**: update compare.js exit method (Adrian Nitu) [#7961](https://github.com/nodejs/node/pull/7961)
* [[`9e7fd8e810`](https://github.com/nodejs/node/commit/9e7fd8e810)] - **benchmark**: fix comment typos and code format (Adrian Nitu) [#7961](https://github.com/nodejs/node/pull/7961)
* [[`d525e6c92a`](https://github.com/nodejs/node/commit/d525e6c92a)] - **(SEMVER-MAJOR)** **benchmark**: remove broken string-creation.js (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`6edef1deb9`](https://github.com/nodejs/node/commit/6edef1deb9)] - **(SEMVER-MAJOR)** **benchmark**: update docs after refactor (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`0c0f34e2fe`](https://github.com/nodejs/node/commit/0c0f34e2fe)] - **(SEMVER-MAJOR)** **benchmark**: add script for creating scatter plot (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`855009af7f`](https://github.com/nodejs/node/commit/855009af7f)] - **(SEMVER-MAJOR)** **benchmark**: use t-test for comparing node versions (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`8bb59fdb12`](https://github.com/nodejs/node/commit/8bb59fdb12)] - **(SEMVER-MAJOR)** **benchmark**: missing process.exit after bench.end (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`f99471b2ae`](https://github.com/nodejs/node/commit/f99471b2ae)] - **(SEMVER-MAJOR)** **benchmark**: refactor to use process.send (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`0f9bfaa7c5`](https://github.com/nodejs/node/commit/0f9bfaa7c5)] - **(SEMVER-MAJOR)** **benchmark**: move cli parts of common.js into run.js (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`edbed3f3fd`](https://github.com/nodejs/node/commit/edbed3f3fd)] - **(SEMVER-MAJOR)** **benchmark**: move http_simple.js to http directory (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`ee2843b4ea`](https://github.com/nodejs/node/commit/ee2843b4ea)] - **(SEMVER-MAJOR)** **benchmark**: remove unused files (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`60042ca70e`](https://github.com/nodejs/node/commit/60042ca70e)] - **buffer**: fix range checks for slice() (Trevor Norris) [#9174](https://github.com/nodejs/node/pull/9174)
* [[`14d1a8a631`](https://github.com/nodejs/node/commit/14d1a8a631)] - **buffer**: coerce slice parameters consistently (Sakthipriyan Vairamani (thefourtheye)) [#9101](https://github.com/nodejs/node/pull/9101)
* [[`96b501d338`](https://github.com/nodejs/node/commit/96b501d338)] - **(SEMVER-MAJOR)** **buffer**: make byteLength throw on invalid input (Brian White) [#8946](https://github.com/nodejs/node/pull/8946)
* [[`c21458a15d`](https://github.com/nodejs/node/commit/c21458a15d)] - **(SEMVER-MINOR)** **buffer**: expose underlying buffer object always (Sakthipriyan Vairamani) [#8311](https://github.com/nodejs/node/pull/8311)
* [[`2c9a86f01e`](https://github.com/nodejs/node/commit/2c9a86f01e)] - **buffer**: directly use ArrayBuffer as the pool (Anna Henningsen) [#8302](https://github.com/nodejs/node/pull/8302)
* [[`f2fe5583c4`](https://github.com/nodejs/node/commit/f2fe5583c4)] - **(SEMVER-MAJOR)** **buffer**: runtime deprecation of calling Buffer without new (Nikolai Vavilov) [#8169](https://github.com/nodejs/node/pull/8169)
* [[`9cee8b1b62`](https://github.com/nodejs/node/commit/9cee8b1b62)] - **(SEMVER-MAJOR)** **buffer**: alias toLocaleString to toString (James M Snell) [#8148](https://github.com/nodejs/node/pull/8148)
* [[`8f90dcc1b8`](https://github.com/nodejs/node/commit/8f90dcc1b8)] - **(SEMVER-MAJOR)** **buffer**: throw on negative .allocUnsafe() argument (Anna Henningsen) [#7079](https://github.com/nodejs/node/pull/7079)
* [[`bd23290657`](https://github.com/nodejs/node/commit/bd23290657)] - **buffer**: remove obsolete and confusing comment (Nikolai Vavilov) [#7264](https://github.com/nodejs/node/pull/7264)
* [[`5292a1358f`](https://github.com/nodejs/node/commit/5292a1358f)] - **buffer**: improve creation performance. (Ingvar Stepanyan) [#6893](https://github.com/nodejs/node/pull/6893)
* [[`c5f5bcb331`](https://github.com/nodejs/node/commit/c5f5bcb331)] - **build**: fix config.gypi target (Daniel Bevenius) [#9053](https://github.com/nodejs/node/pull/9053)
* [[`b311906abf`](https://github.com/nodejs/node/commit/b311906abf)] - **(SEMVER-MAJOR)** **build**: do not clean V8 gtest directory (Michaël Zasso) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`94f68b5b97`](https://github.com/nodejs/node/commit/94f68b5b97)] - **(SEMVER-MAJOR)** **build**: fix mkpeephole configuration (Ali Ijaz Sheikh) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`8481ea1ca4`](https://github.com/nodejs/node/commit/8481ea1ca4)] - **(SEMVER-MAJOR)** **build**: use libc++ on OSX (Ali Ijaz Sheikh) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`197d18795e`](https://github.com/nodejs/node/commit/197d18795e)] - **(SEMVER-MAJOR)** **build**: define icu_use_data_file_flag (Ali Ijaz Sheikh) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`eab418f7f9`](https://github.com/nodejs/node/commit/eab418f7f9)] - **(SEMVER-MAJOR)** **build**: update V8 gypfile paths (Michaël Zasso) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`88e862ba82`](https://github.com/nodejs/node/commit/88e862ba82)] - **build**: windows sharedlib support (Stefan Budeanu) [#7487](https://github.com/nodejs/node/pull/7487)
* [[`6eece7773e`](https://github.com/nodejs/node/commit/6eece7773e)] - **child_process**: update outdated comment (Tanuja-Sawant)
* [[`0548e5d12a`](https://github.com/nodejs/node/commit/0548e5d12a)] - **(SEMVER-MAJOR)** **child_process**: add fork/execFile arg validation (Rich Trott) [#7399](https://github.com/nodejs/node/pull/7399)
* [[`b90f3da9de`](https://github.com/nodejs/node/commit/b90f3da9de)] - **(SEMVER-MAJOR)** **child_process, win**: fix shell spawn with AutoRun (Bartosz Sosnowski) [#8063](https://github.com/nodejs/node/pull/8063)
* [[`f44b18f010`](https://github.com/nodejs/node/commit/f44b18f010)] - **(SEMVER-MAJOR)** **cluster**: deprecate worker.suicide (Evan Lucas) [#3747](https://github.com/nodejs/node/pull/3747)
* [[`bd7d7a7e17`](https://github.com/nodejs/node/commit/bd7d7a7e17)] - **console**: name anonymous functions (Tyler Brazier) [#9047](https://github.com/nodejs/node/pull/9047)
* [[`c60d43b6d9`](https://github.com/nodejs/node/commit/c60d43b6d9)] - **crypto**: fix faulty logic in iv size check (Ben Noordhuis) [#9032](https://github.com/nodejs/node/pull/9032)
* [[`72f1c41fb6`](https://github.com/nodejs/node/commit/72f1c41fb6)] - **crypto**: naming anonymous functions (solebox) [#8993](https://github.com/nodejs/node/pull/8993)
* [[`89643b645e`](https://github.com/nodejs/node/commit/89643b645e)] - **crypto**: use SSL_get_SSL_CTX. (Adam Langley) [#8995](https://github.com/nodejs/node/pull/8995)
* [[`f4aa2c2c93`](https://github.com/nodejs/node/commit/f4aa2c2c93)] - **(SEMVER-MAJOR)** **crypto**: remove POINT_CONVERSION_HYBRID from documentation. (Adam Langley) [#4956](https://github.com/nodejs/node/pull/4956)
* [[`6bbdd668bd`](https://github.com/nodejs/node/commit/6bbdd668bd)] - **deps**: update V8 to 5.4.500.36 (Michaël Zasso) [#9253](https://github.com/nodejs/node/pull/9253)
* [[`5e3a480ad5`](https://github.com/nodejs/node/commit/5e3a480ad5)] - **deps**: revert default gtest reporter change (Brian White) [#8948](https://github.com/nodejs/node/pull/8948)
* [[`c0a3ac2e94`](https://github.com/nodejs/node/commit/c0a3ac2e94)] - **deps**: cherry-pick missing v8 floating patch (Michael Dawson) [#8907](https://github.com/nodejs/node/pull/8907)
* [[`bef4b3bfda`](https://github.com/nodejs/node/commit/bef4b3bfda)] - **deps**: update V8 to 5.4.500.31 (Michaël Zasso) [#8852](https://github.com/nodejs/node/pull/8852)
* [[`a88bb3a758`](https://github.com/nodejs/node/commit/a88bb3a758)] - **(SEMVER-MAJOR)** **deps**: cherry-pick workaround for clang-3.4 ICE (Michaël Zasso) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`90efff6000`](https://github.com/nodejs/node/commit/90efff6000)] - **(SEMVER-MAJOR)** **deps**: update V8 to 5.4.500.27 (Michaël Zasso) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`245ac302f5`](https://github.com/nodejs/node/commit/245ac302f5)] - **(SEMVER-MINOR)** **deps**: update V8 to 5.1.281.75 (Ben Noordhuis) [#7615](https://github.com/nodejs/node/pull/7615)
* [[`dc17432208`](https://github.com/nodejs/node/commit/dc17432208)] - **deps**: fix V8 5.1 tests (Michaël Zasso) [#7488](https://github.com/nodejs/node/pull/7488)
* [[`2cc2951796`](https://github.com/nodejs/node/commit/2cc2951796)] - **(SEMVER-MINOR)** **deps**: update V8 to 5.1.281.69 (Michaël Zasso) [#7016](https://github.com/nodejs/node/pull/7016)
* [[`e9b6fbbf17`](https://github.com/nodejs/node/commit/e9b6fbbf17)] - **(SEMVER-MAJOR)** **dgram**: prefer strict equality, type validation (Claudio Rodriguez) [#8011](https://github.com/nodejs/node/pull/8011)
* [[`260f41f2cc`](https://github.com/nodejs/node/commit/260f41f2cc)] - **dns**: name anonymous functions (Miguel Angel Asencio Hurtado) [#9052](https://github.com/nodejs/node/pull/9052)
* [[`3238f15234`](https://github.com/nodejs/node/commit/3238f15234)] - **doc**: change os x tag to macos (Gibson Fahnestock) [#9009](https://github.com/nodejs/node/pull/9009)
* [[`1794456ebc`](https://github.com/nodejs/node/commit/1794456ebc)] - **doc**: change solaris tag to smartos (Gibson Fahnestock) [#9009](https://github.com/nodejs/node/pull/9009)
* [[`98ca07bfe0`](https://github.com/nodejs/node/commit/98ca07bfe0)] - **doc**: add teams for platform-specific issues (Gibson Fahnestock) [#9009](https://github.com/nodejs/node/pull/9009)
* [[`e4e60b45e1`](https://github.com/nodejs/node/commit/e4e60b45e1)] - **doc**: add s390 and ppc architecture labels (Gibson Fahnestock) [#9009](https://github.com/nodejs/node/pull/9009)
* [[`3b580145c4`](https://github.com/nodejs/node/commit/3b580145c4)] - **doc**: fixes formatting in process (Rod Machen) [#9235](https://github.com/nodejs/node/pull/9235)
* [[`3e2bafe053`](https://github.com/nodejs/node/commit/3e2bafe053)] - **doc**: improve header styling for API docs (Jeremiah Senkpiel) [#8811](https://github.com/nodejs/node/pull/8811)
* [[`0a307f90cd`](https://github.com/nodejs/node/commit/0a307f90cd)] - **doc**: clarify fs.link and fs.linkSync arguments (Kyle E. Mitchell) [#9145](https://github.com/nodejs/node/pull/9145)
* [[`38cf1d4739`](https://github.com/nodejs/node/commit/38cf1d4739)] - **doc**: remove confusing reference in governance doc (Rich Trott) [#9073](https://github.com/nodejs/node/pull/9073)
* [[`5bf215d6b9`](https://github.com/nodejs/node/commit/5bf215d6b9)] - **doc**: suggest nodejs/help for general support (Myles Borins) [#9128](https://github.com/nodejs/node/pull/9128)
* [[`5e26980937`](https://github.com/nodejs/node/commit/5e26980937)] - **doc**: fix header level for crypto.constants (Evan Lucas) [#9187](https://github.com/nodejs/node/pull/9187)
* [[`89b920fead`](https://github.com/nodejs/node/commit/89b920fead)] - **doc**: add ctc-review label information (Rich Trott) [#9072](https://github.com/nodejs/node/pull/9072)
* [[`e6d1d54230`](https://github.com/nodejs/node/commit/e6d1d54230)] - **doc**: fix typo in zlib.md (Parambir Singh) [#9123](https://github.com/nodejs/node/pull/9123)
* [[`3b63b64992`](https://github.com/nodejs/node/commit/3b63b64992)] - **doc**: further improve child_process doc types (Indrek Ardel) [#9095](https://github.com/nodejs/node/pull/9095)
* [[`f56bdecde1`](https://github.com/nodejs/node/commit/f56bdecde1)] - **doc**: edit Stream api grammar (Benji Marinacci) [#9100](https://github.com/nodejs/node/pull/9100)
* [[`95d45d750a`](https://github.com/nodejs/node/commit/95d45d750a)] - **doc**: improved example for http.get (marzelin) [#9065](https://github.com/nodejs/node/pull/9065)
* [[`0022bfe42e`](https://github.com/nodejs/node/commit/0022bfe42e)] - **doc**: update reference to list hash algorithms in crypto.md (scott stern) [#9043](https://github.com/nodejs/node/pull/9043)
* [[`b0da43104f`](https://github.com/nodejs/node/commit/b0da43104f)] - **doc**: specify that errno is a number, not a string (John Vilk) [#9007](https://github.com/nodejs/node/pull/9007)
* [[`c258dc89d9`](https://github.com/nodejs/node/commit/c258dc89d9)] - **doc**: highlight deprecated API in ToC (Ilya Frolov) [#7189](https://github.com/nodejs/node/pull/7189)
* [[`d529a46416`](https://github.com/nodejs/node/commit/d529a46416)] - **doc**: explains why Reviewed-By is added in PRs (jessicaquynh) [#9044](https://github.com/nodejs/node/pull/9044)
* [[`482995e7cc`](https://github.com/nodejs/node/commit/482995e7cc)] - **doc**: explain why GitHub merge button is not used (jessicaquynh) [#9044](https://github.com/nodejs/node/pull/9044)
* [[`3735f22480`](https://github.com/nodejs/node/commit/3735f22480)] - **doc**: fix typo (Nikolai Vavilov) [#9089](https://github.com/nodejs/node/pull/9089)
* [[`839f1f02ed`](https://github.com/nodejs/node/commit/839f1f02ed)] - **doc**: fix broken links in changelogs (Evan Lucas) [#8122](https://github.com/nodejs/node/pull/8122)
* [[`8f6589a0ba`](https://github.com/nodejs/node/commit/8f6589a0ba)] - **doc**: revise http documentation (Timothy Gu) [#8486](https://github.com/nodejs/node/pull/8486)
* [[`f3f5a89a10`](https://github.com/nodejs/node/commit/f3f5a89a10)] - **doc**: *.md formatting fixes in the benchmark dir (Сковорода Никита Андреевич) [#7727](https://github.com/nodejs/node/pull/7727)
* [[`9744928cf5`](https://github.com/nodejs/node/commit/9744928cf5)] - **doc**: fix layout problem in v4 changelog (Myles Borins) [#7394](https://github.com/nodejs/node/pull/7394)
* [[`d976d66cfc`](https://github.com/nodejs/node/commit/d976d66cfc)] - **doc**: clarify fs.access works on directories too. (Lance Ball) [#7113](https://github.com/nodejs/node/pull/7113)
* [[`8c1d5e58d4`](https://github.com/nodejs/node/commit/8c1d5e58d4)] - **doc**: improve rendering of v4.4.5 changelog entry (Myles Borins) [#6958](https://github.com/nodejs/node/pull/6958)
* [[`2bceda6493`](https://github.com/nodejs/node/commit/2bceda6493)] - **doc**: get rid of sneaky hard tabs in CHANGELOG (Myles Borins) [#6608](https://github.com/nodejs/node/pull/6608)
* [[`29e49fc286`](https://github.com/nodejs/node/commit/29e49fc286)] - **(SEMVER-MAJOR)** **doc, punycode**: soft-deprecation of the punycode module (James M Snell) [#7941](https://github.com/nodejs/node/pull/7941)
* [[`3b8ec68a3a`](https://github.com/nodejs/node/commit/3b8ec68a3a)] - **(SEMVER-MAJOR)** **domain**: add message for dispose deprecation (Brian White) [#7053](https://github.com/nodejs/node/pull/7053)
* [[`983775d457`](https://github.com/nodejs/node/commit/983775d457)] - **(SEMVER-MAJOR)** **events**: make memory leak warning name more verbose (Anna Henningsen) [#8341](https://github.com/nodejs/node/pull/8341)
* [[`b7a8a691b4`](https://github.com/nodejs/node/commit/b7a8a691b4)] - **(SEMVER-MAJOR)** **events**: unwrap #once listeners in #listeners (Owen Smith) [#6881](https://github.com/nodejs/node/pull/6881)
* [[`108c1fbbe2`](https://github.com/nodejs/node/commit/108c1fbbe2)] - **fs**: clarify fs.link and fs.linkSync arguments (Kyle E. Mitchell) [#9145](https://github.com/nodejs/node/pull/9145)
* [[`7f7d1d385d`](https://github.com/nodejs/node/commit/7f7d1d385d)] - **(SEMVER-MAJOR)** **fs**: move stringToFlags() to lib/internal (Ben Noordhuis) [#7162](https://github.com/nodejs/node/pull/7162)
* [[`fe9f5bcd75`](https://github.com/nodejs/node/commit/fe9f5bcd75)] - **fs**: don't alter user provided `options` object (Sakthipriyan Vairamani (thefourtheye)) [#7831](https://github.com/nodejs/node/pull/7831)
* [[`169f485289`](https://github.com/nodejs/node/commit/169f485289)] - **(SEMVER-MAJOR)** **fs**: refactor "options" processing as a function (Sakthipriyan Vairamani) [#7165](https://github.com/nodejs/node/pull/7165)
* [[`21124ba23a`](https://github.com/nodejs/node/commit/21124ba23a)] - **(SEMVER-MAJOR)** **fs**: do not emit 'stop' watch event synchronously (Claudio Rodriguez) [#8524](https://github.com/nodejs/node/pull/8524)
* [[`b50557b51b`](https://github.com/nodejs/node/commit/b50557b51b)] - **fs**: use process.emitWarning to print deprecation warning (James M Snell) [#8166](https://github.com/nodejs/node/pull/8166)
* [[`dc7277909b`](https://github.com/nodejs/node/commit/dc7277909b)] - **fs**: move SyncWriteStream to internal/fs (James M Snell) [#6749](https://github.com/nodejs/node/pull/6749)
* [[`49ef3ae90a`](https://github.com/nodejs/node/commit/49ef3ae90a)] - **(SEMVER-MAJOR)** ***Revert*** "**fs**: add a temporary fix for re-evaluation support" (James M Snell) [#6413](https://github.com/nodejs/node/pull/6413)
* [[`f8f283b8f3`](https://github.com/nodejs/node/commit/f8f283b8f3)] - **(SEMVER-MAJOR)** **fs**: warn if no callback is passed to async calls (Sakthipriyan Vairamani) [#7897](https://github.com/nodejs/node/pull/7897)
* [[`6f27bedfba`](https://github.com/nodejs/node/commit/6f27bedfba)] - **governance**: expand use of CTC issue tracker (Rich Trott) [#8945](https://github.com/nodejs/node/pull/8945)
* [[`179150091f`](https://github.com/nodejs/node/commit/179150091f)] - **http**: name anonymous functions in http (maasencioh) [#9055](https://github.com/nodejs/node/pull/9055)
* [[`73a8d3b0da`](https://github.com/nodejs/node/commit/73a8d3b0da)] - **http**: name anonymous functions in _http_server (maasencioh) [#9055](https://github.com/nodejs/node/pull/9055)
* [[`ffa5c9ea30`](https://github.com/nodejs/node/commit/ffa5c9ea30)] - **http**: name anonymous functions in _http_outgoing (maasencioh) [#9055](https://github.com/nodejs/node/pull/9055)
* [[`fa035ada90`](https://github.com/nodejs/node/commit/fa035ada90)] - **http**: name anonymous functions in _http_incoming (maasencioh) [#9055](https://github.com/nodejs/node/pull/9055)
* [[`ec17e76656`](https://github.com/nodejs/node/commit/ec17e76656)] - **http**: name anonymous functions in _http_client (maasencioh) [#9055](https://github.com/nodejs/node/pull/9055)
* [[`9099a43073`](https://github.com/nodejs/node/commit/9099a43073)] - **http**: name anonymous functions (maasencioh) [#9054](https://github.com/nodejs/node/pull/9054)
* [[`cde2ca96e4`](https://github.com/nodejs/node/commit/cde2ca96e4)] - **http**: reject control characters in http.request() (Ben Noordhuis) [#8923](https://github.com/nodejs/node/pull/8923)
* [[`2cc7fa5e7d`](https://github.com/nodejs/node/commit/2cc7fa5e7d)] - **(SEMVER-MAJOR)** **http**: remove deprecated Client interface (Brian White) [#8104](https://github.com/nodejs/node/pull/8104)
* [[`31bef6b704`](https://github.com/nodejs/node/commit/31bef6b704)] - **(SEMVER-MAJOR)** **http**: correct error message for invalid trailer (Bryan English) [#6308](https://github.com/nodejs/node/pull/6308)
* [[`a54ec7f49c`](https://github.com/nodejs/node/commit/a54ec7f49c)] - **inspector**: no URLs when the debugger is connected (Eugene Ostroukhov) [#8919](https://github.com/nodejs/node/pull/8919)
* [[`626a07df5b`](https://github.com/nodejs/node/commit/626a07df5b)] - **inspector**: restore 9229 as a default port (Eugene Ostroukhov) [#8550](https://github.com/nodejs/node/pull/8550)
* [[`9f1f7e2a34`](https://github.com/nodejs/node/commit/9f1f7e2a34)] - **(SEMVER-MAJOR)** **inspector**: listen on process.debugPort (cjihrig) [#8386](https://github.com/nodejs/node/pull/8386)
* [[`7b73f55902`](https://github.com/nodejs/node/commit/7b73f55902)] - **internal/util**: remove printDeprecationWarning (James M Snell) [#8166](https://github.com/nodejs/node/pull/8166)
* [[`9ad3082b1c`](https://github.com/nodejs/node/commit/9ad3082b1c)] - **(SEMVER-MAJOR)** **intl**: add deprecation warning for v8BreakIterator (Michaël Zasso) [#8908](https://github.com/nodejs/node/pull/8908)
* [[`15eaba98a1`](https://github.com/nodejs/node/commit/15eaba98a1)] - **lib**: use emitWarning instead of printDeprecationMessage (James M Snell) [#8166](https://github.com/nodejs/node/pull/8166)
* [[`3a3996315c`](https://github.com/nodejs/node/commit/3a3996315c)] - **lib,src**: reset zero fill flag on exception (Ben Noordhuis) [#7093](https://github.com/nodejs/node/pull/7093)
* [[`27e84ddd4e`](https://github.com/nodejs/node/commit/27e84ddd4e)] - **lib,src**: clean up ArrayBufferAllocator (Ben Noordhuis) [#7082](https://github.com/nodejs/node/pull/7082)
* [[`334ef4f19d`](https://github.com/nodejs/node/commit/334ef4f19d)] - **lib,src**: drop dependency on v8::Private::ForApi() (Ben Noordhuis) [#7082](https://github.com/nodejs/node/pull/7082)
* [[`d582193613`](https://github.com/nodejs/node/commit/d582193613)] - **(SEMVER-MAJOR)** **module**: Remove deprecated function requireRepl. (Adri Van Houdt) [#8575](https://github.com/nodejs/node/pull/8575)
* [[`6f1cae70eb`](https://github.com/nodejs/node/commit/6f1cae70eb)] - **net**: fix ambiguity in EOF handling (Fedor Indutny) [#9066](https://github.com/nodejs/node/pull/9066)
* [[`fd6af98c2d`](https://github.com/nodejs/node/commit/fd6af98c2d)] - **(SEMVER-MAJOR)** **net**: refactor Server.prototype.listen (Jan Schär) [#4039](https://github.com/nodejs/node/pull/4039)
* [[`5e5ec2cd1e`](https://github.com/nodejs/node/commit/5e5ec2cd1e)] - **(SEMVER-MAJOR)** **os**: deprecate `tmpDir()` in favour of `tmpdir()` (Jeremiah Senkpiel) [#6739](https://github.com/nodejs/node/pull/6739)
* [[`aedb72e03b`](https://github.com/nodejs/node/commit/aedb72e03b)] - **process**: improve performance of nextTick (Evan Lucas) [#8932](https://github.com/nodejs/node/pull/8932)
* [[`bf91035364`](https://github.com/nodejs/node/commit/bf91035364)] - **process**: fix handling of process.noDeprecation in emitWarning (James M Snell) [#8166](https://github.com/nodejs/node/pull/8166)
* [[`62b544290a`](https://github.com/nodejs/node/commit/62b544290a)] - **(SEMVER-MAJOR)** **process**: remove deprecated process.EventEmitter (cjihrig) [#6862](https://github.com/nodejs/node/pull/6862)
* [[`07dbf7313d`](https://github.com/nodejs/node/commit/07dbf7313d)] - **(SEMVER-MAJOR)** **promise**: hard deprecation for unhandled promise rejection (James M Snell) [#8217](https://github.com/nodejs/node/pull/8217)
* [[`ecf474ceba`](https://github.com/nodejs/node/commit/ecf474ceba)] - **(SEMVER-MAJOR)** **promise**: warn on unhandled rejections (Benjamin Gruenbaum) [#8217](https://github.com/nodejs/node/pull/8217)
* [[`1a9e247c79`](https://github.com/nodejs/node/commit/1a9e247c79)] - **(SEMVER-MAJOR)** **readline**: show completions only after 2nd TAB (Anna Henningsen) [#7754](https://github.com/nodejs/node/pull/7754)
* [[`8a87b29034`](https://github.com/nodejs/node/commit/8a87b29034)] - **(SEMVER-MAJOR)** **readline**: remove deprecated methods (cjihrig) [#6423](https://github.com/nodejs/node/pull/6423)
* [[`488d28d391`](https://github.com/nodejs/node/commit/488d28d391)] - **(SEMVER-MAJOR)** **repl**: deprecate unused function convertToContext (Prince J Wesley) [#7829](https://github.com/nodejs/node/pull/7829)
* [[`b2be04ac85`](https://github.com/nodejs/node/commit/b2be04ac85)] - **src**: refactor contextify (Franziska Hinkelmann) [#8909](https://github.com/nodejs/node/pull/8909)
* [[`e175188a94`](https://github.com/nodejs/node/commit/e175188a94)] - **src**: fix typo rval to value (Miguel Angel Asencio Hurtado) [#9023](https://github.com/nodejs/node/pull/9023)
* [[`1fda657cac`](https://github.com/nodejs/node/commit/1fda657cac)] - **(SEMVER-MAJOR)** **src**: update module version mismatch error message (James M Snell) [#8391](https://github.com/nodejs/node/pull/8391)
* [[`96933df2ff`](https://github.com/nodejs/node/commit/96933df2ff)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 51 (Myles Borins) [#8808](https://github.com/nodejs/node/pull/8808)
* [[`b032f1cfc3`](https://github.com/nodejs/node/commit/b032f1cfc3)] - **(SEMVER-MAJOR)** **src**: no longer need to use std::tr1:: (Michaël Zasso) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`ebad04326d`](https://github.com/nodejs/node/commit/ebad04326d)] - **src**: notify V8 for low memory when alloc fails (Anna Henningsen) [#8482](https://github.com/nodejs/node/pull/8482)
* [[`aed9792ff4`](https://github.com/nodejs/node/commit/aed9792ff4)] - **src**: provide allocation + nullptr check shortcuts (Anna Henningsen) [#8482](https://github.com/nodejs/node/pull/8482)
* [[`d2470d4dff`](https://github.com/nodejs/node/commit/d2470d4dff)] - **src**: pass desired return type to allocators (Anna Henningsen) [#8482](https://github.com/nodejs/node/pull/8482)
* [[`de946013c2`](https://github.com/nodejs/node/commit/de946013c2)] - **src**: add Malloc() size param + overflow detection (Anna Henningsen) [#8482](https://github.com/nodejs/node/pull/8482)
* [[`5bf94357a9`](https://github.com/nodejs/node/commit/5bf94357a9)] - **src**: remove unused StringValue macro parameters (Daniel Bevenius) [#7905](https://github.com/nodejs/node/pull/7905)
* [[`cc00be6ace`](https://github.com/nodejs/node/commit/cc00be6ace)] - **src**: fix -Wunused-result warning (Santiago Gimeno) [#8450](https://github.com/nodejs/node/pull/8450)
* [[`8e7cbe2546`](https://github.com/nodejs/node/commit/8e7cbe2546)] - **(SEMVER-MAJOR)** **src**: make debugger listen on 127.0.0.1 by default (Ben Noordhuis) [#8106](https://github.com/nodejs/node/pull/8106)
* [[`781713d5ef`](https://github.com/nodejs/node/commit/781713d5ef)] - **src**: remove unused isolate member (Ben Noordhuis) [#7334](https://github.com/nodejs/node/pull/7334)
* [[`de4161d367`](https://github.com/nodejs/node/commit/de4161d367)] - **src**: remove unused internals from node.cc (Anna Henningsen) [#7117](https://github.com/nodejs/node/pull/7117)
* [[`ac0665c908`](https://github.com/nodejs/node/commit/ac0665c908)] - **src**: fix ArrayBuffer size for zero fill flag (Anna Henningsen) [#7142](https://github.com/nodejs/node/pull/7142)
* [[`aac79dfd78`](https://github.com/nodejs/node/commit/aac79dfd78)] - **src**: use stack-allocated Environment instances (Ben Noordhuis) [#7090](https://github.com/nodejs/node/pull/7090)
* [[`58cec4e85b`](https://github.com/nodejs/node/commit/58cec4e85b)] - **src**: move env init logic into Environment class (Ben Noordhuis) [#7090](https://github.com/nodejs/node/pull/7090)
* [[`c3cd453cba`](https://github.com/nodejs/node/commit/c3cd453cba)] - **src**: make IsolateData creation explicit (Ben Noordhuis) [#7082](https://github.com/nodejs/node/pull/7082)
* [[`0301ce9f55`](https://github.com/nodejs/node/commit/0301ce9f55)] - **src**: move IsolateData out of Environment (Ben Noordhuis) [#7082](https://github.com/nodejs/node/pull/7082)
* [[`a3c5567eb4`](https://github.com/nodejs/node/commit/a3c5567eb4)] - **(SEMVER-MAJOR)** **src,win**: use correct exit code in old versions (yorkie) [#8204](https://github.com/nodejs/node/pull/8204)
* [[`2f05af4c06`](https://github.com/nodejs/node/commit/2f05af4c06)] - **(SEMVER-MAJOR)** **stream**: improve stream error messages (Italo A. Casas) [#8801](https://github.com/nodejs/node/pull/8801)
* [[`9983af0347`](https://github.com/nodejs/node/commit/9983af0347)] - **(SEMVER-MAJOR)** **stream**: improve unimplemented \_write() error (ratikesh9) [#7671](https://github.com/nodejs/node/pull/7671)
* [[`0cd0118334`](https://github.com/nodejs/node/commit/0cd0118334)] - **(SEMVER-MAJOR)** **stream**: 'data' argument on callback of Transform.\_flush() (Jesús Leganés Combarro "piranna) [#3708](https://github.com/nodejs/node/pull/3708)
* [[`a717be87a3`](https://github.com/nodejs/node/commit/a717be87a3)] - **test**: fix flaky test-timers-blocking-callback (Rich Trott) [#9198](https://github.com/nodejs/node/pull/9198)
* [[`5ba02bf5db`](https://github.com/nodejs/node/commit/5ba02bf5db)] - **test**: remove arbitrary timer (Rich Trott) [#9197](https://github.com/nodejs/node/pull/9197)
* [[`1518cc1e70`](https://github.com/nodejs/node/commit/1518cc1e70)] - **test**: remove duplicate required module (Rich Trott) [#9169](https://github.com/nodejs/node/pull/9169)
* [[`d62e7bd1f9`](https://github.com/nodejs/node/commit/d62e7bd1f9)] - **test**: add regression test for instanceof (Franziska Hinkelmann) [#9178](https://github.com/nodejs/node/pull/9178)
* [[`bb1e6064c1`](https://github.com/nodejs/node/commit/bb1e6064c1)] - **test**: rename target to exports for consistency (Daniel Bevenius) [#9135](https://github.com/nodejs/node/pull/9135)
* [[`8788d009f8`](https://github.com/nodejs/node/commit/8788d009f8)] - **test**: checking if error constructor is assert.AssertionError (larissayvette) [#9119](https://github.com/nodejs/node/pull/9119)
* [[`68157bd8b9`](https://github.com/nodejs/node/commit/68157bd8b9)] - **test**: remove unneeded escaping in template strings (Rich Trott) [#9112](https://github.com/nodejs/node/pull/9112)
* [[`0591362887`](https://github.com/nodejs/node/commit/0591362887)] - **test**: remove unused common.libDir (Rich Trott) [#9124](https://github.com/nodejs/node/pull/9124)
* [[`0f2f4d2425`](https://github.com/nodejs/node/commit/0f2f4d2425)] - **test**: fix flaky test-child-process-fork-dgram (Rich Trott) [#9098](https://github.com/nodejs/node/pull/9098)
* [[`47863a5837`](https://github.com/nodejs/node/commit/47863a5837)] - **test**: use npm sandbox in test-npm-install (João Reis) [#9079](https://github.com/nodejs/node/pull/9079)
* [[`67e2b92e21`](https://github.com/nodejs/node/commit/67e2b92e21)] - **test**: enable node-module-version/test.js with debug (Daniel Bevenius) [#9093](https://github.com/nodejs/node/pull/9093)
* [[`d5bdd65c6a`](https://github.com/nodejs/node/commit/d5bdd65c6a)] - **test**: move module out of fixture directory (Rich Trott) [#9022](https://github.com/nodejs/node/pull/9022)
* [[`0ad0e6addb`](https://github.com/nodejs/node/commit/0ad0e6addb)] - **test**: fix issues reported by Coverity (Eugene Ostroukhov) [#8870](https://github.com/nodejs/node/pull/8870)
* [[`aac93a5c64`](https://github.com/nodejs/node/commit/aac93a5c64)] - **test**: refactor test-file-* (Jenna Vuong) [#8999](https://github.com/nodejs/node/pull/8999)
* [[`1bb1b3abe4`](https://github.com/nodejs/node/commit/1bb1b3abe4)] - **test**: fixes that do not affect performance (larissayvette) [#9011](https://github.com/nodejs/node/pull/9011)
* [[`96faba6ad8`](https://github.com/nodejs/node/commit/96faba6ad8)] - **test**: add cluster inspector debug port test (cjihrig) [#8958](https://github.com/nodejs/node/pull/8958)
* [[`7926886bf3`](https://github.com/nodejs/node/commit/7926886bf3)] - **test**: fix test-debug-signal-cluster.js flakyness (Julien Gilli) [#8568](https://github.com/nodejs/node/pull/8568)
* [[`99cfd53097`](https://github.com/nodejs/node/commit/99cfd53097)] - **(SEMVER-MAJOR)** **test**: test execFile/fork arg validation (Chuck Langford) [#7399](https://github.com/nodejs/node/pull/7399)
* [[`15cd45c6fc`](https://github.com/nodejs/node/commit/15cd45c6fc)] - **test**: fix tests for non-crypto builds (Anna Henningsen) [#7056](https://github.com/nodejs/node/pull/7056)
* [[`fea3070ec4`](https://github.com/nodejs/node/commit/fea3070ec4)] - **test**: add buffer testcase for resetting kZeroFill (Сковорода Никита Андреевич) [#7093](https://github.com/nodejs/node/pull/7093)
* [[`2cdd5ccef9`](https://github.com/nodejs/node/commit/2cdd5ccef9)] - **test,lib,benchmark**: match function names (Rich Trott) [#9113](https://github.com/nodejs/node/pull/9113)
* [[`827660e03e`](https://github.com/nodejs/node/commit/827660e03e)] - **tools**: enable ES2016 syntax support in ESLint (Michaël Zasso) [#9218](https://github.com/nodejs/node/pull/9218)
* [[`a83354a567`](https://github.com/nodejs/node/commit/a83354a567)] - **tools**: replace custom lint rule for getter/setter (Rich Trott) [#9194](https://github.com/nodejs/node/pull/9194)
* [[`3ab8be07cb`](https://github.com/nodejs/node/commit/3ab8be07cb)] - **tools**: fix release script on macOS 10.12 (Evan Lucas) [#8824](https://github.com/nodejs/node/pull/8824)
* [[`72fa9f5663`](https://github.com/nodejs/node/commit/72fa9f5663)] - **tools**: update ESLint to v3.8.0 (Rich Trott) [#9112](https://github.com/nodejs/node/pull/9112)
* [[`8ac29bd7c1`](https://github.com/nodejs/node/commit/8ac29bd7c1)] - **tools**: avoid let in for loops (jessicaquynh) [#9049](https://github.com/nodejs/node/pull/9049)
* [[`1a93e03a0e`](https://github.com/nodejs/node/commit/1a93e03a0e)] - **(SEMVER-MAJOR)** **tools**: do not disable ICU's transliteration (Michaël Zasso) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`6a3dbdacd6`](https://github.com/nodejs/node/commit/6a3dbdacd6)] - **(SEMVER-MAJOR)** **udp**: remove ancient check (Saúl Ibarra Corretgé) [#8088](https://github.com/nodejs/node/pull/8088)
* [[`1afd7c166e`](https://github.com/nodejs/node/commit/1afd7c166e)] - **url**: fix building when using --without-intl (James M Snell) [#9041](https://github.com/nodejs/node/pull/9041)
* [[`a8ece149e2`](https://github.com/nodejs/node/commit/a8ece149e2)] - **(SEMVER-MINOR)** **url**: adding WHATWG URL support (James M Snell) [#7448](https://github.com/nodejs/node/pull/7448)
* [[`336b027411`](https://github.com/nodejs/node/commit/336b027411)] - **(SEMVER-MAJOR)** **url**: return valid file: urls fom url.format() (Rich Trott) [#7234](https://github.com/nodejs/node/pull/7234)
* [[`197a465280`](https://github.com/nodejs/node/commit/197a465280)] - **(SEMVER-MAJOR)** **zlib**: move constants into zlib.constants (James M Snell) [#7203](https://github.com/nodejs/node/pull/7203)
