/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef hpke_vectors_h__
#define hpke_vectors_h__

#include "pk11hpke.h"
#include <vector>

typedef struct hpke_encrypt_vector_str {
  std::string pt;
  std::string aad;
  std::string ct;
} hpke_encrypt_vector;

typedef struct hpke_export_vector_str {
  std::string ctxt;
  size_t len;
  std::string exported;
} hpke_export_vector;

/* Note: The following test vec values are implicitly checked via:
 * shared_secret: secret derivation
 * key_sched_context: key/nonce derivations
 * secret: key/nonce derivations
 * exporter_secret: export vectors */
typedef struct hpke_vector_str {
  uint32_t test_id;
  HpkeModeId mode;
  HpkeKemId kem_id;
  HpkeKdfId kdf_id;
  HpkeAeadId aead_id;
  std::string info;
  std::string pkcs8_e;
  std::string pkcs8_r;
  std::string psk;
  std::string psk_id;
  std::string enc;
  std::string key;
  std::string nonce;
  std::vector<hpke_encrypt_vector> encrypt_vecs;
  std::vector<hpke_export_vector> export_vecs;
} hpke_vector;

const hpke_vector kHpkeTestVectors[] = {
    // A.1. DHKEM(X25519, HKDF-SHA256), HKDF-SHA256, AES-128-GCM, Base mode
    {0,
     static_cast<HpkeModeId>(0),
     static_cast<HpkeKemId>(32),
     static_cast<HpkeKdfId>(1),
     static_cast<HpkeAeadId>(1),
     "4f6465206f6e2061204772656369616e2055726e",
     "3067020100301406072a8648ce3d020106092b06010401da470f01044c304a02010104206"
     "cee2e2755790708a2a1be22667883a5e3f9ec52810404a0d889a0ed3e28de00a123032100"
     "950897e0d37a8bdb0f2153edf5fa580a64b399c39fbb3d014f80983352a63617",
     "3067020100301406072a8648ce3d020106092b06010401da470f01044c304a0201010420e"
     "caf25b8485bcf40b9f013dbb96a6230f25733b8435bba0997a1dedbc7f78806a123032100"
     "a5912b20892e36905bac635267e2353d58f8cc7525271a2bf57b9c48d2ec2c07",
     "",
     "",
     "950897e0d37a8bdb0f2153edf5fa580a64b399c39fbb3d014f80983352a63617",
     "e20cee1bf5392ad2d3a442e231f187ae",
     "5d99b2f03c452f7a9441933a",
     {// Encryptions
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d30",
       "9418f1ae06eddc43aa911032aed4a951754ee2286a786733761857f8d96a7ec8d852da9"
       "3bc5eeab49623344aba"},
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d31",
       "74d69c61899b9158bb50e95d92fbad106f612ea67c61b3c4bef65c8bf3dc18e17bf41ec"
       "4c408688aae58358d0e"},
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d32",
       "e6602db9be05d81c4ab8fa621bc35993a7b759851075a34b3bffd257340011c70c9fa1f"
       "5c11868a076fc3adb3b"}},
     {// Exports
      {"", 32,
       "be82c06bd83fd6edd74385de5a70859b9e03def4c7bb224a10cfae86087f8a25"},
      {"00", 32,
       "82cbfd3c2b2db75e2311d457e569cf12b6387eb4309bca8e77adb2f2b599fc85"},
      {"54657374436f6e74657874", 32,
       "c8387c1e6ec4f026c7f3577e3f29df51f46161295eec84c4f64a9174f7b64e4f"}}},

    // A.1. DHKEM(X25519, HKDF-SHA256), HKDF-SHA256, AES-128-GCM, PSK mode
    {1,
     static_cast<HpkeModeId>(1),
     static_cast<HpkeKemId>(32),
     static_cast<HpkeKdfId>(1),
     static_cast<HpkeAeadId>(1),
     "4f6465206f6e2061204772656369616e2055726e",
     "3067020100301406072a8648ce3d020106092b06010401da470f01044c304a02010104204"
     "c1feed23e15ec6a55b8457e0c0f42a3a1ab3ccc309b7cbb7ac6165fc657bd3ba123032100"
     "f16fa9440b2cb36c855b4b82fb87e1c02ce656dd132f7a7aec739294b6912768",
     "3067020100301406072a8648ce3d020106092b06010401da470f01044c304a02010104208"
     "e5430f0d821407670e5e3f6eecc9f52b2cad27b15a5fad1f3d05359ae30d81ca123032100"
     "13c789187a2dda71889e4b98dc5443624ae68f309cea91865561cfa207586e3a",
     "0247fd33b913760fa1fa51e1892d9f307fbe65eb171e8132c2af18555a738b82",
     "456e6e796e20447572696e206172616e204d6f726961",
     "f16fa9440b2cb36c855b4b82fb87e1c02ce656dd132f7a7aec739294b6912768",
     "70030b55bfb737d4f4355cf62302d281",
     "746d5e6255902701c3e0b99f",
     {// Encryptions
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d30",
       "63f7ed3d99e625d4a7373982b5f04daf0c3dfff39cac4b38eeb9d5c225cc3183bdbc91a"
       "053db9b195319cc8c45"},
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d31",
       "65e7160f80fdf47893a5abe1edcff46c85899f04acb97882e194ce6d4fceec2dc4cb2d3"
       "abe5d969880722859b2"},
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d32",
       "915e08e6e340fca64982e90ad93490826bfb74af8f48062212c87105dad2b7569c83688"
       "e564ed5862592b77cdc"}},
     {// Exports
      {"", 32,
       "7c40ceb745e14d19fceeac6e4756c796957fe5ff28709198c3f8cbdb5d368fe1"},
      {"00", 32,
       "1ef0fd07bd40326f1b88f3545c92969cff202ca7186b9fd1315241f93fcc2edf"},
      {"54657374436f6e74657874", 32,
       "997368419db9490aa96c977cdd90bda8fd6234054d4add3d2f31aaaa2f8c1172"}}},
    // A.2. DHKEM(X25519, HKDF-SHA256), HKDF-SHA256, ChaCha20Poly1305, Base
    // mode
    {2,
     static_cast<HpkeModeId>(0),
     static_cast<HpkeKemId>(32),
     static_cast<HpkeKdfId>(1),
     static_cast<HpkeAeadId>(3),
     "4f6465206f6e2061204772656369616e2055726e",
     "3067020100301406072a8648ce3d020106092b06010401da470f01044c304a0201010420e"
     "fda8f0538ce6ab9f165aae26e02ad96dcb1775b248267174aeb3d140e002ee3a123032100"
     "1440805f4e60cbd34835baf0813c3071d17def1dbd8c04e75889bb2271d7823a",
     "3067020100301406072a8648ce3d020106092b06010401da470f01044c304a02010104201"
     "4365bb26500e7cf263720c4ab04bd45b8e146b4f724facd1fa01d58b63975e4a123032100"
     "26147d5c2978bccc3cc03a4f9ac607560b5d83f852be4e9024f2cb7207d4c30e",
     "",
     "",
     "1440805f4e60cbd34835baf0813c3071d17def1dbd8c04e75889bb2271d7823a",
     "a17448a542d0d6d75e3b21be0a1f68607904b4802c6b19a7e7e90976aa00a5c8",
     "6f6b832dba944a91e5684514",
     {// Encryptions
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d30",
       "1b9ce69bd0e6b4242ac2dd841ef093fc9dfa9e684f81c2d1778fd3268ca5aa7d612cd87"
       "f72acd2aeaee084dee2"},
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d31",
       "f041fb8de275b5319587269cb39190029906b9267eb5619b7bec8a5e0b3b3a0bead1696"
       "17f2c4d45d028b1b654"},
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d32",
       "0042c74002608a20e432ee9628e84cba76482aca29359e93d60067371be547355acca2c"
       "271a2072b85a77a6237"}},
     {// Exports
      {"", 32,
       "996dc6fda1dc47e687613e0e221d64a3598e1ead9585177d22f230716569c04d"},
      {"00", 32,
       "6d07b4e3e06ace3dc3f1b2a0826a0f896aa828769ff993c2e3829ae40325c27d"},
      {"54657374436f6e74657874", 32,
       "bb69068c4f7767331512d375e4ab0ca0c6c51446040096ea0ae1cc3f9a3f54bd"}}},
    // A.2. DHKEM(X25519, HKDF-SHA256), HKDF-SHA256, ChaCha20Poly1305, PSK
    // mode
    {3,
     static_cast<HpkeModeId>(1),
     static_cast<HpkeKemId>(32),
     static_cast<HpkeKdfId>(1),
     static_cast<HpkeAeadId>(3),
     "4f6465206f6e2061204772656369616e2055726e",
     "3067020100301406072a8648ce3d020106092b06010401da470f01044c304a0201010420d"
     "b1c9dfba77e1e3b8687ea18af207cffca803bdd983f955376b8271ef9c78a46a123032100"
     "8e4b29035c22b67b3a7a0f5a52f12b3ab17a9ae1f0c63b029137ba09f420224a",
     "3067020100301406072a8648ce3d020106092b06010401da470f01044c304a02010104204"
     "e335da3ec60e68c156586b8217de6801cb83b5a4de413645fcb112c00b2228ba123032100"
     "94ea1227a357dfd3548aadb9ef19d9974add594871498e123390a8bcb4db5d51",
     "0247fd33b913760fa1fa51e1892d9f307fbe65eb171e8132c2af18555a738b82",
     "456e6e796e20447572696e206172616e204d6f726961",
     "8e4b29035c22b67b3a7a0f5a52f12b3ab17a9ae1f0c63b029137ba09f420224a",
     "a603fe0f9897dc6ce042a467d6bd430a01cd679e930f1b5706ad425e4153496d",
     "318e48afae42913a928146e6",
     {// Encryptions
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d30",
       "c87f8158a501c7a2f31708bbdba10f9c5ad035624c3153eeb028e65b82f41f38cbe1cd9"
       "aafb10e502d328b83c1"},
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d31",
       "aef7a0b0e3a58b177dac9628439b44d1e706724e265ab3b46d791612b51637342479ad9"
       "45607b8b54112bd8c86"},
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d32",
       "c00884a5c658213bd4381d65b54d93682692fef9408a6e437a97a904267727269b242d3"
       "d81725ad8f0c764e082"}},
     {// Exports
      {"", 32,
       "23c31ee2757bbecf105f74c90bf1e640b6ddc545dc8d80b1abbf2aa9dd1786ce"},
      {"00", 32,
       "05af7597519945fe8443f7cb84cdb651a8dd18cd7bbbd65d31095d3c69c1257e"},
      {"54657374436f6e74657874", 32,
       "5814619f842c7c328c9657854154e51b581c7bbd3b646bd773be67f93900a109"}}},
    // DHKEM(X25519, HKDF-SHA256), HKDF-SHA512, ChaCha20Poly1305, Base mode
    // Tests KEM.hash != KDF.hash.
    {4,
     static_cast<HpkeModeId>(0),
     static_cast<HpkeKemId>(32),
     static_cast<HpkeKdfId>(3),
     static_cast<HpkeAeadId>(3),
     "4f6465206f6e2061204772656369616e2055726e",
     "3067020100301406072a8648ce3d020106092b06010401da470f01044c304a02010104200"
     "6e74abcc8b65671d1ef4a6cb273662c6a3b3ff6590852bfebc7bc94887f5c4ea123032100"
     "de2746f66f3e14a3389f570e8f8cc1de4e39a89d1cbb445fad711d7acf407e15",
     "3067020100301406072a8648ce3d020106092b06010401da470f01044c304a02010104202"
     "dc14b2f31b233963f0a2d9a836072f29666fdea84a5893d30254deb9183e0a9a123032100"
     "318f92c9e96142c4ce9a06ea04f7099698ee4160044f2db585d9e2b02abd6041",
     "",
     "",
     "de2746f66f3e14a3389f570e8f8cc1de4e39a89d1cbb445fad711d7acf407e15",
     "4a54adb318d8a420506b0473815a32c2b1923a936fa7c735c8a038a38fcc80d2",
     "9c6d83a59628e7327d19a3d8",
     {// Encryptions
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d30",
       "59cbc98df2d7640598377e3184e07c008dea1c264c72a8414028715960ab6d6909a3110"
       "e633a23baf8b9b5e2f1"},
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d31",
       "c9a4b68ea349eea9fdf499f7577c9325e9b76f24308a81ac5dfbbee3489dd41c85d7fb3"
       "5e585859ea5c790f155"},
      {"4265617574792069732074727574682c20747275746820626561757479",
       "436f756e742d32",
       "5d9f717b192b43bea1f6bd25ee63d7b88b06019132c31a4e262a4c1d4f01c7bd70d00df"
       "0e2f858cf654ae86447"}},
     {// Exports
      {"", 32,
       "97b0ac016b9dedb5f115cf6fd24b927f8e75b48a2ab6069efe7fec6a18ff4272"},
      {"00", 32,
       "c994b47854104e476d9e47bb15f9fb66f4879f68bc89a4cfccc259e80a30c913"},
      {"54657374436f6e74657874", 32,
       "9199e5beeda45397b1bbee3dd13ad1afbd2963f83d9e5ebdf1e23b6c7e012317"}}},
};
#endif  // hpke_vectors_h__
