#!/bin/sh
#
# ntpman.sh  -- Create man pages for ntp

# Configuration parameters
#4.2.0-r2
#/usr/share/doc/ntp-$VERSION/html
VERSION=4.2.2p2
HTMLDIR=/usr/local/src/ntp/ntp-${VERSION}/html
MANDIR=man

if [ ! -d "${HTMLDIR}" ] ; then
	echo "ERROR: $HTMLDIR does not exist"
	exit 1
fi

# Process a single HTML file
processfile() {
    HTMLFILE=$1
    MANFILE=$2
    echo -n "Processing $HTMLFILE..."
	sed -e "s:<csobj.*<:csobj>/:" -e "s:&nbsp;: :" -e "s/\\\/\//" $HTMLDIR/$HTMLFILE > f
	xsltproc --html --stringparam version $VERSION ntp.xsl f > $MANDIR/$MANFILE || exit 1
	rm -f f
    echo "Done."
}

# Print information
echo "Generates ntp man files from HTML documentation. Using:"
echo "VERSION:   $VERSION"
echo "HTMLDIR:   $HTMLDIR"
echo "MANDIR:    $MANDIR"
echo "Press enter to continue, or Ctrl-C to cancel."
read

# Process HTML files
rm -rf ${MANDIR}
mkdir ${MANDIR}
for f in ntp{date,dc,d,q,time,trace,dsim} keygen tickadj ; do
	processfile ${f}.html ${f}.8
done
echo

cp -v /usr/local/src/freebsd/src/usr.sbin/ntp/doc/*.5 man/
cp -v genmans.sh ntp.xsl man/

tar -jcf ntp-${VERSION}-manpages.tar.bz2 ${MANDIR}
du -b ntp-${VERSION}-manpages.tar.bz2
