#!/bin/bash
#
# ntpman.sh  -- Create man pages for ntp
#

VERSION=$1
if [[ -z ${VERSION} ]] ; then
	VERSION=$(ls -1d ntp-*/ 2>/dev/null | LC_COLLATE=C sort | sed -n '${s:/::;p;Q}')
	if [[ -z ${VERSION} ]] ; then
		VERSION=$(ls "${0%/*}"/../../ntp-*.ebuild | LC_COLLATE=C sort | sed -n '${s:.*/::;s:_::;s:[.]ebuild::;p;Q}')
		if [[ -z ${VERSION} ]] ; then
			echo "Usage: $0 <version>"
			exit 1
		fi
	fi
fi
[[ ${VERSION} != ntp-* ]] && VERSION="ntp-${VERSION}"

if ! which portageq > /dev/null 2>&1; then
	echo "Sorry I can't find portageq"
	exit 1
fi
SRCDIR=${0%/*}
HTMLDIR=${SRCDIR}/${VERSION}/html
DISTFILE=$(portageq envvar DISTDIR)/${VERSION}.tar.gz
MANDIR=${SRCDIR}/man

rm -rf ${SRCDIR}/${VERSION}
if [[ ! -d ${HTMLDIR} ]] ; then
	if [[ -f ${DISTFILE} ]] ; then
		tar zxf ${DISTFILE} -C ${SRCDIR} || exit 1
	else
		echo "ERROR: $HTMLDIR / $DISTFILE does not exist"
		exit 1
	fi
fi

# Process a single HTML file
processfile() {
    HTMLFILE=$1
    MANFILE=$2
    echo -n "Processing $HTMLFILE ..."
	sed -e "s:<csobj.*<:csobj>/:" $HTMLDIR/$HTMLFILE > .$HTMLFILE
	xsltproc --html --stringparam version $VERSION ${SRCDIR}/ntp.xsl .$HTMLFILE > $MANDIR/$MANFILE || exit 1
	rm -f .$HTMLFILE
    echo "Done."
}

# Print information
echo "Generates ntp man files from HTML documentation. Using:"
echo "VERSION:   $VERSION"
echo "HTMLDIR:   $HTMLDIR"
echo "MANDIR:    $MANDIR"
echo "Press enter to continue, or Ctrl-C to cancel."
read

# Process HTML files
rm -rf ${MANDIR}
mkdir ${MANDIR}
for f in ntp{date,dc,d,q,time,trace,dsim} keygen tickadj ; do
	processfile ${f}.html ${f}.8
done
echo

pushd ${VERSION}
# We need to build it to get the ntp.conf.5 man page
./configure
make -j4
popd

cp -vi ${VERSION}/ntpd/ntp.conf.5 ${MANDIR} || exit 1

(
d=${PWD}
cd ${MANDIR}
# Are there any patches?
if ls -l *.5.patch > /dev/null 2>&1; then
	for p in $d/*.5.patch ; do
		patch -F0 -p0 < $p || exit 1
	done
fi
) || exit 1
cp -vi ${SRCDIR}/*.patch ${SRCDIR}/genmans.sh ${SRCDIR}/ntp.xsl ${MANDIR}

tar -jcf ${VERSION}-manpages.tar.bz2 -C ${MANDIR}/.. man
du -b ${VERSION}-manpages.tar.bz2

rm -rf ${MANDIR} ${SRCDIR}/${VERSION}
