np.bartlett(12)
# array([ 0.        ,  0.18181818,  0.36363636,  0.54545455,  0.72727273,
# 0.90909091,  0.90909091,  0.72727273,  0.54545455,  0.36363636,
# 0.18181818,  0.        ])

# Plot the window and its frequency response (requires SciPy and matplotlib):

from numpy import clip, log10, array, bartlett, linspace
from numpy.fft import fft, fftshift
import matplotlib.pyplot as plt

window = bartlett(51)
plt.plot(window)
# [<matplotlib.lines.Line2D object at 0x...>]
plt.title("Bartlett window")
# <matplotlib.text.Text object at 0x...>
plt.ylabel("Amplitude")
# <matplotlib.text.Text object at 0x...>
plt.xlabel("Sample")
# <matplotlib.text.Text object at 0x...>
plt.show()

plt.figure()
# <matplotlib.figure.Figure object at 0x...>
A = fft(window, 2048) / 25.5
mag = abs(fftshift(A))
freq = linspace(-0.5,0.5,len(A))
response = 20*log10(mag)
response = clip(response,-100,100)
plt.plot(freq, response)
# [<matplotlib.lines.Line2D object at 0x...>]
plt.title("Frequency response of Bartlett window")
# <matplotlib.text.Text object at 0x...>
plt.ylabel("Magnitude [dB]")
# <matplotlib.text.Text object at 0x...>
plt.xlabel("Normalized frequency [cycles per sample]")
# <matplotlib.text.Text object at 0x...>
plt.axis('tight')
# (-0.5, 0.5, -100.0, ...)
plt.show()
