/* NVTV direct backend header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Header for direct access backend (common part for Linux and MS-Windows)
 */

#ifndef _BACK_DIRECT_H
#define _BACK_DIRECT_H

#include "local.h" 
#include "xfree.h"

#include "backend.h"
#include "tv_common.h"
#include "data.h"

/* back_direct methods */

extern BackAccessRec bdir_func;

void bdir_openCard (CardPtr card);
void bdir_closeCard (void);

#ifdef DEBUG_PROBE
void bdir_probeSystem (CardPtr card_list);
#endif

/* generic find routines */

int bdir_listModes (CardType card, DataFunc *data, 
  TVSystem system, TVMode *(list[]));

Bool bdir_findBySize (CardType card, DataFunc *data, 
  TVSystem system, int xres, int yres, char *size, TVMode *mode);

Bool bdir_findByOverscan (CardType card, DataFunc *data, TVSystem system, 
  int xres, int yres, double hoc, double voc, TVMode *mode);

/* additional helper methods */

extern ScrnInfoRec bdir_fakeScreen;

void bdir_freeChips (CardPtr chips);
ChipPtr bdir_copyChips (I2CChainPtr root);

#endif /* _BACK_DIRECT_H */

