/* NVTV null backend header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Header for null backend
 */

#ifndef _BACK_NULL_H
#define _BACK_NULL_H

#include "debug.h"
#include "backend.h"

CardPtr back_null_init (void);

/* back_null methods */

void bnull_openCard (CardPtr card);
void bnull_closeCard (void);
void bnull_setHeads (int main, int tv, int video);
void bnull_getHeads (int *main, int *tv, int *video, int *max);
void bnull_probeChips (void);
void bnull_setChip (ChipPtr chip, Bool init);
void bnull_setSettings (TVSettings *set);
void bnull_getSettings (TVSettings *set);
void bnull_setMode (TVRegs *r);
void bnull_getMode (TVRegs *r);
void bnull_setModeSettings (TVRegs *r, TVSettings *set);
void bnull_setTestImage (TVEncoderRegs *tv, TVSettings *set);
long bnull_getStatus (int index);
TVConnect bnull_getConnection (void);
Bool bnull_findBySize (TVSystem system, int xres, int yres, char *size, 
    TVMode *mode);
Bool bnull_findByOverscan (TVSystem system, int xres, int yres, 
    double hoc, double voc, TVMode *mode);

void bnull_initSharedView (int *view_x, int *view_y); 
Bool bnull_getTwinView (int *view_x, int *view_y);
Bool bnull_adjustViewport (int flags, int *view_x, int *view_y);
Bool bnull_serviceViewportCursor (int flags, int cursor_x, int cursor_y, 
  int *view_x, int *view_y);

#ifdef DEBUG_PROBE
void bnull_probeSystem (CardPtr card_list);
void bnull_probeCard (void);
I2CChainPtr bnull_probeBus (void);
#endif

#endif /* _BACK_NULL_H */

