/* NVTV 3dfx backend header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Header: Backend for 3dfx (Voodoo 3) cards, direct access.
 *
 */

#ifndef _BACK_TDFX_H
#define _BACK_TDFX_H

#include "backend.h"

extern BackCardRec btdfx_func;

void btdfx_openCard (CardPtr card);
void btdfx_closeCard (void);
void btdfx_setHeads (int main, int tv, int video);
void btdfx_getHeads (int *main, int *tv, int *video, int *max);
void btdfx_probeChips (void);
void btdfx_setChip (ChipPtr chip, Bool init);
void btdfx_setSettings (TVSettings *set);
void btdfx_getSettings (TVSettings *set);
void btdfx_setMode (TVRegs *r);
void btdfx_getMode (TVRegs *r);
void btdfx_setModeSettings (TVRegs *r, TVSettings *set);
void btdfx_setTestImage (TVEncoderRegs *tv, TVSettings *set);
long btdfx_getStatus (int index);
TVConnect btdfx_getConnection (void);
Bool btdfx_findBySize (TVSystem system, int xres, int yres, char *size, 
    TVMode *mode);
Bool btdfx_findByOverscan (TVSystem system, int xres, int yres, 
    double hoc, double voc, TVMode *mode);

#endif /* _BACK_TDFX_H */
