/* NVTV data header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 */ 

#ifndef _DATA_H
#define _DATA_H

#include "tv_chip.h"

/* init and setup must use a copy of the values from the database,
   otherwise the database will change. */

typedef struct {
  TVMode* (*modes) (void);
  void (*defaults) (TVSettings *s);
  void (*setup) (TVSettings *s, TVRegs *r);
  void (*clamp) (TVSettings *s, TVRegs *r);
  void (*calc) (TVSystem system, int hres, int vres, double hoc, double voc, 
		TVRegs *r);
} DataFunc;

typedef void (*make_vidmode) (int hdisplay, int hsyncstart, int hsyncend, 
  int htotal, int vdisplay, int vsyncstart, int vsyncend, int vtotal, 
  int dotclock, TVCrtcRegs *crt);

typedef struct {
  make_vidmode make;
} DataCardFunc;

int data_clamp (int val, int size, int ticks[]);
int data_pick (int val, int size, int ticks[]);

TVMode *data_find (TVMode *modes, TVSystem system, 
  int res_x, int res_y, char *size);

TVMode *data_findNearest (TVMode *modes, TVSystem system, 
  int res_x, int res_y, double hoc, double voc);

int data_listModes (TVMode *modes, TVSystem system, TVMode *(list[]));

void data_calc_null (TVSystem system, int hres, int vres, 
   double hoc, double voc, TVRegs *r);

DataFunc *data_func (CardType card, TVChip chip);
DataCardFunc *data_card_func (CardType card);

extern DataFunc null_func;

#endif /* _DATA_H */
