/* NVTV Brooktree chip data header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Header: Data tables and setup routines for the Brooktree chip.
 */ 

#ifndef _DATA_BT_H
#define _DATA_BT_H

#include "tv_chip.h"
#include "data.h"

void data_init_bt (TVSystem system, TVBtRegs *r);
void data_default_bt (TVSettings *s);
void data_clamp_bt (TVSettings *s, TVRegs *r);
void data_setup_bt (TVSettings *s, TVRegs *r);

void data_init_nomux_bt (TVSystem system, TVBtRegs *r);
void data_setup_nomux_bt (TVSettings *s, TVRegs *r);

void data_mux_nv_bt (TVBtRegs *r);
void data_mux_tdfx_bt (TVBtRegs *r);

void data_ntsc_palm_bt (TVBtRegs *r);

extern TVBtRegs bt_ntsc_small_a;    /* 13.79  x 13.58  (std 0)  */
extern TVBtRegs bt_ntsc_normal_a;   /* 10.59  x 08.23           */
extern TVBtRegs bt_ntsc_huge_a;     /* 02.46  x 01.23           */
extern TVBtRegs bt_ntsc_small_b;    /* 21.62  x 11.52  (std 2)  */
extern TVBtRegs bt_ntsc_normal_b;   /* 11.90  x 05.35           */
extern TVBtRegs bt_ntsc_huge_b;     /* 07.15  x 00.004          */
extern TVBtRegs bt_ntsc_normal_c;   /* 08.762 x 18.107          */
extern TVBtRegs bt_ntsc_dvd_a;      /* 01.245 x 01.235          */
extern TVBtRegs bt_ntsc_dvd_b;      /* 02.135 x 01.235          */

extern TVBtRegs bt_pal_small_a;     /* 16.56  x 16.67  (std 1)  */
extern TVBtRegs bt_pal_normal_a;    /* 12.87  x 07.64           */
extern TVBtRegs bt_pal_huge_a;      /* 06.22  x 00.69           */
extern TVBtRegs bt_pal_small_b;     /* 14.53  x 13.19  (std 3)  */
extern TVBtRegs bt_pal_normal_b;    /* 10.81  x 05.56           */
extern TVBtRegs bt_pal_large_b;     /* 07.461 x 02.083          */
extern TVBtRegs bt_pal_huge_b;      /* 00.039 x 00.00  (direct) */
extern TVBtRegs bt_pal_small_c;     /* 13.122 x 07.986          */
extern TVBtRegs bt_pal_normal_c;    /* 09.806 x 04.514          */
extern TVBtRegs bt_pal_huge_c;      /* 00.000 x 00.000          */
extern TVBtRegs bt_pal_normal_d;    /* 08.83  x 07.29           */
extern TVBtRegs bt_pal_dvd_a;       /* 00.21  x 00.00           */

extern TVBtRegs bt_pal60_small_a;   /* 16.758 x 14.815 */
extern TVBtRegs bt_pal60_normal_a;  /* 10.592 x 08.230 */
extern TVBtRegs bt_pal60_huge_a;    /* 01.469 x 01.235 */
extern TVBtRegs bt_pal60_small_b;   /* 21.623 x 11.523 */
extern TVBtRegs bt_pal60_normal_b;  /* 11.897 x 05.350 */
extern TVBtRegs bt_pal60_huge_b;    /* 07.862 x 00.823 */
extern TVBtRegs bt_pal60_dvd_a;     /* 01.245 x 01.235 */

extern TVBtRegs bt_async_pal_small_a;     /* 16.56  x 16.67  (std 1)  */

#endif /* _DATA_BT_H */
