/* NVTV Chrontel chip data header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Header: Data tables and setup routines for the Chrontel chip.
 */ 

#ifndef _DATA_CH_H
#define _DATA_CH_H

#include "tv_chip.h"
#include "data.h"

void data_init_ch (TVSystem system, TVChRegs *r);
void data_default_ch (TVSettings *s);
void data_clamp_ch (TVSettings *s, TVRegs *r);
void data_setup_ch (TVSettings *s, TVRegs *r);

extern TVChRegs ch_ntsc_large_a;     /* Mode 16: 640x480 1:1  */
extern TVChRegs ch_ntsc_small_a;     /* Mode 17: 640x480 7:8  */
extern TVChRegs ch_ntsc_tiny_a;      /* Mode 18: 640x480 5:6  */
extern TVChRegs ch_ntsc_huge_b;      /* Mode 22: 800x600 5:6  */
extern TVChRegs ch_ntsc_large_b;     /* Mode 23: 800x600 3:4  */
extern TVChRegs ch_ntsc_small_b;     /* Mode 24: 800x600 7:10 */
extern TVChRegs ch_ntsc_large_c;     /* Mode 10: 640x400 5:4  */
extern TVChRegs ch_ntsc_small_c;     /* Mode 11: 640x400 1:1  */
extern TVChRegs ch_ntsc_tiny_c;      /* Mode 12: 640x400 7:8  */
extern TVChRegs ch_ntsc_large_d;     /* Mode  6: 720x400 5:4  */
extern TVChRegs ch_ntsc_small_d;     /* Mode  7: 720x400 1:1  */
extern TVChRegs ch_ntsc_large_e;     /* Mode  2: 512x384 5:4  */
extern TVChRegs ch_ntsc_small_e;     /* Mode  3: 512x384 1:1  */
extern TVChRegs ch_ntsc_large_f;     /* Mode 23: 800x600 3:4  */
extern TVChRegs ch_ntsc_large_g;     /* Mode 23: 800x600 3:4  */
extern TVChRegs ch_ntsc_interl_dvd;  /* Mode 26: 720x480 IL   */

extern unsigned long ch_fsci_ntsc_large_a [];
extern unsigned long ch_fsci_ntsc_small_a [];
extern unsigned long ch_fsci_ntsc_tiny_a  [];
extern unsigned long ch_fsci_ntsc_huge_b  [];
extern unsigned long ch_fsci_ntsc_large_b [];
extern unsigned long ch_fsci_ntsc_small_b [];
extern unsigned long ch_fsci_ntsc_large_c [];
extern unsigned long ch_fsci_ntsc_small_c [];
extern unsigned long ch_fsci_ntsc_tiny_c  [];
extern unsigned long ch_fsci_ntsc_large_d [];
extern unsigned long ch_fsci_ntsc_small_d [];
extern unsigned long ch_fsci_ntsc_large_e [];
extern unsigned long ch_fsci_ntsc_small_e [];

extern TVChRegs ch_pal_large_a;    /* Mode 13: 640x480 5:4  */
extern TVChRegs ch_pal_small_a;    /* Mode 14: 640x480 1:1  */
extern TVChRegs ch_pal_tiny_a;     /* Mode 15: 640x480 5:6  */
extern TVChRegs ch_pal_large_b;    /* Mode 19: 800x600 1:1  */
extern TVChRegs ch_pal_small_b;    /* Mode 20: 800x600 5:6  */
extern TVChRegs ch_pal_tiny_b;     /* Mode 21: 800x600 3:4  */
extern TVChRegs ch_pal_small_c;    /* Mode  8: 640x400 5:4  */
extern TVChRegs ch_pal_tiny_c;     /* Mode  9: 640x400 1:1  */
extern TVChRegs ch_pal_small_d;    /* Mode  4: 720x400 5:4  */
extern TVChRegs ch_pal_tiny_d;     /* Mode  5: 720x400 1:1  */
extern TVChRegs ch_pal_small_e;    /* Mode  0: 512x384 5:4  */
extern TVChRegs ch_pal_tiny_e;     /* Mode  1: 512x384 1:1  */
extern TVChRegs ch_pal_large_f;    /* Mode 19: 800x600 1:1  */
extern TVChRegs ch_pal_large_g;    /* Mode 19: 800x600 1:1  */
extern TVChRegs ch_pal_small_f;    /* Mode 20: 800x600 5:6  */
extern TVChRegs ch_pal_small_g;    /* Mode 20: 800x600 5:6  */
extern TVChRegs ch_pal_interl_dvd; /* Mode 25: 720x576 IL   */

extern unsigned long ch_fsci_pal_large_a [];
extern unsigned long ch_fsci_pal_small_a [];
extern unsigned long ch_fsci_pal_tiny_a  [];
extern unsigned long ch_fsci_pal_large_b [];
extern unsigned long ch_fsci_pal_small_b [];
extern unsigned long ch_fsci_pal_tiny_b  [];
extern unsigned long ch_fsci_pal_small_c [];
extern unsigned long ch_fsci_pal_tiny_c  [];
extern unsigned long ch_fsci_pal_small_d [];
extern unsigned long ch_fsci_pal_tiny_d  [];
extern unsigned long ch_fsci_pal_small_e [];
extern unsigned long ch_fsci_pal_tiny_e  [];

#endif /* _DATA_CH_H */
